define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-79083DA0-4E6B-48CB-B296-00FC58BE60D7"
                },
                {
                    "title":"Changes in This Release for Oracle Universal Connection Pool Developer's Guide",
                    "href":"changes-this-release-oracle-universal-connection-pool-developers-guide.html#GUID-97199BCC-A97C-40D6-A1D0-0B841BE5CF5B"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to UCP",
                    "href":"intro.html#GUID-82ACD002-4C5F-4BF7-99FF-46A2A97DD35D"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Getting Started",
                    "href":"get-started.html#GUID-7438ABC8-6AC0-437E-9D19-60D60E73E9C6"
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Getting Database Connections in UCP",
                    "href":"getting-database-connections.html#GUID-5E13DF84-005B-41D3-99C6-7E3120EB3C93",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> About Borrowing Connections from UCP",
                            "href":"borrowing-ucp-connections.html#GUID-2AB7C67B-E634-4EBD-9383-7086FD672617"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Setting Connection Pool Properties for UCP",
                            "href":"setting-ucp-properties.html#GUID-8FA8829A-80E8-43A4-B241-C3E7E80FEEDE"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Overview of Validating Connections in UCP",
                            "href":"validating-ucp-connections.html#GUID-A7C850D6-4026-4629-BCFA-9181C29EFBF9"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Returning Borrowed Connections to UCP",
                            "href":"returning-borrowed-connections.html#GUID-FC52575A-B60E-4528-8AD6-B50E923C8E7E"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Removing Connections from UCP",
                            "href":"removing-connections.html#GUID-C49B5866-005C-493B-BD0A-139E67AE1A74"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> UCP Integration with Third-Party Products",
                            "href":"third-party-integration.html#GUID-389CABB3-2890-42F6-8EEF-F8779AF90ECA"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Connection Creation Consumer",
                    "href":"connection-creation-consumer.html#GUID-0D68FD82-0412-4F82-99CF-C19E5AA2C444"
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Optimizing Universal Connection Pool Behavior",
                    "href":"optimizing-ucp-behavior.html#GUID-FFCAB66D-45B3-4D7B-991B-40F1480630FD",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Optimizing Connection Pools",
                            "href":"optimizing-connection-pools.html#GUID-B889EA72-103B-4AE4-AED8-D98FCCCA7E01"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> About Controlling the Pool Size in UCP",
                            "href":"controlling-pool-size.html#GUID-1909EBD1-E526-4385-9A2A-39C89F985A14"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Real-World Performance Considerations with Respect to Connection Pool Sizes",
                            "href":"optimizing-real-world-performance.html#GUID-BC09F045-5D80-4AF5-93F5-FEF0531E0E1D"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Stale Connections in UCP",
                            "href":"stale-ucp-connections.html#GUID-B441E4C1-D944-4F04-9A63-1E4F811A2474"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> About Harvesting Connections in UCP",
                            "href":"harvesting-connections.html#GUID-1639B871-C332-4F30-8EE0-F753FF07BFB7"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> About Caching SQL Statements in UCP",
                            "href":"caching-sql-statements.html#GUID-D3E63627-6FA4-455B-AC0F-C6CF538AA3D4"
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> UCP Best Practices",
                            "href":"UCP-best-practices.html#GUID-619C7C59-10F8-4035-A21B-DEAA826CD323"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Labeling Connections in UCP",
                    "href":"labeling-ucp-connections.html#GUID-FF477DDE-FAE6-4E42-9B45-C3003CDB0DDF",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Overview of Labeling Connections in UCP",
                            "href":"overview-labeling-ucp-connections.html#GUID-566DB81D-1930-4B98-A7DC-E2DADF9B9C6D"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Implementation of a Labeling Callback in UCP",
                            "href":"implementing-labeling-ucp-connections.html#GUID-47A8BF36-AA20-4FBE-948A-C72722524436"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Integration of UCP with DRCP",
                            "href":"ucp-drcp-integration.html#GUID-54A8CF56-1FBD-4F4B-BE7E-CB169E9435F1"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Applying Connection Labels in UCP",
                            "href":"applying-connection-labels.html#GUID-00D7FD1B-DD59-4AD0-8FC5-86BC4B79793B"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Borrowing Labeled Connections from UCP",
                            "href":"borrowing-labeled-connections.html#GUID-D5675784-7FCD-43B7-9973-7EA4A930A955"
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> Checking Unmatched Labels in UCP",
                            "href":"checking-unmatched-labels.html#GUID-C806ECE8-335D-4BBB-984F-04404CC99526"
                        },
                        {
                            "title":"<span class=\"secnum\">6.7 </span> Removing a Connection Label in UCP",
                            "href":"removing-connection-labels.html#GUID-070C5A60-4A2C-4BC8-93DC-CEDF24CC389A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Controlling Reclaimable Connection Behavior",
                    "href":"controlling-reclaimable-connection-behavior.html#GUID-B13613CF-F472-43BD-8ED0-4561C1449C14"
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Using the Connection Pool Manager",
                    "href":"using-ucp-manager.html#GUID-14734102-0179-47A6-9484-4F75B01D765F",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Overview of Using the UCP Manager",
                            "href":"overview-using-ucp-manager.html#GUID-8932E6BA-EF64-442D-9E43-4FC6B7046E11"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Overview of JMX-Based Management in UCP",
                            "href":"jmx-based-management.html#GUID-1D9CA0B0-80EC-47EB-863D-715E8B50A2B6"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Shared Pool Support for Multitenant Data Sources",
                    "href":"shared-pool-for-multitenant-data-sources.html#GUID-7C397AA8-9C78-4DB0-AAF4-15BBF9AFFB85"
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Using Oracle RAC Features",
                    "href":"using-Oracle-RAC-features.html#GUID-A0B5E9FF-84E1-40FC-8B2E-084C1134FDFD",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Overview of Oracle RAC Features",
                            "href":"overview-Oracle-RAC-features.html#GUID-DA4D43E9-1656-4101-8868-DAA2BB9B34D4"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> About Fast Connection Failover",
                            "href":"fast-connection-failover.html#GUID-126F8C9B-C0B3-426B-B07D-4B127BBDD867"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> About Run-Time Connection Load Balancing",
                            "href":"run-time-connection-load-balancing.html#GUID-305FD568-95F5-458C-8B52-5A81FA62999C"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> About Connection Affinity",
                            "href":"connection-affinity.html#GUID-7F9764AD-2F53-4BAF-9E7E-0671C8936C1F"
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Global Data Services",
                            "href":"global-data-services.html#GUID-97370C21-B4E5-4533-A66D-C6C1B3C15BCD"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> UCP Asynchronous Extension",
                    "href":"UCP-asynchronous-extensions.html#GUID-710718EB-BEED-4A88-B532-C1AC166E4FDE"
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Ensuring Application Continuity",
                    "href":"application-continuity-using-ucp.html#GUID-E087EE2A-5429-4B64-9BC5-B540B2BBC36A"
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Shared Pool for Sharded Databases",
                    "href":"ucp-database-sharding-support.html#GUID-12685D3A-F083-433A-90DF-C5533009B841",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Overview of UCP Shared Pool for Database Sharding",
                            "href":"ucp-database-sharding-overview.html#GUID-A5722833-CFD6-4557-B983-88B5C657A74B"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> About Handling Connection Requests for a Sharded Database",
                            "href":"sharded-database-connection-request.html#GUID-A0371FC7-5644-4AC7-AEFE-37BE974D6616"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> Sharding Data Source for Transparent Access to Sharded Databases",
                            "href":"sharding-driver-for-transparent-access.html#GUID-C82EEEA3-B027-42D9-BA1D-750CE2B53F17"
                        },
                        {
                            "title":"<span class=\"secnum\">13.4 </span> Middle-Tier Routing Using UCP",
                            "href":"middle-tier-routing-using-ucp.html#GUID-6B3483EE-6E38-4B76-AAAC-0192E5827C3A"
                        },
                        {
                            "title":"<span class=\"secnum\">13.5 </span> Sharding with JTA/XA Transaction in WebLogic Server",
                            "href":"sharding-with-JTA-XA-transaction-in-WebLogic-Server.html#GUID-BA0CB872-66E5-4693-87D2-C438C6572BBC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Diagnosing a Connection Pool",
                    "href":"diagnosing-ucp.html#GUID-ED0408D9-D3D6-44DA-91EE-5991C0EA8CAD",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Pool Statistics",
                            "href":"pool-statistics.html#GUID-E9E1CC73-F1D6-4A0E-9449-07106BC14EED"
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Dynamic Monitoring Service Metrics",
                            "href":"dynamic-monitoring-service-metrics.html#GUID-47E4F8B3-9336-464D-8783-61DEB632B040"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> Overview of Logging and Tracing in UCP",
                            "href":"logging-and-tracing-in-UCP.html#GUID-F2C85A4C-31F1-46C0-9003-3F17C633EEC7"
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> About Viewing Oracle RAC Statistics",
                            "href":"viewing-Oracle-RAC-statistics.html#GUID-6ED3F083-8838-4EB2-B1F7-30D381D9BCE2"
                        },
                        {
                            "title":"<span class=\"secnum\">14.5 </span> Exceptions and Error Codes",
                            "href":"exceptions-error-codes.html#GUID-1823BA23-9571-4579-AD0C-6AF3A4644D44"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Error Codes Reference",
                    "href":"error-codes-reference.html#GUID-13577739-E376-4B27-8DD7-7CCA993239B1"
                },
                {
                    "title":"<span class=\"secnum\">B </span> UCP Exception Error Codes",
                    "href":"UCP-exceptions-and-error-codes.html#GUID-D28A9F34-77F8-4E2C-84E4-B1B41E2FD79A"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});