define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-071A6B76-11E3-4421-963E-41DA6F2EF07A"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Oracle AI Database Installation Checklist",
                    "href":"oracle-database-installation-checklist.html#GUID-E847221C-1406-4B6D-8666-479DB6BDB046",
                    "topics":[
                        {
                            "title":"Server Hardware Checklist for Oracle AI Database Installation",
                            "href":"server-hardware-checklist-for-oracle-database-installation.html#GUID-D311E770-9444-45D0-A122-6491D1B66B8A"
                        },
                        {
                            "title":"Operating System Checklist for Oracle AI Database Installation on Linux",
                            "href":"operating-system-checklist-for-oracle-database-installation-on-linux.html#GUID-E5C0A90E-7750-45D9-A8BC-C7319ED934F0"
                        },
                        {
                            "title":"Server Configuration Checklist for Oracle AI Database Installation",
                            "href":"server-configuration-checklist-for-oracle-database-installation.html#GUID-CD4657FB-2DDC-4B30-AAB4-2C927045A86D"
                        },
                        {
                            "title":"Oracle User Environment Configuration Checklist for Oracle AI Database Installation",
                            "href":"oracle-user-environment-configuration-checklist-for-oracle-database-installation.html#GUID-9CCDF3FA-ED8C-44C2-A137-EC498CD3D4EA"
                        },
                        {
                            "title":"Storage Checklist for Oracle AI Database Installation",
                            "href":"storage-checklist-for-oracle-database-installation.html#GUID-C6184DFA-45A2-4420-99D6-237EA5BAB058"
                        },
                        {
                            "title":"Installer Planning Checklist for Oracle AI Database",
                            "href":"installer-planning-checklist-for-oracle-database-installation.html#GUID-27030ED5-5803-4AA7-B761-1FAE300B9FF2"
                        },
                        {
                            "title":"Deployment Checklist for Oracle AI Database",
                            "href":"deployment-checklist-for-oracle-database.html#GUID-EE6DD02E-DD1B-42BE-BAE5-25F54974719F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Checking and Configuring the Server for Oracle AI Database",
                    "href":"checking-and-configuring-server-hardware-for-oracle-database.html#GUID-485CDC0E-1CB4-4F8A-B8D1-83F3BECA3F13",
                    "topics":[
                        {
                            "title":"Logging In to a Remote System Using X Window System",
                            "href":"logging-in-to-a-remote-system-using-x-window-system.html#GUID-6503D6FD-F784-4115-86D1-B9C78B3C1B92"
                        },
                        {
                            "title":"Setting Remote Display and X11 Forwarding Configuration",
                            "href":"setting-remote-display-and-x11-forwarding-configuration.html#GUID-D524603D-F3F9-4BDA-A374-CAC20EA6D5C6"
                        },
                        {
                            "title":"Checking Server Hardware and Memory Configuration",
                            "href":"checking-server-hardware-and-memory-configuration.html#GUID-DC04ABB6-1822-444A-AB1B-8C306079439C"
                        },
                        {
                            "title":"Preventing Installation Errors Caused by Terminal Output Commands",
                            "href":"preventing-installation-errors-caused-by-terminal-output-commands.html#GUID-D394E4D3-E08E-4694-BE81-1D47FE539F4B"
                        },
                        {
                            "title":"About Installing Oracle AI Database Software on Oracle Exadata Database Machine",
                            "href":"db-on-exadata.html#GUID-00EA1FFC-8727-4FF2-B56B-56647F88DF73"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Automatically Configuring Oracle Linux with Oracle AI Database Preinstallation RPM",
                    "href":"automatically-configuring-oracle-linux-with-oracle-preinstallation-rpm.html#GUID-22846194-58EF-4552-AAC3-6F6D0A1DF794",
                    "topics":[
                        {
                            "title":"About the Oracle AI Database Preinstallation RPM",
                            "href":"about-the-oracle-preinstallation-rpm.html#GUID-C15A642B-534D-4E4A-BDE8-6DC7772AA9C8"
                        },
                        {
                            "title":"Overview of Oracle Linux Configuration with Oracle AI Database Preinstallation RPM",
                            "href":"overview-of-oracle-linux-configuration-with-oracle-rpms.html#GUID-693599D4-BD32-4E6A-9689-FA7D1CD75653"
                        },
                        {
                            "title":"Installing the Oracle AI Database Preinstallation RPM Using ULN",
                            "href":"installing-the-oracle-preinstallation-rpm-with-uln-support.html#GUID-AF94713E-97AF-4F20-8DBC-36BC383D0301"
                        },
                        {
                            "title":"Installing Oracle AI Database Preinstallation RPM During an Oracle Linux Installation",
                            "href":"installing-a-new-oracle-linux-installation-from-dvds-or-images.html#GUID-A686DF5E-8F3D-4697-88F5-DFA4C2B7DB07"
                        },
                        {
                            "title":"Installing Oracle Oracle AI Database Preinstallation RPM Using the Oracle Linux yum Server",
                            "href":"installing-oracle-linux-with-public-yum-repository-support.html#GUID-190BAEE2-2B77-4AA2-AA6B-5D6AF73A4005"
                        },
                        {
                            "title":"Configure Additional Operating System Features",
                            "href":"configure-additional-operating-system-features.html#GUID-65F1AAB7-4624-43C8-BAB2-6FABF05F05BE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Configuring Operating Systems for Oracle AI Database on Linux",
                    "href":"configuring-operating-systems-for-oracle-database-on-linux.html#GUID-563B2067-8E17-4846-A9E1-F7043E70B00E",
                    "topics":[
                        {
                            "title":"Guidelines for Linux Operating System Installation",
                            "href":"guidelines-for-linux-operating-system-installation.html#GUID-11991892-6B97-4283-B042-E894BBF9B3BF",
                            "topics":[
                                {
                                    "title":"Completing a Minimal or Default Linux Installation",
                                    "href":"about-minimal-linux-installations.html#GUID-59C92547-8AB3-4334-8D82-1B797A29D199"
                                },
                                {
                                    "title":"About Oracle Linux with the Unbreakable Enterprise Kernel",
                                    "href":"about-oracle-linux-and-the-unbreakable-enterprise-kernel.html#GUID-EC62F856-B9AA-4BC5-BC81-B41A5C6A24F5"
                                },
                                {
                                    "title":"Configuring HugePages on Linux",
                                    "href":"configuring_hugepages.html#GUID-19BFCC60-BA4C-4750-85EB-7432282A9556"
                                },
                                {
                                    "title":"Restrictions for HugePages and Transparent HugePages Configurations",
                                    "href":"restrictions-for-hugepages-and-transparent-hugepages-configurations.html#GUID-D8178896-D00F-4F02-82A7-A44F89D8F103"
                                }
                            ]
                        },
                        {
                            "title":"Reviewing Operating System Security Common Practices",
                            "href":"reviewing-operating-system-security-common-practices.html#GUID-D50A5D72-AC1A-47CE-A7AC-DAE22BA5912D"
                        },
                        {
                            "title":"About Installation Fixup Scripts",
                            "href":"about-installation-fixup-scripts.html#GUID-B427B3F7-BFE3-4ACF-89FD-A79A5774C7AA"
                        },
                        {
                            "title":"About Operating System Requirements",
                            "href":"about-operating-system-requirements.html#GUID-9758581C-6925-4A0E-B321-9E424575E7F2"
                        },
                        {
                            "title":"Operating System Requirements for x86-64 Linux Platforms",
                            "href":"operating-system-requirements-for-x86-64-linux-platforms.html#GUID-3F647617-7FF5-4EE4-BBA8-9A5E3EEC888F",
                            "topics":[
                                {
                                    "title":"General Guidelines for Operating System Packages",
                                    "href":"guidelines-for-os-packages.html#GUID-DC3C9BC6-2F5F-4EFA-AFD6-9D4F5FEFFB7D"
                                },
                                {
                                    "title":"Supported Oracle Linux 9 Distributions for x86-64",
                                    "href":"supported-oracle-linux-9-distributions-for-x86-64.html#GUID-C3D652E3-9593-4B4F-A63F-D20AB31C9EC8"
                                },
                                {
                                    "title":"Supported Oracle Linux 8 Distributions for x86-64",
                                    "href":"supported-oracle-linux-8-distributions-for-x86-64.html#GUID-F4902762-325B-4C89-B85B-F52BA482190F"
                                },
                                {
                                    "title":"Supported Red Hat Enterprise Linux 9 Distributions for x86-64",
                                    "href":"supported-red-hat-enterprise-linux-9-distributions-for-x86-64.html#GUID-088A9B4A-959F-47E1-8120-A00D464C9D13"
                                },
                                {
                                    "title":"Supported Red Hat Enterprise Linux 8 Distributions for x86-64",
                                    "href":"supported-red-hat-enterprise-linux-8-distributions-for-x86-64.html#GUID-B1487167-84F8-4F8D-AC31-A4E8F592374B"
                                },
                                {
                                    "title":"Supported SUSE Linux Enterprise Server 15 Distributions for x86-64",
                                    "href":"supported-suse-15-distributions-for-x86-64.html#GUID-58F12FC2-7F98-49F9-BDBB-A88AFD710B08"
                                },
                                {
                                    "title":"Installing Operating System Packages",
                                    "href":"installing-operating-system-packages.html#GUID-1AE7031F-AABD-4049-87DC-99112C9D82EE"
                                }
                            ]
                        },
                        {
                            "title":"Operating System Requirements for Linux for Arm (aarch64)",
                            "href":"operating-system-reqs-arm.html#GUID-7744E340-220A-4A6D-A70B-C412F7777437",
                            "topics":[
                                {
                                    "title":"Supported Oracle Linux 8 Distributions on Linux for Arm (aarch64)",
                                    "href":"oracle-linux-8-distributions-for-arm.html#GUID-9B526E96-2513-4B7D-A099-53FFB5E4505D"
                                }
                            ]
                        },
                        {
                            "title":"Additional Drivers and Software Packages for Linux",
                            "href":"additional-drivers-and-software-packages-for-linux.html#GUID-F09C1AE2-FEE2-42A6-BEEF-289251413841",
                            "topics":[
                                {
                                    "title":"Installing PAM for Login Authentication on Linux",
                                    "href":"installing-pam-for-login-authentication-on-linux.html#GUID-9C7ACF0E-44BB-4CBF-B426-E254E3A1EF82"
                                },
                                {
                                    "title":"Installing OCFS2",
                                    "href":"installing-ocfs2.html#GUID-D3BE83F2-3F7A-4D07-8BC5-127CA0C82550"
                                },
                                {
                                    "title":"Installing Oracle Messaging Gateway",
                                    "href":"installing-oracle-messaging-gateway.html#GUID-956E1E0A-52AE-475E-B01D-7FB12D80AFC1"
                                },
                                {
                                    "title":"Installation Requirements for ODBC and LDAP",
                                    "href":"installation-requirements-for-odbc-and-ldap.html#GUID-A87B2D38-6BCD-48F5-980B-B34CCEDE0545",
                                    "topics":[
                                        {
                                            "title":"About ODBC Drivers and Oracle AI Database",
                                            "href":"about-odbc-drivers-and-oracle-database.html#GUID-6A7E02AB-7DA5-4EF2-9A7C-94FF44570711"
                                        },
                                        {
                                            "title":"Installing ODBC Drivers for Linux x86-64",
                                            "href":"installing-odbc-drivers-for-linux-x86-64.html#GUID-494A764B-22A6-4DB4-AB45-AE4B467650D2"
                                        },
                                        {
                                            "title":"About LDAP and Oracle Plug-ins",
                                            "href":"about-ldap-and-oracle-plug-ins.html#GUID-01A4C3C8-7CDC-4CBC-A6B2-B7D2B19EF7E9"
                                        },
                                        {
                                            "title":"Installing the LDAP Package",
                                            "href":"installing-the-ldap-package.html#GUID-0756E362-8AFD-481A-B105-F65F02F3DBCD"
                                        }
                                    ]
                                },
                                {
                                    "title":"Installation Requirements for Programming Environments for Linux",
                                    "href":"installation-requirements-for-programming-environments-for-linux.html#GUID-2E32042E-15FE-4951-BD71-5C040ED87944",
                                    "topics":[
                                        {
                                            "title":"Installation Requirements for Programming Environments for Linux x86-64",
                                            "href":"installation-requirements-for-programming-environments-for-linux-x86-64.html#GUID-BFD716A4-6235-49F6-8259-A534E2D96A8D"
                                        }
                                    ]
                                },
                                {
                                    "title":"Installation Requirements for Web Browsers",
                                    "href":"installation-requirements-for-web-browsers.html#GUID-28DE4328-8EC8-4462-AC70-95DC07766F4E"
                                }
                            ]
                        },
                        {
                            "title":"Checking Kernel and Package Requirements for Linux",
                            "href":"checking-kernel-and-package-requirements-for-linux.html#GUID-7065A86D-C2AB-4731-953B-12AC25C94156"
                        },
                        {
                            "title":"Setting Clock Source for VMs on Linux x86-64",
                            "href":"setting-clock-source-vm.html#GUID-E55821AE-E001-4490-9545-DBAB652D896E"
                        },
                        {
                            "title":"Confirming Host Name Resolution",
                            "href":"confirming-host-name-resolution.html#GUID-B12E885F-CF2E-498A-A878-117082F237CC"
                        },
                        {
                            "title":"Setting Transparent HugePages to madvise",
                            "href":"disabling-transparent-hugepages.html#GUID-02E9147D-D565-4AF8-B12A-8E6E9F74BEEA"
                        },
                        {
                            "title":"Using Automatic SSH Configuration During Installation",
                            "href":"using-automatic-ssh-configuration-during-installation.html#GUID-51280BE9-4B2A-4BE3-9DA3-68B795D9FBA2"
                        },
                        {
                            "title":"Verifying the Disk I/O Scheduler on Linux 8 and Later Systems",
                            "href":"setting-the-disk-io-scheduler-on-linux.html#GUID-AB706834-3DEB-4278-8872-96961C7379A8"
                        },
                        {
                            "title":"Verifying Digital Signature and Integrity of Installation Archive Files",
                            "href":"verify-signature.html#GUID-1AA115AE-56E1-421A-82C3-7FF0E56C5B73"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Configuring Users, Groups and Environments for Oracle Grid Infrastructure and Oracle AI Database",
                    "href":"configuring-users-groups-and-environments-for-oracle-grid-infrastructure-and-oracle-database.html#GUID-B65E6113-D056-4DD9-940F-DFF493E413D5",
                    "topics":[
                        {
                            "title":"Required Operating System Groups and Users",
                            "href":"required-operating-system-groups-and-users.html#GUID-EBE883F8-5692-43C6-9CEB-2953C2E2837D",
                            "topics":[
                                {
                                    "title":"Determining If an Oracle Inventory and Oracle Inventory Group Exist",
                                    "href":"determining-if-an-oracle-inventory-and-oracle-inventory-group-exist.html#GUID-63920FC2-410E-437D-8897-FB40AD828AD4"
                                },
                                {
                                    "title":"Creating the Oracle Inventory Group If an Oracle Inventory Does Not Exist",
                                    "href":"creating-the-oracle-inventory-group-if-an-oracle-inventory-does-not-exist.html#GUID-D2F89B6F-2B5D-4B70-8523-BCAF71865271"
                                },
                                {
                                    "title":"About Oracle Installation Owner Accounts",
                                    "href":"about-oracle-installation-owner-accounts.html#GUID-39A48A63-E41F-4034-8C54-08D8E11A4F4C"
                                },
                                {
                                    "title":"Identifying an Oracle Software Owner User Account",
                                    "href":"identifying-an-oracle-software-owner-user-account.html#GUID-0A95F4B1-1045-455D-9897-A23012E4E27F"
                                }
                            ]
                        },
                        {
                            "title":"Oracle Installations with Standard and Job Role Separation Groups and Users",
                            "href":"oracle-installations-with-standard-and-job-role-separation-groups-and-users.html#GUID-67A7AC8E-1736-4D53-A529-EB96FCDBA516",
                            "topics":[
                                {
                                    "title":"About Oracle Installations with Job Role Separation",
                                    "href":"about-oracle-installations-with-job-role-separation.html#GUID-E5EA50C5-8187-4B63-ACF2-88EBF414AF08"
                                },
                                {
                                    "title":"Standard Oracle AI Database Groups for Database Administrators",
                                    "href":"standard-oracle-database-groups-for-database-administrators.html#GUID-0A789F28-169A-43D6-9E48-AAE20D7B0C44"
                                },
                                {
                                    "title":"Extended Oracle AI Database Groups for Job Role Separation",
                                    "href":"extended-oracle-database-groups-for-job-role-separation.html#GUID-4F9A7AE7-BB13-4D87-A372-22CE5CE4DE60"
                                },
                                {
                                    "title":"Creating an ASMSNMP User",
                                    "href":"creating-an-asmsnmp-user.html#GUID-42F96652-F891-49C4-AE48-BA18078D5909"
                                },
                                {
                                    "title":"Oracle Automatic Storage Management Groups for Job Role Separation",
                                    "href":"oracle-automatic-storage-management-groups-for-job-role-separation.html#GUID-FBCCD803-1675-4D4B-90E5-7D1085D57576"
                                }
                            ]
                        },
                        {
                            "title":"Creating Operating System Privileges Groups",
                            "href":"creating-operating-system-privileges-groups.html#GUID-164A7218-166D-4B58-9A86-88149E8FCB83"
                        },
                        {
                            "title":"Creating Operating System Oracle Installation User Accounts",
                            "href":"creating-operating-system-oracle-installation-user-accounts.html#GUID-4DA71FFA-AB5B-49AA-B21D-92C952C8A3FC",
                            "topics":[
                                {
                                    "title":"Creating an Oracle Software Owner User",
                                    "href":"creating-an-oracle-software-owner-user.html#GUID-C1E5CEA8-741A-4500-B03E-B4A6BC1E87BB"
                                },
                                {
                                    "title":"Environment Requirements for Oracle Software Owners",
                                    "href":"environment-requirements-for-oracle-software-owners.html#GUID-C08E7530-3733-4096-9E31-99CFE922E8AA"
                                },
                                {
                                    "title":"Procedure for Configuring Oracle Software Owner Environments",
                                    "href":"procedure-for-configuring-oracle-software-owner-environments.html#GUID-9390F139-EA37-4C57-BF1F-E1991ACE528E"
                                },
                                {
                                    "title":"Modifying Oracle Owner User Groups",
                                    "href":"modifying-oracle-owner-user-groups.html#GUID-2DD4A4F8-4A87-4188-BA08-35095373FA72"
                                },
                                {
                                    "title":"Checking Resource Limits for Oracle Software Installation Users",
                                    "href":"checking-resource-limits-for-oracle-software-installation-users.html#GUID-293874BD-8069-470F-BEBF-A77C06618D5A"
                                }
                            ]
                        },
                        {
                            "title":"Creating Oracle Database Vault User Accounts",
                            "href":"creating-oracle-database-vault-user-accounts.html#GUID-4FDAAD6D-4C2E-4991-98EC-79EA13759A6E"
                        },
                        {
                            "title":"Unsetting Oracle Installation Owner Environment Variables",
                            "href":"unsetting-oracle-installation-owner-environment-variables.html#GUID-A2D16A20-0F7A-4323-9736-7CF71A52F0A4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Configuring Networks for Oracle AI Database",
                    "href":"configuring-networks-for-oracle-database.html#GUID-27FD2A4E-25D0-41A5-BE76-CF73480F401E",
                    "topics":[
                        {
                            "title":"About Oracle AI Database Network Configuration Options",
                            "href":"about-oracle-database-network-configuration-options.html#GUID-4C3F170A-36F6-4AC3-82F0-8CCF6FBC8ACC"
                        },
                        {
                            "title":"About Assigning Global Database Names During Installation",
                            "href":"about-assigning-global-database-names-during-installation.html#GUID-1AC9E18F-0AE4-4263-B3CC-A83B859A178F"
                        },
                        {
                            "title":"Network Configuration for Computers Completed After Installation",
                            "href":"network-configuration-for-computers-completed-after-installation.html#GUID-89D0E8CD-0B4E-47FA-BF30-E4D05D675872"
                        },
                        {
                            "title":"Network Configuration for Multihome Computers",
                            "href":"network-configuration-for-multihome-computers.html#GUID-6921AF22-5FC3-4BB7-809D-358E2A54B688"
                        },
                        {
                            "title":"Setting the ORACLE_HOSTNAME Environment Variable",
                            "href":"setting-the-oracle_hostname-environment-variable.html#GUID-27DFE5F2-8AAE-4085-8A63-CC6C94F73AA0"
                        },
                        {
                            "title":"Network Configuration for Computers with Multiple Aliases",
                            "href":"network-configuration-for-computers-with-multiple-aliases.html#GUID-0AADF1E8-333D-48AD-A601-2727B15497A4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Supported Storage Options for Oracle AI Database and Oracle Grid Infrastructure",
                    "href":"supported-storage-options-for-oracle-database-and-oracle-grid-infrastructure.html#GUID-D5A3B718-FB00-420F-BE8B-FA111B1482E6",
                    "topics":[
                        {
                            "title":"Supported Storage Options for Oracle AI Database",
                            "href":"supported-storage-options-for-oracle-database.html#GUID-120C3995-F827-4D01-B955-CB1BD0457AF7"
                        },
                        {
                            "title":"About Oracle Grid Infrastructure for a Standalone Server",
                            "href":"about-oracle-grid-infrastructure-for-a-standlone-server.html#GUID-D13A1F20-F513-4448-808C-A19AFCDAE135"
                        },
                        {
                            "title":"Oracle ACFS and Oracle ADVM",
                            "href":"oracle-acfs-and-oracle-advm.html#GUID-63DAB520-38DD-4D62-A241-433270FE8755",
                            "topics":[
                                {
                                    "title":"Oracle ACFS and Oracle ADVM Support on Linux x86–64",
                                    "href":"oracle-acfs-and-oracle-advm-support-on-linux.html#GUID-4290DF00-C4DB-40AE-85D3-97C4F29994A6"
                                },
                                {
                                    "title":"Restrictions and Guidelines for Oracle ACFS",
                                    "href":"restrictions-and-guidelines-for-oracle-acfs.html#GUID-C16763D5-F309-488A-8281-1E062242822A"
                                }
                            ]
                        },
                        {
                            "title":"File System Options for Oracle AI Database",
                            "href":"file-system-options-for-oracle-database.html#GUID-B4280399-263C-43A1-A944-0D47337FA711"
                        },
                        {
                            "title":"Guidelines for Placing Oracle AI Database Files On a File System or Logical Volume",
                            "href":"guidelines-for-placing-oracle-database-files-on-a-file-system-or-logical-volume.html#GUID-44D1D3EE-AFF8-434C-B0F3-1CD840FF8177"
                        },
                        {
                            "title":"About NFS Storage for Data Files",
                            "href":"about-nfs-storage-for-data-files.html#GUID-CF1F1C17-0548-4DE5-A5BD-7E3752ECF101"
                        },
                        {
                            "title":"About Direct NFS Client Mounts to NFS Storage Devices",
                            "href":"about-direct-nfs-client-mounts-to-nfs-storage-devices.html#GUID-31591084-74BD-4B66-8C5B-68BF0FEE8750"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Configuring File System Storage for Oracle AI Database",
                    "href":"configuring-file-system-storage-for-oracle-database.html#GUID-9BC5A6E7-155E-41A2-B06E-ACBE91F9F99A",
                    "topics":[
                        {
                            "title":"Deploying Oracle Direct NFS",
                            "href":"deploying_dnfs.html#GUID-D06079DB-8C71-4F68-A1E3-A75D7D96DCE2",
                            "topics":[
                                {
                                    "title":"Configuring NFS Buffer Size Parameters for Oracle AI Database",
                                    "href":"configuring-nfs-buffer-size-parameters-for-oracle-database.html#GUID-5F14F816-445B-4EBB-BBA2-E9DFD7E5EF96"
                                },
                                {
                                    "title":"Checking TCP Network Protocol Buffer for Direct NFS Client",
                                    "href":"checking-tcp-network-protocol-buffer-for-direct-nfs-client.html#GUID-EEE6EF7D-2532-486E-B1D8-192F6E877492"
                                },
                                {
                                    "title":"Creating an oranfstab File for Direct NFS Client",
                                    "href":"creating-an-oranfstab-file-for-direct-nfs-client.html#GUID-C16A1AF8-CCC5-46C2-875E-4276C2CCCF22"
                                },
                                {
                                    "title":"Enabling and Disabling Direct NFS Client Control of NFS",
                                    "href":"enabling-and-disabling-direct-nfs-client-control-of-nfs.html#GUID-27DDB55B-F79E-4F40-8228-5D94456E620B"
                                },
                                {
                                    "title":"Enabling Hybrid Columnar Compression on Direct NFS Client",
                                    "href":"enabling-hcc-on-direct-nfs-client.html#GUID-6F8D47F3-D4E1-4022-9DE5-6D054D93B02A"
                                }
                            ]
                        },
                        {
                            "title":"Deploying a DAX-Enabled File System for Persistent Memory Database",
                            "href":"deploying-dax.html#GUID-64E95594-861D-4A06-8A72-036AD4305622",
                            "topics":[
                                {
                                    "title":"About Using a DAX-Enabled File System for Persistent Memory Database",
                                    "href":"about-dax.html#GUID-9B974B6D-1BA5-45FC-964C-D446B517C482"
                                },
                                {
                                    "title":"Creating a DAX-Enabled File System for Persistent Memory Database",
                                    "href":"creating-dax.html#GUID-2417DE06-7E38-4290-B073-761D92F8C5C8"
                                }
                            ]
                        },
                        {
                            "title":"Creating a Database on PMEM Storage Using Oracle DBCA",
                            "href":"pmem-on-dbca.html#GUID-DC95E1AE-081B-460F-99B0-7915CA0A6AE9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Configuring Storage for Oracle Grid Infrastructure for a Standalone Server",
                    "href":"configuring-storage-for-oracle-grid-infrastructure-for-a-standalone-server.html#GUID-B832D62F-CC58-446E-818A-677E894A9BBA",
                    "topics":[
                        {
                            "title":"Configuring Storage for Oracle Automatic Storage Management",
                            "href":"configuring-storage-for-oracle-automatic-storage-management.html#GUID-CBDF7400-9A35-4548-A3F2-52BA6871F130",
                            "topics":[
                                {
                                    "title":"Identifying Storage Requirements for Oracle Automatic Storage Management",
                                    "href":"identifying-storage-requirements-for-oracle-automatic-storage-management.html#GUID-FBF71AA0-16BF-446E-AA41-AD35CBA5C2F8"
                                },
                                {
                                    "title":"Oracle ASM Disk Space Requirements",
                                    "href":"disk_space_requirements_for_oracle_asm.html#GUID-DE737EEE-A352-4DC3-BB85-8CADE800E6C1"
                                },
                                {
                                    "title":"ASM Disk Group Options for Installation",
                                    "href":"asm-disk-group-options-for-interactive-and-noninteractive-installation.html#GUID-9791F7A1-8A33-4670-A54E-1632420D3B19"
                                },
                                {
                                    "title":"Using an Existing Oracle ASM Disk Group",
                                    "href":"using-an-existing-oracle-asm-disk-group.html#GUID-6921527A-0919-4DE8-BF88-FA343B7B2B31"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Storage Device Path Persistence Using Oracle ASMLIB",
                            "href":"configuring-storage-device-path-persistence-using-oracle-asmlib.html#GUID-BBD347D1-17D2-422A-879F-07FD189A4A2D",
                            "topics":[
                                {
                                    "title":"About Oracle ASM with Oracle ASMLIB",
                                    "href":"about-oracle-asm-with-oracle-asmlib.html#GUID-2DC2078C-9A79-4876-8BD4-3B56FF3FB7C9"
                                },
                                {
                                    "title":"Installing and Configuring Oracle ASMLIB Software",
                                    "href":"installing-and-configuring-oracle-asmlib-software.html#GUID-6C3F9E52-4E28-4912-B3A0-4E52570778C7"
                                },
                                {
                                    "title":"Deinstalling Oracle ASMLIB On Oracle AI Database",
                                    "href":"deinstalling-oracle-asmlib-on-oracle-database.html#GUID-F7B288F6-A1A3-4E87-B6A5-4EBDDCE1773F"
                                }
                            ]
                        },
                        {
                            "title":"Migrating from Oracle ASM Filter Driver to Oracle ASMLib for Oracle Restart",
                            "href":"migrating-from-asmfd-to-asmlib.html#GUID-0C6FBAC0-FF00-4E3D-A7DB-32E600226645"
                        },
                        {
                            "title":"Deconfiguring Oracle ASM Filter Driver",
                            "href":"deconfiguring-oracle-asmfd.html#GUID-541D9CFC-43FA-4E45-B916-B62BE09ADCBD"
                        },
                        {
                            "title":"Creating DAS or SAN Disk Partitions for Oracle Automatic Storage Management",
                            "href":"creating-das-or-san-disk-partitions-for-oracle-automatic-storage-management.html#GUID-C7491F9C-397F-4621-AA46-CCA72D4C8ED3"
                        },
                        {
                            "title":"Creating Directories for Oracle AI Database Files",
                            "href":"creating-directories-for-oracle-database-files.html#GUID-BAA48B85-7B6D-4482-B2CB-CE3CFC82ABBD"
                        },
                        {
                            "title":"Creating Files on a NAS Device for Use with Oracle Automatic Storage Management",
                            "href":"creating-files-on-a-nas-device-for-use-with-oracle-automatic-storage-management.html#GUID-D1F279EF-2D7D-4F70-9AC3-3078FF6E5649"
                        },
                        {
                            "title":"Configuring NVMe Over Fabrics Storage Devices with Oracle ASM",
                            "href":"configuring-nvmeof-storage-devices-with-oracle-asm.html#GUID-FD2EC9F8-49EC-406C-B201-C43D177946BF",
                            "topics":[
                                {
                                    "title":"About Using NVMe Over Fabrics Devices for Data Files",
                                    "href":"about-using-nvmeof-devices-for-data-files.html#GUID-13A5516C-C0BA-41B3-9EEE-D1E67EC370E6"
                                },
                                {
                                    "title":"Requirements and Guidelines for NVMe Over Fabrics Storage",
                                    "href":"requirement-and-guidelines-for-nvmeof-storage.html#GUID-4A010886-161C-4F69-B858-3CEC0C4BE891"
                                },
                                {
                                    "title":"Creating an NVMe-oF Storage Target",
                                    "href":"creating-nvme-storage-target.html#GUID-D4CB8CEC-FE2A-4543-A4E4-D8D2C145A04E"
                                },
                                {
                                    "title":"Creating an NVMe Configuration File and Using NVMe-oF Devices",
                                    "href":"creating-nvme-configuration-file.html#GUID-404B9885-0C58-4DEA-9B74-2D779F609726"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Installing and Configuring Oracle Grid Infrastructure for a Standalone Server",
                    "href":"installing-and-configuring-oracle-grid-infrastructure-for-a-standalone-server.html#GUID-DA3B90BE-EE1F-4347-8A5E-ED1BBFF29D93",
                    "topics":[
                        {
                            "title":"About Image-Based Oracle Grid Infrastructure Installation",
                            "href":"about-image-based-oracle-grid-infrastructure-installation.html#GUID-D991F940-7626-4615-908D-231D79740A5F"
                        },
                        {
                            "title":"Setup Wizard Installation Options for Creating Images",
                            "href":"setup-wizard-installation-options.html#GUID-30C45B5F-58A3-4D4C-8475-40093C51650B"
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure for a Standalone Server",
                            "href":"installing-oracle-grid-infrastructure-for-a-standalone-server-with-a-new-database-installation.html#GUID-0B1CEE8C-C893-46AA-8A6A-7B5FAAEC72B3"
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure for a Standalone Server for an Existing Database",
                            "href":"installing-oracle-grid-infrastructure-for-a-standalone-server-for-an-existing-database.html#GUID-8A992D7C-6287-438F-971C-887BE8AFDBEB"
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure for a Standalone Server Using a Software-Only Installation",
                            "href":"installing-oracle-grid-infrastructure-for-a-standalone-server-using-a-software-only-installation.html#GUID-B5A9BBFF-9530-4D4C-9113-19349574EC4E",
                            "topics":[
                                {
                                    "title":"About Oracle Grid Infrastructure Software-Only Installations",
                                    "href":"about-oracle-grid-infrastructure-software-only-installations.html#GUID-2FF7FD14-62FA-4B02-AE91-68B6BC966D1F"
                                },
                                {
                                    "title":"Installing Software Binaries for Oracle Grid Infrastructure for a Standalone Server",
                                    "href":"installing-software-binaries-for-oracle-grid-infrastructure-for-a-standalone-server.html#GUID-CBFF2EAE-082A-48B5-9A2F-C11B79BF8BF1"
                                },
                                {
                                    "title":"Configuring Software Binaries for Oracle Grid Infrastructure for a Standalone Server",
                                    "href":"configuring-software-binaries-for-oracle-grid-infrastructure-for-a-standalone-server.html#GUID-D85BEC0B-D206-492B-8665-6906E2DF34E7"
                                }
                            ]
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure for a Standalone Server Using Command-Line Interface",
                            "href":"install-restart-cli.html#GUID-75BFC849-35D6-48D1-B77E-4D60CB48D240"
                        },
                        {
                            "title":"Testing the Oracle Automatic Storage Management Installation",
                            "href":"testing-the-oracle-automatic-storage-management-installation.html#GUID-125CBE93-C37C-46B6-A3AD-03D8AD210EFD"
                        },
                        {
                            "title":"Relinking Oracle Restart and Oracle ASM Binaries",
                            "href":"modifying-oracle-grid-infrastructure-for-a-standalone-server-binaries-after-installation.html#GUID-3A0164E9-8814-4137-808F-CCF5DA32DD26"
                        },
                        {
                            "title":"Configuring Oracle ASM Disk Groups Manually using Oracle ASMCA",
                            "href":"configuring-oracle-asm-disk-groups-manually-using-oracle-asmca.html#GUID-F1A4AB04-EB12-49F2-896D-7719F877DFDD"
                        },
                        {
                            "title":"Enabling Oracle ACFS on Oracle Restart Configurations",
                            "href":"enabling-oracle-acfs-on-oracle-restart-configurations.html#GUID-92347E54-7711-4AC7-9972-E408FAA7C58C"
                        },
                        {
                            "title":"Applying Patches During an Oracle Grid Infrastructure Installation or Upgrade",
                            "href":"applying-patches-during-gi-install.html#GUID-D10C7B8D-A120-48A2-8237-36809D0DB21E"
                        },
                        {
                            "title":"Patching and Switching Oracle Grid Infrastructure Homes",
                            "href":"switch-gi-home-patching.html#GUID-27EBDA86-24B2-407B-A4AD-C0542B472F90"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Installing Oracle AI Database",
                    "href":"installing-oracle-database.html#GUID-1B6E6CAF-1621-4DFE-A63A-C0C9C7642CAB",
                    "topics":[
                        {
                            "title":"About Image-Based Oracle AI Database Installation",
                            "href":"about-image-based-database-installation.html#GUID-0315AA15-1C03-4E96-B801-3A8E5F5D4B39"
                        },
                        {
                            "title":"About Deploying Oracle AI Database Using Oracle Fleet Patching and Provisioning",
                            "href":"about-deploying-oracle-database-using-rapid-home-provisioning.html#GUID-7166A69D-5C4F-4EFC-AF22-F940C2376491"
                        },
                        {
                            "title":"Downloading Oracle Software",
                            "href":"downloading-oracle-software.html#GUID-543FA763-4692-48AB-8172-E26797E839FC",
                            "topics":[
                                {
                                    "title":"Downloading the Installation Archive Files from the Oracle AI Database Website",
                                    "href":"downloading-the-installation-archive-files-from-otn.html#GUID-698509F0-8BB5-494D-B80F-C752F38AA255"
                                },
                                {
                                    "title":"Downloading the Software from Oracle Software Delivery Cloud Portal",
                                    "href":"downloading-the-software-from-oracle-software-delivery-cloud-portal.html#GUID-34A70DC4-170F-41CD-8C7A-F4EE75B0EDAB"
                                }
                            ]
                        },
                        {
                            "title":"About Character Set Selection During Installation",
                            "href":"about-character-set-selection-during-installation.html#GUID-70B091B3-C67A-4AFD-9F60-75046171592D"
                        },
                        {
                            "title":"About Automatic Memory Management Installation Options",
                            "href":"about-automatic-memory-management-installation-options.html#GUID-38F46564-B167-4A78-A974-8C7CEE34EDFE"
                        },
                        {
                            "title":"Running the Installer in a Different Language",
                            "href":"running-oracle-universal-installer-in-different-languages.html#GUID-0CE36769-C9C9-4844-B06D-F27655EDE1A5"
                        },
                        {
                            "title":"Installing the Oracle AI Database Software",
                            "href":"installing-the-oracle-database-software.html#GUID-2D723146-DA37-4887-93F8-1164E7403235",
                            "topics":[
                                {
                                    "title":"Setup Wizard Installation Options for Creating Images",
                                    "href":"Chunk1586481694.html#GUID-30C45B5F-58A3-4D4C-8475-40093C51650B"
                                },
                                {
                                    "title":"Applying Patches During an Oracle AI Database Installation or Upgrade",
                                    "href":"applying-patches-during-db-install.html#GUID-9E8DC4A7-4DCD-4BF7-A476-434B1B047418"
                                },
                                {
                                    "title":"Running Oracle AI Database Setup Wizard to Install Oracle AI Database",
                                    "href":"running-oracle-universal-installer-to-install-oracle-database.html#GUID-DD4800E9-C651-4B08-A6AC-E5ECCC6512B9"
                                },
                                {
                                    "title":"Installing Oracle AI Database Using Command-Line Interface",
                                    "href":"install-database-cli.html#GUID-4265FFF4-EFE8-457A-84E4-A9484156D97B"
                                }
                            ]
                        },
                        {
                            "title":"Installing Oracle AI Database Using RPM Packages",
                            "href":"installing-oracle-database-using-rpm-packages.html#GUID-5AF74AC1-510E-4EB0-9BCA-B096C42C6A76",
                            "topics":[
                                {
                                    "title":"About RPM-Based Oracle AI Database Installation",
                                    "href":"about-rpm-based-oracle-database-installation.html#GUID-C2B4A806-E1E2-4B77-971B-628CFF18A488"
                                },
                                {
                                    "title":"Restrictions and Guidelines for RPM-Based Installations",
                                    "href":"restrictions-for-rpm-based-installations.html#GUID-22C1C4C1-49BE-4664-9A73-E96F70665633"
                                },
                                {
                                    "title":"RPM Packages Naming Convention",
                                    "href":"rpm-packages-naming-convention.html#GUID-04FBD99C-77A8-4E31-9C8D-5B6B2EAE68DB"
                                },
                                {
                                    "title":"Running RPM Packages to Install Oracle AI Database",
                                    "href":"running-rpm-packages-to-install-oracle-database.html#GUID-BB7C11E3-D385-4A2F-9EAF-75F4F0AACF02"
                                }
                            ]
                        },
                        {
                            "title":"Installing Standard Edition High Availability",
                            "href":"configuring-standard-edition-high-availability.html#GUID-B4071766-F926-469F-9F9E-AB82E62236C8",
                            "topics":[
                                {
                                    "title":"About Standard Edition High Availability",
                                    "href":"about-standard-edition-high-availability.html#GUID-518DE985-BA6F-42C3-83BD-6EC9D754530E"
                                },
                                {
                                    "title":"Requirements for Installing Standard Edition High Availability",
                                    "href":"guidelines-for-seha.html#GUID-55EEFB09-B708-4BA5-BA1A-23609FEC6A29"
                                },
                                {
                                    "title":"Deploying Standard Edition High Availability",
                                    "href":"installing-seha.html#GUID-A7A88796-A778-47DD-BC00-53F1F1721B2D",
                                    "topics":[
                                        {
                                            "title":"Installing Standard Edition High Availability Database Software on Local File System",
                                            "href":"installing-seha-on-local-file-system.html#GUID-F81473AF-75A2-421B-B8E2-B3EE1D4D103F"
                                        },
                                        {
                                            "title":"Installing Standard Edition High Availability Database Software on Oracle ACFS",
                                            "href":"installing-seha-on-oracle-acfs.html#GUID-E6154340-63CF-4462-BD37-830DDE4A8EC7"
                                        },
                                        {
                                            "title":"Creating a Standard Edition High Availability Database Using Oracle DBCA",
                                            "href":"dbca-seha.html#GUID-DB338534-832E-47B7-8829-0D1F1574F552"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Single-Server Rolling Database Maintenance",
                            "href":"single-server-rolling-database-maintenance.html#GUID-132AD06F-10FC-446E-89CA-B4FF90E464A9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Configuring Oracle Homes",
                    "href":"configuring-read-only-oracle-homes.html#GUID-906DA159-AC83-4ACC-A8A6-5B4A39EB72E1",
                    "topics":[
                        {
                            "title":"Evolution of Oracle Homes",
                            "href":"understanding-read-only-oracle-homes.html#GUID-AE1973D7-0325-4AD8-9FC9-D7BA3C3C3F37",
                            "topics":[
                                {
                                    "title":"About Read-Only Oracle Homes",
                                    "href":"about-read-only-oracle-home.html#GUID-D848002A-DBAD-48FA-8467-E849630B8E42"
                                },
                                {
                                    "title":"About Oracle Base Home",
                                    "href":"about-oracle-base-home.html#GUID-2895AF62-C297-4753-B104-5E0519F30141"
                                },
                                {
                                    "title":"About Oracle Base Config",
                                    "href":"about-oracle-base-config.html#GUID-65A66058-319C-4C53-98F2-9CD2D8B030C6"
                                },
                                {
                                    "title":"About orabasetab",
                                    "href":"about-orabasetab.html#GUID-9090F5D7-9875-48C5-B735-A8E90F9F8BAE"
                                },
                                {
                                    "title":"Location of Networking Files in a Read-Only Oracle Home",
                                    "href":"location-networking-files.html#GUID-A81E1D5E-721F-4149-B856-7C413948F7C0"
                                }
                            ]
                        },
                        {
                            "title":"Enabling a Read-Only Oracle Home",
                            "href":"enabling-read-only-oracle-home.html#GUID-7B2FA40E-8FBA-4494-934A-A284532AF702"
                        },
                        {
                            "title":"Copying demo Directories to Oracle Base Home",
                            "href":"running-demo-from-oracle-base-home.html#GUID-9C4D0762-7F36-4819-9D00-90ACE68E482B"
                        },
                        {
                            "title":"Determining If an Oracle Home is Read-Only",
                            "href":"checking-if-read-only-oracle-home-exists.html#GUID-7B4C699F-49B1-42D9-94A6-6112B2F7945A"
                        },
                        {
                            "title":"File Path and Directory Changes in Read-Only Oracle Homes",
                            "href":"file-path-directory-changes-read-only-oracle-home.html#GUID-695D5458-A4AF-4F2A-AE4B-FB1062CF6014"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Oracle AI Database Postinstallation Tasks",
                    "href":"oracle-database-postinstallation-tasks.html#GUID-FCF693BF-FB7F-4FA6-81BD-DF669675D401",
                    "topics":[
                        {
                            "title":"Oracle AI Database Patching",
                            "href":"oracle-database-patching.html#GUID-73555C58-B361-4F0B-8D70-3E4CE5FB6EBF",
                            "topics":[
                                {
                                    "title":"About Oracle AI Database Release Update Patches",
                                    "href":"about-oracle-database-patches.html#GUID-1B7C597D-4629-431B-A759-BBF8F0556F42"
                                },
                                {
                                    "title":"Downloading Release Update Patches",
                                    "href":"downloading-and-installing-patch-updates.html#GUID-A2FD0257-D074-444D-8007-A21EBEC10358"
                                },
                                {
                                    "title":"Applying Out-of-Place Oracle AI Database Patches",
                                    "href":"apply-oop-db-patches.html#GUID-A3259797-A63F-40D9-AC82-34C95CF739A9"
                                },
                                {
                                    "title":"Patching Oracle AI Database Using Oracle FPP Local Mode",
                                    "href":"patching-db--fpp-local-mode.html#GUID-B50D950E-6FE9-4C2C-846A-1F10601C495D"
                                }
                            ]
                        },
                        {
                            "title":"Required Postinstallation Tasks",
                            "href":"required-postinstallation-tasks.html#GUID-57C27D5D-7C92-4919-A430-690B89C57665",
                            "topics":[
                                {
                                    "title":"Unlocking Accounts and Resetting Oracle AI Database User Passwords",
                                    "href":"unlocking-and-resetting-oracle-database-user-passwords.html#GUID-9EABD4CE-9EB0-4A87-8726-9F9F51DFBD23",
                                    "topics":[
                                        {
                                            "title":"Requirements for Database Passwords",
                                            "href":"requirements-for-database-passwords.html#GUID-432DA3DD-7688-49F9-BCA7-66C86149295B"
                                        },
                                        {
                                            "title":"Oracle AI Database System Privileges Accounts and Passwords",
                                            "href":"oracle-database-system-privileges-accounts-and-passwords.html#GUID-7513171C-1055-48BB-8C79-B27EECC9B7E9"
                                        },
                                        {
                                            "title":"Guidelines for Changing System Privileges Account Passwords",
                                            "href":"guidelines-for-changing-system-privileges-account-passwords.html#GUID-D6235258-7FEA-42C6-89E2-A917585D6562"
                                        },
                                        {
                                            "title":"Using SQL*Plus to Lock, Unlock Accounts, and Reset Passwords",
                                            "href":"using-sql-plus-to-unlock-accounts-and-reset-passwords.html#GUID-1147D2B9-8FFC-4F91-A774-E97066B4E9C5"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Recommended Postinstallation Tasks",
                            "href":"recommended-postinstallation-tasks.html#GUID-01E7E498-DC11-411E-ADA2-02C2B8F358F0",
                            "topics":[
                                {
                                    "title":"Setting Language and Locale Preferences for Client Connections",
                                    "href":"setting-language-preferences-for-client-connections.html#GUID-78A71337-2199-4FED-B0F1-D313F769B22C"
                                },
                                {
                                    "title":"Recompile Invalid Objects in the Database",
                                    "href":"recompiling-all-invalid-objects.html#GUID-1023C5FB-B409-4F16-BCA1-C14CB9B7E625"
                                },
                                {
                                    "title":"About Installing Oracle Autonomous Health Framework",
                                    "href":"downloading-and-installing-the-orachk-health-check-tool.html#GUID-19914928-49B2-444A-8F1B-D4398C264AAD"
                                }
                            ]
                        },
                        {
                            "title":"About Changes in Default SGA Permissions for Oracle AI Database",
                            "href":"change-in-default-sga-permissions-for-oracle-database.html#GUID-B588A924-1F76-4536-A476-E8AC9FCB977B"
                        },
                        {
                            "title":"Checking Installed Oracle AI Database Contents and Directory Location",
                            "href":"checking-installed-oracle-database-contents-and-directory-location.html#GUID-7C3D12AE-3C1A-4647-AC76-F3F70EE190EC"
                        },
                        {
                            "title":"Enabling and Disabling Oracle AI Database Options After Installation",
                            "href":"enabling-and-disabling-oracle-database-options-after-installation.html#GUID-5E055744-6440-4E28-AC76-E87449379EED",
                            "topics":[
                                {
                                    "title":"Chopt Tool",
                                    "href":"chopt-tool.html#GUID-057E4EFC-74ED-43B3-B03B-C83C5A5D3C7F"
                                }
                            ]
                        },
                        {
                            "title":"Creating a Fast Recovery Area",
                            "href":"creating-a-fast-recovery-area.html#GUID-C56FFC39-923E-4A94-961D-B6785FB83C8A",
                            "topics":[
                                {
                                    "title":"About the Fast Recovery Area and the Fast Recovery Area Disk Group",
                                    "href":"about-the-fast-recovery-area-and-the-fast-recovery-area-disk-group.html#GUID-05343E2B-24CF-427E-A068-9AC2104BEF81"
                                },
                                {
                                    "title":"Creating the Fast Recovery Area Disk Group",
                                    "href":"creating-the-fast-recovery-area-disk-group.html#GUID-5D87E773-BEAA-4C7E-BE25-B970E15633D7"
                                }
                            ]
                        },
                        {
                            "title":"Cloning Oracle AI Database",
                            "href":"cloning-oracle-database.html#GUID-071A5C60-9AFA-485B-923C-F8BE1B4880A2",
                            "topics":[
                                {
                                    "title":"Cloning an Oracle AI Database Home Using an Image File",
                                    "href":"cloning-using-goldimage.html#GUID-3E6A6A11-18C0-40C3-A3D0-CF7BAC846EE4"
                                },
                                {
                                    "title":"Cloning an Oracle AI Database Home Using clone.pl",
                                    "href":"cloning-an-oracle-home.html#GUID-494E59C3-C381-4A35-8ABE-F6E5DBF29032"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Removing Oracle AI Database Software",
                    "href":"removing-oracle-database-software.html#GUID-5619EBF0-C89E-4349-AE6F-A8F8B3B06BD1",
                    "topics":[
                        {
                            "title":"About Oracle Deinstallation Options",
                            "href":"about-oracle-deinstallation-options.html#GUID-DF4E3D18-163A-4014-B24F-AAC4EBD9955F"
                        },
                        {
                            "title":"Oracle Deinstallation (Deinstall)",
                            "href":"oracle-deinstallation-tool-deinstall.html#GUID-71E860C5-4E1E-4D2F-AFD1-141709A172C0"
                        },
                        {
                            "title":"Deinstallation Examples for Oracle AI Database",
                            "href":"deinstallation-examples-for-oracle-database.html#GUID-05452B1D-E034-4547-B9C6-9E8BCA1BD4EF"
                        },
                        {
                            "title":"Downgrading Oracle Restart",
                            "href":"downgrading-oracle-restart.html#GUID-0833DAC4-75D9-407C-B8E1-47CC5092BAD4"
                        },
                        {
                            "title":"Removing an RPM-based Oracle AI Database Installation",
                            "href":"removing-rpm-based-database-installation.html#GUID-7F7AECE2-16D5-433A-95BD-972B97955BF7"
                        },
                        {
                            "title":"Deinstalling Previous Release Grid Home",
                            "href":"deinstalling-previous-release-grid-home.html#GUID-D84F94CE-251C-4D3B-9D6E-F584FB30F5B3"
                        },
                        {
                            "title":"Changing the Oracle Restart Home Path",
                            "href":"change-restart-path.html#GUID-2D97DEC7-7C62-4D2A-B9D9-ACD8E6B4451B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle Grid Infrastructure Command-Line Options",
                    "href":"grid-command-line-options.html#GUID-24AE3D52-39B5-4361-B5DF-3E6D0334029D",
                    "topics":[
                        {
                            "title":"gridSetup.sh Command",
                            "href":"gridsetup-command-options.html#GUID-C9C5B44A-4541-4869-8829-8A540476CF07"
                        },
                        {
                            "title":"gridSetup.sh -setupHome",
                            "href":"gridsetup-setuphome-command.html#GUID-8A135DED-1768-4185-BF20-7EA0019BD262"
                        },
                        {
                            "title":"gridSetup.sh -setupHomeAs",
                            "href":"gridsetup-setuphomeas-command.html#GUID-8A094193-0DE0-4352-BB66-E3001715E42F"
                        },
                        {
                            "title":"gridSetup.sh -configureStandaloneServer",
                            "href":"gridsetup-configurestandaloneserver-command.html#GUID-95EB4A9C-321E-42EB-9B3E-1CBE80C3093C"
                        },
                        {
                            "title":"gridSetup.sh -switchGridhome",
                            "href":"gridsetup-switchgridhome-command.html#GUID-383FA93F-BA10-4131-9BFA-1A99E6807D6A"
                        },
                        {
                            "title":"gridSetup.sh -createGoldImage",
                            "href":"gridsetup-creategoldimage-command.html#GUID-9ADE23AB-FB22-49EF-9628-7FFF59DDD109"
                        },
                        {
                            "title":"gridSetup.sh -upgrade",
                            "href":"gridsetup-upgradegridinfrastructure-command.html#GUID-2CDDA644-F691-4B7D-A882-81FC5F740FC3"
                        },
                        {
                            "title":"gridSetup.sh -downgrade",
                            "href":"gridsetup-downgradegridinfrastructure-command.html#GUID-E6BEE552-3325-452A-ADC4-DE1E8C1505CC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Oracle AI Database Installer Command-Line Options",
                    "href":"db-command-line-options.html#GUID-6B2B7EEC-A152-4097-A872-A2CABDEE2BCC",
                    "topics":[
                        {
                            "title":"runInstaller Command",
                            "href":"runinstaller-command-options.html#GUID-D9DC47E4-1A6D-4CFF-B49E-9011BBA8E306"
                        },
                        {
                            "title":"runInstaller -setupDBHome",
                            "href":"runinstaller-setupdbhome-command.html#GUID-F916624B-5821-42B6-BBED-D76F1286F8EB"
                        },
                        {
                            "title":"runInstaller -setupDBHomeAs",
                            "href":"runinstaller-setupdbhomeas-command.html#GUID-EFE4BE7C-4DD3-4FEF-8063-AB835025421F"
                        },
                        {
                            "title":"runInstaller -createDatabase",
                            "href":"runinstaller-create-database-command.html#GUID-B7B80A34-054F-44AC-9101-F3283B152EAE"
                        },
                        {
                            "title":"runInstaller -createGoldImage",
                            "href":"runinstaller-creategoldimage-command.html#GUID-DA476FA3-41F1-42F5-A7D5-AA5130199206"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Completing Preinstallation Tasks Manually",
                    "href":"completing-preinstallation-tasks-manually.html#GUID-54959149-E611-48EC-BDDF-F379E8B35C97",
                    "topics":[
                        {
                            "title":"Configuring Kernel Parameters for Linux",
                            "href":"configuring-kernel-parameters-for-linux.html#GUID-6127884D-FB27-45FA-9498-B2540632CBD5",
                            "topics":[
                                {
                                    "title":"Minimum Parameter Settings for Installation",
                                    "href":"minimum-parameter-settings-for-installation.html#GUID-CDEB89D1-4D48-41D9-9AC2-6AD9B0E944E3"
                                },
                                {
                                    "title":"Changing Kernel Parameter Values",
                                    "href":"changing-kernel-parameter-values.html#GUID-FB0CC366-61C9-4AA2-9BE7-233EB6810A31"
                                },
                                {
                                    "title":"Configuring Additional Kernel Settings for SUSE Linux",
                                    "href":"configuring-additional-kernel-settings-for-suse-linux.html#GUID-7A4DF920-A200-42F1-93CF-EF1D45240092"
                                },
                                {
                                    "title":"Setting UDP and TCP Kernel Parameters Manually",
                                    "href":"setting-udp-and-tcp-kernel-parameters-manually.html#GUID-F94545C8-7695-4866-89B0-F32651CD3658"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Default Thread Limits Value for SUSE Linux",
                            "href":"configuring-defaulttasksmax-for-suse.html#GUID-0815D18D-65E7-46B2-BA89-F54BA02EFCB8"
                        },
                        {
                            "title":"Configuring Storage Device Path Persistence Manually",
                            "href":"configuring-storage-device-path-persistence-manually.html#GUID-9E4220CB-506E-4792-87B3-EAC4071C1056",
                            "topics":[
                                {
                                    "title":"Configuring Device Persistence Manually for Oracle ASM",
                                    "href":"configuring-device-persistence-manually-for-oracle-asm.html#GUID-70D50812-CCB2-41E4-AA3B-4689E1DA934E"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">D </span> Response Files",
                    "href":"installing-and-configuring-oracle-database-using-response-files.html#GUID-D53355E9-E901-4224-9A2A-B882070EDDF7",
                    "topics":[
                        {
                            "title":"Modes for Oracle DBCA Noninteractive (Silent) Configuration",
                            "href":"how-response-files-work.html#GUID-22719BEB-97CB-4134-A84D-629A7109C7A5"
                        },
                        {
                            "title":"Reasons for Using Silent Mode or Response File Mode",
                            "href":"reasons-for-using-silent-mode-or-response-file-mode.html#GUID-62D156C6-8CB4-491E-A7DD-ED3DB7D1D82B"
                        },
                        {
                            "title":"Using Response Files",
                            "href":"using-response-files.html#GUID-9EDC0547-4BCC-4349-A0F7-CBDD0039F3EF"
                        },
                        {
                            "title":"Preparing Response Files",
                            "href":"preparing-response-files.html#GUID-436B233E-1195-44E3-B849-4635B497D238",
                            "topics":[
                                {
                                    "title":"Editing a Response File Template",
                                    "href":"editing-a-response-file-template.html#GUID-662F8635-947B-4774-B9BB-3752B47C3F91"
                                },
                                {
                                    "title":"Recording Response Files",
                                    "href":"recording-response-files.html#GUID-5F75A411-6DD8-43C8-9BC7-294AE82204FE"
                                }
                            ]
                        },
                        {
                            "title":"Running Oracle Universal Installer Using a Response File",
                            "href":"running-oracle-universal-installer-using-a-response-file.html#GUID-C8B6ED11-4486-45E0-8365-E1A9695FB27C"
                        },
                        {
                            "title":"Running Configuration Assistants Using Response Files",
                            "href":"running-configuration-assistants-using-response-files.html#GUID-BCE68F44-2A36-42B5-A4EA-0A7C2B890766",
                            "topics":[
                                {
                                    "title":"Running Net Configuration Assistant Using Response Files",
                                    "href":"running-net-configuration-assistant-using-response-files.html#GUID-86CD4F09-BEF8-40B4-905C-5DA86582CD74"
                                },
                                {
                                    "title":"Running Oracle DBCA Using Response Files",
                                    "href":"running-database-configuration-assistant-using-response-files.html#GUID-E84CE996-B30C-4DCA-AE4C-1E90201317C2"
                                }
                            ]
                        },
                        {
                            "title":"Postinstallation Configuration Using Response File Created During Installation",
                            "href":"postinstallation-configuration-using-response-file-created-during-installation.html#GUID-855D3F72-D2F9-4263-8BC6-37641F2C4251",
                            "topics":[
                                {
                                    "title":"Using the Installation Response File for Postinstallation Configuration",
                                    "href":"using-the-installation-response-file-for-postinstallation-configuration.html#GUID-25DFB0D0-FC1A-432B-919C-6FB9B7F9E447"
                                },
                                {
                                    "title":"Running Postinstallation Configuration Using Response File",
                                    "href":"running-postinstallation-configuration-using-response-file.html#GUID-F8AE183A-872E-43FC-AE9A-74407530C1E2"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">E </span> Optimal Flexible Architecture",
                    "href":"optimal-flexible-architecture.html#GUID-34434C8B-EBEE-497A-BB92-26B43561B6B1",
                    "topics":[
                        {
                            "title":"About the Optimal Flexible Architecture Standard",
                            "href":"about-the-optimal-flexible-architecture-standard.html#GUID-6619CDB7-9667-426E-8471-5A996707D093"
                        },
                        {
                            "title":"About Multiple Oracle Homes Support",
                            "href":"about-multiple-oracle-homes-support.html#GUID-CFB6CD80-EFE5-4A14-95F4-08291DB594FD"
                        },
                        {
                            "title":"About the Oracle Inventory Directory and Installation",
                            "href":"about-the-oracle-inventory-directory-and-installation.html#GUID-22CB62EF-D5DA-47BF-B4C3-C5D03B059728"
                        },
                        {
                            "title":"Oracle Base Directory Naming Convention",
                            "href":"oracle-base-directory-naming-convention.html#GUID-3B198883-0AD1-4AB2-9007-059AE32240F0"
                        },
                        {
                            "title":"Oracle Home Directory Naming Convention",
                            "href":"oracle-home-directory-naming-convention.html#GUID-8599FF25-C020-4E03-93D2-8D92ADA240A8"
                        },
                        {
                            "title":"Optimal Flexible Architecture File Path Examples",
                            "href":"optimal-flexible-architecture-file-path-examples.html#GUID-BB3EE4F7-50F4-4A2D-8A0D-96B7CC44029B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">F </span> Managing Oracle AI Database Port Numbers",
                    "href":"managing-oracle-database-port-numbers.html#GUID-283FCCBE-A8FA-457B-8C7D-34D64AEB6DA9",
                    "topics":[
                        {
                            "title":"About Managing Ports",
                            "href":"about-managing-ports.html#GUID-116C07D3-DE6B-4670-87C6-F1656C5D1722"
                        },
                        {
                            "title":"Oracle AI Database Component Port Numbers and Protocols",
                            "href":"oracle-database-component-port-numbers-and-protocols.html#GUID-B530F5CD-DD07-44D9-8499-0828B716C3A8"
                        }
                    ]
                }
            ]
        }
    ]
});