define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Examples",
                    "href":"loe.html"
                },
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-9952D28D-0310-4869-8002-4462BDC679BB"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Changes in This Release for Oracle Database PL/SQL Language Reference",
                    "href":"release-changes.html"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Overview of PL/SQL",
                    "href":"overview.html#GUID-2FBCFBBE-6B42-4DB8-83F3-55B63B75B1EB",
                    "topics":[
                        {
                            "title":"Advantages of PL/SQL",
                            "href":"advantages-pl-sql.html#GUID-17166AA4-14DC-48A6-BE92-3FC758DAA940"
                        },
                        {
                            "title":"Main Features of PL/SQL",
                            "href":"main-features-pl-sql.html#GUID-66D23BD1-0489-43B0-8108-FA14CA579B52"
                        },
                        {
                            "title":"Architecture of PL/SQL",
                            "href":"architecture-pl-sql.html#GUID-6C7B2CED-969A-4861-9CDF-25FD804FAE6E"
                        },
                        {
                            "title":"Protecting Sensitive Information in PL/SQL",
                            "href":"protecting-sensitive-information-pl-sql.html#GUID-BA1950FD-2A7D-45AF-8ED0-115E60E4C919"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> PL/SQL Language Fundamentals",
                    "href":"plsql-language-fundamentals.html#GUID-640DB3AA-15AF-4825-BD6C-1D4EB5AB7715",
                    "topics":[
                        {
                            "title":"Character Sets",
                            "href":"character-sets.html#GUID-C2478525-0728-45B1-BFED-103D533B70D2"
                        },
                        {
                            "title":"Lexical Units",
                            "href":"lexical-units.html#GUID-8854493A-E242-4473-9B17-01F489ABC371"
                        },
                        {
                            "title":"Declarations",
                            "href":"declarations.html#GUID-65F9E0D0-03CD-4C40-829A-7392ACE8F932"
                        },
                        {
                            "title":"References to Identifiers",
                            "href":"references-identifiers.html#GUID-397990B7-9C45-4D37-A8A4-478FC116E898"
                        },
                        {
                            "title":"Scope and Visibility of Identifiers",
                            "href":"scope-and-visibility-identifiers.html#GUID-2FC17012-FC99-4614-90DD-ADC99F2EDBE9"
                        },
                        {
                            "title":"Assigning Values to Variables",
                            "href":"assigning-values-variables.html#GUID-356CB656-68ED-4869-8C67-FE93A78AEC9A"
                        },
                        {
                            "title":"Expressions",
                            "href":"expressions.html#GUID-42674F8E-55C3-44D5-BA42-47B323CD74F5"
                        },
                        {
                            "title":"Error-Reporting Functions",
                            "href":"error-reporting-functions.html#GUID-9BD20166-6ECC-470A-8D81-47D11EC01CE9"
                        },
                        {
                            "title":"Conditional Compilation",
                            "href":"conditional-compilation1.html#GUID-DC23291F-006D-49C4-87DA-6B31F19F162A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> PL/SQL Data Types",
                    "href":"plsql-data-types.html#GUID-391C58FD-16AF-486C-AF28-173E309CDBA5",
                    "topics":[
                        {
                            "title":"SQL Data Types",
                            "href":"sql-data-types.html#GUID-239A89A6-4CBC-46F5-8A6A-10E8B465B7E8"
                        },
                        {
                            "title":"PLS_INTEGER and BINARY_INTEGER Data Types",
                            "href":"pls_integer-and-binary_integer-data-types.html#GUID-9517B7AC-9CEA-4C36-A454-52588BEEBE8F"
                        },
                        {
                            "title":"User-Defined PL/SQL Subtypes",
                            "href":"user-defined-pl-sql-subtypes.html#GUID-0E03C20F-2960-4ED9-8692-D4DCBF1F9670"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> PL/SQL Control Statements",
                    "href":"plsql-control-statements.html#GUID-18777904-23F6-4F6D-8B41-46BABF00BA03",
                    "topics":[
                        {
                            "title":"Conditional Selection Statements",
                            "href":"conditional-selection-statements.html#GUID-B7DD4E62-3ED2-41E9-AAE5-90A78788BB31"
                        },
                        {
                            "title":"LOOP Statements",
                            "href":"loop-statements.html#GUID-4CD12F11-2DB8-4B0D-9E04-DF983DCF9358"
                        },
                        {
                            "title":"Sequential Control Statements",
                            "href":"sequential-control-statements.html#GUID-7CA9E984-CCB3-4DB8-8D0C-30BF0C74BA83"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> PL/SQL Collections and Records",
                    "href":"plsql-collections-and-records.html#GUID-7115C8B6-62F9-496D-BEC3-F7441DFE148A",
                    "topics":[
                        {
                            "title":"Collection Types",
                            "href":"collection-types.html#GUID-7E9034D5-0D33-43A1-9012-918350FE148C"
                        },
                        {
                            "title":"Associative Arrays",
                            "href":"associative-arrays.html#GUID-8060F01F-B53B-48D4-9239-7EA8461C2170"
                        },
                        {
                            "title":"Varrays (Variable-Size Arrays)",
                            "href":"varrays-variable-size-arrays.html#GUID-E932FC04-C7AD-4562-9555-8BA05446C0B8"
                        },
                        {
                            "title":"Nested Tables",
                            "href":"nested-tables.html#GUID-5ADB7EE2-71F6-4172-ACD8-FFDCF2787A37"
                        },
                        {
                            "title":"Collection Constructors",
                            "href":"collection-constructors.html#GUID-92967CC1-481E-472A-BB4C-90C60F75296D"
                        },
                        {
                            "title":"Qualified Expressions Overview",
                            "href":"qualified-expressions-overview.html#GUID-4B379569-4068-4DB1-9D69-E706F4AC5758"
                        },
                        {
                            "title":"Assigning Values to Collection Variables",
                            "href":"assigning-values-collection-variables.html#GUID-7836EEC3-2642-4CF8-AA50-81034855119D"
                        },
                        {
                            "title":"Multidimensional Collections",
                            "href":"multidimensional-collections.html#GUID-2E00BF7F-0285-41F1-8075-AC859F622A3F"
                        },
                        {
                            "title":"Collection Comparisons",
                            "href":"collection-comparisons.html#GUID-68EC8EF3-E351-4917-8C7A-5103CDB2C01B"
                        },
                        {
                            "title":"Collection Methods",
                            "href":"collection-methods.html#GUID-0452FBDC-D9C1-486E-B432-49AF84743A9F"
                        },
                        {
                            "title":"Collection Types Defined in Package Specifications",
                            "href":"collection-types-defined-package-specifications.html#GUID-7C84EBD2-D0A5-4126-8EB7-FF9243EE5B47"
                        },
                        {
                            "title":"Record Variables",
                            "href":"record-variables.html#GUID-75875E26-FC7B-4513-A5E2-EDA26F1D67B1"
                        },
                        {
                            "title":"Assigning Values to Record Variables",
                            "href":"assigning-values-record-variables.html#GUID-794AD0D6-2D97-4C4A-B7DA-6126025EF2A5"
                        },
                        {
                            "title":"Record Comparisons",
                            "href":"record-comparisons.html#GUID-DFDE40BD-4B61-4C8A-B9CE-3FE01E21F658"
                        },
                        {
                            "title":"Inserting Records into Tables",
                            "href":"inserting-records-tables.html#GUID-AC5CEFCB-87AA-41FD-AE16-FFE66606E6B1"
                        },
                        {
                            "title":"Updating Rows with Records",
                            "href":"updating-rows-records.html#GUID-11D63245-591D-4CBF-BFBA-8F3C0AE0E968"
                        },
                        {
                            "title":"Restrictions on Record Inserts and Updates",
                            "href":"restrictions-record-inserts-and-updates.html#GUID-EC8E43E9-8356-4256-857A-D8109F2CF324"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> PL/SQL Static SQL",
                    "href":"static-sql.html#GUID-A2E4086F-94DC-4CC7-9E4B-30285BEC3313",
                    "topics":[
                        {
                            "title":"Description of Static SQL",
                            "href":"description-static-sql.html#GUID-54ABD9E3-EA4D-4C60-A84A-021925501C0C"
                        },
                        {
                            "title":"Cursors Overview",
                            "href":"cursors-overview.html#GUID-F1FE15F9-5C96-4C4E-B240-B7363D25A8F1"
                        },
                        {
                            "title":"Processing Query Result Sets",
                            "href":"processing-query-result-sets.html#GUID-E6BCE8B1-71AA-459F-845F-2C34541A534D"
                        },
                        {
                            "title":"Cursor Variables",
                            "href":"cursor-variables.html#GUID-4A6E054A-4002-418D-A1CA-DE849CD7E6D5"
                        },
                        {
                            "title":"CURSOR Expressions",
                            "href":"cursor-expressions.html#GUID-77FF2850-F338-4C77-9577-0FE3399D39BA"
                        },
                        {
                            "title":"Transaction Processing and Control",
                            "href":"transaction-processing-and-control.html#GUID-218080C2-A7C5-42CC-B34E-A08A0C9341C1"
                        },
                        {
                            "title":"Autonomous Transactions",
                            "href":"autonomous-transactions.html#GUID-BC564905-51F4-4ADB-B300-9F15B1AC3099"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> PL/SQL Dynamic SQL",
                    "href":"dynamic-sql.html#GUID-7E2F596F-9CA3-4DC8-8333-0C117962DB73",
                    "topics":[
                        {
                            "title":"When You Need Dynamic SQL",
                            "href":"when-you-need-dynamic-sql.html#GUID-DAFD83C8-FA3A-40A6-95E5-3B2F082E1798"
                        },
                        {
                            "title":"Native Dynamic SQL",
                            "href":"native-dynamic-sql.html#GUID-D2613968-6660-4AA2-9057-28E425A3040D"
                        },
                        {
                            "title":"DBMS_SQL Package",
                            "href":"dbms_sql-package.html#GUID-4E1FD47B-7E1A-42E9-9792-210F13C75A1B"
                        },
                        {
                            "title":"SQL Injection",
                            "href":"sql-injection.html#GUID-1E31057E-057F-4A53-B1DD-8BC2C337AA2C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> PL/SQL Subprograms",
                    "href":"plsql-subprograms.html#GUID-13BEBBEC-02D4-48E8-A059-DFEAC4751A3B",
                    "topics":[
                        {
                            "title":"Reasons to Use Subprograms",
                            "href":"reasons-use-subprograms.html#GUID-56B4253C-6113-4C97-A0D2-1488B6526076"
                        },
                        {
                            "title":"Nested, Package, and Standalone Subprograms",
                            "href":"nested-package-and-standalone-subprograms.html#GUID-E03F512B-1A30-43B4-8DCA-64DA68AE7CE4"
                        },
                        {
                            "title":"Subprogram Invocations",
                            "href":"subprogram-invocations.html#GUID-C04B6BF9-1B19-42F9-82D8-CA137E97A024"
                        },
                        {
                            "title":"Subprogram Properties",
                            "href":"subprogram-properties.html#GUID-F4B0F4E1-90F4-4432-8DCF-3C93D0376E88"
                        },
                        {
                            "title":"Subprogram Parts",
                            "href":"subprogram-parts.html#GUID-855AA11F-32CB-4CAD-9255-BE92A6821487"
                        },
                        {
                            "title":"Forward Declaration",
                            "href":"forward-declaration.html#GUID-117C2D94-EB7C-4A9E-A080-99F4829D69B0"
                        },
                        {
                            "title":"Subprogram Parameters",
                            "href":"subprogram-parameters.html#GUID-C0397690-70F4-480D-ADC9-02D277DAA1BB"
                        },
                        {
                            "title":"Subprogram Invocation Resolution",
                            "href":"subprogram-invocation-resolution.html#GUID-A7D51201-1711-4F33-827F-70042700801F"
                        },
                        {
                            "title":"Overloaded Subprograms",
                            "href":"overloaded-subprograms.html#GUID-47D5A50E-7AAF-4C80-A06A-37593EA2526A"
                        },
                        {
                            "title":"Recursive Subprograms",
                            "href":"recursive-subprograms.html#GUID-E093EF16-0477-44B4-B3E2-37D7CEF4F25C"
                        },
                        {
                            "title":"Subprogram Side Effects",
                            "href":"subprogram-side-effects.html#GUID-6C6A828F-8FA0-4278-97D2-6D5649A66A9A"
                        },
                        {
                            "title":"PL/SQL Function Result Cache",
                            "href":"pl-sql-function-result-cache.html#GUID-250BDBBB-0CD6-4D56-9DDF-6FCEDC110D00"
                        },
                        {
                            "title":"PL/SQL Functions that SQL Statements Can Invoke",
                            "href":"pl-sql-functions-that-sql-statements-can-invoke.html#GUID-4FC97312-AC30-4A6E-8337-996198191E29"
                        },
                        {
                            "title":"Invoker's Rights and Definer's Rights (AUTHID Property)",
                            "href":"invokers-rights-and-definers-rights-authid-property.html#GUID-41D23DE7-3C07-41CF-962B-F92B696594B5"
                        },
                        {
                            "title":"External Subprograms",
                            "href":"external-subprograms.html#GUID-96B5DE2B-D809-4296-9CDE-B317B81895F8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> PL/SQL Triggers",
                    "href":"plsql-triggers.html#GUID-217E8B13-29EF-45F3-8D0F-2384F9F1D231",
                    "topics":[
                        {
                            "title":"Overview of Triggers",
                            "href":"overview-triggers.html#GUID-3CD2CC67-5AC2-4DD5-B7D3-12E5FAE082C9"
                        },
                        {
                            "title":"Reasons to Use Triggers",
                            "href":"reasons-use-triggers.html#GUID-C08EA160-8FD2-4A10-9733-6F2D20C83E93"
                        },
                        {
                            "title":"DML Triggers",
                            "href":"dml-triggers.html#GUID-E76C8044-6942-4573-B7DB-3502FB96CF6F"
                        },
                        {
                            "title":"Correlation Names and Pseudorecords",
                            "href":"correlation-names-and-pseudorecords.html#GUID-4CF74E99-8859-4AB1-96E7-07898A2ABB9E"
                        },
                        {
                            "title":"System Triggers",
                            "href":"system-triggers.html#GUID-FE23FCE8-DE36-41EF-80A9-6B4B49E80E5B"
                        },
                        {
                            "title":"Subprograms Invoked by Triggers",
                            "href":"subprograms-invoked-triggers.html#GUID-E11CFB2F-064F-42EB-8390-F025564AD107"
                        },
                        {
                            "title":"Trigger Compilation, Invalidation, and Recompilation",
                            "href":"trigger-compilation-invalidation-and-recompilation.html#GUID-39111AAC-597E-4661-82A6-F3BE621F75BB"
                        },
                        {
                            "title":"Exception Handling in Triggers",
                            "href":"exception-handling-triggers.html#GUID-FA7A16B6-F94D-4E4C-A326-F602FE9FE3E8"
                        },
                        {
                            "title":"Trigger Design Guidelines",
                            "href":"trigger-design-guidelines.html#GUID-78B64011-B288-4EDD-B595-2DDBB3835ACA"
                        },
                        {
                            "title":"Trigger Restrictions",
                            "href":"trigger-restrictions.html#GUID-5B3A43E2-B9E1-4015-9A6C-0BE696853F3F"
                        },
                        {
                            "title":"Order in Which Triggers Fire",
                            "href":"order-which-triggers-fire.html#GUID-2585112C-C48F-40ED-B825-21DF975EA126"
                        },
                        {
                            "title":"Trigger Enabling and Disabling",
                            "href":"trigger-enabling-and-disabling.html#GUID-6CD799AB-FAEF-493A-8A58-2394E400072C"
                        },
                        {
                            "title":"Trigger Changing and Debugging",
                            "href":"trigger-changing-and-debugging.html#GUID-4F200DEC-9B4B-4DCC-A86D-1DB2E281A43C"
                        },
                        {
                            "title":"Triggers and Oracle Database Data Transfer Utilities",
                            "href":"triggers-and-oracle-database-data-transfer-utilities.html#GUID-F1103CD4-A84F-4440-9250-872212BDC5A9"
                        },
                        {
                            "title":"Triggers for Publishing Events",
                            "href":"triggers-publishing-events.html#GUID-2951D8A6-6C80-428F-840D-13A76A97E365"
                        },
                        {
                            "title":"Views for Information About Triggers",
                            "href":"views-information-triggers.html#GUID-F843EE28-6D46-4AA2-B3B3-7CB5485B96CE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> PL/SQL Packages",
                    "href":"plsql-packages.html#GUID-C285EC5A-BE50-4192-A88E-48C0778B34E0",
                    "topics":[
                        {
                            "title":"What is a Package?",
                            "href":"what-is-package.html#GUID-8D02540E-C697-4498-9261-848F6D4E5CB5"
                        },
                        {
                            "title":"Reasons to Use Packages",
                            "href":"reasons-use-packages.html#GUID-F2763E50-C2C6-4A4B-AEFA-103EB8529FD5"
                        },
                        {
                            "title":"Package Specification",
                            "href":"package-specification.html#GUID-85E86008-3460-4596-B43A-13D54D6E04C7"
                        },
                        {
                            "title":"Package Body",
                            "href":"package-body.html#GUID-49A935CE-825D-4FEA-BF2D-89F87EA9C750"
                        },
                        {
                            "title":"Package Instantiation and Initialization",
                            "href":"package-instantiation-and-initialization.html#GUID-5946DBAF-D010-40E4-B119-CA76FA5AFA3A"
                        },
                        {
                            "title":"Package State",
                            "href":"package-state.html#GUID-08E1FC04-9EF3-4396-83C6-4812F8ECABF4"
                        },
                        {
                            "title":"SERIALLY_REUSABLE Packages",
                            "href":"serially_reusable-packages.html#GUID-001EF960-7491-411B-A5F3-D1260A45794B"
                        },
                        {
                            "title":"Package Writing Guidelines",
                            "href":"package-writing-guidelines.html#GUID-4C39BAEB-9F20-4620-B5B0-8DDDBF783AB2"
                        },
                        {
                            "title":"Package Example",
                            "href":"package-example.html#GUID-3A313D35-26B6-4A0D-A128-231692BCBC97"
                        },
                        {
                            "title":"How STANDARD Package Defines the PL/SQL Environment",
                            "href":"how-standard-package-defines-pl-sql-environment.html#GUID-6471BE85-7F01-4218-BC6B-C945C588FEFF"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> PL/SQL Error Handling",
                    "href":"plsql-error-handling.html#GUID-0502DC1A-F0A5-4180-A912-6A5CDC855F56",
                    "topics":[
                        {
                            "title":"Compile-Time Warnings",
                            "href":"compile-time-warnings.html#GUID-3311B813-3185-4751-A3A6-309B93973366"
                        },
                        {
                            "title":"Overview of Exception Handling",
                            "href":"overview-exception-handling.html#GUID-343E0653-9BCE-48F5-A00A-795D77B96B44"
                        },
                        {
                            "title":"Internally Defined Exceptions",
                            "href":"internally-defined-exceptions.html#GUID-4F0787E6-ABCA-4860-A28E-435C7FE15154"
                        },
                        {
                            "title":"Predefined Exceptions",
                            "href":"predefined-exceptions.html#GUID-8C327B4A-71FA-4CFB-8BC9-4550A23734D6"
                        },
                        {
                            "title":"User-Defined Exceptions",
                            "href":"user-defined-exceptions.html#GUID-8844A6D8-FE6F-4DFF-B449-59AB076316C1"
                        },
                        {
                            "title":"Redeclared Predefined Exceptions",
                            "href":"redeclared-predefined-exceptions.html#GUID-C98B60A9-3931-4F8D-BE13-205A1779596D"
                        },
                        {
                            "title":"Raising Exceptions Explicitly",
                            "href":"raising-exceptions-explicitly.html#GUID-66346B68-7A18-438C-951B-A60F970D98B8"
                        },
                        {
                            "title":"Exception Propagation",
                            "href":"exception-propagation.html#GUID-A99B76C3-44DF-40E1-AB7A-454C6805B9BB"
                        },
                        {
                            "title":"Unhandled Exceptions",
                            "href":"unhandled-exceptions.html#GUID-494984A3-37E6-41BF-9BB9-05A693CD9577"
                        },
                        {
                            "title":"Retrieving Error Code and Error Message",
                            "href":"retrieving-error-code-and-error-message.html#GUID-7E0CDD98-D31C-4745-B819-B5C5E1DF90A8"
                        },
                        {
                            "title":"Continuing Execution After Handling Exceptions",
                            "href":"continuing-execution-handling-exceptions.html#GUID-E63131E7-4AE6-4C47-8D21-5EC1F6D3AA68"
                        },
                        {
                            "title":"Retrying Transactions After Handling Exceptions",
                            "href":"retrying-transactions-handling-exceptions.html#GUID-CF7B91D7-215F-48D7-AE83-240012CE8ED6"
                        },
                        {
                            "title":"Handling Errors in Distributed Queries",
                            "href":"handling-errors-distributed-queries.html#GUID-6B966875-B27C-4FDF-8334-8FB3B22ABF4A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> PL/SQL Optimization and Tuning",
                    "href":"plsql-optimization-and-tuning.html#GUID-12C08950-12A4-45F4-92F1-49B19417BCD5",
                    "topics":[
                        {
                            "title":"PL/SQL Optimizer",
                            "href":"pl-sql-optimizer.html#GUID-8BC4231B-2E5C-47D6-BE14-6D75CE14C57E"
                        },
                        {
                            "title":"Candidates for Tuning",
                            "href":"candidates-tuning.html#GUID-1640FEEA-4237-4A0D-B445-621EF2A420C6"
                        },
                        {
                            "title":"Minimizing CPU Overhead",
                            "href":"minimizing-cpu-overhead.html#GUID-C2DC6043-17CC-4F9F-934D-A075133FBD01"
                        },
                        {
                            "title":"Bulk SQL and Bulk Binding",
                            "href":"bulk-sql-and-bulk-binding.html#GUID-61D1B533-DBB9-4150-91F9-0A4C9428391E"
                        },
                        {
                            "title":"Chaining Pipelined Table Functions for Multiple Transformations",
                            "href":"chaining-pipelined-table-functions-multiple-transformations.html#GUID-ED557894-EC08-47E0-A629-0E4AEDDBB77B"
                        },
                        {
                            "title":"Overview of Polymorphic Table Functions",
                            "href":"overview-polymorphic-table-functions.html#GUID-981102A8-5204-4931-B10A-93486304B184"
                        },
                        {
                            "title":"Updating Large Tables in Parallel",
                            "href":"updating-large-tables-parallel.html#GUID-AD1BDE75-DDC1-496E-8964-CA0D41B0C76A"
                        },
                        {
                            "title":"Collecting Data About User-Defined Identifiers",
                            "href":"collecting-data-user-defined-identifiers.html#GUID-AD358676-E837-45EB-9301-36A094A3BB22"
                        },
                        {
                            "title":"Profiling and Tracing PL/SQL Programs",
                            "href":"profiling-and-tracing-pl-sql-programs.html#GUID-D99A60B1-E3ED-4252-A85C-8FA732EE9957"
                        },
                        {
                            "title":"Compiling PL/SQL Units for Native Execution",
                            "href":"compiling-pl-sql-units-native-execution.html#GUID-7C4557E7-4C35-4CAB-A95D-CB96BDC6D487"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> PL/SQL Language Elements",
                    "href":"plsql-language-elements.html#GUID-285DFAEE-1A34-4248-BA4B-2591476A0C3C",
                    "topics":[
                        {
                            "title":"ACCESSIBLE BY Clause",
                            "href":"ACCESSIBLE-BY-clause.html#GUID-9720619C-9862-4123-96E7-3E85F240FF36"
                        },
                        {
                            "title":"AGGREGATE Clause",
                            "href":"AGGREGATE-clause.html#GUID-2ED21240-E45A-4982-B674-CF0E1BE0985B"
                        },
                        {
                            "title":"Assignment Statement",
                            "href":"assignment-statement.html#GUID-4C3BEFDF-3FFA-4E9D-96D0-4C5E13E08643"
                        },
                        {
                            "title":"AUTONOMOUS_TRANSACTION Pragma",
                            "href":"AUTONOMOUS_TRANSACTION-pragma.html#GUID-AD33D949-081B-4CD3-A240-C29773E908C3"
                        },
                        {
                            "title":"Basic LOOP Statement",
                            "href":"basic-LOOP-statement.html#GUID-99AC48AC-D868-43C4-9E4D-6A7671942A39"
                        },
                        {
                            "title":"Block",
                            "href":"block.html#GUID-9ACEB9ED-567E-4E1A-A16A-B8B35214FC9D"
                        },
                        {
                            "title":"Call Specification",
                            "href":"call-specification.html#GUID-C5F117AE-E9A2-499B-BA6A-35D072575BAD"
                        },
                        {
                            "title":"CASE Statement",
                            "href":"CASE-statement.html#GUID-F4251A23-0284-4990-A156-00A92F83BC35"
                        },
                        {
                            "title":"CLOSE Statement",
                            "href":"CLOSE-statement.html#GUID-46E7086C-8C29-4689-A062-0FF059E268FD"
                        },
                        {
                            "title":"Collection Method Invocation",
                            "href":"collection-method.html#GUID-7AF1A3C4-D04B-4F91-9D7B-C92C75E3A300"
                        },
                        {
                            "title":"Collection Variable Declaration",
                            "href":"collection-variable.html#GUID-89A1863C-65A1-40CF-9392-86E9FDC21BE9"
                        },
                        {
                            "title":"Comment",
                            "href":"comment.html#GUID-E1FA7338-852E-44AA-B7BE-E8C4E746F0D5"
                        },
                        {
                            "title":"COMPILE Clause",
                            "href":"COMPILE-clause.html#GUID-FB890581-9F65-474B-9D86-6E318110AD5F"
                        },
                        {
                            "title":"Constant Declaration",
                            "href":"constant-declaration.html#GUID-C6DA65F8-3F0C-43F3-8BC6-231064E8C1B6"
                        },
                        {
                            "title":"CONTINUE Statement",
                            "href":"CONTINUE-statement.html#GUID-3ED7E5D5-E2D0-42D1-8A7F-97FFC7372775"
                        },
                        {
                            "title":"COVERAGE Pragma",
                            "href":"COVERAGE-pragma.html#GUID-38A315DC-020B-41BD-90CD-DBF4D937EE83"
                        },
                        {
                            "title":"Cursor FOR LOOP Statement",
                            "href":"cursor-FOR-LOOP-statement.html#GUID-62C9A3C8-82F9-468F-8D84-81672E67736D"
                        },
                        {
                            "title":"Cursor Variable Declaration",
                            "href":"cursor-variable-declaration.html#GUID-CE884B31-07F0-46AA-8067-EBAF73821F3D"
                        },
                        {
                            "title":"Datatype Attribute",
                            "href":"datatype-attribute.html#GUID-B4A364AB-7CC2-4B3F-AF52-09A752029C8E"
                        },
                        {
                            "title":"DEFAULT COLLATION Clause",
                            "href":"DEFAULT-COLLATION-clause.html#GUID-453FC0EA-7B83-407B-A991-87A48017B358"
                        },
                        {
                            "title":"DELETE Statement Extension",
                            "href":"DELETE-statement-extension.html#GUID-9BEEC5E0-EF77-4E88-9DD4-B9BA1EABABCF"
                        },
                        {
                            "title":"DEPRECATE Pragma",
                            "href":"DEPRECATE-pragma.html#GUID-D2DAD89D-C537-4666-A8A7-2836EB77A0E5"
                        },
                        {
                            "title":"DETERMINISTIC Clause",
                            "href":"DETERMINISTIC-clause.html#GUID-6AECC957-27CC-4334-9F43-0FBE88F92654"
                        },
                        {
                            "title":"Element Specification",
                            "href":"element-specification.html#GUID-20D95D8A-5C17-4C89-9AAB-1852CDB57CE2"
                        },
                        {
                            "title":"EXCEPTION_INIT Pragma",
                            "href":"EXCEPTION_INIT-pragma.html#GUID-873A087E-A470-4798-9152-16BC673B4940"
                        },
                        {
                            "title":"Exception Declaration",
                            "href":"exception-declaration.html#GUID-AAC8C54F-775C-4E65-B531-0350CFF5B1BD"
                        },
                        {
                            "title":"Exception Handler",
                            "href":"exception-handler.html#GUID-3FECF29B-A240-4191-A635-92C612D00C4D"
                        },
                        {
                            "title":"EXECUTE IMMEDIATE Statement",
                            "href":"EXECUTE-IMMEDIATE-statement.html#GUID-C3245A95-B85B-4280-A01F-12307B108DC8"
                        },
                        {
                            "title":"EXIT Statement",
                            "href":"EXIT-statement.html#GUID-66E20B6C-3606-42AD-A7DB-C8EC782B94D8"
                        },
                        {
                            "title":"Explicit Cursor Declaration and Definition",
                            "href":"explicit-cursor-declaration-and-definition.html#GUID-38C5DBA3-9DEC-4AF2-9B5E-7B721D11A77C"
                        },
                        {
                            "title":"Expression",
                            "href":"expression.html#GUID-D4700B45-F2C8-443E-AEE7-2BD20FFD45B8"
                        },
                        {
                            "title":"FETCH Statement",
                            "href":"FETCH-statement.html#GUID-75BC6E63-841A-4103-9B96-8AC97F5C28BB"
                        },
                        {
                            "title":"FOR LOOP Statement",
                            "href":"FOR-LOOP-statement.html#GUID-D00F8F0B-ECFC-48B6-B399-D8B5114E7E21"
                        },
                        {
                            "title":"FORALL Statement",
                            "href":"FORALL-statement.html#GUID-C45B8241-F9DF-4C93-8577-C840A25963DB"
                        },
                        {
                            "title":"Formal Parameter Declaration",
                            "href":"formal-parameter-declaration.html#GUID-5BA8E033-96B9-439A-A4FC-4844FEC14AD8"
                        },
                        {
                            "title":"Function Declaration and Definition",
                            "href":"function-declaration-and-definition.html#GUID-4E19FB09-46B5-4CE5-8A5B-CD815C29DA1C"
                        },
                        {
                            "title":"GOTO Statement",
                            "href":"GOTO-statement.html#GUID-89407985-3BA9-4508-9F1F-DE36878B4C89"
                        },
                        {
                            "title":"IF Statement",
                            "href":"IF-statement.html#GUID-B7D65A8E-B0C3-448F-B79C-6C330190A266"
                        },
                        {
                            "title":"Implicit Cursor Attribute",
                            "href":"implicit-cursor-attribute.html#GUID-5A938EE7-E8D2-468C-B60F-81898F110BE1"
                        },
                        {
                            "title":"INLINE Pragma",
                            "href":"INLINE-pragma.html#GUID-CD0EAC7A-9839-4292-9620-70EC12917021"
                        },
                        {
                            "title":"Invoker’s Rights and Definer’s Rights Clause",
                            "href":"invokers_rights_clause.html#GUID-66745CF3-81D9-491B-BD49-E83E05A5C4E4"
                        },
                        {
                            "title":"INSERT Statement Extension",
                            "href":"INSERT-statement-extension.html#GUID-D81224C4-06DE-4635-A850-41D29D4A8E1B"
                        },
                        {
                            "title":"Iterator",
                            "href":"iterator.html#GUID-BD211E6F-8B4A-494A-AECF-AC26A241FF98"
                        },
                        {
                            "title":"Named Cursor Attribute",
                            "href":"named-cursor-attribute.html#GUID-CD8D8415-FF19-4D81-99BA-7825FD40CC96"
                        },
                        {
                            "title":"NULL Statement",
                            "href":"NULL-statement.html#GUID-E4263D38-9921-426D-8C87-3EF2998F1623"
                        },
                        {
                            "title":"OPEN Statement",
                            "href":"OPEN-statement.html#GUID-FB5A9CC3-655F-4AF4-8105-14CB39F2FEA8"
                        },
                        {
                            "title":"OPEN FOR Statement",
                            "href":"OPEN-FOR-statement.html#GUID-EB7AF439-FDD3-4461-9E3F-B621E8ABFB96"
                        },
                        {
                            "title":"PARALLEL_ENABLE Clause",
                            "href":"PARALLEL_ENABLE-clause.html#GUID-CFF3C7D3-6438-44C2-9FAF-569F246C37CA"
                        },
                        {
                            "title":"PIPE ROW Statement",
                            "href":"PIPE-ROW-statement.html#GUID-AD2713A9-062A-42DD-B49E-804C6120378B"
                        },
                        {
                            "title":"PIPELINED Clause",
                            "href":"PIPELINED-clause.html#GUID-FA182210-C68D-4E03-85B9-A6C681099705"
                        },
                        {
                            "title":"Procedure Declaration and Definition",
                            "href":"procedure-declaration-and-definition.html#GUID-9A48D7CE-3720-46A4-B5CA-C2250CA86AF2"
                        },
                        {
                            "title":"Qualified Expression",
                            "href":"qualified-expression.html#GUID-1C475462-11D2-4D0B-B2D1-497491F88746"
                        },
                        {
                            "title":"RAISE Statement",
                            "href":"RAISE-statement.html#GUID-5F58843F-84C8-4768-A7B3-0E318948A88B"
                        },
                        {
                            "title":"Record Variable Declaration",
                            "href":"record-variable-declaration.html#GUID-704FC014-561E-422C-9636-EDCA3B996AAD"
                        },
                        {
                            "title":"RESETTABLE Clause",
                            "href":"RESETTABLE-clause.html#GUID-6368E63A-15C8-45D9-ACAC-624A2ABBE8A3"
                        },
                        {
                            "title":"RESTRICT_REFERENCES Pragma",
                            "href":"RESTRICT_REFERENCES-pragma.html#GUID-D189A0B4-D0D3-4951-BFC2-7D996F1659FE"
                        },
                        {
                            "title":"RESULT_CACHE Clause",
                            "href":"RESULT_CACHE-clause.html#GUID-7B0FFFDF-C953-46E5-9FD6-C41DFBDE1B0B"
                        },
                        {
                            "title":"RETURN Statement",
                            "href":"RETURN-statement.html#GUID-2DCDD1F2-041A-479C-A2F8-B3B68F50FE5D"
                        },
                        {
                            "title":"RETURNING INTO Clause",
                            "href":"RETURNING-INTO-clause.html#GUID-38F735B9-1100-45AF-AE71-18FB74A899BE"
                        },
                        {
                            "title":"%ROWTYPE Attribute",
                            "href":"ROWTYPE-attribute.html#GUID-4E0B9FE2-909D-444A-9B4A-E0243B7FCB99"
                        },
                        {
                            "title":"Scalar Variable Declaration",
                            "href":"scalar-variable-declaration.html#GUID-03124315-0E1E-4154-8EBE-12034CA6AD55"
                        },
                        {
                            "title":"SELECT INTO Statement",
                            "href":"SELECT-INTO-statement.html#GUID-6E14E04D-4344-45F3-BE80-979DD26C7A90"
                        },
                        {
                            "title":"SERIALLY_REUSABLE Pragma",
                            "href":"SERIALLY_REUSABLE-pragma.html#GUID-35B02603-B794-403C-9E0D-E40208CEAF35"
                        },
                        {
                            "title":"SHARD_ENABLE Clause",
                            "href":"SHARD_ENABLE-clause.html#GUID-D0D54BE9-5F2D-455E-AD13-9BF3220DC4BB"
                        },
                        {
                            "title":"SHARING Clause",
                            "href":"SHARING-clause.html#GUID-3C830338-8B7E-43C0-9EA0-4E292AA1A97B"
                        },
                        {
                            "title":"SQL_MACRO Clause",
                            "href":"SQL_MACRO-clause.html#GUID-292C3A17-2A4B-4EFB-AD38-68DF6380E5F7"
                        },
                        {
                            "title":"SQLCODE Function",
                            "href":"SQLCODE-function.html#GUID-1FFD7902-D22D-4505-815A-C97DDBEFB4B5"
                        },
                        {
                            "title":"SQLERRM Function",
                            "href":"SQLERRM-function.html#GUID-D4468C8F-62D9-42A5-AF72-C1098C866DC5"
                        },
                        {
                            "title":"SUPPRESSES_WARNING_6009 Pragma",
                            "href":"Supresses-warning-pragma-6009.html#GUID-5EE71954-6476-4C86-92B4-B68F50770B4E"
                        },
                        {
                            "title":"%TYPE Attribute",
                            "href":"TYPE-attribute.html#GUID-EAB44F7E-B2AB-4AC6-B83D-B586193D75FC"
                        },
                        {
                            "title":"UDF Pragma",
                            "href":"UDF-pragma.html#GUID-D3AC7A45-66E9-4D9E-BC8B-5DCD7CE84E7C"
                        },
                        {
                            "title":"UPDATE Statement Extensions",
                            "href":"UPDATE-statement-extensions.html#GUID-8FA29ACC-5E0F-4BE1-BC33-2B882C87E36D"
                        },
                        {
                            "title":"WHILE LOOP Statement",
                            "href":"WHILE-LOOP-statement.html#GUID-9339C3AD-7F41-4D3F-9B2D-6FC5DCE44C6B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> SQL Statements for Stored PL/SQL Units",
                    "href":"sql-statements-for-stored-plsql-units.html#GUID-C918310F-F1BB-41D7-9466-B558B70DDFFE",
                    "topics":[
                        {
                            "title":"ALTER FUNCTION Statement",
                            "href":"ALTER-FUNCTION-statement.html#GUID-C78E0E7E-6BCF-4AE8-8C75-9F133E8FB4E1"
                        },
                        {
                            "title":"ALTER LIBRARY Statement",
                            "href":"ALTER-LIBRARY-statement.html#GUID-8F479CDD-5D74-48C6-9508-6AA19B210627"
                        },
                        {
                            "title":"ALTER PACKAGE Statement",
                            "href":"ALTER-PACKAGE-statement.html#GUID-61273667-8D8F-4E79-9D81-072CFFE3A7F1"
                        },
                        {
                            "title":"ALTER PROCEDURE Statement",
                            "href":"ALTER-PROCEDURE-statement.html#GUID-17EAA51A-308B-4DA3-856C-DA5C4480AAA9"
                        },
                        {
                            "title":"ALTER TRIGGER Statement",
                            "href":"ALTER-TRIGGER-statement.html#GUID-BC319647-2D94-46D1-BF69-16CDFB507725"
                        },
                        {
                            "title":"ALTER TYPE Statement",
                            "href":"ALTER-TYPE-statement.html#GUID-A8B449E7-E3A8-48F4-A4C6-5BB87B1841CD"
                        },
                        {
                            "title":"CREATE FUNCTION Statement",
                            "href":"CREATE-FUNCTION-statement.html#GUID-B71BC5BD-B87C-4054-AAA5-213E856651F2"
                        },
                        {
                            "title":"CREATE LIBRARY Statement",
                            "href":"CREATE-LIBRARY-statement.html#GUID-869376E5-013B-4853-8278-0133C97BB233"
                        },
                        {
                            "title":"CREATE PACKAGE Statement",
                            "href":"CREATE-PACKAGE-statement.html#GUID-03A70A54-90FF-4293-B6B8-F0B35E184AC5"
                        },
                        {
                            "title":"CREATE PACKAGE BODY Statement",
                            "href":"CREATE-PACKAGE-BODY-statement.html#GUID-68526FF2-96A1-4F14-A10B-4DD3E1CD80BE"
                        },
                        {
                            "title":"CREATE PROCEDURE Statement",
                            "href":"CREATE-PROCEDURE-statement.html#GUID-5F84DB47-B5BE-4292-848F-756BF365EC54"
                        },
                        {
                            "title":"CREATE TRIGGER Statement",
                            "href":"CREATE-TRIGGER-statement.html#GUID-AF9E33F1-64D1-4382-A6A4-EC33C36F237B"
                        },
                        {
                            "title":"CREATE TYPE Statement",
                            "href":"CREATE-TYPE-statement.html#GUID-389D603D-FBD0-452A-8414-240BBBC57034"
                        },
                        {
                            "title":"CREATE TYPE BODY Statement",
                            "href":"CREATE-TYPE-BODY-statement.html#GUID-B468D6FB-75ED-436B-80E4-8460E4551AE0"
                        },
                        {
                            "title":"DROP FUNCTION Statement",
                            "href":"DROP-FUNCTION-statement.html#GUID-415FF998-4B2D-48AA-9275-465B17952280"
                        },
                        {
                            "title":"DROP LIBRARY Statement",
                            "href":"DROP-LIBRARY-statement.html#GUID-F892A88E-DCEE-4FB7-9FF9-57B449172F8C"
                        },
                        {
                            "title":"DROP PACKAGE Statement",
                            "href":"DROP-PACKAGE-statement.html#GUID-91CB731B-471A-409B-A22B-4C1AF9E5903B"
                        },
                        {
                            "title":"DROP PROCEDURE Statement",
                            "href":"DROP-PROCEDURE-statement.html#GUID-A66E96E6-A582-4A59-B97E-8E6EA52EC292"
                        },
                        {
                            "title":"DROP TRIGGER Statement",
                            "href":"DROP-TRIGGER-statement.html#GUID-C664FDA9-656B-49D4-A86D-D08B615137E9"
                        },
                        {
                            "title":"DROP TYPE Statement",
                            "href":"DROP-TYPE-statement.html#GUID-EDB83D12-26B5-42D1-9DB6-BD8AAB6490EC"
                        },
                        {
                            "title":"DROP TYPE BODY Statement",
                            "href":"DROP-TYPE-BODY-statement.html#GUID-4668B4DD-213D-452A-8706-F27D36C03D3C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> PL/SQL Source Text Wrapping",
                    "href":"plsql-source-text-wrapping.html#GUID-AB6FFBAD-DE20-4197-A885-AF81F3766FA2",
                    "topics":[
                        {
                            "title":"PL/SQL Source Text Wrapping Limitations",
                            "href":"pl-sql-source-text-wrapping-limitations.html#GUID-C37788E2-0F5D-430B-8D9C-6CD708223C93"
                        },
                        {
                            "title":"PL/SQL Source Text Wrapping Guidelines",
                            "href":"pl-sql-source-text-wrapping-guidelines.html#GUID-95FE6D1A-8D8E-4F26-949C-D5583F8D4E2A"
                        },
                        {
                            "title":"Wrapping PL/SQL Source Text with PL/SQL Wrapper Utility",
                            "href":"wrapping-pl-sql-source-text-pl-sql-wrapper-utility.html#GUID-4C024F24-F054-4E11-BCAD-ACA9D6B745D2"
                        },
                        {
                            "title":"Wrapping PL/SQL Source Text with DBMS_DDL Subprograms",
                            "href":"wrapping-pl-sql-source-text-dbms_ddl-subprograms.html#GUID-16C5FD7F-622B-42F6-A75B-C328C0CE3ACE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> PL/SQL Name Resolution",
                    "href":"plsql-name-resolution.html#GUID-7A77C7A5-F6BE-49F4-A398-EDD8646CE2C9",
                    "topics":[
                        {
                            "title":"Qualified Names and Dot Notation",
                            "href":"qualified-names-and-dot-notation.html#GUID-688FB948-E8F0-4294-B2DF-4C281BCD366C"
                        },
                        {
                            "title":"Column Name Precedence",
                            "href":"column-name-precedence.html#GUID-A551A39D-7DF8-4525-BE0F-1F46FE04ED09"
                        },
                        {
                            "title":"Differences Between PL/SQL and SQL Name Resolution Rules",
                            "href":"differences-pl-sql-and-sql-name-resolution-rules.html#GUID-848E544F-7C7A-41F6-BFDC-BBEC58DC6F24"
                        },
                        {
                            "title":"Resolution of Names in Static SQL Statements",
                            "href":"resolution-names-static-sql-statements.html#GUID-0D18B5E5-A6F7-45B7-A1FA-F7D930C6999C"
                        },
                        {
                            "title":"What is Capture?",
                            "href":"what-is-capture.html#GUID-6471F04B-7872-4D88-B72D-8B46448B29EB"
                        },
                        {
                            "title":"Avoiding Inner Capture in SELECT and DML Statements",
                            "href":"avoiding-inner-capture-select-and-dml-statements.html#GUID-5B50488D-CF48-4A77-BD75-96D62EDF4BBE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> PL/SQL Program Limits",
                    "href":"plsql-program-limits.html#GUID-00966B4C-B9A5-47D4-94AA-54AEBCC07CE9"
                },
                {
                    "title":"<span class=\"secnum\">D </span> PL/SQL Reserved Words and Keywords",
                    "href":"plsql-reserved-words-keywords.html#GUID-9BAA3A99-41B1-45CB-A91E-1E482BC1F927"
                },
                {
                    "title":"<span class=\"secnum\">E </span> PL/SQL Predefined Data Types",
                    "href":"plsql-predefined-data-types.html#GUID-1D28B7B6-15AE-454A-8134-F8724551AE8B"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});