define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"About the REST APIs",
                    "href":"index.html"
                },
                {
                    "title":"All REST Endpoints",
                    "href":"rest-endpoints.html"
                }
            ]
        },
        {
            "heading":"Get Started",
            "topics":[
                {
                    "title":"Quick Start",
                    "href":"QuickStart.html"
                },
                {
                    "title":"Supported Methods",
                    "href":"supported-methods.html"
                },
                {
                    "title":"Status Codes",
                    "href":"Status-Codes.html"
                },
                {
                    "title":"Authentication",
                    "href":"Authentication.html"
                },
                {
                    "title":"Testing the REST APIs",
                    "href":"Testing.html",
                    "topics":[
                        {
                            "title":"Install cURL",
                            "href":"InstallcURL.html"
                        },
                        {
                            "title":"Use cURL",
                            "href":"Use-cURL.html"
                        }
                    ]
                }
            ]
        },
        {
            "heading":"Tasks",
            "topics":[
                {
                    "title":"GeoRaster API",
                    "topics":[
                        {
                            "title":"Data Access",
                            "href":"api-georaster-api-data-access.html",
                            "topics":[
                                {
                                    "title":"Get a GeoRaster Object",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-get.html"
                                },
                                {
                                    "title":"Get GeoRaster Object Cell Values",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-cellvalues-get.html"
                                },
                                {
                                    "title":"Get GeoRaster Object Metadata",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-metadata-get.html"
                                },
                                {
                                    "title":"Get Raster Data in Image Format 1",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-rasterimage-get.html"
                                },
                                {
                                    "title":"Get Raster Data in Image Format 2",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-rasterimage-post.html"
                                },
                                {
                                    "title":"Get Raster Data in Raw Data Format",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-rasterdata-post.html"
                                },
                                {
                                    "title":"Initiate a GeoRaster Object",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-put.html"
                                },
                                {
                                    "title":"List GeoRaster Objects",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-get.html"
                                },
                                {
                                    "title":"List GeoRaster Tables",
                                    "href":"op-server-georaster-v1-datasource-get.html"
                                },
                                {
                                    "title":"Update GeoRaster Object Metadata",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-metadata-put.html"
                                }
                            ]
                        },
                        {
                            "title":"Data Processing",
                            "href":"api-georaster-api-data-processing.html",
                            "topics":[
                                {
                                    "title":"Execute SDO_GEOR Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor-functionname-post.html"
                                },
                                {
                                    "title":"Execute SDO_GEOR_ADMIN Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_admin-functionname-post.html"
                                },
                                {
                                    "title":"Execute SDO_GEOR_AGGR Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_aggr-functionname-post.html"
                                },
                                {
                                    "title":"Execute SDO_GEOR_IP Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_ip-functionname-post.html"
                                },
                                {
                                    "title":"Execute SDO_GEOR_RA Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_ra-functionname-post.html"
                                },
                                {
                                    "title":"Execute SDO_GEOR_UTL Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_utl-functionname-post.html"
                                },
                                {
                                    "title":"List SDO_GEOR Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor-get.html"
                                },
                                {
                                    "title":"List SDO_GEOR_ADMIN Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_admin-get.html"
                                },
                                {
                                    "title":"List SDO_GEOR_AGGR Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_aggr-get.html"
                                },
                                {
                                    "title":"List SDO_GEOR_IP Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_ip-get.html"
                                },
                                {
                                    "title":"List SDO_GEOR_RA Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_ra-get.html"
                                },
                                {
                                    "title":"List SDO_GEOR_UTL Package Functions",
                                    "href":"op-server-georaster-v1-datasource-sdo_geor_utl-get.html"
                                }
                            ]
                        },
                        {
                            "title":"Import and Export",
                            "href":"api-georaster-api-import-and-export.html",
                            "topics":[
                                {
                                    "title":"Create an Export Job",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-format-get.html"
                                },
                                {
                                    "title":"Create an Import Job",
                                    "href":"op-server-georaster-v1-datasource-tablename-georastercolumnname-rdt-rid-put.html"
                                },
                                {
                                    "title":"Delete an Import/Export Job",
                                    "href":"op-server-georaster-v1-datasource-jobs-id-delete.html"
                                },
                                {
                                    "title":"Get the Status of an Import/Export Job",
                                    "href":"op-server-georaster-v1-datasource-jobs-id-get.html"
                                },
                                {
                                    "title":"List GeoRaster Import/Export Jobs",
                                    "href":"op-server-georaster-v1-datasource-jobs-get.html"
                                }
                            ]
                        },
                        {
                            "title":"Virtual Mosaic",
                            "href":"api-georaster-api-virtual-mosaic.html",
                            "topics":[
                                {
                                    "title":"Create a Virtual Mosaic",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-put.html"
                                },
                                {
                                    "title":"Delete a Virtual Mosaic",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-delete.html"
                                },
                                {
                                    "title":"Get the Definition of a Virtual Mosaic",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-get.html"
                                },
                                {
                                    "title":"Get the Statistics of a Virtual Mosaic",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-statistics-get.html"
                                },
                                {
                                    "title":"Get Virtual Mosaic Data in Image Format",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-rasterimage-post.html"
                                },
                                {
                                    "title":"Get Virtual Mosaic Data in RAW Data Format",
                                    "href":"op-server-georaster-v1-datasource-vm-virtualmosaicname-rasterdata-post.html"
                                },
                                {
                                    "title":"List Virtual Mosaics",
                                    "href":"op-server-georaster-v1-datasource-vm-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"NDM Contraction Hierarchies API",
                    "topics":[
                        {
                            "title":"Analysis",
                            "href":"api-ndm-contraction-hierarchies-api-analysis.html",
                            "topics":[
                                {
                                    "title":"Generate NDM Network Buffer in database",
                                    "href":"op-https-localhost-7011-chrest-v1-analysis-networkbuffer-post.html"
                                },
                                {
                                    "title":"Post an analysis reqeust on a contraction hierarchy",
                                    "href":"op-https-localhost-7011-chrest-v1-analysis-post.html"
                                }
                            ]
                        },
                        {
                            "title":"Configuration",
                            "href":"api-ndm-contraction-hierarchies-api-configuration.html",
                            "topics":[
                                {
                                    "title":"Get available contraction hierarchy networks",
                                    "href":"op-https-localhost-7011-chrest-v1-configuration-networks-get.html"
                                },
                                {
                                    "title":"Post a configuration of a contraction hierarchy",
                                    "href":"op-https-localhost-7011-chrest-v1-configuration-post.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});