define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Audience",
                            "href":"audience.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"do-not-use-shared-global-topic-conventions.html"
                        }
                    ]
                },
                {
                    "title":"Part I Understanding Oracle Net Services",
                    "href":"understanding-oracle-net-services.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> Introducing Oracle Net Services",
                            "href":"introducing-oracle-net-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1 </span> About Oracle Net Services",
                                    "href":"oracle-net-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">1.1.1 </span> Understanding Connectivity",
                                            "href":"understanding-connectivity.html#GUID-C4E85051-5B08-4442-8DDA-25B1E684BF1E"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.2 </span> Understanding Manageability",
                                            "href":"understanding-manageability.html#GUID-80113BBB-D5A3-4743-BF97-F4614DABD1EB"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.3 </span> Understanding Shared Server Architecture",
                                            "href":"understanding-shared-server-architecture.html#GUID-EF83D698-AD84-47FB-BFF5-5E83704403B9"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.4 </span> Understanding Performance",
                                            "href":"understanding-performance.html#GUID-4467A33C-A20A-4E63-B6CD-6ABA2B6A1569"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.5 </span> Understanding Network Security",
                                            "href":"understanding-network-security.html#GUID-1323916D-4748-4E73-8A6C-7B0167D50702"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">1.2 </span> Understanding Database Instances",
                                    "href":"understanding-database-instances.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.3 </span> Components of Oracle Net Services",
                                    "href":"components-oracle-net-services.html#GUID-391ADF28-94D9-45CD-9AC3-284A6FF6EE1C"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> Identifying and Accessing the Database",
                            "href":"identifying-and-accessing-database.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1 </span> Understanding Database Instances",
                                    "href":"understanding-database-instances.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2 </span> Understanding Database Services",
                                    "href":"understanding-database-services.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3 </span> Connecting to a Database Service",
                                    "href":"connecting-database-service.html#GUID-2BDF9E52-4147-4F46-84E2-A5AE1018A373"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.4 </span> Understanding Service Handlers",
                                    "href":"understanding-service-handlers.html#GUID-8436D29C-A65C-43C3-B632-7B5550B128C2"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.5 </span> Understanding Naming Methods",
                                    "href":"understanding-naming-methods.html#GUID-E14B3391-F5CE-46E7-B63B-6B74B7CEB4D9"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6 </span> Enhancing Service Accessibility Using Multiple Listeners",
                                    "href":"enhancing-service-accessibility-using-multiple-listeners.html#GUID-2520CEEE-D08C-419C-BA9A-8D7D1CFD2221"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3 </span> Managing Network Address Information",
                            "href":"managing-network-address-information.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1 </span> Using Localized Management",
                                    "href":"using-localized-management.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2 </span> Using a Directory Server for Centralized Management",
                                    "href":"using-directory-server-centralized-management.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.2.1 </span> Understanding the Directory Information Tree",
                                            "href":"understanding-directory-information-tree.html#GUID-3299F3D3-8ED8-4251-A3D0-261684AB9429"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.2 </span> Understanding Oracle Context",
                                            "href":"understanding-oracle-context.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.3 </span> Understanding Net Service Alias Entries",
                                            "href":"understanding-net-service-alias-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.4 </span> Who Can Add or Modify Entries in the Directory Server",
                                            "href":"who-can-add-or-modify-entries-directory-server.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.5 </span> Client Connections Using Directory Naming",
                                            "href":"client-connections-using-directory-naming.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.6 </span> Considerations When Using Directory Servers",
                                            "href":"considerations-when-using-directory-servers.html#GUID-DC8FF206-D90C-4634-9D31-68F972D811B5"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.7 </span> Limitations of Directory Naming Support with Microsoft Active Directory",
                                            "href":"limitations-directory-naming-support-microsoft-active-directory.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> Understanding the Communication Layers",
                            "href":"understanding-communication-layers.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1 </span> Understanding Oracle Net Stack Communication for Client/Server Applications",
                                    "href":"understanding-oracle-net-stack-communication-client-server-applications.html#GUID-CC082D31-FA89-4905-99DA-B507FB1B52F7"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2 </span> Using Oracle Net Stack Communication for Java Applications",
                                    "href":"using-oracle-net-stack-communication-java-applications.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3 </span> Using Oracle Net Stack Communication for Web Clients",
                                    "href":"using-oracle-net-stack-communication-web-clients.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4 </span> Understanding Oracle Protocol Support Layer",
                                    "href":"understanding-oracle-protocol-support-layer.html#GUID-A3C83EA0-97D7-4F90-98D8-3200AFB9495C"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5 </span> Understanding Oracle Net Architecture",
                            "href":"understanding-oracle-net-architecture.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1 </span> About Service Registration",
                                    "href":"service-registration1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2 </span> About the Listener and Connection Requests",
                                    "href":"listener-and-connection-requests.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3 </span> About Oracle Restart",
                                    "href":"oracle-restart.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.4 </span> About Blocked Connection Requests",
                                    "href":"blocked-connection-requests.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.5 </span> Understanding Database Server Process Architecture",
                                    "href":"understanding-database-server-process-architecture.html#GUID-AEF383D2-FF3D-4284-ABE4-119B4C7439C2"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.6 </span> Understanding Oracle Connection Manager Architecture",
                                    "href":"understanding-oracle-connection-manager-architecture.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.7 </span> Complete Architecture",
                                    "href":"complete-architecture.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.8 </span> Reverse Connection Using CMAN Tunnels",
                                    "href":"reverse-connection-using-cman-tunnels.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part II Configuration and Administration of Oracle Net Services",
                    "href":"configuration-and-administration-oracle-net-services.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6 </span> Quick Start to Oracle Net Services",
                            "href":"quick-start-oracle-net-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1 </span> Prerequisites for Establishing Connectivity",
                                    "href":"prerequisites-establishing-connectivity.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2 </span> Confirming Network Availability",
                                    "href":"confirming-network-availability.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.3 </span> Starting Oracle Net Listener and the Oracle Database Server",
                                    "href":"starting-oracle-net-listener-and-oracle-database-server.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.4 </span> Starting Oracle Connection Manager",
                                    "href":"starting-oracle-connection-manager.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.5 </span> Using Easy Connect to Connect to a Database",
                                    "href":"using-easy-connect-connect-database.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.6 </span> Viewing Connection Strings Using the connstr Utility",
                                    "href":"viewing-connection-strings-using-connstr-utility.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.7 </span> Connecting to the Database",
                                    "href":"connecting-database.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7 </span> Managing Oracle Net Services",
                            "href":"managing-oracle-net-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1 </span> Using the User Interface Tools",
                                    "href":"using-user-interface-tools.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">7.1.1 </span> Using Oracle Enterprise Manager Cloud Control to Configure Oracle Net Services",
                                            "href":"using-oracle-enterprise-manager-cloud-control-configure-oracle-net-services.html#GUID-697E4B64-854C-49BB-B287-C2B4C57F987F"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">7.1.2 </span> Using Oracle Net Manager to Configure Oracle Net Services",
                                            "href":"using-oracle-net-manager-configure-oracle-net-services.html#GUID-2294BF67-B05F-44A2-9584-6CF0855A0F56"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">7.1.3 </span> Deciding When to Use Oracle Enterprise Manager Cloud Control and Oracle Net Manager",
                                            "href":"deciding-when-use-oracle-enterprise-manager-cloud-control-and-oracle-net-manager.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">7.1.4 </span> Using Oracle Net Configuration Assistant to Configure Network Components",
                                            "href":"using-oracle-net-configuration-assistant-configure-network-components.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2 </span> About the OracleNetAdmins Group",
                                    "href":"oraclenetadmins-group.html#GUID-FFF9F681-DE35-4778-8368-B028B1FF0431"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3 </span> Using Listener Control Utility to Administer the Listener",
                                    "href":"using-listener-control-utility-administer-listener.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.4 </span> Performing Common Network Tasks",
                                    "href":"performing-common-network-tasks.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8 </span> Configuring Naming Methods",
                            "href":"configuring-naming-methods.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1 </span> Configuring the Local Naming Method",
                                    "href":"configuring-local-naming-method.html#GUID-D62B85C0-D3C1-4C5C-A9DF-C12DFB21C533"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2 </span> Configuring the Directory Naming Method",
                                    "href":"configuring-directory-naming-method.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.2.1 </span> Configure Net Service Name, Database Service, and Alias Entries",
                                            "href":"configure-net-service-name-database-service-and-alias-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.2 </span> Create Multiple Default Contexts in a Directory Naming Server",
                                            "href":"create-multiple-default-contexts-directory-naming-server.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.3 </span> Export Local Naming Entries to a Directory Naming Server",
                                            "href":"export-local-naming-entries-directory-naming-server.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.4 </span> Configure the LDAP Naming Adapter to Use Wallets",
                                            "href":"configure-ldap-naming-adapter-use-wallets.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5 </span> Specify LDAP Parameters Directly in a Connect Identifier",
                                            "href":"specify-ldap-parameters-directly-connect-identifier.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.6 </span> Export Directory Naming Entries to the tnsnames.ora file",
                                            "href":"export-directory-naming-entries-tnsnames-ora-file.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3 </span> Configuring the Centralized Configuration Provider Naming Method",
                                    "href":"configuring-centralized-configuration-provider-naming-method.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.1 </span> Azure App Configuration Store",
                                            "href":"azure-app-configuration-store.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.1 </span> Prerequisites for Using the Azure App Configuration Store",
                                                    "href":"prerequisites-using-azure-app-configuration-store.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.2 </span> Step 1: Create a Key-Value with the Connect Descriptor",
                                                    "href":"step-1-create-key-value-connect-descriptor.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.3 </span> Step 2: Add the User Name and Password Vault Reference (Optional)",
                                                    "href":"step-2-add-database-username-and-password-vault-reference-optional1.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.4 </span> Step 3: Add the Wallet Vault Reference (Optional)",
                                                    "href":"step-3-add-wallet-vault-reference-optional1.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.5 </span> Step 4: Add Oracle Call Interface Parameters (Optional)",
                                                    "href":"step-4-add-oracle-call-interface-parameters-optional1.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.1.6 </span> Step 5: Use a Connect Identifier Containing Azure App Configuration Store Values",
                                                    "href":"step-5-use-connect-identifier-containing-azure-configuration-store-values.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2 </span> OCI Object Storage JSON File",
                                            "href":"oci-object-storage-json-file.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.1 </span> Prerequisites for Using the OCI Object Storage JSON File",
                                                    "href":"prerequisites-using-oci-object-storage-json-file.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.2 </span> Step 1: Create a JSON file with the Connect Descriptor",
                                                    "href":"step-1-create-json-file-connect-descriptor.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.3 </span> Step 2: Add the User Name and Password Vault Reference (Optional)",
                                                    "href":"step-2-add-database-username-and-password-vault-reference-optional.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.4 </span> Step 3: Add the Wallet Vault Reference (Optional)",
                                                    "href":"step-3-add-wallet-vault-reference-optional.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.5 </span> Step 4: Add Oracle Call Interface Parameters (Optional)",
                                                    "href":"step-4-add-oracle-call-interface-parameters-optional.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">8.3.2.6 </span> Step 5: Use a Connect Identifier Containing OCI Object Storage Values",
                                                    "href":"step-5-use-connect-identifier-containing-oci-object-storage-values.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4 </span> Configuring the Easy Connect Naming Method",
                                    "href":"configuring-easy-connect-naming-method.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.4.1 </span> Understanding the Easy Connect Naming Method",
                                            "href":"understanding-easy-connect-naming-method.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.4.2 </span> Support for Easy Connect Plus",
                                            "href":"support-easy-connect-plus.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.4.3 </span> Examples of Easy Connect Naming Method",
                                            "href":"examples-easy-connect-naming-method.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.4.4 </span> Configuring Easy Connect Naming on the Client",
                                            "href":"configuring-easy-connect-naming-client.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.4.5 </span> Configuring Easy Connect Naming to Use a DNS Alias",
                                            "href":"configuring-easy-connect-naming-use-dns-alias.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9 </span> Configuring and Administering Oracle Net Listener",
                            "href":"configuring-and-administering-oracle-net-listener.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.1 </span> Overview of Oracle Net Listener",
                                    "href":"overview-oracle-net-listener.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.2 </span> Configuring Dynamic Service Registration",
                                    "href":"configuring-dynamic-service-registration.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">9.2.1 </span> Setting Initialization Parameters for Service Registration",
                                            "href":"setting-initialization-parameters-service-registration.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.2 </span> Registering Information with a Local Listener",
                                            "href":"registering-information-local-listener.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.3 </span> Registering Information with a Remote Listener",
                                            "href":"registering-information-remote-listener.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.4 </span> Registering Information with All Listeners in a Network",
                                            "href":"registering-information-all-listeners-network.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.5 </span> Configuring a Naming Method",
                                            "href":"configuring-naming-method.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">9.3 </span> Configuring Oracle Net Listener During Installation",
                                    "href":"configuring-oracle-net-listener-installation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.4 </span> Customizing Oracle Net Listener Configuration",
                                    "href":"customizing-oracle-net-listener-configuration.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">9.4.1 </span> Configuring Listening Protocol Addresses",
                                            "href":"configuring-listening-protocol-addresses.html#GUID-B16FD816-5871-4AD7-86D1-55DDD8531322"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.4.2 </span> Handling Large Volumes of Concurrent Connection Requests",
                                            "href":"handling-large-volumes-concurrent-connection-requests.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.4.3 </span> Managing Oracle Net Listener Security",
                                            "href":"managing-oracle-net-listener-security.html#GUID-FD3EC78A-3430-4DB7-8222-8C0DB2B326AD"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">9.5 </span> Administering the Listener",
                                    "href":"administering-listener.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">9.5.1 </span> Starting and Stopping a Listener",
                                            "href":"starting-and-stopping-listener.html#GUID-CF3D3974-B170-4FB1-8850-6A083CBC7917"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.5.2 </span> Managing a Listener in an Oracle Restart Configuration",
                                            "href":"managing-listener-oracle-restart-configuration.html#GUID-623EC4F3-A129-4265-B5E9-14CC2B6DCC84"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.5.3 </span> Determining the Current Status of a Listener",
                                            "href":"determining-current-status-listener.html#GUID-98FBD991-DBAA-4F3D-B866-C12E13BE9645"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.5.4 </span> Monitoring Services of a Listener",
                                            "href":"monitoring-services-listener.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.5.5 </span> Monitoring Service Registration Operations",
                                            "href":"monitoring-service-registraton-operations.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.5.6 </span> Monitoring Listener Log Files",
                                            "href":"monitoring-listener-log-files.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">9.6 </span> Understanding Listener Redirects",
                                    "href":"understanding-listener-redirects.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10 </span> Configuring and Administering Oracle Connection Manager",
                            "href":"configuring-oracle-connection-manager.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1 </span> Setting Up Oracle Connection Manager",
                                    "href":"setting-oracle-connection-manager.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.1 </span> About the cman.ora File",
                                            "href":"cman-ora-file.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.2 </span> Configuring the cman.ora file for the Oracle Connection Manager Host",
                                            "href":"configuring-cman-ora-file-oracle-connection-manager-host.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.3 </span> Configuring Transport Layer Security on Oracle Connection Manager",
                                            "href":"configuring-transport-layer-security-oracle-connection-manager.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.4 </span> Enabling Access Control",
                                            "href":"enabling-access-control.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.5 </span> Configuring Clients for Oracle Connection Manager",
                                            "href":"configuring-clients-oracle-connection-manager.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.6 </span> Configuring the Oracle Database Server for Oracle Connection Manager",
                                            "href":"configuring-oracle-database-server-oracle-connection-manager.html#GUID-FC03FA50-05E7-4A38-972B-242DF9E40392"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.2 </span> Configuring Oracle Connection Manager in Traffic Director Mode",
                                    "href":"configuring-oracle-connection-manager-traffic-director-mode.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.2.1 </span> About Oracle Connection Manager in Traffic Director Mode",
                                            "href":"oracle-connection-manager-traffic-director-mode.html#GUID-18E96DB7-00D4-44C6-B541-0B61B488A2DF"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.2 </span> Configuring cman.ora File for Oracle Connection Manager in Traffic Director Mode",
                                            "href":"configuring-cman-ora-file-oracle-connection-manager-traffic-director-mode.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.3 </span> Configuring a Wallet for Oracle Connection Manager in Traffic Director Mode Proxy Authentication",
                                            "href":"configuring-wallet-oracle-connection-manager-traffic-director-mode-proxy-authentication.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.4 </span> Enabling Oracle Connection Manager in Traffic Director Mode to Use External Password Store",
                                            "href":"enabling-oracle-connection-manager-traffic-director-mode-use-external-password-store.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.5 </span> Configuring Databases for Oracle Connection Manager in Traffic Director Mode Proxy Authentication",
                                            "href":"configuring-databases-oracle-connection-manager-traffic-director-mode-proxy-authentication.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.6 </span> Configuring Service Registration with Oracle Connection Manager in Traffic Director Mode",
                                            "href":"configuring-service-registration-oracle-connection-manager-traffic-director-mode.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.7 </span> Configuring Proxy Resident Connection Pooling in Oracle Connection Manager in Traffic Director Mode",
                                            "href":"configuring-proxy-resident-connection-pool-oracle-connection-manager-traffic-director-mode.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.8 </span> Configuring Oracle Connection Manager in Traffic Director Mode for Unplanned Events",
                                            "href":"configuring-oracle-connection-manager-traffic-director-mode-unplanned-events.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.9 </span> Configuring Oracle Connection Manager in Traffic Director Mode for Planned Down Events",
                                            "href":"configuring-oracle-connection-manager-traffic-director-mode-planned-events.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.10 </span> Configuring Oracle Connection Manager in Traffic Director Mode for Service Affinity",
                                            "href":"configuring-oracle-connection-manager-traffic-director-mode-service-affinity.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.11 </span> Configuring Transport Layer Security on Oracle Connection Manager in Traffic Director Mode",
                                            "href":"configuring-transport-layer-security-oracle-connection-manager-traffic-director-mode.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.2.12 </span> Oracle Connection Manager in Traffic Director Mode Restrictions",
                                            "href":"oracle-connection-manager-traffic-director-mode-restrictions.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.3 </span> Configuring Oracle Connection Manager in Tunneling Mode for Reverse Connection",
                                    "href":"configuring-oracle-connection-manager-tunneling-mode-reverse-connection.html#GUID-C086480F-411B-46E7-9248-F62E2625D42D"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4 </span> Using Oracle Connection Manager as a Bridge for IPv4 and IPv6",
                                    "href":"using-oracle-connection-manager-bridge-ipv4-and-ipv6.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.5 </span> Using Oracle Connection Manager to Prevent Denial-of-Service Attacks",
                                    "href":"using-oracle-connection-manager-prevent-denial-service-attacks.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.6 </span> Starting and Stopping Oracle Connection Manager",
                                    "href":"using-oracle-connection-manager-control-utility-administer-oracle-connection-manager.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7 </span> About CMCTL REST Interface",
                                    "href":"cmctl-rest-interface.html#GUID-D82AD9B1-E959-4183-9C8A-CA80578E5CC6"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.8 </span> Migrating CMAN Sessions During Patching",
                                    "href":"migrating-cman-sessions-patching.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.9 </span> Oracle Connection Manager Enhancements",
                                    "href":"oracle-connection-manager-enhancements.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11 </span> Configuring a Shared Server Architecture",
                            "href":"configuring-shared-server-architecture.html#GUID-CAF99423-AFB9-4141-A36B-5EAF6B2CA7C0"
                        },
                        {
                            "title":"<span class=\"secnum\">12 </span> Configuring Profiles",
                            "href":"configuring-profiles.html#GUID-85BF0B4A-9FD2-4A74-8107-F5B6693A5747"
                        },
                        {
                            "title":"<span class=\"secnum\">13 </span> Enabling Advanced Features of Oracle Net Services",
                            "href":"enabling-advanced-features-oracle-net-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.1 </span> Configuring Advanced Network Address and Connect Data Information",
                                    "href":"configuring-advanced-network-address-and-connect-data-information.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.1.1 </span> Creating a List of Listener Protocol Addresses",
                                            "href":"creating-list-listener-protocol-addresses.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.1.2 </span> About the Address List Parameters",
                                            "href":"address-list-parameters.html#GUID-39241458-E9E1-4B4C-99FD-48975F307239"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.1.3 </span> About the Advanced Connect Data Parameters",
                                            "href":"advanced-connect-data-parameters.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2 </span> Understanding Connection Load Balancing",
                                    "href":"understanding-connection-load-balancing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.2.1 </span> Example of Connection Load Balancing for Shared Server Configuration",
                                            "href":"example-connection-load-balancing-shared-server-configuration.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.2.2 </span> Example of Connection Load Balancing for Dedicated Server Configuration",
                                            "href":"example-connection-load-balancing-dedicated-server-configuration.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.2.3 </span> COLOCATION_TAG of Client Connections",
                                            "href":"colocation_tag-client-connections.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">13.3 </span> Configuring Transparent Application Failover",
                                    "href":"configuring-transparent-application-failover.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.3.1 </span> About Transparent Application Failover",
                                            "href":"transparent-application-failover.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.3.2 </span> What Transparent Application Failover Restores",
                                            "href":"what-transparent-application-failover-restores.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.3.3 </span> About the FAILOVER_MODE Parameters",
                                            "href":"failover_mode-parameters.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.3.4 </span> Implementing Transparent Application Failover",
                                            "href":"implementing-transparent-application-failover.html#GUID-466CD611-155F-4DD6-9E6C-0A8E6A58B796"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.3.5 </span> Verifying Transparent Application Failover",
                                            "href":"verifying-transparent-application-failover.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">13.4 </span> Specifying the Instance Role for Primary and Secondary Instance Configurations",
                                    "href":"specifying-instance-role-primary-and-secondary-instance-configurations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.5 </span> Configuring Static Service Registration",
                                    "href":"configuring-static-service-registration.html#GUID-0203C8FA-A4BE-44A5-9A25-3D1E578E879F"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.6 </span> Configuring Connections to Third-Party Database Services",
                                    "href":"configuring-connections-third-party-database-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.6.1 </span> Default Configuration for External Procedures",
                                            "href":"default-configuration-external-procedures.html#GUID-8B71CC48-B8F7-4543-915B-87FF6C3E39DB"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.6.2 </span> About Oracle Net Services for Oracle Heterogeneous Services",
                                            "href":"oracle-net-services-oracle-heterogeneous-services.html#GUID-AD068B69-6790-4699-A710-A22C3482AE4B"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.6.3 </span> Configuring Oracle Net Services for an Oracle Rdb Database",
                                            "href":"configuring-oracle-net-services-oracle-rdb-database.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14 </span> Optimizing Performance",
                            "href":"optimizing-performance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1 </span> Understanding the Benefits of Network Data Compression",
                                    "href":"understanding-benefits-network-data-compression.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2 </span> Configuring Session Data Unit",
                                    "href":"configuring-session-data-unit.html#GUID-86D61D6F-AD26-421A-BABA-77949C8A2B04"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.3 </span> Determining the Bandwidth-Delay Product",
                                    "href":"determining-bandwidth-delay-product.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.4 </span> Configuring I/O Buffer Space",
                                    "href":"configuring-i-o-buffer-space.html#GUID-E94D2ABA-23C8-44E9-BBCB-077FADA85F29"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.5 </span> Configuring SDP Support for InfiniBand Connections",
                                    "href":"configuring-sdp-support-infiniband-connections.html#GUID-A8594BE3-BBF8-4C9D-89CA-41560B625C10"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.6 </span> Configuring Exadirect Support for InfiniBand Connections",
                                    "href":"configuring-exadirect-support-infiniband-connections.html#GUID-5499D049-CEB6-4AD1-99B6-0211D391908E"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.7 </span> Limiting Resource Consumption by Unauthorized Users",
                                    "href":"limiting-resource-consumption-unauthorized-users.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.8 </span> Configuring Key-Based Routing for Client-Server Connections",
                                    "href":"configuring-key-based-routing-client-server-connections.html#GUID-B079570D-B6DC-44A0-9E20-89E667B94B3B"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.9 </span> Configuring SNI for TLS connections",
                                    "href":"configuring-sni-tls-connections.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part III Testing and Troubleshooting Oracle Net Services",
                    "href":"testing-and-troubleshooting-oracle-net-services.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15 </span> Testing Connections",
                            "href":"testing-connections.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.1 </span> Testing the Network",
                                    "href":"testing-network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2 </span> Using the TNSPING Utility to Test Connectivity from the Client",
                                    "href":"using-tnsping-utility-test-connectivity-client.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.3 </span> Using the TRCROUTE Utility to Test Connectivity from the Client",
                                    "href":"using-trcroute-utility-test-connectivity-client.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">16 </span> Troubleshooting Oracle Net Services",
                            "href":"troubleshooting-oracle-net-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.1 </span> Understanding Automatic Diagnostic Repository",
                                    "href":"understanding-automatic-diagnostic-repository.html#GUID-92CB3B70-5297-4105-8C34-9999DB4CF4F0"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.2 </span> Diagnosing Oracle Net Services",
                                    "href":"diagnosing-oracle-net-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">16.2.1 </span> Diagnosing Server Problems",
                                            "href":"diagnosing-server-problems.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.2.2 </span> Diagnosing Client Problems",
                                            "href":"diagnosing-client-problems.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">16.3 </span> Resolving the Most Common Error Messages for Oracle Net Services",
                                    "href":"resolving-most-common-error-messages-oracle-net-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">16.3.1 </span> ORA-03113",
                                            "href":"ora-03113-end-file-communication-channel.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.2 </span> ORA-12154",
                                            "href":"ora-12154-could-not-resolve-connect-identifier-specified.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.3 </span> ORA-12170",
                                            "href":"ora-12170-connect-timeout-occurred.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.4 </span> ORA-12241",
                                            "href":"ora-12241-windows-service-not-available-or-running.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.5 </span> ORA-12261",
                                            "href":"ora-12261-error-when-using-easy-connect-plus-naming-method.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.6 </span> ORA-12262",
                                            "href":"ora-12262-error-when-using-easy-connect-plus-naming-method.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.7 </span> ORA-12500",
                                            "href":"tns-12500-or-ora-12500-listener-failed-start-dedicated-server-process.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.8 </span> ORA-12505",
                                            "href":"ora-12505-listener-does-not-currently-know-sid-given-connect-descriptor.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.9 </span> ORA-12514",
                                            "href":"ora-12514-listener-does-not-currently-know-service-requested-connect-descriptor.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.10 </span> ORA-12516",
                                            "href":"ora-12516-listener-could-not-find-available-handler-matching-protocol-stack.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.11 </span> ORA-12520",
                                            "href":"ora-12520-listener-could-not-find-available-handler-requested-type-server.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.12 </span> ORA-12521",
                                            "href":"ora-12521-listener-does-not-currently-know-instance-requested-connect-descriptor.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.13 </span> ORA-12525",
                                            "href":"ora-12525-listener-has-not-received-clients-request-time-allowed.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.14 </span> ORA-12533",
                                            "href":"ora-12533-illegal-address-parameters.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.15 </span> ORA-12540 and TNS-00510",
                                            "href":"tns-12540-or-ora-12540-tns-internal-limit-restriction-exceeded-and-tns-00510-internal-limit-restri.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.16 </span> ORA-12541",
                                            "href":"tns-12541-or-ora-12541-tns-no-listener.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.17 </span> ORA-12549 and TNS-00519",
                                            "href":"tns-12549-or-ora-12549-tns-operating-system-resource-quota-exceeded-and-tns-00519-operating-system.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.18 </span> ORA-12560",
                                            "href":"tns-12560-or-ora-12560-tns-protocol-adapter-error-occurred.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.3.19 </span> Directory Naming Errors",
                                            "href":"directory-naming-errors.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">16.4 </span> Troubleshooting Suggestions for Oracle Net Services",
                                    "href":"troubleshooting-suggestions-oracle-net-services.html#GUID-2D54FE7A-F1BD-4C4B-A6B3-2133B7E34876"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5 </span> Example of Troubleshooting a TNS-12154 Error",
                                    "href":"example-troubleshooting-tns-12154-error.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.6 </span> Logging Error Information for Oracle Net Services",
                                    "href":"logging-error-information-oracle-net-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">16.6.1 </span> Oracle Net Error Stacks",
                                            "href":"oracle-net-error-stacks.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.2 </span> Understanding Error Stack Messages",
                                            "href":"understanding-error-stack-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.3 </span> Oracle Net Services Log File Names",
                                            "href":"oracle-net-services-log-file-names.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.4 </span> Oracle Network Log File Segmentation",
                                            "href":"oracle-network-log-file-segmentation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.5 </span> About the Logging Parameters",
                                            "href":"logging-parameters.html#GUID-08E98770-0D0F-47D5-AD4E-C10A659B390C"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.6 </span> Setting Logging Parameters in Configuration Files",
                                            "href":"setting-logging-parameters-configuration-files.html#GUID-04BCED20-729C-4A3D-ABC2-AB7B57F7D4E2"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.7 </span> Setting Logging During Control Utilities Runtime",
                                            "href":"setting-logging-control-utilities-runtime.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.8 </span> Using Log Files",
                                            "href":"using-log-files.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.9 </span> Analyzing Listener Logs",
                                            "href":"analyzing-listener-logs.html#GUID-13C57450-A1F1-46F4-B48C-8E284C3C87CA"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.6.10 </span> Analyzing Oracle Connection Manager Logs",
                                            "href":"analyzing-oracle-connection-manager-logs.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">16.7 </span> Tracing Error Information for Oracle Net Services",
                                    "href":"tracing-error-information-oracle-net-services.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">16.7.1 </span> Understanding Oracle Net Services Trace File Names",
                                            "href":"understanding-oracle-net-services-trace-file-names.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.7.2 </span> Setting Tracing Parameters",
                                            "href":"setting-tracing-parameters.html#GUID-B9589F4C-4CC6-450B-965E-0D2AA6D9EDD9"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.7.3 </span> Setting Tracing During Control Utilities Runtime",
                                            "href":"setting-tracing-control-utilities-runtime.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.7.4 </span> Evaluating Oracle Net Services Trace Files",
                                            "href":"evaluating-oracle-net-services-trace-files.html#GUID-6158C428-1480-46EB-AD8F-CDDDA5E0006D"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">16.7.5 </span> Using the Trace Assistant to Examine Trace Files",
                                            "href":"using-trace-assistant-examine-trace-files.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">16.7.5.1 </span> Trace Assistant Syntax",
                                                    "href":"trace-assistant-syntax.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">16.7.5.2 </span> Packet Examples",
                                                    "href":"packet-examples.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">16.7.5.3 </span> Two-Task Common (TTC) Packet Examples",
                                                    "href":"two-task-common-ttc-packet-examples.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">16.7.5.4 </span> Connection Example",
                                                    "href":"connection-example.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">16.7.5.5 </span> Statistics Example",
                                                    "href":"statistics-example.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">16.8 </span> Contacting Oracle Support Services",
                                    "href":"contacting-oracle-support-services.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});