define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Examples",
                    "href":"loe.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-3B523B8F-7232-4658-9AB7-420572E56033"
                },
                {
                    "title":"Changes in This Release for Oracle Data Provider for .NET",
                    "href":"release_changes.html#GUID-7EDAEAB4-55C9-4D59-AAC8-D37EECB11395"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introducing Oracle Data Provider for .NET",
                    "href":"intro.html#GUID-635BAE6C-7D0B-4CF2-ADD8-8DB531B9C52E",
                    "topics":[
                        {
                            "title":".NET Data Access in Oracle: Products and Documentation",
                            "href":"intro001.html#GUID-6008A8EE-BF13-4A47-8DC9-03B8FB8F8ABB"
                        },
                        {
                            "title":"Overview of Oracle Data Provider for .NET (ODP.NET)",
                            "href":"intro002.html#GUID-1638EDC5-8F98-4587-80B2-F383305C0323"
                        },
                        {
                            "title":"Oracle Data Provider for .NET Assemblies",
                            "href":"intro003.html#GUID-FD1413E6-6DD8-4E92-96F2-674A9D318FF5"
                        },
                        {
                            "title":"Differences between the ODP.NET Drivers",
                            "href":"intro004.html#GUID-75DC70F1-8F24-4190-B4EE-F2E03DFB6ED2"
                        },
                        {
                            "title":"Getting Started With Developing ODP.NET Applications",
                            "href":"intro005.html#GUID-8519A047-B33E-4135-9BB7-716A9A11E3F3"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Installing and Configuring Oracle Data Provider for .NET",
                    "href":"install.html#GUID-1308ACD5-025A-468E-834A-CAB59FE9BB59",
                    "topics":[
                        {
                            "title":"System Requirements",
                            "href":"InstallSystemRequirements.html#GUID-A6405CAD-C0E9-45E0-9C38-26B7ED214479"
                        },
                        {
                            "title":"Entity Framework Requirements",
                            "href":"InstallEntityReq.html#GUID-6F3C3514-7234-476C-AF29-5D4221F2AD73"
                        },
                        {
                            "title":"Entity Framework Core System Requirements",
                            "href":"InstallEFCoreRequirements.html#GUID-715D48FB-C6AD-48EE-AB3E-DC93A0095487"
                        },
                        {
                            "title":"Oracle Data Provider for .NET Versioning Scheme",
                            "href":"InstallVersioningScheme.html#GUID-54448394-9F84-4B23-8E9B-9EC7A91B382D"
                        },
                        {
                            "title":"Installing Oracle Data Provider for .NET, Unmanaged Driver",
                            "href":"InstallODP.html#GUID-1AFEBF7B-3917-4E8F-9384-923EE9F5838B"
                        },
                        {
                            "title":"Installing Oracle Data Provider for .NET, Managed Driver",
                            "href":"installODPmd.html#GUID-0E834EC7-21DF-4913-B712-2B0A07FD58FD"
                        },
                        {
                            "title":"Installing Oracle Data Provider for .NET Core",
                            "href":"InstallODPCore.html#GUID-6A865B77-99D7-4F5E-A19B-4D7CC4F56885"
                        },
                        {
                            "title":"Entity Framework Assemblies and File Location",
                            "href":"InstallEntityAssemblies.html#GUID-269A3B1D-1841-4C4A-ADC3-7CF13F21F58F"
                        },
                        {
                            "title":"Configuring Oracle Data Provider for .NET",
                            "href":"InstallConfig.html#GUID-1F689B90-2CC4-4907-B8FE-A5F4EE36F673"
                        },
                        {
                            "title":"Oracle Data Provider for .NET, Unmanaged Driver Configuration",
                            "href":"InstallUnmanagedConfig.html#GUID-6F3A5287-F255-4583-8B03-6A8D9D12A3E3"
                        },
                        {
                            "title":"Oracle Data Provider for .NET, Managed Driver Configuration",
                            "href":"InstallManagedConfig.html#GUID-29A85CBD-948D-4C9F-A89D-A96A99EFF2D7"
                        },
                        {
                            "title":"Oracle Data Provider for .NET Core Configuration",
                            "href":"InstallCoreConfiguration.html#GUID-24C963AE-F20B-44B5-800C-594CA06BD24B"
                        },
                        {
                            "title":"Configuration Differences among ODP.NET Drivers",
                            "href":"InstallConfigDiff.html#GUID-3F98A3AE-BF6F-40B9-87BC-101D8F2EC2D8"
                        },
                        {
                            "title":"Centralized Configuration Providers for Deployments",
                            "href":"InstallCentralConfig.html#GUID-4EB05B45-1929-4F5B-BBFB-8F66EF0BE4DA"
                        },
                        {
                            "title":"Connection Configuration Restriction",
                            "href":"InstallConnectionConfigurationRestriction.html#GUID-35FC6C1A-A057-49B4-AB3E-9084A6BFE727"
                        },
                        {
                            "title":"Configuring for Entity Framework Code First",
                            "href":"InstallEntityConfig.html#GUID-4681DA4C-9F03-4AC0-A658-F87CB1BE33AB"
                        },
                        {
                            "title":"Migrating from ODP.NET, Unmanaged Driver to ODP.NET, Managed Driver or ODP.NET Core",
                            "href":"InstallMigrateUDtoMD.html#GUID-BD777BE6-BA34-4978-96CC-36B65A169151"
                        },
                        {
                            "title":"Configuring a Port to Listen for Database Notifications",
                            "href":"InstallConfiguringPort.html#GUID-95E53037-AEAA-4AFD-A8C5-CA25A3555D40"
                        },
                        {
                            "title":"General .NET Programming Recommendations and Tips for ODP.NET",
                            "href":"InstallTips.html#GUID-D7AFF83A-05CA-4D34-B1A7-2A7787DD8F97"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Features of Oracle Data Provider for .NET",
                    "href":"features.html#GUID-FF58E75D-B5D1-4327-B65E-CE263E3A5C6C",
                    "topics":[
                        {
                            "title":"Base Classes, Provider Factory Classes, and DbDataSource",
                            "href":"featClasses.html#GUID-BA9474A2-90AB-4A06-9F86-973E06EE7E54"
                        },
                        {
                            "title":"Code Access Security",
                            "href":"featCodeAccess.html#GUID-35586B6E-4D5B-42A8-ACF1-F9FEFD90BCFD"
                        },
                        {
                            "title":"Connecting to Oracle Database",
                            "href":"featConnecting.html#GUID-BCF2F215-C25F-403C-8D18-B03A69BC7104"
                        },
                        {
                            "title":"Real Application Clusters and Global Data Services",
                            "href":"featRAC.html#GUID-BAF145C1-33A9-45C7-9ED5-FB4563B274CA"
                        },
                        {
                            "title":"Using Transaction Guard to Prevent Logical Corruption",
                            "href":"featTG.html#GUID-A99CC6F9-D58C-44C6-8762-0851264724B3"
                        },
                        {
                            "title":"Application Continuity",
                            "href":"featAppCont.html#GUID-6EE145F2-DCEC-4A8A-9DCF-979F03B285A8"
                        },
                        {
                            "title":"Transparent Application Failover",
                            "href":"featTAF.html#GUID-5A079844-3296-40B7-9AEA-7FE24FF1508B"
                        },
                        {
                            "title":"Oracle Globally Distributed Database",
                            "href":"featDataSharding.html#GUID-D42183C2-3C84-443E-9A92-93EF764D5770"
                        },
                        {
                            "title":"OracleCommand Object",
                            "href":"featOraCommand.html#GUID-FB17153B-9E21-4EAF-B694-D08B07ECC448"
                        },
                        {
                            "title":"ODP.NET Types Overview",
                            "href":"featTypes.html#GUID-9DA46E61-DAA9-424A-A35B-10F36E4B6734"
                        },
                        {
                            "title":"GUIDs",
                            "href":"featGUID.html#GUID-F37C139A-037C-4029-844E-979FA7922F74"
                        },
                        {
                            "title":"Obtaining Data from an OracleDataReader Object",
                            "href":"featData.html#GUID-E962F3D3-6434-46DF-BFE4-42B9085B539D"
                        },
                        {
                            "title":"PL/SQL REF CURSOR and OracleRefCursor",
                            "href":"featRefCursor.html#GUID-4215DACA-977E-473F-AF4E-764841A476D7"
                        },
                        {
                            "title":"Implicit REF CURSOR Binding",
                            "href":"featImplRefCursor.html#GUID-807466C6-81C4-4C13-B698-A2518A1EEAC8"
                        },
                        {
                            "title":"LOB Support",
                            "href":"featLOBsupp.html#GUID-499E925C-C014-419A-B411-FF2C39170C67"
                        },
                        {
                            "title":"Native JSON Support",
                            "href":"featNativeJSONSupport.html#GUID-B74CC67D-D2E2-4B6B-8628-EBCD68AAC3AC"
                        },
                        {
                            "title":"Artificial Intelligence Vectors and Semantic Search",
                            "href":"featAIVectorSearch.html#GUID-82C09283-1643-4C75-B836-BFB7FB33E34B"
                        },
                        {
                            "title":"ODP.NET XML Support",
                            "href":"featXML.html#GUID-6CF36CBC-281B-4CE3-85DC-FD21FA4D6B52"
                        },
                        {
                            "title":"Oracle User-Defined Types (UDTs) and .NET Custom Types",
                            "href":"featUDTs.html#GUID-2A2F1C93-7BD8-4E48-B48A-F0EF6E63EC8B"
                        },
                        {
                            "title":"Bulk Copy",
                            "href":"featBulkCopy.html#GUID-91569C5F-52C3-4F95-8040-432A8AA8D0F8"
                        },
                        {
                            "title":"Asynchronous Programming and Pipelining",
                            "href":"featAsyncPipelining.html#GUID-27CA3823-92BA-489A-9356-9EAA7B86A4FE"
                        },
                        {
                            "title":"Advanced Queuing and Transactional Event Queues",
                            "href":"featAQ.html#GUID-94DD46DA-B24E-4D7B-AD79-D106716A900E"
                        },
                        {
                            "title":"Continuous Query Notification Support",
                            "href":"featChange.html#GUID-11ED5CC0-9DDE-4285-BC33-73D517E97629"
                        },
                        {
                            "title":"OracleDataAdapter Safe Type Mapping",
                            "href":"featSafeType.html#GUID-AEAA0FB6-123B-49DF-97C1-F71FAC35D60B"
                        },
                        {
                            "title":"OracleDataAdapter Requery Property",
                            "href":"featRequery.html#GUID-D7A62257-0676-4B30-A85A-AEBD62D904B2"
                        },
                        {
                            "title":"Guaranteeing Uniqueness in Updating DataSet to Database",
                            "href":"featUnique.html#GUID-8D1FCB1E-FE1D-4C4B-B3A4-92B0EB6A456B"
                        },
                        {
                            "title":"Globalization Support",
                            "href":"featGlobal.html#GUID-EE66C558-1C17-4CB5-A31F-72066B9B9FA1"
                        },
                        {
                            "title":"Data Use Case Domains",
                            "href":"featSQLDomains.html#GUID-BB587B2E-F19B-4392-9615-BB4D5B258A54"
                        },
                        {
                            "title":"Annotations",
                            "href":"featAnnotations.html#GUID-D1F6A320-364E-4F98-AF76-7AB06D9B258F"
                        },
                        {
                            "title":"OpenTelemetry",
                            "href":"featOpenTelemetry.html#GUID-498BB919-43C4-494F-A73B-74980C40CFF3"
                        },
                        {
                            "title":".NET Metrics",
                            "href":"featMetrics.html#GUID-5FC3B56C-6F0D-42CD-B22E-B017FC3A466D"
                        },
                        {
                            "title":"Debug Tracing",
                            "href":"featDebug.html#GUID-A1A17BCF-10B2-4A61-8A50-A6CA91CD7CAE"
                        },
                        {
                            "title":"Database Application Migration: SQL Translation Framework",
                            "href":"featSqlTranslationFW.html#GUID-2DF740D8-48B6-4828-A405-D85A34621FD3"
                        },
                        {
                            "title":"Allowed Logon Version Client Support",
                            "href":"featAllowedLogonVersionClientSupport.html#GUID-0BD35B7D-9D66-4D0A-8CC9-5DA99AD73138"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> ADO.NET Entity Framework and LINQ to Entities",
                    "href":"entity_framework.html#GUID-28FDD8AA-CD22-48FD-877B-8A4B7E930742",
                    "topics":[
                        {
                            "title":"Overview of Entity Framework",
                            "href":"entityOverview.html#GUID-C950DE18-0F6F-4609-804A-FB6EDA19BDF8"
                        },
                        {
                            "title":"Language Integrated Query and Entity SQL",
                            "href":"entityLang.html#GUID-3D435613-8D06-4D49-8AE8-ECAC3DAD97E9"
                        },
                        {
                            "title":"Mapping Oracle Data Types to EDM Types",
                            "href":"entityEDMmapping.html#GUID-47AB0154-D89E-4CA0-AB6C-F5BF3D57CE5F"
                        },
                        {
                            "title":"Oracle Number Default Data Type Mapping and Customization",
                            "href":"entityDataTypeMapping.html#GUID-121CDE13-EB42-4B03-BFDA-F6617E5777AD"
                        },
                        {
                            "title":"Migrating Existing Entity Framework 5 Applications to Entity Framework 6",
                            "href":"entityMigrate.html#GUID-2A2E0DB7-DDFC-4065-B2D2-EDE08B50509A"
                        },
                        {
                            "title":"Code First",
                            "href":"entityCodeFirst.html#GUID-F8587AB2-DFD8-4B05-9520-52B32C9E143B"
                        },
                        {
                            "title":"Unsupported Entity Framework Features",
                            "href":"entityUnsupported.html#GUID-1AB87200-2C60-4C85-8A73-D8662448EC6A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Oracle Data Provider for .NET Entity Framework Core",
                    "href":"ODPEFCore.html#GUID-80B07B35-46C9-408F-A688-F98CE1A4CD6C",
                    "topics":[
                        {
                            "title":"Oracle Entity Framework Core 9 Features",
                            "href":"EFCore9features.html#GUID-E09019EA-9C77-4611-B074-E47D6728627A"
                        },
                        {
                            "title":"Oracle Entity Framework Core 8 Features",
                            "href":"EFCore8features.html#GUID-10351987-258D-4D8B-B788-C50F2C4316B7"
                        },
                        {
                            "title":"Oracle Entity Framework Core 7 Features",
                            "href":"EFCore7features.html#GUID-9414B317-AF98-420D-8209-6825654B5679"
                        },
                        {
                            "title":"Application Programming Interface",
                            "href":"EFCoreAPI.html#GUID-770CD8EA-F963-48A5-A679-CAF471A4DB1A"
                        },
                        {
                            "title":"Sample Code",
                            "href":"EFCoreSampleCode.html#GUID-71B4A0A3-7B88-4D4D-BC99-8ACB2F344280"
                        },
                        {
                            "title":"Using ODP.NET Core Classes",
                            "href":"EFCoreClasses.html#GUID-D5D99935-D8AF-4E16-BD52-88B2A7537B84"
                        },
                        {
                            "title":"Logging",
                            "href":"EFCoreLogging.html#GUID-965B78C4-8E96-44E8-A3DC-151D38546845"
                        },
                        {
                            "title":"Migrations",
                            "href":"EFCoreDataTypeMapping.html#GUID-484E9D3A-8E42-417F-9591-F2E7305E3F6A"
                        },
                        {
                            "title":"Scaffolding Or Reverse Engineering",
                            "href":"EFCoreREDataTypeMapping.html#GUID-4FF3A9A3-AE49-431B-A4FB-31F8C53FCCF5"
                        },
                        {
                            "title":"Identifier Name Length and Uniqueness",
                            "href":"EFCoreIdentifier.html#GUID-FA43F1A1-EDA2-462F-8844-45D49EF67607"
                        },
                        {
                            "title":"Using Large Character or Binary Data Types",
                            "href":"EFCoreLargeCharacter.html#GUID-AE805872-88C9-4D67-95B5-1700B5539518"
                        },
                        {
                            "title":"Performance Considerations",
                            "href":"EFCorePerformanceConsiderations.html#GUID-E12B036C-A8B7-4891-9713-B079AC4815DD"
                        },
                        {
                            "title":"Artificial Intelligence Vector Data Types",
                            "href":"EFCoreAIVectordatatypes.html#GUID-A2FBC9CC-20CA-44B3-8123-29985B198593"
                        },
                        {
                            "title":"Breaking Changes",
                            "href":"EFCoreDesupportedAPIs.html#GUID-9429D321-2E46-4A95-AF56-EFBEC52A9E01"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Oracle Data Provider for .NET Classes",
                    "href":"odp-dot-net-classes.html#GUID-C9E51CC1-9116-4D3D-B922-3A9D07DADF45",
                    "topics":[
                        {
                            "title":"OracleAccessToken Class",
                            "href":"OracleAccessTokenClass.html#GUID-3CF1108C-D0EC-4F87-95D8-20558385E741",
                            "topics":[
                                {
                                    "title":"OracleAccessToken Members",
                                    "href":"OracleAccessTokenMembers.html#GUID-85D6E501-6422-482A-BF9F-B5AD24F08396"
                                },
                                {
                                    "title":"OracleAccessToken Constructors",
                                    "href":"OracleAccessTokenConstructors.html#GUID-F975EC0D-F06C-418C-8FB9-44FF6AB2F5E7",
                                    "topics":[
                                        {
                                            "title":"OracleAccessToken(char)",
                                            "href":"OracleAccessTokenCtor1.html#GUID-8B1742A1-2151-4DCF-BA2F-34E73EF66A60"
                                        },
                                        {
                                            "title":"OracleAccessToken(char, char)",
                                            "href":"OracleAccessTokenCtor2.html#GUID-DCA4C35D-C579-4F54-9FB0-33FAF700F42D"
                                        }
                                    ]
                                },
                                {
                                    "title":"RefreshAccessToken Event",
                                    "href":"AccessTokenRefreshAccessToken.html#GUID-536E652E-5598-4885-BE56-C25474C871A8"
                                }
                            ]
                        },
                        {
                            "title":"OracleClientFactory Class",
                            "href":"OracleClientFactoryClass.html#GUID-9E000B2B-B54E-470D-97F3-EDEF5EA4316E",
                            "topics":[
                                {
                                    "title":"OracleClientFactory Members",
                                    "href":"OracleClientFactoryMembers.html#GUID-3011A164-476A-4E26-B6FF-C0C4FAD0322F"
                                },
                                {
                                    "title":"OracleClientFactory Field",
                                    "href":"ClientFactoryField.html#GUID-486D49EF-BDF8-4338-B140-B85614873090",
                                    "topics":[
                                        {
                                            "title":"Instance",
                                            "href":"ClientFactoryInstance.html#GUID-6F9CF51D-1D6F-4328-BFD2-D29A2C34AC31"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleClientFactory Constructor",
                                    "href":"ClientFactoryConstructor.html#GUID-9C55EAB8-03FE-48F7-B182-DB66D913456D"
                                },
                                {
                                    "title":"OracleClientFactory Public Properties",
                                    "href":"ClientFactoryProperties.html#GUID-54273069-A5F2-4D5C-A0F9-D34B4E0B966A",
                                    "topics":[
                                        {
                                            "title":"CanCreateDataSourceEnumerator",
                                            "href":"ClientFactoryCanCreateDataSourceEnumerator.html#GUID-B63E9A72-08A2-4F75-A953-88283D871AEC"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleClientFactory Public Methods",
                                    "href":"ClientFactoryPublicMethods.html#GUID-94272C39-8C85-430F-A442-841D7CCE9069",
                                    "topics":[
                                        {
                                            "title":"CreateCommand",
                                            "href":"ClientFactoryCreateCommand.html#GUID-DBD7A2C5-98DA-42FA-8E20-D48611C38F9F"
                                        },
                                        {
                                            "title":"CreateCommandBuilder",
                                            "href":"ClientFactoryCreateCommandBuilder.html#GUID-80FC5467-ABB7-44B2-A1AE-D876B009905B"
                                        },
                                        {
                                            "title":"CreateConnection",
                                            "href":"ClientFactoryCreateConnection.html#GUID-863A0637-B554-4818-9221-E52E231DB56B"
                                        },
                                        {
                                            "title":"CreateConnectionStringBuilder",
                                            "href":"ClientFactoryCreateConnectionStringBuilder.html#GUID-38A41E63-D71A-4EEE-8A07-3B5439F975C9"
                                        },
                                        {
                                            "title":"CreateDataAdapter",
                                            "href":"ClientFactoryCreateDataAdapter.html#GUID-7FED9E44-0E0F-4C04-BB0A-A44BC2F1B5FD"
                                        },
                                        {
                                            "title":"CreateDataSource",
                                            "href":"ClientFactoryCreateDataSource.html#GUID-74946DA4-BB39-42D8-8D08-06339ECAF1EC"
                                        },
                                        {
                                            "title":"CreateDataSourceEnumerator",
                                            "href":"ClientFactoryCreateDataSourceEnumerator.html#GUID-E47E0561-F2B0-400B-A61F-7D6720063AEA"
                                        },
                                        {
                                            "title":"CreateParameter",
                                            "href":"ClientFactoryCreateParameter.html#GUID-7B381851-537C-406F-9BD6-1D2FCF833909"
                                        },
                                        {
                                            "title":"CreatePermission",
                                            "href":"ClientFactoryCreatePermission.html#GUID-B9CB4774-29A4-42EC-BB10-DFCAF0BD971E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleCommand Class",
                            "href":"OracleCommandClass.html#GUID-7C1D5BCC-0268-4F1B-A583-F401F30EB9C0",
                            "topics":[
                                {
                                    "title":"OracleCommand Members",
                                    "href":"OracleCommandMembers.html#GUID-675EB077-B6E5-4922-AA2B-407AC5DDCD66"
                                },
                                {
                                    "title":"OracleCommand Constructors",
                                    "href":"OracleCommandCtors.html#GUID-86402528-ABA6-42ED-BDEF-80A75A83B6CF",
                                    "topics":[
                                        {
                                            "title":"OracleCommand()",
                                            "href":"CommandCtor1.html#GUID-ECAE1FFB-78F2-48B7-9B08-7449938D89E1"
                                        },
                                        {
                                            "title":"OracleCommand(string)",
                                            "href":"CommandCtor2.html#GUID-D62C0BE3-B7C8-4F6E-ACB2-2A1E7E70558E"
                                        },
                                        {
                                            "title":"OracleCommand(string, OracleConnection)",
                                            "href":"CommandCtor3.html#GUID-61D978B0-380E-4670-8E4C-8B12AD0A8192"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommand Static Methods",
                                    "href":"CommandStaticMethods.html#GUID-B11A7575-26C7-4E63-BEE3-53B7B1CF2708"
                                },
                                {
                                    "title":"OracleCommand Properties",
                                    "href":"CommandProperties.html#GUID-8C2AB5B2-3C3D-426D-8ABD-9025504200D8",
                                    "topics":[
                                        {
                                            "title":"AddRowid",
                                            "href":"CommandAddRowid.html#GUID-5F6230E7-79E4-4FB6-8FAF-D26E98D3FDD1"
                                        },
                                        {
                                            "title":"AddToStatementCache",
                                            "href":"CommandAddToStatementCache.html#GUID-4B7622E5-9261-4850-B66E-EB8A5C094D25"
                                        },
                                        {
                                            "title":"ArrayBindCount",
                                            "href":"CommandArrayBindCount.html#GUID-04A4E08E-E2C5-435A-9476-9ECDE83C90BC"
                                        },
                                        {
                                            "title":"ArrayBindRowsAffected",
                                            "href":"CommandArrayBindRowsAffected.html#GUID-604073D7-AD69-41C4-86C1-FA93CA866430"
                                        },
                                        {
                                            "title":"BindByName",
                                            "href":"CommandBindByName.html#GUID-609B7F20-2444-4CBF-AC8A-A19907A626C8"
                                        },
                                        {
                                            "title":"CommandText",
                                            "href":"CommandCommandText.html#GUID-D958222F-893C-4034-884C-9F3A3D4FFA20"
                                        },
                                        {
                                            "title":"CommandTimeout",
                                            "href":"CommandCommandTimeout.html#GUID-F3B678B5-60E3-453D-B7D4-5ADE8082E1ED"
                                        },
                                        {
                                            "title":"CommandType",
                                            "href":"CommandCommandType.html#GUID-EBFDC752-751E-4E7B-AFC9-CDBD63EC4C7B"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"CommandConnection.html#GUID-0382B366-99D7-4EE6-9EE0-9FF301766291"
                                        },
                                        {
                                            "title":"DesignTimeVisible",
                                            "href":"CommandDesignTimeVisible.html#GUID-C965B3CD-180B-4A45-BC32-28DA6D74B761"
                                        },
                                        {
                                            "title":"FetchSize",
                                            "href":"CommandFetchSize.html#GUID-4C26C1D4-DC67-4CAA-972D-FA3BF52DDBC6"
                                        },
                                        {
                                            "title":"FetchSqlId",
                                            "href":"CommandFetchSqlId.html#GUID-6443EF0C-CE9F-4FDB-A69C-7243628A1833"
                                        },
                                        {
                                            "title":"ImplicitRefCursors",
                                            "href":"CommandImplicitRefCursors.html#GUID-FFC776D1-8214-4FC6-93EB-16F20FC24725"
                                        },
                                        {
                                            "title":"InitialLOBFetchSize",
                                            "href":"CommandInitialLOBFetchSize.html#GUID-323D5DA4-D5DE-4CA6-A262-0A4F3F311DCA"
                                        },
                                        {
                                            "title":"InitialLONGFetchSize",
                                            "href":"CommandInitialLONGFetchSize.html#GUID-7AFA7559-8EC4-41AA-ACBA-AD5941EC5CBE"
                                        },
                                        {
                                            "title":"Notification",
                                            "href":"CommandNotification.html#GUID-901CB17E-9AA9-4559-8D05-1DCE6379C17A"
                                        },
                                        {
                                            "title":"NotificationAutoEnlist",
                                            "href":"CommandNotificationAutoEnlist.html#GUID-DC81618E-3E73-453F-BC07-B460E0475067"
                                        },
                                        {
                                            "title":"Parameters",
                                            "href":"CommandParameters.html#GUID-E95BA929-46C0-4FF0-99AB-D1141273DEAD"
                                        },
                                        {
                                            "title":"RowSize",
                                            "href":"CommandRowSize.html#GUID-0B324D30-3B75-4DC0-BC98-BBC1C4478622"
                                        },
                                        {
                                            "title":"RowsToFetchPerRoundTrip",
                                            "href":"CommandRowsToFetchPerRoundTrip.html#GUID-DD801233-A0AE-443E-A7CE-CAA656C04831"
                                        },
                                        {
                                            "title":"SqlId",
                                            "href":"CommandSqlId.html#GUID-B091A869-8EAC-4961-AB13-1ACA14E359EB"
                                        },
                                        {
                                            "title":"Transaction",
                                            "href":"CommandTransaction.html#GUID-1D62DDC4-2E46-452C-8EE9-5F5ED4F4A295"
                                        },
                                        {
                                            "title":"UpdatedRowSource",
                                            "href":"CommandUpdatedRowSource.html#GUID-204D060B-68A1-45AB-A3B7-756DC409E37A"
                                        },
                                        {
                                            "title":"UseEdmMapping",
                                            "href":"CommandUseEdmMapping.html#GUID-97B95E1F-D9E8-4F16-B7E9-29AEE24A6038"
                                        },
                                        {
                                            "title":"XmlCommandType",
                                            "href":"CommandXmlCommandType.html#GUID-5009D866-BC70-46FE-8C92-7CE5A5D1839C"
                                        },
                                        {
                                            "title":"XmlQueryProperties",
                                            "href":"CommandXmlQueryProperties.html#GUID-7E807DC6-0676-4B35-802E-BD394DD0B6D2"
                                        },
                                        {
                                            "title":"XmlSaveProperties",
                                            "href":"CommandXmlSaveProperties.html#GUID-BA07604E-00D9-4232-B85B-8743DEAFC04B"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommand Public Methods",
                                    "href":"CommandPublicMethods.html#GUID-DB9CAE68-F49F-41E2-82C6-08CE05D65A09",
                                    "topics":[
                                        {
                                            "title":"Cancel",
                                            "href":"CommandCancel.html#GUID-AA7F3329-7359-44BF-AF57-A39319270397"
                                        },
                                        {
                                            "title":"Clone",
                                            "href":"CommandClone.html#GUID-911F4AC4-08E5-48A3-9BA4-26BE03A0E6E4"
                                        },
                                        {
                                            "title":"CreateParameter",
                                            "href":"CommandCreateParameter.html#GUID-64134B74-F5F2-446B-BCCD-9ABFB4BBEAA9"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"CommandDispose.html#GUID-ED45922B-7F60-4EC6-A567-0A45F685902C"
                                        },
                                        {
                                            "title":"ExecuteNonQuery",
                                            "href":"CommandExecuteNonQuery.html#GUID-E1E79471-6037-4490-BDE7-ADE252922C83"
                                        },
                                        {
                                            "title":"ExecuteNonQueryAsync",
                                            "href":"CommandExecuteNonQueryAsyncOverloads.html#GUID-AE995680-3618-48BC-A4FE-E3C9DA727F65"
                                        },
                                        {
                                            "title":"ExecuteNonQueryAsync()",
                                            "href":"CommandExecuteNonQueryAsync1.html#GUID-5F41D720-F19D-4A1F-B768-05F61867D556"
                                        },
                                        {
                                            "title":"ExecuteNonQueryAsync(CancellationToken cancellationToken)",
                                            "href":"CommandExecuteNonQueryAsync2.html#GUID-1F73D4F5-9DE7-4DDD-B2D4-29D5C058691D"
                                        },
                                        {
                                            "title":"ExecuteReader",
                                            "href":"CommandExecuteReaderOverloads.html#GUID-6565DEB4-D5F3-467F-AA73-73EEBC1C04B0"
                                        },
                                        {
                                            "title":"ExecuteReader()",
                                            "href":"CommandExecuteReader1.html#GUID-C8EAEB65-A5C3-4D5C-9F87-6747C83F2DC0"
                                        },
                                        {
                                            "title":"ExecuteReader(CommandBehavior)",
                                            "href":"CommandExecuteReader2.html#GUID-E581F08F-22F0-4EB3-A3DE-A8097D33D6A1"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync",
                                            "href":"CommandExecuteReaderAsyncOverloads.html#GUID-7894F37A-4676-45E6-A669-C11B76FE9381"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync()",
                                            "href":"CommandExecuteReaderAsync1.html#GUID-3CCA309E-966C-4EA3-9AFD-092461CB6F62"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync(CancellationToken cancellationToken)",
                                            "href":"CommandExecuteReaderAsync2.html#GUID-DBFB6FE7-8C26-478D-B1BB-810F5B9CBAC8"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync(CommandBehavior behavior)",
                                            "href":"CommandExecuteReaderAsync3.html#GUID-C9BAFCC8-AFED-4BFE-8352-A1DDB7F2D819"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken)",
                                            "href":"CommandExecuteReaderAsync4.html#GUID-233C9BC9-BF25-4FA4-B9B0-09C881E6A477"
                                        },
                                        {
                                            "title":"ExecuteScalar",
                                            "href":"CommandExecuteScalar.html#GUID-53674A8B-2871-4129-AC0A-202BB8E0D5F3"
                                        },
                                        {
                                            "title":"ExecuteStream",
                                            "href":"CommandExecuteStream.html#GUID-4A8827A3-B709-4F86-8B73-FCFF4A144D59"
                                        },
                                        {
                                            "title":"ExecuteToStream",
                                            "href":"CommandExecuteToStream.html#GUID-13F47F4C-A9BE-4FFD-9277-AF89077DAF03"
                                        },
                                        {
                                            "title":"ExecuteScalarAsync",
                                            "href":"CommandExecuteScalarAsyncOverloads.html#GUID-911DC7F3-5C8A-42F6-AC9B-67671FFD4DC9"
                                        },
                                        {
                                            "title":"ExecuteScalarAsync()",
                                            "href":"CommandExecuteScalarAsync1.html#GUID-791D5687-39C7-4147-B4D2-060DA89AEEA8"
                                        },
                                        {
                                            "title":"ExecuteScalarAsync(CancellationToken cancellationToken)",
                                            "href":"CommandExecuteScalarAsync2.html#GUID-C535A35C-9CD9-4162-A208-CE730FF49DBB"
                                        },
                                        {
                                            "title":"ExecuteXmlReader",
                                            "href":"CommandExecuteXmlReader.html#GUID-5ACE58F5-335B-4104-B99C-EFFD29A74E2E"
                                        },
                                        {
                                            "title":"ExecuteXmlReaderAsync",
                                            "href":"CommandExecuteXmlReaderAsyncOverloads.html#GUID-127BC771-FD7F-4878-8516-43055E6C2214"
                                        },
                                        {
                                            "title":"ExecuteXmlReaderAsync()",
                                            "href":"CommandExecuteXmlReaderAsync1.html#GUID-9AA8D720-F891-4E5C-A9F7-2CCA5C944C0B"
                                        },
                                        {
                                            "title":"ExecuteXmlReaderAsync(CancellationToken)",
                                            "href":"CommandExecuteXmlReaderAsync2.html#GUID-C1DE02D5-A218-481D-B2CB-6B2DF683466C"
                                        },
                                        {
                                            "title":"Prepare",
                                            "href":"CommandPrepare.html#GUID-78190DD6-CFEE-403C-B51F-2C5388C3F558"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleCommandBuilder Class",
                            "href":"OracleCommandBuilderClass.html#GUID-FE018CDC-29C6-42DA-AD24-E0D874C4030C",
                            "topics":[
                                {
                                    "title":"OracleCommandBuilder Members",
                                    "href":"CommandBuilderMembers.html#GUID-4170AB29-8F99-404F-9218-FBB758155FDF"
                                },
                                {
                                    "title":"OracleCommandBuilder Constructors",
                                    "href":"CommandBuilderCtors.html#GUID-ED08B355-EEEE-4C01-8121-DE8FD5C505F2",
                                    "topics":[
                                        {
                                            "title":"OracleCommandBuilder()",
                                            "href":"CommandBuilderCtor1.html#GUID-6F59DDFA-22E1-4F2B-A5AB-78EC82C8C24C"
                                        },
                                        {
                                            "title":"OracleCommandBuilder(OracleDataAdapter)",
                                            "href":"CommandBuilderCtor2.html#GUID-1DC64D27-578A-4EDD-A78E-6E3ADEB85C42"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommandBuilder Static Methods",
                                    "href":"CommandBuilderStaticMethods.html#GUID-E3646B7A-0663-4D79-9DAD-CF56FF12DD23",
                                    "topics":[
                                        {
                                            "title":"DeriveParameters",
                                            "href":"CommandBuilderDeriveParameters.html#GUID-D5D64EE5-4330-4E29-81E3-86D9524B03CF"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommandBuilder Properties",
                                    "href":"CommandBuilderProperties.html#GUID-9ED178E3-B7E3-4389-9A30-7C5971DAFDAE",
                                    "topics":[
                                        {
                                            "title":"CaseSensitive",
                                            "href":"CommandBuilderCaseSensitive.html#GUID-6D9DD73D-792B-44C0-B49B-B726A88C2984"
                                        },
                                        {
                                            "title":"CatalogLocation",
                                            "href":"CommandBuilderCatalogLocation.html#GUID-5DEEEF6D-D4B8-4C52-8419-327322F1793F"
                                        },
                                        {
                                            "title":"CatalogSeparator",
                                            "href":"CommandBuilderCatalogSeparator.html#GUID-98B614FC-2253-4353-A3F7-BB82B04FD30B"
                                        },
                                        {
                                            "title":"ConflictOption",
                                            "href":"CommandBuilderConflictOption.html#GUID-403F526E-C177-44FF-A2E8-17E0C9EC119E"
                                        },
                                        {
                                            "title":"DataAdapter",
                                            "href":"CommandBuilderDataAdapter.html#GUID-BBA2A649-48CA-4AD1-BA51-F5C159B2084B"
                                        },
                                        {
                                            "title":"QuotePrefix",
                                            "href":"CommandbuilderQuotePrefix.html#GUID-2A3739FF-099E-4D4D-8A3F-585FCD89CBE1"
                                        },
                                        {
                                            "title":"QuoteSuffix",
                                            "href":"CommandbuilderQuoteSuffix.html#GUID-2C298DE1-B8E4-47E4-A8C1-250B412ED190"
                                        },
                                        {
                                            "title":"SchemaSeparator",
                                            "href":"CommandBuilderSchemaSeparator.html#GUID-1D41D305-A7C7-4EB5-9E19-BEA40AF4123D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommandBuilder Public Methods",
                                    "href":"CommandBuilderPublicMethods.html#GUID-956F7854-3F83-421A-B6B2-292311C1555A",
                                    "topics":[
                                        {
                                            "title":"GetDeleteCommand",
                                            "href":"CommandBuilderGetDeleteCommandOverloads.html#GUID-CC99E9AB-A7A2-41A3-AA8A-ED6F9701C0EF"
                                        },
                                        {
                                            "title":"GetDeleteCommand()",
                                            "href":"CommandBuilderGetDeleteCommand1.html#GUID-82C29670-DDCB-4880-81F2-99C76198FFF4"
                                        },
                                        {
                                            "title":"GetDeleteCommand(bool)",
                                            "href":"CommandBuilderGetDeleteCommand2.html#GUID-8AEB275A-89BE-4E78-A227-E5CA6F3CDF8B"
                                        },
                                        {
                                            "title":"GetInsertCommand",
                                            "href":"CommandBuilderGetInsertCommandOverloads.html#GUID-6709D904-DC22-47B4-8135-51C46413D34A"
                                        },
                                        {
                                            "title":"GetInsertCommand()",
                                            "href":"CommandBuilderGetInsertCommand1.html#GUID-60168F8C-3B1F-47EF-B49B-0E99078450EA"
                                        },
                                        {
                                            "title":"GetInsertCommand(bool)",
                                            "href":"CommandBuilderGetInsertCommand2.html#GUID-45E4F544-5992-4597-B6BB-F131A0723494"
                                        },
                                        {
                                            "title":"GetUpdateCommand",
                                            "href":"CommandBuilderGetUpdateCommandOverloads.html#GUID-1C42DD35-6B5E-4968-B295-773E8AD8EE90"
                                        },
                                        {
                                            "title":"GetUpdateCommand()",
                                            "href":"CommandBuilderGetUpdateCommand1.html#GUID-385C4F56-8C3D-471F-9511-8C7E7B12F57E"
                                        },
                                        {
                                            "title":"GetUpdateCommand(bool)",
                                            "href":"CommandBuilderGetUpdateCommand2.html#GUID-0948EBB1-586D-49AF-A8E1-64C946F76915"
                                        },
                                        {
                                            "title":"QuoteIdentifier",
                                            "href":"CommandBuilderQuoteIdentifier.html#GUID-BA74EE9E-F91F-40A0-A720-A5F916FE73F8"
                                        },
                                        {
                                            "title":"RefreshSchema",
                                            "href":"CommandBuilderRefreshSchema.html#GUID-1F855E71-016E-4216-8EAC-705825A6C950"
                                        },
                                        {
                                            "title":"UnquoteIdentifier",
                                            "href":"CommandBuilderUnquoteIdentifier.html#GUID-0F335652-691C-40D4-90FC-0113FAF0C8EF"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCommandBuilder Events",
                                    "href":"CommandBuilderEvents.html#GUID-2B69C1FD-9EBE-4D8C-9AFF-FBC121F1BE8D"
                                }
                            ]
                        },
                        {
                            "title":"OracleConfiguration Class",
                            "href":"OracleConfigurationClass.html#GUID-F1F71D03-CBB8-4173-A883-0878DA84D11A",
                            "topics":[
                                {
                                    "title":"OracleConfiguration Members",
                                    "href":"OracleConfigurationMembers.html#GUID-1E7847C9-8B76-4F9A-A0BD-6579C13562AF"
                                },
                                {
                                    "title":"OracleConfiguration Methods",
                                    "href":"OracleConfigurationMethods.html#GUID-173F91DE-7B7C-4008-A2C0-1BCB0AB475C5",
                                    "topics":[
                                        {
                                            "title":"DisableConnectionStringAllowedProperties",
                                            "href":"ConfigurationDisableConnectionStringAllowedProperties.html#GUID-A3330BB9-9608-4A3B-8E48-CAF1074C802B"
                                        },
                                        {
                                            "title":"EnableConnectionStringAllowedProperties",
                                            "href":"ConfigurationEnableConnectionStringAllowedPropertiesOverloads.html#GUID-14F53E35-5043-4D1D-B8FA-99BB70A5298C"
                                        },
                                        {
                                            "title":"EnableConnectionStringAllowedProperties(string, bool)",
                                            "href":"ConfigurationEnableConnectionStringAllowedProperties1.html#GUID-20F08129-1F05-4BB6-9648-475A442C90D2"
                                        },
                                        {
                                            "title":"EnableConnectionStringAllowedProperties(FileInfo, bool)",
                                            "href":"ConfigurationEnableConnectionStringAllowedProperties2.html#GUID-4F60F7AB-789B-44FD-94D6-698315827FE6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Connection Properties",
                                    "href":"ConfigurationConnectionProperties.html#GUID-36D84977-9EAE-4ED0-90B4-242638D9C53D",
                                    "topics":[
                                        {
                                            "title":"ConfigurationProviders",
                                            "href":"ConfigurationConfigurationProviders.html#GUID-98E0A11A-F9D9-48FD-935B-1B338B32F821"
                                        },
                                        {
                                            "title":"DatabaseCharset",
                                            "href":"ConfigurationDatabaseCharset.html#GUID-E1D5B500-02CA-416B-AE6A-067FF74D3663"
                                        },
                                        {
                                            "title":"DatabaseNCharset",
                                            "href":"ConfigurationDatabaseNCharset.html#GUID-EA2D1F61-EABE-4914-B0B3-E5C5A845281D"
                                        },
                                        {
                                            "title":"DatabaseEditionName",
                                            "href":"ConfigurationDatabaseEditionName.html#GUID-BAA8AFA6-028E-4E2A-9D3F-20F0C16F20A2"
                                        },
                                        {
                                            "title":"DisableOOB",
                                            "href":"ConfigurationDisableOOB.html#GUID-7C77807F-A486-4D5A-8BA0-D39FE25078F2"
                                        },
                                        {
                                            "title":"DrcpConnectionClass",
                                            "href":"ConfigurationDrcpConnectionClass.html#GUID-C92C3AB5-96DA-463B-BCA8-B4D9638E4627"
                                        },
                                        {
                                            "title":"HostnameDefaultServiceIsHost",
                                            "href":"ConfigurationHostnameDefaultServicesIsHost.html#GUID-CDC0DD96-F9ED-40B4-9377-7C00E3104625"
                                        },
                                        {
                                            "title":"MapVectorColumnAsClob",
                                            "href":"ConfigurationMapVectorColumnAsClob.html#GUID-C0FF3795-420F-4671-B586-E139B05ACABD"
                                        },
                                        {
                                            "title":"NamesDirectoryPath",
                                            "href":"ConfigurationNamesDirectoryPath.html#GUID-8E97FA6D-224B-4CEF-BC16-2DD7BDEBD5F3"
                                        },
                                        {
                                            "title":"OciCompartment",
                                            "href":"ConfigurationOciCompartment.html#GUID-BFA53DF4-8493-46FD-917A-C8E19539E3A8"
                                        },
                                        {
                                            "title":"OciConfigurationFile",
                                            "href":"ConfigurationOciConfigurationFile.html#GUID-A8A94426-F6D0-47A9-9BD1-944C94F7388C"
                                        },
                                        {
                                            "title":"OciDatabase",
                                            "href":"ConfigurationOciDatabase.html#GUID-7F987B36-9779-4A58-BD87-73D9F869AEFC"
                                        },
                                        {
                                            "title":"OciIamUrl",
                                            "href":"ConfigurationOciIamUrl.html#GUID-8ED91200-EC3B-40B9-8FEC-3B00AE1C22FC"
                                        },
                                        {
                                            "title":"OciProfile",
                                            "href":"ConfigurationOciProfile.html#GUID-672F3566-E88D-41EB-B732-BC79CE905D83"
                                        },
                                        {
                                            "title":"OciTenacy",
                                            "href":"ConfigurationOciTenacy.html#GUID-EE40A824-0BD3-4732-B3A5-B26C7715FD6E"
                                        },
                                        {
                                            "title":"OracleDataSources",
                                            "href":"ConfigurationOracleDataSources.html#GUID-92D5170C-16B6-479B-8626-88B8BEFD7B34"
                                        },
                                        {
                                            "title":"SuppressGetDecimalInvalidCastException",
                                            "href":"ConfigurationSuppressGetDecimalInvalidCastException.html#GUID-C4C104D0-270E-43F6-83CB-CE0FE49432BC"
                                        },
                                        {
                                            "title":"TAFUsePooledConnections",
                                            "href":"ConfigurationTAFUsePooledConnections.html#GUID-513D8705-2937-4D52-BCF9-A696CA0C7C4C"
                                        },
                                        {
                                            "title":"TcpConnectTimeout",
                                            "href":"ConfigurationTcpConnectTimeout.html#GUID-D38C72DF-14C5-40D6-B559-9911BFF5DB87"
                                        },
                                        {
                                            "title":"TimeZoneFileLocation",
                                            "href":"ConfigurationTimeZoneFileLocation.html#GUID-126A1F80-9F1D-4160-A0D8-6FB9BA003ECA"
                                        },
                                        {
                                            "title":"TnsAdmin",
                                            "href":"ConfigurationTnsAdmin.html#GUID-30FDA896-3814-455B-9D45-6512705D95D3"
                                        },
                                        {
                                            "title":"UseSNI",
                                            "href":"ConfiguationUseSNI.html#GUID-1CCE5953-4E34-45F8-945E-E370530A1D75"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Secure Connection Properties",
                                    "href":"ConfigurationSecureConnectionProperties.html#GUID-AD618594-5CE7-4F02-8B43-9A01118308F7",
                                    "topics":[
                                        {
                                            "title":"AllowUncPaths",
                                            "href":"ConfigurationAllowUncPaths.html#GUID-D42D7F6D-545B-4C97-8228-C00175825F07"
                                        },
                                        {
                                            "title":"PasswordAuthentication",
                                            "href":"ConfigurationPasswordAuthentication.html#GUID-58F30FB0-414C-41CB-BC4E-E2B76ECBFFDD"
                                        },
                                        {
                                            "title":"SEPSWalletLocation",
                                            "href":"ConfigurationSEPSWalletLocation.html#GUID-0F0169DF-4BA4-48E2-A348-E4E22F5A1922"
                                        },
                                        {
                                            "title":"SEPSWalletPassword",
                                            "href":"ConfigurationSEPSWalletPassword.html#GUID-6B1056BA-15BA-4519-8C64-D23DC674D55E"
                                        },
                                        {
                                            "title":"SqlNetAllowedLogonVersionClient",
                                            "href":"ConfigurationAllowedLogonVersionClient.html#GUID-957B7ADA-C3CB-41B0-92DD-176130B1205C"
                                        },
                                        {
                                            "title":"SqlNetAllowWeakCrypto",
                                            "href":"ConfigurationSqlNetAllowWeakCrypto.html#GUID-7C7698DF-0B86-490E-A541-A274E3822F09"
                                        },
                                        {
                                            "title":"SqlNetAuthenticationServices",
                                            "href":"ConfigurationSqlNetAuthenticationServices.html#GUID-81012BD5-D4AC-4F8D-9B8D-55673C03B41E"
                                        },
                                        {
                                            "title":"SqlNetCloudUser",
                                            "href":"ConfigurationSqlNetCloudUser.html#GUID-77D89C07-7A78-429A-98AD-D0A04E043E2D"
                                        },
                                        {
                                            "title":"SqlNetCryptoChecksumClient",
                                            "href":"ConfigurationSqlNetCryptoChecksumClient.html#GUID-5AFD419B-6EC6-47DF-8D9C-53E001349D36"
                                        },
                                        {
                                            "title":"SqlNetCryptoChecksumTypesClient",
                                            "href":"ConfigurationSqlNetCryptoChecksumTypesClient.html#GUID-4D8A2250-F18E-473F-8B62-7CB2CB97329A"
                                        },
                                        {
                                            "title":"SqlNetEncryptionClient",
                                            "href":"ConfigurationSqlNetEncryptionClient.html#GUID-0FF66753-1204-4B77-9A10-14B9438BEC8A"
                                        },
                                        {
                                            "title":"SqlNetEncryptionTypesClient",
                                            "href":"ConfigurationSqlNetEncryptionTypesClient.html#GUID-3823BFD7-2529-4D4F-A6F3-55093AAED20C"
                                        },
                                        {
                                            "title":"SqlNetIgnoreANOEncrytionForTCPS",
                                            "href":"ConfigurationSqlNetIgnoreANOEncrytionForTCPS.html#GUID-67D4B682-CA44-4CCC-903F-1CAA479BADEC"
                                        },
                                        {
                                            "title":"SqlNetWalletOverride",
                                            "href":"ConfigurationSqlNetWalletOverride.html#GUID-75BCFD85-8641-46D0-B65F-3B1132C957F1"
                                        },
                                        {
                                            "title":"SqlNetURI",
                                            "href":"ConfigurationSqlNetURI.html#GUID-71FB62F0-3F84-42A0-8761-10F037B3E3B9"
                                        },
                                        {
                                            "title":"SSLCertificateThumbprint",
                                            "href":"ConfigurationSSLCertificateThumbprint.html#GUID-CCE83352-ABD2-46F9-9F34-6C5B8E8C271C"
                                        },
                                        {
                                            "title":"SSLServerDNMatch",
                                            "href":"ConfigurationSSLServerDNMatch.html#GUID-E90850ED-767E-4948-9FA7-91005FBF18EA"
                                        },
                                        {
                                            "title":"SSLVersion",
                                            "href":"ConfigurationSSLVersion.html#GUID-FD58A6C5-0551-4874-8D79-B7670C6836F0"
                                        },
                                        {
                                            "title":"TLSExcludeVersion",
                                            "href":"ConfigurtionTLSExcludeVersion.html#GUID-7D29CA73-A430-45AE-83CD-61023EFD44DF"
                                        },
                                        {
                                            "title":"TLSVersion",
                                            "href":"ConfigurtionTLSVersion.html#GUID-1603F49A-5C70-45D2-8C34-BCB847E41681"
                                        },
                                        {
                                            "title":"TokenAuthentication",
                                            "href":"ConfigurationTokenAuthentication.html#GUID-43706D6E-6B6C-492E-8D6E-0F9E7D96718C"
                                        },
                                        {
                                            "title":"TokenLocation",
                                            "href":"ConfigurationTokenLocation.html#GUID-F2BE1BCE-3B0C-41D7-A5C4-576832C2FB83"
                                        },
                                        {
                                            "title":"UseMITKerberos",
                                            "href":"ConfigurtionUseMITKerberos.html#GUID-12DEDFA0-6771-474D-A1E5-D5BA5F2C5031"
                                        },
                                        {
                                            "title":"WalletLocation",
                                            "href":"ConfigurationWalletLocation.html#GUID-1CF9B2C8-83A4-4445-B7DD-ED1EB2DE0313"
                                        },
                                        {
                                            "title":"WalletPassword",
                                            "href":"ConfigurationWalletPassword.html#GUID-C2B27E39-31EB-43DB-8D1D-B1BD38D39FCE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Command Properties",
                                    "href":"ConfigurationCommandProperties.html#GUID-B395BB6B-ED18-42FC-8445-57B238ECEF35",
                                    "topics":[
                                        {
                                            "title":"AddOracleTypesDeserialization",
                                            "href":"ConfigurationAddOracleTypesDeserialization.html#GUID-3303BAA0-D55B-47C1-A34B-D1E350742471"
                                        },
                                        {
                                            "title":"BindByName",
                                            "href":"ConfigurationBindByName.html#GUID-2C48877A-6B06-46ED-A250-5689F61982B9"
                                        },
                                        {
                                            "title":"CommandTimeout",
                                            "href":"ConfigurationCommandTimeout.html#GUID-57A74A1E-11EE-4B65-9980-23753049CF17"
                                        },
                                        {
                                            "title":"GetDecimalRetainTrailingZeros",
                                            "href":"ConfigurationGetDecimalRetainTrailingZeros.html#GUID-395F60C5-7206-46A2-8249-7E31168839F6"
                                        },
                                        {
                                            "title":"ProviderTypeNLSSensitiveToString",
                                            "href":"ConfigurationProviderTypeNLSSensitiveToString.html#GUID-293B134B-D802-41A9-AEAB-D3916147C169"
                                        },
                                        {
                                            "title":"UseClientInitiatedCQN",
                                            "href":"ConfigurationUseClientInitiatedCQN.html#GUID-02353048-5FD3-4C2C-A4DF-DFEEF30F2449"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Directories Properties",
                                    "href":"ConfigurationDirectoriesProperties.html#GUID-B966ACFC-FE33-4DAC-B048-03DED04CE23B",
                                    "topics":[
                                        {
                                            "title":"DefaultAdminContext",
                                            "href":"ConfigurationDefaultAdminContext.html#GUID-3E5F4A2C-F8C6-4116-BFF6-7E5305D1EDC6"
                                        },
                                        {
                                            "title":"DirectoryServers",
                                            "href":"ConfigurationDirectoryServers.html#GUID-DA509CEB-ECED-4770-86EE-3FFABDD4977D"
                                        },
                                        {
                                            "title":"DirectoryServerType",
                                            "href":"ConfigurationDirectoryServerType.html#GUID-ED5585A1-C705-4272-9AC1-A0C03EB8F82D"
                                        },
                                        {
                                            "title":"LdapAdmin",
                                            "href":"ConfigurationLdapAdmin.html#GUID-CD17B8C8-6BD3-4054-9974-3C41C71F36FA"
                                        },
                                        {
                                            "title":"NamesLdapAuthenticateBind",
                                            "href":"ConfigurationNamesLdapAuthenticateBind.html#GUID-652E05A4-439A-48D1-87FA-47BD2932BF4B"
                                        },
                                        {
                                            "title":"NamesLdapAuthenticateBindMethod",
                                            "href":"ConfigurationNamesLdapAuthenticateBindMethod.html#GUID-5F9B35EA-174D-45AC-A88E-DB422819673A"
                                        },
                                        {
                                            "title":"NamesLdapConnTimeout",
                                            "href":"ConfigurationNamesLdapConnTimeout.html#GUID-1E0CA5CD-5197-4A3D-A1DE-1DD5B2500662"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration High Availability Properties",
                                    "href":"ConfigurationHighAvailabilityProperties.html#GUID-C1513965-890C-4731-B013-992CB7335494",
                                    "topics":[
                                        {
                                            "title":"ChunkMigrationConnectionTimeout",
                                            "href":"ConfigurationChunkMigrationConnectionTimeout.html#GUID-7AC4C284-76BD-4D32-832C-C72FA4995D32"
                                        },
                                        {
                                            "title":"DbNotificationAddress",
                                            "href":"ConfigurationDbNotificationAddress.html#GUID-4FB4B38C-AE5B-43C7-B0C5-C2C5DB9401CD"
                                        },
                                        {
                                            "title":"DbNotificationPort",
                                            "href":"ConfigurationDbNotificationPort.html#GUID-1A84CA41-66AA-4F4F-B780-9CB78C831D89"
                                        },
                                        {
                                            "title":"DistributedTransactionRecoveryAddress",
                                            "href":"ConfigurationDistributedTransactionRecoveryAddress.html#GUID-ABA448E8-8B25-417F-8BF9-97BCBDE23762"
                                        },
                                        {
                                            "title":"DistributedTransactionRecoveryPort",
                                            "href":"ConfigurationDistributedTransactionRecoveryPort.html#GUID-1344DA08-4C3B-4197-A180-3BDAA7CC87D6"
                                        },
                                        {
                                            "title":"DistributedTransactionTimeToLive",
                                            "href":"ConfigurationDistributedTransactionTimeToLive.html#GUID-FEF62125-C1B4-48A7-B512-55E42C7613BB"
                                        },
                                        {
                                            "title":"HAEvents",
                                            "href":"ConfigurationHAEvents.html#GUID-DBF9C345-0F93-45F0-B34C-DF77C0B857EE"
                                        },
                                        {
                                            "title":"MaxCallsPerRequestBoundary",
                                            "href":"ConfigurationMaxCallsPerRequestBoundary.html#GUID-DC3A6E27-0ECC-4AEB-9187-E2F25F11094E"
                                        },
                                        {
                                            "title":"OnsConfigFile",
                                            "href":"ConfigurationOnsConfigFile.html#GUID-EBA2D76A-594D-4F00-A18B-75A21BCF564A"
                                        },
                                        {
                                            "title":"OnsMode",
                                            "href":"ConfigurationOnsMode.html#GUID-8FA9D38D-71F8-42CD-8331-7ADEA6EED0B2"
                                        },
                                        {
                                            "title":"OnsProtocol",
                                            "href":"ConfigurationOnsProtocol.html#GUID-14DDC3C0-129F-4870-BF13-4BD4F700C8D9"
                                        },
                                        {
                                            "title":"OnsWalletLocation",
                                            "href":"ConfigurationOnsWalletLocation.html#GUID-B69B6445-6A22-477E-9C1D-2BF12BB649B6"
                                        },
                                        {
                                            "title":"OracleOnsServers",
                                            "href":"ConfigurationOracleOnsServers.html#GUID-7BAF0B81-E0D5-4D07-88F6-F172B83A36F7"
                                        },
                                        {
                                            "title":"ServiceRelocationConnectionTimeout",
                                            "href":"ConfigurationServiceRelocationConnectionTimeout.html#GUID-0D60966B-A3C7-4CA5-A5DE-764BFE147DD9"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Performance Properties",
                                    "href":"ConfigurationPerformanceProperties.html#GUID-83A912BE-A655-4050-B704-0243FA39460B",
                                    "topics":[
                                        {
                                            "title":"DefaultSDUSize",
                                            "href":"ConfigurationDefaultSDUSize.html#GUID-E76BF27F-3711-4AB2-B0B2-4F956B91EB44"
                                        },
                                        {
                                            "title":"FetchSize",
                                            "href":"ConfigurationFetchSize.html#GUID-2DBC9CFF-9D47-4746-B7FC-1C2F17076D18"
                                        },
                                        {
                                            "title":"LoadBalancing",
                                            "href":"ConfigurationLoadBalancing.html#GUID-ABA98731-13FE-4444-BD88-FC509D7BBE56"
                                        },
                                        {
                                            "title":"MaxStatementCacheSize",
                                            "href":"ConfigurationMaxStatementCacheSize.html#GUID-62E036EC-56C4-4502-BB55-C06315CC2DF4"
                                        },
                                        {
                                            "title":"PerformanceCounters",
                                            "href":"ConfigurationPerformanceCounters.html#GUID-74D7279B-A4DA-4FE7-BACC-3F7A17556A65"
                                        },
                                        {
                                            "title":"Pipelining",
                                            "href":"ConfigurationPipelining.html#GUID-CB2C3582-06DF-40B5-9A3B-204476D96AC8"
                                        },
                                        {
                                            "title":"ReceiveBufferSize",
                                            "href":"ConfigurationReceiveBufferSize.html#GUID-2B9FEB9D-F394-42AE-934D-0AC1812AEDBB"
                                        },
                                        {
                                            "title":"RowsToFetchPerRoundTrip",
                                            "href":"ConfigurationRowsToFetchPerRoundTrip.html#GUID-0F734332-77D2-4585-8EC2-B9A81588387A"
                                        },
                                        {
                                            "title":"SelfTuning",
                                            "href":"ConfigurationSelfTuning.html#GUID-ACB174B6-C9B5-45AB-AB37-09F2F3554AD7"
                                        },
                                        {
                                            "title":"SendBufferSize",
                                            "href":"ConfigurationSendBufferSize.html#GUID-A543E0F0-CC04-4087-BF7C-3AEF53C3569A"
                                        },
                                        {
                                            "title":"StatementCacheSize",
                                            "href":"ConfigurationStatementCacheSize.html#GUID-4F5B67F7-E5AD-4487-B17D-5B66884BD946"
                                        },
                                        {
                                            "title":"TcpNoDelay",
                                            "href":"ConfigurationTcpNoDelay.html#GUID-81FFF215-3971-4928-A56E-4F7EE9738B4C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConfiguration Diagnostics and Tracing Properties",
                                    "href":"ConfigurationDebugTracingProperties.html#GUID-55BC401E-4C25-44D3-ADAD-54B70FECE60A",
                                    "topics":[
                                        {
                                            "title":"ConnectionIdPrefix",
                                            "href":"ConfigurationConnectionIdPrefix.html#GUID-F85ABC3F-1EF5-48CF-A5A7-C134566D3F32"
                                        },
                                        {
                                            "title":"OpenTelemetryTracing",
                                            "href":"ConfigurationOpenTelemetryTracing.html#GUID-91321787-F2BC-440C-AE63-03CB1866AC30"
                                        },
                                        {
                                            "title":"PoolNames",
                                            "href":"ConfigurationPoolNames.html#GUID-987080B2-B134-46F3-9C8E-40E3C9E9F770"
                                        },
                                        {
                                            "title":"Program",
                                            "href":"ConfigurationProgram.html#GUID-36C16C42-A7BB-4F95-826A-1DFA76A0A5EA"
                                        },
                                        {
                                            "title":"SuppressErrorURL",
                                            "href":"ConfigurationSuppressErrorURL.html#GUID-4B678847-A1DD-427C-B9C1-922BCDF80191"
                                        },
                                        {
                                            "title":"TraceFileLocation",
                                            "href":"ConfigurationTraceFileLocation.html#GUID-7B942251-9D1C-4DC3-998C-D07A8EC3E811"
                                        },
                                        {
                                            "title":"TraceFileMaxSize",
                                            "href":"ConfigurationTraceFileMaxSize.html#GUID-6E8CDEE2-950F-4512-9DBC-FABD0073BADC"
                                        },
                                        {
                                            "title":"TraceLevel",
                                            "href":"ConfigurationTraceLevel.html#GUID-E4A2B13E-E0AC-4E79-BCD9-51C4DBBBFEA5"
                                        },
                                        {
                                            "title":"TraceOption",
                                            "href":"ConfigurationTraceOption.html#GUID-7883A515-237A-4379-A9DC-A263043D143E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleConfigurationProvider Class",
                            "href":"OracleConfigurationProviderClass.html#GUID-A0793A6F-9D9E-41AF-931D-DDFC08CEA2A8"
                        },
                        {
                            "title":"OracleConnection Class",
                            "href":"OracleConnectionClass.html#GUID-A8BFA792-97D6-423B-9548-80CA0652174E",
                            "topics":[
                                {
                                    "title":"OracleConnection Members",
                                    "href":"ConnectionMembers.html#GUID-4DE91FF2-45DB-4996-904A-96B37B467EC3"
                                },
                                {
                                    "title":"OracleConnection Constructors",
                                    "href":"ConnectionCtors.html#GUID-D15E6EB0-8B1B-444E-A832-161A10ADBD6F",
                                    "topics":[
                                        {
                                            "title":"OracleConnection()",
                                            "href":"ConnectionCtor1.html#GUID-4B6FC1E3-698B-4263-A9F8-F60E8DCC91BF"
                                        },
                                        {
                                            "title":"OracleConnection(string)",
                                            "href":"ConnectionCtor2.html#GUID-6D54A5D3-A757-47F9-AE35-83A302C63EFF"
                                        },
                                        {
                                            "title":"OracleConnection(string, OracleCredential)",
                                            "href":"ConnectionCtor3.html#GUID-6A2AB728-45F0-4ED4-AEC3-FC9F58B72960"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnection Static Methods",
                                    "href":"ConnectionStaticMethods.html#GUID-9791655E-E77D-443D-9851-7C39CCF4FD6C",
                                    "topics":[
                                        {
                                            "title":"ClearAllPools",
                                            "href":"ConnectionClearAllPools.html#GUID-1513DFA2-00EA-446D-8C28-052A9B2B583A"
                                        },
                                        {
                                            "title":"ClearPool",
                                            "href":"ConnectionClearPool.html#GUID-193C5A10-0808-472B-BE0F-C906BC72EC2C"
                                        },
                                        {
                                            "title":"ClearInteractiveTokenCache",
                                            "href":"ConnectionClearInteractiveTokenCache.html#GUID-7ED701F2-274E-400C-88CC-8971C49903B6"
                                        },
                                        {
                                            "title":"UnregisterCloudConfigNotification",
                                            "href":"ConnectionUnregisterCloudConfigNotification.html#GUID-B4CE0DE8-535E-411D-ADD6-B77A163D835A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnection Properties",
                                    "href":"ConnectionProperties.html#GUID-8C3065D0-9EA1-4086-B8FD-2927703B006C",
                                    "topics":[
                                        {
                                            "title":"AccessToken",
                                            "href":"ConnectionAccessToken.html#GUID-8C00AF27-AC05-4B31-91E7-2979A6E8D07C"
                                        },
                                        {
                                            "title":"ActionName",
                                            "href":"ConnectionActionName.html#GUID-DD91ACC4-D039-4CD5-9A6F-9C798F83F003"
                                        },
                                        {
                                            "title":"AllowCertificateSelectionUI",
                                            "href":"ConnectionAllowCertificateSelectionUI.html#GUID-644C539F-E514-45A6-B3DC-C638DDEA0F6A"
                                        },
                                        {
                                            "title":"AutoCommit",
                                            "href":"ConnectionIsInAutoCommit.html#GUID-0CF1A8FA-2D20-419D-8145-78EDC95FFC22"
                                        },
                                        {
                                            "title":"AutoProxy",
                                            "href":"ConnectionAutoProxy.html#GUID-9FC75621-7D3D-477B-9FA2-F9A2B8539BDA"
                                        },
                                        {
                                            "title":"BindByName",
                                            "href":"ConnectionBindByName.html#GUID-B85C9522-F37C-4814-8946-A056D1042F3E"
                                        },
                                        {
                                            "title":"ChunkMigrationConnectionTimeout",
                                            "href":"ConnectionChunkMigrationConnectionTimeout.html#GUID-60E96398-67A0-4CB5-8C45-A7E965D14872"
                                        },
                                        {
                                            "title":"ClientId",
                                            "href":"ConnectionClientId.html#GUID-2F345284-B509-42FE-AB92-57B7BFCCAF55"
                                        },
                                        {
                                            "title":"ClientInfo",
                                            "href":"ConnectionClientInfo.html#GUID-0AB16782-88DE-461A-85C7-7F9E07DF254A"
                                        },
                                        {
                                            "title":"ClientTimeZoneFileVersion",
                                            "href":"ConnectionClientTimeZoneFileVersion.html#GUID-29CBB5EC-021C-4DE4-9B64-DAF5098B469F"
                                        },
                                        {
                                            "title":"CommandTimeout",
                                            "href":"ConnectionCommandTimeout.html#GUID-E9090BAF-9283-4C12-A5B0-1CDA2AFCC846"
                                        },
                                        {
                                            "title":"ConnectionIdPrefix",
                                            "href":"ConnectionConnectionIdPrefix.html#GUID-5567D57D-83EF-4DB9-BA66-651662EF7C5B"
                                        },
                                        {
                                            "title":"ConnectionString",
                                            "href":"ConnectionConnectionString.html#GUID-DF4ED9A3-1AAF-445D-AEEF-016E6CD5A0C0"
                                        },
                                        {
                                            "title":"ConnectionTimeout",
                                            "href":"ConnectionConnectionTimeout.html#GUID-43D3CBFA-964E-494E-8953-195DF63D549A"
                                        },
                                        {
                                            "title":"ConnectionType",
                                            "href":"ConnectionConnectionType.html#GUID-27DF511C-AC78-40DA-A45F-44A2724CEEB4"
                                        },
                                        {
                                            "title":"Credential",
                                            "href":"ConnectionCredential.html#GUID-C443C82E-DC95-4E00-A662-8D972FEC1D92"
                                        },
                                        {
                                            "title":"Database",
                                            "href":"ConnectionDatabase.html#GUID-80D9BAD4-6FC3-4A3E-909E-2862F89A634D"
                                        },
                                        {
                                            "title":"DatabaseCharset",
                                            "href":"ConnectionDatabaseCharset.html#GUID-F0B646B3-B519-4BD2-9AB6-BC30E1644AEE"
                                        },
                                        {
                                            "title":"DatabaseNCharset",
                                            "href":"ConnectionDatabaseNCharset.html#GUID-B0F1FBA5-71CC-495A-9EA7-74621CAA91C9"
                                        },
                                        {
                                            "title":"DatabaseDomainName",
                                            "href":"ConnectionDatabaseDomainName.html#GUID-23DCD4C5-DB3E-42FA-BE6C-F0CEE4877E56"
                                        },
                                        {
                                            "title":"DatabaseEditionName",
                                            "href":"ConnectionDatabaseEditionName.html#GUID-052F4129-0B71-4636-9464-6FBCE96D1072"
                                        },
                                        {
                                            "title":"DatabaseMaxIdentifierLength",
                                            "href":"ConnectionDatabaseMaxIdentifierLength.html#GUID-9ED0DD31-A411-478B-902E-1665DA3E3DBF"
                                        },
                                        {
                                            "title":"DatabaseName",
                                            "href":"ConnectionDatabaseName.html#GUID-4988F7D5-E424-4FB3-90A9-5307520CEFDF"
                                        },
                                        {
                                            "title":"DatabaseTimeZoneFileVersion",
                                            "href":"ConnectionDatabaseTimeZoneFileVersion.html#GUID-8258674F-4E79-4BFA-B78A-8D030B4FC98C"
                                        },
                                        {
                                            "title":"DataSource",
                                            "href":"ConnectionDatasource.html#GUID-0CC8BE32-4634-4AFA-8B5F-315CC41C922F"
                                        },
                                        {
                                            "title":"DRCPConnectionClass",
                                            "href":"ConnectionDRCPConnectionClass.html#GUID-7AF8E7A9-4F0F-4639-AED0-1E76135D8E22"
                                        },
                                        {
                                            "title":"DRCPPurity",
                                            "href":"ConnectionDRCPPurity.html#GUID-E486AA85-D3B3-4483-8E34-E500E0B925BF"
                                        },
                                        {
                                            "title":"FetchSize",
                                            "href":"ConnectionFetchSize.html#GUID-E0B306CA-79F9-4BC5-99A9-013B4F41C5CE"
                                        },
                                        {
                                            "title":"HostName",
                                            "href":"ConnectionHostName.html#GUID-38E13184-8672-4722-8507-D782752230C6"
                                        },
                                        {
                                            "title":"HttpsProxy",
                                            "href":"ConnectionHttpsProxy.html#GUID-E130C8A4-E7C0-4E48-969F-DA08B0D0C43C"
                                        },
                                        {
                                            "title":"HttpsProxyPort",
                                            "href":"ConnectionHttpsProxyPort.html#GUID-DC878375-8E3A-49C8-9D46-C3AAF04EAC0D"
                                        },
                                        {
                                            "title":"InstanceName",
                                            "href":"ConnectionInstanceName.html#GUID-B527322F-E550-4379-9C20-26250AAF940E"
                                        },
                                        {
                                            "title":"IsInTransaction",
                                            "href":"ConnectionIsInTransaction.html#GUID-1ACCA190-B916-4CF2-A54B-7382BF770A35"
                                        },
                                        {
                                            "title":"IsNNEChecksummed",
                                            "href":"ConnectionIsNNEChecksummed.html#GUID-E1A53C28-4BB4-441F-8EDB-28AFB08090AB"
                                        },
                                        {
                                            "title":"IsNNEEncypted",
                                            "href":"ConnectionIsNNEEncypted.html#GUID-54309CEF-59E9-48C0-8062-C33AD4B1ADD1"
                                        },
                                        {
                                            "title":"IsTLSEncrypted",
                                            "href":"ConnectionIsTLSEncrypted.html#GUID-71388380-6469-4E5E-9C43-ADECBB23DE93"
                                        },
                                        {
                                            "title":"KeepAlive",
                                            "href":"ConnectionKeepAlive.html#GUID-6C24C49B-5E89-4E62-BEB8-828D3B1B47D7"
                                        },
                                        {
                                            "title":"KeepAliveInterval",
                                            "href":"ConnectionKeepAliveInterval.html#GUID-ED6AE59F-F97F-4E25-B8A1-D6C0BD5CF516"
                                        },
                                        {
                                            "title":"KeepAliveTime",
                                            "href":"ConnectionKeepAliveTime.html#GUID-CBF5E160-AE1F-4147-AA7C-2CD4E23EE105"
                                        },
                                        {
                                            "title":"MaxStatementCacheSize",
                                            "href":"ConnectionMaxStatementCacheSize.html#GUID-ADCCABFB-B0BD-4AF0-BB8D-46EE42597922"
                                        },
                                        {
                                            "title":"ModuleName",
                                            "href":"ConnectionModuleName.html#GUID-5F5FA93F-8F9E-4086-AD65-864F68AA64E8"
                                        },
                                        {
                                            "title":"NamesDirectoryPath",
                                            "href":"ConnectionNamesDirectoryPath.html#GUID-5C4D8C30-A250-403E-B9BE-E9C993E17B06"
                                        },
                                        {
                                            "title":"OciCompartment",
                                            "href":"ConnectionOciCompartment.html#GUID-BB03043D-4105-4842-BDFE-D62E95778E09"
                                        },
                                        {
                                            "title":"OciDatabase",
                                            "href":"ConnectionOciDatabase.html#GUID-570030C1-DC55-4ACB-BB3A-A4AB53430778"
                                        },
                                        {
                                            "title":"OciIamUrl",
                                            "href":"ConnectionOciIamUrl.html#GUID-3D59E89A-CDB8-4268-A1C4-7F5F19F36E03"
                                        },
                                        {
                                            "title":"OciTenacy",
                                            "href":"ConnectionOciTenacy.html#GUID-D4D5C1E2-2ED1-42C1-A100-532137A78CF0"
                                        },
                                        {
                                            "title":"PasswordAuthentication",
                                            "href":"ConnectionPasswordAuthentication.html#GUID-76E762B1-5DA6-4BC9-B6D6-4CBCD8008B11"
                                        },
                                        {
                                            "title":"PDBName",
                                            "href":"ConnectionPDBName.html#GUID-2137CC67-0759-4555-8CD2-F18EB239632A"
                                        },
                                        {
                                            "title":"Pipelining",
                                            "href":"ConnectionPipelining.html#GUID-AAFB6CB6-4264-4E22-9DE7-369EEE131B36"
                                        },
                                        {
                                            "title":"PoolName",
                                            "href":"ConnectionPoolName.html#GUID-89EE7DF0-DA3E-4ADF-9069-90BF71B438E1"
                                        },
                                        {
                                            "title":"ProviderName",
                                            "href":"ConnectionProviderName.html#GUID-7D43113A-6F69-47CB-93E9-D205CAB0B7E3"
                                        },
                                        {
                                            "title":"ProviderNuGetVersion",
                                            "href":"ConnectionProviderNuGetVersion.html#GUID-DC056E48-2AFD-4045-8F74-F0130BB7D2CF"
                                        },
                                        {
                                            "title":"ProviderVersion",
                                            "href":"ConnectionProviderVersion.html#GUID-C6794B4D-FED6-44BF-8DD3-30717C39D1E7"
                                        },
                                        {
                                            "title":"RemoteConfigurationFiltering",
                                            "href":"ConnectionRemoteConfigurationFiltering.html#GUID-EBD86AF8-2562-4C31-A5EA-0CAC6126CE11"
                                        },
                                        {
                                            "title":"Roles",
                                            "href":"ConnectionRoles.html#GUID-CD0DD2BA-1B08-4ED8-BB6A-8B219E292059"
                                        },
                                        {
                                            "title":"RowsToFetchPerRoundTrip",
                                            "href":"ConnectionRowsToFetchPerRoundTrip.html#GUID-C0A10D92-77E7-400A-966C-36EDBB8711EA"
                                        },
                                        {
                                            "title":"SDU",
                                            "href":"ConnectionSDU.html#GUID-5E2B308C-992F-4CC1-9A6A-4618ACA12805"
                                        },
                                        {
                                            "title":"ServerVersion",
                                            "href":"ConnectionServerVersion.html#GUID-9E747777-103E-474F-BAB0-01037EBFA5B9"
                                        },
                                        {
                                            "title":"ServiceName",
                                            "href":"ConnectionServiceName.html#GUID-D0075CF8-658E-4440-94C1-A60D3403D604"
                                        },
                                        {
                                            "title":"ServiceRelocationConnectionTimeout",
                                            "href":"ConnectionServiceRelocationConnectionTimeout.html#GUID-DF6E79DC-EC0F-43D7-AF8A-3C4EE00899C4"
                                        },
                                        {
                                            "title":"SessionlessTransactionId",
                                            "href":"ConnectionSessionlessTransactionId.html#GUID-1C2D6F11-0BC1-4CE8-9C8B-C6E9580E3E7E"
                                        },
                                        {
                                            "title":"SessionlessTransactionOptions",
                                            "href":"ConnectionSessionlessTransactionOptions.html#GUID-6DC04FCC-4F43-4857-B643-09DA4823D8F0"
                                        },
                                        {
                                            "title":"SqlNetAllowedLogonVersionClient",
                                            "href":"ConnectionSqlNetAllowedLogonVersionClient.html#GUID-49540352-534C-4123-8B0E-06892CBB04FE"
                                        },
                                        {
                                            "title":"SqlNetAuthenticationServices",
                                            "href":"ConnectionSqlNetAuthenticationServices.html#GUID-847D8CDB-B234-4479-BED8-6BE506984D67"
                                        },
                                        {
                                            "title":"SqlNetCryptoChecksumClient",
                                            "href":"ConnectionSqlNetCryptoChecksumClient.html#GUID-6EC35E2A-1CF2-438E-8716-6D6704F8CA4A"
                                        },
                                        {
                                            "title":"SqlNetCryptoChecksumTypesClient",
                                            "href":"ConnectionSqlNetCryptoChecksumTypesClient.html#GUID-A75F3554-2B89-47B3-8BAE-5EEEBDCCA906"
                                        },
                                        {
                                            "title":"SqlNetEncryptionClient",
                                            "href":"ConnectionSqlNetEncryptionClient.html#GUID-652ED1A0-744E-41F2-A519-9295767B19C6"
                                        },
                                        {
                                            "title":"SqlNetEncryptionTypesClient",
                                            "href":"ConnectionSqlNetEncryptionTypesClient.html#GUID-31EF3D0C-CA66-4D43-A559-0D35B7A7D157"
                                        },
                                        {
                                            "title":"SqlNetWalletOverride",
                                            "href":"ConnectionSqlnetWalletOverride.html#GUID-E4076AE4-55CD-42C2-901E-4C4FA8010BE0"
                                        },
                                        {
                                            "title":"SSLCertificateThumbprint",
                                            "href":"ConnectionSSLCertificateThumbprint.html#GUID-A65AA5DA-D1BF-4ECC-9ECF-83B4C3E1D137"
                                        },
                                        {
                                            "title":"SSLServerCertDN",
                                            "href":"ConnectionSSLServerDNMatch.html#GUID-1920A65D-D128-494F-A31F-305DF7953C79"
                                        },
                                        {
                                            "title":"SSLServerDNMatch",
                                            "href":"ConnectionSSLServerCertDN.html#GUID-BF48D6AB-E77C-4131-A1CB-2994F7AB2B62"
                                        },
                                        {
                                            "title":"SSLVersion",
                                            "href":"ConnectionSSLVersion.html#GUID-17BD7C2F-F728-44B3-A181-BD33D3C793FE"
                                        },
                                        {
                                            "title":"State",
                                            "href":"ConnectionState.html#GUID-F107340B-7651-41AB-9581-000E0EED2C02"
                                        },
                                        {
                                            "title":"StatementCacheSize",
                                            "href":"ConnectionStatementCacheSize.html#GUID-9ED659C9-2C1C-494B-A090-B8AE6DADFCC5"
                                        },
                                        {
                                            "title":"SuppressGetDecimalInvalidCastException",
                                            "href":"ConnectionSuppressGetDecimalInvalidCastException.html#GUID-8F05202F-90CF-4E2A-9238-5A67DA974E91"
                                        },
                                        {
                                            "title":"SwitchedConnection",
                                            "href":"ConnectionSwitchedConnection.html#GUID-42C5F1D0-7EA1-422D-91A4-52C7F2E9155E"
                                        },
                                        {
                                            "title":"TAFMode",
                                            "href":"ConnectionTAFMode.html#GUID-08410566-28E4-46E5-BF82-8365F504428D"
                                        },
                                        {
                                            "title":"TLSExcludeVersion",
                                            "href":"ConnectionTLSExcludeVersion.html#GUID-9C7A2D75-75FD-4328-B4DF-00E9D4AC7540"
                                        },
                                        {
                                            "title":"TLSVersion",
                                            "href":"ConnectionTLSVersion.html#GUID-3B56B787-CF47-4A20-AF44-19A71B54672F"
                                        },
                                        {
                                            "title":"TnsAdmin",
                                            "href":"ConnectionTnsAdmin.html#GUID-3EB1AE31-11F2-4D9E-9A05-4A08B7CBF036"
                                        },
                                        {
                                            "title":"TokenAuthentication",
                                            "href":"ConnectionTokenAuthentication.html#GUID-499F8602-C570-483F-960A-1E4B6A7DE737"
                                        },
                                        {
                                            "title":"TokenLocation",
                                            "href":"ConnectionTokenLocation.html#GUID-6394E5E6-3C83-41D6-AC84-DDDFBC3F9D6B"
                                        },
                                        {
                                            "title":"UseClientInitiatedCQN",
                                            "href":"ConnectionUseClientInitiatedCQN.html#GUID-99D71C2A-5808-4808-A061-1B8BA1ED20FF"
                                        },
                                        {
                                            "title":"UseHourOffsetForUnsupportedTimezone",
                                            "href":"ConnectionUseHourOffsetForUnsupportedTimezone.html#GUID-C66B87C3-0DBB-4609-A57A-D7F9FAD79F72"
                                        },
                                        {
                                            "title":"UseSNI",
                                            "href":"ConnectionUseSNI.html#GUID-6B169FBC-4BCD-4039-8AAD-E7FB45CD476D"
                                        },
                                        {
                                            "title":"WalletLocation",
                                            "href":"ConnectionWalletLocation.html#GUID-F31F01E4-9065-4FDD-ADE3-F7315D196D5B"
                                        },
                                        {
                                            "title":"WalletPassword",
                                            "href":"ConnectionWalletPassword.html#GUID-BFA47B02-4870-4C85-AAF0-770E20934A0B"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnection Public Methods",
                                    "href":"ConnectionPublicMethods.html#GUID-CDBAE05C-A30E-4C8F-91AE-9B9FC823973A",
                                    "topics":[
                                        {
                                            "title":"BeginRequest",
                                            "href":"ConnectionBeginRequest.html#GUID-1506A091-5106-47B0-B58D-8364451E8EEF"
                                        },
                                        {
                                            "title":"BeginSessionlessTransaction",
                                            "href":"ConnectionBeginSessionlessTransaction.html#GUID-6379B4FA-3BC9-4B0B-AB7F-BA80FA3265B5"
                                        },
                                        {
                                            "title":"BeginTransaction",
                                            "href":"ConnectionBeginTransactionOverloads.html#GUID-7D12BD73-AF13-458E-AF10-E10E23726ABB"
                                        },
                                        {
                                            "title":"BeginTransaction()",
                                            "href":"ConnectionBeginTransaction1.html#GUID-25AB0815-4DD5-4D91-A3F1-DC35F804288F"
                                        },
                                        {
                                            "title":"BeginTransaction(IsolationLevel)",
                                            "href":"ConnectionBeginTransaction2.html#GUID-C6E073B0-E17E-41A9-B86A-59F301C611C5"
                                        },
                                        {
                                            "title":"ChangeDatabase",
                                            "href":"ConnectionChangeDatabase.html#GUID-E1BA2428-FDFE-4C99-AA67-BAE880353AEE"
                                        },
                                        {
                                            "title":"Clone",
                                            "href":"ConnectionClone.html#GUID-18293A32-FD8A-4ECB-932D-285215D50BE8"
                                        },
                                        {
                                            "title":"Close",
                                            "href":"ConnectionClose.html#GUID-60EE6D34-756C-468D-BE6C-EEDD5DF4949C"
                                        },
                                        {
                                            "title":"CreateCommand",
                                            "href":"ConnectionCreateCommand.html#GUID-77916906-F1E5-4ECD-A242-6B3E4AA4A976"
                                        },
                                        {
                                            "title":"Commit()",
                                            "href":"ConnectionCommit.html#GUID-8C29806D-F02C-49A3-A199-4B5CE3B9F8EE"
                                        },
                                        {
                                            "title":"DisableReplay",
                                            "href":"ConnectionDisableReplay.html#GUID-D522FD1D-C98E-4C09-9A88-286357C5CC4C"
                                        },
                                        {
                                            "title":"EndRequest",
                                            "href":"ConnectionEndRequest.html#GUID-4AFA5898-336E-4C4A-A5A4-889BFF5176B4"
                                        },
                                        {
                                            "title":"EnlistDistributedTransaction",
                                            "href":"ConnectionEnlistDistributedTransaction.html#GUID-6EB031E2-D457-4142-A112-9A8590905AF7"
                                        },
                                        {
                                            "title":"EnlistTransaction",
                                            "href":"ConnectionEnlistTransaction.html#GUID-6FCB0092-9D08-4E2A-A552-EF9F85BC470C"
                                        },
                                        {
                                            "title":"FlushCache",
                                            "href":"ConnectionFlushCache.html#GUID-40045ACE-B226-45DB-8A24-2EBA37AB15C8"
                                        },
                                        {
                                            "title":"GetSchema",
                                            "href":"ConnectionGetSchemaOverloads.html#GUID-6BE5EBD9-DA19-4E50-B519-262EB9A20BE4"
                                        },
                                        {
                                            "title":"GetSchema()",
                                            "href":"ConnectionGetSchema1.html#GUID-7745CDD8-394E-4F7B-B534-48DE5ED9A538"
                                        },
                                        {
                                            "title":"GetSchema (string collectionName)",
                                            "href":"ConnectionGetSchema2.html#GUID-A01CE2B8-537C-4A66-9037-BFE07475F9C5"
                                        },
                                        {
                                            "title":"GetSchema (string collectionName, string[] restrictions)",
                                            "href":"ConnectionGetSchema3.html#GUID-35E9B896-2953-4BE4-BB06-B0DE395DB367"
                                        },
                                        {
                                            "title":"GetSessionInfo",
                                            "href":"ConnectionGetSessionInfoOverloads.html#GUID-C3200CB4-D5E9-4B13-8168-895649B248D1"
                                        },
                                        {
                                            "title":"GetSessionInfo()",
                                            "href":"ConnectionGetSessionInfo1.html#GUID-61097FA9-DEDF-4288-9B12-A0CBE7F797BD"
                                        },
                                        {
                                            "title":"GetSessionInfo(OracleGlobalization)",
                                            "href":"ConnectionGetSessionInfo2.html#GUID-73E76980-0957-4F67-AFB2-ED2B34ED13AC"
                                        },
                                        {
                                            "title":"Open",
                                            "href":"ConnectionOpen.html#GUID-3849FB02-B32D-476C-980C-BAE8C6D65E80"
                                        },
                                        {
                                            "title":"OpenAsync",
                                            "href":"ConnectionOpenAsyncOverloads.html#GUID-2BFB7100-22EC-4FA4-8386-728604E0F047"
                                        },
                                        {
                                            "title":"OpenAsync()",
                                            "href":"ConnectionOpenAsync1.html#GUID-64807EFB-38D0-4B09-AC76-1B5A0AED3095"
                                        },
                                        {
                                            "title":"OpenAsync(CancellationToken cancellationToken)",
                                            "href":"ConnectionOpenAsync2.html#GUID-0F2624F5-2639-448B-9B45-9CF90098663D"
                                        },
                                        {
                                            "title":"OpenWithNewClientSecret",
                                            "href":"ConnectionOpenWithNewClientSecret.html#GUID-49471232-30E1-4D0C-9827-33713684FA52"
                                        },
                                        {
                                            "title":"OpenWithNewPassword",
                                            "href":"ConnectionOpenWithNewPassword.html#GUID-D3B813C0-BBAD-4597-8E43-B487C45F31AB"
                                        },
                                        {
                                            "title":"OpenWithNewPassword(String)",
                                            "href":"ConnectionOpenWithNewPassword1.html#GUID-4CD612F3-319E-45DD-8211-0CA9B42F8AD0"
                                        },
                                        {
                                            "title":"OpenWithNewPassword(SecureString)",
                                            "href":"ConnectionOpenWithNewPassword2.html#GUID-771E934B-7874-4589-B8E8-DA516D686848"
                                        },
                                        {
                                            "title":"OpenWithNewPassword(OracleOpaqueString)",
                                            "href":"ConnectionOpenWithNewPassword3.html#GUID-CCD3860C-7976-4DF9-AB91-613139FF0FA9"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync",
                                            "href":"ConnectionOpenWithNewPasswordAsyncOverloads.html#GUID-E03B92B0-699C-44DF-883B-3C32537FFCEE"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(String)",
                                            "href":"ConnectionOpenWithNewPasswordAsync1.html#GUID-3FE2868C-4BA6-4305-A778-AD2F2939CF63"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(string, CancellationToken)",
                                            "href":"ConnectionOpenWithNewPasswordAsync2.html#GUID-064B51F1-3B37-4C23-A7DC-6DA0B2D4CBF7"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(SecureString)",
                                            "href":"ConnectionOpenWithNewPasswordAsync3.html#GUID-3F011C25-DA24-471A-B427-F88FB871CA2D"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(SecureString, CancellationToken)",
                                            "href":"ConnectionOpenWithNewPasswordAsync4.html#GUID-52CBBDC9-664D-447E-B7D2-59D8DF8D6BE5"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(OracleOpaqueString)",
                                            "href":"ConnectionOpenWithNewPasswordAsync5.html#GUID-43E3DC26-63D1-4D00-88FE-E98CE5D496F2"
                                        },
                                        {
                                            "title":"OpenWithNewPasswordAsync(OracleOpaqueString, CancellationToken)",
                                            "href":"ConnectionOpenWithNewPasswordAsync6.html#GUID-EBFBFAF7-1A93-46FB-9CA2-A0DCD6F82E97"
                                        },
                                        {
                                            "title":"OpenWithNewToken",
                                            "href":"ConnectionOpenWithNewToken.html#GUID-3B2B3530-621B-4B0B-8795-DA35DE93A842"
                                        },
                                        {
                                            "title":"OpenWithNewToken(char[])",
                                            "href":"ConnnectionOpenWithNewToken1.html#GUID-714D6586-4F64-42BA-8ACB-30D1672C30D9"
                                        },
                                        {
                                            "title":"OpenWithNewToken(char[], char[])",
                                            "href":"ConnectionOpenWithNewToken2.html#GUID-0905A821-3E35-4F68-A80E-1A80E29B3DD5"
                                        },
                                        {
                                            "title":"PurgeStatementCache",
                                            "href":"ConnectionPurgeStatementCache.html#GUID-4068ECE5-60EC-4820-9047-EEEACB8A37A8"
                                        },
                                        {
                                            "title":"ResumeSessionlessTransaction",
                                            "href":"ConnectionResumeSessionlessTransaction.html#GUID-6929E092-8F23-45FE-8059-6EAA15CE1400"
                                        },
                                        {
                                            "title":"Rollback",
                                            "href":"ConnectionRollbackOverloaded.html#GUID-9B55C436-D001-4DF5-8CFD-F2CE5F5C9B37"
                                        },
                                        {
                                            "title":"Rollback()",
                                            "href":"ConnectionRollback1.html#GUID-9B6D6EF1-C96B-44CE-BF24-E92F0CD88EB0"
                                        },
                                        {
                                            "title":"Rollback(String)",
                                            "href":"ConnectionRollback2.html#GUID-DB377F64-DD20-4243-808A-12371F46AD4F"
                                        },
                                        {
                                            "title":"Save(String)",
                                            "href":"ConnectionSave.html#GUID-345EE116-2B7E-4206-98AE-06E422CD922A"
                                        },
                                        {
                                            "title":"SetSessionInfo",
                                            "href":"ConnectionSetSessionInfo.html#GUID-8F565C3E-8C54-4A5D-A890-88EE15C6D7F1"
                                        },
                                        {
                                            "title":"SetShardingKey(OracleShardingKey, OracleShardingKey)",
                                            "href":"ConnectionSetShardingKey.html#GUID-EB81E649-8C68-4C48-8A71-3F5C3C0AC073"
                                        },
                                        {
                                            "title":"SuspendSessionlessTransaction",
                                            "href":"ConnectionSuspendSessionlessTransaction.html#GUID-CCEEABCD-25F5-48A1-825D-8DBDC1374E2E"
                                        },
                                        {
                                            "title":"UseAzureTokenAuthentication",
                                            "href":"ConnectionUseAzureTokenAuthentication.html#GUID-FC91C04D-DE96-4BD4-B54A-5A81053B50A3"
                                        },
                                        {
                                            "title":"UseOciTokenAuthentication",
                                            "href":"ConnectionUseOciTokenAuthentication.html#GUID-3383AA36-F7F9-46A4-AFBD-9D13AC70AD74"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnection Events",
                                    "href":"ConnectionEvents.html#GUID-4137467E-185E-4937-86B0-64FC1077D0DE",
                                    "topics":[
                                        {
                                            "title":"ConnectionOpen",
                                            "href":"ConnectionConnectionOpen.html#GUID-6CD03C1B-4543-4D06-8C2D-FF039ACB34B1"
                                        },
                                        {
                                            "title":"Failover",
                                            "href":"ConnectionFailover.html#GUID-8B9CCE46-FA13-467D-B58E-EC940713CA3A"
                                        },
                                        {
                                            "title":"HAEvent",
                                            "href":"ConnectionHAEvent.html#GUID-38853FD6-40D0-42FE-9056-9E22EDF1478F"
                                        },
                                        {
                                            "title":"InfoMessage",
                                            "href":"ConnectionInfoMessage.html#GUID-0138F8A5-9F82-4F14-89EB-5F6D2FEE9C71"
                                        },
                                        {
                                            "title":"StateChange",
                                            "href":"ConnectionStateChange.html#GUID-7FB4CF85-9CB9-481A-8360-C50E6EB0510E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleConnectionOpenEventArgs Class",
                            "href":"OracleConnectionOpenEventArgsClass.html#GUID-8CD888B1-93D7-4D3E-A286-DDA5269439CF",
                            "topics":[
                                {
                                    "title":"OracleConnectionOpenEventArgs Members",
                                    "href":"ConnectionOpenEventArgsMembers.html#GUID-86322F93-E90C-48CA-A84E-7706FF0BBAC8"
                                },
                                {
                                    "title":"OracleConnectionOpenEventArgs Properties",
                                    "href":"ConnectionOpenEventArgsProperties.html#GUID-A35FA020-3DEE-4642-8B3E-FF869945124D",
                                    "topics":[
                                        {
                                            "title":"Connection",
                                            "href":"ConnectionOpenEventArgsOracleConnection.html#GUID-71DCC04F-0A3F-4B1D-B747-79AECF9530EF"
                                        },
                                        {
                                            "title":"ConnectionOpenReason",
                                            "href":"ConnectionOpenEventArgsConnectionOpenReason.html#GUID-5BB87D19-1BD8-4CB5-84D7-3BC843E8DDFA"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleConnectionOpenEventHandler Delegate",
                            "href":"OracleConnectionOpenEventHandlerDelegate.html#GUID-D47E72D2-575E-415A-9010-1FE369BCEB26"
                        },
                        {
                            "title":"OracleConnectionStringBuilder Class",
                            "href":"OracleConnectionStringBuilderClass.html#GUID-81FD2CFC-D2CE-47A8-BF0A-2F18428A6D5F",
                            "topics":[
                                {
                                    "title":"OracleConnectionStringBuilder Members",
                                    "href":"OracleConnectionStringBuilderMembers.html#GUID-E30D3C68-7BD3-4850-A9C8-DCFD59FFD6C6"
                                },
                                {
                                    "title":"OracleConnectionStringBuilder Constructors",
                                    "href":"ConnectionStringBuilderConstructors.html#GUID-B5D76ECB-61C5-4493-A08F-420BA64D9B1A",
                                    "topics":[
                                        {
                                            "title":"OracleConnectionStringBuilder()",
                                            "href":"ConnectionStringBuilderCtor1.html#GUID-DDD4D423-F49D-4AD4-80F3-682DC17E1DDC"
                                        },
                                        {
                                            "title":"OracleConnectionStringBuilder(string)",
                                            "href":"ConnectionStringBuilderCtor2.html#GUID-B3FAE025-7A46-4572-8BC5-AF2A5C509589"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnectionStringBuilder Public Properties",
                                    "href":"ConnectionStringBuilderPublicProperties.html#GUID-CA97ACE9-ABE9-4804-BEA9-25398C07552E",
                                    "topics":[
                                        {
                                            "title":"ConnectionLifeTime",
                                            "href":"ConnectionStringBuilderConnectionLifeTime.html#GUID-B40246BF-01EB-43F7-9446-887B0FAB148A"
                                        },
                                        {
                                            "title":"ConnectionTimeout",
                                            "href":"ConnectionStringBuilderConnectionTimeout.html#GUID-38A741E9-BAEA-4ECF-A5DD-98269B1F2694"
                                        },
                                        {
                                            "title":"ContextConnection",
                                            "href":"ConnectionStringBuilderContextConnection.html#GUID-181E78C7-B345-46CE-B47F-A13A4DC45548"
                                        },
                                        {
                                            "title":"DataSource",
                                            "href":"ConnectionStringBuilderDataSource.html#GUID-165BFAEA-A146-4995-826B-A2DABAFF5149"
                                        },
                                        {
                                            "title":"DBAPrivilege",
                                            "href":"ConnectionStringBuilderDBAPrivilege.html#GUID-FD51484D-8944-40E0-BBB6-C69E2BE15313"
                                        },
                                        {
                                            "title":"DecrPoolSize",
                                            "href":"ConnectionStringBuilderDecrPoolSize.html#GUID-D775C171-856A-43F6-A27F-AC7E200E9EF0"
                                        },
                                        {
                                            "title":"Enlist",
                                            "href":"ConnectionStringBuilderEnlist.html#GUID-82392047-34CE-4761-9F79-DAAD229FEA58"
                                        },
                                        {
                                            "title":"HAEvents",
                                            "href":"ConnectionStringBuilderHAEvents.html#GUID-433F3DB8-FAE6-4CBB-B10C-AD354A13AAAE"
                                        },
                                        {
                                            "title":"IncrPoolSize",
                                            "href":"ConnectionStringBuilderIncrPoolSize.html#GUID-F0E24DCD-E335-4686-A352-10B77A256FDC"
                                        },
                                        {
                                            "title":"IsFixedSize",
                                            "href":"ConnectionStringBuilderIsFixedSize.html#GUID-FA7AED94-EA8D-4242-BD8F-F6F5F34B1741"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"ConnectionStringBuilderItem.html#GUID-21323C4D-87A2-498B-A37C-B204A1326838"
                                        },
                                        {
                                            "title":"Keys",
                                            "href":"ConnectionStringBuilderKeys.html#GUID-2F41F1B6-E030-426F-803F-6FBBA13C5F7C"
                                        },
                                        {
                                            "title":"LoadBalancing",
                                            "href":"ConnectionStringBuilderLoadBalancing.html#GUID-EB75202F-B9B2-442D-84B6-FE09ACC8AB0E"
                                        },
                                        {
                                            "title":"MaxPoolSize",
                                            "href":"ConnectionStringBuilderMaxPoolSize.html#GUID-9338BFFA-BA8D-434C-8FEB-43A980753656"
                                        },
                                        {
                                            "title":"MetadataPooling",
                                            "href":"ConnectionStringBuilderMetadataPooling.html#GUID-9E51ECBE-4C28-46CC-95DD-965EC002CCE0"
                                        },
                                        {
                                            "title":"MinPoolSize",
                                            "href":"ConnectionStringBuilderMinPoolSize.html#GUID-FAED8E05-5A6A-4D4F-90E5-E7A48DB570B4"
                                        },
                                        {
                                            "title":"Password",
                                            "href":"ConnectionStringBuilderPassword.html#GUID-B8CE0FE3-4011-45C7-91C0-2918C27334DA"
                                        },
                                        {
                                            "title":"PersistSecurityInfo",
                                            "href":"ConnectionStringBuilderPersistSecurityInfo.html#GUID-7CC98244-D1AE-40C9-BAD6-19D339058FF6"
                                        },
                                        {
                                            "title":"Pooling",
                                            "href":"ConnectionStringBuilderPooling.html#GUID-12EB53AA-790F-4867-9DFB-A494B24B41DA"
                                        },
                                        {
                                            "title":"ProxyPassword",
                                            "href":"ConnectionStringBuilderProxyPassword.html#GUID-66C60321-2136-4A8D-B222-BD4595410C35"
                                        },
                                        {
                                            "title":"ProxyUserId",
                                            "href":"ConnectionStringBuilderProxyUserId.html#GUID-44E627F6-BAA9-4F93-813F-B7F88618A7AD"
                                        },
                                        {
                                            "title":"SelfTuning",
                                            "href":"ConnectionStringBuilderSelfTuning.html#GUID-E7FFE8A2-190A-49C6-9746-F552AAF20A38"
                                        },
                                        {
                                            "title":"StatementCachePurge",
                                            "href":"ConnectionStringBuilderStatementCachePurge.html#GUID-ACD0D7B3-C2CE-48E5-B819-047A25B44383"
                                        },
                                        {
                                            "title":"StatementCacheSize",
                                            "href":"ConnectionStringBuilderStatementCacheSize.html#GUID-D4C940DC-D177-4EF9-9F65-D804DE0F1FA3"
                                        },
                                        {
                                            "title":"TnsAdmin",
                                            "href":"ConnectionStringBuilderTnsAdmin.html#GUID-BB741791-46E5-40C4-97BA-72DEC40D8BBA"
                                        },
                                        {
                                            "title":"TokenAuthentication",
                                            "href":"ConnectionStringBuilderTokenAuthentication.html#GUID-7AE8DEBB-DD1E-491A-BBFD-49E62244614C"
                                        },
                                        {
                                            "title":"TokenLocation",
                                            "href":"ConnectionStringBuilderTokenLocation.html#GUID-918DAB58-AE17-4743-A376-787F16397ACD"
                                        },
                                        {
                                            "title":"UserID",
                                            "href":"ConnectionStringBuilderUserID.html#GUID-75237C69-D4FA-418B-8A25-BE7D0BD3DBE2"
                                        },
                                        {
                                            "title":"ValidateConnection",
                                            "href":"ConnectionStringBuilderValidateConnection.html#GUID-B89006C5-E4B2-4AB3-A775-4230D32956E8"
                                        },
                                        {
                                            "title":"Values",
                                            "href":"ConnectionStringBuilderValues.html#GUID-9C08B70A-2FFA-44EE-9FD4-73A7A1342BE4"
                                        },
                                        {
                                            "title":"WalletLocation",
                                            "href":"ConnectionStringBuilderWalletLocation.html#GUID-FE42720C-F41F-49D0-8C45-D548F6505829"
                                        },
                                        {
                                            "title":"WalletPassword",
                                            "href":"ConnectionStringBuilderWalletPassword.html#GUID-5393111D-F697-4EAD-A503-210C5EDA36B6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleConnectionStringBuilder Public Methods",
                                    "href":"ConnectionStringBuilderPublicMethods.html#GUID-4DE4CABC-5A2E-4ADB-A8D0-A4EB1BF7770D",
                                    "topics":[
                                        {
                                            "title":"Clear",
                                            "href":"ConnectionStringBuilderClear.html#GUID-41556A73-C7A4-494A-B4BF-3B2AD5335739"
                                        },
                                        {
                                            "title":"ContainsKey",
                                            "href":"ConnectionStringBuilderContainsKey.html#GUID-317D2C5B-2A6A-41F0-A9F7-49ADAB0CD2B4"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"ConnectionStringBuilderRemove.html#GUID-97CC27FA-DB38-4453-A6F5-11E4E8BB213F"
                                        },
                                        {
                                            "title":"TryGetValue",
                                            "href":"ConnectionStringBuilderTryGetValue.html#GUID-F9AE5F27-244B-4D5B-828A-321FF7B9E1FA"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleCredential Class",
                            "href":"OracleCredentialClass.html#GUID-193A5715-A785-4CA2-842E-1241DEFD8645",
                            "topics":[
                                {
                                    "title":"OracleCredential Members",
                                    "href":"CredentialMembers.html#GUID-D3B73D4B-41BA-4899-86B1-2D267F7F11A3"
                                },
                                {
                                    "title":"OracleCredential Constructors",
                                    "href":"CredentialCtors.html#GUID-6768F62C-7A35-4B5C-9DBE-7CF5F58BF6FA",
                                    "topics":[
                                        {
                                            "title":"OracleCredential(string, SecureString)",
                                            "href":"CredentialCtor1.html#GUID-89521A05-22CF-4C7B-B8A9-4F0A8279F272"
                                        },
                                        {
                                            "title":"OracleCredential(string, SecureString, OracleDBAPrivilege)",
                                            "href":"CredentialCtor2.html#GUID-72BD4C7C-40BD-400E-92FF-433B6E6B1B92"
                                        },
                                        {
                                            "title":"OracleCredential(string, SecureString, string, SecureString)",
                                            "href":"CredentialCtor3.html#GUID-5F5F5C0A-023B-469F-BF27-E583D13F490D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCredential Properties",
                                    "href":"CredentialProperties.html#GUID-50402439-8714-417B-A2C8-957F39B43F37",
                                    "topics":[
                                        {
                                            "title":"DBAPrivilege",
                                            "href":"CredentialDBAPrivilege.html#GUID-EEC599BD-FE65-43DB-B932-A8449BA46D5C"
                                        },
                                        {
                                            "title":"Password",
                                            "href":"CredentialPassword.html#GUID-4E364862-F5EC-4154-966D-8A9C19935776"
                                        },
                                        {
                                            "title":"ProxyPassword",
                                            "href":"CredentialProxyPassword.html#GUID-B5DA9B6B-2E4F-45CC-88CD-586EAAE86690"
                                        },
                                        {
                                            "title":"ProxyUserId",
                                            "href":"CredentialProxyUserId.html#GUID-B26E619B-BE47-4E91-B62D-48BB60EE1FCD"
                                        },
                                        {
                                            "title":"UserId",
                                            "href":"CredentialUserId.html#GUID-E3DFC0FC-D538-44D4-8B22-C402EF9FA060"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCredential Public Methods",
                                    "href":"OracleCredentialPublicMethods.html#GUID-87F91AC2-AE62-4AF2-BF28-24405C75C0A9",
                                    "topics":[
                                        {
                                            "title":"SetPassword",
                                            "href":"CredentialSetPassword.html#GUID-8D89EBCB-6946-4106-9B8D-8E1F2D84D0B7"
                                        },
                                        {
                                            "title":"SetProxyPassword",
                                            "href":"CredentialSetProxyPassword.html#GUID-916CCE86-AB87-44C1-9488-2849B6355F83"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDataAdapter Class",
                            "href":"OracleDataAdapterClass.html#GUID-76F427CE-BC13-4266-B5FC-87D5183D6E6B",
                            "topics":[
                                {
                                    "title":"OracleDataAdapter Members",
                                    "href":"DataAdapterMembers.html#GUID-D9FFFA32-046C-4F4A-B15E-0DDC299736BF"
                                },
                                {
                                    "title":"OracleDataAdapter Constructors",
                                    "href":"DataAdapterCtors.html#GUID-F7CFEDDA-3CF0-4B70-9F15-857AE6FCC5DC",
                                    "topics":[
                                        {
                                            "title":"OracleDataAdapter()",
                                            "href":"DataAdapterCtor1.html#GUID-DDBCFCF0-EB73-48E5-ADEE-1C1A7434BB23"
                                        },
                                        {
                                            "title":"OracleDataAdapter(OracleCommand)",
                                            "href":"DataAdapterCtor2.html#GUID-95F2EE4F-1B24-4E65-B81C-9F0DFE0F2FB3"
                                        },
                                        {
                                            "title":"OracleDataAdapter(string, OracleConnection)",
                                            "href":"DataAdapterCtor3.html#GUID-8E885DBB-A075-431D-85E8-84DD82013322"
                                        },
                                        {
                                            "title":"OracleDataAdapter(string, string)",
                                            "href":"DataAdapterCtor4.html#GUID-45610194-7543-49B2-BFBC-C2FBE9D9D1B4"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataAdapter Static Methods",
                                    "href":"DataAdapterStaticMethods.html#GUID-DC989244-9B29-4CD0-9539-C3A8D6CCF68D"
                                },
                                {
                                    "title":"OracleDataAdapter Properties",
                                    "href":"DataAdapterProperties.html#GUID-753AAB8E-820F-4F27-BC78-6B878D6F97F6",
                                    "topics":[
                                        {
                                            "title":"DeleteCommand",
                                            "href":"DataAdapterDeleteCommand.html#GUID-B1A41532-E1A4-4A23-8FEE-7A09712DD8B5"
                                        },
                                        {
                                            "title":"IdentityInsert",
                                            "href":"DataAdapterIdentityInsert.html#GUID-DD545D51-277F-42FD-A21D-93842D29C42B"
                                        },
                                        {
                                            "title":"IdentityUpdate",
                                            "href":"DataAdapterIdentityUpdate.html#GUID-8673D526-3164-42B8-A69C-682E55CC3B4F"
                                        },
                                        {
                                            "title":"InsertCommand",
                                            "href":"DataAdapterInsertCommand.html#GUID-7A2C062A-38AA-463E-BF8A-D9B3800C953F"
                                        },
                                        {
                                            "title":"Requery",
                                            "href":"DataAdapterRequery.html#GUID-0F6494DA-74F9-43D5-B4D7-5C13AF3CCE1B"
                                        },
                                        {
                                            "title":"ReturnProviderSpecificTypes",
                                            "href":"DataAdapterReturnProviderSpecificTypes.html#GUID-FE1ED86F-A8AC-434E-81E4-0D1EDE6139E8"
                                        },
                                        {
                                            "title":"SafeMapping",
                                            "href":"DataAdapterSafeMapping.html#GUID-2A06C705-ADF2-4DEA-93F4-96ACFCC37A16"
                                        },
                                        {
                                            "title":"SelectCommand",
                                            "href":"DataAdapterSelectCommand.html#GUID-62B1A624-D22F-4D72-BC50-F305D0AF57CC"
                                        },
                                        {
                                            "title":"SuppressGetDecimalInvalidCastException",
                                            "href":"DataAdapterSuppressGetDecimalInvalidCastException.html#GUID-89F96108-35A9-416E-AFB1-B0B9A1C81146"
                                        },
                                        {
                                            "title":"UpdateBatchSize",
                                            "href":"DataAdapterUpdateBatchSize.html#GUID-D412C947-FA09-448E-ABFA-B68946B096D5"
                                        },
                                        {
                                            "title":"UpdateCommand",
                                            "href":"DataAdapterUpdateCommand.html#GUID-F827907F-0E0C-4583-A494-9982541FA5D2"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataAdapter Public Methods",
                                    "href":"DataAdapterPublicMethods.html#GUID-441A497D-3D7B-42D0-941A-F58E7B86519B",
                                    "topics":[
                                        {
                                            "title":"Fill",
                                            "href":"DataAdapterFillOverloads.html#GUID-168A9C27-94F8-4C46-A1D6-495803A7B341"
                                        },
                                        {
                                            "title":"Fill(DataTable, OracleRefCursor)",
                                            "href":"DataAdapterFill1.html#GUID-DF76F239-017E-4CE1-BE60-2AD49E72FEF0"
                                        },
                                        {
                                            "title":"Fill(DataSet, OracleRefCursor)",
                                            "href":"DataAdapterFill2.html#GUID-55269F96-AF66-46CA-A3D0-5D61EC06C962"
                                        },
                                        {
                                            "title":"Fill(DataSet, string, OracleRefCursor)",
                                            "href":"DataAdapterFill3.html#GUID-61D67104-3388-40EC-A840-8CB61C012122"
                                        },
                                        {
                                            "title":"Fill(DataSet, int, int, string, OracleRefCursor)",
                                            "href":"DataAdapterFill4.html#GUID-F8AD883F-39F8-4C88-AB4E-C67BFDD2F094"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataAdapter Events",
                                    "href":"DataAdapterEvents.html#GUID-35E95CF6-3CA7-47C4-A446-B8049E14F72E",
                                    "topics":[
                                        {
                                            "title":"RowUpdated",
                                            "href":"DataAdapterRowUpdated.html#GUID-C90A23D0-32DA-48B0-B12F-9AA043C4B76C"
                                        },
                                        {
                                            "title":"RowUpdating",
                                            "href":"DataAdapterRowUpdating.html#GUID-D32848D8-9CF9-40AC-8863-E3B388681B82"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDatabase Class",
                            "href":"OracleDatabaseClass.html#GUID-F8A71929-B747-4B1F-9259-F41E4E0BF3DA",
                            "topics":[
                                {
                                    "title":"OracleDatabase Members",
                                    "href":"DatabaseMembers.html#GUID-25EB62E4-FB46-4AD6-A096-2FB2F8253FCC"
                                },
                                {
                                    "title":"OracleDatabase Constructors",
                                    "href":"DatabaseCtor.html#GUID-003A08B0-F126-4CB8-8C85-3A8441050A8A",
                                    "topics":[
                                        {
                                            "title":"OracleDatabase Constructor(string)",
                                            "href":"DatabaseCtor1.html#GUID-E325ADF5-A299-489E-955E-336B3AE58C69"
                                        },
                                        {
                                            "title":"OracleDatabase Constructor(string, OracleCredential)",
                                            "href":"DatabaseCtor2.html#GUID-53798E6D-5B13-43A3-9B28-47EE2307FDFB"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDatabase Properties",
                                    "href":"DatabaseProperties.html#GUID-7607093F-1E89-4FC3-8902-1E7F38679F30",
                                    "topics":[
                                        {
                                            "title":"ServerVersion",
                                            "href":"DatabaseServerVersion.html#GUID-28E706D4-151C-4883-B79A-0A83CFB91DFE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDatabase Public Methods",
                                    "href":"DatabasePublicMethods.html#GUID-44472089-ACBC-419C-9A2D-89F92881AF55",
                                    "topics":[
                                        {
                                            "title":"Dispose",
                                            "href":"DatabaseDispose.html#GUID-03AB3CA4-B03E-453E-8E41-8BB957C98824"
                                        },
                                        {
                                            "title":"ExecuteNonQuery",
                                            "href":"DatabaseExecuteNonQuery.html#GUID-4B77CEF6-AAE6-4F48-B968-D561F43A31DC"
                                        },
                                        {
                                            "title":"Shutdown",
                                            "href":"DatabaseShutdownOverloads.html#GUID-66E60654-4799-4CA7-A0CB-38415CE7F2E7"
                                        },
                                        {
                                            "title":"Shutdown()",
                                            "href":"DatabaseShutdown1.html#GUID-475A17F7-0D46-437B-AD99-C75EB02E9C6B"
                                        },
                                        {
                                            "title":"Shutdown(OracleDBShutdownMode, bool)",
                                            "href":"DatabaseShutdown2.html#GUID-B6B8F399-9E6C-4F85-98A6-C94066213D94"
                                        },
                                        {
                                            "title":"Startup",
                                            "href":"DatabaseStartupOverloads.html#GUID-D5E5A0CA-14C0-40B5-A845-0F86923E462E"
                                        },
                                        {
                                            "title":"Startup()",
                                            "href":"DatabaseStartup1.html#GUID-425E1BE8-B099-4CB3-862B-16C1A07090EA"
                                        },
                                        {
                                            "title":"Startup(OracleDBStartupMode, bool)",
                                            "href":"DatabaseStartup3.html#GUID-944A5F23-694D-419D-BF9C-7A62DD9DB30B"
                                        },
                                        {
                                            "title":"Startup(OracleDBStartupMode, string, bool)",
                                            "href":"DatabaseStartup2.html#GUID-61CE97AD-C4D1-491A-8C1D-135C7F3ADCF0"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDataReader Class",
                            "href":"OracleDataReaderClass.html#GUID-6A8F1309-277F-4DA7-B463-642D81DDCB1C",
                            "topics":[
                                {
                                    "title":"OracleDataReader Members",
                                    "href":"DataReaderMembers.html#GUID-634A5009-7D1D-4DD1-9748-88769E702CF5"
                                },
                                {
                                    "title":"OracleDataReader Static Methods",
                                    "href":"DataReaderStaticMethods.html#GUID-8F3C8847-8E4D-4B21-BEC5-5D41EF0ADFD8"
                                },
                                {
                                    "title":"OracleDataReader Properties",
                                    "href":"DataReaderProperties.html#GUID-73EC5269-3B55-4653-9CAD-0C57DDEC96B2",
                                    "topics":[
                                        {
                                            "title":"Depth",
                                            "href":"DataReaderDepth.html#GUID-7A30170F-CBF1-41DB-B4A6-E9E7F327BDED"
                                        },
                                        {
                                            "title":"FetchSize",
                                            "href":"DataReaderFetchSize.html#GUID-4A094770-6340-4141-8235-706AF20F2C56"
                                        },
                                        {
                                            "title":"FieldCount",
                                            "href":"DataReaderFieldCount.html#GUID-50C72C8B-7366-4AB8-8FDB-41C5513A3FFA"
                                        },
                                        {
                                            "title":"HasRows",
                                            "href":"DataReaderHasRows.html#GUID-080BE507-FC53-49BB-9BC6-55A44CCD79DD"
                                        },
                                        {
                                            "title":"HiddenFieldCount",
                                            "href":"DataReaderHiddenFieldCount.html#GUID-9E266D0F-C796-4299-8D94-9067B5C6DFE8"
                                        },
                                        {
                                            "title":"IsClosed",
                                            "href":"DataReaderIsClosed.html#GUID-2FD315B8-91BB-4E90-892B-65D338E98A06"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"DataReaderItemOverloads.html#GUID-C6972B72-1AEC-48C7-B988-8AF367A84FDE"
                                        },
                                        {
                                            "title":"Item [index]",
                                            "href":"DataReaderItem1.html#GUID-3ECF5071-32A9-4052-BC81-47AEB1445F9D"
                                        },
                                        {
                                            "title":"Item [string]",
                                            "href":"DataReaderItem2.html#GUID-B31DE717-0940-4C66-AB8F-1CEDE16348DC"
                                        },
                                        {
                                            "title":"InitialLOBFetchSize",
                                            "href":"DataReaderInitialLOBFetchSize.html#GUID-E015AF50-1A92-41D9-ABFB-D5EEA8C0BF55"
                                        },
                                        {
                                            "title":"InitialLONGFetchSize",
                                            "href":"DataReaderInitialLONGFetchSize.html#GUID-6A44674A-3C88-41C4-A6CB-86F180195977"
                                        },
                                        {
                                            "title":"RecordsAffected",
                                            "href":"DataReaderRecordsAffected.html#GUID-D1B47525-7438-4050-ACB5-E895CB18F872"
                                        },
                                        {
                                            "title":"RowSize",
                                            "href":"DataReaderRowSize.html#GUID-530A93F3-AE0C-408F-A536-40D6A4A6429B"
                                        },
                                        {
                                            "title":"RowsToFetchPerRoundTrip",
                                            "href":"DataReaderRowsToFetchPerRoundTrip.html#GUID-47113595-3777-4811-B5A6-5C9B99BDE877"
                                        },
                                        {
                                            "title":"SuppressGetDecimalInvalidCastException",
                                            "href":"DataReaderSuppressGetDecimalInvalidCastException.html#GUID-FDBFE179-4FA5-4F7B-BAEF-2146F1763383"
                                        },
                                        {
                                            "title":"UseEdmMapping",
                                            "href":"DataReaderUseEdmMapping.html#GUID-2F637484-B521-4B1F-867A-A00D57147971"
                                        },
                                        {
                                            "title":"VisibleFieldCount",
                                            "href":"DataReaderVisibleFieldCount.html#GUID-E1A6A4D9-1750-4C6A-BF45-B746CC04B0D0"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataReader Public Methods",
                                    "href":"DataReaderPublicMethods.html#GUID-10643E0E-132D-4E85-91B0-70DAAD17A062",
                                    "topics":[
                                        {
                                            "title":"Close",
                                            "href":"DataReaderClose.html#GUID-2F3DACE6-EE54-4965-9051-17E8BCE140FD"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"DataReaderDispose.html#GUID-126B4CE4-3E7A-481E-8512-4ECD386CF3DF"
                                        },
                                        {
                                            "title":"GetBoolean",
                                            "href":"DataReaderGetBoolean.html#GUID-2B50EADE-B6AE-49A7-A22F-03819BE32F6A"
                                        },
                                        {
                                            "title":"GetByte",
                                            "href":"DataReaderGetByte.html#GUID-623B64BC-19DA-4682-9678-B3119CCD1927"
                                        },
                                        {
                                            "title":"GetByteArray(int)",
                                            "href":"DataReaderGetByteArray1.html#GUID-37588ED8-E5A1-4B2C-B7CA-942CEA910241"
                                        },
                                        {
                                            "title":"GetByteArray(string)",
                                            "href":"DataReaderGetByteArray2.html#GUID-14929A84-CE4A-41FA-8001-9282AB8B3E82"
                                        },
                                        {
                                            "title":"GetBytes",
                                            "href":"DataReaderGetBytes.html#GUID-830EC83F-E501-4E8D-AB06-2378022860D0"
                                        },
                                        {
                                            "title":"GetChar",
                                            "href":"DataReaderGetChar.html#GUID-E08A2D56-F4C2-4FB9-8294-2F401B29DA7D"
                                        },
                                        {
                                            "title":"GetChars",
                                            "href":"DataReaderGetChars.html#GUID-570D44F1-C648-4C4D-A6CB-D894A3ABB55B"
                                        },
                                        {
                                            "title":"GetData",
                                            "href":"DataReaderGetData.html#GUID-3C568D40-AA1A-4844-8435-F0DB3B31674F"
                                        },
                                        {
                                            "title":"GetDataTypeName",
                                            "href":"DataReaderGetDataTypeName.html#GUID-B3949C15-BD41-4815-8B68-211BFCFF5929"
                                        },
                                        {
                                            "title":"GetDateTime",
                                            "href":"DataReaderGetDateTime.html#GUID-ECA7F25D-E684-49E0-8DD0-75CD49D0BA4E"
                                        },
                                        {
                                            "title":"GetDateTimeOffset",
                                            "href":"DataReaderGetDateTimeOffset.html#GUID-553AEAFD-172D-4D7B-8D1B-D14515A97A46"
                                        },
                                        {
                                            "title":"GetDecimal",
                                            "href":"DataReaderGetDecimal.html#GUID-D3477378-6FEC-4390-A8EE-0EEE58A680CB"
                                        },
                                        {
                                            "title":"GetDouble",
                                            "href":"DataReaderGetDouble.html#GUID-4A30AA27-800D-48EA-A80C-4BAED1F4B7E6"
                                        },
                                        {
                                            "title":"GetDoubleArray(int)",
                                            "href":"DataReaderGetDoubleArray1.html#GUID-AFF68E61-E0AD-44C2-A940-33092FE14DE0"
                                        },
                                        {
                                            "title":"GetDoubleArray(string)",
                                            "href":"DataReaderGetDoubleArray2.html#GUID-39C263F8-A50F-449F-A6B2-BAF7BF518BBA"
                                        },
                                        {
                                            "title":"GetEnumerator",
                                            "href":"DataReaderGetEnumerator.html#GUID-64F61DC8-A89A-404C-8909-B9A08D19AB11"
                                        },
                                        {
                                            "title":"GetFieldType",
                                            "href":"DataReaderGetFieldType.html#GUID-EDFC8C7D-C636-4DC8-8234-007D42606D65"
                                        },
                                        {
                                            "title":"GetFieldValueAsync",
                                            "href":"DataReaderGetFieldValueAsyncOverloaded.html#GUID-7C2F216C-AF8C-42BF-B4F6-7E380AEB780A"
                                        },
                                        {
                                            "title":"GetFieldValueAsync(int, CancellationToken)",
                                            "href":"DataReaderGetFieldValueAsync1.html#GUID-3482EFB6-4226-41D0-B8D6-3BF8F1C21052"
                                        },
                                        {
                                            "title":"GetFieldValueAsync(int)",
                                            "href":"DataReaderGetFieldValueAsync2.html#GUID-3BCA768B-74F3-44A9-8FDF-F5233B423199"
                                        },
                                        {
                                            "title":"GetFloat",
                                            "href":"DataReaderGetFloat.html#GUID-93C2FE34-C8AE-4CE4-83D4-27417D062847"
                                        },
                                        {
                                            "title":"GetFloatArray(int)",
                                            "href":"DataReaderGetFloatArray1.html#GUID-F0A5D9D8-FA2B-4DC2-981A-7B4591F032D4"
                                        },
                                        {
                                            "title":"GetFloatArray(string)",
                                            "href":"DataReaderGetFloatArray2.html#GUID-6890594A-0B34-4FC1-B28C-4079A2FBBF6C"
                                        },
                                        {
                                            "title":"GetGuid",
                                            "href":"DataReaderGetGuid.html#GUID-8E119648-0A08-4C1D-B533-8DBFFA0E34DA"
                                        },
                                        {
                                            "title":"GetInt16",
                                            "href":"DataReaderGetInt16.html#GUID-E3DC9BA3-07E5-4A60-8397-033525B59164"
                                        },
                                        {
                                            "title":"GetInt16Array(int)",
                                            "href":"DataReaderGetInt16Array1.html#GUID-9BD1AC0D-72F5-4B53-B71B-C161CBAB4625"
                                        },
                                        {
                                            "title":"GetInt16Array(string)",
                                            "href":"DataReaderGetInt16Array2.html#GUID-D88ADD37-49F3-41C9-A0AB-EE4C79C442F9"
                                        },
                                        {
                                            "title":"GetInt32",
                                            "href":"DataReaderGetInt32.html#GUID-E8CF0EC5-2E1F-4712-8DDE-F270A0BF7D92"
                                        },
                                        {
                                            "title":"GetInt64",
                                            "href":"DataReaderGetInt64.html#GUID-D24C1214-A773-4843-8082-3DEE09DB211E"
                                        },
                                        {
                                            "title":"GetName",
                                            "href":"DataReaderGetName.html#GUID-16C0AF34-F3CF-41ED-B657-0686BE6AF61E"
                                        },
                                        {
                                            "title":"GetNonZeroDoubleArray",
                                            "href":"DataReaderGetNonZeroDoubleArrayOverloads.html#GUID-700DA8DD-4F2E-4664-B3EA-9A5B0DEBE47E"
                                        },
                                        {
                                            "title":"GetNonZeroDoubleArray(int)",
                                            "href":"DataReaderGetNonZeroDoubleArray1.html#GUID-E26941CE-AD09-453C-8145-043979D21B4D"
                                        },
                                        {
                                            "title":"GetNonZeroDoubleArray(string)",
                                            "href":"DataReaderGetNonZeroDoubleArray2.html#GUID-9317F901-9DBE-4BB0-8632-A0611C502DD0"
                                        },
                                        {
                                            "title":"GetNonZeroFloatArray",
                                            "href":"DataReaderGetNonZeroFloatArrayOverloads.html#GUID-5E01C31C-8636-43DB-8E14-EF09E788BE64"
                                        },
                                        {
                                            "title":"GetNonZeroFloatArray(int)",
                                            "href":"DataReaderGetNonZeroFloatArray1.html#GUID-A53D2709-556E-41A1-91EC-F6DC46BAD4A4"
                                        },
                                        {
                                            "title":"GetNonZeroFloatArray(string)",
                                            "href":"DataReaderGetNonZeroFloatArray2.html#GUID-BDA74A31-FDC1-4344-9663-5F14CF325CB7"
                                        },
                                        {
                                            "title":"GetNonZeroIndexArray",
                                            "href":"DataReaderGetNonZeroIndexArrayOverloads.html#GUID-BA79F8E5-6EF5-4384-B8C7-50B64A99E9B4"
                                        },
                                        {
                                            "title":"GetNonZeroIndexArray(int)",
                                            "href":"DataReaderGetNonZeroIndexArray1.html#GUID-3FC7A7F7-7B7A-4CA5-8963-6ED7AB81D0B6"
                                        },
                                        {
                                            "title":"GetNonZeroIndexArray(string)",
                                            "href":"DataReaderGetNonZeroIndexArray2.html#GUID-E0BD4BDD-172C-4368-A938-FA35E9D4151C"
                                        },
                                        {
                                            "title":"GetNonZeroInt16Array",
                                            "href":"DataReaderGetNonZeroInt16ArrayOverloads.html#GUID-37923215-7B48-4E81-87DB-85932B4C53DC"
                                        },
                                        {
                                            "title":"GetNonZeroInt16Array(int)",
                                            "href":"DataReaderGetNonZeroInt16Array1.html#GUID-287B4323-89CB-48E4-B550-D26B8DA6212D"
                                        },
                                        {
                                            "title":"GetNonZeroInt16Array(string)",
                                            "href":"DataReaderGetNonZeroInt16Array2.html#GUID-33A85FA3-7E68-411B-94A4-42C91EA0769B"
                                        },
                                        {
                                            "title":"GetOracleBFile",
                                            "href":"DataReaderGetOracleBFile.html#GUID-2A757D3A-8022-4985-BF14-E0C5F3858E46"
                                        },
                                        {
                                            "title":"GetOracleBinary",
                                            "href":"DataReaderGetOracleBinary.html#GUID-2528B518-A83B-40CA-B9EF-D52315BA5383"
                                        },
                                        {
                                            "title":"GetOracleBlob",
                                            "href":"DataReaderGetOracleBlob.html#GUID-63895CBE-A3A9-494F-9B01-1D31B45EFA57"
                                        },
                                        {
                                            "title":"GetOracleBlobForUpdate",
                                            "href":"DataReaderGetOracleBlobForUpdateOverloads.html#GUID-479C039E-93D6-41A6-BFB2-D88D9F43CA40"
                                        },
                                        {
                                            "title":"GetOracleBlobForUpdate(int)",
                                            "href":"DataReaderGetOracleBlobForUpdate1.html#GUID-0E2653B7-53C1-4B96-A257-A0B738EACD17"
                                        },
                                        {
                                            "title":"GetOracleBlobForUpdate(int, int)",
                                            "href":"DataReaderGetOracleBlobForUpdate2.html#GUID-ACE7D7A8-B0B5-4697-8B14-C3F89D7E8B49"
                                        },
                                        {
                                            "title":"GetOracleBoolean(int)",
                                            "href":"DataReaderGetOracleBoolean.html#GUID-78C92008-7507-4AE8-AC4B-125A2A75EC50"
                                        },
                                        {
                                            "title":"GetOracleClob",
                                            "href":"DataReaderGetOracleClob.html#GUID-5F1A524D-4342-450E-9264-5414E75DC7E6"
                                        },
                                        {
                                            "title":"GetOracleClobForUpdate",
                                            "href":"DataReaderGetOracleForUpdateOverloads.html#GUID-8DF5B572-8851-46F8-96CF-FBF100F5FA34"
                                        },
                                        {
                                            "title":"GetOracleClobForUpdate(int)",
                                            "href":"DataReaderGetOracleClobForUpdate1.html#GUID-9DD13AA4-A780-4BB4-8973-30514EFDA65C"
                                        },
                                        {
                                            "title":"GetOracleClobForUpdate(int, int)",
                                            "href":"DataReaderGetOracleClobForUpdate2.html#GUID-54752B42-F982-420C-9806-49B65CA46AA3"
                                        },
                                        {
                                            "title":"GetOracleDataReader",
                                            "href":"DataReaderGetOracleDataReader.html#GUID-0BBE63F4-74C4-4A59-BDD8-711316605593"
                                        },
                                        {
                                            "title":"GetOracleDate",
                                            "href":"DataReaderGetOracleDate.html#GUID-421B2413-AF0F-4622-AD63-CF1AA5A64AAE"
                                        },
                                        {
                                            "title":"GetOracleDecimal",
                                            "href":"DataReaderGetOracleDecimal.html#GUID-66DA895B-1978-481B-8705-418ED8C6D882"
                                        },
                                        {
                                            "title":"GetOracleIntervalDS",
                                            "href":"DataReaderGetOracleIntervalDS.html#GUID-937CDD87-9C0C-46DC-B16A-4A226E4041BB"
                                        },
                                        {
                                            "title":"GetOracleIntervalYM",
                                            "href":"DataReaderGetOracleIntervalYM.html#GUID-1FE80F92-46AF-4AE5-9322-652B735D5C5E"
                                        },
                                        {
                                            "title":"GetOracleRef",
                                            "href":"DataReaderGetOracleRef.html#GUID-7FAE9761-223E-436B-A4D0-441D2D54E88B"
                                        },
                                        {
                                            "title":"GetOracleRefCursor",
                                            "href":"DataReaderGetOracleRefCursor.html#GUID-EEB24E3B-E565-455E-B6DE-1400E28F37ED"
                                        },
                                        {
                                            "title":"GetOracleString",
                                            "href":"DataReaderGetOracleString.html#GUID-B9DEDD8F-DAF6-4C04-81D9-3A2F0849C256"
                                        },
                                        {
                                            "title":"GetOracleTimeStamp",
                                            "href":"DataReaderGetOracleTimeStamp.html#GUID-26D01DE8-CF95-4AE9-98CD-0735FBA8AEE8"
                                        },
                                        {
                                            "title":"GetOracleTimeStampLTZ",
                                            "href":"DataReaderGetOracleTimeStampLTZ.html#GUID-5593D00F-9353-4B08-BCC9-62CA4AEFB52A"
                                        },
                                        {
                                            "title":"GetOracleTimeStampTZ",
                                            "href":"DataReaderGetOracleTimeStampTZ.html#GUID-6E6550F0-5D01-4B12-B2F6-00BA3D0FAD56"
                                        },
                                        {
                                            "title":"GetOracleXmlType",
                                            "href":"DataReaderGetOracleXmlType.html#GUID-9915DC1C-B266-4F1E-8562-FB954D40C367"
                                        },
                                        {
                                            "title":"GetOracleValue",
                                            "href":"DataReaderGetOracleValue.html#GUID-C8961F71-A8E1-4032-81DC-89E306450DCA"
                                        },
                                        {
                                            "title":"GetOracleValues",
                                            "href":"DataReaderGetOracleValues.html#GUID-72AFB951-26F5-4209-ACAF-CF2D2A175C05"
                                        },
                                        {
                                            "title":"GetOracleVector",
                                            "href":"DataReaderGetOracleVectorOverloads.html#GUID-30E1557A-12AA-4B10-913C-4A21EF9B10B2"
                                        },
                                        {
                                            "title":"GetOracleVector(int)",
                                            "href":"DataReaderGetOracleVector1.html#GUID-A0316907-D9A2-4DCD-8B5E-9F396E430133"
                                        },
                                        {
                                            "title":"GetOracleVector(string)",
                                            "href":"DataReaderGetOracleVector2.html#GUID-9A43F3A6-B977-412D-A154-38376B6084B0"
                                        },
                                        {
                                            "title":"GetOrdinal",
                                            "href":"DataReaderGetOrdinal.html#GUID-3FDF55D2-115A-4022-B6DA-2F8EDF9302B3"
                                        },
                                        {
                                            "title":"GetProviderSpecificFieldType",
                                            "href":"DataReaderGetProviderSpecificFieldType.html#GUID-32E841BC-BF4C-4025-8874-705932590972"
                                        },
                                        {
                                            "title":"GetProviderSpecificValue",
                                            "href":"DataReaderGetProviderSpecificValue.html#GUID-70F9AE5E-C492-43E0-8A75-351A7D69B244"
                                        },
                                        {
                                            "title":"GetProviderSpecificValues",
                                            "href":"DataReaderGetProviderSpecificValues.html#GUID-7413FC97-D9E3-4987-BCA2-9AFE0623D3BF"
                                        },
                                        {
                                            "title":"GetSchemaTable",
                                            "href":"DataReaderGetSchemaTable.html#GUID-F249DD7B-3E38-460A-A987-2ACCA268F0CB"
                                        },
                                        {
                                            "title":"GetString",
                                            "href":"DataReaderGetString.html#GUID-242D41E6-35D9-4517-B4A1-972C99D60375"
                                        },
                                        {
                                            "title":"GetTimeSpan",
                                            "href":"DataReaderGetTimeSpan.html#GUID-FCE7C80F-D2A8-422F-B461-913FA419D7A5"
                                        },
                                        {
                                            "title":"GetValue",
                                            "href":"DataReaderGetValue.html#GUID-27587006-D091-465D-8942-27BE72F8A41A"
                                        },
                                        {
                                            "title":"GetValues",
                                            "href":"DataReaderGetValues.html#GUID-F6C185FA-C147-4D48-B844-B3D3607B0684"
                                        },
                                        {
                                            "title":"GetVectorDimensions",
                                            "href":"DataReaderGetVectorDimensionsOverloads.html#GUID-77EE0846-0338-49E4-8B20-213BC8CBF170"
                                        },
                                        {
                                            "title":"GetVectorDimensions(int)",
                                            "href":"DataReaderGetVectorDimensions1.html#GUID-ECCB65B0-B5FD-4C1D-9E60-A8A942B9CD99"
                                        },
                                        {
                                            "title":"GetVectorDimensions(string)",
                                            "href":"DataReaderGetVectorDimensions2.html#GUID-D99ABB02-9E54-44B4-BFCF-8562987F9981"
                                        },
                                        {
                                            "title":"GetVectorNumericFormat(int)",
                                            "href":"DataReaderGetVectorNumericFormat1.html#GUID-DD9D53FB-C0D3-4DCC-95EE-ED8FC0F4AEB5"
                                        },
                                        {
                                            "title":"GetVectorNumericFormat(string)",
                                            "href":"DataReaderGetVectorNumericFormat2.html#GUID-A39378B9-EE66-4A4A-B341-51B54063E22B"
                                        },
                                        {
                                            "title":"GetXmlReader",
                                            "href":"DataReaderGetXmlReader.html#GUID-7A27D751-1F36-47C8-972F-FEA996131718"
                                        },
                                        {
                                            "title":"IsDBNull",
                                            "href":"DataReaderIsDBNull.html#GUID-BA67FFC0-8D09-4B76-84D1-EB27ACF48B88"
                                        },
                                        {
                                            "title":"IsDBNullAsync",
                                            "href":"DataReaderIsDBNullAsyncOverloads.html#GUID-DFF633F7-8DC6-4E4F-854D-6654DD634197"
                                        },
                                        {
                                            "title":"IsDBNullAsync(int)",
                                            "href":"DataReaderIsDBNullAsync1.html#GUID-64D011FD-BA5A-4690-A4E0-6FB99D570808"
                                        },
                                        {
                                            "title":"IsDBNullAsync(int, CancellationToken)",
                                            "href":"DataReaderIsDBNullAsync2.html#GUID-D71045F8-0EE1-414F-84B8-C1B7A10EC4D9"
                                        },
                                        {
                                            "title":"NextResult",
                                            "href":"DataReaderNextResult.html#GUID-78F2C693-51CE-43A0-B46D-1B8A64747D36"
                                        },
                                        {
                                            "title":"NextResultAsync",
                                            "href":"DataReaderNextResultAsyncOverloads.html#GUID-9AAC2AE7-93C7-47CF-A8CC-3828C80FFB1E"
                                        },
                                        {
                                            "title":"NextResultAsync()",
                                            "href":"DataReaderNextResultAsync1.html#GUID-3E979555-66E6-4AFC-B86A-53C2360A566B"
                                        },
                                        {
                                            "title":"NextResultAsync(CancellationToken)",
                                            "href":"DataReaderNextResultAsync2.html#GUID-6B8A2A1B-3C6D-475D-A5D1-4F407180577B"
                                        },
                                        {
                                            "title":"Read",
                                            "href":"DataReaderRead.html#GUID-F49A637E-6D0E-4D0A-AD55-2BB0B8E28372"
                                        },
                                        {
                                            "title":"ReadAsync",
                                            "href":"DataReaderReadAsyncOverloads.html#GUID-24718EE8-A7E5-45D9-ABE0-3184D96EC2DA"
                                        },
                                        {
                                            "title":"ReadAsync()",
                                            "href":"DataReaderReadAsync1.html#GUID-BCB842BC-AC20-4A5F-B912-5164E92E52B5"
                                        },
                                        {
                                            "title":"ReadAsync(CancellationToken)",
                                            "href":"DataReaderReadAsync2.html#GUID-413568ED-3F1E-4BC5-BC9C-073B52DCC347"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDataSource Class",
                            "href":"OracleDataSourceClass.html#GUID-144A8325-82E5-41CF-B98C-E5CE017625CF",
                            "topics":[
                                {
                                    "title":"OracleDataSource Members",
                                    "href":"OracleDataSourceMembers.html#GUID-577C41AA-7B09-4A3B-AF0B-820FAA59B49C"
                                },
                                {
                                    "title":"OracleDataSource Public Methods",
                                    "href":"OracleDataSourcePublicMethods.html#GUID-1FCEC495-3E57-414C-BF17-6E9E132E5E8A",
                                    "topics":[
                                        {
                                            "title":"ClearPool",
                                            "href":"DataSourceClearPool.html#GUID-217B5F09-B908-4FA8-99F3-B5438DAEB99C"
                                        },
                                        {
                                            "title":"CreateCommand",
                                            "href":"DataSourceCreateCommand.html#GUID-7D97299E-F19C-4B38-BF4B-04D992B5420B"
                                        },
                                        {
                                            "title":"CreateConnection",
                                            "href":"DataSourceCreateConnection.html#GUID-23651150-DFDC-4484-AE9B-90E414E0D229"
                                        },
                                        {
                                            "title":"OpenConnection",
                                            "href":"DataSourceOpenConnection.html#GUID-41FBBADA-B94C-4517-A386-D3EE686D6593"
                                        },
                                        {
                                            "title":"OpenConnectionAsync",
                                            "href":"DataSourceOpenConnectionAsync.html#GUID-257E2F75-57DE-43F5-B5BB-B1D9D4E3BBAE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataSource Properties",
                                    "href":"OracleDataSourceProperties.html#GUID-821755FA-D4B1-447A-B546-2E773947DAA2",
                                    "topics":[
                                        {
                                            "title":"ConnectionString",
                                            "href":"DataSourceConnectionString.html#GUID-EC89AC0B-1F38-415D-A21D-8757B484E903"
                                        },
                                        {
                                            "title":"DatabaseCharset",
                                            "href":"DataSourceDatabaseCharset.html#GUID-FB72EA13-D2C2-403F-9CEF-EFDDA47B9433"
                                        },
                                        {
                                            "title":"DatabaseMaxIdentifierLength",
                                            "href":"DataSourceDatabaseMaxIdentifierLength.html#GUID-30A62D89-0F6C-4578-9211-E93245B80829"
                                        },
                                        {
                                            "title":"DatabaseNCharset",
                                            "href":"DataSourceDatabaseNCharset.html#GUID-72906C0C-5A9B-4C1E-900B-6BC1599E4F6C"
                                        },
                                        {
                                            "title":"Password",
                                            "href":"DataSourcePassword.html#GUID-B37BAC6A-06A6-4967-AC0E-3D3A8234042E"
                                        },
                                        {
                                            "title":"ProxyPassword",
                                            "href":"DataSourceProxyPassword.html#GUID-F888EA9E-9CA6-4AC2-BCBF-C35A17D054A0"
                                        },
                                        {
                                            "title":"RetryCount",
                                            "href":"DataSourceRetryCount.html#GUID-922976AE-38F9-49E5-90D5-DD3BC85E7717"
                                        },
                                        {
                                            "title":"RetryDelay",
                                            "href":"DataSourceRetryDelay.html#GUID-CC505162-ED09-4835-B09D-3CDDD58F8EA1"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataSource Public Events",
                                    "href":"OracleDataSourcePublicEvents.html#GUID-69D37A92-BABC-49FD-A986-99F4547E64F7"
                                }
                            ]
                        },
                        {
                            "title":"OracleDataSourceBuilder Class",
                            "href":"OracleDataSourceBuilderClass.html#GUID-49B10787-882C-4344-87D6-CCE774123F0D",
                            "topics":[
                                {
                                    "title":"OracleDataSourceBuilder Members",
                                    "href":"OracleDataSourceBuilderMembers.html#GUID-728A721C-15FA-400C-9125-43F3482E8802"
                                },
                                {
                                    "title":"OracleDataSourceBuilder Constructor",
                                    "href":"OracleDataSourceBuilderConstructor.html#GUID-4A01840C-726E-4B5A-82FA-04BA82E5A4FA"
                                },
                                {
                                    "title":"OracleDataSourceBuilder Public Methods",
                                    "href":"OracleDataSourceBuilderPublicMethods.html#GUID-C82D3E01-199B-4C9F-A482-D43569E9EEA3",
                                    "topics":[
                                        {
                                            "title":"Build",
                                            "href":"DataSourceBuilderBuild.html#GUID-54168998-DF78-4C17-8E2C-F5998F407AFC"
                                        },
                                        {
                                            "title":"UsePassword",
                                            "href":"DataSourceBuilderUsePasswordOverloads.html#GUID-24B46A9D-B8E0-4392-B2BC-D0B758C8E32A"
                                        },
                                        {
                                            "title":"UsePassword(password)",
                                            "href":"DataSourceBuilderUsePassword1.html#GUID-C3FA3325-D51B-47F6-B998-44349E053FD8"
                                        },
                                        {
                                            "title":"UsePassword(opaquePassword)",
                                            "href":"DataSourceBuilderUsePassword2.html#GUID-77F68071-0D84-4531-B09A-EA32E74E8133"
                                        },
                                        {
                                            "title":"UseProxyPassword",
                                            "href":"DataSourceBuilderUseProxyPasswordOverloads.html#GUID-8EBAE62A-2304-4500-B4FC-691A53CA5935"
                                        },
                                        {
                                            "title":"UseProxyPassword(proxyPassword)",
                                            "href":"DataSourceBuilderUseProxyPassword1.html#GUID-1E4B9CE6-00F2-4094-95C6-74F676DB7F61"
                                        },
                                        {
                                            "title":"UseProxyPassword(opaquePassword)",
                                            "href":"DataSourceBuilderUseProxyPassword2.html#GUID-C1D8B58A-8AF2-4DA6-AFBB-49F5AE098DDD"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataSourceBuilder Properties",
                                    "href":"OracleDataSourceBuilderProperties.html#GUID-EE8F613A-36D9-45E9-A735-3D6EC3074FFD",
                                    "topics":[
                                        {
                                            "title":"ConnectionString",
                                            "href":"DataSourceBuilderConnectionString.html#GUID-471C6F8F-88EB-4585-B396-2F01EE361994"
                                        }
                                    ]
                                },
                                {
                                    "title":"Methods, Properties, and Events in Common with OracleConnection or OracleDataSource",
                                    "href":"OracleDataSourceBuilderMPE.html#GUID-1B062D5A-2B81-45AB-B401-79E984C127B1"
                                }
                            ]
                        },
                        {
                            "title":"OracleDataSourceCollection Class",
                            "href":"OracleDataSourceCollectionClass.html#GUID-C1D73432-B409-46BE-B060-B5EA06BBBC69",
                            "topics":[
                                {
                                    "title":"OracleDataSourceCollection Members",
                                    "href":"OracleDataSourceCollectionMembers.html#GUID-3E6AB80F-CEA3-49E7-9815-06AF7AB9CB55"
                                },
                                {
                                    "title":"OracleDataSourceCollection Methods",
                                    "href":"DataSourceCollectionMethods.html#GUID-CB4FC94A-2A01-4BAF-A319-7B89A1F3F524",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"DataSourceCollectionAdd.html#GUID-A17017CE-7DBD-429B-8C07-2A7CD0132643"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"DataSourceCollectionRemove.html#GUID-E151ADC7-69F9-4550-AE84-C7C8317700E2"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataSourceCollection Properties",
                                    "href":"DataSourceCollectionProperties.html#GUID-3C0040FF-2637-46B7-9393-4BD00CA5FE38",
                                    "topics":[
                                        {
                                            "title":"Count",
                                            "href":"DataSourceCollectionCount.html#GUID-63551BAB-BB50-4234-8CB0-227F2FC419F1"
                                        },
                                        {
                                            "title":"This",
                                            "href":"DataSourceCollectionThis.html#GUID-E6F8DCCB-6A3C-4442-9184-2A973B984CF3"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDataSourceCommand Class",
                            "href":"OracleDataSourceCommandClass.html#GUID-E2897CC1-64A1-47D4-8738-92F5DEB54ACF",
                            "topics":[
                                {
                                    "title":"OracleDataSourceCommand Members",
                                    "href":"OracleDataSourceCommandMembers.html#GUID-760EA5F5-75FC-4E4D-956A-D61DE6D35853"
                                },
                                {
                                    "title":"OracleDataSource Public Methods",
                                    "href":"OracleDataSourceCommandPublicMethods.html#GUID-B389C3EC-77C6-41B4-B685-D5CD0CC97CD2",
                                    "topics":[
                                        {
                                            "title":"ExecuteReader",
                                            "href":"DataSourceCommandExecuteReaderOverloads.html#GUID-AA722626-FD51-487E-982F-FB7FBD6236FF"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync",
                                            "href":"DataSourceCommandExecuteReaderAsyncOverloads.html#GUID-DED102C3-2B5A-4EC6-A8B1-7443BF482160"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync(cancellationToken)",
                                            "href":"DataSourceCommandExecuteReaderAsync1.html#GUID-8D05105B-B135-4CB9-BDBF-5BED143ED9DA"
                                        },
                                        {
                                            "title":"ExecuteReaderAsync(commandBehavior, cancellationToken)",
                                            "href":"DataSourceCommandExecuteReaderAsync2.html#GUID-806F1798-89DD-493B-8199-0989F1EDFC11"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDataSourceCommand Properties",
                                    "href":"oracledatasourcecommand-properties.html#GUID-391163A6-6FEA-445D-9E54-DC839BD89AF9"
                                }
                            ]
                        },
                        {
                            "title":"OracleDataSourceEnumerator Class",
                            "href":"OracleDataSourceEnumeratorClass.html#GUID-05A6ED15-DC1D-41CC-980F-3C92063B174F",
                            "topics":[
                                {
                                    "title":"OracleDataSourceEnumerator Members",
                                    "href":"OracleDataSourceEnumeratorMembers.html#GUID-68BF1FDE-F618-4E64-B2F9-0AA8F9DD24FD"
                                },
                                {
                                    "title":"OracleDataSourceEnumerator Constructor",
                                    "href":"DataSourceEnumeratorCtor.html#GUID-6E101AC1-180A-47A9-B0C5-646D05A473C5"
                                },
                                {
                                    "title":"OracleDataSourceEnumerator Public Methods",
                                    "href":"DataSourceEnumeratorPublicMethods.html#GUID-97D17EA5-8980-4558-AD16-F58A3B27B64B",
                                    "topics":[
                                        {
                                            "title":"GetDataSources",
                                            "href":"DataSourceEnumeratorGetDataSources.html#GUID-99B76055-D306-48F4-A5E9-0976581CB20B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDBMSAssert Class",
                            "href":"OracleDBMSAssertClass.html#GUID-7BC39F56-04AE-47E8-ACE1-156F4B809B6F",
                            "topics":[
                                {
                                    "title":"OracleDBMSAssert Methods",
                                    "href":"OracleDBMSAssertMethods.html#GUID-CD699731-FEDB-4B61-9961-A32D58872B70",
                                    "topics":[
                                        {
                                            "title":"EnquoteIdentifier",
                                            "href":"DBMSAssertEnquoteIdentifierOverloads.html#GUID-12C40BDE-A17C-4312-9934-A835652C7D23"
                                        },
                                        {
                                            "title":"EnquoteIdentifier(identifier, maxIdentifierLength, charset, bAlwaysQuote, bCapitalize)",
                                            "href":"DBMSAssertEnquoteIdentifier1.html#GUID-F2504B5E-8E9F-48FB-A5BA-EFAB25A6EF6D"
                                        },
                                        {
                                            "title":"EnquoteIdentifier(identifier, bAlwaysQuote, bCapitalize)",
                                            "href":"DBMSAssertEnquoteIdentifier2.html#GUID-7F7CFE2A-743F-4140-B4F2-ECAC5862A138"
                                        },
                                        {
                                            "title":"EnquoteLiteral",
                                            "href":"DBMSAssertEnquoteLiteralOverloads.html#GUID-3CAF5901-EC25-4D54-BF91-3078E0E29B81"
                                        },
                                        {
                                            "title":"EnquoteLiteral(literal, charset)",
                                            "href":"DBMSAssertEnquoteLiteral1.html#GUID-120202D7-8A97-42C9-93FC-52CF662F6C1E"
                                        },
                                        {
                                            "title":"EnquoteLiteral(literal)",
                                            "href":"DBMSAssertEnquoteLiteral2.html#GUID-B7D47393-AC0B-4F5D-8C13-56DA7E3ACD20"
                                        },
                                        {
                                            "title":"EnquoteNCharLiteral",
                                            "href":"DBMSAssertEnquoteNCharLiteralOverloads.html#GUID-8D47C3A3-6D64-400D-98AC-B545C91DBCFD"
                                        },
                                        {
                                            "title":"EnquoteNCharLiteral(literal, ncharset)",
                                            "href":"DBMSAssertEnquoteNCharLiteral1.html#GUID-A28116D0-1623-4A84-9A57-56C9671DC2EE"
                                        },
                                        {
                                            "title":"EnquoteNCharLiteral(literal)",
                                            "href":"DBMSAssertEnquoteNCharLiteral2.html#GUID-177E57B6-F828-41B8-A9C2-071D922CC449"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleError Class",
                            "href":"OracleErrorClass.html#GUID-CA1DE3CE-8601-4E91-AD67-04D1D6AFAA16",
                            "topics":[
                                {
                                    "title":"OracleError Members",
                                    "href":"ErrorMembers.html#GUID-29F5FFF3-FDBC-488C-AC0C-1F6D8D024E8E"
                                },
                                {
                                    "title":"OracleError Static Methods",
                                    "href":"ErrorStaticMethods.html#GUID-0AB915A6-C1C0-4CBD-AC43-3DF26B2E4FC0"
                                },
                                {
                                    "title":"OracleError Properties",
                                    "href":"ErrorProperties.html#GUID-CC9A4FB5-7D45-49E0-9C0F-3E6469BD2E45",
                                    "topics":[
                                        {
                                            "title":"ArrayBindIndex",
                                            "href":"ArrayBindIndex.html#GUID-CA0B6274-CCD8-40E7-86F8-739DDDCE3378"
                                        },
                                        {
                                            "title":"DataSource",
                                            "href":"ErrorDataSource.html#GUID-FF2E6053-D9BD-410D-B27A-722A6D9A765E"
                                        },
                                        {
                                            "title":"Message",
                                            "href":"ErrorMessage.html#GUID-E9A49160-D752-4643-9762-8379A8B295D7"
                                        },
                                        {
                                            "title":"Number",
                                            "href":"ErrorNumber.html#GUID-ACA4BA61-8DDC-49A4-A13F-9795DE0DD1EC"
                                        },
                                        {
                                            "title":"Procedure",
                                            "href":"ErrorProcedure.html#GUID-0AF9F4C8-B1E2-4060-96D7-6D32927D7E46"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"ErrorSource.html#GUID-901DEA84-8537-4B8D-942C-4EE3CCB7E307"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleError Methods",
                                    "href":"ErrorMethods.html#GUID-63C89798-2454-4CFB-8741-A9EAF2BFB3D3",
                                    "topics":[
                                        {
                                            "title":"ToString",
                                            "href":"ErrorToString.html#GUID-D6174047-3A8D-49CC-8242-0C13A6D577B2"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleErrorCollection Class",
                            "href":"OracleErrorCollectionClass.html#GUID-B18C3EF4-A1E8-407C-87A1-9A15B5D88D09",
                            "topics":[
                                {
                                    "title":"OracleErrorCollection Members",
                                    "href":"ErrorCollectionMembers.html#GUID-065DE41A-98C4-4292-B31A-5DFC7F7B37A1"
                                },
                                {
                                    "title":"OracleErrorCollection Static Methods",
                                    "href":"ErrorCollectionStaticMethods.html#GUID-C58BCC7F-DB9D-44FD-94A9-D867158773B5"
                                },
                                {
                                    "title":"OracleErrorCollection Properties",
                                    "href":"ErrorCollectionProperties.html#GUID-F179FF43-3A08-4F6B-B1C3-099135A23AE1"
                                },
                                {
                                    "title":"OracleErrorCollection Public Methods",
                                    "href":"ErrorCollectionPublicMethods.html#GUID-3E48CFF4-35E7-4A00-8D04-7981B0E55B2A"
                                }
                            ]
                        },
                        {
                            "title":"OracleException Class",
                            "href":"OracleExceptionClass.html#GUID-6849ECDC-9730-45E6-9F8E-FC2BBC95C97C",
                            "topics":[
                                {
                                    "title":"OracleException Members",
                                    "href":"ExceptionMembers.html#GUID-F4D71411-78C2-46E7-84B1-40B7DD8B4739"
                                },
                                {
                                    "title":"OracleException Static Methods",
                                    "href":"ExceptionStaticMethods.html#GUID-2C97DEF9-4EE8-4A0E-ABB1-268057225123"
                                },
                                {
                                    "title":"OracleException Properties",
                                    "href":"ExceptionProperties.html#GUID-1C2A9C63-DF37-43B3-B308-ED6F7E3CEED9",
                                    "topics":[
                                        {
                                            "title":"DataSource",
                                            "href":"ExceptionDataSource.html#GUID-D0E75CB9-28BE-469B-8260-839EB334F9F6"
                                        },
                                        {
                                            "title":"Errors",
                                            "href":"ExceptionErrors.html#GUID-D3C758F4-3222-4B60-AF8C-F00C7326BD86"
                                        },
                                        {
                                            "title":"IsRecoverable",
                                            "href":"ExceptionIsRecoverable.html#GUID-0010EC17-B5AA-4161-B119-E1243882EB0C"
                                        },
                                        {
                                            "title":"Message",
                                            "href":"ExceptionMessage.html#GUID-C7B95B81-A5C8-4D76-A62F-2043C781429F"
                                        },
                                        {
                                            "title":"Number",
                                            "href":"ExceptionNumber.html#GUID-5D556DFF-ADC9-4707-AD58-003F15CA5E50"
                                        },
                                        {
                                            "title":"OracleLogicalTransaction",
                                            "href":"ExceptionOracleLogicalTransaction.html#GUID-7C846C0E-B916-4C30-BDA3-6C8485E6E970"
                                        },
                                        {
                                            "title":"Procedure",
                                            "href":"ExceptionProcedure.html#GUID-2198EDD0-B7C6-4760-AB11-C0739EA9B1C2"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"ExceptionSource.html#GUID-53D4BA0A-896E-4D20-B3AE-70F1E62D3274"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleException Methods",
                                    "href":"ExceptionMethods.html#GUID-AC3AF583-82F7-43CC-8F4A-25116DA7D610",
                                    "topics":[
                                        {
                                            "title":"GetObjectData",
                                            "href":"ExceptionGetObjectData.html#GUID-D2139CC9-EFDF-4B5C-AD76-310CD40ADA35"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"ExceptionToString.html#GUID-5763D79C-5603-44EC-B96B-543C93FAF243"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleInfoMessageEventArgs Class",
                            "href":"OracleInfoMessageEventArgsClass.html#GUID-DDAEF19D-72DE-4464-B792-E98DD4DFF09B",
                            "topics":[
                                {
                                    "title":"OracleInfoMessageEventArgs Members",
                                    "href":"OracleInfoMessageEventArgsmembers.html#GUID-67B9D858-CBB1-4563-97DA-F7ED9072797B"
                                },
                                {
                                    "title":"OracleInfoMessageEventArgs Static Methods",
                                    "href":"InfoMessageEventArgsStaticMethods.html#GUID-A955D7B8-3A94-4DDE-A8FD-FA412180D61F"
                                },
                                {
                                    "title":"OracleInfoMessageEventArgs Properties",
                                    "href":"InfoMessageEventArgsProperties.html#GUID-69FEA7C7-0A44-4E87-BE7C-2069480469D0",
                                    "topics":[
                                        {
                                            "title":"Errors",
                                            "href":"InfoMessageEventArgsErrors.html#GUID-44D6DF7A-10E4-45C4-A999-AF03AA202688"
                                        },
                                        {
                                            "title":"Message",
                                            "href":"InfoMessageEventArgsMessage.html#GUID-EAE947C7-F186-4E44-917D-45EB06596E33"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"InfoMessageEventArgsSource.html#GUID-D73D21A5-CB8D-4CB4-9364-B609D28D28B6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleInfoMessageEventArgs Public Methods",
                                    "href":"InfoMessageEventArgsPublicMethods.html#GUID-978CC44A-9DDB-4D66-93FA-5F2D5585FACC",
                                    "topics":[
                                        {
                                            "title":"ToString",
                                            "href":"InfoMessageEventArgsToString.html#GUID-D44165D3-DF77-45BE-862D-9EBDD4DDF001"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleInfoMessageEventHandler Delegate",
                            "href":"OracleInfoMessageEventHandlerDelegate.html#GUID-7D222CD9-1D79-47FF-8576-1E10DB35654D"
                        },
                        {
                            "title":"OracleLogicalTransaction Class",
                            "href":"OracleLogicalTransactionClass.html#GUID-28836692-AB05-4E34-AE58-FB87DADDAA1C",
                            "topics":[
                                {
                                    "title":"OracleLogicalTransaction Members",
                                    "href":"LogicalTransactionMembers.html#GUID-53FD6570-47D6-4A75-A26D-27096A5F9629"
                                },
                                {
                                    "title":"OracleLogicalTransaction Public Read-Only Properties",
                                    "href":"LogicalTransactionPublicProperties.html#GUID-D1397019-1670-4ACC-8166-4368AF31915A",
                                    "topics":[
                                        {
                                            "title":"Committed",
                                            "href":"LogicalTransactionPublicPropertiesCommitted.html#GUID-FF8ADB30-0508-4AF3-B57D-2F1CA1014785"
                                        },
                                        {
                                            "title":"ConnectionString",
                                            "href":"LogicalTransactionPublicPropertiesConnectionString.html#GUID-A0F1AC21-B216-4E83-801B-9D282A187A45"
                                        },
                                        {
                                            "title":"LogicalTransactionId",
                                            "href":"LogicalTransactionPublicPropertiesLogicalTransactionId.html#GUID-B417274B-E5B3-4A48-B3CB-CB55AE600738"
                                        },
                                        {
                                            "title":"UserCallCompleted",
                                            "href":"LogicalTransactionPublicPropertiesUserCallCompleted.html#GUID-28F6E539-A9BC-4938-AAD8-B5D70DEA8A72"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleLogicalTransaction Methods",
                                    "href":"LogicalTransactionMethods.html#GUID-01E7F3A7-2FC6-46B6-96C5-CE21384A3E0F",
                                    "topics":[
                                        {
                                            "title":"Dispose",
                                            "href":"LogicalTransactionDispose.html#GUID-CEE43783-54EB-402D-9435-8767BDA3BD47"
                                        },
                                        {
                                            "title":"GetOutcome",
                                            "href":"LogicalTransactionGetOutcomeOverloads.html#GUID-D051EA4C-2C49-4950-894F-5F142D653BBF"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleOnsServerCollection Class",
                            "href":"OracleOnsServerCollectionClass.html#GUID-3E1F75B0-C6F0-4945-8F31-75DB20A3C579",
                            "topics":[
                                {
                                    "title":"OracleOnsServerCollection Members",
                                    "href":"OracleOnsServerCollectionMembers.html#GUID-9FA500FE-F628-4261-8490-F535C9827094"
                                },
                                {
                                    "title":"OracleOnsServerCollection Methods",
                                    "href":"OnsServerCollectionMethods.html#GUID-38105B01-3974-4862-9477-A7F8667B10A0",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"OnsServerCollectionAdd.html#GUID-11861187-1502-410A-9A59-757519BC5D49"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"OnsServerCollectionRemove.html#GUID-6B5F12D8-B4DC-4A1B-9FF8-2139DC530F05"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleOnsServerCollection Properties",
                                    "href":"OnsServerCollectionProperties.html#GUID-DFD43F5A-07CF-4A08-8D3A-0A4099FBABE9",
                                    "topics":[
                                        {
                                            "title":"Count",
                                            "href":"OnsServerCollectionCount.html#GUID-5391C474-E44A-4D61-8CF8-5E96F14E6E70"
                                        },
                                        {
                                            "title":"This",
                                            "href":"OnsServerCollectionThis.html#GUID-46355498-166A-4256-B265-33628A70CF77"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleOpaqueString Class",
                            "href":"OracleOpaqueStringClass.html#GUID-B2BDFBCC-E6B2-4850-BBAF-6E200E0AC641",
                            "topics":[
                                {
                                    "title":"OracleOpaqueString Members",
                                    "href":"OracleOpaqueStringMembers.html#GUID-8169994E-18A3-44F8-8634-28408B84CFE7"
                                },
                                {
                                    "title":"OracleOpaqueString Constructor",
                                    "href":"OracleOpaqueStringctor1.html#GUID-A0425D6A-C202-410C-922F-1C3FB3A1F529"
                                },
                                {
                                    "title":"OracleOpaqueString Properties",
                                    "href":"OracleOpaqueStringProperties.html#GUID-8222B2A3-6841-454F-AFF6-F039BBEE4D26",
                                    "topics":[
                                        {
                                            "title":"Length",
                                            "href":"OpaqueStringLength.html#GUID-A8C6F678-2669-4C72-871A-7834ECD50B81"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleOpaqueString Methods",
                                    "href":"OracleOpaqueStringMethods.html#GUID-124D9DDD-960A-41EB-AF72-155CFC71BAB9",
                                    "topics":[
                                        {
                                            "title":"AppendChar",
                                            "href":"OpaqueStringAppendChar.html#GUID-2655E0EA-D5BB-46A2-AB3F-FBCE824C8571"
                                        },
                                        {
                                            "title":"Clear",
                                            "href":"OpaqueStringClear.html#GUID-C48EFF72-2162-4149-AB36-FE5BBD9EA45B"
                                        },
                                        {
                                            "title":"Copy",
                                            "href":"OpaqueStringCopy.html#GUID-E8991F4B-075B-46D8-91D1-E0C954431614"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"OpaqueStringDispose.html#GUID-8445D2CB-EF44-4E18-9E4C-A21E337EC17A"
                                        },
                                        {
                                            "title":"IsReadOnly",
                                            "href":"OpaqueStringIsReadOnly.html#GUID-2496FDF6-E2F6-4400-B728-E2CB57B1562A"
                                        },
                                        {
                                            "title":"MakeReadOnly",
                                            "href":"OpaqueStringMakeReadOnly.html#GUID-7FA80A07-1E88-457E-8252-1A9F86DE483B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleParameter Class",
                            "href":"OracleParameterClass.html#GUID-F6A0A115-1AF6-4A74-991B-00C7F7D601AE",
                            "topics":[
                                {
                                    "title":"OracleParameter Members",
                                    "href":"ParameterMembers.html#GUID-447C1DCD-1208-4795-BB2F-DB5BFEDB339C"
                                },
                                {
                                    "title":"OracleParameter Constructors",
                                    "href":"ParameterCtors.html#GUID-EC036FDB-1ADD-4733-85A0-2652042B5A52",
                                    "topics":[
                                        {
                                            "title":"OracleParameter()",
                                            "href":"ParameterCtor1.html#GUID-9AF8CE62-E697-4B87-B1A4-8B727DFF5514"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType)",
                                            "href":"ParameterCtor2.html#GUID-021811CB-0966-4D8C-8EB5-0640974A9C4A"
                                        },
                                        {
                                            "title":"OracleParameter(string, object)",
                                            "href":"ParameterCtor3.html#GUID-28B3EE93-63AE-4E43-ADD2-503E451D16A6"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, ParameterDirection)",
                                            "href":"ParameterCtor4.html#GUID-7EB24787-2D19-41A2-968B-BF1BF002E599"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, object, ParameterDirection)",
                                            "href":"ParameterCtor5.html#GUID-04BE7E69-A80A-4D28-979A-CDC2516C0F93"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, int)",
                                            "href":"ParameterCtor6.html#GUID-57FB64E9-84EF-4F95-B548-149B27FDE591"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, int, string)",
                                            "href":"ParameterCtor7.html#GUID-A6CBBDCA-7B6C-4B32-9DD1-FB93E219D54C"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, int, ParameterDirection, bool, byte, byte, string, DataRowVersion, object)",
                                            "href":"ParameterCtor8.html#GUID-24168402-5E59-42FE-BF4C-2F471E0EACAF"
                                        },
                                        {
                                            "title":"OracleParameter(string, OracleDbType, int, object, ParameterDirection)",
                                            "href":"ParameterCtor9.html#GUID-EEA66161-F814-4B12-8E8B-3DCE32324A59"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleParameter Static Methods",
                                    "href":"ParameterStaticMethods.html#GUID-8BE90A31-D6DA-47AD-96E1-15668934D95C"
                                },
                                {
                                    "title":"OracleParameter Properties",
                                    "href":"ParameterProperties.html#GUID-003F9060-0DD6-4D0C-8E83-1CAC67C3CF71",
                                    "topics":[
                                        {
                                            "title":"ArrayBindSize",
                                            "href":"ParameterArrayBindSize.html#GUID-58C334FB-7121-466E-B16E-634ACE02E1FB"
                                        },
                                        {
                                            "title":"ArrayBindStatus",
                                            "href":"ParameterArrayBindStatus.html#GUID-F6A96A1F-3E66-42AD-A3C3-AFDC551B4C32"
                                        },
                                        {
                                            "title":"CollectionType",
                                            "href":"ParameterCollectionType.html#GUID-03B5C382-C3AA-4393-8AE8-A9B41D1D02D7"
                                        },
                                        {
                                            "title":"DbType",
                                            "href":"ParameterDbtype.html#GUID-75F32157-8D0D-4D6C-8906-F6B0F5604B92"
                                        },
                                        {
                                            "title":"Direction",
                                            "href":"ParameterDirection.html#GUID-3689F98E-C6EB-4871-B49D-AF0A8449C8E1"
                                        },
                                        {
                                            "title":"IsNullable",
                                            "href":"ParameterIsNullable.html#GUID-0BB21944-E027-4BA0-8BE0-2EF6EB4AC9EE"
                                        },
                                        {
                                            "title":"Offset",
                                            "href":"ParameterOffset.html#GUID-A26A9DB1-2F07-4AA4-9FB7-5C6F02695328"
                                        },
                                        {
                                            "title":"OracleDbType",
                                            "href":"ParameterOracleDbType.html#GUID-3643C815-6FDC-4B1E-AD71-75CF2B844437"
                                        },
                                        {
                                            "title":"OracleDbTypeEx",
                                            "href":"ParameterOracleDbTypeEx.html#GUID-AE8758D8-ED13-4150-948D-6E708D081B7F"
                                        },
                                        {
                                            "title":"ParameterName",
                                            "href":"ParameterParameterName.html#GUID-931B5F6B-CF43-4CFF-BFAF-A57AA2F5C451"
                                        },
                                        {
                                            "title":"Precision",
                                            "href":"ParameterPrecision.html#GUID-10E9507D-7DDA-484B-89D3-9E3F13A59667"
                                        },
                                        {
                                            "title":"Scale",
                                            "href":"ParameterScale.html#GUID-0CC94DD4-304B-4866-BE76-2CB6A98A271F"
                                        },
                                        {
                                            "title":"Size",
                                            "href":"ParameterSize.html#GUID-941B5A3B-9D8C-4C81-9E9E-56120FDE27E2"
                                        },
                                        {
                                            "title":"SourceColumn",
                                            "href":"ParameterSourceColumn.html#GUID-3A1D0EF6-85B4-4807-85A2-54E44F9C7D86"
                                        },
                                        {
                                            "title":"SourceColumnNullMapping",
                                            "href":"ParameterSourceColumnNullMapping.html#GUID-3E3E5443-05D6-4A85-B8E3-9D5D0AE11FB4"
                                        },
                                        {
                                            "title":"SourceVersion",
                                            "href":"ParameterSourceVersion.html#GUID-0704B3C5-B0E6-45F6-8EA9-B4ED1BAA3222"
                                        },
                                        {
                                            "title":"Status",
                                            "href":"ParameterStatus.html#GUID-50743F9C-ACA4-47A8-A1A9-8F28BAAEFEE4"
                                        },
                                        {
                                            "title":"UdtTypeName",
                                            "href":"ParameterUdtTypeName.html#GUID-AA564CED-EB87-44F6-ABEE-CC5467824CBC"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"ParameterValue.html#GUID-0709F4DD-4EC4-451A-A61C-27B08C40FC8F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleParameter Public Methods",
                                    "href":"ParameterPublicMethods.html#GUID-75C38889-100C-48AB-A207-C709BFE25554",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"ParameterClone.html#GUID-F75AEF2B-1C0C-4995-8782-26435E3306DE"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"ParameterDispose.html#GUID-B395B1B9-FB57-49A6-B090-7C9AD377F468"
                                        },
                                        {
                                            "title":"ResetDbType",
                                            "href":"ParameterResetDbType.html#GUID-D7A2B1E1-A7B8-4EAA-8E3D-5CED6445F3F2"
                                        },
                                        {
                                            "title":"ResetOracleDbType",
                                            "href":"ParameterResetOracleDbType.html#GUID-26B5094D-C2DC-471F-8C64-5C76C4B4923D"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"ParameterToString.html#GUID-ECB19296-197F-4832-9336-F0A612D7DA33"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleParameterCollection Class",
                            "href":"OracleParameterCollectionClass.html#GUID-92B284FF-6D80-4408-BD0A-DB625965EC04",
                            "topics":[
                                {
                                    "title":"OracleParameterCollection Members",
                                    "href":"ParameterCollectionMembers.html#GUID-E4585D2C-E74B-4092-A7EF-B7B18AAB12C1"
                                },
                                {
                                    "title":"OracleParameterCollection Static Methods",
                                    "href":"ParameterCollectionStaticMethods.html#GUID-EEBF98EF-52EE-468D-8A51-6E247F78C090"
                                },
                                {
                                    "title":"OracleParameterCollection Properties",
                                    "href":"ParameterCollectionProperties.html#GUID-00850792-5CEC-4E18-8B4C-A9AC8D826F2E",
                                    "topics":[
                                        {
                                            "title":"Count",
                                            "href":"ParameterCollectionCount.html#GUID-BBE7BC94-C51C-45A7-BC5B-69960853EA9F"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"ParameterCollectionItemOverloads.html#GUID-643490C3-B150-44C7-AF4D-E13CA09C56BD"
                                        },
                                        {
                                            "title":"Item[int]",
                                            "href":"ParameterCollectionItem1.html#GUID-A309B326-5C50-429B-9C8A-0CC3A77FCA7A"
                                        },
                                        {
                                            "title":"Item[string]",
                                            "href":"ParameterCollectionItem2.html#GUID-04FE1151-5DAC-466B-92D6-EAEE931B3F4E"
                                        },
                                        {
                                            "title":"IsFixedSize",
                                            "href":"ParameterCollectionIsFixedSize.html#GUID-392BC740-A7E9-438F-8CBF-0B4BA0CAE5F2"
                                        },
                                        {
                                            "title":"IsReadOnly",
                                            "href":"ParameterCollectionIsReadOnly.html#GUID-A696B41E-DC62-4DA4-A865-11876D99A899"
                                        },
                                        {
                                            "title":"IsSynchronized",
                                            "href":"ParameterCollectionIsSynchronized.html#GUID-51F29A22-F19C-4A17-A56C-1D9CA35A0466"
                                        },
                                        {
                                            "title":"SyncRoot",
                                            "href":"ParameterCollectionSyncRoot.html#GUID-BFADCB5D-FE4C-48E8-B124-445CE4FC4E85"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleParameterCollection Public Methods",
                                    "href":"ParameterCollectionPublicMethods.html#GUID-EA792D54-A445-4C06-AC57-E1E48EAABD50",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"ParameterCollectionAddOverloads.html#GUID-E55E290B-A706-44EA-AE49-170F03EC5FCD"
                                        },
                                        {
                                            "title":"Add(object)",
                                            "href":"ParameterCollectionAdd1.html#GUID-19DC10EA-5E54-4C82-898F-BFAD2E5C3DAB"
                                        },
                                        {
                                            "title":"Add(OracleParameter)",
                                            "href":"ParameterCollectionAdd2.html#GUID-C1F0359D-6266-4D62-B011-28F65D493A17"
                                        },
                                        {
                                            "title":"Add(string, object)",
                                            "href":"ParameterCollectionAdd3.html#GUID-88FA1D29-0E7C-4E0E-ABB1-484C6A4BCAF6"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType)",
                                            "href":"ParameterCollectionAdd4.html#GUID-96E222C6-A8D7-4A4F-89D8-72E4E2E189CD"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType, ParameterDirection)",
                                            "href":"ParameterCollectionAdd5.html#GUID-1C655B46-7E35-4EBE-8F4E-D8A4FDA541BE"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType, object, ParameterDirection)",
                                            "href":"ParameterCollectionAdd6.html#GUID-6700D223-A3B0-495C-81EC-6EE0D99792FF"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType, int, object, ParameterDirection)",
                                            "href":"ParameterCollectionAdd7.html#GUID-DA7E5751-AE5C-4332-9042-0F2B0CE474E3"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType, int)",
                                            "href":"ParameterCollectionAdd8.html#GUID-56A3D57E-BBAD-4075-BD63-8642AE9B6BF5"
                                        },
                                        {
                                            "title":"Add (string, OracleDbType, int, string)",
                                            "href":"ParameterCollectionAdd9.html#GUID-CD3888A9-0A05-4228-8F48-613FCD277B5A"
                                        },
                                        {
                                            "title":"Add(string, OracleDbType, int, ParameterDirection, bool, byte, byte, string, DataRowVersion, object)",
                                            "href":"ParameterCollectionAdd10.html#GUID-E6AE0949-FF90-44AB-AFC8-97BEF309A041"
                                        },
                                        {
                                            "title":"AddRange",
                                            "href":"ParameterCollectionAddRange.html#GUID-4D779954-72E0-4884-AEDC-319E0B064D22"
                                        },
                                        {
                                            "title":"Clear",
                                            "href":"ParameterCollectionClear.html#GUID-29C47216-441D-4AAD-ACF3-367BF8F640E7"
                                        },
                                        {
                                            "title":"Contains",
                                            "href":"ParameterCollectionContainsOverloads.html#GUID-844EF7CE-687D-4A13-9882-6F6B1CA7480F"
                                        },
                                        {
                                            "title":"Contains(object)",
                                            "href":"ParameterCollectionContains1.html#GUID-518EC761-EC0C-4F8F-A7BC-621134A6120E"
                                        },
                                        {
                                            "title":"Contains(string)",
                                            "href":"ParameterCollectionContains2.html#GUID-D2066AB4-906D-4957-902B-4A2303417F95"
                                        },
                                        {
                                            "title":"CopyTo",
                                            "href":"ParameterCollectionCopyTo.html#GUID-F1C6254A-F1E0-4A67-83A2-7744EBE9A91A"
                                        },
                                        {
                                            "title":"GetEnumerator",
                                            "href":"ParameterCollectionGetEnumerator.html#GUID-1E5C2259-2C8F-4A23-A22A-E1D4CAD34F8F"
                                        },
                                        {
                                            "title":"IndexOf",
                                            "href":"ParameterCollectionIndexOfOverloads.html#GUID-0C53FB5D-7B89-4C3F-8B44-B3E9B9F090D7"
                                        },
                                        {
                                            "title":"IndexOf(object)",
                                            "href":"ParameterCollectionIndexOf1.html#GUID-1E8CCD17-619F-41A2-B75B-5E9D979B7609"
                                        },
                                        {
                                            "title":"IndexOf(String)",
                                            "href":"ParameterCollectionIndexOf2.html#GUID-E23327E6-7317-4E60-A0C2-0C7524E1B356"
                                        },
                                        {
                                            "title":"Insert",
                                            "href":"ParameterCollectionInsert.html#GUID-15CB6D9E-3E34-4B61-80C2-FCBD206D0617"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"ParameterCollectionRemove.html#GUID-EEB04D42-EBC0-43B1-83B5-24EA357201A7"
                                        },
                                        {
                                            "title":"RemoveAt",
                                            "href":"ParameterCollectionRemoveAtOverloads.html#GUID-D91EA9CD-20AA-480D-8BD7-44A682CD6B5B"
                                        },
                                        {
                                            "title":"RemoveAt(int)",
                                            "href":"ParameterCollectionRemoveAt1.html#GUID-CCCB84F8-AA19-4F77-8162-3E3D8FCE3FA9"
                                        },
                                        {
                                            "title":"RemoveAt(String)",
                                            "href":"ParameterCollectionRemoveAt2.html#GUID-74541B1C-14D0-4168-807D-38647ABDE83B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OraclePermission Class",
                            "href":"OraclePermissionClass.html#GUID-580CB511-58DB-47E2-AFDB-C88AE9300DC8",
                            "topics":[
                                {
                                    "title":"OraclePermission Members",
                                    "href":"PermissionMembers.html#GUID-01B2F055-A896-4DCF-A226-FEE9C7018266"
                                },
                                {
                                    "title":"OraclePermission Constructor",
                                    "href":"PermissionCtor.html#GUID-EFB6344F-7947-40C3-BA09-921A3B0B74AC"
                                },
                                {
                                    "title":"OraclePermission Static Methods",
                                    "href":"PermissionStaticMethods.html#GUID-C4DB0A52-1CA4-4FE1-AF21-3AC3DCEDA545"
                                },
                                {
                                    "title":"OraclePermission Public Properties",
                                    "href":"PermissionPublicProperties.html#GUID-4703D593-818E-498E-9583-F688E5B5BC50"
                                },
                                {
                                    "title":"OraclePermission Public Methods",
                                    "href":"PermissionPublicMethods.html#GUID-F53E18BE-8E6A-45E0-8269-77CA6453EF89",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"PermissionAdd.html#GUID-2F332724-1C0A-4AC0-85A6-D6DFE920EBAB"
                                        },
                                        {
                                            "title":"Copy",
                                            "href":"PermissionCopy.html#GUID-0901E8B9-A41B-4B8F-98AB-17231F0EA09C"
                                        },
                                        {
                                            "title":"IsSubsetOf",
                                            "href":"PermissionIsSubsetOf.html#GUID-E12095B8-A69F-40B0-BCF2-A7528E31DF91"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OraclePermissionAttribute Class",
                            "href":"OraclePermissionAttributeClass.html#GUID-5520A788-1BFB-4DB5-9A83-E244CDD5DC32",
                            "topics":[
                                {
                                    "title":"OraclePermissionAttribute Members",
                                    "href":"PermissionAttributeMembers.html#GUID-F1DF507E-09F8-44C2-9F9B-9875FDBD630A"
                                },
                                {
                                    "title":"OraclePermissionAttribute Constructor",
                                    "href":"PermissionAttributeCtors.html#GUID-BBC6DEBE-398B-403E-84E2-28B721A253FF"
                                },
                                {
                                    "title":"OraclePermissionAttribute Static Methods",
                                    "href":"PermissionAttributeStaticMethods.html#GUID-8817F1C5-75D2-4B82-A2AB-8DFA73A53DA7"
                                },
                                {
                                    "title":"OraclePermissionAttribute Public Properties",
                                    "href":"PermissionAttributePublicProperties.html#GUID-C1615245-A7A0-4B33-BD77-EA9FE4BDEB3A"
                                },
                                {
                                    "title":"OraclePermissionAttribute Public Methods",
                                    "href":"PermissionAttributePublicMethods.html#GUID-82330EBD-77BB-4531-A871-11AC321990F6",
                                    "topics":[
                                        {
                                            "title":"CreatePermission",
                                            "href":"PermissionAttributeCreatePermission.html#GUID-E03F6239-B6BA-4CD9-9E3D-4412C3AA7ABD"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleRefreshAccessTokenEventArgs Class",
                            "href":"OracleRefreshAccessTokenEventArgsClass.html#GUID-F8C64F80-35E7-4092-AD21-314ED9B55AEB",
                            "topics":[
                                {
                                    "title":"OracleRefreshAccessTokenEventArgs Members",
                                    "href":"OracleRefreshAccessTokenEventArgsMembers.html#GUID-913476F8-EE13-466A-895B-AD576DF9DF04"
                                },
                                {
                                    "title":"OracleRefreshAccessTokenEventArgs Properties",
                                    "href":"OracleRefreshAccessTokenEventArgsProperties.html#GUID-4C22293D-CE8C-4FF4-9329-D313379B944E",
                                    "topics":[
                                        {
                                            "title":"DbToken",
                                            "href":"RefreshAccessTokenEventArgsDBToken.html#GUID-97F1F256-8A94-4DD5-B447-E0DBFA7D7874"
                                        },
                                        {
                                            "title":"PrivateKey",
                                            "href":"RefreshAccessTokenEventArgsPrivateKey.html#GUID-596F8747-3DB9-422D-B4AE-4E8C67370199"
                                        },
                                        {
                                            "title":"Token",
                                            "href":"RefreshAccessTokenEventArgsToken.html#GUID-A5DFC42F-CB2B-4446-8E23-D9FD8C054C49"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleRoleCollection Class",
                            "href":"OracleRoleCollectionClass.html#GUID-B70CD1C9-350D-421E-BBD2-2FB6EEFF919E",
                            "topics":[
                                {
                                    "title":"OracleRoleCollection Members",
                                    "href":"OracleRoleCollectionMembers.html#GUID-D5D3F477-C534-4CA8-9230-1DFB737C0246"
                                },
                                {
                                    "title":"OracleRoleCollection Methods",
                                    "href":"OracleRoleCollectionMethods.html#GUID-FA310739-AC5A-410F-960E-CC436BA42639",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"RoleCollectionAddOverloads.html#GUID-5E214C19-D764-4897-95C4-413502D6CF57"
                                        },
                                        {
                                            "title":"Add(string)",
                                            "href":"RoleCollectionAdd1.html#GUID-47B0AAFB-1FF9-4237-A89C-3085A69EFE92"
                                        },
                                        {
                                            "title":"Add(string, OracleOpaqueString)",
                                            "href":"RoleCollectionAdd2.html#GUID-5D365387-625B-43EB-9556-C6DF43ED6ABA"
                                        },
                                        {
                                            "title":"Clear",
                                            "href":"RoleCollectionClear.html#GUID-C515A7C8-19FE-4BC8-A9CA-82DA9167D6C6"
                                        },
                                        {
                                            "title":"Contains",
                                            "href":"RoleCollectionContains.html#GUID-3E3F8876-F393-4124-8E23-4BC2A5800E7D"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"RoleCollectionRemove.html#GUID-0C625DEE-7122-433E-BFEF-21E1C6568E0F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRoleCollection Properties",
                                    "href":"OracleRoleCollectionProperties.html#GUID-A7DCA235-82FB-44EF-95A8-356DD58022E0",
                                    "topics":[
                                        {
                                            "title":"Count",
                                            "href":"RoleCollectionCount.html#GUID-CF917EE6-1B04-4CEF-AD71-0DCBFE7A80E7"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"RoleCollectionItem.html#GUID-AE4DCD0C-C094-43B9-B42D-E2854F5BC2BD"
                                        },
                                        {
                                            "title":"UseAllExcept",
                                            "href":"RoleCollectionUseAllExcept.html#GUID-C381EF9C-2DF4-4BC8-96EE-9580E63F7F25"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleRowUpdatedEventArgs Class",
                            "href":"OracleRowUpdatedEventArgsClass.html#GUID-314001DE-F1B5-4202-89D4-0BD4304AC79D",
                            "topics":[
                                {
                                    "title":"OracleRowUpdatedEventArgs Members",
                                    "href":"RowUpdatedEventArgsMembers.html#GUID-C4104AA3-C36A-4F28-946B-2FBECF3BD1CA"
                                },
                                {
                                    "title":"OracleRowUpdatedEventArgs Constructor",
                                    "href":"RowUpdatedEventArgsCtor.html#GUID-4AD4604F-EF60-4D91-B4F2-D3203117BD2C"
                                },
                                {
                                    "title":"OracleRowUpdatedEventArgs Static Methods",
                                    "href":"RowUpdatedEventArgsStaticMethods.html#GUID-977D275B-66B5-439D-BC8F-94CC0ECF9547"
                                },
                                {
                                    "title":"OracleRowUpdatedEventArgs Properties",
                                    "href":"RowUpdatedEventArgsProperties.html#GUID-ACB896C3-3045-4601-8113-670DD0B3348B",
                                    "topics":[
                                        {
                                            "title":"Command",
                                            "href":"RowUpdatedEventArgsCommand.html#GUID-EB86CBAD-EEAE-46A1-A03C-3B14E5964217"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRowUpdatedEventArgs Public Methods",
                                    "href":"RowUpdatedEventArgsPublicMethods.html#GUID-9F74B931-016A-41C8-906C-3B2FE2286F53"
                                }
                            ]
                        },
                        {
                            "title":"OracleRowUpdatedEventHandler Delegate",
                            "href":"OracleRowUpdatedEventHandlerDelegate.html#GUID-4D477AA1-A7C6-4BFC-B597-8DB581CF8984"
                        },
                        {
                            "title":"OracleRowUpdatingEventArgs Class",
                            "href":"OracleRowUpdatingEventArgsClass.html#GUID-C4A189D9-2F64-49CC-89A8-2925E6D06F12",
                            "topics":[
                                {
                                    "title":"OracleRowUpdatingEventArgs Members",
                                    "href":"OracleRowUpdatingEventArgsmembers.html#GUID-6A57D974-692F-405C-BA68-610B728CA7AD"
                                },
                                {
                                    "title":"OracleRowUpdatingEventArgs Constructor",
                                    "href":"RowUpdatingEventArgsCtor.html#GUID-6AE19972-DEE5-4C20-821C-2D684FF178B7"
                                },
                                {
                                    "title":"OracleRowUpdatingEventArgs Static Methods",
                                    "href":"RowUpdatingEventArgsStaticMethods.html#GUID-ACAA0528-FEEE-4571-84C6-644D5D72B982"
                                },
                                {
                                    "title":"OracleRowUpdatingEventArgs Properties",
                                    "href":"RowUpdatingEventArgsProperties.html#GUID-86589688-6795-4F68-8FA7-5266C9822996",
                                    "topics":[
                                        {
                                            "title":"Command",
                                            "href":"RowUpdatingEventArgsCommand.html#GUID-C6A773E3-E5D8-464E-9849-9D07C1BAC00F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRowUpdatingEventArgs Public Methods",
                                    "href":"RowUpdatingEventArgsPublicMethods.html#GUID-8895FA99-387D-4029-9BCA-8C511590A85D"
                                }
                            ]
                        },
                        {
                            "title":"OracleRowUpdatingEventHandler Delegate",
                            "href":"OracleRowUpdatingEventHandlerDelegate.html#GUID-B4870EB0-EF6A-45F5-8F56-EF410F394D97"
                        },
                        {
                            "title":"OracleSessionlessTransactionOptions Class",
                            "href":"OracleSessionlessTransactionOptionsClass.html#GUID-77638356-DC7A-447B-9B72-AB7397370929",
                            "topics":[
                                {
                                    "title":"OracleSessionlessTransactionOptions Members",
                                    "href":"OracleSessionlessTransactionOptionsMembers.html#GUID-CFCCC949-5791-404F-8A40-DBFC6BCF7975"
                                },
                                {
                                    "title":"OracleSessionlessTransactionOptions Constructors",
                                    "href":"OracleSessionlessTransactionOptionsConstructors.html#GUID-C06A7531-6114-4041-8362-C6D062A46821",
                                    "topics":[
                                        {
                                            "title":"OracleSessionlessTransactionOptions()",
                                            "href":"SessionlessTransactionOptionsctor1.html#GUID-B4D7CB28-DD94-4C7E-9D10-6B8B47D1ADEF"
                                        },
                                        {
                                            "title":"OracleSessionlessTransactionOptions(int, OracleSessionlessTransactionStartBehavior, OracleSessionlessTransactionStartBehavior, bool)",
                                            "href":"SessionlessTransactionOptionsctor2.html#GUID-EF46748D-EB51-4FB6-99CB-D30E8BD739CB"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleSessionlessTransactionOptions Properties",
                                    "href":"OracleSessionlessTransactionOptionsProperties.html#GUID-D0332973-0D3A-4F4D-BA64-94CF251D45CB",
                                    "topics":[
                                        {
                                            "title":"ResumeBehavior",
                                            "href":"SessionlessTransactionOptionsResumeBehavior.html#GUID-880B525B-C23D-490D-9566-57F900277107"
                                        },
                                        {
                                            "title":"StartBehavior",
                                            "href":"SessionlessTransactionOptionsStartBehavior.html#GUID-B10BB6E5-7DBC-42A7-8DE4-D029B14A487F"
                                        },
                                        {
                                            "title":"SuspendAfterExecution",
                                            "href":"SessionlessTransactionOptionsSuspendAfterExecution.html#GUID-B3A65BF3-91A7-4EC4-A68A-25FE92E1EBAC"
                                        },
                                        {
                                            "title":"Timeout",
                                            "href":"SessionlessTransactionOptionsTimeout.html#GUID-DA7113D0-4668-4739-AF39-A7728B6169A9"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleShardingKey Class",
                            "href":"OracleShardingKeyClass.html#GUID-5B4A88CD-58DD-4475-822F-91A4B11FDD75",
                            "topics":[
                                {
                                    "title":"OracleShardingKey Members",
                                    "href":"OracleShardingKeyMembers.html#GUID-7F208814-42E7-4975-BCBE-63214277F6B6"
                                },
                                {
                                    "title":"OracleShardingKey Constructors",
                                    "href":"OracleShardingKeyCtors.html#GUID-C3F486F7-1F80-4CBE-B0EF-3478C23BD883",
                                    "topics":[
                                        {
                                            "title":"OracleShardingKey()",
                                            "href":"ShardingKeyCtor1.html#GUID-5F254CEE-B5F4-4B97-8ADC-49C0CA00E607"
                                        },
                                        {
                                            "title":"OracleShardingKey(OracleDbType, object)",
                                            "href":"ShardingKeyCtor2.html#GUID-CD73C1E0-95E5-40FC-8C50-292B44F353EA"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleShardingKey Instance Methods",
                                    "href":"ShardingKeyInstanceMethods.html#GUID-C09D71BD-5DF7-4897-9C52-161FF7459AC3",
                                    "topics":[
                                        {
                                            "title":"SetShardingKey(OracleDbType, object)",
                                            "href":"ShardingKeySetShardingKey.html#GUID-08560664-C2F8-4C56-8F20-30B6660041FF"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"ShardingKeyDispose.html#GUID-B0188213-8278-4BD8-9491-3B7C94052A7B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleSparseVector Class",
                            "href":"OracleSparseVectorClass.html#GUID-15D0339A-238B-4930-9FB4-82B8E183F329",
                            "topics":[
                                {
                                    "title":"OracleSparseVector Members",
                                    "href":"OracleSparseVectorMembers.html#GUID-363B0A38-0DD7-498E-A074-795983C35570"
                                },
                                {
                                    "title":"OracleSparseVector Constructors",
                                    "href":"OracleSparseVectorConstructors.html#GUID-CE22A1B1-3BB2-49AC-901C-6CD009466ED6",
                                    "topics":[
                                        {
                                            "title":"OracleSparseVector(sparseVectorString)",
                                            "href":"SparseVectorCtor1.html#GUID-891BA68D-D671-4E4D-8594-0B09BBF0BE7C"
                                        },
                                        {
                                            "title":"OracleSparseVector(sparseVectorString, providerType)",
                                            "href":"SparseVectorCtor2.html#GUID-F71AF747-BC17-4BFF-8B0D-C1277ED664BF"
                                        },
                                        {
                                            "title":"OracleSparseVector(dimensions, indices)",
                                            "href":"SparseVectorCtor6.html#GUID-BAF8352C-AF0F-49FA-891F-903945A92D9A"
                                        },
                                        {
                                            "title":"OracleSparseVector(dimensions, indices, sparseValue)",
                                            "href":"SparseVectorCtor3.html#GUID-B8668B61-85B9-472D-92BE-456F9350BF0F"
                                        },
                                        {
                                            "title":"OracleSparseVector(dimensions, indices, sparseValue)",
                                            "href":"SparseVectorCtor4.html#GUID-1835A054-0B89-408F-8D25-26AA6728CB0D"
                                        },
                                        {
                                            "title":"OracleSparseVector(dimensions, indices, sparseValue)",
                                            "href":"SparseVectorCtor5.html#GUID-A7EE5177-D0C5-4D6A-BCDE-E890E67A4556"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleSparseVector Properties",
                                    "href":"OracleSparseVectorProperties.html#GUID-4A9565F5-B371-4DCF-8E64-015C496EDE75",
                                    "topics":[
                                        {
                                            "title":"Dimensions",
                                            "href":"SparseVectorDimensions.html#GUID-DE37E576-F1EA-45F4-BCA2-5DD2D4B63A60"
                                        },
                                        {
                                            "title":"VectorType",
                                            "href":"SparseVectorVectorType.html#GUID-4C09B37C-524C-4B58-8327-0E39A4478131"
                                        },
                                        {
                                            "title":"ProviderType",
                                            "href":"SparseVectorProviderType.html#GUID-2124B555-F93D-4B7E-9074-BA45474038AC"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"SparseVectorValue.html#GUID-E2024D92-1438-403F-A869-77F301CB06F2"
                                        },
                                        {
                                            "title":"Indices",
                                            "href":"SparseVectorIndices.html#GUID-04379BC5-42A7-4C25-AAE8-9EE04B06E249"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"SparseVectorItem.html#GUID-CBD6E67B-953D-4A5F-AB46-5C2295B3636F"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"SparseVectorIsNull.html#GUID-E66BB0ED-83F2-47EE-A44E-639DDCD1998C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleSparseVector Instance Methods",
                                    "href":"OracleSparseVectorInstanceMethods.html#GUID-7C69EE35-42B9-4E23-9032-5A8B278F8768",
                                    "topics":[
                                        {
                                            "title":"ToInt16Array()",
                                            "href":"SparseVectorToInt16Array.html#GUID-8421715B-A73C-4977-B564-2EFDDF61EC10"
                                        },
                                        {
                                            "title":"ToFloatArray()",
                                            "href":"SparseVectorToFloatArray.html#GUID-B57C364D-271C-4101-95B9-00A29B61A0CA"
                                        },
                                        {
                                            "title":"ToDoubleArray()",
                                            "href":"SparseVectorToDoubleArray.html#GUID-2A5C5DFD-BF10-4A14-BD9F-9D41484B7D0F"
                                        },
                                        {
                                            "title":"ToNonZeroInt16Array()",
                                            "href":"SparseVectorToNonZeroInt16Array.html#GUID-ADC4ED9A-E7E5-48E6-B49A-B541059CA5CA"
                                        },
                                        {
                                            "title":"ToNonZeroFloatArray()",
                                            "href":"SparseVectorToNonZeroFloatArray.html#GUID-53087A48-354B-4FCC-B944-308F12BD202B"
                                        },
                                        {
                                            "title":"ToNonZeroDoubleArray()",
                                            "href":"SparseVectorToNonZeroDoubleArray.html#GUID-91026300-2E0F-467C-9AD5-21AE382D05BD"
                                        },
                                        {
                                            "title":"ToString()",
                                            "href":"SparseVectorToString.html#GUID-072552CC-A109-482B-83FA-23B333FB8B5B"
                                        },
                                        {
                                            "title":"Dispose()",
                                            "href":"SparseVectorDispose.html#GUID-57C14D21-3F7A-475A-8D40-31257AB56C89"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleTransaction Class",
                            "href":"OracleTransactionClass.html#GUID-841D0FAA-5E18-4753-AE85-23236E4DD38C",
                            "topics":[
                                {
                                    "title":"OracleTransaction Members",
                                    "href":"TransactionMembers.html#GUID-092B91E4-BCBE-4C1C-8AD2-5EE894B1C47F"
                                },
                                {
                                    "title":"OracleTransaction Static Methods",
                                    "href":"TransactionStaticMethods.html#GUID-5063BC34-6D57-455D-9241-8AE9E503AC72"
                                },
                                {
                                    "title":"OracleTransaction Properties",
                                    "href":"TransactionProperties.html#GUID-DD56C915-33CC-4A56-9ECE-F8572D0D318B",
                                    "topics":[
                                        {
                                            "title":"IsolationLevel",
                                            "href":"TransactionIsolationlevel.html#GUID-ADE56C10-9966-42E3-82F6-406DB0390280"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"TransactionConnection.html#GUID-003BE303-CF2B-4D39-9458-D9B3690FD171"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTransaction Public Methods",
                                    "href":"TransactionPublicMethods.html#GUID-95C84DC3-C084-4760-B211-14CC54C82C99",
                                    "topics":[
                                        {
                                            "title":"Commit",
                                            "href":"TransactionCommit.html#GUID-31B0EBFA-F252-481C-BFE9-BC3363DB94F8"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"TransactionDispose.html#GUID-6A14E889-D711-482B-8F81-8DC957204ECD"
                                        },
                                        {
                                            "title":"Rollback",
                                            "href":"TransactionRollbackOverloads.html#GUID-A6785FC6-520F-43DF-BC60-0143AE189261"
                                        },
                                        {
                                            "title":"Rollback()",
                                            "href":"TransactionRollback1.html#GUID-576171B8-AF72-47CE-975B-E7A4CF919F49"
                                        },
                                        {
                                            "title":"Rollback(string)",
                                            "href":"TransactionRollback2.html#GUID-8380A444-A643-4B67-9AD7-E1CB81D27CEC"
                                        },
                                        {
                                            "title":"Save",
                                            "href":"TransactionSave.html#GUID-85B498C1-87F9-4A69-BD8E-2DE468400E3B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleVector Class",
                            "href":"OracleVectorClass.html#GUID-82439133-4CB3-4701-8A58-AD965B5EE8F1",
                            "topics":[
                                {
                                    "title":"OracleVector Members",
                                    "href":"OracleVectorMembers.html#GUID-AFADCB1C-2F5F-430D-971E-E7D501D8626B"
                                },
                                {
                                    "title":"OracleVector Constructors",
                                    "href":"OracleVectorConstructors.html#GUID-41222549-123E-4FD4-972A-060808B08F3D",
                                    "topics":[
                                        {
                                            "title":"OracleVector(vectorString)",
                                            "href":"VectorCtor1.html#GUID-13632760-BAFA-4AE5-8C42-7C81EB26A66E"
                                        },
                                        {
                                            "title":"OracleVector(vectorString, providerType)",
                                            "href":"VectorCtor2.html#GUID-C017AD84-74F4-43CE-AB95-2773CBC21500"
                                        },
                                        {
                                            "title":"OracleVector(vectorValues)",
                                            "href":"VectorCtor3.html#GUID-C7A14C7C-9094-46CF-B02C-822F0375F9D3"
                                        },
                                        {
                                            "title":"OracleVector(vectorValues)",
                                            "href":"VectorCtor4.html#GUID-3434D020-B8A5-43A4-9CA7-1C3EE7710ED7"
                                        },
                                        {
                                            "title":"OracleVector(vectorValues)",
                                            "href":"VectorCtor5.html#GUID-4883D3F0-C9DE-44C4-9DA2-0B31B1DAF7DF"
                                        },
                                        {
                                            "title":"OracleVector(vectorValues)",
                                            "href":"VectorCtor6.html#GUID-9D2E5E32-29F2-4E95-A6B0-35FC09F21687"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleVector Properties",
                                    "href":"OracleVectorProperties.html#GUID-BA69CDBE-4334-40A4-87E2-8D321835E8E4",
                                    "topics":[
                                        {
                                            "title":"Dimensions",
                                            "href":"VectorDimensions.html#GUID-A1B18133-67DF-4882-BB99-AB6ABD067803"
                                        },
                                        {
                                            "title":"VectorType",
                                            "href":"VectorVectorType.html#GUID-FCFEF63D-4233-4221-BACB-53E97588C938"
                                        },
                                        {
                                            "title":"ProviderType",
                                            "href":"VectorProviderType.html#GUID-9F57C0BE-C644-43C3-854B-DD30EF77753F"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"VectorValue.html#GUID-A13B3E8A-4804-4F8F-B552-361123873599"
                                        },
                                        {
                                            "title":"Item[long]",
                                            "href":"VectorItem.html#GUID-62026650-8739-4FFE-ABCC-DC298E1EAF9A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleVector Instance Methods",
                                    "href":"OracleVectorInstanceMethods.html#GUID-2445AA5C-145A-4E6C-B736-EE6592122084",
                                    "topics":[
                                        {
                                            "title":"ToInt16Array()",
                                            "href":"VectorToInt16Array.html#GUID-D8E502BB-A6C3-4DAF-86EA-4F8A3796BF50"
                                        },
                                        {
                                            "title":"ToFloatArray()",
                                            "href":"VectorToFloatArray.html#GUID-4D3D088A-8B3C-4E56-85D1-BAB3DC014503"
                                        },
                                        {
                                            "title":"ToDoubleArray()",
                                            "href":"VectorToDoubleArray.html#GUID-85316B06-C3C3-4AF0-B0E1-229BAA048619"
                                        },
                                        {
                                            "title":"ToByteArray()",
                                            "href":"VectorToByteArray.html#GUID-207FDB8F-3C08-4ED9-96F9-39E758117238"
                                        },
                                        {
                                            "title":"ToString()",
                                            "href":"VectorToString.html#GUID-F37BD565-7F32-4BD0-8367-8C1A7F80B86E"
                                        },
                                        {
                                            "title":"Dispose()",
                                            "href":"VectorDispose.html#GUID-510A430C-3EE9-4D9A-B687-8C0272F8E99E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAllowedLogonVersionClient Enumeration",
                            "href":"OracleAllowedLogonVersionClientEnumeration.html#GUID-556860B6-E38A-41AD-8E5D-4944C683A059"
                        },
                        {
                            "title":"OracleCollectionType Enumeration",
                            "href":"OracleCollectionTypeEnumeration.html#GUID-1F3026CD-7C66-4470-9AF4-54E3E8F7FF7C"
                        },
                        {
                            "title":"OracleConnectionOpenReason Enumeration",
                            "href":"OracleConnectionOpenReasonEnumeration.html#GUID-E63D6E69-470E-40FA-8AE4-A721CD2A94A1"
                        },
                        {
                            "title":"OracleConnectionType Enumeration",
                            "href":"OracleConnectionTypeEnumeration.html#GUID-B66D0A0B-5C8E-4477-AE07-F567A662E7C4"
                        },
                        {
                            "title":"OracleDBAPrivilege Enumeration",
                            "href":"OracleDBAPrivilegeEnumeration.html#GUID-05E40C75-E084-48E0-AFB0-6D4B06109980"
                        },
                        {
                            "title":"OracleDBShutdownMode Enumeration",
                            "href":"OracleDBShutdownModeEnumeration.html#GUID-1E6E468C-0D51-4019-A25B-5B53B6B07440"
                        },
                        {
                            "title":"OracleDBStartupMode Enumeration",
                            "href":"OracleDBStartupModeEnumeration.html#GUID-746F29AE-A2E6-45F3-A684-EB54C4AC01D6"
                        },
                        {
                            "title":"OracleDbType Enumeration",
                            "href":"OracleDbTypeEnumerationType.html#GUID-E5D6E666-49EA-4A8D-822A-A190101C33D7"
                        },
                        {
                            "title":"OracleDRCPPurity Enumeration",
                            "href":"OracleDRCPPurityEnumeration.html#GUID-C03F3B9E-583D-418E-BC17-F70D26EA1F72"
                        },
                        {
                            "title":"OracleIdentityType Enumeration",
                            "href":"OracleIdentityTypeEnumeration.html#GUID-79FC0AE6-FBD7-4572-A413-701500FDE83E"
                        },
                        {
                            "title":"OracleParameterStatus Enumeration",
                            "href":"OracleParameterStatusEnumeration.html#GUID-D782E182-A426-439F-A49F-9EA3F6248C68"
                        },
                        {
                            "title":"OraclePasswordAuth Enumeration",
                            "href":"OraclePasswordAuthEnumeration.html#GUID-097FB943-38C1-417F-9014-86B54E7B43A3"
                        },
                        {
                            "title":"OracleSessionlessTransactionStartBehavior Enumeration",
                            "href":"OracleSessionlessTransactionStartBehaviorEnumeration.html#GUID-5CD00F7A-8629-477B-B357-3C9B925755EB"
                        },
                        {
                            "title":"OracleTokenAuth Enumeration",
                            "href":"OracleTokenAuthEnumeration.html#GUID-8F9FB724-390C-4703-BD23-F94CC2D95980"
                        },
                        {
                            "title":"OracleVectorType Enumeration",
                            "href":"OracleVectorTypeEnumeration.html#GUID-51964FF2-843D-4064-B1E2-9A06C083B159"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Oracle Data Provider for .NET XML-Related Classes",
                    "href":"odp-dot-net-xml-classes.html#GUID-C381B604-E918-4FE4-99DB-B4B4848A352F",
                    "topics":[
                        {
                            "title":"OracleXmlCommandType Enumeration",
                            "href":"OracleXmlCommandTypeEnumeration.html#GUID-A725317C-1F80-49E2-8F94-655D9FC47FEB"
                        },
                        {
                            "title":"OracleXmlQueryProperties Class",
                            "href":"OracleXmlQueryPropertiesClass.html#GUID-4DDE0B33-11F3-4D6B-99AD-3D075B98CA2F",
                            "topics":[
                                {
                                    "title":"OracleXmlQueryProperties Members",
                                    "href":"XmlQueryPropertiesMembers.html#GUID-CB49444F-0E7F-44F2-8711-E156E0C23B03"
                                },
                                {
                                    "title":"OracleXmlQueryProperties Constructor",
                                    "href":"XmlQueryPropertiesCtors.html#GUID-F50D23E5-E735-4F41-9987-449A59DE837D"
                                },
                                {
                                    "title":"OracleXmlQueryProperties Properties",
                                    "href":"XmlQueryPropertiesProperties.html#GUID-7506580C-7DB2-484A-8054-0B9C09735895",
                                    "topics":[
                                        {
                                            "title":"MaxRows",
                                            "href":"XmlQueryPropertiesMaxRows.html#GUID-F0ED5368-DA86-4961-B411-A640D4932B84"
                                        },
                                        {
                                            "title":"RootTag",
                                            "href":"XmlQueryPropertiesRootTag.html#GUID-263310DC-70E8-428D-8E2E-5FC22547A81E"
                                        },
                                        {
                                            "title":"RowTag",
                                            "href":"XmlQueryPropertiesRowTag.html#GUID-97EF89F3-D228-453E-89B5-0C10106EF4E5"
                                        },
                                        {
                                            "title":"Xslt",
                                            "href":"XmlQueryPropertiesXslt.html#GUID-A6306946-C2BE-4C75-9B9E-0B3200FB91A8"
                                        },
                                        {
                                            "title":"XsltParams",
                                            "href":"XmlQueryPropertiesXsltParams.html#GUID-05BFC9CA-807D-479D-9B0A-465A454C42CE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlQueryProperties Public Methods",
                                    "href":"XmlQueryPropertiesPublicMethods.html#GUID-D39FB55D-F128-41FD-889D-DDC5F5CDEE24",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"XmlQueryPropertiesClone.html#GUID-877FB8B2-711A-4F59-AE5B-116453D6C875"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleXmlSaveProperties Class",
                            "href":"OracleXmlSavePropertiesClass.html#GUID-553601AB-66E4-4E31-838E-2F4B9732286A",
                            "topics":[
                                {
                                    "title":"OracleXmlSaveProperties Members",
                                    "href":"XmlSavePropertiesMembers.html#GUID-1942DE49-CD6A-450F-8770-4AC837860376"
                                },
                                {
                                    "title":"OracleXmlSaveProperties Constructor",
                                    "href":"XmlSavePropertiesCtors.html#GUID-2465D7DD-6266-4F98-9243-6CA31F2CE81B"
                                },
                                {
                                    "title":"OracleXmlSaveProperties Properties",
                                    "href":"XmlSavePropertiesProperties.html#GUID-370C6719-05B9-4C7B-9F9F-CDDE9A98C3A2",
                                    "topics":[
                                        {
                                            "title":"KeyColumnsList",
                                            "href":"XmlSavePropertiesKeyColumnsList.html#GUID-FC5B38C8-883F-4F6B-8A8F-73BEECBCA2FC"
                                        },
                                        {
                                            "title":"RowTag",
                                            "href":"XmlSavePropertiesRowTag.html#GUID-48A07E87-B9AA-457F-86F2-F1646EF802F2"
                                        },
                                        {
                                            "title":"Table",
                                            "href":"XmlSavePropertiesTable.html#GUID-6866B47A-B2D2-48CD-8C8E-F8C70BA09E0F"
                                        },
                                        {
                                            "title":"UpdateColumnsList",
                                            "href":"XmlSavePropertiesUpdateColumnsList.html#GUID-47A86AC9-8676-42F0-9BAC-B5294A152061"
                                        },
                                        {
                                            "title":"Xslt",
                                            "href":"XmlSavePropertiesXslt.html#GUID-A1ABA65C-5395-4AA5-B001-1A35BD15A9D2"
                                        },
                                        {
                                            "title":"XsltParams",
                                            "href":"XmlSavePropertiesXsltParams.html#GUID-8C170C5F-ECC5-4606-A732-5CBF0D4F5E86"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlSaveProperties Public Methods",
                                    "href":"XmlSavePropertiesPublicMethods.html#GUID-F84C62E0-5848-4576-AF28-6E01EA9A9826",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"XmlSavePropertiesClone.html#GUID-B104CEE6-8DEC-4B3B-A2F8-94D00411E8CA"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleXmlStream Class",
                            "href":"OracleXmlStreamClass.html#GUID-D4788FE5-5F50-4185-BC8B-B9F9141D744A",
                            "topics":[
                                {
                                    "title":"OracleXmlStream Members",
                                    "href":"XmlStreamMembers.html#GUID-D4C3E141-C06E-4D35-8360-6C026DC4D6F4"
                                },
                                {
                                    "title":"OracleXmlStream Constructor",
                                    "href":"XmlStreamCtors.html#GUID-63F0F57D-9E39-4AB5-867F-0641CE1AF5ED"
                                },
                                {
                                    "title":"OracleXmlStream Static Methods",
                                    "href":"XmlStreamStaticMethods.html#GUID-0F3C29BC-3D71-444E-867D-22FCCD243CCB"
                                },
                                {
                                    "title":"OracleXmlStream Instance Properties",
                                    "href":"XmlStreamProperties.html#GUID-D61E1CD7-B840-436B-A7A1-E8DD45DDC750",
                                    "topics":[
                                        {
                                            "title":"CanRead",
                                            "href":"XmlStreamCanRead.html#GUID-515A8CE1-3436-4423-8E47-64A823A68178"
                                        },
                                        {
                                            "title":"CanSeek",
                                            "href":"XmlStreamCanSeek.html#GUID-D989847C-751E-4DE0-B639-5417FF23AC23"
                                        },
                                        {
                                            "title":"CanWrite",
                                            "href":"XmlStreamCanWrite.html#GUID-860A26D4-A20E-4CCB-8EC6-AB78AC659396"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"XmlStreamConnection.html#GUID-568A82D8-243F-48AE-9944-68987DB53ABE"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"XmlStreamLength.html#GUID-E8B0FD71-F2FD-49AD-9317-63EF33363169"
                                        },
                                        {
                                            "title":"Position",
                                            "href":"XmlStreamPosition.html#GUID-CB6FB2B3-4FD0-4350-995C-F5420583AAEB"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"XmlStreamValue.html#GUID-7931D80F-970D-4045-B3A7-6AB6BB68394A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlStream Instance Methods",
                                    "href":"XmlStreamPublicMethods.html#GUID-2A5296E4-335F-4EB3-9BDD-A0BFE3069A33",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"XmlStreamClone.html#GUID-9BF69CEE-588C-4B00-AFF2-9AA59B4302F5"
                                        },
                                        {
                                            "title":"Close",
                                            "href":"XmlStream.html#GUID-B553056B-2545-4782-8E42-C69C6FAF6E70"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"XmlStreamDispose.html#GUID-00006036-074D-47F2-AE6C-7084E11BCADE"
                                        },
                                        {
                                            "title":"Flush",
                                            "href":"XmlStreamFlush.html#GUID-5BD1B83B-304F-4D92-BDB5-25D79F2A44AC"
                                        },
                                        {
                                            "title":"Read",
                                            "href":"XmlStreamReadOverloads.html#GUID-FC62BB3E-D2CA-4806-874C-2ACB98322911"
                                        },
                                        {
                                            "title":"Read(byte[ ], int, int)",
                                            "href":"XmlStreamRead1.html#GUID-090124D9-CAF8-4811-9A7F-C86F4D8A2649"
                                        },
                                        {
                                            "title":"Read(char[ ], int, int)",
                                            "href":"XmlStreamRead2.html#GUID-88EB0051-CA2A-4EF5-ABCB-3EA591198B4A"
                                        },
                                        {
                                            "title":"ReadAsync",
                                            "href":"XmlStreamReadAsyncOverloaded.html#GUID-7E1A4380-ECFE-49D0-9EEB-C91EC1EDC80D"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int, CancellationToken)",
                                            "href":"XmlStreamReadAsync1.html#GUID-DDA5D52C-4040-40EF-B348-970476F88D79"
                                        },
                                        {
                                            "title":"ReadAsync(char[], int, int)",
                                            "href":"XmlStreamReadAsync2.html#GUID-A2743005-86B5-4159-BD4E-4072D08C2528"
                                        },
                                        {
                                            "title":"ReadAsync(char[], int, int, CancellationToken)",
                                            "href":"XmlStreamReadAsync3.html#GUID-47905DD1-C885-40FF-B578-87C3ACFBFC99"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int)",
                                            "href":"XmlStreamReadAsync4.html#GUID-142076B8-DA9D-4E6E-A278-06AB950E6933"
                                        },
                                        {
                                            "title":"Seek",
                                            "href":"XmlStreamSeek.html#GUID-9DCDD4A8-D09B-4D97-A8BF-A63C39C479A4"
                                        },
                                        {
                                            "title":"SetLength",
                                            "href":"XmlStreamSetLength.html#GUID-F8FCC48A-EA7C-4741-A752-FFBA436561A7"
                                        },
                                        {
                                            "title":"Write",
                                            "href":"XmlStreamWrite.html#GUID-9E34A8FB-FF52-45B7-87AA-40612A04AEB7"
                                        },
                                        {
                                            "title":"WriteLine",
                                            "href":"XmlStreamWriteLine.html#GUID-5C242323-8249-4301-B006-B49FAEE20CC9"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleXmlType Class",
                            "href":"OracleXmlTypeClass.html#GUID-DA2D8110-CCB4-4482-A525-31729A0B4F06",
                            "topics":[
                                {
                                    "title":"OracleXmlType Members",
                                    "href":"XmlTypeMembers.html#GUID-65C02B10-1816-4B3E-91AF-03ED5A042EA7"
                                },
                                {
                                    "title":"OracleXmlType Constructors",
                                    "href":"XmlTypeCtors.html#GUID-51C6EB9B-2934-45E4-A2FE-6986F27E3706",
                                    "topics":[
                                        {
                                            "title":"OracleXmlType(OracleClob)",
                                            "href":"XmlTypeCtorN1.html#GUID-1AB52FC4-961E-46C7-B78A-2A0017206346"
                                        },
                                        {
                                            "title":"OracleXmlType(OracleConnection, string)",
                                            "href":"XmlTypeCtorN2.html#GUID-046C5F29-9B75-429E-A8C5-6814313ED3D8"
                                        },
                                        {
                                            "title":"OracleXmlType(OracleConnection, XmlReader)",
                                            "href":"XmlTypeCtorN3.html#GUID-D51CE8BC-2E95-4D2C-A301-FA1E66933EB7"
                                        },
                                        {
                                            "title":"OracleXmlType(OracleConnection, XmlDocument)",
                                            "href":"XmlTypeCtorN4.html#GUID-64918F55-21B3-45B7-A100-795B47097440"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlType Static Methods",
                                    "href":"XmlTypeStaticMethods.html#GUID-3E226D8C-9101-48B5-95D1-3659A61DF026"
                                },
                                {
                                    "title":"OracleXmlType Static Fields",
                                    "href":"XmlTypeStaticFields.html#GUID-7D3509B3-5EB1-481D-9CFA-108F00B6451E",
                                    "topics":[
                                        {
                                            "title":"Null",
                                            "href":"XmlTypeStaticFieldNull.html#GUID-C2A15752-F031-49EB-A04D-64646009E7AA"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlType Instance Properties",
                                    "href":"XmlTypeProperties.html#GUID-14C0834A-48FF-44A3-A361-542004FCCB11",
                                    "topics":[
                                        {
                                            "title":"Connection",
                                            "href":"XmlTypeConnection.html#GUID-DAF3E986-FCF0-4C0F-B71B-E2D39BEAF468"
                                        },
                                        {
                                            "title":"IsEmpty",
                                            "href":"XmlTypeIsEmpty.html#GUID-2A284551-45E4-4F87-B322-D7C7A34F0F09"
                                        },
                                        {
                                            "title":"IsFragment",
                                            "href":"XmlTypeIsFragment.html#GUID-402056B3-6B44-4A01-AD0E-40F59B81034A"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"XmlTypeIsNull.html#GUID-8EB9F184-51F7-4259-A8D5-B5AB69E85A87"
                                        },
                                        {
                                            "title":"IsSchemaBased",
                                            "href":"XmlTypeIsSchemaBased.html#GUID-907447CE-1756-412A-B1E5-8DC9ED25E96A"
                                        },
                                        {
                                            "title":"RootElement",
                                            "href":"XmlTypeRootElement.html#GUID-F0A1B5A7-B64F-4394-A8D6-C4398B660A8D"
                                        },
                                        {
                                            "title":"Schema",
                                            "href":"XmlTypeSchema.html#GUID-F3269CC9-37EA-4E33-B2F2-39140A8E2FBF"
                                        },
                                        {
                                            "title":"SchemaUrl",
                                            "href":"XmlTypeSchemaUrl.html#GUID-C34DD4A8-D8B9-420A-9057-63FC4745A724"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"XmlTypeValue.html#GUID-29573EBF-BB8E-4A44-B7E6-AEB6EB22C4FD"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleXmlType Instance Methods",
                                    "href":"XmlTypePublicMethods.html#GUID-FC6FDF25-3225-403E-9858-CDF5190035C3",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"XmlTypeClone.html#GUID-05FC8308-3979-4A95-9311-C20B568D02C9"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"XmlTypeDispose.html#GUID-E0B3D50D-0AF1-416B-990A-D9A8FFE1A559"
                                        },
                                        {
                                            "title":"Extract",
                                            "href":"XmlTypeExtractOverloads.html#GUID-B3D4E2AF-C945-4607-A1CE-246A002F44B4"
                                        },
                                        {
                                            "title":"Extract(string, string)",
                                            "href":"XmlTypeExtract1.html#GUID-414E9E5A-9AE6-4FC2-8186-BD8AFD686534"
                                        },
                                        {
                                            "title":"Extract(string, XmlNameSpaceManager)",
                                            "href":"XmlTypeExtract2.html#GUID-DB5C9CFE-C695-4759-9D00-EEE95CCDE2B6"
                                        },
                                        {
                                            "title":"GetStream",
                                            "href":"XmlTypeGetStream.html#GUID-86CDD671-2C6F-44AE-9B4B-D3DF70017E4C"
                                        },
                                        {
                                            "title":"GetXmlDocument",
                                            "href":"XmlTypeGetXmlDocument.html#GUID-39D0C194-4F23-42D8-83D3-4E3B821B8FB4"
                                        },
                                        {
                                            "title":"GetXmlReader",
                                            "href":"XmlTypeGetXmlReader.html#GUID-CF3E5AF4-5CB1-4D3E-9712-3C63CE137ECA"
                                        },
                                        {
                                            "title":"IsExists",
                                            "href":"XmlTypeIsExistsOverloads.html#GUID-A8FAD863-CBD4-46FF-A565-8B359233D989"
                                        },
                                        {
                                            "title":"IsExists(string, string)",
                                            "href":"XmlTypeIsExists1.html#GUID-1274809F-4250-4F44-B17E-966CC29810F1"
                                        },
                                        {
                                            "title":"IsExists(string, XmlNameSpaceManager)",
                                            "href":"XmlTypeIsExists2.html#GUID-63443FDE-0762-4CFD-8F9A-F7687C5A9662"
                                        },
                                        {
                                            "title":"Transform",
                                            "href":"XmlTypeTransformOverloads.html#GUID-E6F3CAB7-10FE-4639-B327-40F29DDBA1CA"
                                        },
                                        {
                                            "title":"Transform(OracleXmlType, string)",
                                            "href":"XmlTypeTransform1.html#GUID-4CD2DCF5-B22D-429A-87CE-23876641CA1D"
                                        },
                                        {
                                            "title":"Transform(string, string)",
                                            "href":"XmlTypeTransform2.html#GUID-8A44A09A-5575-4CD8-87BB-20CF1D9C248F"
                                        },
                                        {
                                            "title":"Update",
                                            "href":"XmlTypeUpdateOverloads.html#GUID-58B3B34C-E02E-4EEC-9119-FE57D712CE31"
                                        },
                                        {
                                            "title":"Update(string, string, string)",
                                            "href":"XmlTypeUpdate1.html#GUID-F047E4DA-6015-41D2-BDFB-6DBD0E99DB6B"
                                        },
                                        {
                                            "title":"Update(string, XmlNameSpaceManager, string)",
                                            "href":"XmlTypeUpdate2.html#GUID-82FBED69-EA6C-4050-B553-3C2F44AD8982"
                                        },
                                        {
                                            "title":"Update(string, string, OracleXmlType)",
                                            "href":"XmlTypeUpdate3.html#GUID-3B0AA45E-34B6-4672-B3FC-B0929F8B6FD2"
                                        },
                                        {
                                            "title":"Update(string, XmlNameSpaceManager, OracleXmlType)",
                                            "href":"XmlTypeUpdate4.html#GUID-37330349-9B4D-4C87-976C-325FFFDE173B"
                                        },
                                        {
                                            "title":"Validate",
                                            "href":"XmlTypeValidate.html#GUID-E5F02DEA-DDBD-4F76-9128-F43EF732E0DA"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Oracle Data Provider for .NET HA Event Classes",
                    "href":"odp-dot-net-ha-event-classes.html#GUID-B8535D4C-5BED-4C28-B599-277720F35E6F",
                    "topics":[
                        {
                            "title":"OracleHAEventArgs Class",
                            "href":"OracleHAEventArgsClass.html#GUID-3ED2AF56-7CA1-461A-8930-97367E038A11",
                            "topics":[
                                {
                                    "title":"OracleHAEventArgs Members",
                                    "href":"HAEventArgsMembers.html#GUID-ABFCF8C0-471A-4C94-A057-E33E02C8150D"
                                },
                                {
                                    "title":"OracleHAEventArgs Properties",
                                    "href":"HAEventArgsProperties.html#GUID-15982112-2237-478F-ACC0-FBF883F09FBC",
                                    "topics":[
                                        {
                                            "title":"DatabaseDomainName",
                                            "href":"HAEventArgsDatabaseDomainName.html#GUID-1876D74E-E2DD-4611-86AE-5C9EF7348CE0"
                                        },
                                        {
                                            "title":"DatabaseName",
                                            "href":"HAEventArgsDatabaseName.html#GUID-32C34FF4-F8F1-46A6-AA43-0EE3D35E9F59"
                                        },
                                        {
                                            "title":"DrainTimeout",
                                            "href":"HAEventArgsDrainTimeout.html#GUID-F215A512-D476-4A2A-B584-4427CACEF3EE"
                                        },
                                        {
                                            "title":"HostName",
                                            "href":"HAEventArgsHostName.html#GUID-C8C6CF35-9BCA-4847-904A-A90B1B484478"
                                        },
                                        {
                                            "title":"InstanceName",
                                            "href":"HAEventArgsInstanceName.html#GUID-D508C026-83BC-4C11-A184-193FE5A3BC87"
                                        },
                                        {
                                            "title":"Reason",
                                            "href":"HAEventArgsReason.html#GUID-1282A8FA-453C-449D-9F0A-5B60D4CF9AB8"
                                        },
                                        {
                                            "title":"ServiceName",
                                            "href":"HAEventArgsServiceName.html#GUID-63695162-632D-4A2B-9BA8-79F59BF1CE00"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"HAEventArgsSource.html#GUID-D93526C0-9917-4F3A-8C58-D54AEE28903E"
                                        },
                                        {
                                            "title":"Status",
                                            "href":"HAEventArgsStatus.html#GUID-09316C83-2833-4F45-AC45-8B7B0CFC84D7"
                                        },
                                        {
                                            "title":"Time",
                                            "href":"HAEventArgsTime.html#GUID-4F0F05F0-6853-4A7B-B518-01EBFD083708"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleHAEventHandler Delegate",
                            "href":"OracleHAEventHandlerDelegate.html#GUID-7BAD3778-3968-42F2-B39D-FC17BD1935D3"
                        },
                        {
                            "title":"OracleHAEventSource Enumeration",
                            "href":"OracleHAEventSourceEnumeration.html#GUID-09CA34E3-0F40-449D-8A7B-BB32B7DC3A53"
                        },
                        {
                            "title":"OracleHAEventStatus Enumeration",
                            "href":"OracleHAEventStatusEnumeration.html#GUID-4D4F667A-3FE2-4CA9-A443-97910FD3FB9C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Continuous Query Notification Classes",
                    "href":"Continuous-Query-Notification-Classes.html#GUID-9EDECC19-F67D-4586-BB02-A2E84340BB62",
                    "topics":[
                        {
                            "title":"OracleDependency Class",
                            "href":"OracleDependencyClass.html#GUID-D28FE392-A5D9-4921-822D-9E898CFCB361",
                            "topics":[
                                {
                                    "title":"OracleDependency Members",
                                    "href":"DependencyMembers.html#GUID-2234A83D-B9C9-4644-9928-A2573FFD9DF5"
                                },
                                {
                                    "title":"OracleDependency Constructors",
                                    "href":"DependencyConstructors.html#GUID-D2F1F2E8-A315-416A-B20D-9C382DDB4641",
                                    "topics":[
                                        {
                                            "title":"OracleDependency ( )",
                                            "href":"DependencyCtor1.html#GUID-61C8FF18-E079-46F6-B4A5-540F3FA33C1A"
                                        },
                                        {
                                            "title":"OracleDependency(OracleCommand)",
                                            "href":"DependencyCtor2.html#GUID-000E4DE2-2020-4F8C-BC6A-87F4E229AC9D"
                                        },
                                        {
                                            "title":"OracleDependency(OracleCommand, bool, int, bool)",
                                            "href":"DependencyCtor3.html#GUID-7E23A5EF-1BFA-4D1C-B20B-166AE0CE701C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDependency Static Fields",
                                    "href":"DependencyStaticFields.html#GUID-7CAB6DBA-256C-44C8-B335-25F91AF12301",
                                    "topics":[
                                        {
                                            "title":"Address",
                                            "href":"DependencyStaticFieldsAddress.html#GUID-BD5E906F-CB17-44B9-BCE7-FCE7907C9CF2"
                                        },
                                        {
                                            "title":"Port",
                                            "href":"DependencyStaticFieldsPort.html#GUID-2E10D965-AF14-4E4D-99A5-66B4C201CACF"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDependency Static Methods",
                                    "href":"DependencyStaticMethods.html#GUID-2C05EA06-5A71-4B8A-8DDB-E7A4ACA9ACB0",
                                    "topics":[
                                        {
                                            "title":"GetOracleDependency",
                                            "href":"DependencyStaticMethodsGetOracleDependency.html#GUID-159C969B-6E01-4668-887D-75624DF9E158"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDependency Properties",
                                    "href":"DependencyInstanceProperties.html#GUID-6025B15E-DB96-43C5-95A2-AC6468172B93",
                                    "topics":[
                                        {
                                            "title":"DataSource",
                                            "href":"DependencyInstancePropertiesDataSource.html#GUID-F853CAFD-D560-4820-AC4A-1274C0135970"
                                        },
                                        {
                                            "title":"HasChanges",
                                            "href":"DependencyInstancePropertiesHasChanges.html#GUID-7E04B436-38E8-49E8-884A-049CE0F1442C"
                                        },
                                        {
                                            "title":"Id",
                                            "href":"DependencyInstancePropertiesId.html#GUID-333CF6CA-7294-491B-A145-F471DA5ED33D"
                                        },
                                        {
                                            "title":"IsEnabled",
                                            "href":"DependencyInstancePropertiesIsEnabled.html#GUID-E3221201-1AE0-4458-942A-5615786642E2"
                                        },
                                        {
                                            "title":"QueryBasedNotification",
                                            "href":"DependencyInstancePropertiesQueryBasedNotification.html#GUID-06FAF843-E0D5-4D7D-9A3E-99C131D12F28"
                                        },
                                        {
                                            "title":"RegisteredQueryIDs",
                                            "href":"DependencyInstancePropertiesRegisteredQueryIDs.html#GUID-5617123C-7C24-4FB3-9D75-0F989E811B0B"
                                        },
                                        {
                                            "title":"RegisteredResources",
                                            "href":"DependencyInstancePropertiesRegisteredResources.html#GUID-ABA12AA1-80DA-4D02-8576-3F9DF41C22EE"
                                        },
                                        {
                                            "title":"RowidInfo",
                                            "href":"DependencyInstancePropertiesRowidInfo.html#GUID-0E3A91E9-452A-49EA-BDD8-4C7CCDC1627E"
                                        },
                                        {
                                            "title":"UserName",
                                            "href":"DependencyInstancePropertiesUserName.html#GUID-FFC062C8-DF24-48CF-87ED-F7FF01CAEB90"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDependency Methods",
                                    "href":"DependencyInstanceMethods.html#GUID-137C2EAD-2509-4895-A5A7-FE0C4957DA9A",
                                    "topics":[
                                        {
                                            "title":"AddCommandDependency",
                                            "href":"DependencyInstanceMethodsAddCommandDependency.html#GUID-0C5BB5AE-6B85-4EBD-9E32-C829AF2195F7"
                                        },
                                        {
                                            "title":"RemoveRegistration",
                                            "href":"DependencyInstanceMethodsRemoveRegistration.html#GUID-D16343C9-DFC4-4357-9472-F0A747F58186"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDependency Events",
                                    "href":"DependencyEvents.html#GUID-436AF604-BF85-4E1C-A92C-1404DFDDF33A",
                                    "topics":[
                                        {
                                            "title":"OnChange",
                                            "href":"DependencyEventsOnChange.html#GUID-3C8A26CD-600E-41E2-B1DD-564F45E4A30E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleNotificationRequest Class",
                            "href":"OracleNotificationRequestClass.html#GUID-D1057A54-2A97-4623-A500-A8C459632150",
                            "topics":[
                                {
                                    "title":"OracleNotificationRequest Members",
                                    "href":"NotificationRequestMembers.html#GUID-67F8C0D9-52B5-4EB3-B421-94E821FF4CBE"
                                },
                                {
                                    "title":"OracleNotificationRequest Static Methods",
                                    "href":"NotificationRequestStaticMethod.html#GUID-884C11B6-1F09-40F8-94E4-4EF3A124DFC1"
                                },
                                {
                                    "title":"OracleNotificationRequest Properties",
                                    "href":"NotificationRequestInstanceProperties.html#GUID-1C92575F-87C3-4A44-821A-F04E1A90DEC8",
                                    "topics":[
                                        {
                                            "title":"IsNotifiedOnce",
                                            "href":"NotificationRequestIsNotifiedOnce.html#GUID-03A223C3-36DA-482D-8962-178D7CC7C43F"
                                        },
                                        {
                                            "title":"IsPersistent",
                                            "href":"NotificationRequestIsPersistent.html#GUID-ED117939-7DA9-4D56-B6D8-CDC5DCC12DC3"
                                        },
                                        {
                                            "title":"Timeout",
                                            "href":"NotificationRequestTimeout.html#GUID-442D5B85-F98D-4E4B-98DB-8E11F300BFA1"
                                        },
                                        {
                                            "title":"GroupingNotificationEnabled",
                                            "href":"NotificationRequestGroupingNotificationEnabled.html#GUID-372BA15D-B2B7-4483-8676-B86C89E065CD"
                                        },
                                        {
                                            "title":"GroupingType",
                                            "href":"NotificationRequestGroupingType.html#GUID-C413D2F3-5BB4-4DD9-ABDE-CAC3EEB9880C"
                                        },
                                        {
                                            "title":"GroupingInterval",
                                            "href":"NotificationRequestGroupingInterval.html#GUID-0B922ADC-9AD5-41C5-82BC-3B49BA7BB722"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleNotificationRequest Methods",
                                    "href":"NotificationRequestInstanceMethods.html#GUID-439C9AB3-09C8-44C4-9A01-48B67D78E93A"
                                }
                            ]
                        },
                        {
                            "title":"OracleNotificationEventArgs Class",
                            "href":"OracleNotificationEventArgsClass.html#GUID-25873C2A-840D-4D22-A111-E3E0D2A5F82D",
                            "topics":[
                                {
                                    "title":"OracleNotificationEventArgs Members",
                                    "href":"NotificationEventArgsMembers.html#GUID-C0EE0FFF-6F74-4EC5-A29B-DB6919F5D80B"
                                },
                                {
                                    "title":"OracleNotificationEventArgs Static Fields",
                                    "href":"NotificationEventArgsStaticFields.html#GUID-04BBDAFF-249C-426E-A60C-790D5DE4A22D"
                                },
                                {
                                    "title":"OracleNotificationEventArgs Static Methods",
                                    "href":"NotificationEventArgsStaticMethods.html#GUID-9D1C0776-090B-4702-B640-4084808EB15F"
                                },
                                {
                                    "title":"OracleNotificationEventArgs Properties",
                                    "href":"NotificationEventArgsInstanceProperties.html#GUID-48F26A51-5377-46E0-8BA8-2BA6A34E2A05",
                                    "topics":[
                                        {
                                            "title":"Details",
                                            "href":"NotificationEventArgsInstancePropertiesDetails.html#GUID-985FCF9F-35D9-4DFE-ACD6-CDE69C008EC3"
                                        },
                                        {
                                            "title":"Info",
                                            "href":"NotificationEventArgsInstancePropertiesInfo.html#GUID-3ADF0281-6578-4ACD-90B7-8D7DA215A0E2"
                                        },
                                        {
                                            "title":"ResourceNames",
                                            "href":"NotificationEventArgsInstancePropertiesResourceNames.html#GUID-52E8554A-B73E-4FD9-A683-BB02200E0533"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"NotificationEventArgsInstancePropertiesSource.html#GUID-FFB54577-42DF-4DDF-9F44-A00E913EBA1F"
                                        },
                                        {
                                            "title":"Type",
                                            "href":"NotificationEventArgsInstancePropertiesType.html#GUID-D78722A2-C02C-4030-9048-89F398527C0A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleNotificationEventArgs Methods",
                                    "href":"NotificationEventArgsInstanceMethods.html#GUID-96CD6364-23E8-430C-8F99-F8F5A325E1F9"
                                }
                            ]
                        },
                        {
                            "title":"OnChangeEventHandler Delegate",
                            "href":"OnChangeEventHandlerEventDelegate.html#GUID-21E19A8D-EA6E-4A26-B722-ACA8828AC503"
                        },
                        {
                            "title":"OracleRowidInfo Enumeration",
                            "href":"OracleRowidInfoEnumeration.html#GUID-71DF4814-7035-4D17-A9AC-663AB9644FA7"
                        },
                        {
                            "title":"OracleNotificationType Enumeration",
                            "href":"OracleNotificationTypeEnumeration.html#GUID-8A196356-2C48-4E54-980A-CD9A406AFC9D"
                        },
                        {
                            "title":"OracleNotificationSource Enumeration",
                            "href":"OracleNotificationSourceEnumeration.html#GUID-A77047E8-88EE-4E4B-B0E3-FC8B0B82B4E0"
                        },
                        {
                            "title":"OracleNotificationInfo Enumeration",
                            "href":"OracleNotificationInfoEnumeration.html#GUID-F2EDC278-3F8B-4B9A-B63B-A2EC276A45E8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Oracle Data Provider for .NET Globalization Classes",
                    "href":"odp-dot-net-globalization-classes.html#GUID-430433C2-7D3C-434A-ADD8-83688234DFA8",
                    "topics":[
                        {
                            "title":"OracleGlobalization Class",
                            "href":"OracleGlobalizationClass.html#GUID-0F50EB3E-67A3-4748-A146-E783532F9529",
                            "topics":[
                                {
                                    "title":"OracleGlobalization Members",
                                    "href":"GlobalizationMembers.html#GUID-C7E3ED3A-63FF-446D-96A6-E0335B1FD46B"
                                },
                                {
                                    "title":"OracleGlobalization Static Methods",
                                    "href":"GlobalizationStaticMethods.html#GUID-BADADBD1-D569-40E2-B340-E5A62AEA651D",
                                    "topics":[
                                        {
                                            "title":"GetClientInfo",
                                            "href":"GlobalizationGetClientInfoOverloads.html#GUID-4FD5D3EC-7B94-41CC-AAF0-0D83F081D44C"
                                        },
                                        {
                                            "title":"GetClientInfo()",
                                            "href":"GlobalizationGetClientInfo1.html#GUID-AFE5EF98-A84F-4C6E-B2CF-4FEBA26A343B"
                                        },
                                        {
                                            "title":"GetClientInfo(OracleGlobalization)",
                                            "href":"GlobalizationGetClientInfo2.html#GUID-2A54A932-3C10-4F34-B2D5-3B67AC6BA264"
                                        },
                                        {
                                            "title":"GetThreadInfo",
                                            "href":"GlobalizationGetThreadInfoOverloads.html#GUID-7C4555EE-B93A-4E83-AB8A-7A8D94FCF2DD"
                                        },
                                        {
                                            "title":"GetThreadInfo()",
                                            "href":"GlobalizationGetThreadInfo1.html#GUID-9FF49AE7-3884-49C3-8923-0280191699FA"
                                        },
                                        {
                                            "title":"GetThreadInfo(OracleGlobalization)",
                                            "href":"GlobalizationGetThreadInfo2.html#GUID-356E0173-7D2A-481B-A3E0-6B9AED7D2FB8"
                                        },
                                        {
                                            "title":"SetThreadInfo",
                                            "href":"GlobalizationSetThreadInfo.html#GUID-1E73A736-E266-4366-8285-437CD643E2D7"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleGlobalization Properties",
                                    "href":"GlobalizationProperties.html#GUID-8F13BEF7-283B-4468-82A4-7E293911DE45",
                                    "topics":[
                                        {
                                            "title":"Calendar",
                                            "href":"GlobalizationCalendar.html#GUID-00240BDD-885D-4688-961B-D3D7F44D5901"
                                        },
                                        {
                                            "title":"ClientCharacterSet",
                                            "href":"GlobalizationClientCharacterSet.html#GUID-41CF5BE2-5A7E-4808-AE02-D5A9857E6CF3"
                                        },
                                        {
                                            "title":"Comparison",
                                            "href":"GlobalizationComparison.html#GUID-F871676D-AB6B-45AD-B409-FD9D0DB6260A"
                                        },
                                        {
                                            "title":"Currency",
                                            "href":"GlobalizationCurrency.html#GUID-CB5E7F00-3623-44F1-AECE-205E651A9788"
                                        },
                                        {
                                            "title":"DateFormat",
                                            "href":"GlobalizationDateFormat.html#GUID-68E7367E-5B4F-4F20-ACF7-01E70E0CE3FF"
                                        },
                                        {
                                            "title":"DateLanguage",
                                            "href":"GlobalizationDateLanguage.html#GUID-4889EFDF-4478-4253-A40B-2BF0B9F8D32D"
                                        },
                                        {
                                            "title":"DualCurrency",
                                            "href":"GlobalizationDualCurrency.html#GUID-AEF5E091-7C57-45FB-B23C-C1D8BDA53F41"
                                        },
                                        {
                                            "title":"ISOCurrency",
                                            "href":"GlobalizationISOCurrency.html#GUID-9BF9241A-5321-45A6-8950-4D216329D042"
                                        },
                                        {
                                            "title":"Language",
                                            "href":"GlobalizationLanguage.html#GUID-CD906DBC-BFC5-4703-AA0F-4103F9C07926"
                                        },
                                        {
                                            "title":"LengthSemantics",
                                            "href":"GlobalizationLengthSemantics.html#GUID-7CB36598-79F0-480F-9099-A70944E1E520"
                                        },
                                        {
                                            "title":"NCharConversionException",
                                            "href":"GlobalizationNCharConversionException.html#GUID-C1A8C71B-7A61-45CE-8574-24EF2707BDC3"
                                        },
                                        {
                                            "title":"NumericCharacters",
                                            "href":"GlobalizationNumericCharacters.html#GUID-856E5308-2F0C-474C-91AD-4FE2B9AF34E1"
                                        },
                                        {
                                            "title":"Sort",
                                            "href":"GlobalizationSort.html#GUID-9F053CBD-3922-4F62-9872-62CDEBD2CE96"
                                        },
                                        {
                                            "title":"Territory",
                                            "href":"GlobalizationTerritory.html#GUID-48501FC6-3A50-4FD9-A610-7CB83ABA9C92"
                                        },
                                        {
                                            "title":"TimeStampFormat",
                                            "href":"GlobalizationTimeStampFormat.html#GUID-A79087EE-9CEA-4F83-9CA2-499568241BDA"
                                        },
                                        {
                                            "title":"TimeStampTZFormat",
                                            "href":"GlobalizationTimeStampTZFormat.html#GUID-74E5B64C-2139-4AFD-B96B-1C6A6CE9AE1B"
                                        },
                                        {
                                            "title":"TimeZone",
                                            "href":"GlobalizationTimeZone.html#GUID-41049777-4441-4E03-8D1D-08E6BE65AB6B"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleGlobalization Public Methods",
                                    "href":"GlobalizationPublicMethods.html#GUID-5E1AD43F-A29E-4BDB-8CDD-D5B3989B58A3",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"GlobalizationClone.html#GUID-8649880E-15A7-4442-BA65-A3E95CA78DE1"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"GlobalizationDispose.html#GUID-B2E70FC0-0D25-414C-B289-416C1F5CDC02"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDatabaseCharset Enumeration",
                            "href":"OracleDatabaseCharsetEnumeration.html#GUID-762FF258-FE9C-48C1-9B2F-D24C55090F6E"
                        },
                        {
                            "title":"OracleDatabaseNCharset Enumeration",
                            "href":"OracleDatabaseNCharsetEnumeration.html#GUID-C2C7D934-7CA8-43C4-B876-E0F5B52D3AED"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Oracle Data Provider for .NET Transparent Application Failover Classes",
                    "href":"odp-dot-net-failover.html#GUID-01B05188-B332-47A3-A30A-E92D68DD9C20",
                    "topics":[
                        {
                            "title":"OracleFailoverEventArgs Class",
                            "href":"OracleFailoverEventArgsClass.html#GUID-3B464F7C-2AD5-4209-BFBF-5EA7751B30C3",
                            "topics":[
                                {
                                    "title":"OracleFailoverEventArgs Members",
                                    "href":"FailoverEventArgsMembers.html#GUID-5970903E-39C3-46B0-85C1-50E7D35EF10D"
                                },
                                {
                                    "title":"OracleFailoverEventArgs Static Methods",
                                    "href":"FailoverEventArgsStaticMethods.html#GUID-82C97E22-DB03-427F-9D4B-731A4FDB251B"
                                },
                                {
                                    "title":"OracleFailoverEventArgs Properties",
                                    "href":"FailoverEventArgsProperties.html#GUID-55130208-046A-4EDF-BD30-F5D318266D53",
                                    "topics":[
                                        {
                                            "title":"FailoverEvent",
                                            "href":"FailoverEventArgsFailoverEvent.html#GUID-BD40EC40-93D1-41FE-B35F-B6907299B598"
                                        },
                                        {
                                            "title":"FailoverType",
                                            "href":"FailoverEventArgsFailoverType.html#GUID-57A604E4-3A0A-4855-94C4-62892B3E5295"
                                        },
                                        {
                                            "title":"OracleFailoverEvent",
                                            "href":"FailoverEventArgsOracleFailoverEvent.html#GUID-6BD3A524-2CCC-46E7-9982-A11BDC2AA537"
                                        },
                                        {
                                            "title":"OracleFailoverType",
                                            "href":"FailoverEventArgsOracleFailoverType.html#GUID-16E7EACA-F276-42E5-B060-E8FD2D224B72"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleFailoverEventArgs Public Methods",
                                    "href":"FailoverEventArgsPublicMethods.html#GUID-4AD03D55-B487-44CA-87EF-04C177F77BF0"
                                }
                            ]
                        },
                        {
                            "title":"OracleTAFMode Class",
                            "href":"OracleTAFModeClass.html#GUID-1F5FCA3F-7408-4F05-893C-32D513635088",
                            "topics":[
                                {
                                    "title":"OracleTAFMode Constructors",
                                    "href":"TAFModeCtors.html#GUID-D73645AA-1787-4BB3-80D5-B4CBC0EAC9FD"
                                }
                            ]
                        },
                        {
                            "title":"OracleFailoverEventHandler Delegate",
                            "href":"OracleFailoverEventHandlerDelegate.html#GUID-13D8EA35-6F8B-45C4-94ED-31F2DFC6F611"
                        },
                        {
                            "title":"FailoverEvent Enumeration",
                            "href":"FailoverEventEnumeration.html#GUID-B70B6300-A23A-44CD-A145-9DF847283D30"
                        },
                        {
                            "title":"FailoverReturnCode Enumeration",
                            "href":"FailoverReturnCodeEnumeration.html#GUID-35ED2EDE-BE0E-4720-92DC-C708A40EA29B"
                        },
                        {
                            "title":"FailoverType Enumeration",
                            "href":"FailoverTypeEnumeration.html#GUID-19FBBBEC-636A-4873-88C9-E018CC5C7D07"
                        },
                        {
                            "title":"OracleFailoverEvent Enumeration",
                            "href":"OracleFailoverEventEnumeration.html#GUID-49F3C9BC-8230-45BF-AED1-0F99842AAF16"
                        },
                        {
                            "title":"OracleFailoverRestore Enumeration",
                            "href":"OracleFailoverRestoreEnumeration.html#GUID-9C0EC8BF-7C88-46EE-9458-B5838EF2CF4F"
                        },
                        {
                            "title":"OracleFailoverReturnCode Enumeration",
                            "href":"OracleFailoverReturnCodeEnumeration.html#GUID-84606A23-AC9D-4245-8238-08E42569AF9D"
                        },
                        {
                            "title":"OracleFailoverType Enumeration",
                            "href":"OracleFailoverTypeEnumeration.html#GUID-3896EA7B-8BBE-4128-BE56-83A8712B63D6"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Oracle Database Advanced Queuing and Transactional Event Queues Classes",
                    "href":"aq-classes.html#GUID-4DBB419A-BCE1-467C-BA28-3611F3E012CA",
                    "topics":[
                        {
                            "title":"OracleAQAgent Class",
                            "href":"OracleAQAgentClass.html#GUID-13C70186-8CC7-4D37-AC8C-9FF48C0685A0",
                            "topics":[
                                {
                                    "title":"OracleAQAgent Members",
                                    "href":"AQAgentMembers.html#GUID-D3094E7B-98BE-4355-812F-AC7F060BC21D"
                                },
                                {
                                    "title":"OracleAQAgent Constructors",
                                    "href":"AQAgentConstructors.html#GUID-EA4309B1-25F5-4081-8CB1-8750508654B5",
                                    "topics":[
                                        {
                                            "title":"OracleAQAgent (string)",
                                            "href":"AQAgentCtor1.html#GUID-98127158-9113-4C6C-B891-DD2939EFA81A"
                                        },
                                        {
                                            "title":"OracleAQAgent (string, string)",
                                            "href":"AQAgentCtor2.html#GUID-B6859BBC-FD15-4E89-8410-33B14F63121D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQAgent Properties",
                                    "href":"AQAgentProperties.html#GUID-AC5583A5-B280-4B4E-B9FA-71CBBB6B6BDB",
                                    "topics":[
                                        {
                                            "title":"Address",
                                            "href":"AQAgentAddress.html#GUID-75C1401B-AFB9-4C4F-85A6-FAF407C360D0"
                                        },
                                        {
                                            "title":"Name",
                                            "href":"AQAgentName.html#GUID-22B7DE97-CFB8-4968-B5F3-6FA0CA029503"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQDequeueOptions Class",
                            "href":"OracleAQDequeueOptionsClass.html#GUID-FFFFA2E8-5848-4E9D-96AA-1619E766A34F",
                            "topics":[
                                {
                                    "title":"OracleAQDequeueOptions Members",
                                    "href":"AQDequeueOptionsMembers.html#GUID-2CEF146C-F9F9-47EA-A0DD-D0C92528C5DB"
                                },
                                {
                                    "title":"OracleAQDequeueOptions Constructor",
                                    "href":"AQDequeueOptionsConstructor.html#GUID-88BB8AA9-83D8-45AB-B576-81B37F6D531E"
                                },
                                {
                                    "title":"OracleAQDequeueOptions Properties",
                                    "href":"AQDequeueOptionsProperties.html#GUID-E0813CC5-E5AD-4808-BB5A-18D6772BFF3A",
                                    "topics":[
                                        {
                                            "title":"ConsumerName",
                                            "href":"AQDequeueOptionsConsumerName.html#GUID-D1BC8FCF-F802-46D8-A1B0-6F2252734604"
                                        },
                                        {
                                            "title":"Correlation",
                                            "href":"AQDequeueOptionsCorrelation.html#GUID-533C3A3C-FABE-4A81-8650-CD5FC504048B"
                                        },
                                        {
                                            "title":"DeliveryMode",
                                            "href":"AQDequeueOptionsDeliveryMode.html#GUID-0428648B-652A-4B06-BCED-1F02B5D5DEAD"
                                        },
                                        {
                                            "title":"DequeueMode",
                                            "href":"AQDequeueOptionsDequeueMode.html#GUID-350EAC48-6A25-44B7-BF83-29C2D6EA0931"
                                        },
                                        {
                                            "title":"MessageId",
                                            "href":"AQDequeueOptionsMessageId.html#GUID-2CBDEECF-0A81-4AD3-87EB-9D59BDF60305"
                                        },
                                        {
                                            "title":"NavigationMode",
                                            "href":"AQDequeueOptionsNavigationMode.html#GUID-27A6A502-5EB8-4F89-AA58-B522146EBD42"
                                        },
                                        {
                                            "title":"ProviderSpecificType",
                                            "href":"AQDequeueOptionsProviderSpecificType.html#GUID-6B49CDCE-E47E-4F32-B042-6A64C431D6B2"
                                        },
                                        {
                                            "title":"Visibility",
                                            "href":"AQDequeueOptionsVisibility.html#GUID-E0FF4DE1-9ADB-47CB-AC6D-5263194D46D9"
                                        },
                                        {
                                            "title":"Wait",
                                            "href":"AQDequeueOptionsWait.html#GUID-8AB996C4-7A3A-415B-A124-551CE858AE1A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQDequeueOptions Public Methods",
                                    "href":"AQDequeueOptionsPublicMethods.html#GUID-EA48FAF0-8E45-4852-96D0-724F4EACA8FA",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"AQDequeueOptionsClone.html#GUID-309CE1A1-8A1E-4EBE-8ED3-D4EFF269A46F"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQEnqueueOptions Class",
                            "href":"OracleAQEnqueueOptionsClass.html#GUID-2CEC6F2D-5A3E-4531-9C76-6348522EAB59",
                            "topics":[
                                {
                                    "title":"OracleAQEnqueueOptions Members",
                                    "href":"AQEnqueueOptionsMembers.html#GUID-DE28FE9C-0607-4885-8722-7926CDDB791C"
                                },
                                {
                                    "title":"OracleAQEnqueueOptions Constructor",
                                    "href":"AQEnqueueOptionsConstructor.html#GUID-3567D18D-D1A7-4460-A162-9D9649EEFAC7"
                                },
                                {
                                    "title":"OracleAQEnqueueOptions Properties",
                                    "href":"AQEnqueueOptionsProperties.html#GUID-DC09FD7B-43CD-4471-92EE-AF27DDFD30A1",
                                    "topics":[
                                        {
                                            "title":"DeliveryMode",
                                            "href":"AQEnqueueOptionsDeliveryMode.html#GUID-E20BF285-AF89-4F6E-8915-AF882E8A426E"
                                        },
                                        {
                                            "title":"Visibility",
                                            "href":"AQEnqueueOptionsVisibility.html#GUID-28E85B07-6054-4AF9-8234-2EBF331B336E"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQEnqueueOptions Public Methods",
                                    "href":"AQEnqueueOptionsPublicMethods.html#GUID-F465B3D2-D500-451D-848D-40051F9BEE42",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"AQEnqueueOptionsClone.html#GUID-79F4F92D-B41F-4DF1-A2AB-1B30311BCFCD"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQMessage Class",
                            "href":"OracleAQMessageClass.html#GUID-16A1F29B-CF63-47A8-8A9B-0A881E3C97CC",
                            "topics":[
                                {
                                    "title":"OracleAQMessage Members",
                                    "href":"AQMessageMembers.html#GUID-2C1A1083-29FE-41B3-92CD-E5A112BCAF25"
                                },
                                {
                                    "title":"OracleAQMessage Constructors",
                                    "href":"AQMessageConstructors.html#GUID-5921D48B-3A26-478F-92D2-BC6463FB2F04",
                                    "topics":[
                                        {
                                            "title":"OracleAQMessage()",
                                            "href":"AQMessageCtor1.html#GUID-3E32833D-DA35-4013-8479-363D574B20B5"
                                        },
                                        {
                                            "title":"OracleAQMessage(Object)",
                                            "href":"AQMessageCtor2.html#GUID-D9B8B6CF-A620-4D69-8C17-520C74C278D7"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQMessage Properties",
                                    "href":"AQMessageProperties.html#GUID-7FF612F5-2A53-43BB-8999-DAB1BB17A511",
                                    "topics":[
                                        {
                                            "title":"Correlation",
                                            "href":"AQMessageCorrelation.html#GUID-49B9218D-E76F-4AFD-BBC3-09025F3F0B7C"
                                        },
                                        {
                                            "title":"Delay",
                                            "href":"AQMessageDelay.html#GUID-1E3DD798-9756-41F9-BB9B-6D3B83505406"
                                        },
                                        {
                                            "title":"DeliveryMode",
                                            "href":"AQMessageDeliveryMode.html#GUID-4C7D3BEC-981B-4DFD-BC22-3B3244F715AD"
                                        },
                                        {
                                            "title":"DequeueAttempts",
                                            "href":"AQMessageDequeueAttempts.html#GUID-485711FA-8230-41D7-8036-39738FF12F03"
                                        },
                                        {
                                            "title":"EnqueueTime",
                                            "href":"AQMessageEnqueueTime.html#GUID-9C9D4D6A-48DA-4B02-BE19-0F0724602CF5"
                                        },
                                        {
                                            "title":"ExceptionQueue",
                                            "href":"AQMessageExceptionQueue.html#GUID-09E2A139-DB33-4F23-99B4-548A2A8470BF"
                                        },
                                        {
                                            "title":"Expiration",
                                            "href":"AQMessageExpiration.html#GUID-6B749449-FCDA-46C0-9C3E-E71B9C0393DA"
                                        },
                                        {
                                            "title":"MessageId",
                                            "href":"AQMessageMessageId.html#GUID-3E785861-71F6-437A-84FD-3A67546AAE56"
                                        },
                                        {
                                            "title":"OriginalMessageId",
                                            "href":"AQMessageOriginalMessageId.html#GUID-1A426B3B-FEC7-4D97-854C-1552BBB7A531"
                                        },
                                        {
                                            "title":"Payload",
                                            "href":"AQMessagePayload.html#GUID-1AD09E63-D2DD-4087-A132-C0D744AA5997"
                                        },
                                        {
                                            "title":"Priority",
                                            "href":"AQMessagePriority.html#GUID-0A137661-0AB7-4461-8326-610462ED9974"
                                        },
                                        {
                                            "title":"Recipients",
                                            "href":"AQMessageRecipients.html#GUID-7F3B4645-B338-4732-B87C-3C9680E3D1C9"
                                        },
                                        {
                                            "title":"SenderId",
                                            "href":"AQMessageSenderId.html#GUID-06107E83-40CA-41FC-A268-23EEFEC5551E"
                                        },
                                        {
                                            "title":"State",
                                            "href":"AQMessageState.html#GUID-2E059AA0-8904-4438-B1BC-F48A5CE871D8"
                                        },
                                        {
                                            "title":"TransactionGroup",
                                            "href":"AQMessageTransactionGroup.html#GUID-65FB1424-3337-4E97-A8D8-542D4208AD6C"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQMessageAvailableEventArgs Class",
                            "href":"OracleAQMessageAvailableEventArgsClass.html#GUID-D01D38BD-3EB2-44CC-AD62-DB80092DEE86",
                            "topics":[
                                {
                                    "title":"OracleAQMessageAvailableEventArgs Members",
                                    "href":"AQMessageAvailableEventArgsMembers.html#GUID-2CD595F9-AFE2-4A9E-84BD-48462824A397"
                                },
                                {
                                    "title":"OracleAQMessageAvailableEventArgs Constructor",
                                    "href":"AQMessageAvailableEventArgsConstructor.html#GUID-855D6C3E-C97A-46F1-B42B-C26E0E181AE6"
                                },
                                {
                                    "title":"OracleAQMessageAvailableEventArgs Properties",
                                    "href":"AQMessageAvailableEventArgsProperties.html#GUID-3D92DAB0-4CF3-4B3B-8BCA-EAC080AF111E",
                                    "topics":[
                                        {
                                            "title":"AvailableMessages",
                                            "href":"AQMessageAvailableEventArgsAvailableMessages.html#GUID-81D92407-EA0A-440E-8D0D-DD9F09A35234"
                                        },
                                        {
                                            "title":"ConsumerName",
                                            "href":"AQMessageAvailableEventArgsConsumerName.html#GUID-E0AE350A-FA10-4D13-992A-6AD47095CCB0"
                                        },
                                        {
                                            "title":"Correlation",
                                            "href":"AQMessageAvailableEventArgsCorrelation.html#GUID-A490120C-131E-4A02-BECB-19A03DEA4F4A"
                                        },
                                        {
                                            "title":"Delay",
                                            "href":"AQMessageAvailableEventArgsDelay.html#GUID-1B98D7A1-2266-4840-901C-FC54F9963C1E"
                                        },
                                        {
                                            "title":"DeliveryMode",
                                            "href":"AQMessageAvailableEventArgsDeliveryMode.html#GUID-FBF1DB16-17F9-45CB-88C4-1FD3A9CF7308"
                                        },
                                        {
                                            "title":"EnqueueTime",
                                            "href":"AQMessageAvailableEventArgsEnqueueTime.html#GUID-3317B31D-FCD5-4B67-9C48-ED0243340812"
                                        },
                                        {
                                            "title":"ExceptionQueue",
                                            "href":"AQMessageAvailableEventArgsExceptionQueue.html#GUID-559638A7-4790-487C-978B-ADEDA1D9D11B"
                                        },
                                        {
                                            "title":"Expiration",
                                            "href":"AQMessageAvailableEventArgsExpiration.html#GUID-4402193E-9C73-4956-ADCD-218D24931E83"
                                        },
                                        {
                                            "title":"MessageId",
                                            "href":"AQMessageAvailableEventArgsMessageId.html#GUID-B7EACFAC-FC6C-44BF-A8AC-8AFA869A8CD0"
                                        },
                                        {
                                            "title":"NotificationType",
                                            "href":"AQMessageAvailableEventArgsNotificationType.html#GUID-5C76C1DC-13B8-42F9-8F6D-04FA309B4BFA"
                                        },
                                        {
                                            "title":"OriginalMessageId",
                                            "href":"AQMessageAvailableEventArgsOriginalMessageId.html#GUID-46DC0513-2A92-4631-9FAA-86177721D5FF"
                                        },
                                        {
                                            "title":"Payload",
                                            "href":"AQMessageAvailableEventArgsPayload.html#GUID-9C3B50FB-0C3C-4F4E-8FA9-98888A0CF2F3"
                                        },
                                        {
                                            "title":"Priority",
                                            "href":"AQMessageAvailableEventArgsPriority.html#GUID-C4A89A19-27CC-49F4-85E0-AD39262AED01"
                                        },
                                        {
                                            "title":"Queue",
                                            "href":"AQMessageAvailableEventArgsQueue.html#GUID-EA08ABFA-FC35-49E2-AF36-96821FCE887C"
                                        },
                                        {
                                            "title":"QueueName",
                                            "href":"AQMessageAvailableEventArgsQueueName.html#GUID-F6ABE028-B6EC-4BB5-9CE4-F11B398A5622"
                                        },
                                        {
                                            "title":"SenderId",
                                            "href":"MessageAvailableEventArgsSenderId.html#GUID-CE0161EC-DA6F-42E8-BB61-CCF987A9E03D"
                                        },
                                        {
                                            "title":"State",
                                            "href":"AQMessageAvailableEventArgsState.html#GUID-F44FE1EB-E1D3-4357-88A7-4FCC3DB77A7C"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQMessageAvailableEventHandler Delegate",
                            "href":"OracleAQMessageAvailableEventHandlerDelegate.html#GUID-8A2ECDE4-FFAF-45C2-BFB2-30B542F554A8"
                        },
                        {
                            "title":"OracleAQQueue Class",
                            "href":"OracleAQQueueClass.html#GUID-5C99D7AC-DDEA-446D-AF13-F3C297F7CE07",
                            "topics":[
                                {
                                    "title":"OracleAQQueue Members",
                                    "href":"AQQueueMembers.html#GUID-54A1B6DA-2CE3-4445-83DA-F6EB878C6ACE"
                                },
                                {
                                    "title":"OracleAQQueue Properties",
                                    "href":"AQQueueProperties.html#GUID-F1ADEF7D-52F4-428A-B244-2761A9D2C8E6",
                                    "topics":[
                                        {
                                            "title":"AutoCommitTEQNotification",
                                            "href":"AQQueueAutoCommitTEQNotification.html#GUID-EF654864-6B6D-4350-963A-B71F66EE06FB"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"AQQueueConnection.html#GUID-135237C8-0560-4C9C-8F37-DB9946DCBD08"
                                        },
                                        {
                                            "title":"DequeueOptions",
                                            "href":"AQQueueDequeueOptions.html#GUID-1EE9BEEC-3D97-4BB5-9A47-4CB968A19B8B"
                                        },
                                        {
                                            "title":"EnqueueOptions",
                                            "href":"AQQueueEnqueueOptions.html#GUID-A9085589-92C1-4029-BCD5-2A57548DFCCA"
                                        },
                                        {
                                            "title":"MessageType",
                                            "href":"AQQueueMessageType.html#GUID-BC78968F-5F05-4845-94B8-A60160EDDAEA"
                                        },
                                        {
                                            "title":"Name",
                                            "href":"AQQueueName.html#GUID-21FB6820-B42F-4A4C-AE8C-32D9D74E91D3"
                                        },
                                        {
                                            "title":"Notification",
                                            "href":"AQQueueNotification.html#GUID-54CFE8F5-3926-4E65-A939-8AE255633B89"
                                        },
                                        {
                                            "title":"NotificationConsumers",
                                            "href":"AQQueueNotificationConsumers.html#GUID-102C6C6E-C7EE-49E2-9EE4-D32F615DA0A1"
                                        },
                                        {
                                            "title":"UdtTypeName",
                                            "href":"AQQueueUdtTypeName.html#GUID-D098130F-2224-4EAD-9F5E-98A3C1A309E2"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQQueue Constructors",
                                    "href":"AQQueueConstructors.html#GUID-DBF1234B-4A30-45AF-89FF-D031717BFA47",
                                    "topics":[
                                        {
                                            "title":"OracleAQQueue(string)",
                                            "href":"AQQueueCtor1.html#GUID-DFDDAAA0-D4C7-40D6-BA4A-84FEAC33390A"
                                        },
                                        {
                                            "title":"OracleAQQueue(string, OracleConnection)",
                                            "href":"AQQueueCtor2.html#GUID-4ED5F801-84F6-4B00-9DDE-2A0349293241"
                                        },
                                        {
                                            "title":"OracleAQQueue(string, OracleConnection, OracleAQMessageType)",
                                            "href":"AQQueueCtor3.html#GUID-B189D788-0159-49F8-B670-E252685FF78D"
                                        },
                                        {
                                            "title":"OracleAQQueue(string, OracleConnection, OracleAQMessageType, string)",
                                            "href":"AQQueueCtor4.html#GUID-CF835F95-8EBC-4779-8659-D69F27112408"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQQueue Static Methods",
                                    "href":"AQQueueStaticMethods.html#GUID-BC64DEE8-3E81-4AE2-B2BB-C1EDF3B0902D",
                                    "topics":[
                                        {
                                            "title":"Listen",
                                            "href":"AQQueueListenOverloads.html#GUID-D1E7595F-18ED-4447-83ED-9F62D5B73B6C"
                                        },
                                        {
                                            "title":"Listen(OracleConnection, OracleAQAgent[ ])",
                                            "href":"AQQueueListen1.html#GUID-BAE26D2B-7AD6-434E-B7CA-5B55CF67500C"
                                        },
                                        {
                                            "title":"Listen(OracleConnection, OracleAQAgent[ ], int)",
                                            "href":"AQQueueListen2.html#GUID-1B5CE1D1-7796-4DDA-AFA3-B6A99D3B5DBA"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQQueue Public Methods",
                                    "href":"AQQueuePublicMethods.html#GUID-66CE9BA0-F3C4-4980-B93A-41F7522E94FD",
                                    "topics":[
                                        {
                                            "title":"AcknowledgeTxEventQNotification",
                                            "href":"AQMessageAvailableEventArgsAcknowledgeTEQNotification.html#GUID-5CB32CEE-D895-4C6E-8937-83CE0B2B2D9A"
                                        },
                                        {
                                            "title":"Dequeue",
                                            "href":"AQQueueDequeueOverloads.html#GUID-A608C8D8-DCAB-4822-A6A5-B4FD7720A6C2"
                                        },
                                        {
                                            "title":"Dequeue()",
                                            "href":"AQQueueDequeue1.html#GUID-0B97C78E-694D-4EEF-BFBE-62880AF2E503"
                                        },
                                        {
                                            "title":"Dequeue(OracleAQDequeueOptions)",
                                            "href":"AQQueueDequeue2.html#GUID-31DFA1A6-0628-4E83-9232-EABE094D1511"
                                        },
                                        {
                                            "title":"DequeueArray",
                                            "href":"AQQueueDequeueArrayOverloads.html#GUID-6AB405FE-F68D-4A39-BA22-B320B8846EAF"
                                        },
                                        {
                                            "title":"DequeueArray(int)",
                                            "href":"AQQueueDequeueArray1.html#GUID-3160CD83-82DA-4743-8205-F9F11138CB9F"
                                        },
                                        {
                                            "title":"DequeueArray(int, OracleAQDequeueOptions)",
                                            "href":"AQQueueDequeueArray2.html#GUID-803030B6-CBA5-42BC-945D-DB73A39DC8C5"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"AQQueueDispose.html#GUID-9C0746E4-409E-45D7-836A-C1584B15C985"
                                        },
                                        {
                                            "title":"Enqueue",
                                            "href":"AQQueueEnqueueOverloads.html#GUID-FEC6C162-4412-4AC1-800C-D3580F2489A7"
                                        },
                                        {
                                            "title":"Enqueue(OracleAQMessage)",
                                            "href":"AQQueueEnqueue1.html#GUID-7539865B-F7C7-4027-9F26-EF864AD48296"
                                        },
                                        {
                                            "title":"Enqueue(OracleAQMessage, OracleAQEnqueueOptions)",
                                            "href":"AQQueueEnqueue2.html#GUID-5D0561F6-BEB3-4C02-B35F-CD30758A8A34"
                                        },
                                        {
                                            "title":"EnqueueArray",
                                            "href":"AQQueueEnqueueArrayOverloads.html#GUID-B9E7CBF7-5EC7-4B20-B810-69B8AE4D0C50"
                                        },
                                        {
                                            "title":"EnqueueArray(OracleAQMessage[ ])",
                                            "href":"AQQueueEnqueueArray1.html#GUID-F9DBCB42-E389-484E-91A7-C05D7D549761"
                                        },
                                        {
                                            "title":"EnqueueArray(OracleAQMessage[ ], OracleAQEnqueueOptions)",
                                            "href":"AQQueueEnqueueArray2.html#GUID-259FBA21-FAE5-4558-A22C-86BDA85A1D35"
                                        },
                                        {
                                            "title":"Listen",
                                            "href":"AQQueueListenOverloads001.html#GUID-66DAA323-EA4E-4B9E-BF14-29D81E690634"
                                        },
                                        {
                                            "title":"Listen(string[])",
                                            "href":"AQQueueListen1001.html#GUID-F522779F-D05B-4739-AF53-E3C23657BF80"
                                        },
                                        {
                                            "title":"Listen (string[], int)",
                                            "href":"AQQueueListen2001.html#GUID-48D8EEA7-2DA6-476B-94FE-791271F4B434"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleAQQueue Events",
                                    "href":"AQQueueEvents.html#GUID-6EF885F2-E5CB-469E-A7AC-064648A29955",
                                    "topics":[
                                        {
                                            "title":"MessageAvailable Event",
                                            "href":"AQQueueMessageAvailableEvent.html#GUID-37AD57F2-4121-4C63-877A-0C06B7AA79D1"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleAQDequeueMode Enumeration",
                            "href":"OracleAQDequeueModeEnumeration.html#GUID-A19B769F-7AF3-4569-BB11-74BB6A542CCD"
                        },
                        {
                            "title":"OracleAQMessageDeliveryMode Enumeration",
                            "href":"OracleAQMessageDeliveryModeEnumeration.html#GUID-9299EA18-3640-4740-9821-923161E99AE7"
                        },
                        {
                            "title":"OracleAQMessageState Enumeration",
                            "href":"OracleAQMessageStateEnumeration.html#GUID-CA666CD6-EB49-43F6-AFD4-66045F2E1AF7"
                        },
                        {
                            "title":"OracleAQMessageType Enumeration",
                            "href":"OracleAQMessageTypeEnumeration.html#GUID-A2338D6C-C76D-4BC9-9699-3D3310BBD0A0"
                        },
                        {
                            "title":"OracleAQNavigationMode Enumeration",
                            "href":"OracleAQNavigationModeEnumeration.html#GUID-4311EB18-37F9-4AC7-B314-BD76CF31E5DC"
                        },
                        {
                            "title":"OracleAQNotificationGroupingType Enumeration",
                            "href":"OracleAQNotificationGroupingTypeEnumeration.html#GUID-A73EDD0A-E720-495A-960A-3D66D495A42E"
                        },
                        {
                            "title":"OracleAQNotificationType Enumeration",
                            "href":"OracleAQNotificationTypeEnumeration.html#GUID-53089B37-4943-47AC-BA0F-01CF81237CA3"
                        },
                        {
                            "title":"OracleAQVisibilityMode Enumeration",
                            "href":"OracleAQVisibilityModeEnumeration.html#GUID-F278A346-81BF-4629-B90D-30F976514D9D"
                        },
                        {
                            "title":"OracleTxEventQNotificationDirective Enumeration",
                            "href":"OracleTEQNotificationDirectiveEnumeration.html#GUID-48AF63A9-0304-4A62-AFCF-F2060370AE09"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Oracle Data Provider for .NET Types Classes",
                    "href":"types-classes.html#GUID-D343EAF4-2926-40D7-8E59-FD18DA726AD6",
                    "topics":[
                        {
                            "title":"OracleBFile Class",
                            "href":"OracleBFileClass.html#GUID-571495C6-7BE9-4AF8-9EC3-02BFF074D57A",
                            "topics":[
                                {
                                    "title":"OracleBFile Members",
                                    "href":"BFileMembers.html#GUID-E8AA3813-288B-4AEA-B934-58FF2201C034"
                                },
                                {
                                    "title":"OracleBFile Constructors",
                                    "href":"BFileCtors.html#GUID-9711857C-5800-4118-9D35-68A0F5A85056",
                                    "topics":[
                                        {
                                            "title":"OracleBFile(OracleConnection)",
                                            "href":"BFileCtor1.html#GUID-FB8DC6EC-0F3B-4B3C-BA2B-FF131034FCA0"
                                        },
                                        {
                                            "title":"OracleBFile(OracleConnection, string, string)",
                                            "href":"BFileCtor2.html#GUID-7D0838A0-D48F-45BC-A269-B2DE1B7B5648"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBFile Static Fields",
                                    "href":"BFileStaticFields.html#GUID-69B9BB75-97B4-4767-AFAB-C2CACD41719B",
                                    "topics":[
                                        {
                                            "title":"MaxSize",
                                            "href":"BFileMaxSize.html#GUID-E5BA2023-AA42-49CB-9852-5D2D71D74B47"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"BFileNull.html#GUID-B10894B2-D0D7-459E-B814-4ED085E760B0"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBFile Static Methods",
                                    "href":"BFileStaticMethods.html#GUID-499D8DD1-446B-4B1B-9A39-D20879D33CB2"
                                },
                                {
                                    "title":"OracleBFile Instance Properties",
                                    "href":"BFileProperties.html#GUID-035EA8A8-E1F0-4044-A174-3B5FAE34C32B",
                                    "topics":[
                                        {
                                            "title":"CanRead",
                                            "href":"BFileCanRead.html#GUID-920250A4-9D7E-4FDE-9006-5601A730749D"
                                        },
                                        {
                                            "title":"CanSeek",
                                            "href":"BFileCanSeek.html#GUID-44306B7E-56B3-49BC-A591-2ADC403C99F1"
                                        },
                                        {
                                            "title":"CanWrite",
                                            "href":"BFileCanWrite.html#GUID-7A8F8FCE-3F4C-453D-B7B6-E69B58B2E105"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"BFileConnection.html#GUID-4275425A-3934-495D-BBFE-C0A557B06E36"
                                        },
                                        {
                                            "title":"DirectoryName",
                                            "href":"BFileDirectoryName.html#GUID-0A422016-6007-47BC-B7D1-87E0170BCCA8"
                                        },
                                        {
                                            "title":"FileExists",
                                            "href":"BFileFileExists.html#GUID-80366914-3747-4038-8547-7F21D45B8A13"
                                        },
                                        {
                                            "title":"FileName",
                                            "href":"BFileFileName.html#GUID-923F01E8-C2D6-4B42-AD35-01038ABD6211"
                                        },
                                        {
                                            "title":"IsEmpty",
                                            "href":"BFileIsEmpty.html#GUID-3755D831-6F64-4596-8845-C98934556375"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"BFileIsNull.html#GUID-BDC7434E-56C7-4349-B7DF-F38DD2EEA926"
                                        },
                                        {
                                            "title":"IsOpen",
                                            "href":"BFileIsOpen.html#GUID-77C7661B-5F73-45E7-AD75-D75C5C3FE352"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"BFileLength.html#GUID-903CAD44-B64E-4724-9A5B-279B79E81A71"
                                        },
                                        {
                                            "title":"Position",
                                            "href":"BFilePosition.html#GUID-EC82C4A4-2733-42BA-A0FF-710A3E2DAD34"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"BFileValue.html#GUID-B6385F2B-2711-4F37-BF55-09F39BADC2C4"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBFile Instance Methods",
                                    "href":"BFileInstanceMethods.html#GUID-40578780-4B76-42CF-AA9D-BDD91C9BC33B",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"BFileClone.html#GUID-34585D89-8942-40F8-9457-571B9AAB13A2"
                                        },
                                        {
                                            "title":"Close",
                                            "href":"BFileClose.html#GUID-59AB21E9-987A-4C41-9429-83E35E4F8404"
                                        },
                                        {
                                            "title":"CloseFile",
                                            "href":"BFileCloseFile.html#GUID-E489FDAA-3249-4E02-804D-9C8698B48BB6"
                                        },
                                        {
                                            "title":"Compare",
                                            "href":"BFileCompare.html#GUID-C835129F-EAA3-4E34-AE70-6075A4C2D22D"
                                        },
                                        {
                                            "title":"CopyTo",
                                            "href":"BFileCopyToOverloads.html#GUID-024A3F06-29E8-4C2F-9747-E4F2525AEA80"
                                        },
                                        {
                                            "title":"CopyTo(OracleBlob)",
                                            "href":"BFileCoptyTo1.html#GUID-650F58C5-B7D9-4E4B-8ABC-2298ED6181CA"
                                        },
                                        {
                                            "title":"CopyTo(OracleBlob, Int64)",
                                            "href":"BFileCopyTo2.html#GUID-A3ED2A92-226A-4C5B-89F1-C1CB08E2EB5A"
                                        },
                                        {
                                            "title":"CopyTo(Int64, OracleBlob, Int64, Int64)",
                                            "href":"BFileCoptyTo3.html#GUID-1C014897-E7A5-4DE0-8899-BB60E5A3D710"
                                        },
                                        {
                                            "title":"CopyTo(OracleClob)",
                                            "href":"BFileCopyTo4.html#GUID-C6ECDABD-4488-490A-B66D-D1A291FAADDB"
                                        },
                                        {
                                            "title":"CopyTo(OracleClob, Int64)",
                                            "href":"BFileCopyTo5.html#GUID-97E1EB00-60C6-46DF-A360-7BCFE0AE4D56"
                                        },
                                        {
                                            "title":"CopyTo(Int64, OracleClob, Int64, Int64)",
                                            "href":"BFileCopyTo6.html#GUID-0584B558-24EE-4E83-9D96-265171D8DAE0"
                                        },
                                        {
                                            "title":"CopyToAsync",
                                            "href":"BFileCopyToAsyncOverloads.html#GUID-FFD4288D-F491-4807-AF07-D0845DF244B5"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleBlob, Int64, Int64)",
                                            "href":"BFileCopyToAsync1.html#GUID-CCC77573-D54B-46E9-B4B2-DC94C3E01452"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleBlob, Int64, Int64, CancellationToken)",
                                            "href":"BFileCopyToAsync2.html#GUID-6AB4CE20-DCC3-4497-ABEC-CD2E0827F96F"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, Int64)",
                                            "href":"BFileCopyToAsync3.html#GUID-29449A39-BB05-43CE-A8EE-28D70385C6D9"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, Int64, CancellationToken)",
                                            "href":"BFileCopyToAsync4.html#GUID-16C05AA2-7D52-490A-A1CE-C1F5C5582322"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob)",
                                            "href":"BFileCopyToAsync5.html#GUID-A8A55D99-66F1-41CB-962B-C274D3E48335"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, CancellationToken)",
                                            "href":"BFileCopyToAsync6.html#GUID-D6A022D5-2596-499E-A7EA-72B987309C0E"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleClob, Int64, Int64)",
                                            "href":"BFileCopyToAsync7.html#GUID-482EC214-A8CB-4D4D-B4D9-70B68DDC3543"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleClob, Int64, Int64, CancellationToken)",
                                            "href":"BFileCopyToAsync8.html#GUID-F1B9984A-D390-4E13-8B63-1F3ACAF5A131"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, Int64)",
                                            "href":"BFileCopyToAsync9.html#GUID-8BD9172E-A4F9-4238-B196-A78BC713F1ED"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, Int64, CancellationToken)",
                                            "href":"BFileCopyToAsync10.html#GUID-908BCF66-0DFD-4A4C-BFD3-9568711C5CD8"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob)",
                                            "href":"BFileCopyToAsync11.html#GUID-1CF8838F-09BE-4F72-AA3C-14E598D1FF00"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, CancellationToken)",
                                            "href":"BFileCopyToAsync12.html#GUID-96F00C36-0F6A-4A65-AD73-8E56169DD945"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"BFileDispose.html#GUID-95678C2D-76D9-4064-904F-34E1289EF2DA"
                                        },
                                        {
                                            "title":"Flush",
                                            "href":"BFileFlush.html#GUID-65050327-B66C-47EC-BD56-B6D4672C837B"
                                        },
                                        {
                                            "title":"FlushAsync",
                                            "href":"BFileFlushAsync.html#GUID-2CCEA041-D19F-48F2-A3C6-946B88BA78AF"
                                        },
                                        {
                                            "title":"IsEqual",
                                            "href":"BFileIsEqual.html#GUID-2F5DA07D-F3E5-4976-8F50-8798CEC6D470"
                                        },
                                        {
                                            "title":"OpenFile",
                                            "href":"BFileOpenFile.html#GUID-74564BF0-E9C3-45CC-ADFA-00FE70E107A5"
                                        },
                                        {
                                            "title":"Read",
                                            "href":"BFileRead.html#GUID-E92EE1D3-78C7-4B60-B00E-EDA95D9B360B"
                                        },
                                        {
                                            "title":"ReadAsync",
                                            "href":"BFileReadAsyncOverloads.html#GUID-7CB573B2-3A36-4734-9F23-C02F203F8511"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int)",
                                            "href":"BFileReadAsync1.html#GUID-EA541AB5-E080-41B2-998E-0C94F032117B"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int, CancellationToken)",
                                            "href":"BFileReadAsync2.html#GUID-DCFBD186-7225-450C-96B5-7A48395C7272"
                                        },
                                        {
                                            "title":"Search",
                                            "href":"BFileSearch.html#GUID-FF5FC60A-E75A-4F98-9461-350BD84EAF48"
                                        },
                                        {
                                            "title":"Seek",
                                            "href":"BFileSeek.html#GUID-E833FCE1-2046-47D4-9121-E3A8D1C0BBD5"
                                        },
                                        {
                                            "title":"SetLength",
                                            "href":"BFileSetLength.html#GUID-191FF72F-0E11-4EA0-8D26-0B07692EBF08"
                                        },
                                        {
                                            "title":"Write",
                                            "href":"BFileWrite.html#GUID-94FDA400-2D78-4F5C-8B32-43985356C8CF"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleBlob Class",
                            "href":"OracleBlobClass.html#GUID-15E1EDFD-8FB6-47ED-AFCF-DA8433B5BADD",
                            "topics":[
                                {
                                    "title":"OracleBlob Members",
                                    "href":"BlobMembers.html#GUID-E8BA1618-B130-4C0C-9763-D5D62F457DD6"
                                },
                                {
                                    "title":"OracleBlob Constructors",
                                    "href":"BlobCtors.html#GUID-19A0A99B-4A43-4C7B-878A-895AC627EB27",
                                    "topics":[
                                        {
                                            "title":"OracleBlob(OracleConnection)",
                                            "href":"BlobCtor1.html#GUID-86CA0EB0-58CF-48EA-B4FE-33BB79B24531"
                                        },
                                        {
                                            "title":"OracleBlob(OracleConnection, bool)",
                                            "href":"BlobCtor2.html#GUID-D4629ABD-B89B-4CFC-A3AA-80C89ECCFC6A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBlob Static Fields",
                                    "href":"BlobStaticFields.html#GUID-37FF85EB-5D48-49C6-AD40-27F97449CEB7",
                                    "topics":[
                                        {
                                            "title":"MaxSize",
                                            "href":"BlobMaxSize.html#GUID-5CFC4712-10F5-4B20-B16F-B01F458EE826"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"BlobNull.html#GUID-9F2A3BA0-7841-4118-9978-61D85A85616F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBlob Static Methods",
                                    "href":"BlobStaticMethods.html#GUID-C6EA52E6-C73E-450F-A783-82D82BF35CE5"
                                },
                                {
                                    "title":"OracleBlob Instance Properties",
                                    "href":"BlobInstanceProperties.html#GUID-B6C53590-9EA3-4A87-894A-3AD0B7C19D69",
                                    "topics":[
                                        {
                                            "title":"CanRead",
                                            "href":"BlobCanRead.html#GUID-3229A94D-47A1-4CD2-BD79-2B01316FD6A0"
                                        },
                                        {
                                            "title":"CanSeek",
                                            "href":"BlobCanSeek.html#GUID-8C4B2801-B07B-4641-93FD-BBF9BF2FF2A5"
                                        },
                                        {
                                            "title":"CanWrite",
                                            "href":"BlobCanWrite.html#GUID-E9BB681F-F16C-4829-A0ED-020DCEA4FB5B"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"BlobConnection.html#GUID-52008A61-9066-4055-A109-C633C06013E4"
                                        },
                                        {
                                            "title":"IsEmpty",
                                            "href":"BlobIsEmpty.html#GUID-F89B197D-DD1A-4DA0-BABE-A9B3E81592D3"
                                        },
                                        {
                                            "title":"IsInChunkWriteMode",
                                            "href":"BlobIsInChunkWriteMode.html#GUID-58046210-7243-427F-91C3-8B60FE8B2543"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"BlobIsNull.html#GUID-D95EE35C-C47E-48B7-A486-EE5C321BAA5E"
                                        },
                                        {
                                            "title":"IsTemporary",
                                            "href":"BlobIsTemporary.html#GUID-49211BC1-D64C-40AA-AE73-13F9B5126B4E"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"BlobLength.html#GUID-D7572939-3D7F-4C63-B47A-EE3DAC6913DA"
                                        },
                                        {
                                            "title":"OptimumChunkSize",
                                            "href":"BlobOptimumChunkSize.html#GUID-8DB78D98-992D-4DE0-9192-71DD8BF6FB2D"
                                        },
                                        {
                                            "title":"Position",
                                            "href":"BlobPosition.html#GUID-F4C91767-10AD-4EEA-A22F-D413F2F194A3"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"BlobValue.html#GUID-27815D13-B951-4B9B-934F-8AE5D7946425"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBlob Instance Methods",
                                    "href":"BlobInstanceMethods.html#GUID-0AC29360-1E0D-441E-A41B-E48A9027127E",
                                    "topics":[
                                        {
                                            "title":"Append",
                                            "href":"BlobAppendOverloads.html#GUID-CE425952-23DB-4063-8B73-7FFE7144717F"
                                        },
                                        {
                                            "title":"Append(OracleBlob)",
                                            "href":"BlobAppend1.html#GUID-80A6BB5F-92DE-4EFF-8C7C-7138DB01368F"
                                        },
                                        {
                                            "title":"Append(byte[ ], int, int)",
                                            "href":"BlobAppend2.html#GUID-CC150C3E-AF19-4F43-A0A3-88AAF7874F38"
                                        },
                                        {
                                            "title":"BeginChunkWrite",
                                            "href":"BlobbeginChunkWrite.html#GUID-B479BEEF-1A2A-4A5C-AB86-E8C365807C84"
                                        },
                                        {
                                            "title":"Clone",
                                            "href":"BlobClone.html#GUID-02A8ECB6-63DF-434E-B077-686C9BCB0354"
                                        },
                                        {
                                            "title":"Close",
                                            "href":"BlobClose.html#GUID-3E2FB1E4-3176-4D73-8F14-6956D8A74319"
                                        },
                                        {
                                            "title":"Compare",
                                            "href":"BlobCompare.html#GUID-AD43A86F-7616-4C3B-A156-025831647344"
                                        },
                                        {
                                            "title":"CopyTo",
                                            "href":"BlobCopyToOverloads.html#GUID-AE098C18-7C71-45E8-AC5B-D60ECBCF3EC7"
                                        },
                                        {
                                            "title":"CopyTo(OracleBlob)",
                                            "href":"BlobCopyTo1.html#GUID-70CE8D9C-107F-48FF-92FA-965A0A4BA00D"
                                        },
                                        {
                                            "title":"CopyTo(OracleBlob, Int64)",
                                            "href":"BlobCopyTo2.html#GUID-CF3E4663-4E4E-48B7-B42D-DCFE2CD4ACE7"
                                        },
                                        {
                                            "title":"CopyTo(Int64, OracleBlob, Int64, Int64)",
                                            "href":"BlobCopyTo3.html#GUID-A98FFCAB-714E-48E4-9F71-9ECE6EC038B3"
                                        },
                                        {
                                            "title":"CopyToAsync",
                                            "href":"BlobCopyToAsyncOverloads.html#GUID-83615738-988F-4936-B225-11960D034ABF"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleBlob, Int64, Int64)",
                                            "href":"BlobCopyToAsync1.html#GUID-87C26263-7064-4951-A656-08FB689FA232"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleBlob, Int64, Int64, CancellationToken)",
                                            "href":"BlobCopyToAsync2.html#GUID-023A2CC7-F170-402A-A0A8-208ABE2B9067"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, Int64)",
                                            "href":"BlobCopyToAsync3.html#GUID-4124A3B1-36D5-4364-8EEE-D256B4383891"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, Int64, CancellationToken)",
                                            "href":"BlobCopyToAsync4.html#GUID-CFF9FBC2-AC71-451F-8451-34FFAA1F8874"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob)",
                                            "href":"BlobCopyToAsync5.html#GUID-AA86A337-B0B1-4F90-8C2A-2A4B0917FCE6"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleBlob, CancellationToken)",
                                            "href":"BlobCopyToAsync6.html#GUID-EEC4C3DC-B617-4093-82FA-E84BA8AC6D22"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"BlobDispose.html#GUID-1B99E019-1E37-42EF-89ED-F4A654A767E8"
                                        },
                                        {
                                            "title":"EndChunkWrite",
                                            "href":"BlobEndChunkWrite.html#GUID-C1DC6D5F-D7CD-4E8A-A7D8-92631C8CBD13"
                                        },
                                        {
                                            "title":"Erase",
                                            "href":"BlobEraseOverloads.html#GUID-429DE97C-058B-4F10-A7DF-C2EA23DF7DD8"
                                        },
                                        {
                                            "title":"Erase()",
                                            "href":"BlobErase1.html#GUID-DFC2600E-5DE6-42B0-8222-6ABD1FFA7917"
                                        },
                                        {
                                            "title":"Erase(Int64, Int64)",
                                            "href":"BlobErase2.html#GUID-6DE0F521-AB1B-48FC-A3B1-23C4D39D6E59"
                                        },
                                        {
                                            "title":"Flush",
                                            "href":"BlobFlush.html#GUID-367D9DCC-314C-4840-9256-C4BC15858036"
                                        },
                                        {
                                            "title":"IsEqual",
                                            "href":"BlobIsEqual.html#GUID-253A22A6-DE14-4201-8DAB-13835DE43C60"
                                        },
                                        {
                                            "title":"Read",
                                            "href":"BlobRead.html#GUID-5AFBDB39-18F1-4B85-8D3B-D53A08C0B73B"
                                        },
                                        {
                                            "title":"ReadAsync",
                                            "href":"BlobReadAsyncOverloads.html#GUID-AA68D5A7-8ECB-4235-986F-E8F7244085C1"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int)",
                                            "href":"BlobReadAsync1.html#GUID-8E6BDD23-582E-469C-AE1D-60A2F1FFD012"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int, CancellationToken)",
                                            "href":"BlobReadAsync2.html#GUID-6D1FBC6B-7FAE-403D-9AFC-2207AFA9CCD6"
                                        },
                                        {
                                            "title":"Search",
                                            "href":"BlobSearch.html#GUID-C37CC83B-3E48-4B83-9A26-D38830016BF8"
                                        },
                                        {
                                            "title":"Seek",
                                            "href":"BlobSeek.html#GUID-7553D590-A5E5-4552-92AA-A1F711EEAEF4"
                                        },
                                        {
                                            "title":"SetLength",
                                            "href":"BlobSetLength.html#GUID-C735F19B-9A8B-42BE-B062-F4821D6032A7"
                                        },
                                        {
                                            "title":"Write",
                                            "href":"BlobWrite.html#GUID-DFC942C0-A67D-47C9-9D07-81D8C3DB9B24"
                                        },
                                        {
                                            "title":"WriteAsync",
                                            "href":"BlobWriteAsyncOverloads.html#GUID-BF81F11C-47BD-487B-9B5E-E6C05AB6B3F8"
                                        },
                                        {
                                            "title":"WriteAsync(byte[], int, int)",
                                            "href":"BlobWriteAsync1.html#GUID-4EB8479D-1454-4198-917F-F5410B250C73"
                                        },
                                        {
                                            "title":"WriteAsync(byte[], int, int, CancellationToken)",
                                            "href":"BlobWriteAsync2.html#GUID-E7BFEFB1-360B-491A-8A17-70BD78E8B28B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleClob Class",
                            "href":"OracleClobClass.html#GUID-0C1A0DB5-D2F1-4498-8AC6-565A75E5E384",
                            "topics":[
                                {
                                    "title":"OracleClob Members",
                                    "href":"ClobMembers.html#GUID-0421F9CB-C174-4273-BAE3-6D6135CFDDEB"
                                },
                                {
                                    "title":"OracleClob Constructors",
                                    "href":"ClobCtors.html#GUID-E1463875-E9B4-47E2-8B70-A5C7A396CEB5",
                                    "topics":[
                                        {
                                            "title":"OracleClob(OracleConnection)",
                                            "href":"ClobCtor1.html#GUID-56D83755-98EE-426F-8D0E-55A11E011E42"
                                        },
                                        {
                                            "title":"OracleClob(OracleConnection, bool, bool)",
                                            "href":"ClobCtor2.html#GUID-8DE0F842-AA2D-4B3F-AD76-0C520AD76922"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleClob Static Fields",
                                    "href":"ClobStaticFields.html#GUID-93E8603C-8277-42D6-A77C-AC80975D353A",
                                    "topics":[
                                        {
                                            "title":"MaxSize",
                                            "href":"ClobMaxSize.html#GUID-5E31BDB0-CFB1-469F-8348-CCCF5B46DF44"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"ClobNull.html#GUID-3A405EA4-278F-46FF-8967-5057E79178DB"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleClob Static Methods",
                                    "href":"ClobStaticMethods.html#GUID-1F377A7A-25E5-4C5C-8128-4F529F2A6ACD"
                                },
                                {
                                    "title":"OracleClob Instance Properties",
                                    "href":"ClobInstanceProperties.html#GUID-DA9457A1-C455-452E-8F7E-E1684F7ECBBD",
                                    "topics":[
                                        {
                                            "title":"CanRead",
                                            "href":"ClobCanRead.html#GUID-68A4ADFB-F7B4-4FBB-B1AA-42C6242D9565"
                                        },
                                        {
                                            "title":"CanSeek",
                                            "href":"ClobCanSeek.html#GUID-18BAD32C-7A02-4049-83D2-0AD92AD7C9E8"
                                        },
                                        {
                                            "title":"CanWrite",
                                            "href":"ClobCanWrite.html#GUID-AF06E4C7-F636-4424-A588-E896820606F4"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"ClobConnection.html#GUID-69D27F44-0DA4-433F-A0F5-CD3DC2239E38"
                                        },
                                        {
                                            "title":"IsEmpty",
                                            "href":"ClobIsEmpty.html#GUID-6C055D8C-9EE4-4946-B22C-6B3807E73722"
                                        },
                                        {
                                            "title":"IsInChunkWriteMode",
                                            "href":"ClobIsInChunkWriteMode.html#GUID-27C3FC4F-0970-43AC-9047-DBDD3950874F"
                                        },
                                        {
                                            "title":"IsNClob",
                                            "href":"ClobIsNClob.html#GUID-EE239537-0FAA-4768-AF0E-92F9D07D9D31"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"ClobIsNull.html#GUID-1D896EE3-FF3C-44BF-99B5-CF00773F1289"
                                        },
                                        {
                                            "title":"IsTemporary",
                                            "href":"ClobIsTemporary.html#GUID-DF821EED-969B-45BB-B86C-94E98CBF500B"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"ClobLength.html#GUID-38E431B2-289D-47DE-A65F-52B8C24D9EF5"
                                        },
                                        {
                                            "title":"OptimumChunkSize",
                                            "href":"ClobOptimumChunkSize.html#GUID-5D3AFB60-7031-49FB-B9EC-2ED1FB991B8C"
                                        },
                                        {
                                            "title":"Position",
                                            "href":"ClobPosition.html#GUID-2E7D8AD2-9D19-455A-84B5-19725C2CF32D"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"ClobValue.html#GUID-120BFD1D-E618-43AB-8AC6-514E690D6011"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleClob Instance Methods",
                                    "href":"ClobInstanceMethods.html#GUID-D5E1BAC5-DADA-4A90-A152-8928D52E0055",
                                    "topics":[
                                        {
                                            "title":"Append",
                                            "href":"ClobAppendOverloads.html#GUID-D0941F7F-EDD4-4FED-A257-4D9AAC16F3C1"
                                        },
                                        {
                                            "title":"Append(OracleClob)",
                                            "href":"ClobAppend1.html#GUID-7EA32AEA-7F4B-4059-9EF4-080665EDD626"
                                        },
                                        {
                                            "title":"Append(byte [ ], int, int)",
                                            "href":"ClobAppend2.html#GUID-3FF3AC31-FA99-4FAC-8F8E-890EB60EEE53"
                                        },
                                        {
                                            "title":"Append(char [ ], int, int)",
                                            "href":"ClobAppend3.html#GUID-AFFC5721-0A3A-4EA1-91D4-7B929EEA9240"
                                        },
                                        {
                                            "title":"BeginChunkWrite",
                                            "href":"ClobBeginChunkWrite.html#GUID-41D9779E-CF6A-46B2-B137-2D46B06EFAA4"
                                        },
                                        {
                                            "title":"Clone",
                                            "href":"ClobClone.html#GUID-FFAF5453-3BFF-47BE-BE67-84A63B8520A4"
                                        },
                                        {
                                            "title":"Close",
                                            "href":"ClobClose.html#GUID-95ECB32C-4FFD-411F-8E60-D6EC02FFF0DE"
                                        },
                                        {
                                            "title":"Compare",
                                            "href":"ClobCompare.html#GUID-B0114AFD-9981-4A72-A3D2-84AC1FF0919D"
                                        },
                                        {
                                            "title":"CopyTo",
                                            "href":"ClobCopyToOverloads.html#GUID-80673048-5BD1-4D0D-837E-55F66B920F2E"
                                        },
                                        {
                                            "title":"CopyTo(OracleClob)",
                                            "href":"ClobCopyTo1.html#GUID-1967ABAF-CA14-4611-B6B6-0FCB0DAB69AA"
                                        },
                                        {
                                            "title":"CopyTo(OracleClob, Int64)",
                                            "href":"ClobCopyTo2.html#GUID-2460E857-365A-483F-953F-E884205EDCDB"
                                        },
                                        {
                                            "title":"CopyTo(Int64, OracleClob, Int64, Int64)",
                                            "href":"ClobCopyTo3.html#GUID-A1C1CCEA-068C-471E-AF22-40D2B7488A30"
                                        },
                                        {
                                            "title":"CopyToAsync",
                                            "href":"ClobCopyToAsyncOverloads.html#GUID-CC23B5EF-2FD0-40BB-9F98-2F60B5871E59"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleClob, Int64, Int64)",
                                            "href":"ClobCopyToAsync1.html#GUID-6142D8DC-A90A-44BF-8EE8-2647144ACFB1"
                                        },
                                        {
                                            "title":"CopyToAsync(Int64, OracleClob, Int64, Int64, CancellationToken)",
                                            "href":"ClobCopyToAsync2.html#GUID-B663FE86-4838-4B4F-BE7F-6E9466CE35C9"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, Int64)",
                                            "href":"ClobCopyToAsync3.html#GUID-1C7CEF67-6E72-49AF-9ADD-48B21D43D059"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, Int64, CancellationToken)",
                                            "href":"ClobCopyToAsync4.html#GUID-26BD1F22-BF6F-4323-B31F-544F8794EB27"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob)",
                                            "href":"ClobCopyToAsync5.html#GUID-7EA8BEE6-1655-47B0-9A9C-A4BBFCA56D3C"
                                        },
                                        {
                                            "title":"CopyToAsync(OracleClob, CancellationToken)",
                                            "href":"ClobCopyToAsync6.html#GUID-7248EE12-1067-440C-AF76-CB9FEF0E3373"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"ClobDispose.html#GUID-831AE590-DB28-40DC-B1F9-4D990293763D"
                                        },
                                        {
                                            "title":"EndChunkWrite",
                                            "href":"ClobEndChunkWrite.html#GUID-E35DD71F-19B0-47EE-AE71-EFBCC4C7A564"
                                        },
                                        {
                                            "title":"Erase",
                                            "href":"ClobEraseOverloads.html#GUID-0954B63D-9AF9-4A82-B2A7-AFAC192C23EE"
                                        },
                                        {
                                            "title":"Erase()",
                                            "href":"ClobErase1.html#GUID-2A9CC000-A389-44E6-8E46-188C5492B7BF"
                                        },
                                        {
                                            "title":"Erase(Int64, Int64)",
                                            "href":"ClobErase2.html#GUID-4E1CC7A5-45B0-4E40-AEC5-8316A441B216"
                                        },
                                        {
                                            "title":"Flush",
                                            "href":"ClobFlush.html#GUID-10B537A1-1755-4EA6-8BD2-E07D45728C25"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"ClobGetHashCode.html#GUID-B65B872B-C206-4EFF-AABC-AF20787A7531"
                                        },
                                        {
                                            "title":"IsEqual",
                                            "href":"ClobIsEqual.html#GUID-F2BF9508-5959-4306-B73F-6D3B7020C7F0"
                                        },
                                        {
                                            "title":"Read",
                                            "href":"ClobReadOverloads.html#GUID-BA377183-93A5-4566-AA87-48F97BF07CC3"
                                        },
                                        {
                                            "title":"Read(byte [ ], int, int)",
                                            "href":"ClobRead1.html#GUID-5B9EEA1E-0962-466E-AE1E-1B69BB05EF6F"
                                        },
                                        {
                                            "title":"Read(char [ ], int, int)",
                                            "href":"ClobRead2.html#GUID-059E50E0-B254-49E4-8D2F-7E62C3DEA591"
                                        },
                                        {
                                            "title":"ReadAsync",
                                            "href":"ClobReadAsyncOverloads.html#GUID-AFEBEDBA-0800-42FE-AF75-4F886167D22E"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int, CancellationToken)",
                                            "href":"ClobReadAsync1.html#GUID-2AB8F5AB-1914-4210-80F7-81109C9453E0"
                                        },
                                        {
                                            "title":"ReadAsync(byte[], int, int)",
                                            "href":"ClobReadAsync2.html#GUID-19F4E7C1-94F2-4470-8552-812BFC84DB61"
                                        },
                                        {
                                            "title":"ReadAsync(char[], int, int)",
                                            "href":"ClobReadAsync3.html#GUID-C6C2BDB9-0972-41C4-AC62-6347E2999CCE"
                                        },
                                        {
                                            "title":"ReadAsync(char[], int, int, CancellationToken)",
                                            "href":"ClobReadAsync4.html#GUID-85DBDC83-EA45-425F-B66D-C688D2D96767"
                                        },
                                        {
                                            "title":"Search",
                                            "href":"ClobSearchOverloads.html#GUID-261C4C0E-EE0C-4661-A3A1-6E817442CA6E"
                                        },
                                        {
                                            "title":"Search(byte[ ], Int64, Int64)",
                                            "href":"ClobSearch1.html#GUID-84092724-48F5-4D2C-89A6-8F9813CDF8EC"
                                        },
                                        {
                                            "title":"Search(char[ ], Int64, Int64)",
                                            "href":"ClobSearch2.html#GUID-6DC1FC94-06A8-4AD0-98AF-A84A941D0820"
                                        },
                                        {
                                            "title":"Seek",
                                            "href":"ClobSeek.html#GUID-3C592C50-832C-4B8B-BAB7-ED63CE89FA58"
                                        },
                                        {
                                            "title":"SetLength",
                                            "href":"ClobSetLength.html#GUID-2CA28695-7484-4CD2-84C8-0F2528CD0500"
                                        },
                                        {
                                            "title":"Write",
                                            "href":"ClobWriteOverloads.html#GUID-FDF466C2-A52B-4F63-AA02-02A79DFB3FE1"
                                        },
                                        {
                                            "title":"WriteAsync",
                                            "href":"ClobWriteAsyncOverloads.html#GUID-8BC37ABD-A33A-46B0-BF41-E67D13F7AB13"
                                        },
                                        {
                                            "title":"WriteAsync(byte[], int, int)",
                                            "href":"ClobWriteAsync1.html#GUID-E7ACB1E6-DA28-41D5-8984-91873243E16D"
                                        },
                                        {
                                            "title":"WriteAsync(byte[], int, int, CancellationToken)",
                                            "href":"ClobWriteAsync2.html#GUID-08CFE48B-B6EE-41D4-96DD-047FBABD21FC"
                                        },
                                        {
                                            "title":"WriteAsync(char[], int, int)",
                                            "href":"ClobWriteAsync3.html#GUID-120111DE-57DC-4982-BDF7-5BAD1A693480"
                                        },
                                        {
                                            "title":"WriteAsync(char[], int, int, CancellationToken)",
                                            "href":"ClobWriteAsync4.html#GUID-13DF14B6-19BB-4E5D-B581-91BF136114F5"
                                        },
                                        {
                                            "title":"Write(byte[ ], int, int)",
                                            "href":"ClobWrite1.html#GUID-FBAA4D06-7396-465E-85BC-EC400ECA63CE"
                                        },
                                        {
                                            "title":"Write(char[ ], int, int)",
                                            "href":"ClobWrite2.html#GUID-51DD68BF-5344-4545-B1F5-6B294C32AF7C"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleRefCursor Class",
                            "href":"OracleRefCursorClass.html#GUID-AE638391-C3A0-4C97-AF73-DF1DD0443571",
                            "topics":[
                                {
                                    "title":"OracleRefCursor Members",
                                    "href":"RefCursorMembers.html#GUID-1FC9CF9B-D75F-4B79-A66D-A452F6784364"
                                },
                                {
                                    "title":"OracleRefCursor Static Methods",
                                    "href":"RefcursorStaticMethods.html#GUID-58BA9DBB-5A51-4E84-B165-CF5500205822"
                                },
                                {
                                    "title":"OracleRefCursor Static Fields",
                                    "href":"RefcursorStaticFields.html#GUID-765C879A-36A9-4FF5-93EB-E9294656D325",
                                    "topics":[
                                        {
                                            "title":"Null",
                                            "href":"RefcursorStaticFieldNull.html#GUID-61846B6E-0665-431C-B670-63447F3A2289"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRefCursor Properties",
                                    "href":"RefcursorProperties.html#GUID-48AD2A1B-F964-4B1F-86EC-521CE11BDEB4",
                                    "topics":[
                                        {
                                            "title":"Connection",
                                            "href":"RefcursorConnection.html#GUID-9725B6BE-A70A-4C62-B5CB-224BAA9656FF"
                                        },
                                        {
                                            "title":"FetchSize",
                                            "href":"RefcursorFetchSize.html#GUID-6C614156-2682-4999-87F9-412672DF9D3F"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"RefcursorIsNull.html#GUID-C3B533D3-2F31-438F-AB11-2949E229638D"
                                        },
                                        {
                                            "title":"RowSize",
                                            "href":"RefcursorRowSize.html#GUID-79927980-261C-43D7-B889-D7E711454EA7"
                                        },
                                        {
                                            "title":"RowsToFetchPerRoundTrip",
                                            "href":"RefCursorRowsToFetchPerRoundTrip.html#GUID-ACB1BE96-2DCD-4BDD-8F7E-27499D7AFD64"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRefCursor Instance Methods",
                                    "href":"RefcursorInstanceMethods.html#GUID-1B3919DD-D551-403C-BB98-64B4A331FD75",
                                    "topics":[
                                        {
                                            "title":"Dispose",
                                            "href":"RefcursorDispose.html#GUID-E9ABB373-0C55-45A7-82D5-B91C7AECC435"
                                        },
                                        {
                                            "title":"GetDataReader",
                                            "href":"RefcursorGetDataReader.html#GUID-14788BE1-1A99-435F-8C05-6E468434190C"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Oracle Data Provider for .NET Types Structures",
                    "href":"types-structures.html#GUID-2F1F5E21-A982-49F4-9ED0-4762A59C6FCD",
                    "topics":[
                        {
                            "title":"OracleBinary Structure",
                            "href":"OracleBinaryStructure.html#GUID-D9D05444-46C2-4DB1-AC12-2D3BBF74EF31",
                            "topics":[
                                {
                                    "title":"OracleBinary Members",
                                    "href":"BinaryMembers.html#GUID-ACF4134C-7CDB-47E4-B384-7A3D815D131E"
                                },
                                {
                                    "title":"OracleBinary Constructor",
                                    "href":"BinaryCtor.html#GUID-BF89FDA7-24A9-4C94-A4C7-E67A6CB7AF3E"
                                },
                                {
                                    "title":"OracleBinary Static Fields",
                                    "href":"BinaryStaticFields.html#GUID-361329D4-3EFA-4B3F-BBF1-DCAC2F81A16F",
                                    "topics":[
                                        {
                                            "title":"Null",
                                            "href":"BinaryNull.html#GUID-EA5CCA30-9533-4D45-9369-D85F57AA1819"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBinary Static Methods",
                                    "href":"BinaryStaticMethods.html#GUID-9E3366CF-D3EF-4E09-AA9A-0EACD38D9565",
                                    "topics":[
                                        {
                                            "title":"Concat",
                                            "href":"BinaryConcat.html#GUID-3AF83A88-D897-4256-AC05-D09C4545347D"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"BinaryEqualsStatic.html#GUID-07798F3F-02E8-4400-B58C-8B5795F0A409"
                                        },
                                        {
                                            "title":"GetXsdType",
                                            "href":"BinaryGetXsdType.html#GUID-8D6159B5-09AF-46C7-A7A6-C70E23AB8E4D"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"BinaryGreaterThan.html#GUID-0D0C675C-610A-4F7A-B463-6689E2FA8ACF"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"BinaryGreaterThanOrEqual.html#GUID-6B481708-7356-49EF-A340-DA9A0F8A435A"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"BinaryLessThan.html#GUID-74C614FE-FA49-4863-A928-DF68A31665D9"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"BinaryLessThanOrEqual.html#GUID-4B225835-FD66-496F-B976-038C769FC2EE"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"BinaryNotEquals.html#GUID-CF1A939C-5C98-44CA-BEF2-9E15B51FB8C0"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBinary Static Operators",
                                    "href":"BinaryStaticOperators.html#GUID-3B6A0B9A-BE7A-4A86-897A-BF25AE2031BF",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"BinaryoperatorPlus.html#GUID-676D199B-2B9E-4094-ACAB-36509655F4C7"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"Binaryoperatorequalsequals.html#GUID-9C608C54-6983-469F-96D2-C9618FD32EC0"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"BinaryoperatorGT.html#GUID-D9658686-087F-47E8-AF39-619EA4871BF3"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"BinaryoperatorGTequals.html#GUID-014F96A6-96F5-4527-89C3-5F6952E86759"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"BinaryoperatorNotEqual.html#GUID-E5FF4DB5-BA3F-49CF-85DA-400684F2BD9D"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"BinaryoperatorLT.html#GUID-917D4EDA-D730-4E48-803A-4AB8852DF388"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"BinaryoperatorLTequals.html#GUID-7EE68D2C-4D37-46F8-A1EB-C278AF1DD54F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBinary Static Type Conversion Operators",
                                    "href":"BinaryStaticTypeConversionOperators.html#GUID-D1784E38-E97B-45EB-BDDE-1214B01BFFDC",
                                    "topics":[
                                        {
                                            "title":"explicit operator byte[ ]",
                                            "href":"Binaryexplicitoperatorbyte.html#GUID-D6A4CCAF-3367-44B1-8F40-44141B8142D8"
                                        },
                                        {
                                            "title":"implicit operator OracleBinary",
                                            "href":"BinaryimplicitoperatorOracleBinary.html#GUID-E5FD3D4A-F5ED-471B-9314-11FAD5CFA0D8"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBinary Properties",
                                    "href":"BinaryProperties.html#GUID-10D9382F-E2D2-4B19-ADFE-9B9D289A5617",
                                    "topics":[
                                        {
                                            "title":"IsNull",
                                            "href":"BinaryIsNull.html#GUID-1BDC8112-81EB-442B-8272-8AB7908EE6D7"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"BinaryItem.html#GUID-F7B72186-67B0-4404-951C-5486E9D60601"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"BinaryLength.html#GUID-CC217C07-AF41-494E-B39A-04DC6381B8A5"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"BinaryValue.html#GUID-6899AC90-A6A1-449F-AD67-EFBEADC35216"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBinary Instance Methods",
                                    "href":"BinaryInstanceMethods.html#GUID-0AFCCD83-0A98-4164-A9E0-E646610C5D23",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"BinaryCompareTo.html#GUID-B49F2258-03B9-45E0-917F-8CDB7DDE79F0"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"BinaryEquals.html#GUID-95484D45-2E6B-452E-A701-71F73AE2D01F"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"BinaryGetHashCode.html#GUID-247FF25F-9DC8-4C2D-9299-AB0CA907E263"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"BinaryToString.html#GUID-EB6B7403-D2A9-465B-8CBB-3DCC1B31E806"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleBoolean Structure",
                            "href":"OracleBooleanStructure.html#GUID-B5B5ACB7-14A5-43D5-B8A9-7D0046D40E2E",
                            "topics":[
                                {
                                    "title":"OracleBoolean Members",
                                    "href":"BooleanMembers.html#GUID-63B89CA7-C35F-4F26-8007-77C72118B49F"
                                },
                                {
                                    "title":"OracleBoolean Constructors",
                                    "href":"BooleanCtors.html#GUID-685728E0-DB85-49A2-8D6E-FA1068085BC1",
                                    "topics":[
                                        {
                                            "title":"OracleBoolean(bool)",
                                            "href":"BooleanCtor1.html#GUID-B17DEF46-AEAB-41CD-B8C5-C4A4D7CC770B"
                                        },
                                        {
                                            "title":"OracleBoolean(int)",
                                            "href":"BooleanCtor2.html#GUID-52B2EC75-6B08-49BC-A486-48002A72D9CD"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Static Fields",
                                    "href":"BooleanStaticFields.html#GUID-4EE678CA-3731-4356-AB53-D31EFF45C692",
                                    "topics":[
                                        {
                                            "title":"False",
                                            "href":"BooleanFalse.html#GUID-7FBA5328-9FB9-4D55-8400-73ADD488076D"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"BooleanNull.html#GUID-CF48FAFC-E2B2-40BA-9642-9695F17398B5"
                                        },
                                        {
                                            "title":"One",
                                            "href":"BooleanOne.html#GUID-6DEA2ACF-5D59-470A-BD19-9B20C3023D1E"
                                        },
                                        {
                                            "title":"True",
                                            "href":"BooleanTrue.html#GUID-A1A25020-B90A-4EB9-8675-DCC83368DE54"
                                        },
                                        {
                                            "title":"Zero",
                                            "href":"BooleanZero.html#GUID-D1701D6C-641D-4A53-9FF7-6BD3E0535EFF"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Static Methods",
                                    "href":"BooleanStaticMethods.html#GUID-264B1069-B5B9-4A17-8356-77EBF7BE8663",
                                    "topics":[
                                        {
                                            "title":"And",
                                            "href":"BooleanAnd.html#GUID-8907CA35-184D-494A-A776-6CC67304E3AE"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"BooleanEquals.html#GUID-7C3A7EEA-56AC-4A0E-8912-92243226022C"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"BooleanGreaterThan.html#GUID-A68B5D01-8B7D-4412-938C-224E94815AE1"
                                        },
                                        {
                                            "title":"GreaterThanOrEquals",
                                            "href":"BooleanGreaterThanOrEquals.html#GUID-1510BE4C-F119-425B-8558-A3EB81ABB0AF"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"BooleanLessThan.html#GUID-F314B351-00A6-4D2A-B3F6-5A451834E8D2"
                                        },
                                        {
                                            "title":"LessThanOrEquals",
                                            "href":"BooleanLessThanOrEquals.html#GUID-8913F92A-C488-409A-87E7-70EF4C587AD5"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"BooleanNotEquals.html#GUID-FEE41802-987A-4F23-9B87-4D33D897E803"
                                        },
                                        {
                                            "title":"OnesComplement",
                                            "href":"BooleanOnesComplement.html#GUID-4AF06757-CCC2-4710-A067-11E1D0EB620D"
                                        },
                                        {
                                            "title":"Or",
                                            "href":"BooleanOr.html#GUID-1DEC6F5F-9CD7-4EB0-8EB6-5C4938D6EAF2"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"BooleanParse.html#GUID-64E842D9-6A36-4447-9CD1-919F8C27F974"
                                        },
                                        {
                                            "title":"Xor",
                                            "href":"BooleanXor.html#GUID-2A8CEB10-8708-44A5-9CC5-2CDBC824F16A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Static Operators",
                                    "href":"BooleanStaticOperators.html#GUID-5383BCF7-B941-4EB2-BBA6-D5A2A3BFC1E4",
                                    "topics":[
                                        {
                                            "title":"operator >",
                                            "href":"BooleanoperatorGT.html#GUID-6761BFB1-B85D-4E6E-BFCA-449836CD69C4"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"BooleanoperatorGTequals.html#GUID-60BA1F33-F957-43FC-9568-06DCDF01FE52"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"BooleanoperatorLT.html#GUID-F8E45BF6-7796-4F7E-BC1F-B33BEAA94C06"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"BooleanoperatorLTequals.html#GUID-D987B48C-C77A-4117-9DD2-DAD3BE1C95FB"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"Booleanoperatorequalsequals.html#GUID-82409B42-94E3-47F5-9DCA-8547C487BEE3"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"BooleanoperatorNotEqual.html#GUID-19636A0A-1FB6-49AA-B1F0-467F224A6A88"
                                        },
                                        {
                                            "title":"operator !",
                                            "href":"BooleanoperatorNot.html#GUID-817E9D2B-3971-4169-97B1-52641C8221E7"
                                        },
                                        {
                                            "title":"operator ~",
                                            "href":"BooleanoperatorTILDE.html#GUID-5DCD4F9D-1481-42EF-BFA0-5173C35A911D"
                                        },
                                        {
                                            "title":"operator false",
                                            "href":"Booleanoperatorfalse.html#GUID-3E6DFF4E-5A82-4E9F-B8FC-77C738520631"
                                        },
                                        {
                                            "title":"operator true",
                                            "href":"Booleanoperatortrue.html#GUID-B22CC6DD-065A-431D-831D-EFE25360E901"
                                        },
                                        {
                                            "title":"operator &",
                                            "href":"BooleanoperatorAMP.html#GUID-1296C7A4-638A-4869-B28E-D1616BCE6820"
                                        },
                                        {
                                            "title":"operator |",
                                            "href":"BooleanoperatorPIPE.html#GUID-5984DDB2-2386-4E70-A98E-0B3F257607C6"
                                        },
                                        {
                                            "title":"operator ^",
                                            "href":"BooleanoperatorCARET.html#GUID-D42D2E6F-CBEC-4CDD-88D3-E3FF058F449C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Static Type Conversions",
                                    "href":"BooleanStaticTypeConversions.html#GUID-CD7E1F7F-00E8-4703-9C41-0D998DED7F29",
                                    "topics":[
                                        {
                                            "title":"implicit operator OracleBoolean",
                                            "href":"BooleanimpilictoperatorOracleBoolean.html#GUID-3B0EF0B8-4613-4159-80EE-F3A499E2A1BF"
                                        },
                                        {
                                            "title":"explicit operator bool",
                                            "href":"Booleanexpilictoperatorbool.html#GUID-C353A5CE-86E5-40EE-B28F-6DB5B6753EA9"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean",
                                            "href":"BooleanexpilictoperatorOracleBooleanOverloads.html#GUID-1CACAC2A-34AE-41E2-BF7A-5B597A482061"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(byte)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash1.html#GUID-431BA6AC-D236-460B-A9E1-51169D4E5E30"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(Decimal)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash2.html#GUID-BA3C2729-F0BA-4DC2-AE42-34759FC04555"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(Double)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash3.html#GUID-06FB649D-C0D7-47D8-8727-8FF214573BC8"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(Int16)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash4.html#GUID-C4B4B9A6-BE4C-452C-9AB9-4D73E91B0E3E"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(int)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash5.html#GUID-8768ADA7-48D6-45AB-8A42-3462F420D704"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(Int64)",
                                            "href":"BooleanexplicitoperatorOracleBooleandDash6.html#GUID-2FAE2C93-8934-4010-9ED7-F6EBC51D3D41"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(Single)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash7.html#GUID-E5DA8E9A-F91E-421B-ACB9-BCE7A3EC52AF"
                                        },
                                        {
                                            "title":"explicit operator OracleBoolean(String)",
                                            "href":"BooleanexplicitoperatorOracleBooleanDash8.html#GUID-9BAEF5D9-7FDA-4103-B2CB-9040F8591D9C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Properties",
                                    "href":"BooleanProperties.html#GUID-9240BC7E-18F7-46CE-A5F1-FC6C086583AB",
                                    "topics":[
                                        {
                                            "title":"ByteValue",
                                            "href":"BooleanByteValue.html#GUID-B5E2AAD9-02A2-4846-86A7-941ABD2DC2AB"
                                        },
                                        {
                                            "title":"IsFalse",
                                            "href":"BooleanIsFalse.html#GUID-0AA64BC7-295C-437D-9CCA-D33F88220992"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"BooleanIsNull.html#GUID-6BC8009B-B419-4F83-B809-A9ABA09464EE"
                                        },
                                        {
                                            "title":"IsTrue",
                                            "href":"BooleanIsTrue.html#GUID-A01C71FF-0437-42A7-8EEB-5850DB8E73D2"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"BooleanValue.html#GUID-4A51744C-18C5-4BFC-88BF-9A8A5E70B301"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBoolean Instance Methods",
                                    "href":"BooleanInstanceMethods.html#GUID-E9BAE0C0-01A1-46E6-BF4A-1738917F70C6",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"BooleanCompareTo.html#GUID-07E8656E-5315-4509-9440-BCA4978708AF"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"BooleanInstanceEquals.html#GUID-999FFA70-9C2F-40E5-B48E-7353431F5057"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"BooleanGetHashCode.html#GUID-7904A407-5249-4FE3-ACA7-040D23C856C5"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"BooleanToString.html#GUID-1984A4F6-F7AB-4BBD-8507-88A8CA2020CE"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDate Structure",
                            "href":"OracleDateStructure.html#GUID-F00D1B42-4338-4971-A47F-9DF94E16221C",
                            "topics":[
                                {
                                    "title":"OracleDate Members",
                                    "href":"DateMembers.html#GUID-D1A850B6-904D-48EE-9E2B-A918B0B336D7"
                                },
                                {
                                    "title":"OracleDate Constructors",
                                    "href":"DateCtors.html#GUID-0D27D4CE-D9E6-407B-A738-1372BB81C010",
                                    "topics":[
                                        {
                                            "title":"OracleDate(DateTime)",
                                            "href":"DateCtor1.html#GUID-6D57882B-0198-4907-8A14-E079DD60C82E"
                                        },
                                        {
                                            "title":"OracleDate(string)",
                                            "href":"DateCtor2.html#GUID-B254E0AC-6114-4773-8364-DF2829428952"
                                        },
                                        {
                                            "title":"OracleDate(int, int, int)",
                                            "href":"DateCtor3.html#GUID-5E606F05-2C64-4996-AEB2-8CA328D370A2"
                                        },
                                        {
                                            "title":"OracleDate(int, int, int, int, int, int)",
                                            "href":"DateCtor4.html#GUID-12D5C999-ED63-430A-A929-45160CA53C9E"
                                        },
                                        {
                                            "title":"OracleDate(byte [ ])",
                                            "href":"DateCtor5.html#GUID-9E08D09D-C9F8-4D2A-824B-6F94718D09A6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Static Fields",
                                    "href":"DateStaticFields.html#GUID-72136F4B-6DEE-4861-9BD0-599867BEEB01",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"DateMaxValue.html#GUID-70920656-4C96-45E5-A094-1DD5001178A0"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"DateMinValue.html#GUID-0B293C16-38AC-4FAC-843D-F81F75D86621"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"DateNull.html#GUID-26810D49-21ED-4EA5-8063-986221DFFAA7"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Static Methods",
                                    "href":"DateStaticMethods.html#GUID-28E63A6F-740A-4FA6-9706-98EAFEEC5DE5",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"DateEqualsStatic.html#GUID-5230843E-A52F-4B70-A4A7-773445E51270"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"DateGreaterThan.html#GUID-C8BEDC9B-C8E1-48E1-B7EC-9A42EA15F653"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"DateGreaterThanOrEqual.html#GUID-6A4998B7-ADB3-44F0-83FB-61577E3E554E"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"DateLessThan.html#GUID-708CB9FC-AF05-4FC3-B62C-8EEFF30D0181"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"DateLessThanOrEqual.html#GUID-93905AF5-4B0A-40D3-A5B4-DABCA304AE15"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"DateNotEquals.html#GUID-64785C2B-03F2-4B0F-AC32-2871B05ED329"
                                        },
                                        {
                                            "title":"GetSysDate",
                                            "href":"DateGetSysDate.html#GUID-3C07E232-035D-4158-947D-899EE134F8CF"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"DateParse.html#GUID-920CBFFE-BB99-4DCC-A400-832F9637A62D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Static Operators",
                                    "href":"DateStaticOperators.html#GUID-4A74CD1F-A42D-4EE3-BAA3-5D45319604F7",
                                    "topics":[
                                        {
                                            "title":"operator ==",
                                            "href":"Dateoperatorequalsequals.html#GUID-B84480D8-CF5B-42E3-BA93-6512B1AB2161"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"DateoperatorGT.html#GUID-EA6F2F6A-DC75-4703-AF8B-98FAA0FEC8F3"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"DateoperatorGTequals.html#GUID-24E9B699-32FF-4AA9-872C-6D988BAFB0B1"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"DateoperatorNotEqual.html#GUID-8E71175D-AB4D-4D4B-8E59-57112953E39C"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"DateoperatorLT.html#GUID-48F323C6-A481-4C5D-934C-B05785C0B7D7"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"DateoperatorLTequals.html#GUID-45602A57-0ED5-4293-981E-298C9BAF092E"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Static Type Conversions",
                                    "href":"DateStaticTypeConversions.html#GUID-9662E061-5FDD-45EF-9696-6A285EB22B11",
                                    "topics":[
                                        {
                                            "title":"explicit operator DateTime",
                                            "href":"DateexplicitoperatorDateTime.html#GUID-A4DF3F55-7A3A-46E7-A29D-B401C2266D46"
                                        },
                                        {
                                            "title":"explicit operator OracleDate",
                                            "href":"DateexpilictoperatorOracleDateOverloads.html#GUID-FED70051-8D51-4A9F-B785-1E4DB4CA6831"
                                        },
                                        {
                                            "title":"explicit operator OracleDate(DateTime)",
                                            "href":"DateDateexpilictoperatorOracleDate1.html#GUID-67B2DEAF-614B-42B4-BD43-ACA143F1C1E8"
                                        },
                                        {
                                            "title":"explicit operator OracleDate(OracleTimeStamp)",
                                            "href":"DateDateexpilictoperatorOracleDate2.html#GUID-102C6D8A-0125-471B-8952-89F2F0CE9C8A"
                                        },
                                        {
                                            "title":"explicit operator OracleDate(string)",
                                            "href":"DateDateexpilictoperatorOracleDate3.html#GUID-EC366E1E-8658-4D3E-8B2B-9EF4DFB2C143"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Properties",
                                    "href":"DateProperties.html#GUID-5176CEE7-3525-4284-8D7F-A41E8805DD11",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"DateBinData.html#GUID-2112FBF7-3C56-421F-AE77-0ACEB8CEE932"
                                        },
                                        {
                                            "title":"Day",
                                            "href":"DateDay.html#GUID-5F2E6A83-163C-4067-8E1E-9D6E002A76D8"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"DateIsNull.html#GUID-8AE21CE1-9994-4320-B002-F67AE464BECA"
                                        },
                                        {
                                            "title":"Hour",
                                            "href":"DateHour.html#GUID-04D4D9CA-3A7B-4A4D-9F17-9B3719577CE7"
                                        },
                                        {
                                            "title":"Minute",
                                            "href":"DateMinute.html#GUID-73C4F83F-548E-493A-8402-CEAAF8711617"
                                        },
                                        {
                                            "title":"Month",
                                            "href":"DateMonth.html#GUID-69A93C90-D185-4F41-B148-1C4C5C7D0A3A"
                                        },
                                        {
                                            "title":"Second",
                                            "href":"DateSecond.html#GUID-9DD462D2-CC1A-4F9E-9CD7-67FA33CEE2F3"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"DateValue.html#GUID-4BEE7B4F-AC2A-4883-8322-86D773EAD6A6"
                                        },
                                        {
                                            "title":"Year",
                                            "href":"DateYear.html#GUID-54F162B4-C4E2-445A-840D-F15E819F2649"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDate Methods",
                                    "href":"DateMethods.html#GUID-2F49014E-35F8-4BDD-91D1-F7DE462C4333",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"DateCompareTo.html#GUID-D543DD33-C857-47DE-9B93-18472783E8FB"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"DateEquals.html#GUID-AAC0AFE9-09E1-41B0-908E-6B8DD179936F"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"DateGetHashCode.html#GUID-D3BEC9FA-C674-48B4-92AB-952FECFD06C2"
                                        },
                                        {
                                            "title":"GetDaysBetween",
                                            "href":"DateGetDaysBetween.html#GUID-ACD61F84-FA2D-4D1B-8BC1-8DD3A4C88085"
                                        },
                                        {
                                            "title":"ToOracleTimeStamp",
                                            "href":"DateToOracleTimeStamp.html#GUID-4ED33162-C215-4171-9A69-9839784F1695"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"DateToString.html#GUID-4161E3E2-4888-45D4-B1D0-00BC1F6A2CFC"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDecimal Structure",
                            "href":"OracleDecimalStructure.html#GUID-671F6F1D-3C9A-40CC-BB0B-F84DF63766D3",
                            "topics":[
                                {
                                    "title":"OracleDecimal Members",
                                    "href":"DecimalMembers.html#GUID-524EC230-1A25-4928-BD97-D64E40D211FA"
                                },
                                {
                                    "title":"OracleDecimal Constructors",
                                    "href":"DecimalCtors.html#GUID-15378B68-1C70-48FB-938E-E659D1CC6881",
                                    "topics":[
                                        {
                                            "title":"OracleDecimal(byte [ ])",
                                            "href":"DecimalCtor1.html#GUID-624735CE-2D0B-4FB0-89BE-EC7ADE9E2553"
                                        },
                                        {
                                            "title":"OracleDecimal(decimal)",
                                            "href":"DecimalCtor2.html#GUID-690DA0C7-9A60-47E6-841A-7FF479DFD5CC"
                                        },
                                        {
                                            "title":"OracleDecimal(double)",
                                            "href":"DecimalCtor3.html#GUID-C1629CAA-225C-4893-B0AB-8C129CCEB211"
                                        },
                                        {
                                            "title":"OracleDecimal(int)",
                                            "href":"DecimalCtor4.html#GUID-05BB11F4-1F1D-4D73-A09C-88EBF0491145"
                                        },
                                        {
                                            "title":"OracleDecimal(float)",
                                            "href":"DecimalCtor8.html#GUID-7267BDD0-BD4C-476B-90E9-68AD03BD5C2D"
                                        },
                                        {
                                            "title":"OracleDecimal(long)",
                                            "href":"DecimalCtor5.html#GUID-BC73CDF7-87AA-4119-B250-F4900E7FF5EC"
                                        },
                                        {
                                            "title":"OracleDecimal(string)",
                                            "href":"DecimalCtor6.html#GUID-C0152391-D5FE-48EB-B974-088F404B2276"
                                        },
                                        {
                                            "title":"OracleDecimal(string, string)",
                                            "href":"DecimalCtor7.html#GUID-7906D85C-0792-45D8-A5AA-4894E2404DE3"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static Fields",
                                    "href":"DecimalStaticFields.html#GUID-C5E45676-F02D-4CEE-96DC-AE81B8440BF0",
                                    "topics":[
                                        {
                                            "title":"MaxPrecision",
                                            "href":"DecimalMaxPrecision.html#GUID-3F5EEB7C-962E-46C2-A7F1-3233A2041F4B"
                                        },
                                        {
                                            "title":"MaxScale",
                                            "href":"DecimalMaxScale.html#GUID-6E96973D-884F-4FCB-AEE1-41F817FDA27C"
                                        },
                                        {
                                            "title":"MaxValue",
                                            "href":"DecimalMaxValue.html#GUID-7702C1AF-7A4D-4E65-8842-339EA86DDBF0"
                                        },
                                        {
                                            "title":"MinScale",
                                            "href":"DecimalMinScale.html#GUID-71D125EA-5FDF-43DA-B10A-58CAEC2BD34C"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"DecimalMinValue.html#GUID-C2C883CA-124A-4472-B8A8-ACB381F0A3C8"
                                        },
                                        {
                                            "title":"NegativeOne",
                                            "href":"DecimalNegativeOne.html#GUID-7675C367-ADF6-4B84-9895-6082877EA54D"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"DecimalNull.html#GUID-62B158C4-6225-445F-BD5D-610ADD339C01"
                                        },
                                        {
                                            "title":"One",
                                            "href":"DecimalOne.html#GUID-ED1D76DC-5F40-4224-A9DB-89441954DD44"
                                        },
                                        {
                                            "title":"Pi",
                                            "href":"DecimalPi.html#GUID-1D4B86B5-F8E1-443B-9D06-CE6E570215E7"
                                        },
                                        {
                                            "title":"Zero",
                                            "href":"DecimalZero.html#GUID-FB3D7A4C-0585-43F1-8667-B40692695F65"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static (Comparison) Methods",
                                    "href":"DecimalStaticComparisonMethods.html#GUID-3F0D77BC-492F-4A9C-A70A-557080DEC62F",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"DecimalEquals.html#GUID-332CD71E-A7B4-4D16-9CB0-470E48905A91"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"DecimalGreaterThan.html#GUID-AF2CE195-E2FF-4634-A1D8-43C3E2DC8750"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"DecimalGreaterThanOrEqual.html#GUID-AD457645-2151-4E21-AD61-41B37F001411"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"DecimalLessThan.html#GUID-45346517-6DE4-49D9-B599-AB5E3A00234D"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"DecimalLessThanOrEqual.html#GUID-E8F2F66B-BD90-4F50-A17C-1BD5D22DF542"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"DecimalNotEqual.html#GUID-79F9F41D-E2DC-4341-B5C6-2D2881E8B415"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static (Manipulation) Methods",
                                    "href":"DecimalStaticManipulationMethods.html#GUID-20285294-EC6A-4D60-9B06-7F64CACF0C28",
                                    "topics":[
                                        {
                                            "title":"Abs",
                                            "href":"DecimalAbs.html#GUID-8544BEA9-3E76-4696-8EE4-AF2E299CDA96"
                                        },
                                        {
                                            "title":"Add",
                                            "href":"DecimalAdd.html#GUID-5435979F-39BE-46E2-A489-0F5B98AD9A42"
                                        },
                                        {
                                            "title":"AdjustScale",
                                            "href":"DecimalAdjustScale.html#GUID-A143C4D0-CF70-4F98-BCA5-C7BEDD79ED56"
                                        },
                                        {
                                            "title":"Ceiling",
                                            "href":"DecimalCeiling.html#GUID-DD7E0708-A8D5-4FCB-8106-C45BE68F723C"
                                        },
                                        {
                                            "title":"ConvertToPrecScale",
                                            "href":"DecimalConvertToPrecScale.html#GUID-EFC9738C-ED78-475A-A9DD-2C7FD65AA40F"
                                        },
                                        {
                                            "title":"Divide",
                                            "href":"DecimalDivide.html#GUID-DC22ED53-342B-463D-9916-329602ED5BA3"
                                        },
                                        {
                                            "title":"Floor",
                                            "href":"DecimalFloor.html#GUID-77748F44-45CE-4F4D-9ABA-FECE4216C0B2"
                                        },
                                        {
                                            "title":"Max",
                                            "href":"DecimalMax.html#GUID-52FA4101-E592-4BD1-80F4-00FA0E760982"
                                        },
                                        {
                                            "title":"Min",
                                            "href":"DecimalMin.html#GUID-9EFF84A3-846E-4DF1-8160-8A2A27C0D5C1"
                                        },
                                        {
                                            "title":"Mod",
                                            "href":"DecimalMod.html#GUID-0A3808AE-56A6-4C7C-998F-387A3F5C16DD"
                                        },
                                        {
                                            "title":"Multiply",
                                            "href":"DecimalMultiply.html#GUID-D27D765E-05C8-4C25-95C6-2EA9BAC3A95E"
                                        },
                                        {
                                            "title":"Negate",
                                            "href":"DecimalNegate.html#GUID-E25D953A-2A87-4E5D-9566-CD60A18DEFCE"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"DecimalParse.html#GUID-C8EAB66F-EF11-415F-8BB8-9C5A90483190"
                                        },
                                        {
                                            "title":"Round",
                                            "href":"DecimalRound.html#GUID-5D2930E7-151F-4610-811E-E8938D39F839"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"DecimalSetPrecision.html#GUID-34E1C931-C295-4B9F-94BD-5FB6548A67EA"
                                        },
                                        {
                                            "title":"Shift",
                                            "href":"DecimalShift.html#GUID-FA6BCF35-6368-49C9-A04C-6577BF4D8888"
                                        },
                                        {
                                            "title":"Sign",
                                            "href":"DecimalSign.html#GUID-6E4E216F-9C0E-47E4-AEB6-BCDC08082054"
                                        },
                                        {
                                            "title":"Sqrt",
                                            "href":"DecimalSqrt.html#GUID-8D412361-B15C-4435-A66B-CC21F15B9AD1"
                                        },
                                        {
                                            "title":"Subtract",
                                            "href":"DecimalSubtract.html#GUID-30CCB46D-3361-4E88-B496-B517BC94C587"
                                        },
                                        {
                                            "title":"Truncate",
                                            "href":"DecimalTruncate.html#GUID-D845BF0A-1DB0-443B-8CB4-6A2D910F1A95"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static (Logarithmic) Methods",
                                    "href":"DecimalstaticLogarithmicMethods.html#GUID-2B6F1E7A-870E-4A48-847A-4E1F98993891",
                                    "topics":[
                                        {
                                            "title":"Exp",
                                            "href":"DecimalExp.html#GUID-C76354C2-DC67-452D-962C-4BEF67D3FC80"
                                        },
                                        {
                                            "title":"Log",
                                            "href":"DecimalLogOverloads.html#GUID-3BD8C15D-4517-4C6A-A31F-73F6ECD65819"
                                        },
                                        {
                                            "title":"Log(OracleDecimal)",
                                            "href":"DecimalLog1.html#GUID-1DDA2AEF-03D2-4299-A8FE-62687FC1AD69"
                                        },
                                        {
                                            "title":"Log(OracleDecimal, int)",
                                            "href":"DecimalLog2.html#GUID-50A4C448-0A1D-4D7F-A462-5A9137CE0C4D"
                                        },
                                        {
                                            "title":"Log(OracleDecimal, OracleDecimal)",
                                            "href":"DecimalLog3.html#GUID-0ADD7EED-87F1-472F-BA4A-3FB6433060B4"
                                        },
                                        {
                                            "title":"Pow",
                                            "href":"DecimalPowOverloads.html#GUID-771ED26F-7649-4AAC-804E-04B43ED42A9E"
                                        },
                                        {
                                            "title":"Pow(OracleDecimal, int)",
                                            "href":"DecimalPow1.html#GUID-0ECCDC4B-391C-4131-9F75-3A95B09C4403"
                                        },
                                        {
                                            "title":"Pow(OracleDecimal, OracleDecimal)",
                                            "href":"DecimalPow2.html#GUID-BCF2C0B9-21BD-4763-BECE-422CB11F48F5"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static (Trigonometric) Methods",
                                    "href":"DecimalStaticTrignometricMethods.html#GUID-60591351-B31A-4F80-9BFC-8FF424B6EEEA",
                                    "topics":[
                                        {
                                            "title":"Acos",
                                            "href":"DecimalAcos.html#GUID-C1F5BA65-182D-4538-BA77-950A53ABC70C"
                                        },
                                        {
                                            "title":"Asin",
                                            "href":"DecimalAsin.html#GUID-5282E380-9E0C-4152-9FDA-7FB1892617D1"
                                        },
                                        {
                                            "title":"Atan",
                                            "href":"DecimalAtan.html#GUID-0BAAAB43-20B4-48C0-BB17-4F3D53BA49D9"
                                        },
                                        {
                                            "title":"Atan2",
                                            "href":"DecimalAtan2.html#GUID-A8E0E14E-A90B-4D94-A564-1DFF842CFB6F"
                                        },
                                        {
                                            "title":"Cos",
                                            "href":"DecimalCos.html#GUID-E0ADA27C-70D5-4321-ADE6-C7FA93BC02A4"
                                        },
                                        {
                                            "title":"Sin",
                                            "href":"DecimalSin.html#GUID-22AF2995-FC09-4F0D-AF96-21074CF6B14C"
                                        },
                                        {
                                            "title":"Tan",
                                            "href":"DecimalTan.html#GUID-C88A4925-6D88-4871-9EE2-1CD2C769DB41"
                                        },
                                        {
                                            "title":"Cosh",
                                            "href":"DecimalCosh.html#GUID-1D04F5E6-28FD-4E04-9D71-7164DBD3C50C"
                                        },
                                        {
                                            "title":"Sinh",
                                            "href":"DecimalSinh.html#GUID-31E8375A-F2C3-47D9-B966-9BBCFDFA68C9"
                                        },
                                        {
                                            "title":"Tanh",
                                            "href":"DecimalTanh.html#GUID-3AF39583-04A6-44B7-99DF-C4416DF3173D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static (Comparison) Operators",
                                    "href":"DecimalStaticComparisonOperators.html#GUID-91BD7872-64E0-40BC-AA32-B0C555427F2D",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"DecimaloperatorPLUS.html#GUID-40792697-18E4-48C7-A989-0E18B7A5C77C"
                                        },
                                        {
                                            "title":"operator /",
                                            "href":"DecimaloperatorDV.html#GUID-3B419B8B-1CC6-4B77-810A-1C19A1499007"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"DecimalEQUALTO_EQUALTO.html#GUID-51A74FF5-C4D1-49ED-8742-AB8D6D38BECE"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"DecimaloperatorGT.html#GUID-152A661F-3FC0-4773-9975-24963E9ED4B9"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"DecimaloperatorGTequals.html#GUID-FE5CF65A-946F-4B14-A3E4-0D1D328631FC"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"DecimaloperatorEXCLAMATION_EQUALTO.html#GUID-2B339591-6149-4D42-8FA9-37D693360AC2"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"DecimaloperatorLT.html#GUID-ABF378D0-77F0-4F14-B8C0-DAF8AB432DCA"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"DecimaloperatorLTequals.html#GUID-DC37F079-F836-42A4-B005-02CA24821464"
                                        },
                                        {
                                            "title":"operator *",
                                            "href":"DecimaloperatorML.html#GUID-C833BB1F-A7A9-41CE-BDDD-E5B4F1190E6E"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"DecimaloperatorMinus1.html#GUID-B82A46FB-E36E-40E0-81C1-7C9CE5B58F1D"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"Decimaloperator2.html#GUID-34E7BA25-8B1D-481A-AB09-3F2E39194BDE"
                                        },
                                        {
                                            "title":"operator%",
                                            "href":"DecimaloperatorPERCENT.html#GUID-F245BFCC-5756-4382-A6F8-7BE65CAAC725"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static Operators (Conversion from .NET Type to OracleDecimal)",
                                    "href":"DecimalStaticOperatorsNetToDecimal.html#GUID-02EF2959-D3BC-4C4A-86E4-3F30073A5528",
                                    "topics":[
                                        {
                                            "title":"implicit operator OracleDecimal",
                                            "href":"DecimalimplicitoperatorOracleDecimalOverloads.html#GUID-82659251-AFFB-4535-BF1B-60FF50E6C40E"
                                        },
                                        {
                                            "title":"implicit operator OracleDecimal(decimal)",
                                            "href":"DecimalimplicitoperatorOracleDecimal1.html#GUID-190690FF-F6CF-4D53-B79F-A1E7C130E233"
                                        },
                                        {
                                            "title":"implicit operator OracleDecimal(int)",
                                            "href":"DecimalimplicitoperatorOracleDecimal2.html#GUID-BCA3643E-10B3-423C-84DE-1003D5389A5F"
                                        },
                                        {
                                            "title":"implicit operator OracleDecimal(long)",
                                            "href":"DecimalimplicitoperatorOracleDecimal3.html#GUID-5455A9E0-DF0C-4CEA-A0E4-34268332737D"
                                        },
                                        {
                                            "title":"explicit operator OracleDecimal",
                                            "href":"DecimalexplicitoperatorOracleDecimalOverloads.html#GUID-B64BAFFE-9037-43E3-8414-FA7BC503F714"
                                        },
                                        {
                                            "title":"explicit operator OracleDecimal(double)",
                                            "href":"DecimalexplicitoperatorOracleDecimal1.html#GUID-70C3BFD7-F26C-4D33-8344-47C059108BC6"
                                        },
                                        {
                                            "title":"explicit operator OracleDecimal(string)",
                                            "href":"DecimalexplicitoperatorOracleDecimal2.html#GUID-716E9B3C-F8D0-41C9-8E97-A8135B7E60DB"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Static Operators (Conversion from OracleDecimal to .NET)",
                                    "href":"DecimalStaticOperatorsOracleDecimalToNet.html#GUID-F65FBC7A-A1EE-412D-86E0-89BFC4F2C8F7",
                                    "topics":[
                                        {
                                            "title":"explicit operator byte",
                                            "href":"Decimalexplicitoperatorbyte.html#GUID-13350066-B5C2-4ABC-BE00-7CF93CD194F5"
                                        },
                                        {
                                            "title":"explicit operator decimal",
                                            "href":"Decimalexplicitoperatordecimal.html#GUID-9962D40D-757D-435D-B2AB-4773DC2CAAFF"
                                        },
                                        {
                                            "title":"explicit operator double",
                                            "href":"Decimalexplicitoperatordouble.html#GUID-08281841-CDD2-4A4B-AAA7-D0256217A99B"
                                        },
                                        {
                                            "title":"explicit operator short",
                                            "href":"Decimalexplicitoperatorshort.html#GUID-133800AF-3135-4422-B309-1B1F279FCF6D"
                                        },
                                        {
                                            "title":"explicit operator int",
                                            "href":"Decimalexplicitoperatorint.html#GUID-81766A04-E5CF-4AEC-B663-82EB472A8CBE"
                                        },
                                        {
                                            "title":"explicit operator long",
                                            "href":"Decimalexplicitoperatorlong.html#GUID-E1E40055-7882-4373-B198-4AF1B3C7253D"
                                        },
                                        {
                                            "title":"explicit operator float",
                                            "href":"Decimalexplicitoperatorfloat.html#GUID-9D6632B9-F1A7-4AAB-A54A-24ECAB927B07"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Properties",
                                    "href":"DecimalProperties.html#GUID-2356B39E-2D18-44EE-B645-4E3797373519",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"DecimalBinData.html#GUID-E21D8F84-0C84-4F24-B0BF-0442878DF326"
                                        },
                                        {
                                            "title":"Format",
                                            "href":"DecimalFormat.html#GUID-08DB80EB-5523-45B7-AC16-A26B7EBC347D"
                                        },
                                        {
                                            "title":"IsInt",
                                            "href":"DecimalIsInt.html#GUID-89454879-5325-437B-BAEE-14E323D9BC22"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"DecimalIsNull.html#GUID-6E10F60A-6B64-4D8C-9A73-011646649383"
                                        },
                                        {
                                            "title":"IsPositive",
                                            "href":"DecimalIsPositive.html#GUID-C119BE58-AFD4-45B4-8363-DE71759BF4B3"
                                        },
                                        {
                                            "title":"IsZero",
                                            "href":"DecimalIsZero.html#GUID-63FDE96A-14DF-43D7-B837-540B1975D646"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"DecimalValue.html#GUID-71484D47-B753-487E-B4A2-4323A8ADD623"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDecimal Instance Methods",
                                    "href":"DecimalInstanceMethods.html#GUID-C8C2A53A-CC2E-4112-835C-E681CAC1E99D",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"DecimalCompareTo.html#GUID-CCAB6529-9A3F-4873-B72B-414D077D3B68"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"DecimalEqualsInstance.html#GUID-0ED62888-34CF-4CF8-B927-0411AE12BE0C"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"DecimalGetHashCode.html#GUID-CFC6427B-5B0C-480B-8FE5-DF2E6A8B756D"
                                        },
                                        {
                                            "title":"ToByte",
                                            "href":"DecimalToByte.html#GUID-EA20A0BD-0FAE-488F-9C97-D385FBBDFDEF"
                                        },
                                        {
                                            "title":"ToDouble",
                                            "href":"DecimalToDouble.html#GUID-D4883FB3-3C54-48BF-B513-BB931B700F8E"
                                        },
                                        {
                                            "title":"ToInt16",
                                            "href":"DecimalToint16.html#GUID-CD460081-C84B-479D-B5D7-A31E1F31BB68"
                                        },
                                        {
                                            "title":"ToInt32",
                                            "href":"DecimalToInt32.html#GUID-5E82CDB0-2CA1-4AE8-9C93-65F47E57410E"
                                        },
                                        {
                                            "title":"ToInt64",
                                            "href":"DecimalToint64.html#GUID-50230CA7-B982-402C-924F-86B2B3D92CAA"
                                        },
                                        {
                                            "title":"ToSingle",
                                            "href":"DecimalToSingle.html#GUID-0BDA23E0-AFED-4F48-9D20-030C2598BD37"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"DecimalToString.html#GUID-54D780FE-43A1-4B1B-8773-8F2707225240"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleIntervalDS Structure",
                            "href":"OracleIntervalDSStructure.html#GUID-53F4E66C-7EB7-471C-8710-FF5DD64E7035",
                            "topics":[
                                {
                                    "title":"OracleIntervalDS Members",
                                    "href":"IntervalDSMembers.html#GUID-5EF0A7D7-7A22-40E7-8FDF-71045F8B1066"
                                },
                                {
                                    "title":"OracleIntervalDS Constructors",
                                    "href":"IntervalDSCtors.html#GUID-F368CD0E-CFA7-47EF-8085-0E3D67DB3C57",
                                    "topics":[
                                        {
                                            "title":"OracleIntervalDS(TimeSpan)",
                                            "href":"IntervalDSCtor1.html#GUID-ABA4335B-56B9-48F6-A535-6250681D0B6D"
                                        },
                                        {
                                            "title":"OracleIntervalDS(string)",
                                            "href":"IntervalDSCtor2.html#GUID-758284FD-36FB-47C0-AEA4-A152A15575AD"
                                        },
                                        {
                                            "title":"OracleIntervalDS(double)",
                                            "href":"IntervalDSCtor3.html#GUID-C05BE75E-5E61-4082-BCB2-5FECFD968FBC"
                                        },
                                        {
                                            "title":"OracleIntervalDS(int, int, int, int, double)",
                                            "href":"IntervalDSCtor4.html#GUID-B5A220B9-5742-43DF-BA35-09F6E7AC14B4"
                                        },
                                        {
                                            "title":"OracleIntervalDS(int, int, int, int, int)",
                                            "href":"IntervalDSCtor5.html#GUID-2D2EA3B3-3E14-4C08-BA4F-36CCD1E33B71"
                                        },
                                        {
                                            "title":"OracleIntervalDS(byte[ ])",
                                            "href":"IntervalDSCtor6.html#GUID-0CE0FFEA-A418-4DDC-B5F4-7CB5B1C8737F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Static Fields",
                                    "href":"IntervalDSStaticFields.html#GUID-F4DCB154-D578-44EA-8925-AA1F74120EFF",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"IntervalDSMaxValue.html#GUID-484F6B1B-AE53-4C0F-9C5D-63AE38631E40"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"IntervalDSMinValue.html#GUID-5735F461-5568-4B6A-B691-48B11C819FC6"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"IntervalDSNull.html#GUID-5BAE1CD9-A670-4766-97F8-0B79627BD9F5"
                                        },
                                        {
                                            "title":"Zero",
                                            "href":"IntervalDSZero.html#GUID-C506AE2E-B499-49DC-A89F-3EFC077870A1"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Static Methods",
                                    "href":"IntervalDSStaticMethods.html#GUID-4A5B73E3-9779-48CF-956B-4B459034404D",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"IntervalDSEqualsStatic.html#GUID-D004680F-987A-43BE-AEEF-0250A270EEDE"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"IntervalDSGreaterThan.html#GUID-EFECCCE9-1FCC-407B-A43C-DC482AB535BF"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"IntervalDSGreaterThanOrEqual.html#GUID-67820F89-4CE1-4C0B-8750-E3F5DFB0F31E"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"IntervalDSLessThan.html#GUID-244A543C-C4B4-41D2-ADDD-9CB31D98EC4A"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"IntervalDSLessThanOrEqual.html#GUID-13923802-BC03-4728-BE5F-927D9D77DC2E"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"IntervalDSNotEquals.html#GUID-240F06B3-C7DE-4A07-A62C-737CDD396A34"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"IntervalDSParse.html#GUID-CF6F3442-8B96-428B-9AEC-307BED6CB869"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"IntervalDSSetPrecision.html#GUID-BAD6C3E3-2366-424C-AD30-ADEE7D2B4A4F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Static Operators",
                                    "href":"IntervalDSStaticOperators.html#GUID-EF4BE928-D84A-4731-8477-9680C3D2E622",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"IntervalDSoperatorPLUS.html#GUID-889BEFE2-B049-42C3-8A90-2307665A173B"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"IntervalDSoperatorEQUAL_EQUAL.html#GUID-6E470BED-4A8E-4FF0-9F73-7AB43D5954B7"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"IntervalDSoperatorGT.html#GUID-BFAAB2BE-71A9-42A2-826A-3D52738AC522"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"IntervalDSoperatorGTequals.html#GUID-78B13F66-5C24-44AF-8623-2FD6A3409C6E"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"IntervalDSoperatorEXCLAMATION_EQUAL.html#GUID-A99188CF-54BD-4764-9ACA-82A636448F4F"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"IntervalDSoperatorLT.html#GUID-F8DACF91-78BC-48A0-979F-EDBBC5390FC8"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"IntervalDSoperatorLTequals.html#GUID-98BD2C89-F88F-4A6C-981B-C158423AF3A8"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"IntervalDSoperatorMinus1.html#GUID-EFD607CE-C0D3-46E5-8293-0A25103B6060"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"IntervalDSoperatorNegates2.html#GUID-8B382139-7D61-4D1B-BC50-8F129EF76F2E"
                                        },
                                        {
                                            "title":"operator *",
                                            "href":"IntervalDSoperatorML.html#GUID-3B2907C1-AA97-487C-8131-A925279672A5"
                                        },
                                        {
                                            "title":"operator /",
                                            "href":"IntervalDSoperatorDV.html#GUID-4C9728FC-2111-476F-B5AF-13FD4BA94EB7"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Type Conversions",
                                    "href":"IntervalDSTypeConversions.html#GUID-2ED546DE-5B5F-46F7-B0AE-30DAD3D591F9",
                                    "topics":[
                                        {
                                            "title":"explicit operator TimeSpan",
                                            "href":"IntervalDSexplicitoperatorTimeSpan.html#GUID-C8B08BD6-8FE5-4CD7-A443-47A2E4FC4AA9"
                                        },
                                        {
                                            "title":"explicit operator OracleIntervalDS",
                                            "href":"IntervalDSexplicitoperatorOracleIntervalDS.html#GUID-AFF2FC3B-BD05-4C14-ADC8-ADD0F1782338"
                                        },
                                        {
                                            "title":"implicit operator OracleIntervalDS",
                                            "href":"IntervalDSimplicitoperatorOracleIntervalDS.html#GUID-4546FE33-D11E-4BAE-ADEA-0BB351666D51"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Properties",
                                    "href":"IntervalDSProperties.html#GUID-AE05F569-1D6E-4CB1-9715-2B311D0B4005",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"IntervalDSBinData.html#GUID-37FAE822-887E-4A0F-A979-B197D8E1F12C"
                                        },
                                        {
                                            "title":"Days",
                                            "href":"IntervalDSDays.html#GUID-CBF02153-D8BC-4731-AEF7-DAD839C35059"
                                        },
                                        {
                                            "title":"Hours",
                                            "href":"IntervalDSHours.html#GUID-B522BBFA-DAC1-419E-8D03-59D7F2FC1912"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"IntervalDSIsNull.html#GUID-8587C2AF-ED78-49D8-9E1D-D00D8E3AF6DA"
                                        },
                                        {
                                            "title":"Milliseconds",
                                            "href":"IntervalDSMilliseconds.html#GUID-52F6CEA6-ACE4-45BB-B96F-7202FECBDADF"
                                        },
                                        {
                                            "title":"Minutes",
                                            "href":"IntervalDSMinutes.html#GUID-23576E7E-82F6-426E-BA9D-65E1BC783CE9"
                                        },
                                        {
                                            "title":"Nanoseconds",
                                            "href":"IntervalDSNanoseconds.html#GUID-419CC49E-194B-47A6-B73F-6D466C30041E"
                                        },
                                        {
                                            "title":"Seconds",
                                            "href":"IntervalDSSeconds.html#GUID-35B78916-B62B-4970-BCB7-E5F7B0437B21"
                                        },
                                        {
                                            "title":"TotalDays",
                                            "href":"IntervalDSTotalDays.html#GUID-8F78955A-B1F1-40D9-AA98-1DFAB480661F"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"IntervalDSValue.html#GUID-DD3ECBB4-3DBE-48BC-AA70-B4EA08A4FA9F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalDS Methods",
                                    "href":"IntervalDSMethods.html#GUID-E4DD14F5-1BBE-441F-B169-39B13D18D265",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"IntervalDSCompareTo.html#GUID-1B367B60-D402-4BFA-9A9A-6A75BC2AD865"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"IntervalDSEquals.html#GUID-6B74C178-1189-4C74-AD6C-3C563BA71DF2"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"IntervalDSGetHashCode.html#GUID-AFC6CA1B-A71E-498A-A7FB-134B0206150F"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"IntervalDSToString.html#GUID-C5850103-67B5-4B7F-A5D4-1A343A90D74D"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleIntervalYM Structure",
                            "href":"OracleIntervalYMStructure.html#GUID-C63DC193-8689-4817-B968-7FAB6CE67DE4",
                            "topics":[
                                {
                                    "title":"OracleIntervalYM Members",
                                    "href":"IntervalYMMembers.html#GUID-1376CB7D-A6E1-4D8C-8BA0-04523ED2A8DD"
                                },
                                {
                                    "title":"OracleIntervalYM Constructors",
                                    "href":"IntervalYMCtors.html#GUID-624E2F05-69A9-4075-B06C-E7086A2FCB5B",
                                    "topics":[
                                        {
                                            "title":"OracleIntervalYM(long)",
                                            "href":"IntervalYMCtor1.html#GUID-BB6424D2-56C1-49C3-9645-1C55F86B6B68"
                                        },
                                        {
                                            "title":"OracleIntervalYM(string)",
                                            "href":"IntervalYMCtor2.html#GUID-8989ACBD-ED26-48D7-AE1A-D3AE3EAB5978"
                                        },
                                        {
                                            "title":"OracleIntervalYM(double)",
                                            "href":"IntervalYMCtor3.html#GUID-9A6B433B-F627-43CB-8885-81656953325B"
                                        },
                                        {
                                            "title":"OracleIntervalYM(int, int)",
                                            "href":"IntervalYMCtor4.html#GUID-5BB9C0E8-62A4-41E0-96DD-457FC49D292A"
                                        },
                                        {
                                            "title":"OracleIntervalYM(byte[ ])",
                                            "href":"IntervalYMCtor5.html#GUID-BD1C3684-8731-4F72-95A2-2AB648AE7305"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Static Fields",
                                    "href":"IntervalYMStaticFields.html#GUID-C9D5BFF6-B3BA-4E26-9288-39EE814C5D10",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"IntervalYMMaxValue.html#GUID-450FA851-E9FF-40A7-A8F9-A7EABD7D6C32"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"IntervalYMMinValue.html#GUID-1A42BE1D-BB3F-4244-AA89-32E107D7A379"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"IntervalYMNull.html#GUID-D71C9CCA-F4D6-4160-8A92-A4A7AFBEA780"
                                        },
                                        {
                                            "title":"Zero",
                                            "href":"IntervalYMZero.html#GUID-A6821AC6-B1BB-41CD-82A9-D115091522CD"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Static Methods",
                                    "href":"IntervalYMStaticMethods.html#GUID-0F969C05-0E5B-4C01-80E4-41787C1243CC",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"IntervalYMEqualsStatic.html#GUID-7DC19EDB-00A4-4E81-8D07-D085D8090EE3"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"IntervalYMGreaterThan.html#GUID-29DFD61F-B7B6-4255-BE7C-99B90E566B12"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"IntervalYMGreaterThanOrEqual.html#GUID-81DFDE06-4892-4D9C-9007-E1E16F259035"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"IntervalYMLessThan.html#GUID-1386BAB7-2D01-48D7-9FB7-6640B0B0F4E9"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"IntervalYMLessThanOrEqual.html#GUID-537F4D95-3D7B-4083-BF9C-1E7B87E7D2E2"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"IntervalYMNotEquals.html#GUID-920F9B12-AC14-4BB6-9AE4-1EA0F7A96CCE"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"IntervalYMParse.html#GUID-C9EEB933-E5C8-4C6C-A2A1-8BE2BC07CEBE"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"IntervalYMSetPrecision.html#GUID-6F122152-3E58-44C7-863E-AE40CA3D42B5"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Static Operators",
                                    "href":"IntervalYMStaticOperators.html#GUID-A87947B7-1905-4474-83AC-5C28711B65EC",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"IntervalYMoperatorPLUS.html#GUID-DF58D534-FF0C-46D0-B240-2D1FA97E9600"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"IntervalYMoperatorEQUAL_EQUAL.html#GUID-9446F340-8A34-4661-92BC-CABE990AC974"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"IntervalYMoperatorGT.html#GUID-E9D0C307-B74C-45A3-BAD2-B3FECE39F119"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"IntervalYMoperatorGTequals.html#GUID-7BCD2D4D-9920-4405-AD75-EB17FFCF239F"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"IntervalYMoperatorEXCLAMATION_EQUAL.html#GUID-A39EA2F8-2EB1-41A9-B58D-707579DEA3D3"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"IntervalYMoperatorLT.html#GUID-597C011F-97B8-4319-A8F4-9763D4983659"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"IntervalYMoperatorLTequals.html#GUID-4832E805-475B-41D7-A4DF-3AAD86E5E7BB"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"IntervalYMoperatorMinus1.html#GUID-F2A8B12D-6C34-43D9-A2C5-B4D0AB268578"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"IntervalYMoperatorNegates2.html#GUID-FB25196C-001D-4DC8-832F-3EEF94EFCAC9"
                                        },
                                        {
                                            "title":"operator *",
                                            "href":"IntervalYMoperatorML.html#GUID-983E3F1C-6C1E-401C-88BB-4F49DDD180CB"
                                        },
                                        {
                                            "title":"operator /",
                                            "href":"IntervalYMoperatorDV.html#GUID-654660E5-1595-4A1E-AF81-16C6A9B23E9C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Type Conversions",
                                    "href":"IntervalYMTypeConversions.html#GUID-348EA543-6A02-49F2-B603-DA9111A8BE8A",
                                    "topics":[
                                        {
                                            "title":"explicit operator long",
                                            "href":"IntervalYMexplicitoperatorlong.html#GUID-6A1D62D4-CFB9-4A67-926E-917BA5E23A15"
                                        },
                                        {
                                            "title":"explicit operator OracleIntervalYM",
                                            "href":"IntervalYMexplicitoperatorOracleIntervalYM.html#GUID-EF5E447A-E138-4204-9695-E1AA0F1C7E18"
                                        },
                                        {
                                            "title":"implicit operator OracleIntervalYM",
                                            "href":"IntervalYMimplicitoperatorOracleIntervalYM.html#GUID-E8876CFD-9BA9-4A84-A45B-BA67FB2D819C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Properties",
                                    "href":"IntervalYMProperties.html#GUID-6E5CF64A-AA5D-4125-AF7C-2C4F3D780CE7",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"IntervalYMBinData.html#GUID-A23912CC-12EB-4955-803D-441CC7D581FC"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"IntervalYMIsNull.html#GUID-B73A3B2F-F3E9-4E53-BD2D-DAA33E63284A"
                                        },
                                        {
                                            "title":"Months",
                                            "href":"IntervalYMMonths.html#GUID-CFADD560-4F71-4009-B57A-3ADF6C5908A1"
                                        },
                                        {
                                            "title":"TotalYears",
                                            "href":"IntervalYMTotalYears.html#GUID-DF54A35F-808E-4C62-B099-2DAA2A9B16D3"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"IntervalYMValue.html#GUID-63E0575A-5124-49F3-9940-C716E31D20C8"
                                        },
                                        {
                                            "title":"Years",
                                            "href":"IntervalYMYears.html#GUID-73B8CB02-61A6-44CA-9D3A-46F3C4574403"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleIntervalYM Methods",
                                    "href":"IntervalYMMethods.html#GUID-E22CFFF0-EC19-4EDF-9EE4-CC131B287660",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"IntervalYMCompareTo.html#GUID-D07D8D8E-E98F-4F46-A590-2AC8805F553B"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"IntervalYMEquals.html#GUID-6210ECE2-5A6C-40BA-959F-9376B451E29C"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"IntervalYMGetHashCode.html#GUID-B3A1E6BC-0A3E-496C-B872-09D2BFA3E455"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"IntervalYMToString.html#GUID-DC3A3A6B-D8BC-4247-8942-6792AD094A6E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleString Structure",
                            "href":"OracleStringStructure.html#GUID-6E880731-1ADD-4E86-AFD4-91A976ACA4AC",
                            "topics":[
                                {
                                    "title":"OracleString Members",
                                    "href":"StringMembers.html#GUID-5A6B2AC6-0338-48AD-A97D-32E658EBF44A"
                                },
                                {
                                    "title":"OracleString Constructors",
                                    "href":"StringCtors.html#GUID-CDBD59F6-F42B-4B4B-BA81-063EB76B4DA6",
                                    "topics":[
                                        {
                                            "title":"OracleString(string)",
                                            "href":"StringCtor1.html#GUID-2CFC81B5-F451-4D04-9275-AC0B919F8DF2"
                                        },
                                        {
                                            "title":"OracleString(string, bool)",
                                            "href":"StringCtor2.html#GUID-0BA1EE5F-1300-4551-ABD4-6183F468446A"
                                        },
                                        {
                                            "title":"OracleString(byte [ ], bool)",
                                            "href":"StringCtor3.html#GUID-4BC1D512-3D5D-4CAC-BE43-E4583299F297"
                                        },
                                        {
                                            "title":"OracleString(byte [ ], bool, bool)",
                                            "href":"StringCtor4.html#GUID-3F723482-1426-471B-8ADE-3B34FD79FD62"
                                        },
                                        {
                                            "title":"OracleString(byte [ ], int, int, bool)",
                                            "href":"StringCtor5.html#GUID-F538262C-0681-4A19-AE08-24E3253BED73"
                                        },
                                        {
                                            "title":"OracleString(byte [ ], int, int, bool, bool)",
                                            "href":"StringCtor6.html#GUID-F933F4E5-51EF-4748-82B5-07F1647DF3A3"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Static Fields",
                                    "href":"StringStaticFields.html#GUID-B502F936-253B-487B-9B71-FD2C97FB4E95",
                                    "topics":[
                                        {
                                            "title":"Null",
                                            "href":"StringNull.html#GUID-D9901E82-0B70-471B-A317-E1F30647B97C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Static Methods",
                                    "href":"StringStaticMethods.html#GUID-1F0A8D26-084A-4249-AB54-1A37F399214A",
                                    "topics":[
                                        {
                                            "title":"Concat",
                                            "href":"StringConcat.html#GUID-C50CC41C-593D-4584-A3C6-CBCEB9FFA34A"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"StringEqualsStatic.html#GUID-E00837B1-91F1-4C82-9D94-F3300A2615D8"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"StringGreaterThan.html#GUID-243628BC-E355-483F-BC0B-D9B7867DD971"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"StringGreaterThanOrEqual.html#GUID-0CFA6F2D-8AC8-4098-A5E2-3BD200ED37BF"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"StringLessThan.html#GUID-15216B33-00FD-4491-9011-0690C40A8CD4"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"StringLessThanOrEqual.html#GUID-85A46B1F-EBF7-4935-9462-E8FA008DD5C0"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"StringNotEquals.html#GUID-E2944BBE-0DC6-403D-AFCF-A14A152F14E6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Static Operators",
                                    "href":"StringStaticOperators.html#GUID-6D6A0476-A241-47A7-A9A5-E65760013957",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"StringoperatorPLUS.html#GUID-97E07E9E-9C4C-4628-9F5E-8692BFFD50A7"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"StringoperatorEQUAL_EQUAL.html#GUID-6023F7D5-8214-49C1-827D-811BB908B1E3"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"StringoperatorGT.html#GUID-E2055CB6-9587-48C0-91B2-7772A7AA7E0E"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"StringoperatorGTequals.html#GUID-9C6DD455-19C7-4509-936D-4AC33EF03296"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"StringoperatorEXCLAMATION_EQUAL.html#GUID-5B41778B-DFCE-413A-A235-95FFD46DFE8E"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"StringoperatorLT.html#GUID-0F2D3D15-DFBE-498F-B208-AC3EB9EE835D"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"StringoperatorLTequals.html#GUID-D31CA70E-679F-4AE2-A6DC-BB425D45CE0C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Type Conversions",
                                    "href":"StringTypeConversions.html#GUID-C6FE4B46-9EF8-433C-A0FE-EA5304BD8FED",
                                    "topics":[
                                        {
                                            "title":"explicit operator string",
                                            "href":"Stringexplicitoperatorstring.html#GUID-71032991-E540-4C30-9AB1-106BD6010621"
                                        },
                                        {
                                            "title":"implicit operator OracleString",
                                            "href":"StringimplicitoperatorOracleString.html#GUID-9A8594DB-F5E1-410A-ACF3-CE95484C4E57"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Properties",
                                    "href":"StringProperties.html#GUID-FDBFD3FE-FD98-4C7F-8C7F-8F4D5E78A5A3",
                                    "topics":[
                                        {
                                            "title":"IsCaseIgnored",
                                            "href":"StringIsCaseIgnored.html#GUID-5B309E88-7184-4E24-91BB-C9467B621E23"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"StringIsNull.html#GUID-5A9324E4-AEF9-440A-AC83-7B25C0403583"
                                        },
                                        {
                                            "title":"Item",
                                            "href":"StringItem.html#GUID-C67F7C1B-EC11-453F-80E6-237AE43E5459"
                                        },
                                        {
                                            "title":"Length",
                                            "href":"StringLength.html#GUID-FE091B92-AD2B-4F5A-9A8B-BF1C88DD65A6"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"StringValue.html#GUID-E4F21C30-7675-4069-9F0F-264D3770A6A0"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleString Methods",
                                    "href":"StringMethods.html#GUID-2B0CAE80-E6D9-4C1A-A53C-0AF649426E5E",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"StringClone.html#GUID-30685F17-5953-452B-89FE-283AD1A26CB2"
                                        },
                                        {
                                            "title":"CompareTo",
                                            "href":"StringCompareTo.html#GUID-FF5EFDE2-254E-4813-8305-C6A55DEF3FBF"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"StringEquals.html#GUID-15F0B103-5D4E-454A-95A8-326B030639F6"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"StringGetHashCode.html#GUID-6B0663FB-0953-41ED-A1A6-8FFA5B9985D8"
                                        },
                                        {
                                            "title":"GetNonUnicodeBytes",
                                            "href":"StringGetNonUnicodeBytes.html#GUID-EC4A1612-849B-4BAF-9D33-4CC44950EC07"
                                        },
                                        {
                                            "title":"GetUnicodeBytes",
                                            "href":"StringGetUnicodeBytes.html#GUID-7FACA76E-5D3A-4FDF-8161-F0CAD584B35B"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"StringToString.html#GUID-30516C00-BD0E-4306-8430-67FF46FC2FC0"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleTimeStamp Structure",
                            "href":"OracleTimeStampStructure.html#GUID-27C819FE-B6D7-4A1C-AF29-835A65D57DD1",
                            "topics":[
                                {
                                    "title":"OracleTimeStamp Members",
                                    "href":"TimeStampMembers.html#GUID-8BCA6A11-B9D8-4921-A246-F4018CBA3442"
                                },
                                {
                                    "title":"OracleTimeStamp Constructors",
                                    "href":"TimeStampCtors.html#GUID-62C5A08C-7254-4DE0-AFF8-9A4EB6C191E2",
                                    "topics":[
                                        {
                                            "title":"OracleTimeStamp(DateTime)",
                                            "href":"TimeStampCtor1.html#GUID-A2193607-03FB-4F60-A951-921AAC2A5537"
                                        },
                                        {
                                            "title":"OracleTimeStamp(string)",
                                            "href":"TimeStampCtor2.html#GUID-9F090DD1-0EE7-452B-9A24-E0411DA2D1D5"
                                        },
                                        {
                                            "title":"OracleTimeStamp(int, int, int)",
                                            "href":"TimeStampCtor7.html#GUID-F82BA9C1-9E3E-4963-9F2C-FCD0A91FE301"
                                        },
                                        {
                                            "title":"OracleTimeStamp(int, int, int, int, int, int)",
                                            "href":"TimeStampCtor3.html#GUID-29003C45-103D-4891-BE8D-2E6CFB379B5D"
                                        },
                                        {
                                            "title":"OracleTimeStamp(int, int, int, int, int, int, double)",
                                            "href":"TimeStampCtor4.html#GUID-984D657E-DBC3-4573-942B-418F45436CE8"
                                        },
                                        {
                                            "title":"OracleTimeStamp(int, int, int, int, int, int, int)",
                                            "href":"TimeStampCtor5.html#GUID-1ECF34E2-11D0-4255-B7CF-E8217B85BE13"
                                        },
                                        {
                                            "title":"OracleTimeStamp(byte [ ])",
                                            "href":"TimeStampCtor6.html#GUID-D2BCB39B-F5AA-4EC9-9AB1-50ECF95D538A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Static Fields",
                                    "href":"TimeStampStaticFields.html#GUID-A47112E6-B77D-4B03-ADDD-0BDDAAD5CA2E",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"TimeStampMaxValue.html#GUID-D004D0FD-748D-4677-8138-E1FB256FAC34"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"TimeStampMinValue.html#GUID-034B32BD-51B9-4EEC-8476-EEB2DB678E42"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"TimeStampNull.html#GUID-BEFB6B0F-04A8-46E5-A268-5B7CCBDA3D38"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Static Methods",
                                    "href":"TimeStampStaticMethods.html#GUID-1B46C977-3CF5-48C1-9D22-E5EC9AFC7288",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampEqualsStatic.html#GUID-24309D87-A96F-4324-8757-53DB3C555425"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"TimeStampGreaterThan.html#GUID-D4C56FC5-B85A-425C-B5E6-73F427EB88A2"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"TimeStampGreaterThanOrEqual.html#GUID-74A23104-F94F-4680-A8E0-86F60D6A7FE6"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"TimeStampLessThan.html#GUID-2CCAA3CD-AFDC-453F-86D2-72265C46ECBC"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"TimeStampLessThanOrEqual.html#GUID-13226D61-E978-4F39-AEF9-2186478BA8E2"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"TimeStampNotEquals.html#GUID-A67D63AC-027E-49E0-A05D-C4ED87ADFFCB"
                                        },
                                        {
                                            "title":"GetSysDate",
                                            "href":"TimeStampGetSysDate.html#GUID-16FC3163-DB58-48AE-A3CD-953FFD36C352"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"TimeStampParse.html#GUID-295907BE-D810-4DFE-8EA0-BDE7A6AA34FE"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"TimeStampSetPrecision.html#GUID-915EA083-662D-4BFB-91A3-D76530820F56"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Static Operators",
                                    "href":"TimeStampStaticOperators.html#GUID-9ED34424-4B84-4A26-B2BD-7FC99EDB50D6",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"TimeStampoperatorPLUSOverloads.html#GUID-DD724650-77EC-4879-B9F1-6B22D7BC9401"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStamp, OracleIntervalDS)",
                                            "href":"TimeStampoperatorPLUS1.html#GUID-73B7DEFF-FFB9-4811-A1A2-2D0664A2B3E6"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStamp, OracleIntervalYM)",
                                            "href":"TimeStampoperatorPLUS2.html#GUID-1424B9E7-3FC4-4E9A-B4E7-9DBDDB08584C"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStamp, TimeSpan)",
                                            "href":"TimeStampoperatorPLUS3.html#GUID-11F6C03E-12C1-42DE-90F1-85B1C51CCF7D"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"TimeStampoperatorEQUAL_EQUAL.html#GUID-DBEB8F2B-38E0-4912-8DAB-BEECA78DD1AE"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"TimeStampoperatorGT.html#GUID-783FF46D-D172-4BEE-BE47-D892D09C4AFC"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"TimeStampoperatorGTequals.html#GUID-17755044-9EBA-4DF0-9B4C-E4CA5D1A83D6"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"TimeStampoperatorEXCLAMATION_EQUAL.html#GUID-3A324E9A-3198-495E-8EEF-D2F7FF2AD19D"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"TimeStampoperatorLT.html#GUID-547BCACC-6AAC-42DC-9F55-37B05F36F15F"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"TimeStampoperatorLTequals.html#GUID-BED118BB-FBA4-4E67-8FDC-6BA343CEF7A1"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"TimeStampoperatorMinusOverloads.html#GUID-88AB4103-0824-44AA-A836-77EB7389922E"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStamp, OracleIntervalDS)",
                                            "href":"TimeStampoperatorMinus1.html#GUID-E998F6D3-B92D-4FFD-A83B-48C61CE1575E"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStamp, OracleIntervalYM)",
                                            "href":"TimeStampoperatorMinus2.html#GUID-74E4924E-C875-4542-B86F-59AB44040778"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStamp, TimeSpan)",
                                            "href":"TimeStampoperatorMinus3.html#GUID-8372C247-CB5F-4CE2-9923-5E500728B479"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Static Type Conversions",
                                    "href":"TimeStampStaticTypeConversions.html#GUID-BC329952-2F08-4858-9C46-EC0C613345DC",
                                    "topics":[
                                        {
                                            "title":"explicit operator OracleTimeStamp",
                                            "href":"TimeStampexplicitoperatorOracleTimeStampOverloads.html#GUID-24769055-9052-4992-9DAC-EC78548F1258"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStamp(OracleTimeStampLTZ)",
                                            "href":"TimeStampexplicitoperatorOracleTimeStamp1.html#GUID-70A53A41-2386-4FCF-989B-05C0A0A04723"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStamp(OracleTimeStampTZ)",
                                            "href":"TimeStampexplicitoperatorOracleTimeStamp2.html#GUID-D6CF0F08-097D-48B7-B5EC-92D297D339D2"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStamp(string)",
                                            "href":"TimeStampexplicitoperatorOracleTimeStamp4.html#GUID-5725052E-C779-44A6-B4F5-F615980DFDA4"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStamp",
                                            "href":"TimeStampimplicitoperatorOracleTimeStampOverloads.html#GUID-00C55CD7-3A34-415A-8CA0-0477246CF90F"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStamp(OracleDate)",
                                            "href":"TimeStampimplicitoperatorOracleTimeStamp1.html#GUID-6BF3C607-0198-4EF8-B376-89971CC35215"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStamp(DateTime)",
                                            "href":"TimeStampimplicitoperatorOracleTimeStamp2.html#GUID-41532BE4-4CD5-4616-BE5B-04006FFBED5F"
                                        },
                                        {
                                            "title":"explicit operator DateTime",
                                            "href":"TimeStampexplicitoperatorDateTime.html#GUID-E866FCC1-6F33-4A4F-BFF9-A77784A399DE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Properties",
                                    "href":"TimeStampProperties.html#GUID-B895665E-9F53-4F02-8C04-3A78E53287FB",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"TimeStampBinData.html#GUID-80508D67-839C-4A9B-B2B1-F93A805DF11A"
                                        },
                                        {
                                            "title":"Day",
                                            "href":"TimeStampDay.html#GUID-0AA23F4A-AD45-48CB-9812-66BDDEBE12BE"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"TimeStampIsNull.html#GUID-95E67D5F-072D-4CDE-808C-84AF7658938F"
                                        },
                                        {
                                            "title":"Hour",
                                            "href":"TimeStampHour.html#GUID-19C0E920-C23D-4620-9C22-3BEB6894744B"
                                        },
                                        {
                                            "title":"Millisecond",
                                            "href":"TimeStampMillisecond.html#GUID-1CFE0729-F056-4476-819F-B7EB172A6E64"
                                        },
                                        {
                                            "title":"Minute",
                                            "href":"TimeStampMinute.html#GUID-63B460B4-5A23-4DA3-ACF7-229F3E243DB8"
                                        },
                                        {
                                            "title":"Month",
                                            "href":"TimeStampMonth.html#GUID-CD10C8D9-C0CF-474A-B26B-67D0784092A8"
                                        },
                                        {
                                            "title":"Nanosecond",
                                            "href":"TimeStampNanosecond.html#GUID-071519FE-BA27-4132-9D01-C31B851793E8"
                                        },
                                        {
                                            "title":"Second",
                                            "href":"TimeStampSecond.html#GUID-0A339FB8-3ABC-4183-99C1-3BAEAAC4AB85"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"TimeStampValue.html#GUID-938D8D14-CDDE-42F2-939C-09DDD2C9B40B"
                                        },
                                        {
                                            "title":"Year",
                                            "href":"TimeStampYear.html#GUID-D7E41763-3DAC-4440-A14E-28BA0426F8A2"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStamp Methods",
                                    "href":"TimeStampMethods.html#GUID-58166688-94A3-4A5A-BEBE-44660758A3C1",
                                    "topics":[
                                        {
                                            "title":"AddDays",
                                            "href":"TimeStampAddDays.html#GUID-7DEDD92B-4A83-4598-856D-109D1E3FBF40"
                                        },
                                        {
                                            "title":"AddHours",
                                            "href":"TimeStampAddHours.html#GUID-A7D1211F-1356-4F56-AFF5-C7EBC87E201E"
                                        },
                                        {
                                            "title":"AddMilliseconds",
                                            "href":"TimeStampAddMilliseconds.html#GUID-DE011828-0455-4C80-8482-7301E65C98B5"
                                        },
                                        {
                                            "title":"AddMinutes",
                                            "href":"TimeStampAddMinutes.html#GUID-BCF87D5B-47E1-4D59-A66F-E2626CD2F65D"
                                        },
                                        {
                                            "title":"AddMonths",
                                            "href":"TimeStampAddMonths.html#GUID-38B2B333-1D5A-4991-BA9C-36ED35ED943E"
                                        },
                                        {
                                            "title":"AddNanoseconds",
                                            "href":"TimeStampAddNanoseconds.html#GUID-54BA5FBE-EAEF-47F5-9724-24283A315B98"
                                        },
                                        {
                                            "title":"AddSeconds",
                                            "href":"TimeStampAddSeconds.html#GUID-A8CF97B7-4DCD-4967-8C6B-045B7821A2B9"
                                        },
                                        {
                                            "title":"AddYears",
                                            "href":"TimeStampAddYears.html#GUID-A5B2978D-BDFA-40DA-B410-A6D0788FD824"
                                        },
                                        {
                                            "title":"CompareTo",
                                            "href":"TimeStampCompareTo.html#GUID-6129138F-EDC2-439D-89CF-DC9191C048FD"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampEquals.html#GUID-FB7B8ED0-D429-459A-8FF0-76E077B7FB19"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"TimeStampGetHashCode.html#GUID-8F95967E-0DF9-42C6-B7EA-2EA29B6A64DB"
                                        },
                                        {
                                            "title":"GetDaysBetween",
                                            "href":"TimeStampGetDaysBetween.html#GUID-87C485E4-BE4F-4555-AC86-382FCA3F7D81"
                                        },
                                        {
                                            "title":"GetYearsBetween",
                                            "href":"TimeStampGetYearsBetween.html#GUID-768B1B21-2E8D-4670-A536-BB4FEF5B2CC7"
                                        },
                                        {
                                            "title":"ToOracleDate",
                                            "href":"TimeStampToOracleDate.html#GUID-7B49F2CD-7FF5-4402-8AA4-78388B4CFD7A"
                                        },
                                        {
                                            "title":"ToOracleTimeStampLTZ",
                                            "href":"TimeStampToOracleTimeStampLTZ.html#GUID-83743BC1-5304-4BE2-9EAB-18918CA08FE4"
                                        },
                                        {
                                            "title":"ToOracleTimeStampTZ",
                                            "href":"TimeStampToOracleTimeStampTZ.html#GUID-FD4DA6F8-FA33-41EF-8918-E0DF5764AEF5"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"TimeStampToString.html#GUID-270A4AAC-A15A-4DA2-ACF4-1AF0C80819D8"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleTimeStampLTZ Structure",
                            "href":"OracleTimeStampLTZStructure.html#GUID-CD0E2C04-F2D2-40B0-BFE8-04EC2DA477B6",
                            "topics":[
                                {
                                    "title":"OracleTimeStampLTZ Members",
                                    "href":"TimeStampLTZMembers.html#GUID-B90821B1-9177-4458-AF55-A78B155F978D"
                                },
                                {
                                    "title":"OracleTimeStampLTZ Constructors",
                                    "href":"TimeStampLTZCtors.html#GUID-64176C35-E240-4E1B-936E-0F7C0E45D1B7",
                                    "topics":[
                                        {
                                            "title":"OracleTimeStampLTZ(DateTime)",
                                            "href":"TimeStampLTZCtor1.html#GUID-8E5947C1-4267-4CB1-84D4-1D838CD0C014"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(string)",
                                            "href":"TimeStampLTZCtor2.html#GUID-2175B7BE-3771-4FAD-A839-D1EA25831842"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(int, int, int)",
                                            "href":"TimeStampLTZCtor3.html#GUID-991AAA8F-BE85-4178-A098-0E75A3BF8858"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(int, int, int, int, int, int)",
                                            "href":"TimeStampLTZCtor4.html#GUID-A1FB65C7-73DA-416C-8B52-51D07FF5A305"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(int, int, int, int, int, int, double)",
                                            "href":"TimeStampLTZCtor5.html#GUID-86E31A87-D523-47A9-AEEB-9B56F5754CCA"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(int, int, int, int, int, int, int)",
                                            "href":"TimeStampLTZCtor6.html#GUID-9FD8CD8E-B43C-49C7-B98D-FCAF85D516BD"
                                        },
                                        {
                                            "title":"OracleTimeStampLTZ(byte [ ])",
                                            "href":"TimeStampLTZCtor7.html#GUID-78E7F848-BC06-498A-8F90-5C4D2EA11EA8"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Static Fields",
                                    "href":"TimeStampLTZStaticFields.html#GUID-80446120-5A6C-42E8-8DD0-802FF13D7A17",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"TimeStampLTZMaxvValue.html#GUID-17FD6296-7760-47FF-BA78-1FB7BD56B37A"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"TimeStampLTZMinValue.html#GUID-DC56394E-AA8B-4BC7-8353-3C0E90F17DD5"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"TimeStampLTZNull.html#GUID-5019603F-B29B-4D51-B459-1F864BCC20DE"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Static Methods",
                                    "href":"TimeStampLTZStaticMethods.html#GUID-08134206-151D-461C-97DA-41700A79A9B6",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampLTZEqualsStatic.html#GUID-97D0F861-44C9-4A27-B9EE-40474776E50C"
                                        },
                                        {
                                            "title":"GetLocalTimeZoneName",
                                            "href":"TimeStampLTZGetLocalTimeZoneName.html#GUID-133E472A-F6DA-4B04-9B1A-9CB0672C299C"
                                        },
                                        {
                                            "title":"GetLocalTimeZoneOffset",
                                            "href":"TimeStampLTZGetLocalTimeZoneOffset.html#GUID-E81FF0F0-89DA-43CF-9AD5-76FE0C7B2C28"
                                        },
                                        {
                                            "title":"GetSysDate",
                                            "href":"TimeStampLTZGetSysDate.html#GUID-17C38E4D-885E-4F3B-8179-8A71A9D63A81"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"TimeStampLTZGreaterThan.html#GUID-34ECEAA9-AE7B-4E83-A185-FF808703334C"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"TimeStampLTZGreaterThanOrEquals.html#GUID-A0A2CA9E-9383-4E77-BA12-56F193CF7F08"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"TimeStampLTZLessThan.html#GUID-CFD62679-F51A-46EA-95D0-47B21263EFC5"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"TimeStampLTZLessThanOrEquals.html#GUID-4F81B530-6787-481F-A832-5EA4ACB65CC4"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"TimeStampLTZNotEquals.html#GUID-F11CE51D-E068-4D9A-A034-F7CEFAE453BB"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"TimeStampLTZParse.html#GUID-A1D13713-F59B-461A-BFD7-9F1E1FB5AFD9"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"TimeStampLTZSetPrecision.html#GUID-41B7ED59-F08B-4821-8681-20F70491E08D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Static Operators",
                                    "href":"TimeStampLTZStaticTypeOperators.html#GUID-6A93CF89-1317-41AB-9B8A-685D3439D188",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"TimeStampLTZoperatorPLUSOverloads.html#GUID-538AC6E8-9BC1-43CE-9D7C-4E79725A9EC3"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStampLTZ, OracleIntervalDS)",
                                            "href":"TimeStampLTZoperatorPLUS1.html#GUID-849C9609-A4E2-4B09-ACA3-5A5428A463AE"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStampLTZ, OracleIntervalYM)",
                                            "href":"TimeStampLTZoperatorPLUS2.html#GUID-4004F1A5-FB90-43DD-80D0-1458C81DB364"
                                        },
                                        {
                                            "title":"operator + (OracleTimeStampLTZ, TimeSpan)",
                                            "href":"TimeStampLTZoperatorPLUS3.html#GUID-F4574DAF-4E69-4B0A-BB48-0DC35C5A061B"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"TimeStampLTZoperatorEQUAL_EQUAL.html#GUID-73FEFF21-C1B9-4E0D-AA44-24CC3CBC16DF"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"TimeStampLTZoperatorGT.html#GUID-851B1E83-F231-4F15-A1CC-3D9D70A04AF9"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"TimeStampLTZoperatorGTequals.html#GUID-B3856840-5E59-44BA-BAA7-9CC1217331C5"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"TimeStampLTZoperatorEXCLAMATION_EQUAL.html#GUID-62F24659-7A8D-44BA-B864-93523C2065AE"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"TimeStampLTZoperatorLT.html#GUID-BD80F4BF-A768-48F8-8662-09D48C34C9E3"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"TimeStampLTZoperatorLTequals.html#GUID-78DAC401-CFB6-4499-B181-1B054B09480F"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"TimeStampLTZoepratorMinusOverloads.html#GUID-8A3ABA80-1CE1-4D32-A021-FC715470BA15"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampLTZ, OracleIntervalDS)",
                                            "href":"TimeStampLTZoperatorMinus1.html#GUID-48870D12-3E46-4FF5-8F59-6A21E378C491"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampLTZ, OracleIntervalYM)",
                                            "href":"TimeStampLTZoperatorMinus2.html#GUID-30B3A6DE-9C26-4BC7-985D-EA7DEAD3BC9F"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampLTZ, TimeSpan)",
                                            "href":"TimeStampLTZoperatorMinus3.html#GUID-4472AB72-485F-4B1A-8331-DFD6FA0DC848"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Static Type Conversions",
                                    "href":"TimeStampLTZStatictypeConversions.html#GUID-85FD6133-6DA3-41A6-AE1F-AEDED3978E40",
                                    "topics":[
                                        {
                                            "title":"explicit operator OracleTimeStampLTZ",
                                            "href":"TimeStampLTZexplicitoperatorOracleTimeStampLTZOverloads.html#GUID-B8C8C443-4EF5-4527-AE1B-F99E42A303C0"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampLTZ(OracleTimeStamp)",
                                            "href":"TimeStampLTZexplicitoperatorOracleTimeStampLTZ1.html#GUID-6448DAB5-CC13-4A14-BEB7-E0E35B79FEA8"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampLTZ(OracleTimeStampTZ)",
                                            "href":"TimeStampLTZexplicitoperatorOracleTimeStampLTZ2.html#GUID-3F3AF09B-D42F-493A-A347-619E4B66CC1D"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampLTZ(string)",
                                            "href":"TimeStampLTZexplicitoperatorOracleTimeStampLTZ3.html#GUID-3FF5ED28-B07E-4C73-8B64-9E7A25D6D182"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampLTZ",
                                            "href":"TimeStampLTZimplicitoperatorOracleTimeStampLTZOverloads.html#GUID-399CA475-23A7-445C-B380-D2B1A297F9CE"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampLTZ(OracleDate)",
                                            "href":"TimeStampLTZimplicitoperatorOracleTimeStampLTZ1.html#GUID-5C970A50-A0A2-47A0-81A3-D4B09FF16FAB"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampLTZ(DateTime)",
                                            "href":"TimeStampLTZimplicitoperatorOacleTimeStampLTZ2.html#GUID-BDFB1209-F541-45A9-A417-B7665A15B3EE"
                                        },
                                        {
                                            "title":"explicit operator DateTime",
                                            "href":"TimeStampLTZexplicitoperatorDateTime.html#GUID-4BA69C23-CDFA-474E-B6D5-9B1956D82D54"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Properties",
                                    "href":"TimeStampLTZProperties.html#GUID-5F0D7AD0-32C0-43F7-A675-65EC8FBE21D7",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"TimeStampLTZBinData.html#GUID-DE723B68-9CAA-414B-90C4-E3E86138C557"
                                        },
                                        {
                                            "title":"Day",
                                            "href":"TimeStampLTZDay.html#GUID-849380AA-E53D-4C3A-B44F-F7BC89609989"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"TimeStampLTZIsNull.html#GUID-352DBB76-960F-4E4D-8F16-C34632173BD0"
                                        },
                                        {
                                            "title":"Hour",
                                            "href":"TimeStampLTZHour.html#GUID-365D8E95-E922-4323-9F74-482182EE9451"
                                        },
                                        {
                                            "title":"Millisecond",
                                            "href":"TimeStampLTZMillisecond.html#GUID-BC80F431-A387-43D4-B78E-AF10ADDF87B7"
                                        },
                                        {
                                            "title":"Minute",
                                            "href":"TimeStampLTZMinute.html#GUID-5A0A50B0-6C7F-411A-B08C-74D56DC92F1B"
                                        },
                                        {
                                            "title":"Month",
                                            "href":"TimeStampLTZMonth.html#GUID-0EEF26C9-D5BA-4B64-BAAD-123A80E3A7B6"
                                        },
                                        {
                                            "title":"Nanosecond",
                                            "href":"TimeStampLTZNanosecond.html#GUID-4BD8526B-DC70-4C74-9A51-DD524F1D6302"
                                        },
                                        {
                                            "title":"Second",
                                            "href":"TimeStampLTZSecond.html#GUID-3D0AD89F-3F2E-4B82-83A4-786965A40687"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"TimeStampLTZValue.html#GUID-B07E7B67-48F0-4CE6-BBBC-C9C2DAA50F4A"
                                        },
                                        {
                                            "title":"Year",
                                            "href":"TimeStampLTZYear.html#GUID-C4935C20-2349-462F-A0C9-87A41B22508D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampLTZ Methods",
                                    "href":"TimeStampLTZMethods.html#GUID-5AF4AA71-98A3-4036-A7E8-2FDCA350E427",
                                    "topics":[
                                        {
                                            "title":"AddDays",
                                            "href":"TimeStampLTZAddDays.html#GUID-0C8AA6B1-7E75-4AAF-8D4D-006F37FEEEE3"
                                        },
                                        {
                                            "title":"AddHours",
                                            "href":"TimeStampLTZAddHours.html#GUID-DCB18A47-5B72-4C9F-AC7C-1E8A2328A58D"
                                        },
                                        {
                                            "title":"AddMilliseconds",
                                            "href":"TimeStampLTZAddMilliseconds.html#GUID-E0D2093C-3379-454A-9CEB-5A557193CD94"
                                        },
                                        {
                                            "title":"AddMinutes",
                                            "href":"TimeStampLTZAddMinutes.html#GUID-61554352-B35C-4659-9E00-8DDBEE2C4C4C"
                                        },
                                        {
                                            "title":"AddMonths",
                                            "href":"TimeStampLTZAddMonths.html#GUID-EAFF9A04-24B8-4B75-89B6-339D7A989504"
                                        },
                                        {
                                            "title":"AddNanoseconds",
                                            "href":"TimeStampLTZAddNanoseconds.html#GUID-0DC5AD0F-72CB-4BF5-903B-5A1DA3FF3C36"
                                        },
                                        {
                                            "title":"AddSeconds",
                                            "href":"TimeStampLTZAddSeconds.html#GUID-67C87E9C-04AE-4DCC-899C-1090AB1E3D06"
                                        },
                                        {
                                            "title":"AddYears",
                                            "href":"TimeStampLTZAddYears.html#GUID-8EBC330A-9F8A-48AA-878C-03C842ED2F36"
                                        },
                                        {
                                            "title":"CompareTo",
                                            "href":"TimeStampLTZCompareTo.html#GUID-B88965F0-AAE5-4CDC-AC4E-8DDD21E1BE2F"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampLTZEquals.html#GUID-A1056B2A-D8EE-478F-91E9-6199EB3A4C3D"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"TimeStampLTZGetHashCode.html#GUID-8401EAEF-4639-4DB6-9295-3D0DE41EC9A2"
                                        },
                                        {
                                            "title":"GetDaysBetween",
                                            "href":"TimeStampLTZGetDaysBetween.html#GUID-0FD9DECF-CE75-494D-A409-429F199F3C61"
                                        },
                                        {
                                            "title":"GetYearsBetween",
                                            "href":"TimeStampLTZGetYearsBetween.html#GUID-8E7EA607-E947-42EF-84CF-249388176F3E"
                                        },
                                        {
                                            "title":"ToOracleDate",
                                            "href":"TimeStampLTZToOracleDate.html#GUID-12F139B2-A6E9-49EE-AF1B-094054333BF6"
                                        },
                                        {
                                            "title":"ToOracleTimeStamp",
                                            "href":"TimeStampLTZToOracleTimeStamp.html#GUID-5C992FA3-11FE-403F-A29D-BDA7CAB67DDB"
                                        },
                                        {
                                            "title":"ToOracleTimeStampTZ",
                                            "href":"TimeStampLTZToOracleTimeStampTZ.html#GUID-DE3DF5DA-4DE6-4126-88F2-68991718C521"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"TimeStampLTZToString.html#GUID-DB351ED0-AFD9-4C3F-962C-1212A19B2C1B"
                                        },
                                        {
                                            "title":"ToUniversalTime",
                                            "href":"TimeStampLTZToUniversalTime.html#GUID-A9EDD16C-D6DA-48B2-B445-7E4BFCBFFF8D"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleTimeStampTZ Structure",
                            "href":"OracleTimeStampTZStructure.html#GUID-E3986815-29F1-493D-8A9A-BF8B70617925",
                            "topics":[
                                {
                                    "title":"OracleTimeStampTZ Members",
                                    "href":"TimeStampTZMembers.html#GUID-98A8C430-4CF8-432E-BE4E-8D6C4BA3F707"
                                },
                                {
                                    "title":"OracleTimeStampTZ Constructors",
                                    "href":"TimeStampTZCtors.html#GUID-43242A84-2436-4E23-BB82-77C3A21084D6",
                                    "topics":[
                                        {
                                            "title":"OracleTimeStampTZ(DateTime)",
                                            "href":"TimeStampTZCtor1.html#GUID-43495463-501A-42BA-A569-62FE3838915B"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(DateTime, string)",
                                            "href":"TimeStampTZCtor2.html#GUID-B77FBACC-EC42-4B3B-9B4B-4BAE366719C7"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(string)",
                                            "href":"TimeStampTZCtor3.html#GUID-0EE71320-D390-4924-9146-4AB873E16B11"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int)",
                                            "href":"TimeStampTZCtor4.html#GUID-6E08A813-A4A1-4E24-A9C2-F0CD52B3FB23"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, string)",
                                            "href":"TimeStampTZCtor5.html#GUID-EDF3AF20-3235-4AF6-9BE6-52D66E60DA7A"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int)",
                                            "href":"TimeStampTZCtor6.html#GUID-8F88BFF4-5BA7-412D-8030-979FFE827110"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int, string)",
                                            "href":"TimeStampTZCtor7.html#GUID-6B89976B-66BE-4A9E-8B9F-8ACD7BDF7CC5"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int, double)",
                                            "href":"TimeStampTZCtor8.html#GUID-F1041C1C-C3F9-4C59-9CAE-AF3FC3CB5179"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int, double, string)",
                                            "href":"TimeStampTZCtor9.html#GUID-CCA21EFB-1664-406C-87B9-C7C4DB7E0B8D"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int, int)",
                                            "href":"TimeStampTZCtor10.html#GUID-2FF54B3E-65B0-4634-AEAE-D05887E1E388"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(int, int, int, int, int, int, int, string)",
                                            "href":"TimeStampTZCtor11.html#GUID-26759BC9-675A-461C-AE11-13EA3E9B067A"
                                        },
                                        {
                                            "title":"OracleTimeStampTZ(byte [ ])",
                                            "href":"TimeStampTZCtor12.html#GUID-4D740921-5421-4FE1-B67A-DDC5804E37A4"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Static Fields",
                                    "href":"TimeStampTZStaticFields.html#GUID-0FE71722-D263-425D-8236-D283F5254B7F",
                                    "topics":[
                                        {
                                            "title":"MaxValue",
                                            "href":"TimeStampTZMaxValue.html#GUID-1D0FC4DB-AFE1-41E3-818F-73E92F0DF1C5"
                                        },
                                        {
                                            "title":"MinValue",
                                            "href":"TimeStampTZMinValue.html#GUID-D4FB9FAE-A59B-46B8-84B0-DF9069D16C8B"
                                        },
                                        {
                                            "title":"Null",
                                            "href":"TimeStampTZNull.html#GUID-5ED47926-85D1-430B-8D99-8283C0C50491"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Static Methods",
                                    "href":"TimeStampTZStaticMethods.html#GUID-CF5092E4-1859-4324-BA8F-34DC2B762E9A",
                                    "topics":[
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampTZEqualsStatic.html#GUID-A140E7DD-2454-46E3-B7BD-EA93E92F4A19"
                                        },
                                        {
                                            "title":"GetSysDate",
                                            "href":"TimeStampTZGetSysDate.html#GUID-0DF3F6CD-9C5D-436C-9015-C8250B99FC17"
                                        },
                                        {
                                            "title":"GreaterThan",
                                            "href":"TimeStampTZGreaterThan.html#GUID-8B2C5177-36B7-46B5-96F3-7FA6D915CD46"
                                        },
                                        {
                                            "title":"GreaterThanOrEqual",
                                            "href":"TimeStampTZGreaterThanOrEqual.html#GUID-73836A08-2467-4BC0-BCB8-58BC9893D182"
                                        },
                                        {
                                            "title":"LessThan",
                                            "href":"TimeStampTZLessThan.html#GUID-0ECCA2F8-A1C1-4814-B2A6-9A15D77BB11A"
                                        },
                                        {
                                            "title":"LessThanOrEqual",
                                            "href":"TimeStampTZLessThanOrEqual.html#GUID-A6E6B446-914A-4376-905B-0DC5E5FA6598"
                                        },
                                        {
                                            "title":"NotEquals",
                                            "href":"TimeStampTZNotEquals.html#GUID-648A6BE9-3A7D-4577-8B97-4653AB895880"
                                        },
                                        {
                                            "title":"Parse",
                                            "href":"TimeStampTZParse.html#GUID-0260C1A0-16F5-4E05-B2FA-38DFE7F88A50"
                                        },
                                        {
                                            "title":"SetPrecision",
                                            "href":"TimeStampTZSetPrecision.html#GUID-D2A9CEC0-1A35-4499-A115-B6AD8B5F5AF8"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Static Operators",
                                    "href":"TimeStampTZStaticOperators.html#GUID-120D2BF1-0026-4D16-BFFD-A6EF36258956",
                                    "topics":[
                                        {
                                            "title":"operator +",
                                            "href":"TimeStampTZoperatorPLUSOverloads.html#GUID-82B9865D-AB4C-4FB6-B2CB-C3024B9012D0"
                                        },
                                        {
                                            "title":"operator +(OracleTimeStampTZ, OracleIntervalDS)",
                                            "href":"TimeStampTZoperatorPLUS1.html#GUID-4182666F-4B6E-4F1A-8A87-5FC6D062D951"
                                        },
                                        {
                                            "title":"operator +(OracleTimeStampTZ, OracleIntervalYM)",
                                            "href":"TimeStampTZoperatorPLUS2.html#GUID-61BCACDF-DEB5-4AE6-B96B-72247CF90D1A"
                                        },
                                        {
                                            "title":"operator +(OracleTimeStampTZ, TimeSpan)",
                                            "href":"TimeStampTZoperatorPLUS3.html#GUID-4822A827-B345-4958-826A-7B11DB58B3A0"
                                        },
                                        {
                                            "title":"operator ==",
                                            "href":"TimeStampTZoperatorEQUAL_EQUAL.html#GUID-D42BFA3F-F9E4-4EE8-83D6-66A31C381A52"
                                        },
                                        {
                                            "title":"operator >",
                                            "href":"TimeStampTZoperatorGT.html#GUID-A1925D01-6626-4B1B-A4FA-BBED9881E4E8"
                                        },
                                        {
                                            "title":"operator >=",
                                            "href":"TimeStampTZoperatorGTequals.html#GUID-00FE278C-2B19-427A-9698-7E8504DA26E3"
                                        },
                                        {
                                            "title":"operator !=",
                                            "href":"TimeStampTZEXCLAMATION_EQUAL.html#GUID-3C803BEF-550C-48FC-BCDC-3FBAE166B001"
                                        },
                                        {
                                            "title":"operator <",
                                            "href":"TimeStampTZoperatorLT.html#GUID-717C3457-4980-4443-9FB7-374ED19099E5"
                                        },
                                        {
                                            "title":"operator <=",
                                            "href":"TimeStampTZLTequals.html#GUID-8EABA1D4-4F57-4B2F-BA06-DC29B302BCEB"
                                        },
                                        {
                                            "title":"operator -",
                                            "href":"TimeStampTZoperatorMinusOverloads.html#GUID-66CB956A-3AD8-49E4-A247-054128440F50"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampTZ, OracleIntervalDS)",
                                            "href":"TimeStampTZoperatorMinus1.html#GUID-7C1A06DE-C2F9-432B-B933-20C928379C78"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampTZ, OracleIntervalYM)",
                                            "href":"TimeStampTZoperatorMinus2.html#GUID-F5E0C9C3-5F07-4478-B86C-B0366CE89EAA"
                                        },
                                        {
                                            "title":"operator - (OracleTimeStampTZ value1, TimeSpan value2)",
                                            "href":"TimeStampTZoperatorMinus3.html#GUID-014CD56B-7106-46E1-8E4A-3DBAEEE9C3EB"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Static Type Conversions",
                                    "href":"TimeStampTZStaticTypeConversions.html#GUID-C48AFEE3-1EC4-4B7C-ABDE-1041CCC2375B",
                                    "topics":[
                                        {
                                            "title":"explicit operator OracleTimeStampTZ",
                                            "href":"TimeStampTZexplicitoperatorOracleTimeStampOverloads.html#GUID-2D57406B-CE1B-40E7-9EF2-EFC85BD8B62B"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampTZ(OracleTimeStamp)",
                                            "href":"TimeStampTZexplicitoperatorOracleTimeStampTZ1.html#GUID-18A853C9-A225-46B0-BE8D-8DFA18746C06"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampTZ(OracleTimeStampLTZ)",
                                            "href":"TimeStampTZexplicitoperatorOracleTimeStampTZ2.html#GUID-E594D185-3B7F-4B98-AD06-76359C92688C"
                                        },
                                        {
                                            "title":"explicit operator OracleTimeStampTZ(string)",
                                            "href":"TimeStampTZexplicitoperatorOracleTimeStampTZ3.html#GUID-EFF925E0-E42C-4647-B890-60AB611A4DBB"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampTZ",
                                            "href":"TimeStampTZimplicitoperatorOracleTimeStampTZOverloads.html#GUID-7C1C21FE-1598-42C2-8780-8EA94ED4E091"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampTZ(OracleDate)",
                                            "href":"TimeStampTZimplicitoperatorOracleTimeStampTZ1.html#GUID-98075D9B-497A-4277-8CC6-FB5F2CC44A3A"
                                        },
                                        {
                                            "title":"implicit operator OracleTimeStampTZ(DateTime)",
                                            "href":"TimeStampTZimplicitoperatorOracleTimeStampTZ2.html#GUID-B92A8030-276A-47D7-B949-DA5CA632A99F"
                                        },
                                        {
                                            "title":"explicit operator DateTime",
                                            "href":"TimeStampTZexplicitoperatorDateTime.html#GUID-A5A5BF99-3883-4B7F-8780-747AC48EBD91"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Properties",
                                    "href":"TimeStampTZProperties.html#GUID-81EC7181-B009-4D95-A01E-27EE8D0C0BBD",
                                    "topics":[
                                        {
                                            "title":"BinData",
                                            "href":"TimeStampTZBinData.html#GUID-B55D0C25-AF04-4CDC-A9C4-A3B749DD568B"
                                        },
                                        {
                                            "title":"Day",
                                            "href":"TimeStampTZDay.html#GUID-9A74B33F-FAFF-41FC-867B-40B10B9DFE6A"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"TimeStampTZIsNull.html#GUID-428F2611-A173-4776-A3EE-57E983F4A2F2"
                                        },
                                        {
                                            "title":"Hour",
                                            "href":"TimeStampTZHour.html#GUID-6B433741-22F1-4232-9DF4-1B1880A68D9F"
                                        },
                                        {
                                            "title":"Millisecond",
                                            "href":"TimeStampTZMillisecond.html#GUID-C20A86FE-D563-4A28-82B3-F1A7A9A7D1DE"
                                        },
                                        {
                                            "title":"Minute",
                                            "href":"TimeStampTZMinute.html#GUID-B260EC54-3274-4AD1-BB37-19DB6635CF07"
                                        },
                                        {
                                            "title":"Month",
                                            "href":"TimeStampTZMonth.html#GUID-42E72EFA-49A7-4924-AD46-E4C4E81EA66C"
                                        },
                                        {
                                            "title":"Nanosecond",
                                            "href":"TimeStampTZNanosecond.html#GUID-ADF44500-5092-40DC-96ED-BBE3F172D565"
                                        },
                                        {
                                            "title":"Second",
                                            "href":"TimeStampTZSecond.html#GUID-4031F21B-C9B4-43AF-A07E-A2B9F40C1827"
                                        },
                                        {
                                            "title":"TimeZone",
                                            "href":"TimeStampTZTimeZone.html#GUID-C3F218CF-AAF6-411E-93FE-66E1D8D72E0A"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"TimeStampTZValue.html#GUID-435C80ED-B8D7-4D9C-9FE7-41958AE99227"
                                        },
                                        {
                                            "title":"Year",
                                            "href":"TimeStampTZYear.html#GUID-620887CF-83EA-4A77-89BC-4EBDCF842825"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTimeStampTZ Methods",
                                    "href":"TimeStampTZMethods.html#GUID-6A104A26-1434-45B8-9DD1-CE7BE2656898",
                                    "topics":[
                                        {
                                            "title":"AddDays",
                                            "href":"TimeStampTZAddDays.html#GUID-2BD634AA-CE19-4675-BD61-AC805D98E105"
                                        },
                                        {
                                            "title":"AddHours",
                                            "href":"TimeStampTZAddHours.html#GUID-6D62A46B-6968-4900-BE22-1A027597726F"
                                        },
                                        {
                                            "title":"AddMilliseconds",
                                            "href":"TimeStampTZAddMilliseconds.html#GUID-3A1E77EC-63D4-433E-91B9-25151C93FB61"
                                        },
                                        {
                                            "title":"AddMinutes",
                                            "href":"TimeStampTZAddMinutes.html#GUID-234A9D58-1473-4F8B-8C59-8066FD1AEBFA"
                                        },
                                        {
                                            "title":"AddMonths",
                                            "href":"TimeStampTZAddMonths.html#GUID-C9C074DE-6C7F-439B-9FBC-FE6A37B2BE28"
                                        },
                                        {
                                            "title":"AddNanoseconds",
                                            "href":"TimeStampTZAddNanoseconds.html#GUID-D338C675-7BD8-4F3C-8D85-ECEE2E7A3E8D"
                                        },
                                        {
                                            "title":"AddSeconds",
                                            "href":"TimeStampTZAddSeconds.html#GUID-658641D1-F83F-46D3-B20B-D58B9DBA68E6"
                                        },
                                        {
                                            "title":"AddYears",
                                            "href":"TimeStampTZAddYears.html#GUID-92725A58-F75F-44E1-8149-6DA6202EF0A5"
                                        },
                                        {
                                            "title":"CompareTo",
                                            "href":"TimeStampTZCompareTo.html#GUID-8EE2E245-1796-486C-BB0C-32D310AB4AC1"
                                        },
                                        {
                                            "title":"Equals",
                                            "href":"TimeStampTZEquals.html#GUID-0D3E52F8-7499-414F-9DC4-EC039E5D164A"
                                        },
                                        {
                                            "title":"GetDaysBetween",
                                            "href":"TimeStampTZGetDaysBetween.html#GUID-0ADACF6A-AC68-49BF-99EC-8103E5F5F94E"
                                        },
                                        {
                                            "title":"GetHashCode",
                                            "href":"TimeStampTZGetHashCode.html#GUID-B3C931E3-5255-4C8A-8F41-E8A4CED04151"
                                        },
                                        {
                                            "title":"GetTimeZoneOffset",
                                            "href":"TimeStampTZGetTimeZoneOffset.html#GUID-70191520-DDA4-460B-ACBD-DEEE48D6B0F1"
                                        },
                                        {
                                            "title":"GetYearsBetween",
                                            "href":"TimeStampTZGetYearsBetween.html#GUID-EE878787-8FDD-4350-87FF-6B1F85F70C1B"
                                        },
                                        {
                                            "title":"ToLocalTime",
                                            "href":"TimeStampTZToLocalTime.html#GUID-86CC603F-9412-44AD-B190-73EC4807C9BB"
                                        },
                                        {
                                            "title":"ToOracleDate",
                                            "href":"TimeStampTZToOracleDate.html#GUID-5FE5CC71-A7C4-4813-9604-9DBD356F9441"
                                        },
                                        {
                                            "title":"ToOracleTimeStampLTZ",
                                            "href":"TimeStampTZToOracleTimeStampLTZ.html#GUID-C40D8D42-2E49-4841-B7DE-3248E5A3A648"
                                        },
                                        {
                                            "title":"ToOracleTimeStamp",
                                            "href":"TimeStampTZToOracleTimeStamp.html#GUID-46D5CF15-A6E4-46C6-A2BC-B9A98119FEB5"
                                        },
                                        {
                                            "title":"ToString",
                                            "href":"TimeStampTZToString.html#GUID-183B08B5-E911-4363-9D72-C2AC71983B45"
                                        },
                                        {
                                            "title":"ToUniversalTime",
                                            "href":"TimeStampTZToUniversalTime.html#GUID-C2578C7C-2EBA-4E94-8217-188CC691670E"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"INullable Interface",
                            "href":"INullableInterface.html#GUID-65A35C4E-24E7-4C4F-B84B-CCEAD036D159",
                            "topics":[
                                {
                                    "title":"INullable Interface Members",
                                    "href":"INullableMembers.html#GUID-FB7087D3-19E8-4D78-9B45-4DDC200B1EEC"
                                },
                                {
                                    "title":"INullable Interface Properties",
                                    "href":"INullableProperties.html#GUID-DB5386F1-886B-41D2-A8CD-B72B01FFE13D",
                                    "topics":[
                                        {
                                            "title":"IsNull",
                                            "href":"INullableIsNull.html#GUID-2C908392-4796-416D-AD76-1E3F8425B42F"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Oracle Data Provider for .NET Types Exceptions",
                    "href":"types-exceptions.html#GUID-37D75D01-67F4-4264-A2F5-15F033B89427",
                    "topics":[
                        {
                            "title":"OracleTypeException Class",
                            "href":"OracleTypeExceptionClass.html#GUID-1451264D-4E19-447B-BAA7-6A6EA908DD53",
                            "topics":[
                                {
                                    "title":"OracleTypeException Members",
                                    "href":"TypeExceptionMembers.html#GUID-C29689CE-7592-4C30-95F6-C6032AB6F580"
                                },
                                {
                                    "title":"OracleTypeException Constructors",
                                    "href":"TypeExceptionCtors.html#GUID-3EE36F38-BEFA-468D-B5E2-DF77D4A161F9",
                                    "topics":[
                                        {
                                            "title":"OracleTypeException(string)",
                                            "href":"TypeExceptionCtor1.html#GUID-1A28AE07-4943-49C2-ACE0-3F40AEA60821"
                                        },
                                        {
                                            "title":"OracleTypeException(SerializationInfo, StreamingContext)",
                                            "href":"TypeExceptionCtor2.html#GUID-0123E5AE-B4F8-4457-99C6-73583F98BD50"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTypeException Static Methods",
                                    "href":"TypeExceptionStaticMethods.html#GUID-F6F44366-54A9-4BE6-83AB-2E3B023B7223"
                                },
                                {
                                    "title":"OracleTypeException Properties",
                                    "href":"TypeExceptionProperties.html#GUID-B2FB8954-52F7-4208-AD6B-0B2BFECF44FA",
                                    "topics":[
                                        {
                                            "title":"Message",
                                            "href":"TypeExceptionMessage.html#GUID-B7DB1707-281E-47A1-AA16-1B3F25989E95"
                                        },
                                        {
                                            "title":"Number",
                                            "href":"TypeExceptionNumber.html#GUID-17B78043-4FB7-4034-B183-BB664CE1F42A"
                                        },
                                        {
                                            "title":"Source",
                                            "href":"TypeExceptionSource.html#GUID-E16A9CD2-EF0C-4C02-B323-82EC29C0490D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTypeException Methods",
                                    "href":"TypeExceptionMethods.html#GUID-CE8E7592-6AED-408C-8A6D-4AD15DB6F673",
                                    "topics":[
                                        {
                                            "title":"ToString",
                                            "href":"TypeExceptionToString.html#GUID-74B01B87-DCC4-4630-9A95-F9FABD63E239"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleNullValueException Class",
                            "href":"OracleNullValueExceptionClass.html#GUID-9D373AFC-E954-4068-976C-8C396CAB83C2",
                            "topics":[
                                {
                                    "title":"OracleNullValueException Members",
                                    "href":"NullValueExceptionMembers.html#GUID-8A59A8BD-38C7-410F-B28E-19B466902395"
                                },
                                {
                                    "title":"OracleNullValueException Constructors",
                                    "href":"NullValueExceptionCtors.html#GUID-D874934D-E1E8-4732-A2B9-3351AA3BC69A",
                                    "topics":[
                                        {
                                            "title":"OracleNullValueException()",
                                            "href":"NullValueExceptionCtor1.html#GUID-0DCCE324-10F4-4BA7-BB5B-07993C0A64E7"
                                        },
                                        {
                                            "title":"OracleNullValueException(string)",
                                            "href":"NullValueExceptionCtor2.html#GUID-E7C84CE9-B428-4010-8DF5-EF1FD62D3D05"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleNullValueException Static Methods",
                                    "href":"NullValueExceptionStaticMethods.html#GUID-D00B847A-37D1-46FB-90E0-D09B0FDC82F8"
                                },
                                {
                                    "title":"OracleNullValueException Properties",
                                    "href":"NullValueExceptionProperties.html#GUID-2608EAA3-3E71-4064-9BA5-939FBC1842C7"
                                },
                                {
                                    "title":"OracleNullValueException Methods",
                                    "href":"NullValueExceptionMethods.html#GUID-76AB9084-80DA-4606-8875-1C188C92FDAF"
                                }
                            ]
                        },
                        {
                            "title":"OracleTruncateException Class",
                            "href":"OracleTruncateExceptionClass.html#GUID-70C06100-CCAB-46BE-AC06-E202105EC391",
                            "topics":[
                                {
                                    "title":"OracleTruncateException Members",
                                    "href":"TruncateExceptionMembers.html#GUID-B1552D7D-A512-4C01-9A5B-1B193461EDD5"
                                },
                                {
                                    "title":"OracleTruncateException Constructors",
                                    "href":"TruncateExceptionCtors.html#GUID-4A9D4307-9A62-4595-87E9-D54C0E2FDF70",
                                    "topics":[
                                        {
                                            "title":"OracleTruncateException()",
                                            "href":"TruncateExceptionCtor1.html#GUID-CB2E098F-5D08-4D5F-A4CF-328E26EFC0C6"
                                        },
                                        {
                                            "title":"OracleTruncateException(string)",
                                            "href":"TruncateExceptionCtor2.html#GUID-A8C81E8E-F7CB-4522-BB43-FC90CC545F6F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleTruncateException Static Methods",
                                    "href":"TruncateExceptionStaticMethods.html#GUID-F637ED2E-B38A-42AE-8984-F16C0C18876C"
                                },
                                {
                                    "title":"OracleTruncateException Properties",
                                    "href":"TruncateExceptionProperties.html#GUID-E7300E47-70A7-4B60-8703-A23288473F63"
                                },
                                {
                                    "title":"OracleTruncateException Methods",
                                    "href":"TruncateExceptionMethods.html#GUID-33F9FF20-2F51-4968-A241-5AEAC2ABEFB4"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Oracle Data Provider for .NET UDT-Related Classes",
                    "href":"udt-related-classes.html#GUID-22B718E1-B54B-4F73-8875-18D64B60D741",
                    "topics":[
                        {
                            "title":"OracleCustomTypeMappingAttribute Class",
                            "href":"OracleCustomTypeMappingAttributeClass.html#GUID-74C8A8F2-35A2-466E-9E2F-E24B07DD41F4",
                            "topics":[
                                {
                                    "title":"OracleCustomTypeMappingAttribute Members",
                                    "href":"OracleCustomTypeMappingAttributeMembers.html#GUID-043C0095-EF5B-42A6-B605-86781301408C"
                                },
                                {
                                    "title":"OracleCustomTypeMappingAttribute Constructors",
                                    "href":"CustomTypeMappingAttributeConstructors.html#GUID-B60B5F1A-A3D3-4A86-92B2-9D5F103774E7",
                                    "topics":[
                                        {
                                            "title":"OracleCustomTypeMappingAttribute(string)",
                                            "href":"CustomTypeMappingAttributeCtor1.html#GUID-285CD3E7-8E4B-4CD0-87C1-4E114D2A0E69"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCustomTypeMappingAttribute Static Methods",
                                    "href":"CustomTypeMappingAttributeStaticMethods.html#GUID-57F90439-EBE3-4E3B-B67D-D1E3F2A4EB2B"
                                },
                                {
                                    "title":"OracleCustomTypeMappingAttribute Properties",
                                    "href":"CustomTypeMappingAttributeProperties.html#GUID-04302C2A-62BA-43BF-9EB0-3E0CA150CC86",
                                    "topics":[
                                        {
                                            "title":"UdtTypeName",
                                            "href":"CustomTypeMappingAttributeUdtTypeName.html#GUID-E233A742-79D9-4208-B108-52B05A39491C"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCustomTypeMappingAttribute Methods",
                                    "href":"CustomTypeMappingAttributeMethods.html#GUID-3FEFA51A-8E40-4A1F-9C23-7B2F44304412"
                                }
                            ]
                        },
                        {
                            "title":"OracleObjectMappingAttribute Class",
                            "href":"OracleObjectMappingAttributeClass.html#GUID-EE79486E-D965-4058-B637-5D367298D441",
                            "topics":[
                                {
                                    "title":"OracleObjectMappingAttribute Members",
                                    "href":"OracleObjectMappingAttributeMembers.html#GUID-8BDEB128-0C59-48A4-8C80-0E8A947D1FDB"
                                },
                                {
                                    "title":"OracleObjectMappingAttribute Constructors",
                                    "href":"ObjectMappingAttributeConstructors.html#GUID-B3228FB4-E41D-49BF-A1DF-46E899A7E4FC",
                                    "topics":[
                                        {
                                            "title":"OracleObjectMappingAttribute(string)",
                                            "href":"ObjectMappingAttributeCtor1.html#GUID-3BEF13EA-293D-4DC7-B9EE-2E9D255040BE"
                                        },
                                        {
                                            "title":"OracleObjectMappingAttribute(int)",
                                            "href":"ObjectMappingAttributeCtor2.html#GUID-C8C60058-D31E-4CCE-AADE-807BD053083D"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleObjectMappingAttribute Static Methods",
                                    "href":"ObjectMappingAttributeStaticMethods.html#GUID-E2302F80-3899-4A20-8BD8-E894047FA3A8"
                                },
                                {
                                    "title":"OracleObjectMappingAttribute Properties",
                                    "href":"ObjectMappingAttributeProperties.html#GUID-DF86BF60-954E-4984-BDFE-2E49B3A70F32",
                                    "topics":[
                                        {
                                            "title":"AttributeIndex",
                                            "href":"ObjectMappingAttributeAttributeIndex.html#GUID-520B4CA5-51DE-454A-9025-08D998D62C3E"
                                        },
                                        {
                                            "title":"AttributeName",
                                            "href":"ObjectMappingAttributeAttributeName.html#GUID-77AA55E4-D923-4BBA-B773-CD042D26952A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleObjectMappingAttribute Methods",
                                    "href":"ObjectMappingAttributeAttributeMethods.html#GUID-AFC3BC60-7AE1-4FD8-8234-1E3ED6800500"
                                }
                            ]
                        },
                        {
                            "title":"OracleArrayMappingAttribute Class",
                            "href":"OracleArrayMappingAttributeClass.html#GUID-3B789DFD-DF31-4A70-B100-5BD68051D95E",
                            "topics":[
                                {
                                    "title":"OracleArrayMappingAttribute Members",
                                    "href":"OracleArrayMappingAttributeMembers.html#GUID-D68B4BB7-DC39-45AF-B6E7-21851439599F"
                                },
                                {
                                    "title":"OracleArrayMappingAttribute Constructors",
                                    "href":"OracleArrayMappingAttributeConstructors.html#GUID-C4FE9F1D-15F2-45EE-A0DB-B17BC7F90CBD",
                                    "topics":[
                                        {
                                            "title":"OracleArrayMappingAttribute()",
                                            "href":"ArrayMappingAttributeCtor1.html#GUID-7A3A8453-8259-423C-8F8B-54C41C330DDA"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleArrayMappingAttribute Static Methods",
                                    "href":"ArrayMappingAttributeStaticMethods.html#GUID-75A3FC86-F5B0-4854-B70E-DD087EA80B9E"
                                },
                                {
                                    "title":"OracleArrayMappingAttribute Properties",
                                    "href":"ArrayMappingAttributeProperties.html#GUID-E25B97BD-59FA-42D0-B812-421FA552C182"
                                },
                                {
                                    "title":"OracleArrayMappingAttribute Methods",
                                    "href":"ArrayMappingAttributeMethods.html#GUID-85469F1A-136C-43FB-921F-1FE9C175CFD9"
                                }
                            ]
                        },
                        {
                            "title":"IOracleCustomType Interface",
                            "href":"IOracleCustomTypeInterface.html#GUID-F6BC2C6D-F83C-4292-A1BA-5DA466DC1358",
                            "topics":[
                                {
                                    "title":"IOracleCustomType Members",
                                    "href":"IOracleCustomTypeMembers.html#GUID-8FB3FC30-F63D-4B7C-AB55-12FAF49DA98D"
                                },
                                {
                                    "title":"IOracleCustomType Interface Methods",
                                    "href":"CustomTypeInterfaceMethods.html#GUID-5F4F1950-CE80-486F-899C-627B5B7481E6",
                                    "topics":[
                                        {
                                            "title":"FromCustomObject(OracleConnection, IntPtr)",
                                            "href":"CustomTypeFromCustomObject1.html#GUID-F2749987-686D-418B-9831-2CB3A283F1C2"
                                        },
                                        {
                                            "title":"FromCustomObject(OracleConnection, object)",
                                            "href":"CustomTypeFromCustomObject2.html#GUID-2E0554A8-8160-43B9-9166-6C6BE92F9CE0"
                                        },
                                        {
                                            "title":"ToCustomObject(OracleConnection, IntPtr)",
                                            "href":"CustomTypeToCustomObject1.html#GUID-EF92439B-893B-41F7-8694-9E5925CD8F81"
                                        },
                                        {
                                            "title":"ToCustomObject(OracleConnection, object)",
                                            "href":"CustomTypeToCustomObject2.html#GUID-086517C6-2020-40CD-8D1A-4BC7EEA1E5F6"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"IOracleCustomTypeFactory Interface",
                            "href":"IOracleCustomTypeFactoryInterface.html#GUID-252C6DC9-4066-4285-B4FE-469A23C12A37",
                            "topics":[
                                {
                                    "title":"IOracleCustomTypeFactory Members",
                                    "href":"IOracleCustomTypeFactoryMembers.html#GUID-9D7C77D1-39DE-4420-B1DA-9D1A88F4A387"
                                },
                                {
                                    "title":"IOracleCustomTypeFactory Interface Methods",
                                    "href":"CustomTypeFactoryInterfaceMethods.html#GUID-71E9C1CC-31FA-4B2E-8E60-B1EDAF55E6C5",
                                    "topics":[
                                        {
                                            "title":"CreateObject",
                                            "href":"CustomTypeFactoryCreateObject.html#GUID-28B3239F-5FCB-4A59-A739-7A06149D446D"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"IOracleArrayTypeFactory Interface",
                            "href":"IOracleArrayTypeFactoryInterface.html#GUID-61BD391C-C2C6-4FF4-A447-F97A2B8DD84B",
                            "topics":[
                                {
                                    "title":"IOracleArrayTypeFactory Members",
                                    "href":"IOracleArrayTypeFactoryMembers.html#GUID-AC3B14EE-4D5E-448A-BBE1-8B81FC68E0FE"
                                },
                                {
                                    "title":"IOracleArrayTypeFactory Interface Methods",
                                    "href":"ArrayTypeFactoryInterfaceMethods.html#GUID-E610004C-7A6E-455B-BA51-AB96CA3E72C5",
                                    "topics":[
                                        {
                                            "title":"CreateArray",
                                            "href":"ArrayTypeFactoryCreateArray.html#GUID-E6625AA0-924D-409B-9F5A-0BE43688D511"
                                        },
                                        {
                                            "title":"CreateStatusArray",
                                            "href":"ArrayTypeFactoryCreateStatusArray.html#GUID-5F571452-CBD1-4E73-B457-8C0C071D6B82"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleUdt Class",
                            "href":"OracleUdtClass.html#GUID-E3137DD9-1359-4FF6-9E94-EC285B5EE6EB",
                            "topics":[
                                {
                                    "title":"OracleUdt Members",
                                    "href":"OracleUdtMembers.html#GUID-18778CA7-0EC8-413C-86D4-E8CA72D2988D"
                                },
                                {
                                    "title":"OracleUDT Static Methods",
                                    "href":"UDTstaticmethods.html#GUID-F46D29A5-D93B-4BF1-9443-4A0A32FC6E4D",
                                    "topics":[
                                        {
                                            "title":"GetValue",
                                            "href":"UDTGetValueoverloads.html#GUID-3B32CFCB-6FFD-445B-95D1-A358AA51DDCA"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, IntPtr, string)",
                                            "href":"UdtGetValue1.html#GUID-3C669874-DB0E-4F05-B720-74C1C0FD8066"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, IntPtr, int)",
                                            "href":"UdtGetValue2.html#GUID-DAC4A40A-115C-4EC8-A848-DE198BFA8D77"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, IntPtr, string, out object)",
                                            "href":"UdtGetValue3.html#GUID-4310E858-51FB-4782-8D53-6B6D52BB1D68"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, IntPtr, int, out object)",
                                            "href":"UdtGetValue4.html#GUID-C6202703-8366-475D-8D72-9962294F4426"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, object, string)",
                                            "href":"UdtGetValue5.html#GUID-300EB299-D834-4BB4-929D-8336DF2D65A3"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, object, int)",
                                            "href":"UdtGetValue6.html#GUID-2D8D28D0-78B0-4581-9EE4-55A9AB6D0ABA"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, object, string, out object)",
                                            "href":"UdtGetValue7.html#GUID-F9B20F5F-6FC5-4784-B9B4-166CBDE1D373"
                                        },
                                        {
                                            "title":"GetValue(OracleConnection, object, int, out object)",
                                            "href":"UdtGetValue8.html#GUID-AA0773AC-C737-4C98-A4FA-51E0196922C0"
                                        },
                                        {
                                            "title":"IsDBNull",
                                            "href":"UdtIsDBNulloverloads.html#GUID-CD32C084-5E03-4924-93B6-976ABCA56B4D"
                                        },
                                        {
                                            "title":"IsDBNull(OracleConnection, IntPtr, string)",
                                            "href":"UdtIsDBNull1.html#GUID-E8D0C180-0200-4E85-87EE-772BC4E2BCF9"
                                        },
                                        {
                                            "title":"IsDBNull(OracleConnection, IntPtr, int)",
                                            "href":"UdtIsDBNull2.html#GUID-BCB69714-0F27-4FC3-B972-EF7C47C651A7"
                                        },
                                        {
                                            "title":"IsDBNull(OracleConnection, object, string)",
                                            "href":"UdtIsDBNull3.html#GUID-AFE8C5C9-86BF-4C32-9742-A90BB7A22F8E"
                                        },
                                        {
                                            "title":"IsDBNull(OracleConnection, object, int)",
                                            "href":"UdtIsDBNull4.html#GUID-D40939BC-56D4-4DAC-B8E3-70A2C195048F"
                                        },
                                        {
                                            "title":"SetValue",
                                            "href":"UdtSetValueOverloads.html#GUID-31481C10-9629-48E5-8B8A-32C022DAD7D4"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, IntPtr, string, object)",
                                            "href":"UdtSetValue1.html#GUID-EAB11124-A1C5-46FD-9716-C65C7F69D721"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, IntPtr, int, object)",
                                            "href":"UdtSetValue2.html#GUID-DCDDC0CA-F98E-4330-9850-38522C16CE0A"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, IntPtr, string, object, object)",
                                            "href":"UdtSetValue3.html#GUID-E9E53F57-567C-4D47-B6E3-6B44F1FF8091"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, IntPtr, int, object, object)",
                                            "href":"UdtSetValue4.html#GUID-C3FDC25D-613C-423C-A21B-B2352FC2EFD0"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, object, string, object)",
                                            "href":"UdtSetValue5.html#GUID-11700043-904A-4137-87AB-F8D2CA78BE9B"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, object, int, object)",
                                            "href":"UdtSetValue6.html#GUID-FCF94DF6-7D6A-46BA-9E8B-67B727D4EC7C"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, object, string, object, object)",
                                            "href":"UdtSetValue7.html#GUID-70E00597-0450-4B2D-9CA0-62F951E317E2"
                                        },
                                        {
                                            "title":"SetValue(OracleConnection, object, int, object, object)",
                                            "href":"UdtSetValue8.html#GUID-B211BC52-0077-4837-A5D4-D3AEC418C1B5"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleRef Class",
                            "href":"OracleRefClass.html#GUID-4299B1DF-12DD-4FB3-9BC2-B0973E203390",
                            "topics":[
                                {
                                    "title":"OracleRef Members",
                                    "href":"OracleRefMembers.html#GUID-5A5FA48C-C817-4EB4-A057-A9811A375973"
                                },
                                {
                                    "title":"OracleRef Constructors",
                                    "href":"RefConstructors.html#GUID-3D912C7E-1B31-4689-8BDE-06B95020C2F5",
                                    "topics":[
                                        {
                                            "title":"OracleRef(OracleConnection, string)",
                                            "href":"RefCtor1.html#GUID-CB84EA8D-5D35-43E6-85EF-0479B70AE422"
                                        },
                                        {
                                            "title":"OracleRef(OracleConnection, string, string)",
                                            "href":"RefCtor2.html#GUID-BD63CDB1-2844-4665-853C-2802FEF64714"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRef Static Fields",
                                    "href":"RefStaticFields.html#GUID-0A77A74B-564C-44EE-91D4-1D7A0D3E399C",
                                    "topics":[
                                        {
                                            "title":"Null",
                                            "href":"RefNull.html#GUID-68D9A087-0E70-46DB-8ABE-AA8D76E939C6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRef Static Methods",
                                    "href":"RefStaticMethods.html#GUID-D95EDDDB-BEEC-4EC4-A747-D0BAB115C7D1"
                                },
                                {
                                    "title":"OracleRef Instance Properties",
                                    "href":"RefProperties.html#GUID-715BD789-5105-4A5E-BABC-A2679980469A",
                                    "topics":[
                                        {
                                            "title":"Connection",
                                            "href":"RefConnection.html#GUID-80F81BA3-8317-41CB-8A6A-721DE959D2E4"
                                        },
                                        {
                                            "title":"HasChanges",
                                            "href":"RefHasChanges.html#GUID-1996C084-81DE-4DAB-86E3-A7C887D4EA75"
                                        },
                                        {
                                            "title":"IsLocked",
                                            "href":"RefIsLocked.html#GUID-ABE19EE5-AA7E-47B5-8F95-283C4753536E"
                                        },
                                        {
                                            "title":"IsNull",
                                            "href":"RefIsNull.html#GUID-46AE4814-A784-4149-96D9-4B01A8D2C151"
                                        },
                                        {
                                            "title":"ObjectTableName",
                                            "href":"RefObjectTableName.html#GUID-93419C46-94F1-4875-9B48-C25A9139BE54"
                                        },
                                        {
                                            "title":"Value",
                                            "href":"RefValue.html#GUID-A6919302-7C72-4A3B-8458-617C5DA9F4BA"
                                        }
                                    ]
                                },
                                {
                                    "title":"Oracle Ref Instance Methods",
                                    "href":"RefInstanceMethods.html#GUID-6020ECC2-A457-43BE-8CC0-6EDA6E586985",
                                    "topics":[
                                        {
                                            "title":"Clone",
                                            "href":"RefClone.html#GUID-D4AF4DC4-CC49-434E-8528-06055FFFF3A3"
                                        },
                                        {
                                            "title":"Delete",
                                            "href":"RefDelete.html#GUID-CB4F4FDD-36FB-4E40-A748-7DDF944A54F1"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"RefDispose.html#GUID-C38714E6-B71E-4C74-95F4-F876BC2144C4"
                                        },
                                        {
                                            "title":"Flush",
                                            "href":"RefFlush.html#GUID-9957EA9B-BC53-4893-881B-FA331C723F96"
                                        },
                                        {
                                            "title":"GetCustomObject",
                                            "href":"RefGetCustomObjectOverloads.html#GUID-5C96B1DD-7286-45D4-B0CC-C41F2DD284AF"
                                        },
                                        {
                                            "title":"GetCustomObject(OracleUdtFetchOption)",
                                            "href":"RefGetCustomObject1.html#GUID-2D6A129F-CD49-4F06-8E78-529AC7151609"
                                        },
                                        {
                                            "title":"GetCustomObject(OracleUdtFetchOption, int)",
                                            "href":"RefGetCustomObject2.html#GUID-5B0F553C-F1E4-4F3C-BCCC-2A7AEC0D2287"
                                        },
                                        {
                                            "title":"GetCustomObjectForUpdate",
                                            "href":"RefGetCustomObjectForUpdateOverloads.html#GUID-17E4812A-D7A3-4AB4-9C0A-2CC4E2644B73"
                                        },
                                        {
                                            "title":"GetCustomObjectForUpdate(bool)",
                                            "href":"RefGetCustomObjectForUpdate1.html#GUID-9642BEC9-528C-44E0-8411-A0A10C17E076"
                                        },
                                        {
                                            "title":"GetCustomObjectForUpdate(bool, int)",
                                            "href":"RefGetCustomObjectForUpdate2.html#GUID-F18FB0FA-689A-4643-9F54-833E566C7E79"
                                        },
                                        {
                                            "title":"IsEqual",
                                            "href":"RefIsEqual.html#GUID-2BC36A6B-8505-4D8F-8093-D9400DC441BB"
                                        },
                                        {
                                            "title":"Lock",
                                            "href":"RefLock.html#GUID-BDD14A1D-5766-4409-AD91-204B89558CC0"
                                        },
                                        {
                                            "title":"Update",
                                            "href":"RefUpdate.html#GUID-34832B2B-4C82-4161-ADF3-A9A93F1B1E44"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleUdtFetchOption Enumeration",
                            "href":"OracleUdtFetchOptionEnumeration.html#GUID-01224228-1C74-4DB1-845F-AE7B8DFB2DFE"
                        },
                        {
                            "title":"OracleUdtStatus Enumeration",
                            "href":"OracleUdtStatusEnumeration.html#GUID-8B1E0977-CDA7-46A8-88B8-3E7BDB9F57C9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Oracle Data Provider for .NET Bulk Copy Classes",
                    "href":"bulk-copy-classes.html#GUID-D22429BA-AB13-4BFF-831E-C2C18ACEC378",
                    "topics":[
                        {
                            "title":"OracleBulkCopy Class",
                            "href":"OracleBulkCopyClass.html#GUID-3993FDA1-2807-4F66-A078-9A2C7091E2ED",
                            "topics":[
                                {
                                    "title":"OracleBulkCopy Members",
                                    "href":"OracleBulkCopyMembers.html#GUID-80BDCCC2-09DA-4F47-8A9B-28969B078749"
                                },
                                {
                                    "title":"OracleBulkCopy Constructors",
                                    "href":"BulkCopyConstructors.html#GUID-79295079-958B-42F2-82CD-33772CF6A726",
                                    "topics":[
                                        {
                                            "title":"OracleBulkCopy(OracleConnection)",
                                            "href":"BulkCopyCtor1.html#GUID-68394E8D-C791-4AD7-B425-CC747753A1AC"
                                        },
                                        {
                                            "title":"OracleBulkCopy(string)",
                                            "href":"BulkCopyCtor2.html#GUID-581A18E7-9DA5-4B3C-8DBC-EBE7395790F5"
                                        },
                                        {
                                            "title":"OracleBulkCopy(OracleConnection, OracleBulkCopyOptions)",
                                            "href":"BulkCopyCtor3.html#GUID-C441F460-9FDA-498A-A4C9-2D12FE268002"
                                        },
                                        {
                                            "title":"OracleBulkCopy(string, OracleBulkCopyOptions)",
                                            "href":"BulkCopyCtor4.html#GUID-C608BEB6-5FD6-433C-86CC-4DFB56DC7475"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopy Properties",
                                    "href":"BulkCopyProperties.html#GUID-4DDD75FC-B47B-4995-A82D-9A10C6BB08CA",
                                    "topics":[
                                        {
                                            "title":"BatchSize",
                                            "href":"BulkCopyBatchSize.html#GUID-5B2ED329-56C3-4CC7-91DC-A13CD174FF3D"
                                        },
                                        {
                                            "title":"BulkCopyOptions",
                                            "href":"BulkCopyBulkCopyOptions.html#GUID-B9CEDFA6-4735-4D07-A2AD-0B451CAFF96D"
                                        },
                                        {
                                            "title":"BulkCopyTimeout",
                                            "href":"BulkCopyBulkCopyTimeout.html#GUID-E6AFB77D-E5AF-4FD5-89C7-B44EF921DF20"
                                        },
                                        {
                                            "title":"ColumnMappings",
                                            "href":"BulkCopyColumnMappings.html#GUID-ED2C999B-9CDC-48B2-888A-5C7F859D0048"
                                        },
                                        {
                                            "title":"Connection",
                                            "href":"BulkCopyConnection.html#GUID-C4A2E364-9A56-4FA9-8548-0B0D2C0222ED"
                                        },
                                        {
                                            "title":"DestinationPartitionName",
                                            "href":"BulkCopyDestinationPartitionName.html#GUID-A9867334-445F-4A23-A203-728147296B8B"
                                        },
                                        {
                                            "title":"DestinationSchemaName",
                                            "href":"BulkCopyDestinationSchemaName.html#GUID-B1EA4CC8-49C6-4C56-8994-061263852657"
                                        },
                                        {
                                            "title":"DestinationTableName",
                                            "href":"BulkCopyDestinationTableName.html#GUID-DAFEC8CD-40DD-4DEC-8E8B-92019DCF5DBF"
                                        },
                                        {
                                            "title":"NotifyAfter",
                                            "href":"BulkCopyNotifyAfter.html#GUID-B7E22811-8A26-457C-A825-2C467B58D16E"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopy Public Methods",
                                    "href":"BulkCopyPublicMethods.html#GUID-476D1AA7-933C-4ED9-8C74-CD5F0F43B7E5",
                                    "topics":[
                                        {
                                            "title":"Close",
                                            "href":"BulkCopyClose.html#GUID-9A15397F-F686-4D86-AC9D-F72E9D8B4D75"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"BulkCopyDispose.html#GUID-7D30BB11-4CA1-4663-902F-20D49D22AE9B"
                                        },
                                        {
                                            "title":"WriteToServer",
                                            "href":"BulkCopyWriteToServerOverloads.html#GUID-EE4889D5-1701-4A69-9473-EB0650DB09DF"
                                        },
                                        {
                                            "title":"WriteToServer(DataRow[])",
                                            "href":"BulkCopyWriterToServer1.html#GUID-DF48DBAD-86A5-46C6-BDE9-C1A3038C1230"
                                        },
                                        {
                                            "title":"WriteToServer(DataTable)",
                                            "href":"BulkCopyWriterToServer2.html#GUID-003B02F3-7150-4360-9608-188C8E31A0AE"
                                        },
                                        {
                                            "title":"WriteToServer(IDataReader)",
                                            "href":"BulkCopyWriterToServer3.html#GUID-278BE8E9-5241-47BB-B682-88BB40FE47F2"
                                        },
                                        {
                                            "title":"WriteToServer(DataTable, DataRowState)",
                                            "href":"BulkCopyWriterToServer4.html#GUID-45240C11-B0CC-4856-B27F-C25E4CE04587"
                                        },
                                        {
                                            "title":"WriteToServer(OracleRefCursor)",
                                            "href":"BulkCopyWriterToServer5.html#GUID-FEE176FB-276A-4EC9-AF1D-EAACDB786E43"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopy Events",
                                    "href":"BulkCopyEvents.html#GUID-D8215BFF-16FA-42C6-B90D-CFE87613E29C",
                                    "topics":[
                                        {
                                            "title":"OracleRowsCopied",
                                            "href":"BulkCopyOracleRowsCopied.html#GUID-F7736BFF-2C44-4F0D-BB1C-A7F8AA98D36B"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleBulkCopyColumnMapping Class",
                            "href":"OracleBulkCopyColumnMappingClass.html#GUID-85BFC1C5-A1B0-46EF-83A2-41EAE3387143",
                            "topics":[
                                {
                                    "title":"OracleBulkCopyColumnMapping Members",
                                    "href":"OracleBulkCopyColumnMappingMembers.html#GUID-CFC31947-4E76-4EA6-BF6E-6CE8DB7E477B"
                                },
                                {
                                    "title":"OracleBulkCopyColumnMapping Constructors",
                                    "href":"BulkCopyColumnMappingConstructors.html#GUID-77D46BB0-3EE5-4E58-A94F-A40A018BB16E",
                                    "topics":[
                                        {
                                            "title":"OracleBulkCopyColumnMapping()",
                                            "href":"BulkCopyColumnMappingCtor1.html#GUID-910759FD-CCEA-491E-9F0F-1117624D998C"
                                        },
                                        {
                                            "title":"OracleBulkCopyColumnMapping(int, int)",
                                            "href":"BulkCopyColumnMappingCtor2.html#GUID-666D464E-360B-4CBD-9E71-D0FC00C4A64E"
                                        },
                                        {
                                            "title":"OracleBulkCopyColumnMapping(int, string)",
                                            "href":"BulkCopyColumnMappingCtor3.html#GUID-75C570E1-D56C-4051-9E45-81BB63F61FA6"
                                        },
                                        {
                                            "title":"OracleBulkCopyColumnMapping(string, int)",
                                            "href":"BulkCopyColumnMappingCtor4.html#GUID-B83DC44A-0403-4DB0-8584-0496EA096CCD"
                                        },
                                        {
                                            "title":"OracleBulkCopyColumnMapping(string, string)",
                                            "href":"BulkCopyColumnMappingCtor5.html#GUID-0A8D6E0F-2469-419D-A871-5F968EA84D1A"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopyColumnMapping Methods",
                                    "href":"BulkCopyColumnMappingMethods.html#GUID-A428B9EC-27FF-4885-AE03-005B7B0369B1",
                                    "topics":[
                                        {
                                            "title":"CompareTo",
                                            "href":"BulkCopyColumnMappingCompareTo.html#GUID-6327CB7A-BCC5-4543-AED3-53D04BABD0B6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopyColumnMapping Properties",
                                    "href":"BulkCopyColumnMappingProperties.html#GUID-A445F4C6-E87F-4708-A8F4-64EC10BE24CD",
                                    "topics":[
                                        {
                                            "title":"DestinationColumn",
                                            "href":"BulkCopyColumnMappingDestinationColumn.html#GUID-0264DB11-989E-4070-BEAA-E0473C7DD454"
                                        },
                                        {
                                            "title":"DestinationOrdinal",
                                            "href":"BulkCopyColumnMappingDestinationOrdinal.html#GUID-407B5C55-019D-413A-8179-CEA7A7BC3B95"
                                        },
                                        {
                                            "title":"SourceColumn",
                                            "href":"BulkCopyColumnMappingSourceColumn.html#GUID-5D6B4E3A-F226-4BE6-A03A-93B15B130777"
                                        },
                                        {
                                            "title":"SourceOrdinal",
                                            "href":"BulkCopyColumnMappingSourceOrdinal.html#GUID-720498E6-401A-4DBA-940D-0EAEAD551ECB"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleBulkCopyColumnMappingCollection Class",
                            "href":"OracleBulkCopyColumnMappingCollectionClass.html#GUID-B0A74151-D3DA-4A28-BA41-7EE7980AA763",
                            "topics":[
                                {
                                    "title":"OracleBulkCopyColumnMappingCollection Members",
                                    "href":"OracleBulkCopyColumnMappingCollectionMembers.html#GUID-F408E85D-B1D0-4CF0-95EF-2432209529E8"
                                },
                                {
                                    "title":"OracleBulkCopyColumnMappingCollection Properties",
                                    "href":"BulkCopyColumnMappingCollectionProperties.html#GUID-AE9462C9-71B9-4DD2-B934-5823774F0E83",
                                    "topics":[
                                        {
                                            "title":"Item[index]",
                                            "href":"BulkCopyColumnMappingCollectionItemindex.html#GUID-B7E7375A-3039-46D4-AC8A-118637AF63B6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleBulkCopyColumnMappingCollection Public Methods",
                                    "href":"BulkCopyColumnMappingCollectionPublicMethods.html#GUID-3A3CDE36-2AF5-4803-BB78-B4F6397A7D58",
                                    "topics":[
                                        {
                                            "title":"Add",
                                            "href":"BulkCopyColumnMappingCollectionAddOverloads.html#GUID-17C0CC01-9D00-4EAD-B545-9E66AE9EF02F"
                                        },
                                        {
                                            "title":"Add(OracleBulkCopyColumnMapping)",
                                            "href":"BulkCopyColumnMappingCollectionAdd1.html#GUID-02DCCA78-23F3-4A8C-AD0E-AB958B5D24C4"
                                        },
                                        {
                                            "title":"Add(int, int)",
                                            "href":"BulkCopyColumnMappingCollectionAdd2.html#GUID-D9C16154-381D-49C5-B931-1E4584895F42"
                                        },
                                        {
                                            "title":"Add(int, string)",
                                            "href":"BulkCopyColumnMappingCollectionAdd3.html#GUID-B357A91B-EAB3-46C5-9038-47B140055735"
                                        },
                                        {
                                            "title":"Add(string, int)",
                                            "href":"BulkCopyColumnMappingCollectionAdd4.html#GUID-84DAEE79-0F31-4D90-B16A-9F50ED33B26F"
                                        },
                                        {
                                            "title":"Add(string, string)",
                                            "href":"BulkCopyColumnMappingCollectionAdd5.html#GUID-40D052E9-F870-42DE-AA73-0AEFBA55284A"
                                        },
                                        {
                                            "title":"Clear",
                                            "href":"BulkCopyColumnMappingCollectionClear.html#GUID-322B94E8-4839-4C92-841F-7D5AF8BEC781"
                                        },
                                        {
                                            "title":"Contains",
                                            "href":"BulkCopyColumnMappingCollectionContains.html#GUID-2BC5ECC3-8DAE-4999-86BC-69B616B501D7"
                                        },
                                        {
                                            "title":"CopyTo",
                                            "href":"BulkCopyColumnMappingCollectionCopyTo.html#GUID-FB557C45-BA56-45DF-989F-F19775F38972"
                                        },
                                        {
                                            "title":"IndexOf",
                                            "href":"BulkCopyColumnMappingCollectionIndexOf.html#GUID-8CC4DF41-C704-4F43-A135-D901222D56F6"
                                        },
                                        {
                                            "title":"Insert",
                                            "href":"BulkCopyColumnMappingCollectionInsert.html#GUID-48C63C43-5FD6-4E88-B720-B145D1E87B92"
                                        },
                                        {
                                            "title":"Remove",
                                            "href":"BulkCopyColumnMappingCollectionRemove.html#GUID-6EC0D2D3-132B-4D72-B5D3-C8E7C5106917"
                                        },
                                        {
                                            "title":"RemoveAt",
                                            "href":"BulkCopyColumnMappingCollectionRemoveAt.html#GUID-5C58E7A5-D44E-43C4-A8BB-1E30A5534D7A"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleBulkCopyOptions Enumeration",
                            "href":"OracleBulkCopyOptionsEnumeration.html#GUID-72863EF2-A7C7-4B2F-A54B-AFAD4F61FD1B"
                        },
                        {
                            "title":"OracleRowsCopiedEventHandler Delegate",
                            "href":"OracleRowsCopiedEventHandlerDelegate.html#GUID-29E086B7-077C-43B3-AEB6-4B8B22E012C4"
                        },
                        {
                            "title":"OracleRowsCopiedEventArgs Class",
                            "href":"OracleRowsCopiedEventArgsClass.html#GUID-F8F59244-0B28-44FC-9CFB-9DEA4AD7F857",
                            "topics":[
                                {
                                    "title":"OracleRowsCopiedEventArgs Members",
                                    "href":"OracleRowsCopiedEventArgsMembers.html#GUID-5555B186-A1B9-428F-84CB-3C23E2A55897"
                                },
                                {
                                    "title":"OracleRowsCopiedEventArgs Constructors",
                                    "href":"OracleRowsCopiedEventArgsConstructors.html#GUID-382F6A20-95BD-447E-9238-C2EC79A5AFF3",
                                    "topics":[
                                        {
                                            "title":"OracleRowsCopiedEventArgs(long)",
                                            "href":"OracleRowsCopiedEventArgsCtor1.html#GUID-E31EFBD6-3389-4FBD-8206-12F6A8036EF7"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleRowsCopiedEventArgs Properties",
                                    "href":"OracleRowsCopiedEventArgsProperties.html#GUID-B4DC2C50-1921-4E9A-8EE4-5B0016094AFC",
                                    "topics":[
                                        {
                                            "title":"Abort",
                                            "href":"OracleRowsCopiedEventArgsAbort.html#GUID-91479705-4D09-4615-A88F-9A6AD2204D98"
                                        },
                                        {
                                            "title":"RowsCopied",
                                            "href":"OracleRowsCopiedEventArgsRowsCopied.html#GUID-BC3528D6-CED7-4626-BD82-BA89C22904E4"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Oracle Data Provider for .NET OpenTelemetry and Metrics Classes",
                    "href":"ODP_OpenTelemetry.html#GUID-F831B7D3-3AF4-43A4-9FCC-11B2A40D1E84",
                    "topics":[
                        {
                            "title":"OracleDataProviderInstrumentationOptions Class",
                            "href":"OracleDataProviderInstrumentationOptionsClass.html#GUID-A335BBF8-A623-4114-836B-75B4C7E89C35",
                            "topics":[
                                {
                                    "title":"OracleDataProviderInstrumentationOptions Properties",
                                    "href":"OracleDataProviderInstrumentationOptionsProperties.html#GUID-0010FCAB-155B-4213-922C-7F3EA81BE807",
                                    "topics":[
                                        {
                                            "title":"AddDBInfoToDisplayName",
                                            "href":"DataProviderInstrumentationOptionsAddDBInfoToDisplayName.html#GUID-DF64083D-39FB-4D9D-9FA5-DD6D940F4E67"
                                        },
                                        {
                                            "title":"EnableConnectionLevelAttributes",
                                            "href":"DataProviderInstrumentationOptionsEnableConnectionLevelAttributes.html#GUID-1EBDB9A5-8CF8-4B73-AB54-E0FE5CD9C6EE"
                                        },
                                        {
                                            "title":"EnableDBRoundTripTracing",
                                            "href":"DataProviderInstrumentationOptionsEnableDBRoundTripTracing.html#GUID-682B29C2-F717-44A4-BACE-79569DCF3B16"
                                        },
                                        {
                                            "title":"EnableOpenCloseTracing",
                                            "href":"DataProviderInstrumentationOptionsEnableOpenCloseTracing.html#GUID-4206FB86-D283-4731-8AD1-F71C6ABA3677"
                                        },
                                        {
                                            "title":"EnableSqlIdTracing",
                                            "href":"DataProviderInstrumentationOptionsEnableSqlIdTracing.html#GUID-D950F99C-F317-4F91-94AC-7A40693EC483"
                                        },
                                        {
                                            "title":"InstrumentOracleDataReaderRead",
                                            "href":"DataProviderInstrumentationOptionsInstrumentOracleDataReaderRead.html#GUID-CBB6D17A-B17A-447B-9714-206B6853D77E"
                                        },
                                        {
                                            "title":"RecordException",
                                            "href":"DataProviderInstrumentationOptionsRecordException.html#GUID-7E376B5D-4130-4B4C-881F-0E34B02A63A9"
                                        },
                                        {
                                            "title":"RequireApplicationRootSpanCreation",
                                            "href":"DataProviderInstrumentationOptionsEnableRootlessSpanTracing.html#GUID-931249B7-95CF-4442-A19B-6869862208EE"
                                        },
                                        {
                                            "title":"SetDbStatementForStoredProcedure",
                                            "href":"DataProviderInstrumentationOptionsSetDbStatementForStoredProcedure.html#GUID-035BE572-776A-435E-8F58-DCE2B9D203E9"
                                        },
                                        {
                                            "title":"SetDbStatementForText",
                                            "href":"DataProviderInstrumentationOptionsSetDbStatementForText.html#GUID-6173697B-6965-4496-832C-11784934FE96"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"AddOracleDataProviderInstrumentation",
                            "href":"addoracledataproviderinstrumentation.html#GUID-87E8DD1A-CCFB-4884-B505-0908927065CC"
                        },
                        {
                            "title":"OraclePoolNameCollection Class",
                            "href":"OraclePoolNameCollectionClass.html#GUID-D0363F73-E1E4-4419-9A07-9C7125C04564",
                            "topics":[
                                {
                                    "title":"OraclePoolNameCollection Methods",
                                    "href":"OraclePoolNameCollectionMethods.html#GUID-002BC762-D9EF-4F7B-8224-3DAC0AF0B53E",
                                    "topics":[
                                        {
                                            "title":"Add(string, string)",
                                            "href":"PoolNameCollectionAdd1.html#GUID-2B012E76-4558-44E7-8D58-E507A9C275B4"
                                        },
                                        {
                                            "title":"Remove (string)",
                                            "href":"PoolNameCollectionRemove.html#GUID-45E1972C-E202-43D1-A342-835859313E60"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Oracle Data Provider for .NET Oracle Identity and Access Management Classes",
                    "href":"OCI_IAM_SSO.html#GUID-3B055C14-5C1E-49DE-9DEC-D981E199A56F",
                    "topics":[
                        {
                            "title":"OciTokenAuthentication Class",
                            "href":"OciTokenAuthenticationClass.html#GUID-2626560E-16DE-4538-9EC4-AB85051149BD",
                            "topics":[
                                {
                                    "title":"OciTokenAuthentication Members",
                                    "href":"OciTokenAuthenticationMembers.html#GUID-E1D019F0-04BF-456B-AC6B-775F418F4778"
                                },
                                {
                                    "title":"OciTokenAuthentication Constructor()",
                                    "href":"OciTokenAuthenticationCtor1.html#GUID-95407E21-1871-41A5-ABBD-9FC1E400FE6E"
                                },
                                {
                                    "title":"OciTokenAuthentication Properties",
                                    "href":"OciTokenAuthenticationProperties.html#GUID-AFC14F28-354B-43EB-B35E-49A185BD51AD",
                                    "topics":[
                                        {
                                            "title":"Compartment",
                                            "href":"OciTokenAuthenticationCompartment.html#GUID-E565092F-7989-46C0-8589-D86100F229FF"
                                        },
                                        {
                                            "title":"ConfigurationFile",
                                            "href":"OciTokenAuthenticationConfigurationFile.html#GUID-42D5A195-2600-4B4E-96C9-59DAD88F8FB2"
                                        },
                                        {
                                            "title":"Database",
                                            "href":"OciTokenAuthenticationDatabase.html#GUID-EBB97877-349B-4F2D-AFF7-B2812A185A7E"
                                        },
                                        {
                                            "title":"Profile",
                                            "href":"OciTokenAuthenticationProfile.html#GUID-9A9F97BB-CEA1-4AC8-9610-3E7F6E1B4581"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> Oracle Data Provider for .NET Microsoft Entra ID Classes",
                    "href":"AAD_SSO.html#GUID-ADF7F207-A478-4A16-BFC4-1FD575FAFF91",
                    "topics":[
                        {
                            "title":"AzureTokenAuthentication Class",
                            "href":"AzureTokenAuthenticationClass.html#GUID-E38DC41D-80DB-4B04-93A3-54CEEC6B1D26",
                            "topics":[
                                {
                                    "title":"AzureTokenAuthentication Members",
                                    "href":"AzureTokenAuthenticationMembers.html#GUID-331B9C26-F438-4A49-A3B6-08D6047B207E"
                                },
                                {
                                    "title":"AzureTokenAuthentication Constructors",
                                    "href":"AzureTokenAuthenticationConstructors.html#GUID-8B266214-EAAA-48FA-879E-202FD4FEB080",
                                    "topics":[
                                        {
                                            "title":"AzureTokenAuthentication()",
                                            "href":"AzureTokenAuthenticationCtor1.html#GUID-49AA65A6-DEE5-4526-8826-E87208994ED9"
                                        },
                                        {
                                            "title":"AzureTokenAuthentication(string)",
                                            "href":"AzureTokenAuthenticationCtor2.html#GUID-CF3E8814-904E-44EE-886D-ABAEC9EA9838"
                                        }
                                    ]
                                },
                                {
                                    "title":"AzureTokenAuthentication Properties",
                                    "href":"AzureTokenAuthenticationProperties.html#GUID-40A0B698-930D-4AEC-9BB2-B9608F32429B",
                                    "topics":[
                                        {
                                            "title":"DatabaseApplicationIdUri",
                                            "href":"AzureTokenAuthenticationDatabaseApplicationIdUri.html#GUID-D007A8E3-8A5C-4D0E-8D90-00B568FE331C"
                                        },
                                        {
                                            "title":"ClientId",
                                            "href":"AzureTokenAuthenticationClientId.html#GUID-182D3E98-9B01-408B-81B5-5E4E4992A5AB"
                                        },
                                        {
                                            "title":"TenantId",
                                            "href":"AzureTokenAuthenticationTenantId.html#GUID-96F50817-627B-4F02-9284-715822815E1E"
                                        },
                                        {
                                            "title":"RedirectUri",
                                            "href":"AzureTokenAuthenticationRedirectUri.html#GUID-466CB5F0-F1C1-43DB-8C78-6466CADBB3B1"
                                        },
                                        {
                                            "title":"ClientSecret",
                                            "href":"AzureTokenAuthenticationClientSecret.html#GUID-8EFF2413-B02F-413F-B30B-4997FD40CC12"
                                        },
                                        {
                                            "title":"ClientCertificate",
                                            "href":"AzureTokenAuthenticationClientCertificate.html#GUID-C81758AF-317E-442F-BA27-1FD8150D7B84"
                                        },
                                        {
                                            "title":"ClientCertificatePassword",
                                            "href":"AzureTokenAuthenticationClientCertificatePassword.html#GUID-63E460EF-1551-4AB0-861F-F2A9739FDAEC"
                                        },
                                        {
                                            "title":"CustomDeviceCodeCallback",
                                            "href":"AzureTokenAuthenticationCustomDeviceCodeCallback.html#GUID-5612A0D9-831F-469F-9CE8-BC513A46094B"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">21 </span> Oracle Database Vector Store Connector for Semantic Kernel Classes",
                    "href":"VSConnector4SKClasses.html#GUID-6E3FFDD3-17B3-42E1-BA14-902E011C6FDA",
                    "topics":[
                        {
                            "title":"OracleCollection Class",
                            "href":"OracleCollectionClass.html#GUID-7F0D6D99-CDA1-462F-839C-28492D6F82B1",
                            "topics":[
                                {
                                    "title":"OracleCollection Constructors",
                                    "href":"OracleCollectionConstructors.html#GUID-6AFFE378-2F70-4952-AD62-7061268C9F8B",
                                    "topics":[
                                        {
                                            "title":"OracleCollection<TKey, TRecord>(OracleDataSource, string, OracleCollectionOptions?)",
                                            "href":"CollectionCtor1.html#GUID-976FAE93-FF20-48C4-AE51-C8BEC7B422AE"
                                        },
                                        {
                                            "title":"OracleCollection<TKey, TRecord>(string, string, OracleCollectionOptions?)",
                                            "href":"CollectionCtor2.html#GUID-98E998F1-396A-4B35-9963-6FA3E45403F9"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCollection Properties",
                                    "href":"OracleCollectionProperties.html#GUID-8AE8A5DD-589F-4AF6-92F6-A4DDD6EFA9F1",
                                    "topics":[
                                        {
                                            "title":"Name",
                                            "href":"CollectionName.html#GUID-3CC57FFF-E19C-4E95-A7CC-B4BB10B25A99"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleCollection Public Methods",
                                    "href":"OracleCollectionPublicMethods.html#GUID-4900D0FC-7035-4058-91E3-C07EE0FF4A8C",
                                    "topics":[
                                        {
                                            "title":"CollectionExistsAsync",
                                            "href":"CollectionCollectionExistsAsync.html#GUID-61FC7819-5559-40AF-801D-ECEC7853D3CA"
                                        },
                                        {
                                            "title":"DeleteAsync",
                                            "href":"CollectionDeleteAsyncOverloads.html#GUID-ECB4DA86-394F-4082-9C8E-7C54A4CF2B34"
                                        },
                                        {
                                            "title":"DeleteAsync(TKey key, CancellationToken)",
                                            "href":"CollectionDeleteAsync1.html#GUID-CABF5892-1FA9-48D4-99E2-4E85C70CCA8C"
                                        },
                                        {
                                            "title":"DeleteAsync(IEnumerable<TKey> keys, CancellationToken)",
                                            "href":"CollectionDeleteAsync2.html#GUID-AEDF1D08-EBCC-4037-AE53-D23DD5390503"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"CollectionDispose.html#GUID-7E700A49-0E6E-44BD-A85B-F720929E2237"
                                        },
                                        {
                                            "title":"EnsureCollectionDeletedAsync",
                                            "href":"CollectionEnsureCollectionDeletedAsync.html#GUID-923B98C0-3241-4C56-99CA-9BF5B6803684"
                                        },
                                        {
                                            "title":"EnsureCollectionExistsAsync",
                                            "href":"CollectionEnsureCollectionExistsAsync.html#GUID-D731577B-60BE-45EC-B631-451EE2B1E027"
                                        },
                                        {
                                            "title":"GetAsync",
                                            "href":"CollectionGetAsyncOverloads.html#GUID-4641FE7F-65F2-49E2-B4CF-F053202CFA25"
                                        },
                                        {
                                            "title":"GetAsync(TKey , RecordRetrieveOptions?, CancellationToken)",
                                            "href":"CollectionGetAsync1.html#GUID-4B4793C1-369F-469E-9568-7622B7B290F2"
                                        },
                                        {
                                            "title":"GetAsync(IEnumerable<TKey>, RecordRetrieveOptions?, CancellationToken)",
                                            "href":"CollectionGetAsync2.html#GUID-A88B99B7-7B5B-4E2E-9BC8-B8B59996D2B3"
                                        },
                                        {
                                            "title":"GetAsync(Expression<Func<TRecord, bool>>, int, FilteredRecordRetrievalOptions<TRecord>?, CancellationToken)",
                                            "href":"CollectionGetAsync3.html#GUID-E3D51A9F-A077-4C45-B1B3-2B07AC0C8E4B"
                                        },
                                        {
                                            "title":"GetService",
                                            "href":"CollectionGetService.html#GUID-2F7C73FF-7A29-44BE-902C-ED271AD8DC61"
                                        },
                                        {
                                            "title":"SearchAsync",
                                            "href":"CollectionSearchAsync.html#GUID-74ED6D00-E350-4C82-A2FA-5CA17C338B3E"
                                        },
                                        {
                                            "title":"UpsertAsync",
                                            "href":"CollectionUpsertAsyncOverloads.html#GUID-88586FCD-E849-476C-B141-A656F4540AE3"
                                        },
                                        {
                                            "title":"UpsertAsync(TRecord, CancellationToken)",
                                            "href":"CollectionUpsertAsync1.html#GUID-BF66A4F7-6DE1-4B60-AF9A-67CDF5065324"
                                        },
                                        {
                                            "title":"UpsertAsync(IEnumerable<TRecord>, CancellationToken)",
                                            "href":"CollectionUpsertAsync2.html#GUID-61C8483F-9053-41F7-A1C3-989AE4652E23"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleCollectionOptions Class",
                            "href":"OracleCollectionOptionsClass.html#GUID-E8F206A7-8CFD-4BFA-9534-30F257862EDC",
                            "topics":[
                                {
                                    "title":"OracleCollectionOptions Constructor",
                                    "href":"OracleCollectionOptionsConstructor.html#GUID-E3EC6512-18F7-4C58-AB51-FB7C0DE957E2"
                                },
                                {
                                    "title":"OracleCollectionOptions Properties",
                                    "href":"OracleCollectionOptionsProperties.html#GUID-BE970B19-DA79-4EF9-9C62-95622CBAFBCB",
                                    "topics":[
                                        {
                                            "title":"EmbeddingGenerator",
                                            "href":"CollectionOptionsEmbeddingGenerator.html#GUID-F65C87AF-AA31-4A43-9919-9E4BE2B3CC1E"
                                        },
                                        {
                                            "title":"Schema",
                                            "href":"CollectionOptionsSchema.html#GUID-49A2C9D6-447B-4FC4-BE83-4B355A246592"
                                        },
                                        {
                                            "title":"Definition",
                                            "href":"CollectionOptionsDefinition.html#GUID-3D2A1C22-4AB8-4D3F-BA6E-A09121D37ECB"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleDynamicCollection Class",
                            "href":"OracleDynamicCollectionClass.html#GUID-77B79A5E-A5DB-48FA-A83D-851BEAE412A3",
                            "topics":[
                                {
                                    "title":"OracleDynamicCollection Constructors",
                                    "href":"OracleDynamicCollectionConstructors.html#GUID-71EE8A67-AA27-4965-85AA-8A5235B0912D",
                                    "topics":[
                                        {
                                            "title":"OracleDynamicCollection(OracleDataSource, string, OracleCollectionOptions)",
                                            "href":"DynamicCollectionCtor1.html#GUID-7C1D3A84-05F1-4D21-AC2E-89B0D239D123"
                                        },
                                        {
                                            "title":"OracleDynamicCollection(string, string, OracleCollectionOptions)",
                                            "href":"DynamicCollectionCtor2.html#GUID-B122D38E-0AEB-48D2-A5B3-E2481C9C612F"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDynamicCollection Properties",
                                    "href":"OracleDynamicCollectionProperties.html#GUID-2271417D-C0C6-4C1F-8F85-923F40CF0F43",
                                    "topics":[
                                        {
                                            "title":"Name",
                                            "href":"DynamicCollectionName.html#GUID-29612DD5-E5BD-46C8-AA50-824F2331EA27"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleDynamicCollection Public Methods",
                                    "href":"OracleDynamicCollectionPublicMethods.html#GUID-32A0EA4B-6626-4D81-A90C-068FE0DAB1BB",
                                    "topics":[
                                        {
                                            "title":"CollectionExistsAsync",
                                            "href":"DynamicCollectionCollectionExistsAsync.html#GUID-BA0D4861-A656-4A9A-8EFD-3AA75FE1A2EB"
                                        },
                                        {
                                            "title":"DeleteAsync",
                                            "href":"DynamicCollectionDeleteAsyncOverloads.html#GUID-91229504-16CB-43CC-970C-E585E88680D9"
                                        },
                                        {
                                            "title":"DeleteAsync(Object key, CancellationToken)",
                                            "href":"DynamicCollectionDeleteAsync1.html#GUID-E2D6F441-5919-43DA-B163-CE0579D1AD5C"
                                        },
                                        {
                                            "title":"DeleteAsync(IEnumerable<Object> keys, CancellationToken)",
                                            "href":"DynamicCollectionDeleteAsync2.html#GUID-DBAE63D0-8090-4827-BAAA-554BADCAAD3B"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"DynamicCollectionDispose.html#GUID-BB1E2EEB-08E7-42AD-8F66-3D50F79E4A7D"
                                        },
                                        {
                                            "title":"EnsureCollectionDeletedAsync",
                                            "href":"DynamicCollectionEnsureCollectionDeletedAsync.html#GUID-7B1367AC-803D-42E4-BF6F-F6E03AE6196F"
                                        },
                                        {
                                            "title":"EnsureCollectionExistsAsync",
                                            "href":"DynamicCollectionEnsureCollectionExistsAsync.html#GUID-36A2A7EA-3AC5-475E-9A55-DCAD5FB6EA85"
                                        },
                                        {
                                            "title":"GetAsync(Object , RecordRetrieveOptions?, CancellationToken)",
                                            "href":"DynamicCollectionGetAsync1.html#GUID-FB60E7E8-9815-4C41-904D-6ADA6205466A"
                                        },
                                        {
                                            "title":"GetAsync(IEnumerable<Object>, RecordRetrieveOptions?, CancellationToken)",
                                            "href":"DynamicCollectionGetAsync2.html#GUID-269074A5-B317-4F55-9895-C77DB5DA620A"
                                        },
                                        {
                                            "title":"GetAsync(Expression<Func<Dictionary<string, object?>, bool>>, int,<Dictionary<string, object?>>?, CancellationToken )",
                                            "href":"DynamicCollectionGetAsync3.html#GUID-AC04026B-2B99-41B3-B162-7687FE005143"
                                        },
                                        {
                                            "title":"GetService",
                                            "href":"DynamicCollectionGetService.html#GUID-76A2FE28-A8D4-4DD5-A16E-F3DD75FC6977"
                                        },
                                        {
                                            "title":"SearchAsync",
                                            "href":"DynamicCollectionSearchAsync.html#GUID-E009CF15-AF49-4221-BFE2-773545F47D04"
                                        },
                                        {
                                            "title":"UpsertAsync",
                                            "href":"DynamicCollectionUpsertAsyncOverloads.html#GUID-E84AD0B4-54C7-46F5-84A5-0B1FB7DBCB9C"
                                        },
                                        {
                                            "title":"UpsertAsync(Dictionary<string, object?>, CancellationToken)",
                                            "href":"DynamicCollectionUpsertAsync1.html#GUID-8AF3500A-AADF-497B-AF2F-C3042FCF0BE4"
                                        },
                                        {
                                            "title":"UpsertAsync(IEnumerable<Dictionary<string, object?>>, CancellationToken)",
                                            "href":"DynamicCollectionUpsertAsync2.html#GUID-AF9FFB2E-67F5-4F29-B3D5-D327181FE2FF"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleServiceCollectionExtensions Class",
                            "href":"OracleServiceCollectionExtensionsClass.html#GUID-CB47D3C1-4BDF-4F91-B0E3-3E0C5DA319B4",
                            "topics":[
                                {
                                    "title":"OracleServiceCollectionExtensions Static Methods",
                                    "href":"OracleServiceCollectionExtensionsStaticMethods.html#GUID-2E869938-243D-4D62-BA14-88C9E51E4F80",
                                    "topics":[
                                        {
                                            "title":"AddKeyedOracleCollection",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleCollectionOverloads.html#GUID-C2788688-064D-4D38-83F4-42F841A0C156"
                                        },
                                        {
                                            "title":"AddKeyedOracleCollection<TKey, TRecord>(IServiceCollection, object?, string, Func<IServiceProvider, string>, Func<IServiceProvider, OracleVectorCollectionOptions>?, ServiceLifetime )",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleCollection1.html#GUID-101EFBCD-7784-452C-B05D-E4A94382DB40"
                                        },
                                        {
                                            "title":"AddKeyedOracleCollection<TKey, TRecord>(IServiceCollection, object?, string, string,OracleCollectionOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleCollection2.html#GUID-6D2758FD-261C-454A-8012-3FDDF56A978A"
                                        },
                                        {
                                            "title":"AddKeyedOracleVectorStore",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleVectorStoreOverloads.html#GUID-C63C1C48-63D8-476E-9174-FC3D07BD30BF"
                                        },
                                        {
                                            "title":"AddKeyedOracleVectorStore(IServiceCollection, object?, Func<IServiceProvider, string>, Func<IServiceProvider, OracleVectorStoreOptions>?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleVectorStore1.html#GUID-BCC890C4-A166-4948-A4F4-8A2F941E5BCC"
                                        },
                                        {
                                            "title":"AddKeyedOracleVectorStore(IServiceCollection, object?, string, OracleVectorStoreOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddKeyedOracleVectorStore2.html#GUID-22714ADC-84A8-4339-9686-02F0CC120B73"
                                        },
                                        {
                                            "title":"AddOracleCollection",
                                            "href":"ServiceCollectionExtensionsAddOracleCollectionOverloads.html#GUID-2CB6F9B9-7CF2-4483-BB31-F644A4F20F4A"
                                        },
                                        {
                                            "title":"AddOracleCollection<TKey, TRecord>(IServiceCollection, string, Func<IServiceProvider, string>, Func<IServiceProvider, OracleCollectionsOptions>?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleCollection1.html#GUID-45BE63C3-35F1-43D1-9FBD-FE9CFD1F4D4F"
                                        },
                                        {
                                            "title":"AddOracleCollection<TKey, TRecord>(IServiceCollection, string, string, OracleCollectionOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleCollection2.html#GUID-C1F01FF8-9C12-4DA4-A259-4A2B797B1268"
                                        },
                                        {
                                            "title":"AddOracleCollection<TKey, TRecord>(this IServiceCollection, string, OracleCollectionOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleCollection3.html#GUID-EB9BB87E-B43D-4821-A000-2D96A8E3F214"
                                        },
                                        {
                                            "title":"AddOracleVectorStore",
                                            "href":"ServiceCollectionExtensionsAddOracleVectorStoreOverloads.html#GUID-BCF0288A-EDC7-40E5-B1A4-2AE22FC7A065"
                                        },
                                        {
                                            "title":"AddOracleVectorStore(this IServiceCollection, OracleVectorStoreOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleVectorStore1.html#GUID-C2BA6CEA-78D5-4905-ADC1-F71AB74CAA4B"
                                        },
                                        {
                                            "title":"AddOracleVectorStore(IServiceCollection, string, OracleVectorStoreOptions?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleVectorStore2.html#GUID-E5A8D2FF-51F2-4E67-A403-6AF017EE9BB7"
                                        },
                                        {
                                            "title":"AddOracleVectorStore(IServiceCollection, Func<IServiceProvider, string>, Func<IServiceProvider, OracleVectorStoreOptions>?, ServiceLifetime)",
                                            "href":"ServiceCollectionExtensionsAddOracleVectorStore3.html#GUID-7C237418-5E44-489B-8109-08E16B65F9F7"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleVectorStore Class",
                            "href":"OracleVectorStoreClass.html#GUID-D6031CA3-540C-4709-99F3-604386C12741",
                            "topics":[
                                {
                                    "title":"OracleVectorStore Constructors",
                                    "href":"OracleVectorStoreConstructors.html#GUID-04C91E49-35D1-404D-8BD4-F4C855A6D8A3",
                                    "topics":[
                                        {
                                            "title":"OracleVectorStore(OracleDataSource, OracleVectorStoreOptions?)",
                                            "href":"VectorStoreCtor1.html#GUID-4F1068D5-BDB1-4D16-B76A-3052D765D1B5"
                                        },
                                        {
                                            "title":"OracleVectorStore(string connectionString, OracleVectorStoreOptions?)",
                                            "href":"VectorStoreCtor2.html#GUID-DA70B302-98C3-404D-8A13-1A963A011AE6"
                                        }
                                    ]
                                },
                                {
                                    "title":"OracleVectorStore Public Methods",
                                    "href":"OracleVectorStorePublicMethods.html#GUID-D7C66746-5941-4BF3-9E08-53F4C32B12CA",
                                    "topics":[
                                        {
                                            "title":"CollectionExistsAsync",
                                            "href":"VectorStoreCollectionExistsAsync.html#GUID-CFD9442F-B682-4895-AE47-765B4AE7FC21"
                                        },
                                        {
                                            "title":"Dispose",
                                            "href":"VectorStoreDispose.html#GUID-0029BF59-54D2-4487-8484-87DBF4FA5C84"
                                        },
                                        {
                                            "title":"EnsureCollectionDeletedAsync",
                                            "href":"VectorStoreEnsureCollectionDeletedAsync.html#GUID-37AABECA-4114-424E-9171-EBF0542A9A04"
                                        },
                                        {
                                            "title":"GetCollection(string, VectorStoreCollectionDefinition?)",
                                            "href":"VectorStoreGetCollection.html#GUID-14CF9416-CE88-4FCF-805B-84B6905CF778"
                                        },
                                        {
                                            "title":"GetDynamicCollection(string, VectorStoreCollectionDefinition)",
                                            "href":"VectorStoreGetDynamicCollection.html#GUID-80290EBE-7988-4D99-98E5-14ED8768843E"
                                        },
                                        {
                                            "title":"GetService",
                                            "href":"VectorStoreGetService.html#GUID-CB4C200F-8ABB-4BAB-A829-5F9AD6BC2155"
                                        },
                                        {
                                            "title":"ListCollectionNamesAsync",
                                            "href":"VectorStoreListCollectionNamesAsync.html#GUID-C5BF4466-6EFB-46AF-BF6B-3B99865226B8"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"OracleVectorStoreOptions Class",
                            "href":"OracleVectorStoreOptionsClass.html#GUID-3F4E33A6-196C-4204-94D5-D4DCE8701AA6",
                            "topics":[
                                {
                                    "title":"OracleVectorStoreOptions Constructor",
                                    "href":"OracleVectorStoreOptionsConstructor.html#GUID-AB2459C7-0296-4BA4-B21C-289A030E5CF6"
                                },
                                {
                                    "title":"OracleVectorStoreOptions Properties",
                                    "href":"OracleVectorStoreOptionsProperties.html#GUID-F7687F71-94B9-413F-A1AE-1C6BEBD5B215",
                                    "topics":[
                                        {
                                            "title":"EmbeddingGenerator",
                                            "href":"VectorStoreOptionsEmbeddingGenerator.html#GUID-4B79B0CC-E16F-46E3-AC95-F3A70DF004EF"
                                        },
                                        {
                                            "title":"Schema",
                                            "href":"VectorStoreOptionsSchema.html#GUID-EF3C43F5-F4B7-42E3-A38E-96334191AE33"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle Schema Collections",
                    "href":"schema-collections.html#GUID-F0018CF6-FE67-4CB4-ACA7-177177D98335",
                    "topics":[
                        {
                            "title":"Common Schema Collections",
                            "href":"appCommonSchema.html#GUID-CA387F46-DC29-4204-AADB-8C4289AEB935"
                        },
                        {
                            "title":"ODP.NET-Specific Schema Collection",
                            "href":"appSpecificSchema.html#GUID-9A44ED6B-EADE-43AE-B3F5-E140648B0195"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Mapping LINQ Canonical Functions and Oracle Functions",
                    "href":"Mapping-LINQ-Canonical-Functions-Oracle-Functions.html#GUID-318B7438-0259-4251-A137-8D0C8198BCD1"
                },
                {
                    "title":"Glossary",
                    "href":"glossary.html#GUID-B2045BB3-AC78-42A6-ADA7-73229D7D49E3"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});