define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"rdf-preface.html#GUID-0BE082F8-C2FA-4BAA-8957-18CAB973B652"
                },
                {
                    "title":"Changes in This Release for This Guide",
                    "href":"rdf-whats-new.html#GUID-E306BD95-F6CC-4B12-ACFB-5F950A640E03"
                },
                {
                    "title":"How to Use This Book",
                    "href":"how-use-this-book.html"
                },
                {
                    "title":"Part I Conceptual and Usage Information",
                    "href":"conceptual-and-usage-information.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> RDF Graph Overview",
                            "href":"rdf-graph-overview.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1 </span> Introduction to Oracle Semantic Technologies Support",
                                    "href":"introduction-oracle-semantic-technologies-support.html#GUID-77238928-AF9C-4AF1-8833-79E994DC5506"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.2 </span> Key Terms and Concepts for Working with RDF Graphs",
                                    "href":"key-terms-and-concepts-working-oracle-rdf-graph.html#GUID-7AE08EF9-3E78-413F-8478-501DAB42F958"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.3 </span> RDF Data Modeling",
                                    "href":"rdf-data-modeling.html#GUID-02FEDB66-9AA8-4819-91E3-35F3FA02C5F7"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4 </span> RDF Data in the Database",
                                    "href":"rdf-data-database.html#GUID-CE09AF8B-6296-4100-91E5-57F5C5B225F6"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5 </span> RDF Metadata Tables and Views",
                                    "href":"rdf-metadata-tables-and-views.html#GUID-6F93C56B-9007-4F37-9A8F-0ECF4AC204A5"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.6 </span> RDF Data Types, Constructors, and Methods",
                                    "href":"rdf-data-types_-constructors_-and-methods.html#GUID-D7734D1A-EAC0-4581-B3CC-2E23C8F97D94"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.7 </span> Using the SEM_MATCH Table Function to Query RDF Data",
                                    "href":"using-sem_match-table-function-query-rdf-data.html#GUID-71464CC4-1C03-48A4-9A4C-0E671FF8F16E"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.8 </span> Speeding up Query Execution with Result Tables",
                                    "href":"speeding-query-execution-result-tables.html#GUID-7E3A79D5-7BDA-48B7-A5A5-BC3B8A65F4AD"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.9 </span> Using the SEM_APIS.SPARQL_TO_SQL Function to Query RDF Data",
                                    "href":"using-sem_apis-sparql_to_sql-function-query-semantic-data.html#GUID-D90AABC8-81CA-4212-B1A1-C03B818D46C6"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.10 </span> Using the SEM_APIS.GET_SQL Function and SEM_SQL SQL Macro to Query RDF Data",
                                    "href":"using-sem_apis-get_sql-function-and-sem_sql-sql-macro-query-rdf-data.html#GUID-C40B4541-D035-483B-9322-59E59508037C"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.11 </span> Loading and Exporting RDF Data",
                                    "href":"loading-and-exporting-rdf-data.html#GUID-65045BFA-D0FE-4720-BF68-2C45765C74E9"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.12 </span> Using RDF Network Indexes",
                                    "href":"using-rdf-network-indexes.html#GUID-159DBD08-E59E-4A16-8EA9-5B40EB964D12"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.13 </span> Using Data Type Indexes",
                                    "href":"using-data-type-indexes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.14 </span> Managing Statistics for the RDF Graphs and RDF Network",
                                    "href":"managing-statistics-rdf-graphs-and-network.html#GUID-273402FC-2C92-4B36-981A-1E8644FB7134"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.15 </span> Support for SPARQL Update Operations on an RDF Graph",
                                    "href":"support-sparql-update-operations-rdf-graph.html#GUID-933AEB65-4F16-40BB-9FA4-0E16380607EB"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.16 </span> RDF Support for Oracle AI Database In-Memory",
                                    "href":"rdf-support-oracle-database-memory.html#GUID-AD26A431-B5A5-4681-AFFF-42C473AB7936"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.17 </span> RDF Support for Materialized Join Views",
                                    "href":"rdf-support-materialized-join-views.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.18 </span> RDF Support in Oracle SQL Developer",
                                    "href":"rdf-support-oracle-sql-developer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.19 </span> Enhanced RDF ORDER BY Query Processing",
                                    "href":"enhanced-rdf-order-query-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.20 </span> Applying Oracle Machine Learning Algorithms to RDF Data",
                                    "href":"applying-oracle-machine-learning-algorithms-rdf-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.21 </span> RDF Graph Management Examples (PL/SQL and Java)",
                                    "href":"rdf-graph-management-examples-pl-sql-and-java.html#GUID-2A9B194C-2540-42C7-A783-4A32ADA6F1F4"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.22 </span> Software Naming Changes Since Release 11.1",
                                    "href":"software-naming-changes-release-11.1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.23 </span> For More Information About RDF Graph",
                                    "href":"more-information-rdf-graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.24 </span> Required Migration of Pre-12.2 RDF Data",
                                    "href":"required-migration-12.2-rdf-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.25 </span> Oracle RDF Graph Features that Support Accessibility",
                                    "href":"oracle-rdf-graph-features-that-support-accessibility.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> Quick Start for Using RDF Data",
                            "href":"quick-start-using-rdf-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1 </span> Getting Started with RDF Data in a Schema-Private Network",
                                    "href":"getting-started-rdf-data-schema-private-network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2 </span> Quick Start for Using RDF Data in Oracle Autonomous AI Database",
                                    "href":"quick-start-using-rdf-data-oracle-autonomous-ai-database.html#GUID-EEEFDD28-2356-4ED2-BCD6-D226DEC4FCB5"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3 </span> OWL Concepts",
                            "href":"owl-concepts.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1 </span> Ontologies",
                                    "href":"ontologies.html#GUID-3471DB36-45BB-4274-8E74-39DC8EF83C99"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2 </span> Using OWL Inferencing",
                                    "href":"using-owl-inferencing.html#GUID-30145814-CB5E-45ED-B220-677515F91AA9"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3 </span> Using Semantic Operators to Query Relational Data",
                                    "href":"using-semantic-operators-query-relational-data.html#GUID-91E180EF-CCF0-4E56-859E-D25C019A31A0"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> Simple Knowledge Organization System (SKOS) Support",
                            "href":"simple-knowledge-organizaiton-system-skos.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1 </span> Supported and Unsupported SKOS Semantics",
                                    "href":"supported-and-unsupported-skos-semantics.html#GUID-52875AF0-9079-4D7F-A392-B16C7C5C6A45"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2 </span> Performing Inference on SKOS RDF Graphs",
                                    "href":"performing-inference-skos-rdf-graphs.html#GUID-2FC67135-2020-49C2-B53E-3AFD0144E383"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5 </span> Semantic Indexing for Documents",
                            "href":"semantic-indexing-documents.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1 </span> Information Extractors for Semantically Indexing Documents",
                                    "href":"information-extractors-semantically-indexing-documents.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2 </span> Extractor Policies",
                                    "href":"extractor-policies.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3 </span> Semantically Indexing Documents",
                                    "href":"semantically-indexing-documents.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.4 </span> SEM_CONTAINS and Ancillary Operators",
                                    "href":"sem_contains-and-ancillary-operators.html#GUID-196189F0-AA72-4900-9D9A-4AD17F036133"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.5 </span> Searching for Documents Using SPARQL Query Patterns",
                                    "href":"searching-documents-using-sparql-query-patterns.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.6 </span> Bindings for SPARQL Variables in Matching Subgraphs in a Document (SEM_CONTAINS_SELECT Ancillary Operator)",
                                    "href":"bindings-sparql-variables-matching-subgraphs-document-sem_contains_select-ancillary-operator.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.7 </span> Improving the Quality of Document Search Operations",
                                    "href":"improving-quality-document-search-operations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.8 </span> Indexing External Documents",
                                    "href":"indexing-external-documents.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.9 </span> Configuring the Calais Extractor type",
                                    "href":"configuring-calais-extractor-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.10 </span> Working with General Architecture for Text Engineering (GATE)",
                                    "href":"working-general-architecture-text-engineering-gate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.11 </span> Creating a New Extractor Type",
                                    "href":"creating-new-extractor-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.12 </span> Creating a Local Semantic Index on a Range-Partitioned Table",
                                    "href":"creating-local-semantic-index-range-partitioned-table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.13 </span> Altering a Semantic Index",
                                    "href":"altering-semantic-index.html#GUID-78F0B53C-3CE6-4700-844B-44F53119583A"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.14 </span> Passing Extractor-Specific Parameters in CREATE INDEX and ALTER INDEX",
                                    "href":"passing-extractor-specific-parameters-create-index-and-alter-index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.15 </span> Performing Document-Centric Inference",
                                    "href":"performing-document-centric-inference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.16 </span> Metadata Views for Semantic Indexing",
                                    "href":"metadata-views-semantic-indexing.html#GUID-0C0409E6-2EED-4468-8F29-2FB00A51995C"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.17 </span> Default Style Sheet for GATE Extractor Output",
                                    "href":"default-style-sheet-gate-extractor-output.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6 </span> Fine-Grained Access Control for RDF Data",
                            "href":"fine-grained-access-control-rdf-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1 </span> Triple-Level Security",
                                    "href":"triple-level-security.html#GUID-3514B1AC-B47C-4AE6-A7A1-C2D57C22E4B7"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2 </span> Triple-and-Values Security",
                                    "href":"triple-and-values-security.html#GUID-2E1ED0E2-2C97-42D3-9A97-F4D373F48A5D"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7 </span> RDF Graph Support for Apache Jena",
                            "href":"rdf-graph-support-apache-jena.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1 </span> Setting Up the Software Environment",
                                    "href":"setting-software-environment.html#GUID-17E0C43D-2625-4D69-BBD7-1BCF204684EA"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2 </span> Setting Up the SPARQL Service",
                                    "href":"setting-sparql-service.html#GUID-BD74255C-3534-4019-979B-C43817B4C58D"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3 </span> Setting Up the RDF Graph Environment",
                                    "href":"setting-rdf-graph-environment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.4 </span> SEM_MATCH and RDF Graph Support for Apache Jena Queries Compared",
                                    "href":"sem_match-and-rdf-graph-support-apache-jena-queries-compared.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.5 </span> Retrieving User-Friendly Java Objects from SEM_MATCH or SQL-Based Query Results",
                                    "href":"retrieving-user-friendly-java-objects-sem_match-or-sql-based-query-results.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.6 </span> Optimized Handling of SPARQL Queries",
                                    "href":"optimized-handling-sparql-queries.html#GUID-F6416355-45C1-4FAF-83E4-7EBFA902EA7A"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.7 </span> Additions to the SPARQL Syntax to Support Other Features",
                                    "href":"additions-sparql-syntax-support-other-features.html#GUID-9B0B74F2-9733-491E-A97C-BB485D33518C"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.8 </span> Functions Supported in SPARQL Queries through RDF Graph Support for Apache Jena",
                                    "href":"functions-supported-sparql-queries-rdf-graph-support-apache-jena.html#GUID-D7D68CA5-24BF-4546-8679-8AF4AA96C38C"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.9 </span> SPARQL Update Support",
                                    "href":"sparql-update-support.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.10 </span> Analytical Functions for RDF Data",
                                    "href":"analytical-functions-rdf-data.html#GUID-828999B9-6B4D-4BA1-AC00-953D20212F24"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.11 </span> Support for Server-Side APIs",
                                    "href":"support-server-side-apis.html#GUID-CBBCF550-832C-402A-89D2-0CDA62D27F0C"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.12 </span> Bulk Loading Using RDF Graph Support for Apache Jena",
                                    "href":"bulk-loading-using-rdf-graph-support-apache-jena.html#GUID-1109AB37-AFD5-4172-B7E5-6F279782A22E"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.13 </span> Automatic Variable Renaming",
                                    "href":"automatic-variable-renaming.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.14 </span> JavaScript Object Notation (JSON) Format Support",
                                    "href":"javascript-object-notation-json-format-support.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.15 </span> Other Recommendations and Guidelines",
                                    "href":"other-recommendations-and-guidelines.html#GUID-78916DE5-15D7-4E6B-B8CA-23DF0D89423C"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.16 </span> Example Queries Using RDF Graph Support for Apache Jena",
                                    "href":"example-queries-using-rdf-graph-support-apache-jena.html#GUID-9F748C0E-437D-4EBD-80CF-BFA91F3CFE3A"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.17 </span> SPARQL Gateway and RDF Data",
                                    "href":"sparql-gateway-and-rdf-data.html#GUID-649269C9-6EB8-489C-B139-073CB8BA768E"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.18 </span> Deploying Fuseki in Apache Tomcat",
                                    "href":"deploying-fuseki-apache-tomcat.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.19 </span> ORARDFLDR Utility for Bulk Loading RDF Data",
                                    "href":"orardfldr-utility-bulk-loading-rdf-data.html#GUID-26643E79-59D5-4211-9032-C315D01DEC74"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8 </span> RDF Graph Support for Eclipse RDF4J",
                            "href":"rdf-graph-support-eclipse-rdf4j.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1 </span> Oracle RDF Graph Support for Eclipse RDF4J Overview",
                                    "href":"rdf-graph-support-eclipse-rdf4j-overview.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2 </span> Prerequisites for Using Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"prerequisites-using-oracle-rdf-graph-adapter-eclipse-rdf4j.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3 </span> Setup and Configuration for Using Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"setup-and-configuration-using-oracle-rdf-graph-adapter-eclipse-rdf4j.html#GUID-1A22526C-BEC1-4FD0-A7F7-7039AEB4868E"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4 </span> Using Oracle RDF Graph Adapter for Eclipse RDF4J with Oracle Autonomous AI Database",
                                    "href":"using-oracle-rdf-graph-adapter-eclipse-rdf4j-oracle-autonomous-ai-databas.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.5 </span> Database Connection Management",
                                    "href":"database-connection-management.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.6 </span> SPARQL Query Execution Model",
                                    "href":"sparql-query-execution-model.html#GUID-3F1EDF3A-F56C-4800-948C-966BF90C5D58"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.7 </span> SPARQL Update Execution Model",
                                    "href":"sparql-update-execution-model.html#GUID-9B7ABAA0-098A-45D1-989D-6146F61882E0"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.8 </span> Efficiently Loading RDF Data",
                                    "href":"efficiently-loading-rdf-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.9 </span> Validating RDF Data with SHACL Constraints",
                                    "href":"validating-rdf-data-shacl-constraints.html#GUID-D172C261-52C3-4C75-85B0-F5FE178BFAF2"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.10 </span> ORARDFLDR Utility for Bulk Loading RDF Data",
                                    "href":"orardfldr-utility-bulk-loading-rdf-data1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.11 </span> Best Practices for Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"best-practices-oracle-rdf-graph-adapter-eclipse-rdf4j.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.12 </span> Blank Nodes Support in Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"blank-nodes-support-oracle-rdf-graph-adapter-eclipse-rdf4j.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.13 </span> Unsupported Features in Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"unsupported-features-oracle-rdf-graph-adapter-eclipse-rdf4j.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.14 </span> Example Queries Using Oracle RDF Graph Adapter for Eclipse RDF4J",
                                    "href":"example-queries-using-oracle-rdf-graph-adapter-eclipse-rdf4j.html#GUID-D1732ECC-0DC9-4426-B345-172F81B2F879"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9 </span> User-Defined Inferencing and Querying",
                            "href":"user-defined-inferencing-and-querying.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.1 </span> User-Defined Inferencing",
                                    "href":"user-defined-inferencing.html#GUID-C0D74403-EE99-4E4A-9C44-F1C2B84B01DC"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.2 </span> User-Defined Functions and Aggregates",
                                    "href":"user-defined-functions-and-aggregates.html#GUID-26520C46-3A90-40AB-8403-140A82AC73CC"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.3 </span> SPARQL Rule-Based Inference",
                                    "href":"sparql-rule-based-inference.html#GUID-23255827-857E-40F4-8A5B-AB5520B32B8A"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10 </span> RDF Views: Relational Data as RDF",
                            "href":"rdf-views-relational-data-rdf.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1 </span> Why Use RDF Views on Relational Data?",
                                    "href":"why-use-rdf-views-relational-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.2 </span> API Support for RDF Views",
                                    "href":"api-support-rdf-views.html#GUID-213D209A-82C1-4E92-8F42-06C5F25B00BF"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.3 </span> Example: Using an RDF View Graph with Direct Mapping",
                                    "href":"example-using-rdf-view-graph-direct-mapping.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4 </span> Combining Native RDF Data with Virtual RDB2RDF Data",
                                    "href":"combining-native-rdf-data-virtual-rdb2rdf-data.html#GUID-7EE22B1F-D5C1-4F0F-85B9-CAB4BB815819"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11 </span> Creating Property Graphs from RDF Graphs",
                            "href":"creating-property-graphs-rdf-graphs.html"
                        }
                    ]
                },
                {
                    "title":"Part II RDF Graph Server and Query UI",
                    "href":"rdf-graph-server-and-query-ui.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12 </span> Introduction to RDF Graph Server and Query UI",
                            "href":"introduction-rdf-graph-server-and-client.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13 </span> RDF Graph Server and Query UI Concepts",
                            "href":"rdf-graph-server-and-query-ui-concepts.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.1 </span> Data Sources",
                                    "href":"data-sources.html#GUID-76B57B3C-C578-4B35-B5E6-CA4A9C73739A"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2 </span> RDF Datasets",
                                    "href":"rdf-datasets.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.3 </span> REST Services",
                                    "href":"rest-services.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14 </span> Oracle RDF Graph Query UI",
                            "href":"oracle-rdf-graph-query-ui.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1 </span> Installing RDF Graph Query UI",
                                    "href":"installing-rdf-graph-query-ui.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2 </span> Managing User Roles for RDF Graph Query UI",
                                    "href":"managing-user-roles-rdf-graph-query-ui.html#GUID-D6DC1D2F-AC7C-4B25-B8EF-D30B1FDB4B8D"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.3 </span> Getting Started with RDF Graph Query UI",
                                    "href":"gettting-started-rdf-graph-query-ui.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">14.3.1 </span> Data Sources Page",
                                            "href":"data-sources-page.html#GUID-8FF43980-B34A-4124-9172-2EE36AFB09A6"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.3.2 </span> RDF Data Page",
                                            "href":"rdf-data-page.html#GUID-C893B221-957C-462C-BE2B-79D46A3245E2"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.3.3 </span> Configuration Files for RDF Server and Client",
                                            "href":"configuration-files-rdf-server-and-client.html#GUID-C680A139-0E2D-4A7A-A09D-86892C6BFE51"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">14.4 </span> Accessibility",
                                    "href":"accessibility.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part III Reference Information",
                    "href":"reference-information.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15 </span> SEM_APIS Package Subprograms",
                            "href":"sem_apis-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.1 </span> SEM_APIS.ADD_DATATYPE_INDEX",
                                    "href":"sem_apis-add_datatype_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2 </span> SEM_APIS.ADD_NETWORK_INDEX",
                                    "href":"sem_apis-add_network_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.3 </span> SEM_APIS.ADD_SEM_INDEX",
                                    "href":"sem_apis-add_sem_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4 </span> SEM_APIS.ALTER_DATATYPE_INDEX",
                                    "href":"sem_apis-alter_datatype_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.5 </span> SEM_APIS.ALTER_ENTAILMENT",
                                    "href":"sem_apis-alter_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.6 </span> SEM_APIS.ALTER_INDEX_ON_INFERRED_GRAPH",
                                    "href":"sem_apis-alter_index_on_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.7 </span> SEM_APIS.ALTER_INDEX_ON_RDF_GRAPH",
                                    "href":"sem_apis-alter_index_on_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.8 </span> SEM_APIS.ALTER_INFERRED_GRAPH",
                                    "href":"sem_apis-alter_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.9 </span> SEM_APIS.ALTER_MODEL",
                                    "href":"sem_apis-alter_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.10 </span> SEM_APIS.ALTER_RDF_GRAPH",
                                    "href":"sem_apis-alter_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.11 </span> SEM_APIS.ALTER_RDF_INDEXES",
                                    "href":"sem_apis-alter_rdf_indexes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.12 </span> SEM_APIS.ALTER_RESULT_TAB",
                                    "href":"sem_apis-alter_result_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.13 </span> SEM_APIS.ALTER_SEM_INDEX_ON_ENTAILMENT",
                                    "href":"sem_apis-alter_sem_index_on_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.14 </span> SEM_APIS.ALTER_SEM_INDEX_ON_MODEL",
                                    "href":"sem_apis-alter_sem_index_on_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.15 </span> SEM_APIS.ALTER_SEM_INDEXES",
                                    "href":"sem_apis-alter_sem_indexes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.16 </span> SEM_APIS.ALTER_SPM_TAB",
                                    "href":"sem_apis-alter_spm_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.17 </span> SEM_APIS.ANALYZE_ENTAILMENT",
                                    "href":"sem_apis-analyze_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.18 </span> SEM_APIS.ANALYZE_INFERRED_GRAPH",
                                    "href":"sem_apis-analyze_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.19 </span> SEM_APIS.ANALYZE_MODEL",
                                    "href":"sem_apis-analyze_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.20 </span> SEM_APIS.ANALYZE_RDF_GRAPH",
                                    "href":"sem_apis-analyze_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.21 </span> SEM_APIS.APPEND_RDF_NETWORK_DATA",
                                    "href":"sem_apis-append_rdf_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.22 </span> SEM_APIS.APPEND_SEM_NETWORK_DATA",
                                    "href":"sem_apis-append_sem_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.23 </span> SEM_APIS.BUILD_RESULT_TAB",
                                    "href":"sem_apis-build_result_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.24 </span> SEM_APIS.BUILD_SPM_TAB",
                                    "href":"sem_apis-build_spm_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.25 </span> SEM_APIS.BULK_LOAD_FROM_STAGING_TABLE",
                                    "href":"sem_apis-bulk_load_from_staging_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.26 </span> SEM_APIS.BULK_LOAD_RDF_GRAPH",
                                    "href":"sem_apis-bulk_load_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.27 </span> SEM_APIS.CLEANUP_BNODES",
                                    "href":"sem_apis-cleanup_bnodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.28 </span> SEM_APIS.CLEANUP_FAILED",
                                    "href":"sem_apis-cleanup_failed.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.29 </span> SEM_APIS.COMPOSE_RDF_TERM",
                                    "href":"sem_apis-compose_rdf_term.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.30 </span> SEM_APIS.CONVERT_TO_GML311_LITERAL",
                                    "href":"sem_apis-convert_to_gml311_literal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.31 </span> SEM_APIS.CONVERT_TO_WKT_LITERAL",
                                    "href":"sem_apis-convert_to_wkt_literal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.32 </span> SEM_APIS.CREATE_ENTAILMENT",
                                    "href":"sem_apis-create_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.33 </span> SEM_APIS.CREATE_INDEX_ON_RESULT_TAB",
                                    "href":"sem_apis-create_index_on_result_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.34 </span> SEM_APIS.CREATE_INDEX_ON_SPM_TAB",
                                    "href":"sem_apis-create_index_on_spm_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.35 </span> SEM_APIS.CREATE_INFERRED_GRAPH",
                                    "href":"sem_apis-create_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.36 </span> SEM_APIS.CREATE_MATERIALIZED_VIEW",
                                    "href":"sem_apis-create_materialized_view.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.37 </span> SEM_APIS.SEM_APIS.CREATE_MV_BITMAP_INDEX",
                                    "href":"sem_apis-create_mv_bitmap_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.38 </span> SEM_APIS.CREATE_RDF_GRAPH",
                                    "href":"sem_apis-create_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.39 </span> SEM_APIS.CREATE_RDF_GRAPH_COLLECTION",
                                    "href":"sem_apis-create_rdf_graph_collection.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.40 </span> SEM_APIS.CREATE_RDF_NETWORK",
                                    "href":"sem_apis-create_rdf_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.41 </span> SEM_APIS.CREATE_RDFVIEW_GRAPH",
                                    "href":"sem_apis-create_rdfview_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.42 </span> SEM_APIS.CREATE_RDFVIEW_MODEL",
                                    "href":"sem_apis-create_rdfview_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.43 </span> SEM_APIS.CREATE_RULEBASE",
                                    "href":"sem_apis-create_rulebase.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.44 </span> SEM_APIS.CREATE_SEM_MODEL",
                                    "href":"sem_apis-create_sem_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.45 </span> SEM_APIS.CREATE_SEM_NETWORK",
                                    "href":"sem_apis-create_sem_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.46 </span> SEM_APIS.CREATE_SEM_SQL",
                                    "href":"sem_apis-create_sem_sql.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.47 </span> SEM_APIS.CREATE_SOURCE_EXTERNAL_TABLE",
                                    "href":"sem_apis-create_source_external_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.48 </span> SEM_APIS.CREATE_SPARQL_INFERRED_GRAPH",
                                    "href":"sem_apis-create_sparql_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.49 </span> SEM_APIS.CREATE_SPARQL_UPDATE_TABLES",
                                    "href":"sem_apis-create_sparql_update_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.50 </span> SEM_APIS.CREATE_VIRTUAL_MODEL",
                                    "href":"sem_apis-create_virtual_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.51 </span> SEM_APIS.DELETE_ENTAILMENT_STATS",
                                    "href":"sem_apis-delete_entailment_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.52 </span> SEM_APIS.DELETE_MODEL_STATS",
                                    "href":"sem_apis-delete_model_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.53 </span> SEM_APIS.DISABLE_CHANGE_TRACKING",
                                    "href":"sem_apis-disable_change_tracking.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.54 </span> SEM_APIS.DISABLE_INC_INFERENCE",
                                    "href":"sem_apis-disable_inc_inference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.55 </span> SEM_APIS.DISABLE_INMEMORY",
                                    "href":"sem_apis-disable_inmemory.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.56 </span> SEM_APIS.DISABLE_INMEMORY_FOR_ENT",
                                    "href":"sem_apis-disable_inmemory_for_ent.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.57 </span> SEM_APIS.DISABLE_INMEMORY_FOR_MODEL",
                                    "href":"sem_apis-disable_inmemory_for_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.58 </span> SEM_APIS.DISABLE_INMEMORY_FOR_INF_GRAPH",
                                    "href":"sem_apis-disable_inmemory_for_inf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.59 </span> SEM_APIS.DISABLE_INMEMORY_FOR_RDF_GRAPH",
                                    "href":"sem_apis-disable_inmemory_for_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.60 </span> SEM_APIS.DISABLE_NETWORK_SHARING",
                                    "href":"sem_apis-disable_network_sharing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.61 </span> SEM_APIS.DROP_DATATYPE_INDEX",
                                    "href":"sem_apis-drop_datatype_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.62 </span> SEM_APIS.DROP_ENTAILMENT",
                                    "href":"sem_apis-drop_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.63 </span> SEM_APIS.DROP_INFERRED_GRAPH",
                                    "href":"sem_apis-drop_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.64 </span> SEM_APIS.DROP_MATERIALIZED_VIEW",
                                    "href":"sem_apis-drop_materialized_view.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.65 </span> SEM_APIS.DROP_MV_BITMAP_INDEX",
                                    "href":"sem_apis-drop_mv_bitmap_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.66 </span> SEM_APIS.DROP_NETWORK_INDEX",
                                    "href":"sem_apis-drop_network_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.67 </span> SEM_APIS.DROP_RDF_GRAPH",
                                    "href":"sem_apis-drop_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.68 </span> SEM_APIS.DROP_RDF_GRAPH_COLLECTION",
                                    "href":"sem_apis-drop_rdf_graph_collection.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.69 </span> SEM_APIS.DROP_RDF_NETWORK",
                                    "href":"sem_apis-drop_rdf_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.70 </span> SEM_APIS.DROP_RDFVIEW_GRAPH",
                                    "href":"sem_apis-drop_rdfview_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.71 </span> SEM_APIS.DROP_RDFVIEW_MODEL",
                                    "href":"sem_apis-drop_rdfview_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.72 </span> SEM_APIS.DROP_RESULT_TAB",
                                    "href":"sem_apis-drop_result_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.73 </span> SEM_APIS.DROP_RULEBASE",
                                    "href":"sem_apis-drop_rulebase.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.74 </span> SEM_APIS.DROP_SEM_INDEX",
                                    "href":"sem_apis-drop_sem_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.75 </span> SEM_APIS.DROP_SEM_MODEL",
                                    "href":"sem_apis-drop_sem_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.76 </span> SEM_APIS.DROP_SEM_NETWORK",
                                    "href":"sem_apis-drop_sem_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.77 </span> SEM_APIS.DROP_SEM_SQL",
                                    "href":"sem_apis-drop_sem_sql.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.78 </span> SEM_APIS.DROP_SPARQL_UPDATE_TABLES",
                                    "href":"sem_apis-drop_sparql_update_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.79 </span> SEM_APIS.DROP_SPM_TAB",
                                    "href":"sem_apis-drop_spm_tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.80 </span> SEM_APIS.DROP_USER_INFERENCE_OBJS",
                                    "href":"sem_apis-drop_user_inference_objs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.81 </span> SEM_APIS.DROP_VIRTUAL_MODEL",
                                    "href":"sem_apis-drop_virtual_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.82 </span> SEM_APIS.ENABLE_CHANGE_TRACKING",
                                    "href":"sem_apis-enable_change_tracking.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.83 </span> SEM_APIS.ENABLE_INC_INFERENCE",
                                    "href":"sem_apis-enable_inc_inference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.84 </span> SEM_APIS.ENABLE_INMEMORY",
                                    "href":"sem_apis-enable_inmemory.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.85 </span> SEM_APIS.ENABLE_INMEMORY_FOR_ENT",
                                    "href":"sem_apis-enable_inmemory_for_ent.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.86 </span> SEM_APIS.ENABLE_INMEMORY_FOR_INF_GRAPH",
                                    "href":"sem_apis-enable_inmemory_for_inf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.87 </span> SEM_APIS.ENABLE_INMEMORY_FOR_MODEL",
                                    "href":"sem_apis-enable_inmemory_for_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.88 </span> SEM_APIS.ENABLE_INMEMORY_FOR_RDF_GRAPH",
                                    "href":"sem_apis-enable_inmemory_for_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.89 </span> SEM_APIS.ENABLE_NETWORK_SHARING",
                                    "href":"sem_apis-enable_network_sharing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.90 </span> SEM_APIS.ESCAPE_CLOB_TERM",
                                    "href":"sem_apis-escape_clob_term.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.91 </span> SEM_APIS.ESCAPE_CLOB_VALUE",
                                    "href":"sem_apis-escape_clob_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.92 </span> SEM_APIS.ESCAPE_RDF_TERM",
                                    "href":"sem_apis-escape_rdf_term.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.93 </span> SEM_APIS.ESCAPE_RDF_VALUE",
                                    "href":"sem_apis-escape_rdf_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.94 </span> SEM_APIS.EXPORT_ENTAILMENT_STATS",
                                    "href":"sem_apis-export_entailment_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.95 </span> SEM_APIS.EXPORT_MODEL_STATS",
                                    "href":"sem_apis-export_model_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.96 </span> SEM_APIS.EXPORT_RDFVIEW_GRAPH",
                                    "href":"sem_apis-export_rdfview_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.97 </span> SEM_APIS.EXPORT_RDFVIEW_MODEL",
                                    "href":"sem_apis-export_rdfview_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.98 </span> SEM_APIS.GATHER_SPM_INFO",
                                    "href":"sem_apis-gather_spm_info.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.99 </span> SEM_APIS.GET_CHANGE_TRACKING_INFO",
                                    "href":"sem_apis-get_change_tracking_info.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.100 </span> SEM_APIS.GET_INC_INF_INFO",
                                    "href":"sem_apis-get_inc_inf_info.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.101 </span> SEM_APIS.GET_MODEL_ID",
                                    "href":"sem_apis-get_model_id.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.102 </span> SEM_APIS.GET_MODEL_NAME",
                                    "href":"sem_apis-get_model_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.103 </span> SEM_APIS.GET_PLAN_COST",
                                    "href":"sem_apis-get_plan_cost.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.104 </span> SEM_APIS.GET_SQL",
                                    "href":"sem_apis-get_sql.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.105 </span> SEM_APIS.GET_TRIPLE_ID",
                                    "href":"sem_apis-get_triple_id.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.106 </span> SEM_APIS.GETV$DATETIMETZVAL",
                                    "href":"sem_apis-getvdatetimetzval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.107 </span> SEM_APIS.GETV$DATETZVAL",
                                    "href":"sem_apis-getvdatetzval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.108 </span> SEM_APIS.GETV$GEOMETRYVAL",
                                    "href":"sem_apis-getvgeometryval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.109 </span> SEM_APIS.GETV$NUMERICVAL",
                                    "href":"sem_apis-getvnumericval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.110 </span> SEM_APIS.GETV$STRINGVAL",
                                    "href":"sem_apis-getvstringval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.111 </span> SEM_APIS.GETV$TIMETZVAL",
                                    "href":"sem_apis-getvtimetzval.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.112 </span> SEM_APIS.GRANT_MODEL_ACCESS_PRIV",
                                    "href":"sem_apis-grant_model_access_priv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.113 </span> SEM_APIS.GRANT_MODEL_ACCESS_PRIVS",
                                    "href":"sem_apis-grant_model_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.114 </span> SEM_APIS.GRANT_NETWORK_ACCESS_PRIVS",
                                    "href":"sem_apis-grant_network_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.115 </span> SEM_APIS.GRANT_NETWORK_SHARING_PRIVS",
                                    "href":"sem_apis-grant_network_sharing_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.116 </span> SEM_APIS.GRANT_RDF_GRAPH_ACCESS_PRIV",
                                    "href":"sem_apis-grant_rdf_graph_access_priv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.117 </span> SEM_APIS.GRANT_RDF_GRAPH_ACCESS_PRIVS",
                                    "href":"sem_apis-grant_rdf_graph_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.118 </span> SEM_APIS.IMPORT_ENTAILMENT_STATS",
                                    "href":"sem_apis-import_entailment_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.119 </span> SEM_APIS.IMPORT_MODEL_STATS",
                                    "href":"sem_apis-import_model_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.120 </span> SEM_APIS.IS_TRIPLE",
                                    "href":"sem_apis-is_triple.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.121 </span> SEM_APIS.LOAD_INTO_STAGING_TABLE",
                                    "href":"sem_apis-load_into_staging_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.122 </span> SEM_APIS.LOOKUP_ENTAILMENT",
                                    "href":"sem_apis-lookup_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.123 </span> SEM_APIS.MERGE_MODELS",
                                    "href":"sem_apis-merge_models.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.124 </span> SEM_APIS.MERGE_RDF_GRAPHS",
                                    "href":"sem_apis-merge_rdf_graphs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.125 </span> SEM_APIS.MIGRATE_DATA_TO_CURRENT",
                                    "href":"sem_apis-migrate_data_to_current.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.126 </span> SEM_APIS.MIGRATE_DATA_TO_STORAGE_V2",
                                    "href":"sem_apis-migrate_data_to_storage_v2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.127 </span> SEM_APIS.MOVE_RDF_NETWORK_DATA",
                                    "href":"sem_apis-move_rdf_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.128 </span> SEM_APIS.MOVE_SEM_NETWORK_DATA",
                                    "href":"sem_apis-move_sem_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.129 </span> SEM_APIS.PURGE_UNUSED_VALUES",
                                    "href":"sem_apis-purge_unused_values.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.130 </span> SEM_APIS.REFRESH_MATERIALIZED_VIEW",
                                    "href":"sem_apis-refresh_materialized_view.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.131 </span> SEM_APIS.REFRESH_NETWORK_INDEX_INFO",
                                    "href":"sem_apis-refresh_network_index_info.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.132 </span> SEM_APIS.REFRESH_QUERY_STATE",
                                    "href":"sem_apis-refresh_query_state.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.133 </span> SEM_APIS.REFRESH_SEM_NETWORK_INDEX_INFO",
                                    "href":"sem_apis-refresh_sem_network_index_info.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.134 </span> SEM_APIS.RENAME_ENTAILMENT",
                                    "href":"sem_apis-rename_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.135 </span> SEM_APIS.RENAME_INFERRED_GRAPH",
                                    "href":"sem_apis-rename_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.136 </span> SEM_APIS.RENAME_MODEL",
                                    "href":"sem_apis-rename_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.137 </span> SEM_APIS.RENAME_RDF_GRAPH",
                                    "href":"sem_apis-rename_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.138 </span> SEM_APIS.RES2VID",
                                    "href":"sem_apis-res2vid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.139 </span> SEM_APIS.RESTORE_RDF_NETWORK_DATA",
                                    "href":"sem_apis-restore_rdf_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.140 </span> SEM_APIS.RESTORE_SEM_NETWORK_DATA",
                                    "href":"sem_apis-restore_sem_network_data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.141 </span> SEM_APIS.REVOKE_MODEL_ACCESS_PRIV",
                                    "href":"sem_apis-revoke_model_access_priv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.142 </span> SEM_APIS.REVOKE_MODEL_ACCESS_PRIVS",
                                    "href":"sem_apis-revoke_model_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.143 </span> SEM_APIS.REVOKE_NETWORK_ACCESS_PRIVS",
                                    "href":"sem_apis-revoke_network_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.144 </span> SEM_APIS.REVOKE_NETWORK_SHARING_PRIVS",
                                    "href":"sem_apis-revoke_network_sharing_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.145 </span> SEM_APIS.REVOKE_RDF_GRAPH_ACCESS_PRIV",
                                    "href":"sem_apis-revoke_rdf_graph_access_priv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.146 </span> SEM_APIS.REVOKE_RDF_GRAPH_ACCESS_PRIVS",
                                    "href":"sem_apis-revoke_rdf_graph_access_privs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.147 </span> SEM_APIS.SEM_SQL_COMPILE",
                                    "href":"sem_apis-sem_sql_compile.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.148 </span> SEM_APIS.SET_ENTAILMENT_STATS",
                                    "href":"sem_apis-set_entailment_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.149 </span> SEM_APIS.SET_MODEL_STATS",
                                    "href":"sem_apis-set_model_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.150 </span> SEM_APIS.SPARQL_TO_SQL",
                                    "href":"sem_apis-sparql_to_sql.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.151 </span> SEM_APIS.SWAP_NAMES",
                                    "href":"sem_apis-swap_names.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.152 </span> SEM_APIS.TRUNCATE_SEM_MODEL",
                                    "href":"sem_apis-truncate_sem_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.153 </span> SEM_APIS.TRUNCATE_RDF_GRAPH",
                                    "href":"sem_apis-truncate_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.154 </span> SEM_APIS.UNESCAPE_CLOB_TERM",
                                    "href":"sem_apis-unescape_clob_term.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.155 </span> SEM_APIS.UNESCAPE_CLOB_VALUE",
                                    "href":"sem_apis-unescape_clob_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.156 </span> SEM_APIS.UNESCAPE_RDF_TERM",
                                    "href":"sem_apis-unescape_rdf_term.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.157 </span> SEM_APIS.UNESCAPE_RDF_VALUE",
                                    "href":"sem_apis-unescape_rdf_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.158 </span> SEM_APIS.UPDATE_MODEL",
                                    "href":"sem_apis-update_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.159 </span> SEM_APIS.UPDATE_RDF_GRAPH",
                                    "href":"sem_apis-update_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.160 </span> SEM_APIS.VALIDATE_ENTAILMENT",
                                    "href":"sem_apis-validate_entailment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.161 </span> SEM_APIS.VALIDATE_GEOMETRIES",
                                    "href":"sem_apis-validate_geometries.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.162 </span> SEM_APIS.VALIDATE_INFERRED_GRAPH",
                                    "href":"sem_apis-validate_inferred_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.163 </span> SEM_APIS.VALIDATE_MODEL",
                                    "href":"sem_apis-validate_model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.164 </span> SEM_APIS.VALIDATE_RDF_GRAPH",
                                    "href":"sem_apis-validate_rdf_graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.165 </span> SEM_APIS.VALUE_NAME_PREFIX",
                                    "href":"sem_apis-value_name_prefix.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.166 </span> SEM_APIS.VALUE_NAME_SUFFIX",
                                    "href":"sem_apis-value_name_suffix.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">16 </span> SEM_PERF Package Subprograms",
                            "href":"sem_perf-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.1 </span> SEM_PERF.ANALYZE_AUX_TABLES",
                                    "href":"sem_perf-analyze_aux_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.2 </span> SEM_PERF.DELETE_NETWORK_STATS",
                                    "href":"sem_perf-delete_network_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.3 </span> SEM_PERF.DROP_EXTENDED_STATS",
                                    "href":"sem_perf-drop_extended_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.4 </span> SEM_PERF.EXPORT_NETWORK_STATS",
                                    "href":"sem_perf-export_network_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5 </span> SEM_PERF.GATHER_STATS",
                                    "href":"sem_perf-gather_stats.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.6 </span> SEM_PERF.IMPORT_NETWORK_STATS",
                                    "href":"sem_perf-import_network_stats.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17 </span> SEM_RDFCTX Package Subprograms",
                            "href":"sem_rdfctx-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.1 </span> SEM_RDFCTX.ADD_DEPENDENT_POLICY",
                                    "href":"sem_rdfctx-add_dependent_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.2 </span> SEM_RDFCTX.CREATE_POLICY",
                                    "href":"sem_rdfctx-create_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.3 </span> SEM_RDFCTX.DROP_POLICY",
                                    "href":"sem_rdfctx-drop_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.4 </span> SEM_RDFCTX.MAINTAIN_TRIPLES",
                                    "href":"sem_rdfctx-maintain_triples.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.5 </span> SEM_RDFCTX.SET_DEFAULT_POLICY",
                                    "href":"sem_rdfctx-set_default_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.6 </span> SEM_RDFCTX.SET_EXTRACTOR_PARAM",
                                    "href":"sem_rdfctx-set_extractor_param.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18 </span> SEM_RDFSA Package Subprograms",
                            "href":"SEM_RDFSA-reference.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.1 </span> SEM_RDFSA.APPLY_OLS_POLICY",
                                    "href":"sem_rdfsa-apply_ols_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2 </span> SEM_RDFSA.DISABLE_OLS_POLICY",
                                    "href":"sem_rdfsa-disable_ols_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.3 </span> SEM_RDFSA.ENABLE_OLS_POLICY",
                                    "href":"sem_rdfsa-enable_ols_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.4 </span> SEM_RDFSA.REMOVE_OLS_POLICY",
                                    "href":"sem_rdfsa-remove_ols_policy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.5 </span> SEM_RDFSA.RESET_MODEL_LABELS",
                                    "href":"sem_rdfsa-reset_model_labels.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.6 </span> SEM_RDFSA.SET_PREDICATE_LABEL",
                                    "href":"sem_rdfsa-set_predicate_label.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.7 </span> SEM_RDFSA.SET_RDFS_LABEL",
                                    "href":"sem_rdfsa-set_rdfs_label.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.8 </span> SEM_RDFSA.SET_RESOURCE_LABEL",
                                    "href":"sem_rdfsa-set_resource_label.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.9 </span> SEM_RDFSA.SET_RULE_LABEL",
                                    "href":"sem_rdfsa-set_rule_label.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Appendixes",
                    "href":"appendixes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A </span> Enabling, Downgrading, or Removing RDF Graph Support",
                            "href":"enabling-downgrading-or-removing-rdf-graph-support.html#GUID-D2F1EC6E-09A6-4845-A9E2-5EA2633F318E",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">A.1 </span> Enabling RDF Graph Support",
                                    "href":"enabling-rdf-graph-support.html#GUID-8B3D00C9-E2B8-4074-BE88-055DD5E157BF"
                                },
                                {
                                    "title":"<span class=\"secnum\">A.2 </span> Downgrading RDF Graph Support to a Previous Release",
                                    "href":"downgrading-rdf-graph-support-previous-release.html#GUID-8481C6C2-CA52-460A-9F82-A3F8EB1B2280"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">B </span> SEM_MATCH Support for Spatial Queries",
                            "href":"SEM_MATCH-spatial.html#GUID-BAB8E8F0-974E-44F7-813A-D3A96BF00399",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">B.1 </span> GeoSPARQL Functions for Spatial Support",
                                    "href":"geosparql-functions-spatial-support.html#GUID-7FADF095-A839-42ED-8DED-F6ADE280246D"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.2 </span> Oracle-Specific Functions for Spatial Support",
                                    "href":"oracle-specific-functions-spatial-support.html#GUID-07C95E2C-1E10-4BE2-836C-24EB82659FBB"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">C </span> RDF Support in SQL Developer",
                            "href":"rdf-support-sql-developer.html#GUID-875227EF-FF35-4B91-8183-70596F90B6CB",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">C.1 </span> About RDF Support in SQL Developer",
                                    "href":"rdf-support-sql-developer1.html#GUID-A6C7EAFF-C864-4C48-94D8-B8DD3A27758A"
                                },
                                {
                                    "title":"<span class=\"secnum\">C.2 </span> Setting Up the RDF Semantic Graph Support In SQL Developer",
                                    "href":"setting-rdf-semantic-graph-support-sql-developer.html#GUID-1895940C-C1E9-4D20-9D13-A4CB45599B70"
                                },
                                {
                                    "title":"<span class=\"secnum\">C.3 </span> Working with RDF Semantic Networks Using SQL Developer",
                                    "href":"working-rdf-semantic-networks-using-sql-developer.html#GUID-D505AA32-02EB-4768-B29F-E82A68A11B18"
                                },
                                {
                                    "title":"<span class=\"secnum\">C.4 </span> Bulk Loading RDF Data Using SQL Developer",
                                    "href":"bulk-loading-rdf-data-using-sql-developer.html#GUID-55FCF41F-62F0-4B5E-BEF6-2C43A280C02F"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">D </span> MDSYS-Owned Semantic Network",
                            "href":"mdsys-owned-semantic-network.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">D.1 </span> Creating an MDSYS-owned Semantic Network",
                                    "href":"creating-mdsys-owned-semantic-network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.2 </span> Getting Started with Semantic Data in an MDSYS-Owned Network",
                                    "href":"getting-started-semantic-data-mdsys-owned-network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.3 </span> Example Queries Using Graph Support for Apache Jena",
                                    "href":"example-queries-using-graph-support-apache-jena.html#GUID-A43C4444-A5DD-41C6-9182-49B22FDB7EF4"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.4 </span> Example Queries Using Graph Adapter for Eclipse RDF4J",
                                    "href":"example-queries-using-oracle-rdf-graph-adapter-eclipse-rdf4j1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.5 </span> Reference Information (MDSYS_Owned Semantic Network Only)",
                                    "href":"reference-information-mdsys_owned-network-only.html#GUID-566933DA-12B0-4BDD-B88B-B4A334A0F0ED"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.6 </span> Migrating an MDSYS-Owned Network to a Schema-Private Network",
                                    "href":"migrating-mdsys-owned-network-schema-private-network.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">E </span> Changes in Terminology and Subprograms",
                            "href":"changes-terminology-and-subprograms.html"
                        }
                    ]
                },
                {
                    "title":"Glossary",
                    "href":"rdf-glossary.html#GUID-E57849D7-DDB7-4219-8687-90D870DD8630"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});