define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-67C79E6F-5724-4AAA-9329-5385483E1BC6"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Oracle RAC Installation Checklist",
                    "href":"oracle-rac-installation-checklist.html#GUID-8233FD25-CBF6-4A63-B392-6553D39C7E09",
                    "topics":[
                        {
                            "title":"Deployment Checklist for Oracle RAC Database",
                            "href":"deployment-checklist-for-oracle-rac-database.html#GUID-D402C32F-96ED-438B-9BFD-89AC2F63F85A"
                        },
                        {
                            "title":"Server Hardware and Software Review Checklist for Oracle RAC Installation",
                            "href":"server-hardware-and-software-review-checklist-for-oracle-rac-installation.html#GUID-4F1008D5-B0A0-4DFF-ADEF-D8FAB5E0A997"
                        },
                        {
                            "title":"Installer Planning Checklist for Oracle AI Database",
                            "href":"installer-planning-checklist-for-oracle-database-installation.html#GUID-757A795E-0184-44BE-86FF-3BD1047F93A2"
                        },
                        {
                            "title":"Oracle RAC Upgrade Checklist",
                            "href":"oracle-rac-upgrade-checklist.html#GUID-5C865E6A-EBB2-4B9A-8824-B5D5C3905615"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Installing Oracle RAC and Oracle RAC One Node",
                    "href":"installing-oracle-rac-and-oracle-rac-one-node.html#GUID-15AAC8E3-5AF7-48B7-BD53-EFE662FA669A",
                    "topics":[
                        {
                            "title":"About Image-Based Oracle AI Database Installation",
                            "href":"about-image-based-oracle-database-installation.html#GUID-0315AA15-1C03-4E96-B801-3A8E5F5D4B39"
                        },
                        {
                            "title":"Setup Wizard Installation Options for Creating Images",
                            "href":"setup-wizard-installation-options.html#GUID-30C45B5F-58A3-4D4C-8475-40093C51650B"
                        },
                        {
                            "title":"Downloading the Software from Oracle Software Delivery Cloud Portal",
                            "href":"downloading-software-from-oracle-software-delivery-cloud-portal.html#GUID-34A70DC4-170F-41CD-8C7A-F4EE75B0EDAB"
                        },
                        {
                            "title":"Verifying Digital Signature and Integrity of Installation Archive Files",
                            "href":"verifying-digital-signature.html#GUID-1AA115AE-56E1-421A-82C3-7FF0E56C5B73"
                        },
                        {
                            "title":"Installing Oracle RAC and Oracle RAC One Node Databases",
                            "href":"running-oracle-universal-installer-to-install-oracle-database.html#GUID-AD7F5FFC-E4D4-47ED-A5BA-A20B43BF0687",
                            "topics":[
                                {
                                    "title":"Steps to Install Oracle AI Database",
                                    "href":"steps-to-install-rac-database.html#GUID-ADE4782A-AF76-4B3C-8766-A6C05727F1C5"
                                },
                                {
                                    "title":"Installing Oracle RAC Database Software Using Setup Wizard",
                                    "href":"installing-oracle-rac-rac-one-node-software-only.html#GUID-E865878B-C328-4368-A8F5-C7B2CD81172B"
                                }
                            ]
                        },
                        {
                            "title":"Installing Oracle RAC Database Software Using Command-Line Interface",
                            "href":"installing-oracle-rac-rac-one-node-software-only-using-cli.html#GUID-EEFB309D-FD62-4022-A99D-FB6BB1292075"
                        },
                        {
                            "title":"About Deploying Oracle AI Database Using Oracle Fleet Patching and Provisioning",
                            "href":"about-deploying-oracle-databases-using-fleet-patching-and-provisioning.html#GUID-1D28C833-E516-43B8-9692-0A07C7485E9D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Creating Oracle RAC or Oracle RAC One Node Databases with Oracle DBCA",
                    "href":"selecting-dbca-options-to-create-oracle-rac-or-oracle-rac-one-node-databases-with-dbca.html#GUID-46C46315-9ADD-48D1-BB98-39ACE50D1E83",
                    "topics":[
                        {
                            "title":"About Oracle Database Configuration Assistant",
                            "href":"benefits-of-using-database-configuration-assistant.html#GUID-E29B7E80-3BFE-4909-8457-2AA57AD47EFE"
                        },
                        {
                            "title":"Selecting Installation Options for Oracle RAC",
                            "href":"selecting-installation-options-for-oracle-rac.html#GUID-68411B0F-D38A-4A79-A6B7-D7AE3E0C6998",
                            "topics":[
                                {
                                    "title":"About Cluster Node Selection for Database Installation",
                                    "href":"about-node-selection-for-database-installation.html#GUID-C4587D50-E2EC-4AE0-9EFC-052B48D30830"
                                },
                                {
                                    "title":"Selecting a Database Name",
                                    "href":"selecting-a-database-name.html#GUID-3C954866-8375-4319-9184-CAA5F3B299D4"
                                },
                                {
                                    "title":"Requirements for Database Passwords",
                                    "href":"requirements-for-database-passwords.html#GUID-432DA3DD-7688-49F9-BCA7-66C86149295B"
                                },
                                {
                                    "title":"About Automatic Memory Management Installation Options",
                                    "href":"about-automatic-memory-management-installation-options.html#GUID-38F46564-B167-4A78-A974-8C7CEE34EDFE"
                                },
                                {
                                    "title":"About Character Set Selection During Installation",
                                    "href":"about-character-set-selection-during-installation.html#GUID-70B091B3-C67A-4AFD-9F60-75046171592D"
                                },
                                {
                                    "title":"Managing Oracle RAC Database Services After Installation",
                                    "href":"managing-db-services-after-install.html#GUID-5CD0BD2E-8BC1-4BD9-9954-051865407262"
                                }
                            ]
                        },
                        {
                            "title":"Automatic Listener Migration from Earlier Releases",
                            "href":"automatic-listener-migration-from-earlier-releases.html#GUID-380865BC-FEBB-41F7-A040-68A952AE9D0E"
                        },
                        {
                            "title":"Verifying Requirements for Oracle DBCA",
                            "href":"verifying-requirements-for-dbca.html#GUID-960D71B7-EED2-4219-9B76-878FA4C9F77A"
                        },
                        {
                            "title":"Tasks to Complete Before Using Oracle DBCA to Create any Oracle RAC Database",
                            "href":"tasks-to-complete-before-using-dbca-to-create-any-oracle-rac-database.html#GUID-844D8252-C26D-45EF-8DE3-D2D95DDA5AF5",
                            "topics":[
                                {
                                    "title":"Load SSH Keys Into Memory Before Starting DBCA",
                                    "href":"load-ssh-keys-into-memory-before-starting-dbca.html#GUID-82F6A6F4-EBC3-4BE9-8553-9999496A3F29"
                                },
                                {
                                    "title":"Decide on a Naming Convention to Use for Your Oracle RAC Database",
                                    "href":"decide-on-a-naming-convention-to-use-for-your-oracle-rac-database.html#GUID-E999E002-CD5A-4F5A-B599-7DA753ACE671"
                                },
                                {
                                    "title":"Configure Shared Storage for the Oracle RAC Database",
                                    "href":"configure-shared-storage-for-the-oracle-rac-database.html#GUID-50E03FD9-6304-4BDB-B629-180FB6B611FE"
                                }
                            ]
                        },
                        {
                            "title":"Selecting Oracle DBCA Options to Create an Oracle RAC or Oracle RAC One Node Database",
                            "href":"creating-an-oracle-rac-or-oracle-rac-one-node-database-with-dbca.html#GUID-2A620780-8495-4632-ACE6-C70E5709B729",
                            "topics":[
                                {
                                    "title":"Starting Oracle DBCA",
                                    "href":"starting-dbca.html#GUID-E4B492BD-74BA-4ECA-871D-38ED19A99156"
                                },
                                {
                                    "title":"Cluster Detection and Node Selection when Using Oracle DBCA",
                                    "href":"cluster-detection-and-node-selection-when-using-dbca.html#GUID-045A9285-21CB-4ADA-ACEF-338569F5B4D7"
                                },
                                {
                                    "title":"Using Oracle DBCA to Select Storage to Use With any Oracle RAC Database",
                                    "href":"using-dbca-to-select-storage-to-use-with-any-oracle-rac-database.html#GUID-759ED263-E20B-48A6-A4B5-8C6678242E03"
                                },
                                {
                                    "title":"Using DBCA to Specify Database Initialization Parameters for Oracle RAC",
                                    "href":"using-dbca-to-specify-database-initialization-parameters-for-oracle-rac.html#GUID-E05E3C92-A185-42B5-82D9-58CC7E3EAC46"
                                },
                                {
                                    "title":"Actions Performed By DBCA for Oracle RAC Databases",
                                    "href":"actions-performed-by-dbca-for-oracle-rac-databases.html#GUID-D84E4426-CF97-4BE7-A944-09ABE6A2D2C3"
                                }
                            ]
                        },
                        {
                            "title":"Using DBCA to Create an Oracle RAC One Node Database",
                            "href":"using-dbca-to-create-an-oracle-rac-one-node-database.html#GUID-EE4E2D5E-92C7-4D40-9913-F0E11B519725"
                        },
                        {
                            "title":"Installing the Oracle Database Vault Option",
                            "href":"installing-the-oracle-database-vault-option.html#GUID-42226538-CC23-4577-825B-5BC279EC8755",
                            "topics":[
                                {
                                    "title":"Starting the Listener with Oracle Database Vault Installations",
                                    "href":"starting-the-listener-with-oracle-database-vault-installations.html#GUID-284BF9E6-F472-469F-87C4-C07CA5D70205"
                                },
                                {
                                    "title":"Configuring Oracle Database Vault Using Oracle DBCA",
                                    "href":"configuring-oracle-database-vault-using-dbca.html#GUID-D3EEE10A-BB9A-4BDF-9F61-4A0B86D56787"
                                }
                            ]
                        },
                        {
                            "title":"Deleting an Oracle RAC Database Using Oracle DBCA",
                            "href":"deleting-an-oracle-rac-database-using-dbca.html#GUID-848508F5-6AE1-49CC-9DDD-4D6C24F8B3F3"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Oracle Real Application Clusters Postinstallation Procedures",
                    "href":"oracle-real-application-clusters-postinstallation-procedures.html#GUID-F5D85B58-2AA1-415C-AECD-B5549DD3529A",
                    "topics":[
                        {
                            "title":"Oracle AI Database Patching",
                            "href":"oracle-database-patching.html#GUID-73555C58-B361-4F0B-8D70-3E4CE5FB6EBF",
                            "topics":[
                                {
                                    "title":"About Oracle AI Database Release Update Patches",
                                    "href":"oracle-ai-database-release-update-patches.html#GUID-1B7C597D-4629-431B-A759-BBF8F0556F42"
                                },
                                {
                                    "title":"Downloading Release Update Patches",
                                    "href":"downloading-and-installing-patch-updates.html#GUID-A2FD0257-D074-444D-8007-A21EBEC10358"
                                },
                                {
                                    "title":"Applying Out-of-Place Oracle AI Database Patches",
                                    "href":"applying-place-oracle-database-patches.html#GUID-FD109EEF-227B-482A-ADC6-2FC9A633B987"
                                },
                                {
                                    "title":"Patching Oracle AI Database Using Oracle FPP Local Mode",
                                    "href":"patching-oracle-database-using-oracle-fpp-lite.html#GUID-1EF156C1-0D48-4783-AB68-2D2241B6BE55"
                                }
                            ]
                        },
                        {
                            "title":"Required Postinstallation Tasks",
                            "href":"required-postinstallation-tasks.html#GUID-57C27D5D-7C92-4919-A430-690B89C57665",
                            "topics":[
                                {
                                    "title":"Setting External Jobs Ownership for HP-UX Installations",
                                    "href":"setting-external-jobs-ownership-for-hp-ux-installations.html#GUID-206D5C32-E8DA-40BF-BDC6-D2572382B5CA"
                                },
                                {
                                    "title":"Setting the Oracle User Environment Variables",
                                    "href":"setting-the-oracle-user-environment-variables.html#GUID-B2A2E0E2-DD9B-4536-9228-CC38EE27AAF3"
                                },
                                {
                                    "title":"Recompile Invalid Objects in the Database",
                                    "href":"recompiling-all-invalid-objects.html#GUID-1023C5FB-B409-4F16-BCA1-C14CB9B7E625"
                                },
                                {
                                    "title":"Configuring Services on Oracle RAC and Oracle RAC One Node Databases",
                                    "href":"configuring-services-on-oracle-rac-and-oracle-rac-one-node-cdbs.html#GUID-9296E40F-13BA-444E-9DC8-11A239BEC395"
                                },
                                {
                                    "title":"Copying Oracle ASM Password File For Oracle RAC One Node Database",
                                    "href":"copying-oracle-asm-password-file-for-oracle-rac-one-node-database.html#GUID-E8548EE1-93DE-4895-A546-556D1C758B02"
                                }
                            ]
                        },
                        {
                            "title":"Recommended Postinstallation Tasks",
                            "href":"recommended-postinstallation-tasks.html#GUID-01E7E498-DC11-411E-ADA2-02C2B8F358F0",
                            "topics":[
                                {
                                    "title":"Setting Up Additional User Accounts",
                                    "href":"setting-up-additional-user-accounts.html#GUID-7709EE8E-0A4F-4CD5-A320-0F24EC9C8756"
                                },
                                {
                                    "title":"About Installing Oracle Autonomous Health Framework",
                                    "href":"downloading-and-installing-the-orachk-health-check-tool.html#GUID-19914928-49B2-444A-8F1B-D4398C264AAD"
                                }
                            ]
                        },
                        {
                            "title":"Product-Specific Postinstallation Tasks",
                            "href":"product-specific-postinstallation-tasks.html#GUID-A9482056-E8C2-41AA-B784-6B8114C32AEC",
                            "topics":[
                                {
                                    "title":"Configuring Oracle Database Vault",
                                    "href":"configuring-oracle-database-vault.html#GUID-5E731500-3082-4436-9CE8-855D51026A0D"
                                },
                                {
                                    "title":"Configuring Oracle Label Security",
                                    "href":"configuring-oracle-label-security.html#GUID-58E7F194-D24C-453F-AE38-D0E438ABC6E4"
                                },
                                {
                                    "title":"Configuring Oracle XML DB",
                                    "href":"configuring-oracle-xml-db.html#GUID-63B24C49-E54E-405E-967B-B344254E6A76"
                                },
                                {
                                    "title":"Configuring Storage for External Tables, Shared Files, or Directory Objects",
                                    "href":"configuring-storage-for-external-tables-shared-files-or-directory-objects.html#GUID-683A8296-D6E2-4177-938F-BD72B8B59FD8"
                                }
                            ]
                        },
                        {
                            "title":"Enabling and Disabling Oracle AI Database Options After Installation",
                            "href":"enabling-and-disabling-oracle-database-options-after-installation.html#GUID-5E055744-6440-4E28-AC76-E87449379EED",
                            "topics":[
                                {
                                    "title":"Chopt Tool",
                                    "href":"chopt-tool.html#GUID-057E4EFC-74ED-43B3-B03B-C83C5A5D3C7F"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Understanding the Oracle RAC Installed Configuration",
                    "href":"understanding-the-oracle-rac-installed-configuration.html#GUID-BBDE5B45-8814-4E72-A699-CA3F7F272D5D",
                    "topics":[
                        {
                            "title":"Understanding the Configured Environment in Oracle RAC",
                            "href":"understanding-the-configured-environment-in-oracle-rac.html#GUID-8F837808-21FE-4DFD-BDDA-8BD6D45AAC9D"
                        },
                        {
                            "title":"Understanding Operating System Privileges Groups",
                            "href":"understanding-operating-system-privileges-groups.html#GUID-220E525A-4CBC-49F2-BCA7-90886E0F64E8"
                        },
                        {
                            "title":"Understanding Time Zone Settings on Cluster Nodes",
                            "href":"understanding-time-zone-settings-on-cluster-nodes.html#GUID-1F5BCD1F-3BCF-40CF-9E81-3EC62E6424CF"
                        },
                        {
                            "title":"Understanding the Server Parameter File for Oracle RAC",
                            "href":"understanding-the-server-parameter-file-for-oracle-rac.html#GUID-D3169A33-3FDC-4C1A-8F01-670864FFA55F"
                        },
                        {
                            "title":"About ORATAB Configuration for Oracle RAC",
                            "href":"about-oratab-configuration-for-oracle-rac.html#GUID-03B4D667-A3A8-4EA2-A7EA-2A3C56A4D875"
                        },
                        {
                            "title":"Database Components Created Using Oracle DBCA",
                            "href":"database-components-created-using-database-configuration-assistant.html#GUID-A89FBA35-0D71-456F-9D80-AA2ED7772D1A",
                            "topics":[
                                {
                                    "title":"About Tablespaces and Data Files",
                                    "href":"about-tablespaces-and-data-files.html#GUID-F01E746E-B545-4581-BE7D-E76DAE297E11"
                                },
                                {
                                    "title":"About Control Files",
                                    "href":"about-control-files.html#GUID-C1E7CE07-AF58-4B8A-A192-ABC14CB5634F"
                                },
                                {
                                    "title":"About Online Redo Log Files",
                                    "href":"about-online-redo-log-files.html#GUID-4171A82E-0A8C-408B-9B7B-73894B01121F"
                                }
                            ]
                        },
                        {
                            "title":"Managing Undo Tablespaces in Oracle RAC",
                            "href":"managing-undo-tablespaces-in-oracle-rac.html#GUID-E4CB404B-3C8C-4D11-AEEE-681F1F20ABB1"
                        },
                        {
                            "title":"About Initialization Parameter Files",
                            "href":"about-initialization-parameter-files.html#GUID-AF939EA6-CB0A-449B-A032-C5C90CC1C997"
                        },
                        {
                            "title":"Oracle Net Services Configuration for Oracle RAC Databases",
                            "href":"oracle-net-services-configuration-for-oracle-rac-databases.html#GUID-D7D0CD9F-731E-4998-81A0-60CD6AFB064B",
                            "topics":[
                                {
                                    "title":"Database Services for an Oracle RAC Database",
                                    "href":"database-services-for-an-oracle-rac-database.html#GUID-6DD26848-E3B5-42B9-91A3-50A8CD63568D"
                                },
                                {
                                    "title":"Naming Methods and Connect Descriptors",
                                    "href":"naming-methods-and-connect-descriptors.html#GUID-0EAF25A3-51A1-4837-97FA-094DA0FE2D98"
                                },
                                {
                                    "title":"Easy Connect Naming Method",
                                    "href":"easy-connect-naming-method.html#GUID-9EAA98B7-93B6-426D-BAB5-F709D79DBA33"
                                },
                                {
                                    "title":"Understanding SCANs",
                                    "href":"understanding-scans.html#GUID-FE474597-F9E5-46A0-9FEF-EB39226546FC",
                                    "topics":[
                                        {
                                            "title":"About the SCAN",
                                            "href":"about-the-scan.html#GUID-BADC71E3-9A0A-42D9-8EA7-9D26315FD28D"
                                        },
                                        {
                                            "title":"About SCAN VIP Addresses",
                                            "href":"about-scan-vip-addresses.html#GUID-795F99B3-FF71-4767-ADFD-351A6A29A4F8"
                                        },
                                        {
                                            "title":"About SCAN Listeners",
                                            "href":"about-scan-listeners.html#GUID-A445F338-30F4-453A-B5D0-3C836ED19D59"
                                        }
                                    ]
                                },
                                {
                                    "title":"About Connecting to an Oracle RAC Database Using SCANs",
                                    "href":"about-connecting-to-an-oracle-rac-database-using-scans.html#GUID-090555EB-7EB7-44DE-BD06-54FED5CF5712"
                                },
                                {
                                    "title":"About Listener Configuration for an Oracle RAC Database",
                                    "href":"about-listener-configuration-for-an-oracle-rac-database.html#GUID-41979EBD-F3FD-4FFD-87B5-F3A33DE64397"
                                },
                                {
                                    "title":"About Service Registration for an Oracle RAC Database",
                                    "href":"about-service-registration-for-an-oracle-rac-database.html#GUID-FD263A64-7FD8-4DDE-A895-95E95573F725"
                                },
                                {
                                    "title":"How Database Connections are Created When Using SCANs",
                                    "href":"how-database-connections-are-created-when-using-scans.html#GUID-DDA82589-44DB-4681-B0BC-32898D3083BA"
                                }
                            ]
                        },
                        {
                            "title":"Performance Features of Oracle Net Services and Oracle RAC",
                            "href":"performance-features-of-oracle-net-services-and-oracle-rac.html#GUID-64C361DC-CBF7-4C28-BB67-1E6F3DC43605",
                            "topics":[
                                {
                                    "title":"Load Balancing of Connections to Oracle RAC Databases",
                                    "href":"load-balancing-of-connections-to-oracle-rac-databases.html#GUID-06B4373D-1217-44E4-BD86-DE353DA657F6"
                                },
                                {
                                    "title":"Connection Failover for Oracle RAC Databases",
                                    "href":"connection-failover-for-oracle-rac-databases.html#GUID-45FD936E-2C4F-421C-9133-832527574C2E"
                                },
                                {
                                    "title":"Shared Server Configuration for an Oracle RAC Database",
                                    "href":"shared-server-configuration-for-an-oracle-rac-database.html#GUID-2EFBA08D-FEEE-407F-BC42-E548DA946DF9"
                                }
                            ]
                        },
                        {
                            "title":"Oracle Net Services Configuration Files and Parameters",
                            "href":"oracle-net-services-configuration-files-and-parameters.html#GUID-798C5828-D904-4D30-BECE-87A6DD128DEB",
                            "topics":[
                                {
                                    "title":"Database Initialization Parameters for Database Service Registration",
                                    "href":"database-initialization-parameters-for-database-service-registration.html#GUID-CFA848E8-C383-484B-A3D2-6937270529DE"
                                },
                                {
                                    "title":"Net Service Names and the tnsnames.ora File",
                                    "href":"net-service-names-and-the-tnsnames-ora-file.html#GUID-F83D74F4-6C53-45D1-ABDD-A60D5134619B"
                                },
                                {
                                    "title":"Net Service Names Created by Oracle DBCA",
                                    "href":"net-service-names-created-by-dbca.html#GUID-C0E2DE71-9993-44C1-8A50-C75EBB83382E",
                                    "topics":[
                                        {
                                            "title":"Net Service Names for Database Connections",
                                            "href":"net-service-names-for-database-connections.html#GUID-D39ED6F5-1510-494A-985A-EDF8C1659962"
                                        },
                                        {
                                            "title":"Net Service Names for Instance Connections",
                                            "href":"net-service-names-for-instance-connections.html#GUID-23C7E93B-5337-498E-B8F4-AC32C420D394"
                                        }
                                    ]
                                },
                                {
                                    "title":"Listener Configuration and the listener.ora File",
                                    "href":"listener-configuration-and-the-listener-ora-file.html#GUID-BFA29AB9-78A3-41DE-9FCA-8EA3EF6D4939",
                                    "topics":[
                                        {
                                            "title":"Local Listener for an Oracle RAC Database",
                                            "href":"local-listener-for-an-oracle-rac-database.html#GUID-3E960246-5192-4AFC-BE59-58553720C8F1"
                                        },
                                        {
                                            "title":"Remote Listeners for an Oracle RAC Database",
                                            "href":"remote-listeners-for-an-oracle-rac-database.html#GUID-F81C986D-D272-4216-B030-19B80BE6293D"
                                        },
                                        {
                                            "title":"Managing Multiple Listeners for an Oracle RAC Database",
                                            "href":"managing-multiple-listeners-for-an-oracle-rac-database.html#GUID-B77A198C-7A02-417A-A1EB-24AFCDF35631"
                                        },
                                        {
                                            "title":"How Oracle AI Database Uses the Listener File (listener.ora)",
                                            "href":"how-oracle-database-uses-the-listener-file-listener-ora.html#GUID-AB2A5486-C0FB-49AD-BBD7-C7E5229E39A8"
                                        }
                                    ]
                                },
                                {
                                    "title":"Net Services Profile File (sqlnet.ora)",
                                    "href":"net-services-profile-file-sqlnet-ora.html#GUID-F04C213C-4B65-4416-A54F-987EA2E6EAF8"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Removing Oracle AI Database Software",
                    "href":"removing-oracle-database-software.html#GUID-5619EBF0-C89E-4349-AE6F-A8F8B3B06BD1",
                    "topics":[
                        {
                            "title":"About Oracle Deinstallation Options",
                            "href":"about-oracle-deinstallation-options.html#GUID-DF4E3D18-163A-4014-B24F-AAC4EBD9955F"
                        },
                        {
                            "title":"Identifying All Instances On a Cluster",
                            "href":"identifying-all-instances-on-a-cluster.html#GUID-4E44D57D-F6C7-4527-831C-EB9CE8A87B26"
                        },
                        {
                            "title":"Oracle Deinstallation (Deinstall)",
                            "href":"oracle-deinstallation-tool-deinstall.html#GUID-71E860C5-4E1E-4D2F-AFD1-141709A172C0"
                        },
                        {
                            "title":"Deinstallation Examples for Oracle AI Database",
                            "href":"deinstallation-examples-for-oracle-database.html#GUID-05452B1D-E034-4547-B9C6-9E8BCA1BD4EF"
                        },
                        {
                            "title":"Deinstallation Parameter File Example for Oracle RAC",
                            "href":"deinstallation-parameter-file-example-for-oracle-rac.html#GUID-63E37484-3395-4901-86E0-38F1D4F8D409"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Using Scripts or Response Files to Create Oracle RAC Databases",
                    "href":"using-scripts-or-response-files-to-create-oracle-rac-databases.html#GUID-56AD634C-1427-4F87-8AAC-766FB8B2BCA1",
                    "topics":[
                        {
                            "title":"Using DBCA to Generate Installation Scripts for Oracle RAC",
                            "href":"using-dbca-to-generate-installation-scripts-for-oracle-rac.html#GUID-86D6563A-BE7E-47BA-85A0-5AB40B8F1757"
                        },
                        {
                            "title":"About DBCA Noninteractive (Silent) Configuration for Oracle RAC",
                            "href":"about-dbca-noninteractive-silent-configuration-for-oracle-rac.html#GUID-3A0D993A-B849-4B9E-9C17-B498EBA9B4B3"
                        },
                        {
                            "title":"Using Oracle DBCA Commands for Noninteractive (Silent) Configuration for Oracle RAC",
                            "href":"using-dbca-commands-for-noninteractive-silent-configuration-for-oracle-rac.html#GUID-0B6FF745-3D89-407B-9722-FA3F2B38B5B6"
                        },
                        {
                            "title":"How Response Files Work",
                            "href":"how-response-files-work.html#GUID-DC3F6376-B78D-41C5-9225-FAE22A5B8CB7",
                            "topics":[
                                {
                                    "title":"Modes for Oracle DBCA Noninteractive (Silent) Configuration",
                                    "href":"modes-for-dbca-silent-configuration.html#GUID-22719BEB-97CB-4134-A84D-629A7109C7A5"
                                },
                                {
                                    "title":"Reasons for Using Silent Mode or Response File Mode",
                                    "href":"reasons-for-using-silent-mode-or-response-file-mode.html#GUID-62D156C6-8CB4-491E-A7DD-ED3DB7D1D82B"
                                },
                                {
                                    "title":"Creating a Database Using Oracle ASM for Database Files",
                                    "href":"creating-a-database-using-oracle-asm-for-database-files.html#GUID-74D3471D-3D26-41EE-95A1-7A49AA676067"
                                },
                                {
                                    "title":"Using Response Files",
                                    "href":"using-response-files.html#GUID-9EDC0547-4BCC-4349-A0F7-CBDD0039F3EF"
                                }
                            ]
                        },
                        {
                            "title":"Preparing Response Files",
                            "href":"preparing-response-files.html#GUID-90A09F65-ADD1-43EB-B545-324749E3282E",
                            "topics":[
                                {
                                    "title":"Editing a Response File Template",
                                    "href":"editing-a-response-file-template.html#GUID-662F8635-947B-4774-B9BB-3752B47C3F91"
                                },
                                {
                                    "title":"Recording Response Files",
                                    "href":"recording-response-files.html#GUID-5F75A411-6DD8-43C8-9BC7-294AE82204FE"
                                }
                            ]
                        },
                        {
                            "title":"Running Oracle Universal Installer Using a Response File",
                            "href":"running-oracle-universal-installer-using-a-response-file.html#GUID-C8B6ED11-4486-45E0-8365-E1A9695FB27C"
                        },
                        {
                            "title":"Postinstallation Configuration Using Response File Created During Installation",
                            "href":"postinstallation-configuration-using-response-file-created-during-installation.html#GUID-855D3F72-D2F9-4263-8BC6-37641F2C4251",
                            "topics":[
                                {
                                    "title":"Using the Installation Response File for Postinstallation Configuration",
                                    "href":"using-the-installation-response-file-for-postinstallation-configuration.html#GUID-25DFB0D0-FC1A-432B-919C-6FB9B7F9E447"
                                },
                                {
                                    "title":"Running Postinstallation Configuration Using Response File",
                                    "href":"running-postinstallation-configuration-using-response-file.html#GUID-F8AE183A-872E-43FC-AE9A-74407530C1E2"
                                }
                            ]
                        },
                        {
                            "title":"Running Configuration Assistants Using Response Files",
                            "href":"running-configuration-assistants-using-response-files.html#GUID-DFD2D9A7-4B06-4554-91AB-89CA83158DAC",
                            "topics":[
                                {
                                    "title":"Running Oracle DBCA Using Response Files",
                                    "href":"running-database-configuration-assistant-using-response-files.html#GUID-E84CE996-B30C-4DCA-AE4C-1E90201317C2"
                                },
                                {
                                    "title":"Running Net Configuration Assistant Using Response Files",
                                    "href":"running-net-configuration-assistant-using-response-files.html#GUID-86CD4F09-BEF8-40B4-905C-5DA86582CD74"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Directory Structure for Oracle RAC Environments",
                    "href":"directory-structure-for-oracle-rac-environments.html#GUID-AA4C4813-60AA-471B-B10B-7D03BEA1B111",
                    "topics":[
                        {
                            "title":"Understanding the Oracle RAC Directory Structure",
                            "href":"understanding-the-oracle-rac-directory-structure.html#GUID-6D64015A-EA83-474E-9923-3ADBE55C5316"
                        },
                        {
                            "title":"Directory Structures for Oracle RAC",
                            "href":"directory-structures-for-oracle-rac.html#GUID-C0568821-5FE4-4938-87E3-573FB73335F9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Preparing to Upgrade an Existing Oracle RAC Database",
                    "href":"preparing-to-upgrade-an-existing-oracle-rac-database.html#GUID-280AA623-966A-4925-98B5-5D4B72014708",
                    "topics":[
                        {
                            "title":"Backing Up the Oracle RAC Database",
                            "href":"backing-up-the-oracle-rac-database.html#GUID-7D28C7FF-EA71-4311-9FBA-2801DE1E424B"
                        },
                        {
                            "title":"Using CVU to Validate Readiness for Oracle RAC Upgrades",
                            "href":"using-cvu-to-validate-readiness-for-oracle-rac-upgrades.html#GUID-2B8C594D-A663-48D6-AD1A-6F695CF95D99",
                            "topics":[
                                {
                                    "title":"cluvfy Command Options for Database Upgrade Validation",
                                    "href":"using-the-cvu-database-upgrade-validation-command-options.html#GUID-CB56AD3E-972D-4675-83F7-AA305F7C2980"
                                },
                                {
                                    "title":"Verifying System Readiness for Oracle AI Database Upgrades",
                                    "href":"verifying-system-readiness-for-oracle-database-upgrades.html#GUID-C7FE8289-40DD-4F0B-AA43-D0D6E5F19CFD"
                                }
                            ]
                        },
                        {
                            "title":"AutoUpgrade and Cluster-Managed Oracle AI Database Upgrades",
                            "href":"autoupgrade-and-cluster-managed-oracle-database-instances.html#GUID-5DAFA02A-D00C-4F2D-80FD-FD5BF589F2B0"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Configuring Oracle Homes",
                    "href":"configuring-read-only-oracle-homes.html#GUID-906DA159-AC83-4ACC-A8A6-5B4A39EB72E1",
                    "topics":[
                        {
                            "title":"Evolution of Oracle Homes",
                            "href":"understanding-read-only-oracle-homes.html#GUID-AE1973D7-0325-4AD8-9FC9-D7BA3C3C3F37",
                            "topics":[
                                {
                                    "title":"About Read-Only Oracle Homes",
                                    "href":"about-read-only-oracle-home.html#GUID-D848002A-DBAD-48FA-8467-E849630B8E42"
                                },
                                {
                                    "title":"About Oracle Base Home",
                                    "href":"about-oracle-base-home.html#GUID-2895AF62-C297-4753-B104-5E0519F30141"
                                },
                                {
                                    "title":"About Oracle Base Config",
                                    "href":"about-oracle-base-config.html#GUID-65A66058-319C-4C53-98F2-9CD2D8B030C6"
                                },
                                {
                                    "title":"About orabasetab",
                                    "href":"about-orabasetab.html#GUID-9090F5D7-9875-48C5-B735-A8E90F9F8BAE"
                                },
                                {
                                    "title":"Location of Networking Files in a Read-Only Oracle Home",
                                    "href":"localtion-of-networking-files-solaris.html#GUID-7AA693E0-4590-450D-92DC-041115ACA987"
                                }
                            ]
                        },
                        {
                            "title":"Enabling a Read-Only Oracle Home",
                            "href":"enabling-read-only-oracle-home.html#GUID-7B2FA40E-8FBA-4494-934A-A284532AF702"
                        },
                        {
                            "title":"Copying demo Directories to Oracle Base Home",
                            "href":"running-demo-from-oracle-base-home.html#GUID-9C4D0762-7F36-4819-9D00-90ACE68E482B"
                        },
                        {
                            "title":"Determining If an Oracle Home is Read-Only",
                            "href":"checking-if-read-only-oracle-home-exists.html#GUID-7B4C699F-49B1-42D9-94A6-6112B2F7945A"
                        },
                        {
                            "title":"File Path and Directory Changes in Read-Only Oracle Homes",
                            "href":"file-path-directory-changes-read-only-oracle-home.html#GUID-695D5458-A4AF-4F2A-AE4B-FB1062CF6014"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Managing Oracle AI Database Port Numbers",
                    "href":"managing-oracle-database-port-numbers.html#GUID-283FCCBE-A8FA-457B-8C7D-34D64AEB6DA9",
                    "topics":[
                        {
                            "title":"About Managing Ports",
                            "href":"about-managing-ports.html#GUID-116C07D3-DE6B-4670-87C6-F1656C5D1722"
                        },
                        {
                            "title":"Port Numbers and Protocols of Oracle Components",
                            "href":"port-numbers-and-protocols-of-oracle-components.html#GUID-D168F70C-BECE-4F9A-B616-D9103A35F1FF"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle AI Database Installer Command-Line Options",
                    "href":"db-command-line-options.html#GUID-6B2B7EEC-A152-4097-A872-A2CABDEE2BCC",
                    "topics":[
                        {
                            "title":"runInstaller Command",
                            "href":"runinstaller-command-options.html#GUID-D9DC47E4-1A6D-4CFF-B49E-9011BBA8E306"
                        },
                        {
                            "title":"runInstaller -setupDBHome",
                            "href":"runinstaller-setupdbhome-command.html#GUID-F916624B-5821-42B6-BBED-D76F1286F8EB"
                        },
                        {
                            "title":"runInstaller -setupDBHomeAs",
                            "href":"runinstaller-setupdbhomeas-command.html#GUID-EFE4BE7C-4DD3-4FEF-8063-AB835025421F"
                        },
                        {
                            "title":"runInstaller -createGoldImage",
                            "href":"runinstaller-creategoldimage-command.html#GUID-DA476FA3-41F1-42F5-A7D5-AA5130199206"
                        }
                    ]
                }
            ]
        }
    ]
});