define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-9E6EA226-BCDB-4AF3-8A84-F475FE6D1190"
                },
                {
                    "title":"Changes in Oracle Globally Distributed Database for Oracle Database 23ai",
                    "href":"changes-oracle-database-23ai.html#GUID-BDC14D70-C513-4EC3-B1A4-AA0616290800"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Oracle Globally Distributed Database Overview",
                    "href":"overview1.html#GUID-0F39B1FB-DCF9-4C8A-A2EA-88705B90C5BF"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Oracle Globally Distributed Database Architecture and Concepts",
                    "href":"architecture-and-concepts1.html#GUID-9DC0048A-2D6E-4759-BA80-10F8855E6871",
                    "topics":[
                        {
                            "title":"Architecture and Components",
                            "href":"architecture-components.html#GUID-3D41F762-BE04-486D-8018-C7A210D809F9"
                        },
                        {
                            "title":"Schema Objects",
                            "href":"schema-objects.html#GUID-1B8DAEE1-A662-4516-9EA9-04FF711211C3"
                        },
                        {
                            "title":"Data Distribution Methods",
                            "href":"data-distribution-methods1.html#GUID-3B07D91C-CEAA-4170-A94B-ACF47BEE617B"
                        },
                        {
                            "title":"Client Application Request Routing",
                            "href":"client-application-request-routing.html#GUID-D1B05BE6-06FD-4F8B-93C4-25DF65F4FF2B"
                        },
                        {
                            "title":"Query Processing and the Query Coordinator",
                            "href":"query-processing-and-query-coordinator.html#GUID-9C13DCC4-0018-4049-94D8-70F518008504"
                        },
                        {
                            "title":"Data Replication",
                            "href":"high-availability-concepts.html#GUID-25B385FF-6A45-495C-A36A-143CBC50E3C5"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Oracle Globally Distributed Database Deployment",
                    "href":"deployment1.html#GUID-F99B8742-4089-4E77-87D4-4691EA932207",
                    "topics":[
                        {
                            "title":"Introduction to Distributed Database Deployment",
                            "href":"introduction-deployment.html#GUID-059FD35C-C1C2-4B14-9A76-B3632A6080DC"
                        },
                        {
                            "title":"Planning Your Deployment",
                            "href":"planning-your-deployment.html#GUID-5A6EC530-FE77-429C-B78D-BA9780C76BE4"
                        },
                        {
                            "title":"Install the Oracle Database Software",
                            "href":"install-oracle-database-software.html#GUID-3F3A387E-FAC5-467C-A45E-4A7DFF95B62D"
                        },
                        {
                            "title":"Install the Shard Director Software",
                            "href":"install-shard-director-software.html#GUID-E1F8A199-D0D2-4ABA-94EA-E314E83A966F"
                        },
                        {
                            "title":"Create the Shard Catalog Database",
                            "href":"create-shard-catalog-database.html#GUID-9A0F96A7-4D52-4B3A-8538-6DA2AB5A9BFB"
                        },
                        {
                            "title":"Create the Shard Databases",
                            "href":"create-shard-databases.html#GUID-AA268F12-4389-4BB2-B588-06BD48A8DA5C"
                        },
                        {
                            "title":"Validate the Shard Database",
                            "href":"validate-shard-database.html#GUID-FECB6D68-0ACC-4BE0-82F3-0917CCBD7728"
                        },
                        {
                            "title":"Configure the Distributed Database Topology",
                            "href":"configure-topology.html#GUID-4DD37935-BA84-4817-99D6-5FB0BE607E3E"
                        },
                        {
                            "title":"Deploy the Configuration",
                            "href":"deploy-configuration.html#GUID-D382277F-02B2-4BBC-B8F0-15EEA16E630A"
                        },
                        {
                            "title":"Create and Start Global Database Services",
                            "href":"create-and-start-global-database-services.html#GUID-1DDE95AD-D1B6-4012-9F3E-8833A16E5774"
                        },
                        {
                            "title":"Verify Shard Status",
                            "href":"verify-shard-status.html#GUID-566C0888-CE21-4E64-8597-E0BEDF95388A"
                        },
                        {
                            "title":"Creating a Shard Catalog Standby",
                            "href":"adding-shard-catalog-standby.html#GUID-0EF4ACE2-EFED-4887-9E52-0284CEB263AA"
                        },
                        {
                            "title":"Example Distributed Database Deployment",
                            "href":"example-deployment.html#GUID-74F7C601-C9AE-4805-A7BF-70BCB8E73393"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Oracle Globally Distributed Database Schema Design",
                    "href":"schema-design1.html#GUID-F4562E84-87F9-4AA0-BB13-8C2F54FE326A",
                    "topics":[
                        {
                            "title":"Schema Design Considerations",
                            "href":"schema-design-considerations.html#GUID-42B2CA52-76DF-4F51-9CB6-51664102408F"
                        },
                        {
                            "title":"Sharding Keys",
                            "href":"sharding-keys.html#GUID-3514F441-FF8F-4313-A3F4-427031B94B2A"
                        },
                        {
                            "title":"Creating Schema Objects",
                            "href":"creating-schema-objects.html#GUID-7DEC4996-5159-4C75-A96C-C1735E9A36DD"
                        },
                        {
                            "title":"Creating Indexes on Sharded Tables",
                            "href":"creating-indexes-sharded-tables.html#GUID-6A224DA1-2521-4036-B015-F72C1BC4763C"
                        },
                        {
                            "title":"Oracle AI Vector Search in a Distributed Database",
                            "href":"oracle-ai-vector-search-globally-distributed-database.html#GUID-999689D3-6EE4-4D81-ABA9-68634C7407E0"
                        },
                        {
                            "title":"Modifying a Distributed Database Schema",
                            "href":"modifying-schema.html#GUID-8DF6BEA5-42AE-42FF-980B-949EF15BF7DA"
                        },
                        {
                            "title":"DDL Processing in a Distributed Database",
                            "href":"ddl-processing.html#GUID-FD5760B7-1F77-4A3C-A74C-2C70B2469E16"
                        },
                        {
                            "title":"Running PL/SQL Procedures in a Distributed Database",
                            "href":"running-pl-sql-procedures.html#GUID-67BC4EEF-91D7-4240-8975-06C94E2FEA8C"
                        },
                        {
                            "title":"Generating Unique Sequence Numbers Across Shards",
                            "href":"generating-unique-sequence-numbers-shards.html#GUID-1ED42D4E-7A13-4303-9EF7-253BAE6A4999"
                        },
                        {
                            "title":"High Speed Data Ingest with SQL*Loader",
                            "href":"high-speed-data-ingest-sqlloader.html#GUID-9A575ADD-0545-4EAC-BAA1-9583551D5AAD"
                        },
                        {
                            "title":"Schema Creation Examples",
                            "href":"schema-creation-examples.html#GUID-BDE45E28-9075-42AB-8F47-9C3995BDA7E2"
                        },
                        {
                            "title":"DDL Failure and Recovery Examples",
                            "href":"ddl-failure-and-recovery-examples.html#GUID-F4479521-DFF2-49B3-BE12-51CCB3B05B0D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Shard-Level Replication with Oracle Data Guard",
                    "href":"data-guard-chapter-orientation.html#GUID-29ABC133-A3EF-403B-A756-D80FC62BE597"
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Raft Replication Configuration and Management",
                    "href":"raft-replication.html#GUID-AB5D3A4B-51BD-456C-B03E-4C6B3EDB4C2B",
                    "topics":[
                        {
                            "title":"Using Raft Replication in Oracle Globally Distributed Database",
                            "href":"raft-replication-concepts.html#GUID-AF14C34B-4F55-4528-8B28-5073A3BFD2BE"
                        },
                        {
                            "title":"Enabling Raft Replication",
                            "href":"enabling-raft-replication.html#GUID-F4568AD4-321C-4549-96A3-E6EF695C9592"
                        },
                        {
                            "title":"Raft Replication Operations and Settings",
                            "href":"raft-replication-operations.html#GUID-0D3B427D-043B-4C21-8BBB-A56F221FA71B"
                        },
                        {
                            "title":"Raft Replication Restrictions",
                            "href":"raft-replication-restrictions.html#GUID-1FD6F057-E8A9-4B88-86A0-E6E874AFD0D7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Deploying and Managing a Directory-Based Oracle Globally Distributed Database",
                    "href":"deploying-and-managing-directory-based-gdd.html#GUID-1ACCEE0E-EEAD-4E08-A8A6-64DE5D7FD18F",
                    "topics":[
                        {
                            "title":"Directory-Based Distributed Database Roadmap",
                            "href":"directory-based-gdd-roadmap.html#GUID-519982C0-0005-4A12-B130-796F6496C923"
                        },
                        {
                            "title":"Creating a Shard Catalog for a Directory-Based Distributed Database",
                            "href":"creating-shard-catalog-directory-based-gdd.html#GUID-D5913E73-88B6-4CE4-BE39-B7174CAF9D8C"
                        },
                        {
                            "title":"Creating Tables Sharded by Directory",
                            "href":"creating-tables-sharded-directory.html#GUID-F323BB3D-921E-4A54-88C8-DBAB13178994"
                        },
                        {
                            "title":"Managing Keys in a Directory-Based Distributed Database",
                            "href":"managing-keys-directory-based-gdd.html#GUID-1C633B26-FC47-48F3-885C-F94BA6C6B97D"
                        },
                        {
                            "title":"DML Support on Tables Sharded by Directory",
                            "href":"dml-support-tables-sharded-directory.html#GUID-01FF27CA-2625-4BA0-9A56-BF490C190D7A"
                        },
                        {
                            "title":"Adding a New Tablespace and Chunks (Partition) in a Shardspace",
                            "href":"adding-new-tablespace-and-chunks-partition-shardspace.html#GUID-267DCA0D-5225-4ECE-B019-1C1655D69F56"
                        },
                        {
                            "title":"Chunk Management in a Directory-Based Distributed Database",
                            "href":"chunk-management-directory-based-gdd.html#GUID-D1881B50-1566-4621-8DBA-776E85FD762E"
                        },
                        {
                            "title":"Splitting Partitions (Chunks)",
                            "href":"splitting-partitions.html#GUID-248AFD0F-5E9B-4724-B426-6B41ABCF0591"
                        },
                        {
                            "title":"Sharding Key Directory Public View",
                            "href":"sharding-key-directory-public-view.html#GUID-1BC8E8C5-5515-4056-96E9-EBFF51734348"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Query and DML Processing",
                    "href":"query-and-dml-processing1.html#GUID-EFC30D99-D4A8-40F6-A0DC-D15FE7BDC7F4",
                    "topics":[
                        {
                            "title":"How Database Requests are Routed to the Shards",
                            "href":"how-database-requests-are-routed-shards.html#GUID-0E965889-9C00-43EF-88BB-12DA1114E559"
                        },
                        {
                            "title":"Connecting to the Query Coordinator",
                            "href":"connecting-query-coordinator.html#GUID-94856D08-8217-4626-B72F-9328A7DA4DA9"
                        },
                        {
                            "title":"Query Coordinator Operation",
                            "href":"query-coordinator-operation.html#GUID-E58EA3C1-8EB6-4F51-88BD-FC887035A624"
                        },
                        {
                            "title":"Query Processing for Single-Shard Queries",
                            "href":"query-processing-single-shard-queries.html#GUID-1BC28361-73D8-460E-A5E4-C11FCD721ECC"
                        },
                        {
                            "title":"Query Processing for Multi-Shard Queries",
                            "href":"query-processing-multi-shard-queries.html#GUID-E3CF0022-FA38-4DD0-A5D5-7A409EA45F76"
                        },
                        {
                            "title":"Multi-Shard Query Coordinator Availability and Scalability",
                            "href":"multi-shard-query-coordinator-availability-and-scalability.html#GUID-DA3D2627-86F3-4B78-8CE0-A826995602A7"
                        },
                        {
                            "title":"Pushing PL/SQL Function Queries to the Shards",
                            "href":"pushing-pl-sql-function-queries-shards.html#GUID-37707A83-AD8C-4E18-B031-D68A1644FBE6"
                        },
                        {
                            "title":"Gathering Optimizer Statistics on Sharded Tables",
                            "href":"gathering-optimizer-statistics-sharded-tables.html#GUID-DBB78044-EE32-4A9C-AC90-31E9EBFF8823"
                        },
                        {
                            "title":"Supported Query Constructs and Example Query Shapes",
                            "href":"supported-query-constructs-and-example-query-shapes.html#GUID-EE5D2C35-6CB2-45CC-B936-CABA2C329E1B"
                        },
                        {
                            "title":"Supported DMLs and Examples",
                            "href":"supported-dmls-and-examples.html#GUID-128B938E-D931-4D47-B75D-5F979FE90E14"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Oracle Globally Distributed Database Administration",
                    "href":"administration1.html#GUID-1A3B887E-148D-4167-81B5-B0FA35746E4B",
                    "topics":[
                        {
                            "title":"Managing the Oracle Globally Distributed Database Stack",
                            "href":"managing-software-stack.html#GUID-2C97E1C6-D57C-45F1-9847-8ADD626EE207"
                        },
                        {
                            "title":"Oracle Globally Distributed Database Users and Roles",
                            "href":"users-and-roles.html#GUID-BF41A59D-10F7-40E8-88DD-8EBF96B9B6B5"
                        },
                        {
                            "title":"Backing Up and Recovering a Distributed Database",
                            "href":"backup-and-recovery.html#GUID-99A32370-00BD-4C30-A2DB-19F4EA168064"
                        },
                        {
                            "title":"Propagation of Parameter Settings Across Shards",
                            "href":"propagation-parameter-settings-shards.html#GUID-92ADAEAE-D44A-4DF3-AACC-E4EE888DEC82"
                        },
                        {
                            "title":"Patching and Upgrading Oracle Globally Distributed Database",
                            "href":"patching-and-upgrading.html#GUID-95B0C1F3-D7F7-43F8-84B2-1DDDDF5F8380"
                        },
                        {
                            "title":"Managing Oracle Globally Distributed Database with Enterprise Manager Cloud Control",
                            "href":"managing-oracle-gdd-enterprise-manager-cloud-control.html#GUID-C4C85B30-CFB7-4D21-9BAB-7AECC783DD1D"
                        },
                        {
                            "title":"Monitoring an Oracle Globally Distributed Database",
                            "href":"monitoring-gdd.html#GUID-E23CF5A3-2A30-47D3-8F61-F625F3518A1C"
                        },
                        {
                            "title":"Shard Management",
                            "href":"shard-management.html#GUID-85D98DBC-E4CA-4C11-B887-650595E6A8CB"
                        },
                        {
                            "title":"Chunk Management",
                            "href":"chunk-management.html#GUID-9F8CEDA8-42ED-4039-ADF7-608D0763E3A8"
                        },
                        {
                            "title":"Shard Director Management",
                            "href":"shard-director-management-em.html#GUID-493D8985-89B3-4B96-B84B-F2BFF95A57D5"
                        },
                        {
                            "title":"Region Management",
                            "href":"region-management-em.html#GUID-90BD3394-3D65-4DDF-B8C8-662CD4E825C2"
                        },
                        {
                            "title":"Shardspace Management",
                            "href":"shardspace-management.html#GUID-C2667825-32A8-4AEA-9890-373A66E64A58"
                        },
                        {
                            "title":"Shardgroup Management",
                            "href":"shardgroup-management-em.html#GUID-C9885B8A-1588-4EA1-AB51-24628A42002E"
                        },
                        {
                            "title":"Services Management",
                            "href":"services-management-em.html#GUID-84C8DF7F-0136-4FA5-85C9-AEDB9403E972"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Developing Applications for Oracle Globally Distributed Database",
                    "href":"developing-applications.html#GUID-4EB511F9-05AB-4E3F-9B69-D59F21799FFF",
                    "topics":[
                        {
                            "title":"Direct Routing to a Shard",
                            "href":"direct-routing-shard.html#GUID-64CAD794-FAAA-406B-9E20-0C35E96D3FA8"
                        },
                        {
                            "title":"APIs Supporting Direct Routing",
                            "href":"oracle-sharding-apis-supporting-direct-routing.html#GUID-A49CEDDD-49F7-49EF-B83B-74048A63021E"
                        },
                        {
                            "title":"JDBC Sharding Data Source",
                            "href":"jdbc-sharding-data-source.html#GUID-075EE029-CA79-40BC-8D96-3F23C81C0A63"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Security in an Oracle Globally Distributed Database Environment",
                    "href":"security1.html#GUID-4EA7943E-C456-491A-A055-5C8C9F3A7440",
                    "topics":[
                        {
                            "title":"Using TCPS Protocol and Transport Layer Security",
                            "href":"using-tcps-protocol-and-transport-layer-security.html#GUID-B3240727-88A1-480A-A1C9-B9EA5977E495"
                        },
                        {
                            "title":"Using Wallets",
                            "href":"using-wallets.html#GUID-5DEE0D74-3DC2-4FA0-BBC7-01661EF56A28"
                        },
                        {
                            "title":"Using Application Contexts During Cross-Shard Operations",
                            "href":"using-application-contexts-cross-shard-operations.html#GUID-869CF3BE-C23E-4DB9-9D08-6FDE17D8991C"
                        },
                        {
                            "title":"Behavior Differences",
                            "href":"behavior-differences.html#GUID-5783BBAE-5487-4692-AD65-F31871104322"
                        },
                        {
                            "title":"Using Transparent Data Encryption",
                            "href":"using-transparent-data-encryption.html#GUID-E566D7E5-9BCA-47B0-B651-C57BE01E111D"
                        },
                        {
                            "title":"Creating a Single Encryption Key on All Shards",
                            "href":"creating-single-encryption-key-all-shards.html#GUID-1F8910A8-A76D-4024-B566-03D422D5AFBF"
                        },
                        {
                            "title":"Oracle Database Vault",
                            "href":"issues-data-vault.html#GUID-A5100E92-A6B4-4ECE-B8EC-D0E2A642592E"
                        },
                        {
                            "title":"Failed Login Attempts Only Counted Per Shard",
                            "href":"failed-login-counts.html#GUID-908F0B00-8841-4096-9EAB-BC34F2D55032"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Migrating to an Oracle Globally Distributed Database",
                    "href":"migration1.html#GUID-3537DA5F-FA92-4BE4-B527-37CCF48B93A3",
                    "topics":[
                        {
                            "title":"Migration with Oracle Data Pump",
                            "href":"using-oracle-data-pump-migrate-sharded-database.html#GUID-041069C8-FA7B-4BA5-BFB8-B5A949DA12A9"
                        },
                        {
                            "title":"Using External Tables to Load Data into a Distributed Database",
                            "href":"using-external-tables-load-data-sharded-database.html#GUID-D2CD7510-79CE-44B1-A91A-8A96EE2EF62E"
                        },
                        {
                            "title":"Oracle GoldenGate Microservices Migration",
                            "href":"using-oracle-goldengate-migrate-data-non-gdd-gdd.html#GUID-C51E918E-2DAC-401B-91B2-CDBBD0699767"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Using Oracle Globally Distributed Database in Oracle Cloud Infrastructure",
                    "href":"gdd-oracle-cloud-infrastructure.html#GUID-E77A60FC-410B-447B-9855-FC6788A02154",
                    "topics":[
                        {
                            "title":"Oracle Cloud Infrastructure Services",
                            "href":"gdd-cloud-services.html#GUID-2608B383-6154-4378-A29B-5E1E0DC9E5D9"
                        },
                        {
                            "title":"Deploy an Oracle Globally Distributed Database on Kubernetes",
                            "href":"deploy-sharded-database-kubernetes.html#GUID-E858EFE1-F7D0-4E09-AA79-9663331176B1"
                        },
                        {
                            "title":"Deploy an Oracle Globally Distributed Database with Terraform",
                            "href":"deploy-sharded-database-terraform.html#GUID-DA85BD66-B4C9-454E-B9A6-54A402C8141D"
                        },
                        {
                            "title":"Deploy an Oracle Globally Distributed Database with Docker",
                            "href":"deploy-sharded-database-docker.html#GUID-8639D959-7395-445B-8E70-71B6DB333A12"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Using the Sharding Advisor",
                    "href":"using-gdd-advisor1.html#GUID-71AD0EB7-8D8A-47A0-88A5-314CC26043DE",
                    "topics":[
                        {
                            "title":"About Sharding Advisor",
                            "href":"sharding-advisor.html#GUID-3BFD0479-520D-4595-A0FE-8AA8695C8979"
                        },
                        {
                            "title":"Run Sharding Advisor",
                            "href":"run-sharding-advisor.html#GUID-F03D3986-15B9-4CFE-9FEE-F0D280834B00"
                        },
                        {
                            "title":"Run Sharding Advisor on a Non-Production System",
                            "href":"run-sharding-advisor-non-production-system.html#GUID-DCFC0ADF-0DF3-4C9B-B3C3-701491B6BF59"
                        },
                        {
                            "title":"Review Sharding Advisor Output",
                            "href":"review-sharding-advisor-output.html#GUID-E47BD07E-69B5-4923-9EAB-C6B2FAEE33DE"
                        },
                        {
                            "title":"Choose a Sharding Advisor Recommended Configuration",
                            "href":"choose-sharding-advisor-recommended-configuration.html#GUID-5D376D48-6075-4520-A3DA-D371C1003EF7"
                        },
                        {
                            "title":"Sharding Advisor Usage and Options",
                            "href":"sharding-advisor-usage-and-options.html#GUID-7411FB1E-03F6-45BE-90F3-E26597EC813E"
                        },
                        {
                            "title":"Sharding Advisor Output Tables",
                            "href":"sharding-advisor-output-tables.html#GUID-671A1FC1-5298-47A5-8488-EDAAB355210C"
                        },
                        {
                            "title":"Sharding Advisor Output Review SQL Examples",
                            "href":"sharding-advisor-output-review-sql-examples.html#GUID-8CDF95AB-1755-4CC0-A115-0933EE79905E"
                        },
                        {
                            "title":"Sharding Advisor Security",
                            "href":"sharding-advisor-security.html#GUID-058B55FC-DFFA-4A38-8995-C46B69E23084"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> JSON Document Collections in a Distributed Database",
                    "href":"json-document-collections-gdd.html#GUID-DBDA8C48-E456-4E48-BE69-FC3F8B58982B",
                    "topics":[
                        {
                            "title":"Overview of Sharding JSON Documents",
                            "href":"overview-sharding-json-documents.html#GUID-08FF78A7-686A-4BB6-A9DF-D6C718E1FDD6"
                        },
                        {
                            "title":"Preparing the Environment",
                            "href":"preparing-oracle-sharding-environment.html#GUID-1501F6D2-A5BF-4516-A070-5B47A0ADBB04"
                        },
                        {
                            "title":"Creating an All-Shards User with SODA Privileges",
                            "href":"creating-all-shards-user-soda-privileges.html#GUID-E0CB23FE-D102-4049-9333-556AAA1AA7A7"
                        },
                        {
                            "title":"Choosing a Sharding Key",
                            "href":"choosing-sharding-key.html#GUID-03697E79-68E7-4540-9B0B-0B00656FAC2E"
                        },
                        {
                            "title":"Using SODA ID as the Sharding Key",
                            "href":"using-soda-id-sharding-key.html#GUID-9A7F787B-A8AD-424B-ADC9-A8F268DA5B40"
                        },
                        {
                            "title":"Using a JSON Field as a Sharding Key",
                            "href":"using-json-field-sharding-key.html#GUID-FAB9FECC-8F5D-48D1-830C-EE3014CE4BA6"
                        },
                        {
                            "title":"Additional Information About Sharding with SODA",
                            "href":"additional-information-sharding-soda.html#GUID-8F224162-47A9-438E-881B-5BFFF60050FA"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Achieving Data Sovereignty with Oracle Globally Distributed Database",
                    "href":"achieving-data-sovereignty-gdd.html#GUID-4AA1D64A-F89B-462A-BA4E-F04038665999",
                    "topics":[
                        {
                            "title":"Overview of Data Sovereignty",
                            "href":"overview-data-sovereignty.html#GUID-2C1E3587-880C-46E7-AB1B-82E9BEABF516"
                        },
                        {
                            "title":"Benefits of Implementing Data Sovereignty with Oracle Globally Distributed Database",
                            "href":"benefits-implementing-data-sovereignty.html#GUID-AAA950B2-3F4E-47C6-924D-9A469D65F2F4"
                        },
                        {
                            "title":"Implementing Data Sovereignty with Oracle Globally Distributed Database",
                            "href":"implementing-data-sovereignty.html#GUID-A0690726-D30A-4E32-BC39-492F6D39454C"
                        },
                        {
                            "title":"Data Sovereignty Use Case",
                            "href":"use-case-achieving-data-sovereignty.html#GUID-5D87B89D-88B3-4DF5-8424-9CE125940FC8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Creating a Federated Distributed Database",
                    "href":"creating-federated-distributed-database.html#GUID-17F8EF42-3FB5-4EBA-8A8A-B90B244129E6",
                    "topics":[
                        {
                            "title":"Overview of Federated Distributed Database",
                            "href":"federated-ddb-overview.html#GUID-C139C3DD-38FE-4AA7-8E47-1A0F4EE6E69D"
                        },
                        {
                            "title":"Configuring a Federated Distributed Database",
                            "href":"creating-and-deploying-federated-ddb-configuration.html#GUID-AC577506-3448-49B2-98DF-760516097B19"
                        },
                        {
                            "title":"Federated Distributed Database Reference",
                            "href":"federated-ddb-reference.html#GUID-EA916B8F-D971-44EE-8DCE-220D662DA77F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Creating Affinity Between Middle-Tier and Shards",
                    "href":"creating-affinity-middle-tier-and-shards.html#GUID-F5D3C0B6-83F9-457A-97A9-429AC9EE4550"
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Troubleshooting",
                    "href":"troubleshooting1.html#GUID-629262E5-7910-4690-A726-A565C59BA73E",
                    "topics":[
                        {
                            "title":"Troubleshooting Tips",
                            "href":"troubleshooting-tips.html#GUID-6456EF62-B6AF-489E-B968-B775D12762DD"
                        },
                        {
                            "title":"Gathering Optimizer Statistics on Sharded Tables",
                            "href":"Chunk2093819934.html#GUID-DBB78044-EE32-4A9C-AC90-31E9EBFF8823"
                        },
                        {
                            "title":"Generate HTML SQL Monitor Output for a Query Running from the Shard Catalog",
                            "href":"generate-html-sql-monitor-output-query-running-shard-catalog.html#GUID-8CB8DB0B-2B59-4BDB-A9B6-3DB9090A111E"
                        },
                        {
                            "title":"Tracing and Debug Information",
                            "href":"tracing-and-debug-information.html#GUID-8D44BB2E-40C5-454F-A864-8004B1FC930D"
                        },
                        {
                            "title":"Common Error Patterns and Resolutions",
                            "href":"common-error-patterns-and-resolutions.html#GUID-2DD22217-BDA6-4C07-A4C6-19081960B743"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> Oracle Globally Distributed Database Reference",
                    "href":"reference1.html#GUID-89DBBC10-D892-4FA7-A38B-6761B2A936CF",
                    "topics":[
                        {
                            "title":"Using GDSCTL with Oracle Globally Distributed Database",
                            "href":"using-gdstl-oracle-sharding.html#GUID-15553DBF-2D49-4A2B-B49D-5770414ED2A3"
                        },
                        {
                            "title":"SHARDED_TABLE_FAMILIES",
                            "href":"sharded_table_families-view.html#GUID-72712376-C465-4A1D-BAA4-C5E4D9166771"
                        }
                    ]
                }
            ]
        }
    ]
});