define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Examples",
                    "href":"loe.html"
                },
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-CDF0F10C-20C3-488E-96C7-599C9E997AD0"
                },
                {
                    "title":"Changes in This Release for Oracle Spatial Developer's Guide",
                    "href":"changes-this-release-oracle-spatial-developers-guide.html#GUID-5E366823-B1E7-4C42-AE5B-9AE8049EF7FE"
                },
                {
                    "title":"Part I Conceptual and Usage Information",
                    "href":"conceptual-and-usage-information.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> Spatial Concepts",
                            "href":"spatial-concepts.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1 </span> What Is Oracle Spatial?",
                                    "href":"what-is-oracle-spatial.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.2 </span> Object-Relational Model",
                                    "href":"object-relational-model.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.3 </span> Introduction to Spatial Data",
                                    "href":"introduction-spatial-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4 </span> Geometry Types",
                                    "href":"geometry-types.html#GUID-CD6ABC34-1CB4-476D-ACB1-BDA07026C206"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5 </span> Data Model",
                                    "href":"data-model.html#GUID-D92BAC59-0CF2-4C3E-B17A-D690AEA90F15"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.6 </span> Query Model",
                                    "href":"query-model.html#GUID-79F09397-E9DA-4E91-B154-9ECB327A5809"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.7 </span> Indexing of Spatial Data",
                                    "href":"indexing-spatial-data.html#GUID-54CCC43F-56B7-42C6-8C87-86843FA25AFC"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.8 </span> Spatial Relationships and Filtering",
                                    "href":"spatial-relationships-and-filtering.html#GUID-FA71CB03-FFF0-4529-BA07-AD0605DA7A89"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.9 </span> Spatial Operators, Procedures, and Functions",
                                    "href":"spatial-operators-procedures-and-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.10 </span> Spatial Aggregate Functions",
                                    "href":"spatial-aggregate-functions.html#GUID-3BD00273-E74F-4830-9444-A3BB15AA0AC4"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.11 </span> Vector Tiles",
                                    "href":"vector-tiles.html#GUID-77640B2D-C3B2-438F-A46A-0AAD78DB7AB9"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.12 </span> H3 Indexing",
                                    "href":"h3-indexing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.13 </span> Three-Dimensional Spatial Objects",
                                    "href":"three-dimensional-spatial-objects.html#GUID-6F3A9C6E-3617-47D9-AE61-CF9F1770555A"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.14 </span> Geocoding",
                                    "href":"geocoding.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.15 </span> Location Data Enrichment",
                                    "href":"location-data-enrichment.html#GUID-1319B328-0F3E-4202-868C-B7435E4FA98F"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.16 </span> JSON and GeoJSON Support in Oracle Spatial",
                                    "href":"json-and-geojson-support-oracle-spatial-and-graph.html#GUID-0D253291-6FB9-4DBF-BD84-925E7E9C93D0"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.17 </span> NURBS Curve Support in Oracle Spatial",
                                    "href":"nurbs-curve-support-oracle-spatial-and-graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.18 </span> Sharded Database Support by Oracle Spatial",
                                    "href":"sharded-database-support-oracle-spatial-and-graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.19 </span> Database In-Memory Support by Oracle Spatial",
                                    "href":"database-memory-support-oracle-spatial.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.20 </span> Spatial Java Application Programming Interface",
                                    "href":"spatial-java-application-programming-interface.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.21 </span> Predefined User Accounts Created by Spatial",
                                    "href":"predefined-user-accounts-created-spatial-and-graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.22 </span> Performance and Tuning Information",
                                    "href":"performance-and-tuning-information.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.23 </span> OGC and ISO Compliance",
                                    "href":"ogc-and-iso-compliance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.24 </span> Spatial Release (Version) Number",
                                    "href":"spatial-and-graph-release-version-number.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.25 </span> SPATIAL_VECTOR_ACCELERATION System Parameter",
                                    "href":"spatial_vector_acceleration-system-parameter.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.26 </span> Spatially Enabling a Table",
                                    "href":"spatially-enabling-table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.27 </span> Moving Spatial Metadata (MDSYS.MOVE_SDO)",
                                    "href":"moving-spatial-metadata-mdsys-move_sdo.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.28 </span> Spatial Application Hardware Requirement Considerations",
                                    "href":"spatial-application-hardware-requirement-considerations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.29 </span> Spatial Studio Application",
                                    "href":"spatial-studio-application.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.30 </span> Spatial Error Messages",
                                    "href":"spatial-error-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.31 </span> Spatial Examples",
                                    "href":"spatial-examples.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.32 </span> Getting Started with Longitude/Latitude Spatial Data",
                                    "href":"getting-started-longitude-latitude-spatial-data-creating-and-indexing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.33 </span> README File for Spatial and Related Features",
                                    "href":"readme-file-spatial-and-graph-and-related-features.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> Spatial Data Types and Metadata",
                            "href":"spatial-data-types-and-metadata.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1 </span> Simple Example: Inserting, Indexing, and Querying Spatial Data",
                                    "href":"simple-example-inserting-indexing-and-querying-spatial-data.html#GUID-51A767CA-82EE-4475-8C8B-13E685C04934"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2 </span> SDO_GEOMETRY Object Type",
                                    "href":"sdo_geometry-object-type.html#GUID-683FF8C5-A773-4018-932D-2AF6EC8BC119"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3 </span> SDO_GEOMETRY Methods",
                                    "href":"sdo_geometry-methods.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.4 </span> SDO_GEOMETRY Constructors",
                                    "href":"sdo_geometry-constructors.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.5 </span> TIN-Related Object Types",
                                    "href":"tin-related-object-types.html#GUID-5D9C0035-7470-470F-B006-B217A67CD66B"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6 </span> Point Cloud-Related Object Types",
                                    "href":"point-cloud-related-object-types.html#GUID-D347DC78-8782-4BB5-995D-0315B3DD2AB4"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.7 </span> Geometry Examples",
                                    "href":"geometry-examples.html#GUID-539FDF31-CF9B-4D16-8C5C-B9D4CFD2A891"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.8 </span> Geometry Metadata Views",
                                    "href":"geometry-metadata-views.html#GUID-AEA8FA01-880B-4865-8074-3B6FBD17A5E1"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.9 </span> Other Spatial Metadata Views",
                                    "href":"other-spatial-metadata-views.html#GUID-BEB3130F-9F57-4BE6-BC7D-8418FBC372FB"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.10 </span> Spatial Index-Related Structures",
                                    "href":"spatial-index-related-structures.html#GUID-154F785A-F706-47E9-9C42-355FBD316295"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11 </span> Unit of Measurement Support",
                                    "href":"unit-measurement-support.html#GUID-5984C12A-0A22-4BFD-B777-7C837D3CBB99"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3 </span> SQL Multimedia Type Support",
                            "href":"sql-multimedia-type-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1 </span> ST_GEOMETRY and SDO_GEOMETRY Interoperability",
                                    "href":"st_geometry-and-sdo_geometry-interoperability.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2 </span> ST_xxx Functions and Spatial Counterparts",
                                    "href":"st_xxx-functions-and-spatial-and-graph-counterparts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3 </span> Tolerance Value with SQL Multimedia Types",
                                    "href":"tolerance-value-sql-multimedia-types.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4 </span> Avoiding Name Conflicts",
                                    "href":"avoiding-name-conflicts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5 </span> Annotation Text Type and Views",
                                    "href":"annotation-text-type-and-views.html#GUID-6E589C3D-211A-46D6-AA4B-D930954F61AF"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> Loading Spatial Data",
                            "href":"loading-spatial-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1 </span> Bulk Loading",
                                    "href":"bulk-loading.html#GUID-8F3F3469-D903-4FD5-B480-FF5DFF0C2F61"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2 </span> Transactional Insert Operations Using SQL",
                                    "href":"transactional-insert-operations-using-sql.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3 </span> Recommendations for Loading and Validating Spatial Data",
                                    "href":"recommendations-loading-and-validating-spatial-data.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5 </span> Indexing and Querying Spatial Data",
                            "href":"indexing-and-querying-spatial-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1 </span> Creating a Spatial Index",
                                    "href":"creating-spatial-index.html#GUID-18BB2973-096E-4239-9A01-0C95E9AFEFA1"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2 </span> Querying Spatial Data",
                                    "href":"querying-spatial-data.html#GUID-34D74D79-6B6A-4827-B418-A05D3F41103D"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6 </span> Coordinate Systems (Spatial Reference Systems)",
                            "href":"coordinate-systems-spatial-reference-systems.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1 </span> Terms and Concepts",
                                    "href":"terms-and-concepts.html#GUID-80FF1099-111C-43A7-8B3B-8F9BA2937E74"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2 </span> Geodetic Coordinate Support",
                                    "href":"geodetic-coordinate-support.html#GUID-EF519345-BDC9-4A3B-9680-728EB6C3955D"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.3 </span> Local Coordinate Support",
                                    "href":"local-coordinate-support.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.4 </span> EPSG Model and Spatial",
                                    "href":"epsg-model-and-spatial-and-graph.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.5 </span> Three-Dimensional Coordinate Reference System Support",
                                    "href":"three-dimensional-coordinate-reference-system-support.html#GUID-15FBE081-AD2E-4316-84A7-14BCDD25C7AF"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.6 </span> TFM_PLAN Object Type",
                                    "href":"tfm_plan-object-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.7 </span> Coordinate Systems Data Structures",
                                    "href":"coordinate-systems-data-structures.html#GUID-7DEF5C91-777C-4023-AE2E-E2E29F5213D2"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.8 </span> Legacy Tables and Views",
                                    "href":"legacy-tables-and-views.html#GUID-FE6B0C7A-7A72-47F5-9BEE-9C117E6BE4BB"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.9 </span> Creating a User-Defined Coordinate Reference System",
                                    "href":"creating-user-defined-coordinate-reference-system.html#GUID-C199908B-F3D5-41F7-8F60-E8CD3BEA7E29"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.10 </span> Notes and Restrictions with Coordinate Systems Support",
                                    "href":"notes-and-restrictions-coordinate-systems-support.html#GUID-5B023245-55FA-4D9A-B806-1FD336704087"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.11 </span> U.S. National Grid Support",
                                    "href":"u-s-national-grid-support.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.12 </span> Geohash Support",
                                    "href":"geohash-support.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.13 </span> Google Maps Considerations",
                                    "href":"google-maps-considerations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.14 </span> Example of Coordinate System Transformation",
                                    "href":"example-coordinate-system-transformation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7 </span> Linear Referencing System",
                            "href":"linear-referencing-system.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1 </span> LRS Terms and Concepts",
                                    "href":"lrs-terms-and-concepts.html#GUID-606C936B-DB4F-4FE0-A5F6-3C1C15FA30C2"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2 </span> LRS Data Model",
                                    "href":"lrs-data-model.html#GUID-34C0AE0E-09AD-4765-A426-8AEBB7CE5A20"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3 </span> Indexing of LRS Data",
                                    "href":"indexing-lrs-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.4 </span> 3D Formats of LRS Functions",
                                    "href":"3d-formats-lrs-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.5 </span> LRS Operations",
                                    "href":"lrs-operations.html#GUID-247E53DE-3F27-4BE2-97D6-363F10814985"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.6 </span> Tolerance Values with LRS Functions",
                                    "href":"tolerance-values-lrs-functions.html#GUID-2A6BC86B-0BE8-43F5-98D9-44E08ADF692C"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.7 </span> Example of LRS Functions",
                                    "href":"example-lrs-functions.html#GUID-699CED71-3497-4826-A4A5-60BF13CD3770"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8 </span> Location Tracking Server",
                            "href":"location-tracking-server1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1 </span> About the Location Tracking Server",
                                    "href":"location-tracking-server.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2 </span> Location Tracking Set",
                                    "href":"location-tracking-set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3 </span> Data Types for the Location Tracking Server",
                                    "href":"data-types-location-tracking-server.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4 </span> Data Structures for the Location Tracking Server",
                                    "href":"data-structures-location-tracking-server.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.5 </span> Workflow for the Location Tracking Server",
                                    "href":"workflow-location-tracking-server.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9 </span> Spatial Analysis and Mining",
                            "href":"spatial-analysis-and-mining.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.1 </span> Spatial Information and Data Mining Applications",
                                    "href":"spatial-information-and-data-mining-applications.html#GUID-5D2E4A7C-0C04-4A11-ABC0-278385F4F3FF"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.2 </span> Spatial Binning for Detection of Regional Patterns",
                                    "href":"spatial-binning-detection-regional-patterns.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.3 </span> Materializing Spatial Correlation",
                                    "href":"materializing-spatial-correlation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.4 </span> Colocation Mining",
                                    "href":"colocation-mining.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.5 </span> Spatial Clustering",
                                    "href":"spatial-clustering.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.6 </span> Location Prospecting",
                                    "href":"location-prospecting.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10 </span> Extending Spatial Indexing Capabilities",
                            "href":"extending-spatial-indexing-capabilities.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1 </span> SDO_GEOMETRY Objects in User-Defined Type Definitions",
                                    "href":"sdo_geometry-objects-user-defined-type-definitions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.2 </span> SDO_GEOMETRY Objects in Function-Based Indexes",
                                    "href":"sdo_geometry-objects-function-based-indexes.html#GUID-CFB6B6DB-4B97-43D1-86A1-21C1BA853089"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part II Spatial Web Services",
                    "href":"spatial-web-services.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11 </span> Introduction to Spatial Web Services",
                            "href":"introduction-spatial-web-services.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.1 </span> Types of Spatial Web Services",
                                    "href":"types-spatial-web-services.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2 </span> Types of Users of Spatial Web Services",
                                    "href":"types-users-spatial-web-services.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.3 </span> Deploying and Configuring Spatial Web Services",
                                    "href":"deploying-and-configuring-spatial-web-services.html#GUID-E22E51C3-892A-4415-91DF-625CC01CD2DE"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12 </span> Geocoding Address Data",
                            "href":"geocoding-address-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.1 </span> Concepts for Geocoding",
                                    "href":"concepts-geocoding.html#GUID-27332DC7-BC0E-46A2-89F4-ADC69132D4AA"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.2 </span> Data Types for Geocoding",
                                    "href":"data-types-geocoding.html#GUID-41EA1F45-3978-496E-93A5-295E9A6328BA"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3 </span> Using the Geocoding Capabilities",
                                    "href":"using-geocoding-capabilities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.4 </span> Geocoding from a Place Name",
                                    "href":"geocoding-place-name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.5 </span> Data Structures for Geocoding",
                                    "href":"data-structures-geocoding.html#GUID-14021C3B-6DCC-421F-B67E-29148EADAA21"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.6 </span> Installing the Profile Tables",
                                    "href":"installing-profile-tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.7 </span> Using the Geocoding Service (XML API)",
                                    "href":"using-geocoding-service-xml-api.html#GUID-01A2C4F9-B250-4A76-9DA6-D829FE5921E1"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">13 </span> Business Directory (Yellow Pages) Support",
                            "href":"business-directory-yellow-pages-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.1 </span> Business Directory Concepts",
                                    "href":"business-directory-concepts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2 </span> Using the Business Directory Capabilities",
                                    "href":"using-business-directory-capabilities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.3 </span> Data Structures for Business Directory Support",
                                    "href":"data-structures-business-directory-support.html#GUID-8DF2CECB-168E-44F5-B41A-66BF006ED73C"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14 </span> Routing Engine",
                            "href":"routing-engine.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1 </span> Routing",
                                    "href":"routing.html#GUID-F54D321D-2BAC-40F1-A823-BF1A672FD5E4"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2 </span> Deploying the Routing Engine",
                                    "href":"deploying-routing-engine.html#GUID-17D3E385-FD35-4EBA-9DBB-C61B4610933D"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.3 </span> Routing Engine XML API",
                                    "href":"routing-engine-xml-api.html#GUID-B25365E3-3843-404E-98EF-8A16CA5D8AD4"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.4 </span> Location-Based Query Using the WSServlet XML API",
                                    "href":"location-based-query-using-wsservlet-xml-api.html#GUID-7ACA84EE-7C06-427F-81AC-5B236A5DF5DA"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.5 </span> Data Structures Used by the Routing Engine",
                                    "href":"data-structures-used-routing-engine.html#GUID-C6D3CD44-CD67-4570-90BE-D8D768A62CDD"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.6 </span> User Data Structures Used by the Routing Engine",
                                    "href":"user-data-structures-used-routing-engine.html#GUID-7F72093A-B400-4817-8C28-11D47FA15167"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">15 </span> OpenLS Support",
                            "href":"openls-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.1 </span> Supported OpenLS Services",
                                    "href":"supported-openls-services.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2 </span> OpenLS Application Programming Interfaces",
                                    "href":"openls-application-programming-interfaces.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.3 </span> OpenLS Service Support and Examples",
                                    "href":"openls-service-support-and-examples.html#GUID-D35908E1-1284-4DD3-B238-51D33AA64492"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">16 </span> Web Feature Service (WFS) Support",
                            "href":"web-feature-service-wfs-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.1 </span> WFS Engine",
                                    "href":"wfs-engine.html#GUID-3A495FD2-A00C-4D47-B3C8-03EC314022E1"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.2 </span> Configuring the WFS Engine",
                                    "href":"configuring-wfs-engine.html#GUID-DC6FADC3-F067-44C7-BCEF-EDEF25FC7D84"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.3 </span> Managing Feature Types",
                                    "href":"managing-feature-types.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.4 </span> Capabilities Documents (WFS)",
                                    "href":"capabilities-documents-wfs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5 </span> WFS Operations: Requests and Responses with XML Examples",
                                    "href":"wfs-operations-requests-and-responses-xml-examples.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.6 </span> WFS Administration Console",
                                    "href":"wfs-administration-console.html#GUID-633E26A1-F42F-481E-B9FF-D392C7F9D114"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.7 </span> Diagnosing WFS Issues",
                                    "href":"diagnosing-wfs-issues.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.8 </span> Using WFS with Oracle Workspace Manager",
                                    "href":"using-wfs-oracle-workspace-manager.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.9 </span> Dropping WFS Support (Release 21c or Later Only)",
                                    "href":"dropping-wfs-support-release-21c-or-later-only.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.10 </span> Updating a WFS Instance from an Oracle Database for a Release Before 21c to Release 21c or Later",
                                    "href":"updating-wfs-instance-oracle-database-release-21c-release-21c-or-later.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17 </span> Web Coverage Service (WCS) Support",
                            "href":"web-coverage-service-wcs-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.1 </span> Web Coverage Service Architecture",
                                    "href":"web-coverage-service-architecture.html#GUID-5ADAE73B-9E83-41DE-9561-61F307F5644C"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.2 </span> Database Schemas for WCS",
                                    "href":"database-schemas-wcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.3 </span> Database Objects Used for WCS",
                                    "href":"database-objects-used-wcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.4 </span> PL/SQL Subprograms for Using WCS",
                                    "href":"pl-sql-subprograms-using-wcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.5 </span> Setting Up WCS Using WebLogic Server",
                                    "href":"setting-wcs-using-weblogic-server.html#GUID-E7632ECF-FD3A-42B7-919A-8B13980F35C5"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.6 </span> WCS Administration Console",
                                    "href":"wcs-administration-console.html#GUID-BA163B07-66D3-42EF-BCFC-277D7F11D56A"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.7 </span> Oracle Implementation Extension for WCS",
                                    "href":"oracle-implementation-extension-wcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.8 </span> WCS Operations: Requests and Responses with XML Examples",
                                    "href":"wcs-operations-requests-and-responses-xml-examples.html#GUID-3326E625-13B3-474F-AEC4-72318818D245"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.9 </span> WCS Extensions Implemented",
                                    "href":"wcs-extensions-implemented.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.10 </span> Diagnosing WCS Issues",
                                    "href":"diagnosing-wcs-issues.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18 </span> Catalog Services for the Web (CSW) Support",
                            "href":"catalog-services-web-csw-support.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.1 </span> CSW Engine and Architecture",
                                    "href":"csw-engine-and-architecture.html#GUID-C97D0A50-6008-41F8-B0DE-D926912341DB"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2 </span> Database Schema and Objects for CSW",
                                    "href":"database-schema-and-objects-csw.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.3 </span> Configuring and Deploying the CSW Engine",
                                    "href":"configuring-and-deploying-csw-engine.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.4 </span> Capabilities Documents (CSW)",
                                    "href":"capabilities-documents-csw.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.5 </span> CSW Major Operations (DCMI Profile)",
                                    "href":"csw-major-operations-dcmi-profile.html#GUID-52EC622D-BDBC-4157-BA14-E59F9DE6E027"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.6 </span> CSW Major Operations (ISO Profile)",
                                    "href":"csw-major-operations-iso-profile.html#GUID-FDB9230A-8407-49E6-97DA-168BA379F56A"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.7 </span> CSW Administration Console",
                                    "href":"csw-administration-console.html#GUID-E73B2A0A-D728-4F28-AD21-ABCC0E0F8AD1"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.8 </span> Diagnosing CSW Issues",
                                    "href":"diagnosing-csw-issues.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part III Reference Information",
                    "href":"reference-information.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19 </span> SQL Statements for Indexing Spatial Data",
                            "href":"sql-statements-indexing-spatial-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.1 </span> ALTER INDEX",
                                    "href":"alter-index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2 </span> ALTER INDEX REBUILD",
                                    "href":"alter-index-rebuild.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.3 </span> ALTER INDEX RENAME TO",
                                    "href":"alter-index-rename.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.4 </span> CREATE INDEX",
                                    "href":"create-index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.5 </span> DROP INDEX",
                                    "href":"drop-index.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">20 </span> Spatial Operators",
                            "href":"spatial-operators.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">20.1 </span> SDO_ANYINTERACT",
                                    "href":"sdo_anyinteract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.2 </span> SDO_CONTAINS",
                                    "href":"sdo_contains.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.3 </span> SDO_COVEREDBY",
                                    "href":"sdo_coveredby.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.4 </span> SDO_COVERS",
                                    "href":"sdo_covers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.5 </span> SDO_EQUAL",
                                    "href":"sdo_equal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.6 </span> SDO_FILTER",
                                    "href":"sdo_filter.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.7 </span> SDO_GEOM_MBR",
                                    "href":"sdo_geom_mbr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.8 </span> SDO_INSIDE",
                                    "href":"sdo_inside.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.9 </span> SDO_JOIN",
                                    "href":"sdo_join.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.10 </span> SDO_NN",
                                    "href":"sdo_nn.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.11 </span> SDO_NN_DISTANCE",
                                    "href":"sdo_nn_distance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.12 </span> SDO_ON",
                                    "href":"sdo_on.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.13 </span> SDO_OVERLAPBDYDISJOINT",
                                    "href":"sdo_overlapbdydisjoint.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.14 </span> SDO_OVERLAPBDYINTERSECT",
                                    "href":"sdo_overlapbdyintersect.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.15 </span> SDO_OVERLAPS",
                                    "href":"sdo_overlaps.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.16 </span> SDO_POINTINPOLYGON",
                                    "href":"sdo_pointinpolygon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.17 </span> SDO_RELATE",
                                    "href":"sdo_relate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.18 </span> SDO_TOUCH",
                                    "href":"sdo_touch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">20.19 </span> SDO_WITHIN_DISTANCE",
                                    "href":"sdo_within_distance.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">21 </span> Spatial Aggregate Functions",
                            "href":"spatial-aggregate-functions1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">21.1 </span> SDO_AGGR_CENTROID",
                                    "href":"sdo_aggr_centroid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.2 </span> SDO_AGGR_CONCAT_LINES",
                                    "href":"sdo_aggr_concat_lines.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.3 </span> SDO_AGGR_CONCAVEHULL",
                                    "href":"sdo_aggr_concavehull.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.4 </span> SDO_AGGR_CONVEXHULL",
                                    "href":"sdo_aggr_convexhull.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.5 </span> SDO_AGGR_LRS_CONCAT",
                                    "href":"sdo_aggr_lrs_concat.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.6 </span> SDO_AGGR_MBR",
                                    "href":"sdo_aggr_mbr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.7 </span> SDO_AGGR_SET_UNION",
                                    "href":"sdo_aggr_set_union.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.8 </span> SDO_AGGR_UNION",
                                    "href":"sdo_aggr_union.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">22 </span> SDO_CS Package (Coordinate System Transformation)",
                            "href":"sdo_cs-package-coordinate-system-transformation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">22.1 </span> SDO_CS.ADD_PREFERENCE_FOR_OP",
                                    "href":"sdo_cs-add_preference_for_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.2 </span> SDO_CS.CONVERT_3D_SRID_TO_2D",
                                    "href":"sdo_cs-convert_3d_srid_to_2d.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.3 </span> SDO_CS.CONVERT_NADCON_TO_XML",
                                    "href":"sdo_cs-convert_nadcon_to_xml.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.4 </span> SDO_CS.CONVERT_NTV2_TO_XML",
                                    "href":"sdo_cs-convert_ntv2_to_xml.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.5 </span> SDO_CS.CONVERT_XML_TO_NADCON",
                                    "href":"sdo_cs-convert_xml_to_nadcon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.6 </span> SDO_CS.CONVERT_XML_TO_NTV2",
                                    "href":"sdo_cs-convert_xml_to_ntv2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.7 </span> SDO_CS.CREATE_CONCATENATED_OP",
                                    "href":"sdo_cs-create_concatenated_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.8 </span> SDO_CS.CREATE_OBVIOUS_EPSG_RULES",
                                    "href":"sdo_cs-create_obvious_epsg_rules.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.9 </span> SDO_CS.CREATE_PREF_CONCATENATED_OP",
                                    "href":"sdo_cs-create_pref_concatenated_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.10 </span> SDO_CS.DELETE_ALL_EPSG_RULES",
                                    "href":"sdo_cs-delete_all_epsg_rules.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.11 </span> SDO_CS.DELETE_OP",
                                    "href":"sdo_cs-delete_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.12 </span> SDO_CS.DETERMINE_CHAIN",
                                    "href":"sdo_cs-determine_chain.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.13 </span> SDO_CS.DETERMINE_DEFAULT_CHAIN",
                                    "href":"sdo_cs-determine_default_chain.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.14 </span> SDO_CS.FIND_GEOG_CRS",
                                    "href":"sdo_cs-find_geog_crs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.15 </span> SDO_CS.FIND_PROJ_CRS",
                                    "href":"sdo_cs-find_proj_crs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.16 </span> SDO_CS.FIND_SRID",
                                    "href":"sdo_cs-find_srid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.17 </span> SDO_CS.FROM_GEOHASH",
                                    "href":"sdo_cs-from_geohash.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.18 </span> SDO_CS.FROM_OGC_SIMPLEFEATURE_SRS",
                                    "href":"sdo_cs-from_ogc_simplefeature_srs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.19 </span> SDO_CS.FROM_USNG",
                                    "href":"sdo_cs-from_usng.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.20 </span> SDO_CS.GENERATE_SCRIPT_FROM_SRID",
                                    "href":"sdo_cs-generate_script_from_srid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.21 </span> SDO_CS.GET_EPSG_DATA_VERSION",
                                    "href":"sdo_cs-get_epsg_data_version.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.22 </span> SDO_CS.GET_GEOHASH_CELL_HEIGHT",
                                    "href":"sdo_cs-get_geohash_cell_height.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.23 </span> SDO_CS.GET_GEOHASH_CELL_WIDTH",
                                    "href":"sdo_cs-get_geohash_cell_width.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.24 </span> SDO_CS.INSERT_SRID",
                                    "href":"sdo_cs-insert_srid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.25 </span> SDO_CS.LOAD_EPSG_MATRIX",
                                    "href":"sdo_cs-load_epsg_matrix.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.26 </span> SDO_CS.MAKE_2D",
                                    "href":"sdo_cs-make_2d.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.27 </span> SDO_CS.MAKE_3D",
                                    "href":"sdo_cs-make_3d.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.28 </span> SDO_CS.MAP_EPSG_SRID_TO_ORACLE",
                                    "href":"sdo_cs-map_epsg_srid_to_oracle.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.29 </span> SDO_CS.MAP_ORACLE_SRID_TO_EPSG",
                                    "href":"sdo_cs-map_oracle_srid_to_epsg.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.30 </span> SDO_CS.REVOKE_PREFERENCE_FOR_OP",
                                    "href":"sdo_cs-revoke_preference_for_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.31 </span> SDO_CS.TO_GEOHASH",
                                    "href":"sdo_cs-to_geohash.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.32 </span> SDO_CS.TO_OGC_SIMPLEFEATURE_SRS",
                                    "href":"sdo_cs-to_ogc_simplefeature_srs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.33 </span> SDO_CS.TO_USNG",
                                    "href":"sdo_cs-to_usng.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.34 </span> SDO_CS.TRANSFORM",
                                    "href":"sdo_cs-transform.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.35 </span> SDO_CS.TRANSFORM_LAYER",
                                    "href":"sdo_cs-transform_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.36 </span> SDO_CS.UPDATE_WKTS_FOR_ALL_EPSG_CRS",
                                    "href":"sdo_cs-update_wkts_for_all_epsg_crs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.37 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_CRS",
                                    "href":"sdo_cs-update_wkts_for_epsg_crs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.38 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_DATUM",
                                    "href":"sdo_cs-update_wkts_for_epsg_datum.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.39 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_ELLIPS",
                                    "href":"sdo_cs-update_wkts_for_epsg_ellips.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.40 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_OP",
                                    "href":"sdo_cs-update_wkts_for_epsg_op.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.41 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_PARAM",
                                    "href":"sdo_cs-update_wkts_for_epsg_param.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.42 </span> SDO_CS.UPDATE_WKTS_FOR_EPSG_PM",
                                    "href":"sdo_cs-update_wkts_for_epsg_pm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.43 </span> SDO_CS.VALIDATE_EPSG_MATRIX",
                                    "href":"sdo_cs-validate_epsg_matrix.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.44 </span> SDO_CS.VALIDATE_WKT",
                                    "href":"sdo_cs-validate_wkt.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">23 </span> SDO_CSW Package (Catalog Services for the Web)",
                            "href":"sdo_csw-package-catalog-services-web.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">23.1 </span> SDO_CSW.CREATE_SPATIAL_IDX",
                                    "href":"sdo_csw-create_spatial_idx.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">23.2 </span> SDO_CSW.CREATE_XQFT_IDX",
                                    "href":"sdo_csw-create_xqft_idx.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">23.3 </span> SDO_CSW.INITIALIZE_CSW",
                                    "href":"sdo_csw-initialize_csw.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">23.4 </span> SDO_CSW.SYNC_INDEX",
                                    "href":"sdo_csw-sync_index.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">24 </span> SDO_GCDR Package (Geocoding)",
                            "href":"sdo_gcdr-package-geocoding.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">24.1 </span> SDO_GCDR.CREATE_PROFILE_TABLES",
                                    "href":"sdo_gcdr-create_profile_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.2 </span> SDO_GCDR.ELOC_DRIVE_DISTANCE_POLYGON",
                                    "href":"sdo_gcdr-eloc_drive_distance_polygon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.3 </span> SDO_GCDR.ELOC_DRIVE_TIME_POLYGON",
                                    "href":"sdo_gcdr-eloc_drive_time_polygon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.4 </span> SDO_GCDR.ELOC_GEOCODE",
                                    "href":"sdo_gcdr-eloc_geocode.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.5 </span> SDO_GCDR.ELOC_GEOCODE_AS_GEOM",
                                    "href":"sdo_gcdr-eloc_geocode_as_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.6 </span> SDO_GCDR.ELOC_GRANT_ACCESS",
                                    "href":"sdo_gcdr-eloc_grant_access.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.7 </span> SDO_GCDR.ELOC_REVOKE_ACCESS",
                                    "href":"sdo_gcdr-eloc_revoke_access.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.8 </span> SDO_GCDR.ELOC_ROUTE",
                                    "href":"sdo_gcdr-eloc_route.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.9 </span> SDO_GCDR.ELOC_ROUTE_DISTANCE",
                                    "href":"sdo_gcdr-eloc_route_distance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.10 </span> SDO_GCDR.ELOC_ROUTE_GEOM",
                                    "href":"sdo_gcdr-eloc_route_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.11 </span> SDO_GCDR.ELOC_ROUTE_TIME",
                                    "href":"sdo_gcdr-eloc_route_time.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.12 </span> SDO_GCDR.GEOCODE",
                                    "href":"sdo_gcdr-geocode.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.13 </span> SDO_GCDR.GEOCODE_ADDR",
                                    "href":"sdo_gcdr-geocode_addr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.14 </span> SDO_GCDR.GEOCODE_ADDR_ALL",
                                    "href":"sdo_gcdr-geocode_addr_all.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.15 </span> SDO_GCDR.GEOCODE_ALL",
                                    "href":"sdo_gcdr-geocode_all.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.16 </span> SDO_GCDR.GEOCODE_AS_GEOMETRY",
                                    "href":"sdo_gcdr-geocode_as_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.17 </span> SDO_GCDR.REVERSE_GEOCODE",
                                    "href":"sdo_gcdr-reverse_geocode.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">25 </span> SDO_GEOM Package (Geometry)",
                            "href":"sdo_geom-package-geometry.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">25.1 </span> SDO_GEOM.DTW_DISTANCE",
                                    "href":"sdo_geom-dtw_distance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.2 </span> SDO_GEOM.RELATE",
                                    "href":"sdo_geom-relate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.3 </span> SDO_GEOM.SDO_ALPHA_SHAPE",
                                    "href":"sdo_geom-sdo_alpha_shape.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.4 </span> SDO_GEOM.SDO_ARC_DENSIFY",
                                    "href":"sdo_geom-sdo_arc_densify.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.5 </span> SDO_GEOM.SDO_AREA",
                                    "href":"sdo_geom-sdo_area.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.6 </span> SDO_GEOM.SDO_BUFFER",
                                    "href":"sdo_geom-sdo_buffer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.7 </span> SDO_GEOM.SDO_CENTROID",
                                    "href":"sdo_geom-sdo_centroid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.8 </span> SDO_GEOM.SDO_CLOSEST_POINTS",
                                    "href":"sdo_geom-sdo_closest_points.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.9 </span> SDO_GEOM.SDO_CONCAVEHULL",
                                    "href":"sdo_geom-sdo_concavehull.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.10 </span> SDO_GEOM.SDO_CONCAVEHULL_BOUNDARY",
                                    "href":"sdo_geom-sdo_concavehull_boundary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.11 </span> SDO_GEOM.SDO_CONVEXHULL",
                                    "href":"sdo_geom-sdo_convexhull.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.12 </span> SDO_GEOM.SDO_DIAMETER",
                                    "href":"sdo_geom-sdo_diameter.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.13 </span> SDO_GEOM.SDO_DIAMETER_LINE",
                                    "href":"sdo_geom-sdo_diameter_line.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.14 </span> SDO_GEOM.SDO_DIFFERENCE",
                                    "href":"sdo_geom-sdo_difference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.15 </span> SDO_GEOM.SDO_DISTANCE",
                                    "href":"sdo_geom-sdo_distance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.16 </span> SDO_GEOM.SDO_INTERSECTION",
                                    "href":"sdo_geom-sdo_intersection.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.17 </span> SDO_GEOM.SDO_LENGTH",
                                    "href":"sdo_geom-sdo_length.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.18 </span> SDO_GEOM.SDO_MAX_MBR_ORDINATE",
                                    "href":"sdo_geom-sdo_max_mbr_ordinate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.19 </span> SDO_GEOM.SDO_MAXDISTANCE",
                                    "href":"sdo_geom-sdo_maxdistance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.20 </span> SDO_GEOM.SDO_MAXDISTANCE_LINE",
                                    "href":"sdo_geom-sdo_maxdistance_line.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.21 </span> SDO_GEOM.SDO_MBC",
                                    "href":"sdo_geom-sdo_mbc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.22 </span> SDO_GEOM.SDO_MBC_CENTER",
                                    "href":"sdo_geom-sdo_mbc_center.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.23 </span> SDO_GEOM.SDO_MBC_RADIUS",
                                    "href":"sdo_geom-sdo_mbc_radius.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.24 </span> SDO_GEOM.SDO_MBR",
                                    "href":"sdo_geom-sdo_mbr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.25 </span> SDO_GEOM.SDO_MIN_MBR_ORDINATE",
                                    "href":"sdo_geom-sdo_min_mbr_ordinate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.26 </span> SDO_GEOM.SDO_POINTONSURFACE",
                                    "href":"sdo_geom-sdo_pointonsurface.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.27 </span> SDO_GEOM.SDO_SELF_UNION",
                                    "href":"sdo_geom-sdo_self_union.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.28 </span> SDO_GEOM.SDO_TRIANGULATE",
                                    "href":"sdo_geom-sdo_triangulate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.29 </span> SDO_GEOM.SDO_UNION",
                                    "href":"sdo_geom-sdo_union.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.30 </span> SDO_GEOM.SDO_VOLUME",
                                    "href":"sdo_geom-sdo_volume.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.31 </span> SDO_GEOM.SDO_WIDTH",
                                    "href":"sdo_geom-sdo_width.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.32 </span> SDO_GEOM.SDO_WIDTH_LINE",
                                    "href":"sdo_geom-sdo_width_line.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.33 </span> SDO_GEOM.SDO_XOR",
                                    "href":"sdo_geom-sdo_xor.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.34 </span> SDO_GEOM.VALIDATE_GEOMETRY_WITH_CONTEXT",
                                    "href":"sdo_geom-validate_geometry_with_context.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.35 </span> SDO_GEOM.VALIDATE_LAYER_WITH_CONTEXT",
                                    "href":"sdo_geom-validate_layer_with_context.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.36 </span> SDO_GEOM.WITHIN_DISTANCE",
                                    "href":"sdo_geom-within_distance.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">26 </span> SDO_LRS Package (Linear Referencing System)",
                            "href":"sdo_lrs-package-linear-referencing-system.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">26.1 </span> SDO_LRS.CLIP_GEOM_SEGMENT",
                                    "href":"sdo_lrs-clip_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.2 </span> SDO_LRS.CONCATENATE_GEOM_SEGMENTS",
                                    "href":"sdo_lrs-concatenate_geom_segments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.3 </span> SDO_LRS.CONNECTED_GEOM_SEGMENTS",
                                    "href":"sdo_lrs-connected_geom_segments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.4 </span> SDO_LRS.CONVERT_TO_LRS_DIM_ARRAY",
                                    "href":"sdo_lrs-convert_to_lrs_dim_array.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.5 </span> SDO_LRS.CONVERT_TO_LRS_GEOM",
                                    "href":"sdo_lrs-convert_to_lrs_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.6 </span> SDO_LRS.CONVERT_TO_LRS_LAYER",
                                    "href":"sdo_lrs-convert_to_lrs_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.7 </span> SDO_LRS.CONVERT_TO_STD_DIM_ARRAY",
                                    "href":"sdo_lrs-convert_to_std_dim_array.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.8 </span> SDO_LRS.CONVERT_TO_STD_GEOM",
                                    "href":"sdo_lrs-convert_to_std_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.9 </span> SDO_LRS.CONVERT_TO_STD_LAYER",
                                    "href":"sdo_lrs-convert_to_std_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.10 </span> SDO_LRS.DEFINE_GEOM_SEGMENT",
                                    "href":"sdo_lrs-define_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.11 </span> SDO_LRS.DYNAMIC_SEGMENT",
                                    "href":"sdo_lrs-dynamic_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.12 </span> SDO_LRS.FIND_LRS_DIM_POS",
                                    "href":"sdo_lrs-find_lrs_dim_pos.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.13 </span> SDO_LRS.FIND_MEASURE",
                                    "href":"sdo_lrs-find_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.14 </span> SDO_LRS.FIND_OFFSET",
                                    "href":"sdo_lrs-find_offset.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.15 </span> SDO_LRS.GEOM_SEGMENT_END_MEASURE",
                                    "href":"sdo_lrs-geom_segment_end_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.16 </span> SDO_LRS.GEOM_SEGMENT_END_PT",
                                    "href":"sdo_lrs-geom_segment_end_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.17 </span> SDO_LRS.GEOM_SEGMENT_LENGTH",
                                    "href":"sdo_lrs-geom_segment_length.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.18 </span> SDO_LRS.GEOM_SEGMENT_START_MEASURE",
                                    "href":"sdo_lrs-geom_segment_start_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.19 </span> SDO_LRS.GEOM_SEGMENT_START_PT",
                                    "href":"sdo_lrs-geom_segment_start_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.20 </span> SDO_LRS.GET_MEASURE",
                                    "href":"sdo_lrs-get_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.21 </span> SDO_LRS.GET_NEXT_SHAPE_PT",
                                    "href":"sdo_lrs-get_next_shape_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.22 </span> SDO_LRS.GET_NEXT_SHAPE_PT_MEASURE",
                                    "href":"sdo_lrs-get_next_shape_pt_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.23 </span> SDO_LRS.GET_PREV_SHAPE_PT",
                                    "href":"sdo_lrs-get_prev_shape_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.24 </span> SDO_LRS.GET_PREV_SHAPE_PT_MEASURE",
                                    "href":"sdo_lrs-get_prev_shape_pt_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.25 </span> SDO_LRS.IS_GEOM_SEGMENT_DEFINED",
                                    "href":"sdo_lrs-is_geom_segment_defined.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.26 </span> SDO_LRS.IS_MEASURE_DECREASING",
                                    "href":"sdo_lrs-is_measure_decreasing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.27 </span> SDO_LRS.IS_MEASURE_INCREASING",
                                    "href":"sdo_lrs-is_measure_increasing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.28 </span> SDO_LRS.IS_SHAPE_PT_MEASURE",
                                    "href":"sdo_lrs-is_shape_pt_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.29 </span> SDO_LRS.LOCATE_PT",
                                    "href":"sdo_lrs-locate_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.30 </span> SDO_LRS.LRS_INTERSECTION",
                                    "href":"sdo_lrs-lrs_intersection.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.31 </span> SDO_LRS.MEASURE_RANGE",
                                    "href":"sdo_lrs-measure_range.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.32 </span> SDO_LRS.MEASURE_TO_PERCENTAGE",
                                    "href":"sdo_lrs-measure_to_percentage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.33 </span> SDO_LRS.OFFSET_GEOM_SEGMENT",
                                    "href":"sdo_lrs-offset_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.34 </span> SDO_LRS.PERCENTAGE_TO_MEASURE",
                                    "href":"sdo_lrs-percentage_to_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.35 </span> SDO_LRS.PROJECT_PT",
                                    "href":"sdo_lrs-project_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.36 </span> SDO_LRS.REDEFINE_GEOM_SEGMENT",
                                    "href":"sdo_lrs-redefine_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.37 </span> SDO_LRS.RESET_MEASURE",
                                    "href":"sdo_lrs-reset_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.38 </span> SDO_LRS.REVERSE_GEOMETRY",
                                    "href":"sdo_lrs-reverse_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.39 </span> SDO_LRS.REVERSE_MEASURE",
                                    "href":"sdo_lrs-reverse_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.40 </span> SDO_LRS.SCALE_GEOM_SEGMENT",
                                    "href":"sdo_lrs-scale_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.41 </span> SDO_LRS.SET_PT_MEASURE",
                                    "href":"sdo_lrs-set_pt_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.42 </span> SDO_LRS.SPLIT_GEOM_SEGMENT",
                                    "href":"sdo_lrs-split_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.43 </span> SDO_LRS.TRANSLATE_MEASURE",
                                    "href":"sdo_lrs-translate_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.44 </span> SDO_LRS.VALID_GEOM_SEGMENT",
                                    "href":"sdo_lrs-valid_geom_segment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.45 </span> SDO_LRS.VALID_LRS_PT",
                                    "href":"sdo_lrs-valid_lrs_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.46 </span> SDO_LRS.VALID_MEASURE",
                                    "href":"sdo_lrs-valid_measure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">26.47 </span> SDO_LRS.VALIDATE_LRS_GEOMETRY",
                                    "href":"sdo_lrs-validate_lrs_geometry.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">27 </span> SDO_MIGRATE Package (Upgrading)",
                            "href":"sdo_migrate-package-upgrading.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">27.1 </span> SDO_MIGRATE.TO_CURRENT",
                                    "href":"sdo_migrate-to_current.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">28 </span> SDO_OLS Package (OpenLS)",
                            "href":"sdo_ols-package-openls.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">28.1 </span> SDO_OLS.MakeOpenLSClobRequest",
                                    "href":"sdo_ols-makeopenlsclobrequest.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">28.2 </span> SDO_OLS.MakeOpenLSRequest",
                                    "href":"sdo_ols-makeopenlsrequest.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29 </span> SDO_PC_PKG Package (Point Clouds)",
                            "href":"SDO_PC_PKG-reference.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.1 </span> SDO_PC_PKG.CLIP_PC",
                                    "href":"sdo_pc_pkg-clip_pc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.2 </span> SDO_PC_PKG.CLIP_PC_FLAT",
                                    "href":"sdo_pc_pkg-clip_pc_flat.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3 </span> SDO_PC_PKG.CLIP_PC_FLAT_STRING",
                                    "href":"sdo_pc_pkg-clip_pc_flat_string.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4 </span> SDO_PC_PKG.CLIP_PC_INTO_TABLE",
                                    "href":"sdo_pc_pkg-clip_pc_into_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.5 </span> SDO_PC_PKG.CREATE_CONTOUR_GEOMETRIES",
                                    "href":"sdo_pc_pkg-create_contour_geometries.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.6 </span> SDO_PC_PKG.CREATE_PC",
                                    "href":"sdo_pc_pkg-create_pc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.7 </span> SDO_PC_PKG.CREATE_PC_UNIFIED",
                                    "href":"sdo_pc_pkg-create_pc_unified.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.8 </span> SDO_PC_PKG.DROP_DEPENDENCIES",
                                    "href":"sdo_pc_pkg-drop_dependencies.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.9 </span> SDO_PC_PKG.GENERATE_CROSS_SECTION_AS_GEOMS",
                                    "href":"sdo_pc_pkg-generate_cross_section_as_geoms.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.10 </span> SDO_PC_PKG.GET_PT_IDS",
                                    "href":"sdo_pc_pkg-get_pt_ids.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.11 </span> SDO_PC_PKG.HAS_PYRAMID",
                                    "href":"sdo_pc_pkg-has_pyramid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.12 </span> SDO_PC_PKG.INIT",
                                    "href":"sdo_pc_pkg-init.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.13 </span> SDO_PC_PKG.PC_DIFFERENCE",
                                    "href":"sdo_pc_pkg-pc_difference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.14 </span> SDO_PC_PKG.PC2DEM",
                                    "href":"sdo_pc_pkg-pc2dem.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.15 </span> SDO_PC_PKG.PRESERVES_LEVEL1",
                                    "href":"sdo_pc_pkg-preserves_level1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.16 </span> SDO_PC_PKG.SDO_PC_NN",
                                    "href":"sdo_pc_pkg-sdo_pc_nn.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.17 </span> SDO_PC_PKG.SDO_PC_NN_FOR_EACH",
                                    "href":"sdo_pc_pkg-sdo_pc_nn_for_each.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.18 </span> SDO_PC_PKG.TO_GEOMETRY",
                                    "href":"sdo_pc_pkg-to_geometry.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">30 </span> SDO_SAM Package (Spatial Analysis and Mining)",
                            "href":"sdo_sam-package-spatial-analysis-and-mining.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">30.1 </span> SDO_SAM.AGGREGATES_FOR_GEOMETRY",
                                    "href":"sdo_sam-aggregates_for_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.2 </span> SDO_SAM.AGGREGATES_FOR_LAYER",
                                    "href":"sdo_sam-aggregates_for_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.3 </span> SDO_SAM.BIN_GEOMETRY",
                                    "href":"sdo_sam-bin_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.4 </span> SDO_SAM.BIN_LAYER",
                                    "href":"sdo_sam-bin_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.5 </span> SDO_SAM.COLOCATED_REFERENCE_FEATURES",
                                    "href":"sdo_sam-colocated_reference_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.6 </span> SDO_SAM.SIMPLIFY_GEOMETRY",
                                    "href":"sdo_sam-simplify_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.7 </span> SDO_SAM.SIMPLIFY_LAYER",
                                    "href":"sdo_sam-simplify_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.8 </span> SDO_SAM.SPATIAL_CLUSTERS",
                                    "href":"sdo_sam-spatial_clusters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.9 </span> SDO_SAM.TILED_AGGREGATES",
                                    "href":"sdo_sam-tiled_aggregates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.10 </span> SDO_SAM.TILED_BINS",
                                    "href":"sdo_sam-tiled_bins.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">31 </span> SDO_TIN_PKG Package (TINs)",
                            "href":"SDO_TIN_PKG-reference.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">31.1 </span> SDO_TIN_PKG.CLIP_TIN",
                                    "href":"sdo_tin_pkg-clip_tin.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2 </span> SDO_TIN_PKG.CREATE_MESHES",
                                    "href":"sdo_tin_pkg-create_meshes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.3 </span> SDO_TIN_PKG.CREATE_TIN",
                                    "href":"sdo_tin_pkg-create_tin.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.4 </span> SDO_TIN_PKG.DROP_DEPENDENCIES",
                                    "href":"sdo_tin_pkg-drop_dependencies.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.5 </span> SDO_TIN_PKG.GET_BLOCKING_METHOD",
                                    "href":"sdo_tin_pkg-get_blocking_method.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.6 </span> SDO_TIN_PKG.GET_NUM_POINTS",
                                    "href":"sdo_tin_pkg-get_num_points.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.7 </span> SDO_TIN_PKG.GET_TIN_BLOCK_SORT_ORDER",
                                    "href":"sdo_tin_pkg-get_tin_block_sort_order.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.8 </span> SDO_TIN_PKG.INIT",
                                    "href":"sdo_tin_pkg-init.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.9 </span> SDO_TIN_PKG.LIST_TIN_COLUMNS",
                                    "href":"sdo_tin_pkg-list_tin_columns.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.10 </span> SDO_TIN_PKG.LIST_TINS",
                                    "href":"sdo_tin_pkg-list_tins.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.11 </span> SDO_TIN_PKG.PROJECT_ORDINATES_ONTO_TIN",
                                    "href":"sdo_tin_pkg-project_ordinates_onto_tin.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.12 </span> SDO_TIN_PKG.TO_DEM",
                                    "href":"sdo_tin_pkg-to_dem.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.13 </span> SDO_TIN_PKG.TO_GEOMETRY",
                                    "href":"sdo_tin_pkg-to_geometry.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">32 </span> SDO_TRKR Package (Location Tracking)",
                            "href":"sdo_trkr-package-location-tracking.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">32.1 </span> SDO_TRKR.CREATE_TRACKING_SET",
                                    "href":"sdo_trkr-create_tracking_set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.2 </span> SDO_TRKR.DROP_TRACKING_SET",
                                    "href":"sdo_trkr-drop_tracking_set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.3 </span> SDO_TRKR.GET_NOTIFICATION_MSG",
                                    "href":"sdo_trkr-get_notification_msg.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.4 </span> SDO_TRKR.SEND_LOCATION_MSGS",
                                    "href":"sdo_trkr-send_location_msgs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.5 </span> SDO_TRKR.SEND_TRACKING_MSG",
                                    "href":"sdo_trkr-send_tracking_msg.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.6 </span> SDO_TRKR.START_TRACKING_SET",
                                    "href":"sdo_trkr-start_tracking_set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.7 </span> SDO_TRKR.STOP_TRACKING_SET",
                                    "href":"sdo_trkr-stop_tracking_set.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">33 </span> SDO_TUNE Package (Tuning)",
                            "href":"sdo_tune-package-tuning.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">33.1 </span> SDO_TUNE.AVERAGE_MBR",
                                    "href":"sdo_tune-average_mbr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">33.2 </span> SDO_TUNE.ESTIMATE_RTREE_INDEX_SIZE",
                                    "href":"sdo_tune-estimate_rtree_index_size.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">33.3 </span> SDO_TUNE.EXTENT_OF",
                                    "href":"sdo_tune-extent_of.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">33.4 </span> SDO_TUNE.MIX_INFO",
                                    "href":"sdo_tune-mix_info.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">34 </span> SDO_WCS Package (Web Coverage Service)",
                            "href":"SDO_WCS-reference.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">34.1 </span> SDO_WCS.CreateTempTable",
                                    "href":"sdo_wcs-createtemptable.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.2 </span> SDO_WCS.DropTempTable",
                                    "href":"sdo_wcs-droptemptable.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.3 </span> SDO_WCS.GrantPrivilegesToWCS",
                                    "href":"sdo_wcs-grantprivilegestowcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.4 </span> SDO_WCS.Init",
                                    "href":"sdo_wcs-init.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.5 </span> SDO_WCS.PublishCoverage",
                                    "href":"sdo_wcs-publishcoverage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.6 </span> SDO_WCS.RevokePrivilegesFromWCS",
                                    "href":"sdo_wcs-revokeprivilegesfromwcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.7 </span> SDO_WCS.UnpublishCoverage",
                                    "href":"sdo_wcs-unpublishcoverage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">34.8 </span> SDO_WCS.ValidateCoverages",
                                    "href":"sdo_wcs-validatecoverages.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">35 </span> SDO_UTIL Package (Utility)",
                            "href":"SDO_UTIL-package-utility.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">35.1 </span> SDO_UTIL.AFFINETRANSFORMS",
                                    "href":"sdo_util-affinetransforms.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.2 </span> SDO_UTIL.APPEND",
                                    "href":"sdo_util-append.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.3 </span> SDO_UTIL.BEARING_TILT_FOR_POINTS",
                                    "href":"sdo_util-bearing_tilt_for_points.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.4 </span> SDO_UTIL.CIRCLE_POLYGON",
                                    "href":"sdo_util-circle_polygon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.5 </span> SDO_UTIL.CONCAT_LINES",
                                    "href":"sdo_util-concat_lines.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.6 </span> SDO_UTIL.CONVERT_UNIT",
                                    "href":"sdo_util-convert_unit.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.7 </span> SDO_UTIL.CONVERT3007TO3008",
                                    "href":"sdo_util-convert3007to3008.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.8 </span> SDO_UTIL.DELETE_SDO_GEOM_METADATA",
                                    "href":"sdo_util-delete_sdo_geom_metadata.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.9 </span> SDO_UTIL.DENSIFY_GEOMETRY",
                                    "href":"sdo_util-densify_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.10 </span> SDO_UTIL.DISABLE_VECTORTILE_CACHE",
                                    "href":"sdo_util-disable_vectortile_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.11 </span> SDO_UTIL.DROP_WORK_TABLES",
                                    "href":"sdo_util-drop_work_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.12 </span> SDO_UTIL.ELLIPSE_POLYGON",
                                    "href":"sdo_util-ellipse_polygon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.13 </span> SDO_UTIL.ENABLE_VECTORTILE_CACHE",
                                    "href":"sdo_util-enable_vectortile_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.14 </span> SDO_UTIL.EXPAND_GEOM",
                                    "href":"sdo_util-expand_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.15 </span> SDO_UTIL.EXTRACT",
                                    "href":"sdo_util-extract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.16 </span> SDO_UTIL.EXTRACT_ALL",
                                    "href":"sdo_util-extract_all.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.17 </span> SDO_UTIL.EXTRACT3D",
                                    "href":"sdo_util-extract3d.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.18 </span> SDO_UTIL.EXTRUDE",
                                    "href":"sdo_util-extrude.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.19 </span> SDO_UTIL.FROM_GEOJSON",
                                    "href":"sdo_util-from_geojson.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.20 </span> SDO_UTIL.FROM_GML311GEOMETRY",
                                    "href":"sdo_util-from_gml311geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.21 </span> SDO_UTIL.FROM_GMLGEOMETRY",
                                    "href":"sdo_util-from_gmlgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.22 </span> SDO_UTIL.FROM_JSON",
                                    "href":"sdo_util-from_json.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.23 </span> SDO_UTIL.FROM_KMLGEOMETRY",
                                    "href":"sdo_util-from_kmlgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.24 </span> SDO_UTIL.FROM_WKBGEOMETRY",
                                    "href":"sdo_util-from_wkbgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.25 </span> SDO_UTIL.FROM_WKTGEOMETRY",
                                    "href":"sdo_util-from_wktgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.26 </span> SDO_UTIL.GEO_SEARCH",
                                    "href":"sdo_util-geo_search.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.27 </span> SDO_UTIL.GET_2D_FOOTPRINT",
                                    "href":"sdo_util-get_2d_footprint.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.28 </span> SDO_UTIL.GET_COORDINATE",
                                    "href":"sdo_util-get_coordinate.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.29 </span> SDO_UTIL.GET_TILE_ENVELOPE",
                                    "href":"sdo_util-get_tile_envelope.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.30 </span> SDO_UTIL.GET_VECTORTILE",
                                    "href":"sdo_util-get_vectortile.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.31 </span> SDO_UTIL.GETFIRSTVERTEX",
                                    "href":"sdo_util-getfirstvertex.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.32 </span> SDO_UTIL.GETLASTVERTEX",
                                    "href":"sdo_util-getlastvertex.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.33 </span> SDO_UTIL.GETNUMELEM",
                                    "href":"sdo_util-getnumelem.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.34 </span> SDO_UTIL.GETNUMVERTICES",
                                    "href":"sdo_util-getnumvertices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.35 </span> SDO_UTIL.GETNURBSAPPROX",
                                    "href":"sdo_util-getnurbsapprox.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.36 </span> SDO_UTIL.GETVERTICES",
                                    "href":"sdo_util-getvertices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.37 </span> SDO_UTIL.GRANT_VECTORTILE_CACHE",
                                    "href":"sdo_util-grant_vectortile_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.38 </span> SDO_UTIL.H3_BASE_CELL",
                                    "href":"sdo_util-h3_base_cell.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.39 </span> SDO_UTIL.H3_BOUNDARY",
                                    "href":"sdo_util-h3_boundary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.40 </span> SDO_UTIL.H3_CENTER",
                                    "href":"sdo_util-h3_center.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.41 </span> SDO_UTIL.H3_HEX_AREA",
                                    "href":"sdo_util-h3_hex_area.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.42 </span> SDO_UTIL.H3_HEX_EDGELEN",
                                    "href":"sdo_util-h3_hex_edgelen.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.43 </span> SDO_UTIL.H3_NUM_CELLS",
                                    "href":"sdo_util-h3_hex_num_cells.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.44 </span> SDO_UTIL.H3_IS_CLASS3",
                                    "href":"sdo_util-h3_is_class3.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.45 </span> SDO_UTIL.H3_IS_PENTAGON",
                                    "href":"sdo_util-h3_is_pentagon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.46 </span> SDO_UTIL.H3_IS_VALID_CELL",
                                    "href":"sdo_util-h3_is_valid_cell.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.47 </span> SDO_UTIL.H3_KEY",
                                    "href":"sdo_util-h3_key.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.48 </span> SDO_UTIL.H3_MBR",
                                    "href":"sdo_util-h3_mbr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.49 </span> SDO_UTIL.H3_PARENT",
                                    "href":"sdo_util-h3_parent.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.50 </span> SDO_UTIL.H3_PENTAGON_AREA",
                                    "href":"sdo_util-h3_pentagon_area.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.51 </span> SDO_UTIL.H3_PENTAGON_EDGELEN",
                                    "href":"sdo_util-h3_pentagon_edgelen.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.52 </span> SDO_UTIL.H3_RESOLUTION",
                                    "href":"sdo_util-h3_resolution.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.53 </span> SDO_UTIL.H3SUM_AS_TABLE",
                                    "href":"sdo_util-h3sum_as_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.54 </span> SDO_UTIL.H3SUM_CREATE_TABLE",
                                    "href":"sdo_util-h3sum_create_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.55 </span> SDO_UTIL.H3SUM_ESTIMATE_RESOLUTION",
                                    "href":"sdo_util-h3sum_estimate_resolution.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.56 </span> SDO_UTIL.H3SUM_GET_CURSOR",
                                    "href":"sdo_util-h3sum_get_cursor.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.57 </span> SDO_UTIL.H3SUM_LIST_TABLES",
                                    "href":"sdo_util-h3sum_list_tables.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.58 </span> SDO_UTIL.H3SUM_VECTORTILE",
                                    "href":"sdo_util-h3sum_vectortile.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.59 </span> SDO_UTIL.INITIALIZE_INDEXES_FOR_TTS",
                                    "href":"sdo_util-initialize_indexes_for_tts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.60 </span> SDO_UTIL.INSERT_SDO_GEOM_METADATA",
                                    "href":"sdo_util-insert_sdo_geom_metadata.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.61 </span> SDO_UTIL.INTERIOR_POINT",
                                    "href":"sdo_util-interior_point.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.62 </span> SDO_UTIL.LINEAR_KEY",
                                    "href":"sdo_util-linear_key.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.63 </span> SDO_UTIL.LINEAR_KEY_BOUNDARY",
                                    "href":"sdo_util-linear_key_boundary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.64 </span> SDO_UTIL.POINT_AT_BEARING",
                                    "href":"sdo_util-point_at_bearing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.65 </span> SDO_UTIL.POLYGONTOLINE",
                                    "href":"sdo_util-polygontoline.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.66 </span> SDO_UTIL.PURGE_VECTORTILE_CACHE",
                                    "href":"sdo_util-purge_vectortile_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.67 </span> SDO_UTIL.RECTIFY_GEOMETRY",
                                    "href":"sdo_util-rectify_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.68 </span> SDO_UTIL.REMOVE_DUPLICATE_VERTICES",
                                    "href":"sdo_util-remove_duplicate_vertices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.69 </span> SDO_UTIL.REVERSE_LINESTRING",
                                    "href":"sdo_util-reverse_linestring.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.70 </span> SDO_UTIL.REVOKE_VECTORTILE_CACHE",
                                    "href":"sdo_util-revoke_vectortile_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.71 </span> SDO_UTIL.SIMPLIFY",
                                    "href":"sdo_util-simplify.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.72 </span> SDO_UTIL.SIMPLIFYVW",
                                    "href":"sdo_util-simplifyvw.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.73 </span> SDO_UTIL.THEME3D_GET_BLOCK_TABLE",
                                    "href":"sdo_util-theme3d_get_block_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.74 </span> SDO_UTIL.THEME3D_HAS_LOD",
                                    "href":"sdo_util-theme3d_has_lod.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.75 </span> SDO_UTIL.THEME3D_HAS_TEXTURE",
                                    "href":"sdo_util-theme3d_has_texture.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.76 </span> SDO_UTIL.TILE_GEOMETRY",
                                    "href":"sdo_util-tile_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.77 </span> SDO_UTIL.TO_GEOJSON",
                                    "href":"sdo_util-to_geojson.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.78 </span> SDO_UTIL.TO_GEOJSON_JSON",
                                    "href":"sdo_util-to_geojson_json.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.79 </span> SDO_UTIL.TO_GML311GEOMETRY",
                                    "href":"sdo_util-to_gml311geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.80 </span> SDO_UTIL.TO_GMLGEOMETRY",
                                    "href":"sdo_util-to_gmlgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.81 </span> SDO_UTIL.TO_JSON",
                                    "href":"sdo_util-to_json.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.82 </span> SDO_UTIL.TO_JSON_JSON",
                                    "href":"sdo_util-to_json_json.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.83 </span> SDO_UTIL.TO_JSON_VARCHAR",
                                    "href":"sdo_util-to_json_varchar.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.84 </span> SDO_UTIL.TO_KMLGEOMETRY",
                                    "href":"sdo_util-to_kmlgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.85 </span> SDO_UTIL.TO_WKBGEOMETRY",
                                    "href":"sdo_util-to_wkbgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.86 </span> SDO_UTIL.TO_WKTGEOMETRY",
                                    "href":"sdo_util-to_wktgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.87 </span> SDO_UTIL.VALIDATE_3DTHEME",
                                    "href":"sdo_util-validate_3dtheme.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.88 </span> SDO_UTIL.VALIDATE_SCENE",
                                    "href":"sdo_util-validate_scene.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.89 </span> SDO_UTIL.VALIDATE_VIEWFRAME",
                                    "href":"sdo_util-validate_viewframe.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.90 </span> SDO_UTIL.VALIDATE_WKBGEOMETRY",
                                    "href":"sdo_util-validate_wkbgeometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">35.91 </span> SDO_UTIL.VALIDATE_WKTGEOMETRY",
                                    "href":"sdo_util-validate_wktgeometry.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">36 </span> SDO_WFS_LOCK Package (WFS)",
                            "href":"sdo_wfs_lock-package-wfs.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">36.1 </span> SDO_WFS_LOCK.EnableDBTxns",
                                    "href":"sdo_wfs_lock-enabledbtxns.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">36.2 </span> SDO_WFS_LOCK.RegisterFeatureTable",
                                    "href":"sdo_wfs_lock-registerfeaturetable.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">36.3 </span> SDO_WFS_LOCK.UnRegisterFeatureTable",
                                    "href":"sdo_wfs_lock-unregisterfeaturetable.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">37 </span> SDO_WFS_PROCESS Package (WFS Processing)",
                            "href":"sdo_wfs_process-package-wfs-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">37.1 </span> SDO_WFS_PROCESS.DropFeatureType",
                                    "href":"sdo_wfs_process-dropfeaturetype.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.2 </span> SDO_WFS_PROCESS.DropFeatureTypes",
                                    "href":"sdo_wfs_process-dropfeaturetypes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.3 </span> SDO_WFS_PROCESS.GenCollectionProcs",
                                    "href":"sdo_wfs_process-gencollectionprocs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.4 </span> SDO_WFS_PROCESS.GetFeatureTypeId",
                                    "href":"sdo_wfs_process-getfeaturetypeid.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.5 </span> SDO_WFS_PROCESS.GrantFeatureTypeToUser",
                                    "href":"sdo_wfs_process-grantfeaturetypetouser.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.6 </span> SDO_WFS_PROCESS.GrantMDAccessToUser",
                                    "href":"sdo_wfs_process-grantmdaccesstouser.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.7 </span> SDO_WFS_PROCESS.InsertCapabilitiesInfo",
                                    "href":"sdo_wfs_process-insertcapabilitiesinfo.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.8 </span> SDO_WFS_PROCESS.InsertFtDataUpdated",
                                    "href":"sdo_wfs_process-insertftdataupdated.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.9 </span> SDO_WFS_PROCESS.InsertFtMDUpdated",
                                    "href":"sdo_wfs_process-insertftmdupdated.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.10 </span> SDO_WFS_PROCESS.PopulateFeatureTypeXMLInfo",
                                    "href":"sdo_wfs_process-populatefeaturetypexmlinfo.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.11 </span> SDO_WFS_PROCESS.PublishFeatureType",
                                    "href":"sdo_wfs_process-publishfeaturetype.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.12 </span> SDO_WFS_PROCESS.Publish_FeatureTypes_In_Schema",
                                    "href":"sdo_wfs_process-publish_featuretypes_in_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.13 </span> SDO_WFS_PROCESS.RegisterMTableView",
                                    "href":"sdo_wfs_process-registermtableview.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.14 </span> SDO_WFS_PROCESS.RevokeFeatureTypeFromUser",
                                    "href":"sdo_wfs_process-revokefeaturetypefromuser.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.15 </span> SDO_WFS_PROCESS.RevokeMDAccessFromUser",
                                    "href":"sdo_wfs_process-revokemdaccessfromuser.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">37.16 </span> SDO_WFS_PROCESS.UnRegisterMTableView",
                                    "href":"sdo_wfs_process-unregistermtableview.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Supplementary Information",
                    "href":"supplementary-information.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A </span> Installation, Migration, Compatibility, and Upgrade",
                            "href":"spatial-install-migrate-upgrade.html#GUID-EB48F5B9-5790-4242-8665-D9CBE01775CC"
                        },
                        {
                            "title":"<span class=\"secnum\">B </span> Complex Spatial Queries: Examples",
                            "href":"complex-spatial-queries.html#GUID-66516CA7-D36C-4A73-90FC-28C650DDDF68"
                        },
                        {
                            "title":"<span class=\"secnum\">C </span> Loading ESRI Shapefiles into Spatial",
                            "href":"esri-shapefiles.html#GUID-0FEDEB4E-5039-490A-83AB-1E226512A0A0"
                        },
                        {
                            "title":"<span class=\"secnum\">D </span> Routing Engine Administration",
                            "href":"routing-engine-administration.html#GUID-ED1682F6-EEC2-4080-A29A-269CD89DEB4F"
                        }
                    ]
                },
                {
                    "title":"Glossary",
                    "href":"spatial-glossary.html#GUID-3740B39A-6588-449B-82F5-62C0D8803DDB"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});