define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"Preface.html#GUID-0897B474-6033-4398-AA8A-922F1C5CAF53"
                },
                {
                    "title":"Changes in This Release for Oracle Database SQL Language Reference",
                    "href":"Changes-in-This-Release-for-Oracle-Database-SQL-Language-Reference.html#GUID-0B18172E-8876-40D0-84DE-53C2CE6436BD"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Oracle SQL",
                    "href":"Introduction-to-Oracle-SQL.html#GUID-049B7AE8-11E1-4110-B3E4-D117907D77AC",
                    "topics":[
                        {
                            "title":"History of SQL",
                            "href":"History-of-SQL.html#GUID-4DD5E1B6-BEC7-4E9B-B369-1466F93ACA28"
                        },
                        {
                            "title":"SQL Standards",
                            "href":"SQL-Standards.html#GUID-BCCCFF75-D2A4-43AD-8CAF-C3C97D92AC63"
                        },
                        {
                            "title":"Using Enterprise Manager",
                            "href":"Using-Enterprise-Manager.html#GUID-ABEC85E5-1C69-40EE-BAE5-B693C1F2131C"
                        },
                        {
                            "title":"Lexical Conventions",
                            "href":"Lexical-Conventions.html#GUID-D9AEB31A-8584-4066-85D0-AF6EFA609381"
                        },
                        {
                            "title":"Tools Support",
                            "href":"Tools-Support.html#GUID-F54D11BA-BAAE-4285-94F8-6D706A2D936B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Basic Elements of Oracle SQL",
                    "href":"Basic-Elements-of-Oracle-SQL.html#GUID-41D065C3-3449-4DAE-B2D8-4DF256FFC88A",
                    "topics":[
                        {
                            "title":"Data Types",
                            "href":"Data-Types.html#GUID-A3C0D836-BADB-44E5-A5D4-265BA5968483"
                        },
                        {
                            "title":"Data Type Comparison Rules",
                            "href":"Data-Type-Comparison-Rules.html#GUID-1563C817-86BF-430B-99AB-322EE2E29187"
                        },
                        {
                            "title":"Literals",
                            "href":"Literals.html#GUID-192417E8-A79D-4A1D-9879-68272D925707"
                        },
                        {
                            "title":"Format Models",
                            "href":"Format-Models.html#GUID-DFB23985-2943-4C6A-96DF-DF0F664CED96"
                        },
                        {
                            "title":"Nulls",
                            "href":"Nulls.html#GUID-B0BA4751-9D88-426A-84AD-BCDBD5584071"
                        },
                        {
                            "title":"Comments",
                            "href":"Comments.html#GUID-79B6B8FD-2DD4-471E-B9E0-0C8D20B058F6"
                        },
                        {
                            "title":"Database Objects",
                            "href":"Database-Objects.html#GUID-31BE00A7-7FF9-41CB-852A-F1416912CA9E"
                        },
                        {
                            "title":"Database Object Names and Qualifiers",
                            "href":"Database-Object-Names-and-Qualifiers.html#GUID-3C59E44A-5140-4BCA-B9E1-3039C8050C49"
                        },
                        {
                            "title":"Syntax for Schema Objects and Parts in SQL Statements",
                            "href":"Syntax-for-Schema-Objects-and-Parts-in-SQL-Statements.html#GUID-1164C6E0-ABAB-49C2-8821-6B6C5047FEDD"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Pseudocolumns",
                    "href":"Pseudocolumns.html#GUID-6C65C788-76AA-4A51-B011-51D53DD2521D",
                    "topics":[
                        {
                            "title":"Hierarchical Query Pseudocolumns",
                            "href":"Hierarchical-Query-Pseudocolumns.html#GUID-2F2FBA6F-2FD1-47D6-A74F-DB4B31E4D400"
                        },
                        {
                            "title":"Sequence Pseudocolumns",
                            "href":"Sequence-Pseudocolumns.html#GUID-693B576A-191D-45F5-B7CB-88D0EA821B44"
                        },
                        {
                            "title":"Version Query Pseudocolumns",
                            "href":"Version-Query-Pseudocolumns.html#GUID-F4DB0235-43A9-4AA2-8E9C-F2D9699D4AAD"
                        },
                        {
                            "title":"COLUMN_VALUE Pseudocolumn",
                            "href":"COLUMN_VALUE-Pseudocolumn.html#GUID-66AD602D-7207-4BDF-9CB0-E7418CCC81D3"
                        },
                        {
                            "title":"OBJECT_ID Pseudocolumn",
                            "href":"OBJECT_ID-Pseudocolumn.html#GUID-EA125CCC-B4EE-4065-996E-12A1ADCC5F7F"
                        },
                        {
                            "title":"OBJECT_VALUE Pseudocolumn",
                            "href":"OBJECT_VALUE-Pseudocolumn.html#GUID-456B90CD-30DE-4973-98E0-E4B531938E6E"
                        },
                        {
                            "title":"ORA_ROWSCN Pseudocolumn",
                            "href":"ORA_ROWSCN-Pseudocolumn.html#GUID-8071AAB0-F656-4C93-B926-0BCE1439F121"
                        },
                        {
                            "title":"ORA_SHARDSPACE_NAME Pseudocolumn",
                            "href":"ora_shardspace_name-pseudocolumn.html#GUID-598FDFBE-7544-46B6-B307-DDA4102D3208"
                        },
                        {
                            "title":"ROWID Pseudocolumn",
                            "href":"ROWID-Pseudocolumn.html#GUID-F6E0FBD2-983C-495D-9856-5E113A17FAF1"
                        },
                        {
                            "title":"ROWNUM Pseudocolumn",
                            "href":"ROWNUM-Pseudocolumn.html#GUID-2E40EC12-3FCF-4A4F-B5F2-6BC669021726"
                        },
                        {
                            "title":"XMLDATA Pseudocolumn",
                            "href":"XMLDATA-Pseudocolumn.html#GUID-EBB52EE8-57B4-4DCA-A17E-351DE5CFA934"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Operators",
                    "href":"Operators.html#GUID-874EFABC-F473-44A3-BC93-CDCAC28B131A",
                    "topics":[
                        {
                            "title":"About SQL Operators",
                            "href":"About-SQL-Operators.html#GUID-CF1DBF8D-966F-4E5E-8AC8-9BF777B984D8"
                        },
                        {
                            "title":"Arithmetic Operators",
                            "href":"Arithmetic-Operators.html#GUID-46CD9FD8-FC94-44BA-AA62-30A16063EAAE"
                        },
                        {
                            "title":"COLLATE Operator",
                            "href":"COLLATE-Operator.html#GUID-1B8CE3B0-77FC-455C-8400-6F81CF188D7B"
                        },
                        {
                            "title":"Concatenation Operator",
                            "href":"Concatenation-Operator.html#GUID-08C10738-706B-4290-B7CD-C279EBC90F7E"
                        },
                        {
                            "title":"Hierarchical Query Operators",
                            "href":"Hierarchical-Query-Operators.html#GUID-4CC13EEB-846A-4254-93FC-E91E678BD302"
                        },
                        {
                            "title":"Set Operators",
                            "href":"Set-Operators.html#GUID-5CB549AF-5A4F-453E-B164-49CAC8F94CBF"
                        },
                        {
                            "title":"Multiset Operators",
                            "href":"Multiset-Operators.html#GUID-793FCBB0-A97C-4884-BCAC-DD0542EA746B"
                        },
                        {
                            "title":"SHARD_CHUNK_ID Operator",
                            "href":"shard_chunk_id-operator.html#GUID-FABB2038-EFA8-4A5C-8048-2B3F01D0E6CA"
                        },
                        {
                            "title":"User-Defined Operators",
                            "href":"User-Defined-Operators.html#GUID-6025E56E-8429-42E2-B5A6-6048B5D1AF25"
                        },
                        {
                            "title":"Data Quality Operators",
                            "href":"data-quality-operators.html#GUID-30540D17-AC84-45F5-A511-75D95F7B0229"
                        },
                        {
                            "title":"GRAPH_TABLE Operator",
                            "href":"graph_table-operator.html#GUID-CA6A600E-2087-46F8-A081-C6F3F01CF305",
                            "topics":[
                                {
                                    "title":"Graph Reference",
                                    "href":"graph-reference.html#GUID-873488F0-58D1-4B9D-94B1-F4967B1785DD"
                                },
                                {
                                    "title":"Graph Pattern",
                                    "href":"graph-pattern.html#GUID-1F1E8BC1-CEBB-43A2-B66A-C7D9BB24D88C"
                                },
                                {
                                    "title":"Graph Table Shape",
                                    "href":"graph-table-shape.html#GUID-93202EC2-D2F3-45B0-869D-4C03057EB1A5"
                                },
                                {
                                    "title":"Value Expressions for GRAPH_TABLE",
                                    "href":"value-expressions-graph_table.html#GUID-30B0844D-329B-4A95-BEA1-953AF9F3ED7C"
                                }
                            ]
                        },
                        {
                            "title":"JSON_ID Operator",
                            "href":"json_id-operator.html#GUID-89A6BCC7-B500-429B-8299-A3F78D1D077F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Expressions",
                    "href":"Expressions.html#GUID-E7A5363C-AEE9-4809-99C1-1A9C6E3AE017",
                    "topics":[
                        {
                            "title":"About SQL Expressions",
                            "href":"About-SQL-Expressions.html#GUID-68789A5C-B142-496F-ADEE-837F75F95B2B"
                        },
                        {
                            "title":"Simple Expressions",
                            "href":"Simple-Expressions.html#GUID-0E033897-60FB-40D7-A5F3-498B0FCC31B0"
                        },
                        {
                            "title":"Analytic View Expressions",
                            "href":"analytic-view-measure-expressions.html#GUID-F8C7ED67-A4EC-479C-975F-12F1F4B8CBA0"
                        },
                        {
                            "title":"Compound Expressions",
                            "href":"Compound-Expressions.html#GUID-533C7BA0-C8B4-4323-81EA-1379657AF64A"
                        },
                        {
                            "title":"CASE Expressions",
                            "href":"CASE-Expressions.html#GUID-CA29B333-572B-4E1D-BA64-851FABDBAE96"
                        },
                        {
                            "title":"Column Expressions",
                            "href":"Column-Expressions.html#GUID-B16B2D82-5D4B-485B-AE20-160EC0C7137A"
                        },
                        {
                            "title":"CURSOR Expressions",
                            "href":"CURSOR-Expressions.html#GUID-B28362BE-8831-4687-89CF-9F77DB3698D2"
                        },
                        {
                            "title":"Datetime Expressions",
                            "href":"Datetime-Expressions.html#GUID-F72A753A-98A4-4EBD-84E9-C014CE058384"
                        },
                        {
                            "title":"Function Expressions",
                            "href":"Function-Expressions.html#GUID-C47F0B7D-9058-481F-815E-A31FB21F3BD5"
                        },
                        {
                            "title":"Interval Expressions",
                            "href":"Interval-Expressions.html#GUID-EB9B5B5D-357B-494C-A237-153A2CF8425C"
                        },
                        {
                            "title":"JSON Object Access Expressions",
                            "href":"JSON-Object-Access-Expressions.html#GUID-09D1A154-335D-484E-A7A2-DA1983CD511C"
                        },
                        {
                            "title":"Model Expressions",
                            "href":"Model-Expressions.html#GUID-83D3FD56-8346-4D3F-A49E-5FE41FE19257"
                        },
                        {
                            "title":"Object Access Expressions",
                            "href":"Object-Access-Expressions.html#GUID-FA69A056-12A6-420F-A106-EE252386CC43"
                        },
                        {
                            "title":"Placeholder Expressions",
                            "href":"Placeholder-Expressions.html#GUID-B98B5394-A573-4BF8-9EC3-7B1BB1130553"
                        },
                        {
                            "title":"Scalar Subquery Expressions",
                            "href":"Scalar-Subquery-Expressions.html#GUID-475D80C3-C873-4475-AB1A-8837C5CF8CE4"
                        },
                        {
                            "title":"Type Constructor Expressions",
                            "href":"Type-Constructor-Expressions.html#GUID-E8A491DE-18BA-4A1E-8CE2-BBA43E5C52D6"
                        },
                        {
                            "title":"Expression Lists",
                            "href":"Expression-Lists.html#GUID-5CC8FC75-813B-44AA-8737-D940FA887D1E"
                        },
                        {
                            "title":"BOOLEAN Expressions",
                            "href":"boolean-expressions.html#GUID-E492D339-5AAF-43C1-95B8-88DB1CDED0D9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Conditions",
                    "href":"Conditions.html#GUID-C2E3ED44-16E7-4924-9125-E1693B1022A8",
                    "topics":[
                        {
                            "title":"About SQL Conditions",
                            "href":"About-SQL-Conditions.html#GUID-E9EC8434-CD48-4C01-B01B-85E5359D8DD7"
                        },
                        {
                            "title":"Comparison Conditions",
                            "href":"Comparison-Conditions.html#GUID-828576BF-E606-4EA6-B94B-BFF48B67F927"
                        },
                        {
                            "title":"Floating-Point Conditions",
                            "href":"Floating-Point-Conditions.html#GUID-D7707649-2C93-4553-BF78-F461F17A634E"
                        },
                        {
                            "title":"Logical Conditions",
                            "href":"Logical-Conditions.html#GUID-C5E48AF2-3FF9-401D-A104-CDB5FC19E65F"
                        },
                        {
                            "title":"Model Conditions",
                            "href":"Model-Conditions.html#GUID-1F5B08DB-2B7A-4ECE-B51A-C753A426928B"
                        },
                        {
                            "title":"Multiset Conditions",
                            "href":"Multiset-Conditions.html#GUID-E8164A15-715A-40A0-944D-26DF4C84DE3F"
                        },
                        {
                            "title":"Pattern-matching Conditions",
                            "href":"Pattern-matching-Conditions.html#GUID-3FA7F5AB-AC64-4200-8F90-294101428C26"
                        },
                        {
                            "title":"Null Conditions",
                            "href":"Null-Conditions.html#GUID-657F2BA6-5687-4A00-8C2F-57515FD2DAEB"
                        },
                        {
                            "title":"XML Conditions",
                            "href":"XML-Conditions.html#GUID-DE0B495D-F70A-4D37-AB8B-9376991E6081"
                        },
                        {
                            "title":"SQL For JSON Conditions",
                            "href":"SQL-JSON-Conditions.html#GUID-08C75404-6E58-4EBE-A8B4-0B6041B0DB63"
                        },
                        {
                            "title":"Compound Conditions",
                            "href":"Compound-Conditions.html#GUID-D2A245F5-8071-4DF7-886E-A46F3D13AC80"
                        },
                        {
                            "title":"BETWEEN Condition",
                            "href":"BETWEEN-Condition.html#GUID-868A7C9D-EDF9-44E7-91B5-C3F69E503CCB"
                        },
                        {
                            "title":"EXISTS Condition",
                            "href":"EXISTS-Condition.html#GUID-20259A83-C42B-4E0D-8DF4-9A2A66ACA8E7"
                        },
                        {
                            "title":"IN Condition",
                            "href":"IN-Condition.html#GUID-C7961CB3-8F60-47E0-96EB-BDCF5DB1317C"
                        },
                        {
                            "title":"IS OF type Condition",
                            "href":"IS-OF-type-Condition.html#GUID-7254E4C7-0194-4C1F-A3B2-2CFB0AD907CD"
                        },
                        {
                            "title":"BOOLEAN Test Condition",
                            "href":"boolean-test-condition.html#GUID-E6611D82-5FC0-4466-A3F9-BA0E35F4103D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Functions",
                    "href":"Functions.html#GUID-D079EFD3-C683-441F-977E-2C9503089982",
                    "topics":[
                        {
                            "title":"About SQL Functions",
                            "href":"About-SQL-Functions.html#GUID-D51AB228-518C-4213-8BD4-F919623D105E"
                        },
                        {
                            "title":"Aggregate Functions",
                            "href":"Aggregate-Functions.html#GUID-62BE676B-AF18-4E63-BD14-25206FEA0848"
                        },
                        {
                            "title":"Analytic Functions",
                            "href":"Analytic-Functions.html#GUID-527832F7-63C0-4445-8C16-307FA5084056"
                        },
                        {
                            "title":"Data Cartridge Functions",
                            "href":"Data-Cartridge-Functions.html#GUID-C2B7672A-A9B4-4B53-A9FB-08B9B2EB75D4"
                        },
                        {
                            "title":"Model Functions",
                            "href":"Model-Functions.html#GUID-C3070477-FF37-4FF1-8602-031163FB2646"
                        },
                        {
                            "title":"Object Reference Functions",
                            "href":"Object-Reference-Functions.html#GUID-538CB642-0FDA-4090-9197-8685E1B55EC6"
                        },
                        {
                            "title":"OLAP Functions",
                            "href":"OLAP-Functions.html#GUID-2AE523A7-630C-4907-B91B-89861C141EBD"
                        },
                        {
                            "title":"Single-Row Functions",
                            "href":"Single-Row-Functions.html#GUID-B93F789D-B486-49FF-B0CD-0C6181C5D85C"
                        },
                        {
                            "title":"ABS",
                            "href":"ABS.html#GUID-D8D3489A-44EA-4FEC-A6F0-B5E312FFC231"
                        },
                        {
                            "title":"ACOS",
                            "href":"ACOS.html#GUID-B4C70DD5-B908-4130-975A-6CFD5C1AC1F9"
                        },
                        {
                            "title":"ADD_MONTHS",
                            "href":"ADD_MONTHS.html#GUID-B8C74443-DF32-4B7C-857F-28D557381543"
                        },
                        {
                            "title":"ANY_VALUE",
                            "href":"ANY_VALUE.html#GUID-A3C47D5E-B145-40B2-93D2-CA3BA65C2D81"
                        },
                        {
                            "title":"APPROX_COUNT",
                            "href":"APPROX_COUNT.html#GUID-7D07E04A-3F9A-425E-BADE-EDA9C6162E9C"
                        },
                        {
                            "title":"APPROX_COUNT_DISTINCT",
                            "href":"APPROX_COUNT_DISTINCT.html#GUID-50055A05-0187-4481-AFE5-2414F7227713"
                        },
                        {
                            "title":"APPROX_COUNT_DISTINCT_AGG",
                            "href":"APPROX_COUNT_DISTINCT_AGG.html#GUID-EEDA9388-A066-422A-B5C0-639A3076A10B"
                        },
                        {
                            "title":"APPROX_COUNT_DISTINCT_DETAIL",
                            "href":"APPROX_COUNT_DISTINCT_DETAIL.html#GUID-8FBD2881-743D-425E-A104-472A720DEF50"
                        },
                        {
                            "title":"APPROX_MEDIAN",
                            "href":"APPROX_MEDIAN.html#GUID-F6A11DF2-121A-4057-9D0B-BF1A221B5622"
                        },
                        {
                            "title":"APPROX_PERCENTILE",
                            "href":"APPROX_PERCENTILE.html#GUID-70D54091-EE2F-4283-A10B-1AB5A1242FE2"
                        },
                        {
                            "title":"APPROX_PERCENTILE_AGG",
                            "href":"APPROX_PERCENTILE_AGG.html#GUID-72A1DAB0-4A3E-42BF-9E20-92273AD62E11"
                        },
                        {
                            "title":"APPROX_PERCENTILE_DETAIL",
                            "href":"APPROX_PERCENTILE_DETAIL.html#GUID-F9A0B9B5-671F-43CA-9FA7-69A2DD174F54"
                        },
                        {
                            "title":"APPROX_RANK",
                            "href":"APPROX_RANK.html#GUID-4F20978C-3188-4225-863D-0F7A25FD78FD"
                        },
                        {
                            "title":"APPROX_SUM",
                            "href":"APPROX_SUM.html#GUID-AC2A72A7-24E5-4FB8-B012-BD35CB560D6B"
                        },
                        {
                            "title":"ASCII",
                            "href":"ASCII.html#GUID-871D4171-FF70-475E-BC82-9B8F46239A5D"
                        },
                        {
                            "title":"ASCIISTR",
                            "href":"ASCIISTR.html#GUID-B6128485-4E86-4851-860F-AC03981E2388"
                        },
                        {
                            "title":"ASIN",
                            "href":"ASIN.html#GUID-809ACB4E-9FDA-4943-B234-DDB32522A523"
                        },
                        {
                            "title":"ATAN",
                            "href":"ATAN.html#GUID-12E8F1AA-54D0-4A19-8648-27094946C588"
                        },
                        {
                            "title":"ATAN2",
                            "href":"ATAN2.html#GUID-D34E671B-F3C0-4390-A2D8-ABB702B4B5D3"
                        },
                        {
                            "title":"AVG",
                            "href":"AVG.html#GUID-B64BCBF1-DAA0-4D88-9821-2C4D3FDE5E4A"
                        },
                        {
                            "title":"BFILENAME",
                            "href":"BFILENAME.html#GUID-1F767077-7C26-4962-9833-1433F1749621"
                        },
                        {
                            "title":"BIN_TO_NUM",
                            "href":"BIN_TO_NUM.html#GUID-BF061402-D7F0-4557-B7D4-1CEE6E80F3B2"
                        },
                        {
                            "title":"BITAND",
                            "href":"BITAND.html#GUID-EADBED75-6AC5-4FBE-991A-E3B4D260F73B"
                        },
                        {
                            "title":"BIT_AND_AGG",
                            "href":"BIT_AND_AGG.html#GUID-82497098-6D77-48D3-89EF-C1041BF8A258"
                        },
                        {
                            "title":"BITMAP_BIT_POSITION",
                            "href":"BITMAP_BIT_POSITION.html#GUID-B57660B6-FDFA-4339-ADD3-DBE818C37BE6"
                        },
                        {
                            "title":"BITMAP_BUCKET_NUMBER",
                            "href":"BITMAP_BUCKET_NUMBER.html#GUID-6368CC51-B7C5-4BD9-9276-DE449BBC2CF3"
                        },
                        {
                            "title":"BITMAP_CONSTRUCT_AGG",
                            "href":"BITMAP_CONSTRUCT_AGG.html#GUID-AD768466-C6FF-45D7-AB26-5B1315E76B84"
                        },
                        {
                            "title":"BITMAP_COUNT",
                            "href":"BITMAP_COUNT.html#GUID-F1A3261E-7DA9-4FEF-8413-E38907C856BA"
                        },
                        {
                            "title":"BITMAP_OR_AGG",
                            "href":"BITMAP_OR_AGG.html#GUID-8C99C362-BE95-4495-9E50-4C1B572CCBEF"
                        },
                        {
                            "title":"BIT_OR_AGG",
                            "href":"BIT_OR_AGG.html#GUID-18B0E3CB-1C90-4625-8E36-B422FA4E04A8"
                        },
                        {
                            "title":"BIT_XOR_AGG",
                            "href":"BIT_XOR_AGG.html#GUID-1563FB7E-9CC9-4D03-859E-BE336AF01F1D"
                        },
                        {
                            "title":"BOOLEAN_AND_AGG",
                            "href":"boolean_and_agg.html#GUID-AF3C1A26-C7A1-4BD2-B15C-86B761D4D8D9"
                        },
                        {
                            "title":"BOOLEAN_OR_AGG",
                            "href":"boolean_or_agg.html#GUID-C3E187DE-BD26-4440-B0AD-51342FFA4775"
                        },
                        {
                            "title":"CARDINALITY",
                            "href":"CARDINALITY.html#GUID-11F978F8-1DD9-4D82-9FCF-2FC633D1C100"
                        },
                        {
                            "title":"CAST",
                            "href":"CAST.html#GUID-5A70235E-1209-4281-8521-B94497AAEF75"
                        },
                        {
                            "title":"CEIL (datetime)",
                            "href":"ceil-datetime.html#GUID-666629BE-AA15-4EA6-86A0-DF321AEFF3C0"
                        },
                        {
                            "title":"CEIL (interval)",
                            "href":"ceil-interval.html#GUID-F774D359-1828-44D4-8F48-7550A06E7206"
                        },
                        {
                            "title":"CEIL (number)",
                            "href":"CEIL.html#GUID-6DCC9AFB-9B80-4C27-AF63-5AA3B1E43660"
                        },
                        {
                            "title":"CHARTOROWID",
                            "href":"CHARTOROWID.html#GUID-F9C63933-F680-465D-AB22-6B8B882B5CF7"
                        },
                        {
                            "title":"CHECKSUM",
                            "href":"checksum.html#GUID-3F55C5DF-F23A-4B2F-BC6F-E03B34B78BA8"
                        },
                        {
                            "title":"CHR",
                            "href":"CHR.html#GUID-35FEE007-D49C-4562-A904-041186AC8928"
                        },
                        {
                            "title":"CLUSTER_DETAILS",
                            "href":"CLUSTER_DETAILS.html#GUID-6E47A5A7-B73A-4D79-BAA5-BB7E3C173D0F"
                        },
                        {
                            "title":"CLUSTER_DISTANCE",
                            "href":"CLUSTER_DISTANCE.html#GUID-21E611E3-2F15-4DF1-B648-9A36E8D5CE4D"
                        },
                        {
                            "title":"CLUSTER_ID",
                            "href":"CLUSTER_ID.html#GUID-1B0D0954-5A57-409C-9E84-F3EE12712040"
                        },
                        {
                            "title":"CLUSTER_PROBABILITY",
                            "href":"CLUSTER_PROBABILITY.html#GUID-999A15BA-FEDD-4FA6-8F1B-C847C2FE51CD"
                        },
                        {
                            "title":"CLUSTER_SET",
                            "href":"CLUSTER_SET.html#GUID-7B44CB7A-4783-4FE0-80D8-26AE88D6B060"
                        },
                        {
                            "title":"COALESCE",
                            "href":"COALESCE.html#GUID-3F9007A7-C0CA-4707-9CBA-1DBF2CDE0C87"
                        },
                        {
                            "title":"COLLATION",
                            "href":"COLLATION.html#GUID-70A694BA-C1A0-4F5A-9492-58A5943D9BDD"
                        },
                        {
                            "title":"COLLECT",
                            "href":"COLLECT.html#GUID-A0A74602-2A97-449B-A3EC-847D38D3DA90"
                        },
                        {
                            "title":"COMPOSE",
                            "href":"COMPOSE.html#GUID-A16E7D53-E7F8-46A6-B3F8-BA322D129019"
                        },
                        {
                            "title":"CON_DBID_TO_ID",
                            "href":"CON_DBID_TO_ID.html#GUID-9F38A14F-8E6A-4A4A-96D5-52E4480A8926"
                        },
                        {
                            "title":"CON_GUID_TO_ID",
                            "href":"CON_GUID_TO_ID.html#GUID-F93F257F-BB58-427D-9E19-A22E43DB288F"
                        },
                        {
                            "title":"CON_ID_TO_CON_NAME",
                            "href":"con_id_to_con_name.html#GUID-85BFFF80-142A-43EF-B807-60890FB64F65"
                        },
                        {
                            "title":"CON_ID_TO_DBID",
                            "href":"con_id_to_dbid.html#GUID-4305B1BC-5829-4AAD-B4DF-AEE17EB8F18D"
                        },
                        {
                            "title":"CON_ID_TO_GUID",
                            "href":"con_id_to_guid.html#GUID-2B5AB386-2254-46A6-83B6-ED0504008F03"
                        },
                        {
                            "title":"CON_ID_TO_UID",
                            "href":"con_id_to_uid.html#GUID-0C8239D7-5848-4C23-8680-E0B19490C48B"
                        },
                        {
                            "title":"CON_NAME_TO_ID",
                            "href":"CON_NAME_TO_ID.html#GUID-714E0914-5018-4E32-AB1E-134FDD0B28FE"
                        },
                        {
                            "title":"CON_UID_TO_ID",
                            "href":"CON_UID_TO_ID.html#GUID-14BE69F3-8519-4676-90CD-374152981901"
                        },
                        {
                            "title":"CONCAT",
                            "href":"CONCAT.html#GUID-D8723EA5-C93A-45C3-83FB-1F3D2A4CEAF2"
                        },
                        {
                            "title":"CONVERT",
                            "href":"CONVERT.html#GUID-C8BA0657-61C8-4964-A4CB-9292390853F6"
                        },
                        {
                            "title":"CORR",
                            "href":"CORR.html#GUID-E73AF5E2-38A4-436A-955C-5122C079F49C"
                        },
                        {
                            "title":"CORR_*",
                            "href":"CORR_A.html#GUID-B2DED35A-2ECE-4DF0-BDA4-28F28B7BCA23"
                        },
                        {
                            "title":"COS",
                            "href":"COS.html#GUID-C008F067-C6DC-4C13-9B7F-5A385415363A"
                        },
                        {
                            "title":"COSH",
                            "href":"COSH.html#GUID-A48CD625-5238-4259-9A1F-0FDBFD19841E"
                        },
                        {
                            "title":"COUNT",
                            "href":"COUNT.html#GUID-AEF08B79-024D-4E3A-B362-9715FB011776"
                        },
                        {
                            "title":"COVAR_POP",
                            "href":"COVAR_POP.html#GUID-D728D05F-D2E3-405C-986F-088B8353553A"
                        },
                        {
                            "title":"COVAR_SAMP",
                            "href":"COVAR_SAMP.html#GUID-7850B9E1-83A4-41CB-8F17-DCD2E2A70C95"
                        },
                        {
                            "title":"CUBE_TABLE",
                            "href":"CUBE_TABLE.html#GUID-55CDE2F2-14ED-4F8F-B5BF-1566C0E18727"
                        },
                        {
                            "title":"CUME_DIST",
                            "href":"CUME_DIST.html#GUID-B12C577C-A63C-4D19-8E18-FCCBBFBF8278"
                        },
                        {
                            "title":"CURRENT_DATE",
                            "href":"CURRENT_DATE.html#GUID-96795097-D6F0-4288-90E7-9D7C49B4F6E5"
                        },
                        {
                            "title":"CURRENT_TIMESTAMP",
                            "href":"CURRENT_TIMESTAMP.html#GUID-CBD42B84-869D-45C7-9FFC-001DD7712097"
                        },
                        {
                            "title":"CV",
                            "href":"CV.html#GUID-32E56E9C-4F59-486E-8E4C-F332284C5EA7"
                        },
                        {
                            "title":"DATAOBJ_TO_MAT_PARTITION",
                            "href":"DATAOBJ_TO_MAT_PARTITION.html#GUID-195AC748-0C9E-4A68-B2BC-2411DE435375"
                        },
                        {
                            "title":"DATAOBJ_TO_PARTITION",
                            "href":"DATAOBJ_TO_PARTITION.html#GUID-B6F62AFF-0AE1-469B-98B1-589A2D07F3A3"
                        },
                        {
                            "title":"DBTIMEZONE",
                            "href":"DBTIMEZONE.html#GUID-F2368F72-7065-462F-80B9-E115F5A48025"
                        },
                        {
                            "title":"DECODE",
                            "href":"DECODE.html#GUID-39341D91-3442-4730-BD34-D3CF5D4701CE"
                        },
                        {
                            "title":"DECOMPOSE",
                            "href":"DECOMPOSE.html#GUID-3E772756-F12C-4827-99A5-F7CF4F11A25A"
                        },
                        {
                            "title":"DENSE_RANK",
                            "href":"DENSE_RANK.html#GUID-BB66F574-09DF-4594-87A4-ABD83E8DC3FE"
                        },
                        {
                            "title":"DEPTH",
                            "href":"DEPTH.html#GUID-C0107BE4-0003-4329-9CCE-D0671B3F3538"
                        },
                        {
                            "title":"DEREF",
                            "href":"DEREF.html#GUID-E551FFE4-619F-40CE-8303-683EFA3EB28F"
                        },
                        {
                            "title":"DOMAIN_CHECK",
                            "href":"domain_check.html#GUID-599390A5-1B96-4465-82CE-DBC2345A018B"
                        },
                        {
                            "title":"DOMAIN_CHECK_TYPE",
                            "href":"domain_check_type.html#GUID-9ED35142-A66C-4511-9DE1-B8BB4350DE41"
                        },
                        {
                            "title":"DOMAIN_DISPLAY",
                            "href":"domain_display.html#GUID-BF1D853F-5BA8-4E9E-B8EB-BF7502F11D20"
                        },
                        {
                            "title":"DOMAIN_NAME",
                            "href":"domain_name.html#GUID-BFF71A4E-8FF2-407A-8661-C0A24D4E5487"
                        },
                        {
                            "title":"DOMAIN_ORDER",
                            "href":"domain_order.html#GUID-FC34F669-0BCA-4F8A-B911-4ACAA1F8F11D"
                        },
                        {
                            "title":"DUMP",
                            "href":"DUMP.html#GUID-A05793C9-B35D-4BA7-B68C-E3693BCF47A5"
                        },
                        {
                            "title":"EMPTY_BLOB, EMPTY_CLOB",
                            "href":"EMPTY_BLOB-EMPTY_CLOB.html#GUID-551B5A7C-A03B-4B2E-80EF-DAA8574CF160"
                        },
                        {
                            "title":"EVERY",
                            "href":"every.html#GUID-C34D8A50-3050-4F32-941A-8C2512DEC62D"
                        },
                        {
                            "title":"EXISTSNODE",
                            "href":"EXISTSNODE.html#GUID-71731B1A-99E5-4B82-8243-DEEE6704796F"
                        },
                        {
                            "title":"EXP",
                            "href":"EXP.html#GUID-414FB4AE-03B5-41AD-AE33-E3755EFED0A0"
                        },
                        {
                            "title":"EXTRACT (datetime)",
                            "href":"EXTRACT-datetime.html#GUID-36E52BF8-945D-437D-9A3C-6860CABD210E"
                        },
                        {
                            "title":"EXTRACT (XML)",
                            "href":"EXTRACT-XML.html#GUID-593295AA-4F46-4D75-B8DC-E7BCEDB1D4D7"
                        },
                        {
                            "title":"EXTRACTVALUE",
                            "href":"EXTRACTVALUE.html#GUID-20AB974B-7544-4F44-B539-787FB6145680"
                        },
                        {
                            "title":"FEATURE_COMPARE",
                            "href":"FEATURE_COMPARE.html#GUID-3D4E179F-F5D2-4FCF-AB42-4D0C8CC7D514"
                        },
                        {
                            "title":"FEATURE_DETAILS",
                            "href":"FEATURE_DETAILS.html#GUID-A42F313B-22C1-4CAC-BA3F-C418178D743F"
                        },
                        {
                            "title":"FEATURE_ID",
                            "href":"FEATURE_ID.html#GUID-BA187F80-5F51-49F6-BB69-64422FB9FD90"
                        },
                        {
                            "title":"FEATURE_SET",
                            "href":"FEATURE_SET.html#GUID-55582346-F1D6-447E-851A-D4912982EB28"
                        },
                        {
                            "title":"FEATURE_VALUE",
                            "href":"FEATURE_VALUE.html#GUID-EC0E44D0-BE01-49F8-9E5A-72B500119877"
                        },
                        {
                            "title":"FIRST",
                            "href":"FIRST.html#GUID-85AB9246-0E0A-44A1-A7E6-4E57502E9238"
                        },
                        {
                            "title":"FIRST_VALUE",
                            "href":"FIRST_VALUE.html#GUID-D454EC3F-370C-4C64-9B11-33FCB10D95EC"
                        },
                        {
                            "title":"FLOOR (datetime)",
                            "href":"floor-datetime.html#GUID-3EB4F1BA-9D18-437C-96BA-D3B0282DDE97"
                        },
                        {
                            "title":"FLOOR (interval)",
                            "href":"floor-interval.html#GUID-2339112B-EA60-46F6-9BDA-63C0A99B86A1"
                        },
                        {
                            "title":"FLOOR (number)",
                            "href":"FLOOR.html#GUID-67F61AC7-C097-4397-A122-213157BF584F"
                        },
                        {
                            "title":"FROM_TZ",
                            "href":"FROM_TZ.html#GUID-84384FF7-6462-480C-BC40-60087016857B"
                        },
                        {
                            "title":"FROM_VECTOR",
                            "href":"from_vector.html#GUID-AA60B3CB-FCB7-4944-9E06-976C272855B1"
                        },
                        {
                            "title":"GRAPHQL Table Function",
                            "href":"graphql-table-function.html#GUID-3B8F3473-AE08-4126-8D95-636FA72A05A6"
                        },
                        {
                            "title":"GREATEST",
                            "href":"GREATEST.html#GUID-06B88B22-8466-44B6-93C7-50B222122ECE"
                        },
                        {
                            "title":"GROUP_ID",
                            "href":"GROUP_ID.html#GUID-3A5A9C15-1B67-4FD7-AC41-EE8349B2E834"
                        },
                        {
                            "title":"GROUPING",
                            "href":"GROUPING.html#GUID-82E6084A-0BDF-4587-A40E-36899783F073"
                        },
                        {
                            "title":"GROUPING_ID",
                            "href":"GROUPING_ID.html#GUID-E20A5B8E-73B6-42FD-8AFB-DD3CD6D6DC61"
                        },
                        {
                            "title":"HEXTORAW",
                            "href":"HEXTORAW.html#GUID-8571556F-C219-4814-A854-9F01581FFBDF"
                        },
                        {
                            "title":"INITCAP",
                            "href":"INITCAP.html#GUID-9FE9E0EE-D6B6-4C2C-BDEF-4FF4E1314560"
                        },
                        {
                            "title":"INSTR",
                            "href":"INSTR.html#GUID-47E3A7C4-ED72-458D-A1FA-25A9AD3BE113"
                        },
                        {
                            "title":"ITERATION_NUMBER",
                            "href":"ITERATION_NUMBER.html#GUID-C7B75092-475A-4AB3-8A7C-94C68704538C"
                        },
                        {
                            "title":"IS_UUID",
                            "href":"is_uuid.html#GUID-01803FC5-A637-498C-932C-DEB909115D97"
                        },
                        {
                            "title":"JSON_ARRAY",
                            "href":"JSON_ARRAY.html#GUID-46CDB3AF-5795-455B-85A8-764528CEC43B"
                        },
                        {
                            "title":"JSON_ARRAYAGG",
                            "href":"JSON_ARRAYAGG.html#GUID-6D56077D-78DE-4CC0-9498-225DDC42E054"
                        },
                        {
                            "title":"JSON_DATAGUIDE",
                            "href":"JSON_DATAGUIDE.html#GUID-4CF32887-0F46-4925-8381-AE2B74343933"
                        },
                        {
                            "title":"JSON_MERGEPATCH",
                            "href":"JSON_MERGEPATCH.html#GUID-2004F536-BE60-4457-A1A8-AB908FFF5399"
                        },
                        {
                            "title":"JSON_OBJECT",
                            "href":"JSON_OBJECT.html#GUID-1EF347AE-7FDA-4B41-AFE0-DD5A49E8B370"
                        },
                        {
                            "title":"JSON_OBJECTAGG",
                            "href":"JSON_OBJECTAGG.html#GUID-09422D4A-936C-4D38-9991-C64101283D98"
                        },
                        {
                            "title":"JSON_QUERY",
                            "href":"JSON_QUERY.html#GUID-6D396EC4-D2AA-43D2-8F5D-08D646A4A2D9"
                        },
                        {
                            "title":"JSON_SCALAR",
                            "href":"json_scalar.html#GUID-F05BD523-F827-4A5F-9A82-8CBC2DB04E2E"
                        },
                        {
                            "title":"JSON_SERIALIZE",
                            "href":"JSON_SERIALIZE.html#GUID-01B769C6-A7B3-4136-977F-63CA05963D21"
                        },
                        {
                            "title":"JSON_TABLE",
                            "href":"JSON_TABLE.html#GUID-3C8E63B5-0B94-4E86-A2D3-3D4831B67C62"
                        },
                        {
                            "title":"JSON_TRANSFORM",
                            "href":"JSON_TRANSFORM.html#GUID-DD2A821B-C688-4310-81B5-5F45090B9366"
                        },
                        {
                            "title":"JSON_VALUE",
                            "href":"JSON_VALUE.html#GUID-C7F19D36-1E75-4CB2-AE67-ADFBAD23CBC2"
                        },
                        {
                            "title":"JSON Type Constructor",
                            "href":"json-type-constructor.html#GUID-2B598841-A327-4610-91B9-602F480A8314"
                        },
                        {
                            "title":"KURTOSIS_POP",
                            "href":"KURTOSIS_POP.html#GUID-F820DFF7-B758-460E-AECC-053915069B9F"
                        },
                        {
                            "title":"KURTOSIS_SAMP",
                            "href":"KURTOSIS_SAMP.html#GUID-487DE503-A015-415F-B6CD-F9D095B91178"
                        },
                        {
                            "title":"LAG",
                            "href":"LAG.html#GUID-68081CD0-72BE-4C0A-AA6B-AD39FFA7BCF2"
                        },
                        {
                            "title":"LAST",
                            "href":"LAST.html#GUID-4E16BC0E-D3B8-4BA4-8F97-3A08891A85CC"
                        },
                        {
                            "title":"LAST_DAY",
                            "href":"LAST_DAY.html#GUID-296C7C02-7FB9-4AAC-8927-6A79320CE0C6"
                        },
                        {
                            "title":"LAST_VALUE",
                            "href":"LAST_VALUE.html#GUID-A646AF95-C8E9-4A67-87BA-87B11AEE7B79"
                        },
                        {
                            "title":"LEAD",
                            "href":"LEAD.html#GUID-0A0481F1-E98F-4535-A739-FCCA8D1B5B77"
                        },
                        {
                            "title":"LEAST",
                            "href":"LEAST.html#GUID-0198D71B-051A-41D9-8E9C-599E24692556"
                        },
                        {
                            "title":"LENGTH",
                            "href":"LENGTH.html#GUID-8F97F652-5AE8-4457-AFD7-7A6F25551E0C"
                        },
                        {
                            "title":"LISTAGG",
                            "href":"LISTAGG.html#GUID-B6E50D8E-F467-425B-9436-F7F8BF38D466"
                        },
                        {
                            "title":"LN",
                            "href":"LN.html#GUID-DCC9EDAA-D308-4145-8E05-8D06A5EF5F6F"
                        },
                        {
                            "title":"LNNVL",
                            "href":"LNNVL.html#GUID-FBCCE9B1-614E-45FA-8EE1-DFAA4F936867"
                        },
                        {
                            "title":"LOCALTIMESTAMP",
                            "href":"LOCALTIMESTAMP.html#GUID-3C3D1F29-5F53-41F2-B2D6-A3767DFB22CA"
                        },
                        {
                            "title":"LOG",
                            "href":"LOG.html#GUID-3739F356-A4A0-4D0D-A4EB-9725ACA05CD1"
                        },
                        {
                            "title":"LOWER",
                            "href":"LOWER.html#GUID-C8682D4C-9BED-48AC-B73A-1D70BF307F48"
                        },
                        {
                            "title":"LPAD",
                            "href":"LPAD.html#GUID-0C27B59A-A6CF-43D3-BF4B-07A3D0F2CE20"
                        },
                        {
                            "title":"LTRIM",
                            "href":"LTRIM.html#GUID-81B3D53C-0BBC-4485-B057-C8012CD6E40F"
                        },
                        {
                            "title":"MAKE_REF",
                            "href":"MAKE_REF.html#GUID-926B9963-5387-4781-88D5-A005334C1F2A"
                        },
                        {
                            "title":"MAX",
                            "href":"MAX.html#GUID-E5372020-A6DA-44BF-93BE-DA8C3F74CD01"
                        },
                        {
                            "title":"MEDIAN",
                            "href":"MEDIAN.html#GUID-DE15705A-AC18-4416-8487-B9E1D70CE01A"
                        },
                        {
                            "title":"MIN",
                            "href":"MIN.html#GUID-F7F04E18-1AD8-4D15-9491-4622AD847A74"
                        },
                        {
                            "title":"MOD",
                            "href":"MOD.html#GUID-E12A3928-2C50-45B0-B8C3-82432C751B8C"
                        },
                        {
                            "title":"MONTHS_BETWEEN",
                            "href":"MONTHS_BETWEEN.html#GUID-E4A1AEC0-F5A0-4703-9CC8-4087EB889952"
                        },
                        {
                            "title":"NANVL",
                            "href":"NANVL.html#GUID-3C094646-2A70-41F5-984C-9BC0FB31494A"
                        },
                        {
                            "title":"NCHR",
                            "href":"NCHR.html#GUID-3A1BDD54-6C0B-4067-99C5-A439C0F8D561"
                        },
                        {
                            "title":"NEW_TIME",
                            "href":"NEW_TIME.html#GUID-1D1CC7DE-CA2A-4BEC-B404-89FD19EE36AC"
                        },
                        {
                            "title":"NEXT_DAY",
                            "href":"NEXT_DAY.html#GUID-01B2CC7A-1A64-4A74-918E-26158C9096F6"
                        },
                        {
                            "title":"NLS_CHARSET_DECL_LEN",
                            "href":"NLS_CHARSET_DECL_LEN.html#GUID-5F0939C0-4AFB-4CEA-9899-BDE85B9B2F11"
                        },
                        {
                            "title":"NLS_CHARSET_ID",
                            "href":"NLS_CHARSET_ID.html#GUID-733B03A0-CD66-4645-A323-401A176499E3"
                        },
                        {
                            "title":"NLS_CHARSET_NAME",
                            "href":"NLS_CHARSET_NAME.html#GUID-5DCFB255-92AD-4E94-9344-73B7918C106C"
                        },
                        {
                            "title":"NLS_COLLATION_ID",
                            "href":"NLS_COLLATION_ID.html#GUID-69EA3869-28E3-4CF8-9678-CD4F9878EE99"
                        },
                        {
                            "title":"NLS_COLLATION_NAME",
                            "href":"NLS_COLLATION_NAME.html#GUID-24848987-2A02-4B09-A690-D3C87308FB3A"
                        },
                        {
                            "title":"NLS_INITCAP",
                            "href":"NLS_INITCAP.html#GUID-42C1581B-B5AA-4D4C-A489-BC5B38A754FD"
                        },
                        {
                            "title":"NLS_LOWER",
                            "href":"NLS_LOWER.html#GUID-96944213-377E-461C-9F02-2DC4EC2B1649"
                        },
                        {
                            "title":"NLS_UPPER",
                            "href":"NLS_UPPER.html#GUID-91D6302F-4DE2-49FA-8837-D46D3FD58DF8"
                        },
                        {
                            "title":"NLSSORT",
                            "href":"NLSSORT.html#GUID-781C6FE8-0924-4617-AECB-EE40DE45096D"
                        },
                        {
                            "title":"NTH_VALUE",
                            "href":"NTH_VALUE.html#GUID-F8A0E88C-67E5-4AA6-9515-95D03A7F9EA0"
                        },
                        {
                            "title":"NTILE",
                            "href":"NTILE.html#GUID-FAD7A986-AEBD-4A03-B0D2-F7F2148BA5E9"
                        },
                        {
                            "title":"NULLIF",
                            "href":"NULLIF.html#GUID-445FC268-7FFA-4850-98C9-D53D88AB2405"
                        },
                        {
                            "title":"NUMTODSINTERVAL",
                            "href":"NUMTODSINTERVAL.html#GUID-5A7392A8-7976-4465-8839-A65EFF1A80B6"
                        },
                        {
                            "title":"NUMTOYMINTERVAL",
                            "href":"NUMTOYMINTERVAL.html#GUID-B98B21AA-44F7-4A9D-A646-6775A1D5F46D"
                        },
                        {
                            "title":"NVL",
                            "href":"NVL.html#GUID-3AB61E54-9201-4D6A-B48A-79F4C4A034B2"
                        },
                        {
                            "title":"NVL2",
                            "href":"NVL2.html#GUID-414D6E81-9627-4163-8AC2-BD24E57742AE"
                        },
                        {
                            "title":"ORA_DM_PARTITION_NAME",
                            "href":"ORA_DM_PARTITION_NAME.html#GUID-F9ADE9AD-C306-42D1-8274-3F73C2FBAC19"
                        },
                        {
                            "title":"ORA_DST_AFFECTED",
                            "href":"ORA_DST_AFFECTED.html#GUID-EE288E4B-DE55-4104-813C-11E28F7B474A"
                        },
                        {
                            "title":"ORA_DST_CONVERT",
                            "href":"ORA_DST_CONVERT.html#GUID-3A991FB0-0E98-48F5-902F-55C6FCA8DA13"
                        },
                        {
                            "title":"ORA_DST_ERROR",
                            "href":"ORA_DST_ERROR.html#GUID-02FAF3EC-D90A-42FB-A212-513314AD774A"
                        },
                        {
                            "title":"ORA_HASH",
                            "href":"ORA_HASH.html#GUID-0349AFF5-0268-43CE-8118-4F96D752FDE6"
                        },
                        {
                            "title":"ORA_INVOKING_USER",
                            "href":"ORA_INVOKING_USER.html#GUID-FAE7B186-C40D-48BB-A2C9-AB7EE3878BF1"
                        },
                        {
                            "title":"ORA_INVOKING_USERID",
                            "href":"ORA_INVOKING_USERID.html#GUID-91F09A40-96CD-4759-8EDF-4C54219E8E83"
                        },
                        {
                            "title":"PATH",
                            "href":"PATH.html#GUID-91937F98-7718-4F39-9225-1E0229F11F0D"
                        },
                        {
                            "title":"PERCENT_RANK",
                            "href":"PERCENT_RANK.html#GUID-66A868F5-9EBA-482A-BF8C-09300B9EE165"
                        },
                        {
                            "title":"PERCENTILE_CONT",
                            "href":"PERCENTILE_CONT.html#GUID-CA259452-A565-41B3-A4F4-DD74B66CEDE0"
                        },
                        {
                            "title":"PERCENTILE_DISC",
                            "href":"PERCENTILE_DISC.html#GUID-7C34FDDA-C241-474F-8C5C-50CC0182E005"
                        },
                        {
                            "title":"POWER",
                            "href":"POWER.html#GUID-D280B322-D2C3-46D0-8076-C88F16CBEDC2"
                        },
                        {
                            "title":"POWERMULTISET",
                            "href":"POWERMULTISET.html#GUID-34F3B1D1-4089-4A5B-AA2C-9C69A5C36E6D"
                        },
                        {
                            "title":"POWERMULTISET_BY_CARDINALITY",
                            "href":"POWERMULTISET_BY_CARDINALITY.html#GUID-57423B5C-CD16-4B3C-A796-AAA0910EF261"
                        },
                        {
                            "title":"PREDICTION",
                            "href":"PREDICTION.html#GUID-DA66A1C3-BFB2-43A1-A3FF-93D4A3DAB9C6"
                        },
                        {
                            "title":"PREDICTION_BOUNDS",
                            "href":"PREDICTION_BOUNDS.html#GUID-C9478C25-8D31-4A39-99B8-AB66A6614795"
                        },
                        {
                            "title":"PREDICTION_COST",
                            "href":"PREDICTION_COST.html#GUID-2E58222D-FB7E-4CA2-BCAA-C932FCDEE890"
                        },
                        {
                            "title":"PREDICTION_DETAILS",
                            "href":"PREDICTION_DETAILS.html#GUID-D7261A56-E729-4882-B48D-CDD343C53810"
                        },
                        {
                            "title":"PREDICTION_PROBABILITY",
                            "href":"PREDICTION_PROBABILITY.html#GUID-0F309771-40A3-4E23-9A96-CD134C80F584"
                        },
                        {
                            "title":"PREDICTION_SET",
                            "href":"PREDICTION_SET.html#GUID-25AE84A7-C733-4BC5-8C57-2E5574C49AFC"
                        },
                        {
                            "title":"PRESENTNNV",
                            "href":"PRESENTNNV.html#GUID-2FB61064-9A7C-49E5-8448-6636CC69837E"
                        },
                        {
                            "title":"PRESENTV",
                            "href":"PRESENTV.html#GUID-201643DA-918F-4F68-BF80-FEAA7EBFD829"
                        },
                        {
                            "title":"PREVIOUS",
                            "href":"PREVIOUS.html#GUID-75D5C320-ECE3-444A-86C1-A5637F4428AF"
                        },
                        {
                            "title":"RANK",
                            "href":"RANK.html#GUID-0950BD34-C994-41DA-A8F9-34B3FE53BBBA"
                        },
                        {
                            "title":"RATIO_TO_REPORT",
                            "href":"RATIO_TO_REPORT.html#GUID-9D10C275-4341-435F-ACF4-767B9CCB7390"
                        },
                        {
                            "title":"RAWTOHEX",
                            "href":"RAWTOHEX.html#GUID-F86E3B5B-7FEE-47FD-A0C2-2FC55DC21C9E"
                        },
                        {
                            "title":"RAWTONHEX",
                            "href":"RAWTONHEX.html#GUID-5657B113-24CE-4DC6-BD11-63135B7DB009"
                        },
                        {
                            "title":"RAW_TO_UUID",
                            "href":"raw_to_uuid.html#GUID-F5948759-F523-47F6-B7E9-96A99154CA51"
                        },
                        {
                            "title":"REF",
                            "href":"REF.html#GUID-B7622138-6EB6-4203-B5E7-91CAD52E9DB1"
                        },
                        {
                            "title":"REFTOHEX",
                            "href":"REFTOHEX.html#GUID-3F8A9932-063D-4EF1-85B7-03D823F6AC09"
                        },
                        {
                            "title":"REGEXP_COUNT",
                            "href":"REGEXP_COUNT.html#GUID-5148AF2E-9CED-497D-A78D-3A7847A45276"
                        },
                        {
                            "title":"REGEXP_INSTR",
                            "href":"REGEXP_INSTR.html#GUID-D21B53A1-83E2-4722-9BBB-638470715DD6"
                        },
                        {
                            "title":"REGEXP_REPLACE",
                            "href":"REGEXP_REPLACE.html#GUID-EA80A33C-441A-4692-A959-273B5A224490"
                        },
                        {
                            "title":"REGEXP_SUBSTR",
                            "href":"REGEXP_SUBSTR.html#GUID-2903904D-455F-4839-A8B2-1731EF4BD099"
                        },
                        {
                            "title":"REGR_ (Linear Regression) Functions",
                            "href":"REGR_-Linear-Regression-Functions.html#GUID-A675B68F-2A88-4843-BE2C-FCDE9C65F9A9"
                        },
                        {
                            "title":"REMAINDER",
                            "href":"REMAINDER.html#GUID-430D4C4A-5779-4EBB-90C5-4D7CA7E73556"
                        },
                        {
                            "title":"REPLACE",
                            "href":"REPLACE.html#GUID-1A79BDDF-2D3B-4AD4-98E7-985B2E59DA6B"
                        },
                        {
                            "title":"ROUND (datetime)",
                            "href":"ROUND-date.html#GUID-C6D342D0-6068-4986-A759-70EF4599EC41"
                        },
                        {
                            "title":"ROUND (interval)",
                            "href":"round-interval.html#GUID-BE2A9358-55A6-432B-AC78-535A4D1A55F2"
                        },
                        {
                            "title":"ROUND (number)",
                            "href":"ROUND-number.html#GUID-849F6C45-0D72-4464-9C0F-8B6822BA85E1"
                        },
                        {
                            "title":"ROUND_TIES_TO_EVEN (number)",
                            "href":"ROUND_TIES_TO_EVEN-number.html#GUID-49919B6B-4337-4812-A248-B5D98F102DBD"
                        },
                        {
                            "title":"ROW_NUMBER",
                            "href":"ROW_NUMBER.html#GUID-D5A157F8-0F53-45BD-BF8C-AE79B1DB8C41"
                        },
                        {
                            "title":"ROWIDTOCHAR",
                            "href":"ROWIDTOCHAR.html#GUID-67998E5B-376A-45B5-B20B-1A87E5D370C1"
                        },
                        {
                            "title":"ROWIDTONCHAR",
                            "href":"ROWIDTONCHAR.html#GUID-3178A4DA-2534-4A93-A819-7C14208AE9B5"
                        },
                        {
                            "title":"RPAD",
                            "href":"RPAD.html#GUID-064CFCAE-5902-49F9-800E-0AF311AEF595"
                        },
                        {
                            "title":"RTRIM",
                            "href":"RTRIM.html#GUID-95A7DAFB-F7AB-48F4-BE24-64B3C7A840AA"
                        },
                        {
                            "title":"SCN_TO_TIMESTAMP",
                            "href":"SCN_TO_TIMESTAMP.html#GUID-BCB0C8EE-0E03-4A61-A41A-69975FAC1803"
                        },
                        {
                            "title":"SESSIONTIMEZONE",
                            "href":"SESSIONTIMEZONE.html#GUID-2A243878-C1C5-4B7C-81DE-D8B024796EAB"
                        },
                        {
                            "title":"SET",
                            "href":"SET.html#GUID-533164AC-B4F0-4FCE-ADA4-85C925CB8D14"
                        },
                        {
                            "title":"SIGN",
                            "href":"SIGN.html#GUID-08B75521-B5F5-4658-A005-4B4441C82945"
                        },
                        {
                            "title":"SIN",
                            "href":"SIN.html#GUID-2AF4895F-5D23-4165-89D5-B1D404ED99BF"
                        },
                        {
                            "title":"SINH",
                            "href":"SINH.html#GUID-1EB8626B-4D84-4EAD-BD23-1A97F186FD4A"
                        },
                        {
                            "title":"SKEWNESS_POP",
                            "href":"SKEWNESS_POP.html#GUID-DF34158F-B681-4933-BA27-0A3885A9F43C"
                        },
                        {
                            "title":"SKEWNESS_SAMP",
                            "href":"SKEWNESS_SAMP.html#GUID-E71D9AEC-0AAA-4A6C-BF70-29EE9AD8F7EC"
                        },
                        {
                            "title":"SOUNDEX",
                            "href":"SOUNDEX.html#GUID-9C43625B-70CA-4B43-AE22-5EC2A02192F8"
                        },
                        {
                            "title":"SQRT",
                            "href":"SQRT.html#GUID-E28C0B65-AAD8-4077-A82E-2FB4CD261CCA"
                        },
                        {
                            "title":"STANDARD_HASH",
                            "href":"STANDARD_HASH.html#GUID-4A68DACE-CFCF-443B-8651-B6CEAA7C4FD7"
                        },
                        {
                            "title":"STATS_BINOMIAL_TEST",
                            "href":"STATS_BINOMIAL_TEST.html#GUID-3DDCDC0C-0DB2-479F-A6EB-E9FC0063ABF4"
                        },
                        {
                            "title":"STATS_CROSSTAB",
                            "href":"STATS_CROSSTAB.html#GUID-AA0958AE-FF56-4970-B880-23426E0B7E6D"
                        },
                        {
                            "title":"STATS_F_TEST",
                            "href":"STATS_F_TEST.html#GUID-9E2A91FC-5BB3-449A-810C-DA6CB52B56ED"
                        },
                        {
                            "title":"STATS_KS_TEST",
                            "href":"STATS_KS_TEST.html#GUID-ADE2ACB3-C852-499F-8892-E4AA101EC80D"
                        },
                        {
                            "title":"STATS_MODE",
                            "href":"STATS_MODE.html#GUID-10BDACE0-C435-4E3F-BC50-FD1A41C0F508"
                        },
                        {
                            "title":"STATS_MW_TEST",
                            "href":"STATS_MW_TEST.html#GUID-77AF4F10-D4DC-45A9-94E8-F4F648F81222"
                        },
                        {
                            "title":"STATS_ONE_WAY_ANOVA",
                            "href":"STATS_ONE_WAY_ANOVA.html#GUID-CC614CE5-56CB-4A54-8571-6FEAD2D2E75F"
                        },
                        {
                            "title":"STATS_T_TEST_*",
                            "href":"STATS_T_TEST_.html#GUID-B570D6F6-E4D7-4033-AC83-7E76F2E9CC2A"
                        },
                        {
                            "title":"STATS_WSR_TEST",
                            "href":"STATS_WSR_TEST.html#GUID-80A8A9A9-7CD9-4358-B628-6D67BD42BA5B"
                        },
                        {
                            "title":"STDDEV",
                            "href":"STDDEV.html#GUID-CA0C3B1F-1A4C-4CFB-ADAB-D90216C4E099"
                        },
                        {
                            "title":"STDDEV_POP",
                            "href":"STDDEV_POP.html#GUID-4F804DE5-7E20-4E08-A1BA-32DBB167B34B"
                        },
                        {
                            "title":"STDDEV_SAMP",
                            "href":"STDDEV_SAMP.html#GUID-7B2A708E-E73A-4CFE-978E-3F9C4BD37467"
                        },
                        {
                            "title":"SUBSTR",
                            "href":"SUBSTR.html#GUID-C8A20B57-C647-4649-A379-8651AA97187E"
                        },
                        {
                            "title":"SUM",
                            "href":"SUM.html#GUID-5610BE2C-CFE5-446F-A1F7-B924B5663220"
                        },
                        {
                            "title":"SYS_CONNECT_BY_PATH",
                            "href":"SYS_CONNECT_BY_PATH.html#GUID-D25A0F86-B559-4090-9164-7A2C84D1E11E"
                        },
                        {
                            "title":"SYS_CONTEXT",
                            "href":"SYS_CONTEXT.html#GUID-B9934A5D-D97B-4E51-B01B-80C76A5BD086"
                        },
                        {
                            "title":"SYS_DBURIGEN",
                            "href":"SYS_DBURIGEN.html#GUID-ABA33BEB-F7B7-477B-9FF2-028D62768797"
                        },
                        {
                            "title":"SYS_EXTRACT_UTC",
                            "href":"SYS_EXTRACT_UTC.html#GUID-C540A8C8-72B1-46AF-A9AA-18D011763AD8"
                        },
                        {
                            "title":"SYS_GUID",
                            "href":"SYS_GUID.html#GUID-761E36B4-32DA-497D-8829-3D4653381F9B"
                        },
                        {
                            "title":"SYS_OP_ZONE_ID",
                            "href":"SYS_OP_ZONE_ID.html#GUID-947900CE-F4E0-43B5-B30C-4FDDA3913F17"
                        },
                        {
                            "title":"SYS_ROW_ETAG",
                            "href":"sys_row_etag.html#GUID-46D84F68-2E6E-40B9-81CD-2701E300E417"
                        },
                        {
                            "title":"SYS_TYPEID",
                            "href":"SYS_TYPEID.html#GUID-4E3D45A1-7433-495D-9062-88505A1496E0"
                        },
                        {
                            "title":"SYS_XMLAGG",
                            "href":"SYS_XMLAGG.html#GUID-BEDD241D-360A-46A2-AEBF-C8B70E465D75"
                        },
                        {
                            "title":"SYS_XMLGEN",
                            "href":"SYS_XMLGEN.html#GUID-1AC25984-F4AB-468E-BF53-561275AD44E8"
                        },
                        {
                            "title":"SYSDATE",
                            "href":"SYSDATE.html#GUID-807F8FC5-D72D-4F4D-B66D-B0FE1A8FA7D2"
                        },
                        {
                            "title":"SYSTIMESTAMP",
                            "href":"SYSTIMESTAMP.html#GUID-FCED18CE-A875-4D5D-9178-3DE4FA956516"
                        },
                        {
                            "title":"TAN",
                            "href":"TAN.html#GUID-473E2008-5951-4FC8-A356-14D3D085B8AA"
                        },
                        {
                            "title":"TANH",
                            "href":"TANH.html#GUID-8DD0B75F-1BDB-4E41-8C6D-FB5B2908AF80"
                        },
                        {
                            "title":"TIMESTAMP_TO_SCN",
                            "href":"TIMESTAMP_TO_SCN.html#GUID-58796E1A-9943-4966-96E6-78B636BD2859"
                        },
                        {
                            "title":"TIME_BUCKET (datetime)",
                            "href":"time_bucket-datetime.html#GUID-7C869201-5BE5-4DBD-97A0-864C48EA4034"
                        },
                        {
                            "title":"TO_APPROX_COUNT_DISTINCT",
                            "href":"TO_APPROX_COUNT_DISTINCT.html#GUID-42A18FFB-C992-44A0-AC3E-F4BBF005846F"
                        },
                        {
                            "title":"TO_APPROX_PERCENTILE",
                            "href":"TO_APPROX_PERCENTILE.html#GUID-463702B2-9199-41ED-AE03-865CABAD3E23"
                        },
                        {
                            "title":"TO_BINARY_DOUBLE",
                            "href":"TO_BINARY_DOUBLE.html#GUID-0BA2E065-8006-426C-A3CB-1F6B0C8F283C"
                        },
                        {
                            "title":"TO_BINARY_FLOAT",
                            "href":"TO_BINARY_FLOAT.html#GUID-66A51BE2-BE4A-4B99-9C37-73B110452D27"
                        },
                        {
                            "title":"TO_BLOB (bfile)",
                            "href":"TO_BLOB-bfile.html#GUID-232A1599-53C9-464B-904F-4DBA336B4EBC"
                        },
                        {
                            "title":"TO_BLOB (raw)",
                            "href":"TO_BLOB-raw.html#GUID-C4308DB1-5BFE-48F0-99E5-9E03B80B4585"
                        },
                        {
                            "title":"TO_BOOLEAN",
                            "href":"to_boolean.html#GUID-B4FA8F5F-DD2A-4BEA-946A-B3CA60509294"
                        },
                        {
                            "title":"TO_CHAR (bfile|blob)",
                            "href":"TO_CHAR-bfile-blob.html#GUID-F12F3C5A-8E3C-4FE1-BD7D-4AC0B79EA5A5"
                        },
                        {
                            "title":"TO_CHAR (boolean)",
                            "href":"to_char-boolean.html#GUID-B9923922-AD87-4C7A-BC9A-3A3BC2D6AA2E"
                        },
                        {
                            "title":"TO_CHAR (character)",
                            "href":"TO_CHAR-character.html#GUID-EC078E16-11FE-4ABE-AE05-DA9AC1B4BEBC"
                        },
                        {
                            "title":"TO_CHAR (datetime)",
                            "href":"TO_CHAR-datetime.html#GUID-0C3EEFD1-AE3D-452D-BF23-2FC95664E78F"
                        },
                        {
                            "title":"TO_CHAR (number)",
                            "href":"TO_CHAR-number.html#GUID-00DA076D-2468-41AB-A3AC-CC78DBA0D9CB"
                        },
                        {
                            "title":"TO_CLOB (bfile|blob)",
                            "href":"TO_CLOB-bfile-blob.html#GUID-FD7D58FE-B97C-4B75-85A9-5F82FB1DE96A"
                        },
                        {
                            "title":"TO_CLOB (character)",
                            "href":"TO_CLOB-character.html#GUID-82E2FAD3-B0C8-4A06-A882-26211EE0524C"
                        },
                        {
                            "title":"TO_DATE",
                            "href":"TO_DATE.html#GUID-D226FA7C-F7AD-41A0-BB1D-BD8EF9440118"
                        },
                        {
                            "title":"TO_DSINTERVAL",
                            "href":"TO_DSINTERVAL.html#GUID-DEBB41BD-9438-4558-A53E-428CE93C05D3"
                        },
                        {
                            "title":"TO_LOB",
                            "href":"TO_LOB.html#GUID-35810313-029E-4CB8-8C27-DF432FA3C253"
                        },
                        {
                            "title":"TO_MULTI_BYTE",
                            "href":"TO_MULTI_BYTE.html#GUID-58A9F91A-5B1E-4C14-8F48-046F176E2F4A"
                        },
                        {
                            "title":"TO_NCHAR (boolean)",
                            "href":"to_nchar-boolean.html#GUID-4F0853D4-C661-4DF2-8B67-F5207F2A86CF"
                        },
                        {
                            "title":"TO_NCHAR (character)",
                            "href":"TO_NCHAR-character.html#GUID-539E9F5C-CB47-4BCE-B468-C34CF6BABDC5"
                        },
                        {
                            "title":"TO_NCHAR (datetime)",
                            "href":"TO_NCHAR-datetime.html#GUID-C40DBBC2-B9F2-49D8-8775-DDA99FF41EAC"
                        },
                        {
                            "title":"TO_NCHAR (number)",
                            "href":"TO_NCHAR-number.html#GUID-B0FA1B2F-3285-46C4-96DA-3C7AED48987C"
                        },
                        {
                            "title":"TO_NCLOB",
                            "href":"TO_NCLOB.html#GUID-56CEB237-8515-4030-A5D5-016CBC5FA6BB"
                        },
                        {
                            "title":"TO_NUMBER",
                            "href":"TO_NUMBER.html#GUID-D4807212-AFD7-48A7-9AED-BEC3E8809866"
                        },
                        {
                            "title":"TO_SINGLE_BYTE",
                            "href":"TO_SINGLE_BYTE.html#GUID-36364630-C62C-46C5-B29B-EFE3DFB5AA6D"
                        },
                        {
                            "title":"TO_TIMESTAMP",
                            "href":"TO_TIMESTAMP.html#GUID-57E09334-E3CC-4CA2-809E-F0909458BCFA"
                        },
                        {
                            "title":"TO_TIMESTAMP_TZ",
                            "href":"TO_TIMESTAMP_TZ.html#GUID-3999303B-89CA-4AA3-9817-458F36ADC9DC"
                        },
                        {
                            "title":"TO_UTC_TIMESTAMP_TZ",
                            "href":"TO_UTC_TIMESTAMP_TZ.html#GUID-1728EE3E-EC0C-4FA8-B404-99C0A445CE82"
                        },
                        {
                            "title":"TO_VECTOR",
                            "href":"to_vector.html#GUID-2CCAB607-A28B-43F7-A71D-9800C0B9A380"
                        },
                        {
                            "title":"TO_YMINTERVAL",
                            "href":"TO_YMINTERVAL.html#GUID-5DEBA096-7AC3-4B18-A4BE-D36FC9BDB450"
                        },
                        {
                            "title":"TRANSLATE",
                            "href":"TRANSLATE.html#GUID-80F85ACB-092C-4CC7-91F6-B3A585E3A690"
                        },
                        {
                            "title":"TRANSLATE ... USING",
                            "href":"TRANSLATE-USING.html#GUID-EC8DE4D2-4F24-456D-A2E7-AD8F82E3A148"
                        },
                        {
                            "title":"TREAT",
                            "href":"TREAT.html#GUID-037C0CD3-C256-4A02-80E0-C6F15147C5BF"
                        },
                        {
                            "title":"TRIM",
                            "href":"TRIM.html#GUID-00D5C77C-19B1-4894-828F-066746235B03"
                        },
                        {
                            "title":"TRUNC (datetime)",
                            "href":"TRUNC-date.html#GUID-BC82227A-2698-4EC8-8C1A-ABECC64B0E79"
                        },
                        {
                            "title":"TRUNC (interval)",
                            "href":"trunc-interval.html#GUID-7719AF9B-5593-4F2B-9B82-03C51AEA693D"
                        },
                        {
                            "title":"TRUNC (number)",
                            "href":"TRUNC-number.html#GUID-911AE7FE-E04A-471D-8B0E-9C50EBEFE07D"
                        },
                        {
                            "title":"TZ_OFFSET",
                            "href":"TZ_OFFSET.html#GUID-D2007072-34C2-4971-BD2B-64D93A3D7A31"
                        },
                        {
                            "title":"UID",
                            "href":"UID.html#GUID-DFDC8E24-B911-4C42-B4B1-853E964D3644"
                        },
                        {
                            "title":"UNISTR",
                            "href":"UNISTR.html#GUID-AAF757DB-6E5D-4548-9E36-6B36BB0BD83E"
                        },
                        {
                            "title":"UPPER",
                            "href":"UPPER.html#GUID-0518FB26-7FE5-43B9-AB31-9352F9F6029C"
                        },
                        {
                            "title":"USER",
                            "href":"USER.html#GUID-AD0B927B-EFD4-4246-89B4-2D55AB3AF531"
                        },
                        {
                            "title":"USERENV",
                            "href":"USERENV.html#GUID-AC3C8AEF-A988-41C4-9242-69B54E5941D2"
                        },
                        {
                            "title":"UUID",
                            "href":"uuid.html#GUID-2A0ECCC2-3DA1-442F-AC9D-A6FE643F381D"
                        },
                        {
                            "title":"UUID_TO_RAW",
                            "href":"uuid_to_raw.html#GUID-B752F910-3319-46C1-AD8E-F29CDEF6D9E5"
                        },
                        {
                            "title":"VALIDATE_CONVERSION",
                            "href":"VALIDATE_CONVERSION.html#GUID-DC485EEB-CB6D-42EF-97AA-4487884CB2CD"
                        },
                        {
                            "title":"VALUE",
                            "href":"VALUE.html#GUID-BEB129A5-525F-4EEF-A79C-261954056234"
                        },
                        {
                            "title":"VAR_POP",
                            "href":"VAR_POP.html#GUID-B62FB4A4-BD1F-47B0-B412-31A98B70C2E4"
                        },
                        {
                            "title":"VAR_SAMP",
                            "href":"VAR_SAMP.html#GUID-314D5831-0E26-4ABF-9F46-35F78F97DA52"
                        },
                        {
                            "title":"VARIANCE",
                            "href":"VARIANCE.html#GUID-EC33717A-2509-402D-B3BB-7EECB2E4ED8B"
                        },
                        {
                            "title":"VECTOR",
                            "href":"vector.html#GUID-8A63005B-5512-4D20-954C-7A9DA877FE4B"
                        },
                        {
                            "title":"VECTOR_CHUNKS",
                            "href":"vector_chunks.html#GUID-5927E2FA-6419-4744-A7CB-3E62DBB027AD"
                        },
                        {
                            "title":"VECTOR_DISTANCE",
                            "href":"vector_distance.html#GUID-BA4BCFB2-D905-43DC-87B0-E53522CF07B7"
                        },
                        {
                            "title":"VECTOR_DIMS",
                            "href":"vector_dims.html#GUID-010349D7-190D-430B-A798-ACC486E1036A"
                        },
                        {
                            "title":"VECTOR_DIMENSION_COUNT",
                            "href":"vector_dimension_count.html#GUID-C3D937E0-7F9F-4C21-A214-0CFA31472E67"
                        },
                        {
                            "title":"VECTOR_DIMENSION_FORMAT",
                            "href":"vector_dimension_format.html#GUID-354ACE80-7120-4D45-B2B0-AB1D86E3D37D"
                        },
                        {
                            "title":"VECTOR_EMBEDDING",
                            "href":"vector_embedding.html#GUID-5ED78260-6D21-4B6B-86E0-A1E70EFA11CA"
                        },
                        {
                            "title":"VECTOR_NORM",
                            "href":"vector_norm.html#GUID-41554068-9EB8-49E8-A771-4E666674DDA8"
                        },
                        {
                            "title":"VECTOR_SERIALIZE",
                            "href":"vector_serialize.html#GUID-9E3FFB34-F924-4C02-B35D-30B9FA1DA1A3"
                        },
                        {
                            "title":"VSIZE",
                            "href":"VSIZE.html#GUID-CDDB2A17-9398-4AF8-96FB-4297DDA2665B"
                        },
                        {
                            "title":"WIDTH_BUCKET",
                            "href":"WIDTH_BUCKET.html#GUID-5E9058E5-A91F-45ED-A90D-E21355D19A88"
                        },
                        {
                            "title":"XMLAGG",
                            "href":"XMLAGG.html#GUID-BCD1D755-5E26-4F73-BA22-521C30D275DA"
                        },
                        {
                            "title":"XMLCAST",
                            "href":"XMLCAST.html#GUID-06563B93-1247-4F0C-B6BE-42DB3B1DB069"
                        },
                        {
                            "title":"XMLCDATA",
                            "href":"XMLCDATA.html#GUID-FB517A52-6F1A-4D8D-B632-F91EFA606691"
                        },
                        {
                            "title":"XMLCOLATTVAL",
                            "href":"XMLCOLATTVAL.html#GUID-AE3B6441-74D8-4033-900B-A578A79E5F0A"
                        },
                        {
                            "title":"XMLCOMMENT",
                            "href":"XMLCOMMENT.html#GUID-AECB7BCC-C60F-4E0C-BD9A-E52D8F1599C4"
                        },
                        {
                            "title":"XMLCONCAT",
                            "href":"XMLCONCAT.html#GUID-CEEEF777-4C7D-41E4-9F69-69DE6D1B07C2"
                        },
                        {
                            "title":"XMLDIFF",
                            "href":"XMLDIFF.html#GUID-B7746C15-27FD-4CAF-87EA-49C0DFA1E935"
                        },
                        {
                            "title":"XMLELEMENT",
                            "href":"XMLELEMENT.html#GUID-DEA75423-00EA-4034-A246-4A774ADC988E"
                        },
                        {
                            "title":"XMLEXISTS",
                            "href":"XMLEXISTS.html#GUID-3D0D90DB-3D4F-4685-AFF6-72B6250624B9"
                        },
                        {
                            "title":"XMLFOREST",
                            "href":"XMLFOREST.html#GUID-68E5C67E-CE97-4BF8-B7FF-2365E062C363"
                        },
                        {
                            "title":"XMLISVALID",
                            "href":"XMLISVALID.html#GUID-012BB50C-30E4-46BA-8199-A8480453F79E"
                        },
                        {
                            "title":"XMLPARSE",
                            "href":"XMLPARSE.html#GUID-39A93E58-F06E-4633-A7BF-6CF27A53D9B6"
                        },
                        {
                            "title":"XMLPATCH",
                            "href":"XMLPATCH.html#GUID-C52DA494-2840-475B-871F-1EA071299894"
                        },
                        {
                            "title":"XMLPI",
                            "href":"XMLPI.html#GUID-142604E3-7999-4803-9DF5-28BDC0701571"
                        },
                        {
                            "title":"XMLQUERY",
                            "href":"XMLQUERY.html#GUID-9E8D3220-2CF5-4C63-BDC2-0526D57B9CDB"
                        },
                        {
                            "title":"XMLSEQUENCE",
                            "href":"XMLSEQUENCE.html#GUID-BE0837A9-7D85-4621-8C22-1FECAD17E569"
                        },
                        {
                            "title":"XMLSERIALIZE",
                            "href":"XMLSERIALIZE.html#GUID-F2D5ECE7-3838-4DD5-BE8F-2AEE7890AA1C"
                        },
                        {
                            "title":"XMLTABLE",
                            "href":"XMLTABLE.html#GUID-C4A32C58-33E5-4CF1-A1FE-039550D3ECFA"
                        },
                        {
                            "title":"XMLTRANSFORM",
                            "href":"XMLTRANSFORM.html#GUID-3B74EED2-E79F-4333-8C0B-02989DF5EEAA"
                        },
                        {
                            "title":"CEIL, FLOOR, ROUND, and TRUNC Date Functions",
                            "href":"ROUND-and-TRUNC-Date-Functions.html#GUID-8E10AB76-21DA-490F-A389-023B648DDEF8"
                        },
                        {
                            "title":"About User-Defined Functions",
                            "href":"About-User-Defined-Functions.html#GUID-4EB3E236-8216-471C-BA44-23D87BDFEA67"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Common SQL DDL Clauses",
                    "href":"Common-SQL-DDL-Clauses.html#GUID-9B312612-AC5E-49FD-9223-005C6597C271",
                    "topics":[
                        {
                            "title":"allocate_extent_clause",
                            "href":"allocate_extent_clause.html#GUID-DA6B3DC2-84B5-4404-AD96-5ABF7341580F"
                        },
                        {
                            "title":"constraint",
                            "href":"constraint.html#GUID-1055EA97-BA6F-4764-A15F-1024FD5B6DFE"
                        },
                        {
                            "title":"deallocate_unused_clause",
                            "href":"deallocate_unused_clause.html#GUID-016A106B-47D4-4FFF-8A3B-2DF19A5FE9FF"
                        },
                        {
                            "title":"file_specification",
                            "href":"file_specification.html#GUID-580FA726-F712-4410-90CF-783A2DA89688"
                        },
                        {
                            "title":"logging_clause",
                            "href":"logging_clause.html#GUID-C4212274-5595-4045-A599-F033772C496E"
                        },
                        {
                            "title":"parallel_clause",
                            "href":"parallel_clause.html#GUID-59C9EBF3-A45E-4EE5-ABE7-0DA0FCF6C4B5"
                        },
                        {
                            "title":"physical_attributes_clause",
                            "href":"physical_attributes_clause.html#GUID-A15063A9-3237-43D3-B0AE-D01F6E80B393"
                        },
                        {
                            "title":"size_clause",
                            "href":"size_clause.html#GUID-E97FADC2-A6E1-4D68-9F79-DCA271B86517"
                        },
                        {
                            "title":"storage_clause",
                            "href":"storage_clause.html#GUID-C5A67610-3160-41E9-8D48-03206BD5ED15"
                        },
                        {
                            "title":"annotations_clause",
                            "href":"annotations_clause.html#GUID-1AC16117-BBB6-4435-8794-2B99F8F68052"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> SQL Queries and Subqueries",
                    "href":"SQL-Queries-and-Subqueries.html#GUID-5937EB2B-D3EC-45D4-BF75-1FC02E45DAE2",
                    "topics":[
                        {
                            "title":"About Queries and Subqueries",
                            "href":"About-Queries-and-Subqueries.html#GUID-DB7521FE-9329-415E-B583-EA4467E990A7"
                        },
                        {
                            "title":"Creating Simple Queries",
                            "href":"Creating-Simple-Queries.html#GUID-DB044D5C-A960-4813-84DA-A1880C913339"
                        },
                        {
                            "title":"Hierarchical Queries",
                            "href":"Hierarchical-Queries.html#GUID-0118DF1D-B9A9-41EB-8556-C6E7D6A5A84E"
                        },
                        {
                            "title":"The Set Operators",
                            "href":"The-UNION-ALL-INTERSECT-MINUS-Operators.html#GUID-B64FE747-586E-4513-945F-80CB197125EE"
                        },
                        {
                            "title":"Sorting Query Results",
                            "href":"Sorting-Query-Results.html#GUID-E45EF993-20AC-4552-860C-4D74EADB5BF2"
                        },
                        {
                            "title":"Joins",
                            "href":"Joins.html#GUID-39081984-8D38-4D64-A847-AA43F515D460"
                        },
                        {
                            "title":"Using Subqueries",
                            "href":"Using-Subqueries.html#GUID-53A705B6-0358-4E2B-92ED-A83DE83DFD20"
                        },
                        {
                            "title":"Unnesting of Nested Subqueries",
                            "href":"Unnesting-of-Nested-Subqueries.html#GUID-DA7A69AA-156D-4F1B-9E29-DAE9D230D9B5"
                        },
                        {
                            "title":"Selecting from the DUAL Table",
                            "href":"Selecting-from-the-DUAL-Table.html#GUID-0AB153FC-5238-4E79-8522-C9E2A04AB5E4"
                        },
                        {
                            "title":"Distributed Queries",
                            "href":"Distributed-Queries.html#GUID-DADE67A5-1C58-4132-9B2F-C14AE9B65508"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> SQL Statements: ADMINISTER KEY MANAGEMENT to ALTER JSON RELATIONAL DUALITY VIEW",
                    "href":"SQL-Statements-ADMINISTER-KEY-MANAGEMENT-to-ALTER-JAVA.html#GUID-04D8EBB3-583D-4969-8344-E221000E9CD9",
                    "topics":[
                        {
                            "title":"Types of SQL Statements",
                            "href":"Types-of-SQL-Statements.html#GUID-E1749EF5-2264-44DF-99EF-AEBEB943BED6"
                        },
                        {
                            "title":"How the SQL Statement Chapters are Organized",
                            "href":"How-the-SQL-Statement-Chapters-are-Organized.html#GUID-8B052D2F-D532-4F8E-8388-BCFEC30B65A8"
                        },
                        {
                            "title":"ADMINISTER KEY MANAGEMENT",
                            "href":"ADMINISTER-KEY-MANAGEMENT.html#GUID-E5B2746F-19DC-4E94-83EC-A6A5C84A3EA9"
                        },
                        {
                            "title":"ALTER ANALYTIC VIEW",
                            "href":"ALTER-ANALYTIC-VIEW.html#GUID-5256BE3A-F134-40D4-8E70-684E073574C8"
                        },
                        {
                            "title":"ALTER ATTRIBUTE DIMENSION",
                            "href":"ALTER-ATTRIBUTE-DIMENSION.html#GUID-F345D0F9-8133-4257-9A07-EDCE558A1332"
                        },
                        {
                            "title":"ALTER AUDIT POLICY (Unified Auditing)",
                            "href":"ALTER-AUDIT-POLICY-Unified-Auditing.html#GUID-CC41B5C2-09F4-40BC-B7FD-3B4C0A3F5437"
                        },
                        {
                            "title":"ALTER CLUSTER",
                            "href":"ALTER-CLUSTER.html#GUID-A4E03C13-7690-4567-9B0A-DA6A21173B4D"
                        },
                        {
                            "title":"ALTER DATABASE",
                            "href":"ALTER-DATABASE.html#GUID-8069872F-E680-4511-ADD8-A4E30AF67986"
                        },
                        {
                            "title":"ALTER DATABASE DICTIONARY",
                            "href":"ALTER-DATABASE-DICTIONARY.html#GUID-27DDB403-7E7F-40EC-9B48-5E3B475E27AE"
                        },
                        {
                            "title":"ALTER DATABASE LINK",
                            "href":"ALTER-DATABASE-LINK.html#GUID-0259D771-9D04-4D86-A94D-61B621A3918A"
                        },
                        {
                            "title":"ALTER DIMENSION",
                            "href":"ALTER-DIMENSION.html#GUID-16B451F9-FF21-4E44-ACCA-2CFFA6F3F0F9"
                        },
                        {
                            "title":"ALTER DISKGROUP",
                            "href":"ALTER-DISKGROUP.html#GUID-22D73AB6-7063-4627-A2ED-18D521ED2557"
                        },
                        {
                            "title":"ALTER DOMAIN",
                            "href":"alter-domain.html#GUID-089B335C-EDC9-4AB6-894E-2EFEFE3F2BDA"
                        },
                        {
                            "title":"ALTER FLASHBACK ARCHIVE",
                            "href":"ALTER-FLASHBACK-ARCHIVE.html#GUID-285814C9-06ED-4BDB-BB19-E2BA6505C850"
                        },
                        {
                            "title":"ALTER FUNCTION",
                            "href":"ALTER-FUNCTION.html#GUID-6FB32876-2DB3-41EB-B0CA-91B163826AB2"
                        },
                        {
                            "title":"ALTER HIERARCHY",
                            "href":"ALTER-HIERARCHY.html#GUID-37A4E442-EE3A-4239-8228-F08A2F666D91"
                        },
                        {
                            "title":"ALTER INDEX",
                            "href":"ALTER-INDEX.html#GUID-D8F648E7-8C07-4C89-BB71-862512536558"
                        },
                        {
                            "title":"ALTER INDEXTYPE",
                            "href":"ALTER-INDEXTYPE.html#GUID-BFA7E29C-7905-4811-9119-B20FD8EA18F2"
                        },
                        {
                            "title":"ALTER INMEMORY JOIN GROUP",
                            "href":"ALTER-INMEMORY-JOIN-GROUP.html#GUID-AF24F413-BB14-4B5D-93BF-9EB31ACFEBEC"
                        },
                        {
                            "title":"ALTER JAVA",
                            "href":"ALTER-JAVA.html#GUID-6B211750-3247-4D71-9533-3DD8F66640CD"
                        },
                        {
                            "title":"ALTER JSON RELATIONAL DUALITY VIEW",
                            "href":"alter-json-relational-duality-view.html#GUID-F5360747-E268-4083-8D29-46073EA4D513"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> SQL Statements: ALTER LIBRARY to ALTER SESSION",
                    "href":"SQL-Statements-ALTER-LIBRARY-to-ALTER-SESSION.html#GUID-B4A1C1D6-D628-40F9-A6B0-A5FB3DB1D0C1",
                    "topics":[
                        {
                            "title":"ALTER LIBRARY",
                            "href":"ALTER-LIBRARY.html#GUID-BB90AF66-3B1F-46C4-9716-4578DE0AE1F3"
                        },
                        {
                            "title":"ALTER LOCKDOWN PROFILE",
                            "href":"ALTER-LOCKDOWN-PROFILE.html#GUID-B4029154-54A8-4B78-97C3-9CED416F1C34"
                        },
                        {
                            "title":"ALTER MATERIALIZED VIEW",
                            "href":"ALTER-MATERIALIZED-VIEW.html#GUID-29EE5682-AE42-4879-ABAD-E34E66ADD233"
                        },
                        {
                            "title":"ALTER MATERIALIZED VIEW LOG",
                            "href":"ALTER-MATERIALIZED-VIEW-LOG.html#GUID-4DAD5E6F-E30A-43D0-B023-634752E0E627"
                        },
                        {
                            "title":"ALTER MATERIALIZED ZONEMAP",
                            "href":"ALTER-MATERIALIZED-ZONEMAP.html#GUID-9330FD16-28B6-4B22-8205-FF59AF250C1A"
                        },
                        {
                            "title":"ALTER MLE ENV",
                            "href":"alter-mle-env.html#GUID-AF0D1253-6FEF-44A7-BEA3-9F24AEFF17C1"
                        },
                        {
                            "title":"ALTER MLE MODULE",
                            "href":"alter-mle-module.html#GUID-9CE0DFB6-68BE-427D-AEEB-294C0FD31F8F"
                        },
                        {
                            "title":"ALTER OPERATOR",
                            "href":"ALTER-OPERATOR.html#GUID-F00A0AC8-36C8-4EAC-A9BB-B3D42C5EEEDE"
                        },
                        {
                            "title":"ALTER OUTLINE",
                            "href":"ALTER-OUTLINE.html#GUID-49F25C82-0783-4407-88BB-613F986C2FEC"
                        },
                        {
                            "title":"ALTER PACKAGE",
                            "href":"ALTER-PACKAGE.html#GUID-47471C4C-03AB-4D78-A295-3D58C91102E0"
                        },
                        {
                            "title":"ALTER PLUGGABLE DATABASE",
                            "href":"ALTER-PLUGGABLE-DATABASE.html#GUID-A29491AD-8F0F-4E52-9D94-57FC3FF8FBC7"
                        },
                        {
                            "title":"ALTER PMEM FILESTORE",
                            "href":"alter-pmem-filestore.html#GUID-330BB1D5-5194-4B09-93AF-B80DBD36774A"
                        },
                        {
                            "title":"ALTER PROCEDURE",
                            "href":"ALTER-PROCEDURE.html#GUID-24A5796F-7D97-49D4-8448-7E541CB73AC6"
                        },
                        {
                            "title":"ALTER PROFILE",
                            "href":"ALTER-PROFILE.html#GUID-7D2EA18A-49F9-40FA-ADE8-BB3D5D5FE4A1"
                        },
                        {
                            "title":"ALTER PROPERTY GRAPH",
                            "href":"alter-property-graph.html#GUID-3437140C-6244-49A2-9305-FBEB4D414761"
                        },
                        {
                            "title":"ALTER RESOURCE COST",
                            "href":"ALTER-RESOURCE-COST.html#GUID-92DCB41E-5113-4722-8A54-E90E1AE7DB54"
                        },
                        {
                            "title":"ALTER ROLE",
                            "href":"ALTER-ROLE.html#GUID-85543272-EAF4-4FED-A921-AD9868102C39"
                        },
                        {
                            "title":"ALTER ROLLBACK SEGMENT",
                            "href":"ALTER-ROLLBACK-SEGMENT.html#GUID-B25701E3-A074-44C4-9018-C6691BEB2483"
                        },
                        {
                            "title":"ALTER SEQUENCE",
                            "href":"ALTER-SEQUENCE.html#GUID-A6468B63-E7C9-4EF0-B048-82FE2449B26D"
                        },
                        {
                            "title":"ALTER SESSION",
                            "href":"ALTER-SESSION.html#GUID-27186B28-7EFC-4998-B1ED-2B905CC0211B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> SQL Statements: ALTER SYNONYM to COMMENT",
                    "href":"SQL-Statements-ALTER-SYNONYM-to-COMMENT.html#GUID-7B9A6386-C065-4D0D-957E-9859DD917A6C",
                    "topics":[
                        {
                            "title":"ALTER SYNONYM",
                            "href":"ALTER-SYNONYM.html#GUID-C31B6804-6783-4A8C-B448-DF78E3FE6837"
                        },
                        {
                            "title":"ALTER SYSTEM",
                            "href":"ALTER-SYSTEM.html#GUID-2C638517-D73A-41CA-9D8E-A62D1A0B7ADB"
                        },
                        {
                            "title":"ALTER TABLE",
                            "href":"ALTER-TABLE.html#GUID-552E7373-BF93-477D-9DA3-B2C9386F2877"
                        },
                        {
                            "title":"ALTER TABLESPACE",
                            "href":"ALTER-TABLESPACE.html#GUID-CA074861-55D3-4768-8995-43D4DA26365D"
                        },
                        {
                            "title":"ALTER TABLESPACE SET",
                            "href":"ALTER-TABLESPACE-SET.html#GUID-63FEDE73-C1F1-4B7A-98ED-8C34C4073549"
                        },
                        {
                            "title":"ALTER TRIGGER",
                            "href":"ALTER-TRIGGER.html#GUID-085BD628-2903-46A3-9850-C0D8ED7F2EEF"
                        },
                        {
                            "title":"ALTER TYPE",
                            "href":"ALTER-TYPE.html#GUID-E0C4E28C-726F-4481-99FE-15AC67342DC9"
                        },
                        {
                            "title":"ALTER USER",
                            "href":"ALTER-USER.html#GUID-9FCD038D-8193-4241-85CD-2F4723B27D44"
                        },
                        {
                            "title":"ALTER VIEW",
                            "href":"ALTER-VIEW.html#GUID-0DEDE960-B481-4B55-8027-EA9E4C863625"
                        },
                        {
                            "title":"ANALYZE",
                            "href":"ANALYZE.html#GUID-535CE98E-2359-4147-839F-DCB3772C1B0E"
                        },
                        {
                            "title":"ASSOCIATE STATISTICS",
                            "href":"ASSOCIATE-STATISTICS.html#GUID-BD02BA6A-32A7-4093-A6B6-BAE860C0F834"
                        },
                        {
                            "title":"AUDIT (Traditional Auditing)",
                            "href":"AUDIT-Traditional-Auditing.html#GUID-ADF45B07-547A-4096-8144-50241FA2D8DD"
                        },
                        {
                            "title":"AUDIT (Unified Auditing)",
                            "href":"AUDIT-Unified-Auditing.html#GUID-B24D6874-4053-4E66-8238-6CD0C87E9DCA"
                        },
                        {
                            "title":"CALL",
                            "href":"CALL.html#GUID-6CD7B9C4-E5DC-4F3C-9B6A-876AD2C63545"
                        },
                        {
                            "title":"COMMENT",
                            "href":"COMMENT.html#GUID-65F447C4-6914-4823-9691-F15D52DB74D7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> SQL Statements: COMMIT to CREATE JSON RELATIONAL DUALITY VIEW",
                    "href":"SQL-Statements-COMMIT-to-CREATE-JAVA.html#GUID-A087EE75-DE65-4AA6-A479-280413DB74C8",
                    "topics":[
                        {
                            "title":"COMMIT",
                            "href":"COMMIT.html#GUID-6CD5C9A7-54B9-4FA2-BA3C-D6B4492B9EE2"
                        },
                        {
                            "title":"CREATE ANALYTIC VIEW",
                            "href":"CREATE-ANALYTIC-VIEW.html#GUID-EBA7E9BC-3F49-4AA7-9EF6-9255FE7AE466"
                        },
                        {
                            "title":"CREATE ATTRIBUTE DIMENSION",
                            "href":"CREATE-ATTRIBUTE-DIMENSION.html#GUID-62722AB0-2136-4BC9-8E76-CBEA13C15196"
                        },
                        {
                            "title":"CREATE AUDIT POLICY (Unified Auditing)",
                            "href":"CREATE-AUDIT-POLICY-Unified-Auditing.html#GUID-8D6961FB-2E50-46F5-81F7-9AEA314FC693"
                        },
                        {
                            "title":"CREATE CLUSTER",
                            "href":"CREATE-CLUSTER.html#GUID-4DBC701F-AFC3-486D-AA32-B5CB1D6946F7"
                        },
                        {
                            "title":"CREATE CONTEXT",
                            "href":"CREATE-CONTEXT.html#GUID-FDF62812-A884-479C-9C1B-5BD6DDEFE7FA"
                        },
                        {
                            "title":"CREATE CONTROLFILE",
                            "href":"CREATE-CONTROLFILE.html#GUID-9B389F28-C4D0-405D-BFE6-48237E8BD791"
                        },
                        {
                            "title":"CREATE DATABASE",
                            "href":"CREATE-DATABASE.html#GUID-ECE717DF-F116-4151-927C-2E51BB9DD39C"
                        },
                        {
                            "title":"CREATE DATABASE LINK",
                            "href":"CREATE-DATABASE-LINK.html#GUID-D966642A-B19E-449D-9968-1121AF06D793"
                        },
                        {
                            "title":"CREATE DIMENSION",
                            "href":"CREATE-DIMENSION.html#GUID-E6CD4CFC-5D06-4A8F-9DF1-C609A7EB8413"
                        },
                        {
                            "title":"CREATE DIRECTORY",
                            "href":"CREATE-DIRECTORY.html#GUID-8E9C569A-1B06-42C4-9586-0EF83437001A"
                        },
                        {
                            "title":"CREATE DISKGROUP",
                            "href":"CREATE-DISKGROUP.html#GUID-039A1373-1F3F-4A53-A152-8EBC348FB880"
                        },
                        {
                            "title":"CREATE DOMAIN",
                            "href":"create-domain.html#GUID-17D3A9C6-D993-4E94-BF6B-CACA56581F41"
                        },
                        {
                            "title":"CREATE EDITION",
                            "href":"CREATE-EDITION.html#GUID-6CF92CA1-CAF7-4967-9B34-C02D72C23617"
                        },
                        {
                            "title":"CREATE FLASHBACK ARCHIVE",
                            "href":"CREATE-FLASHBACK-ARCHIVE.html#GUID-9E821EC5-8350-4729-85FE-2188EBB4139B"
                        },
                        {
                            "title":"CREATE FUNCTION",
                            "href":"CREATE-FUNCTION.html#GUID-156AEDAC-ADD0-4E46-AA56-6D1F7CA63306"
                        },
                        {
                            "title":"CREATE HIERARCHY",
                            "href":"CREATE-HIERARCHY.html#GUID-73925877-992B-4624-AA28-8F565E9C3F0D"
                        },
                        {
                            "title":"CREATE HYBRID VECTOR INDEX",
                            "href":"create-hybrid-vector-index.html#GUID-8CDFC950-44A1-4340-A9C0-07DB9A777867"
                        },
                        {
                            "title":"CREATE INDEX",
                            "href":"CREATE-INDEX.html#GUID-1F89BBC0-825F-4215-AF71-7588E31D8BFE"
                        },
                        {
                            "title":"CREATE INDEXTYPE",
                            "href":"CREATE-INDEXTYPE.html#GUID-4A7BD0EC-B3E5-4D1D-95C5-C8B52D01D8CE"
                        },
                        {
                            "title":"CREATE INMEMORY JOIN GROUP",
                            "href":"CREATE-INMEMORY-JOIN-GROUP.html#GUID-87CA7034-4F80-4D46-8EE1-5CC865C2D676"
                        },
                        {
                            "title":"CREATE JAVA",
                            "href":"CREATE-JAVA.html#GUID-69E13452-1F91-4F98-B154-CF5B1C198387"
                        },
                        {
                            "title":"CREATE JSON RELATIONAL DUALITY VIEW",
                            "href":"create-json-relational-duality-view.html#GUID-64B579AD-BF97-4B27-BF22-94C1FB6FD6DF"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> SQL Statements: CREATE LIBRARY to CREATE SCHEMA",
                    "href":"SQL-Statements-CREATE-LIBRARY-to-CREATE-SCHEMA.html#GUID-B0517B99-DDA2-4F47-8866-46AD944FABF8",
                    "topics":[
                        {
                            "title":"CREATE LIBRARY",
                            "href":"CREATE-LIBRARY.html#GUID-F042ABC9-2BF5-4E65-9D52-216D6228B288"
                        },
                        {
                            "title":"CREATE LOCKDOWN PROFILE",
                            "href":"CREATE-LOCKDOWN-PROFILE.html#GUID-1CDEC3A3-F3F1-4279-9370-36AACF416E0A"
                        },
                        {
                            "title":"CREATE LOGICAL PARTITION TRACKING",
                            "href":"create-logical-partition-tracking.html#GUID-4828A4B0-712A-4BD9-9684-5717E094D450"
                        },
                        {
                            "title":"CREATE MATERIALIZED VIEW",
                            "href":"CREATE-MATERIALIZED-VIEW.html#GUID-EE262CA4-01E5-4618-B659-6165D993CA1B"
                        },
                        {
                            "title":"CREATE MATERIALIZED VIEW LOG",
                            "href":"CREATE-MATERIALIZED-VIEW-LOG.html#GUID-13902019-D044-4B79-9EB4-1F60652D037B"
                        },
                        {
                            "title":"CREATE MATERIALIZED ZONEMAP",
                            "href":"CREATE-MATERIALIZED-ZONEMAP.html#GUID-1E5048FC-3D28-49BC-80FE-7871568B4702"
                        },
                        {
                            "title":"CREATE MLE ENV",
                            "href":"create-mle-env.html#GUID-419C81FD-338D-495F-85CD-135D4D316718"
                        },
                        {
                            "title":"CREATE MLE MODULE",
                            "href":"create-mle-module.html#GUID-EF8D8EBC-2313-4C6C-A76E-1A739C304DCC"
                        },
                        {
                            "title":"CREATE OPERATOR",
                            "href":"CREATE-OPERATOR.html#GUID-62676C58-6F57-4572-8C09-7984A8E3EE9F"
                        },
                        {
                            "title":"CREATE OUTLINE",
                            "href":"CREATE-OUTLINE.html#GUID-7CC033AF-DB19-4616-87D9-8173939FD627"
                        },
                        {
                            "title":"CREATE PACKAGE",
                            "href":"CREATE-PACKAGE.html#GUID-40636655-899F-47D0-95CA-D58A71C94A56"
                        },
                        {
                            "title":"CREATE PACKAGE BODY",
                            "href":"CREATE-PACKAGE-BODY.html#GUID-E571E5A3-1C4B-4246-BF26-0E4348BEB6D6"
                        },
                        {
                            "title":"CREATE PFILE",
                            "href":"CREATE-PFILE.html#GUID-C01CBA1C-F477-49BE-AD58-F2FED046D561"
                        },
                        {
                            "title":"CREATE PLUGGABLE DATABASE",
                            "href":"CREATE-PLUGGABLE-DATABASE.html#GUID-F2DBA8DD-EEA8-4BB7-A07F-78DC04DB1FFC"
                        },
                        {
                            "title":"CREATE PMEM FILESTORE",
                            "href":"create-pmem-filestore.html#GUID-2518DAF0-E174-4593-86C2-D8E48FBED1FE"
                        },
                        {
                            "title":"CREATE PROCEDURE",
                            "href":"CREATE-PROCEDURE.html#GUID-771879D8-BBFD-4D87-8A6C-290102142DA3"
                        },
                        {
                            "title":"CREATE PROFILE",
                            "href":"CREATE-PROFILE.html#GUID-ABC7AE4D-64A8-4EA9-857D-BEF7300B64C3"
                        },
                        {
                            "title":"CREATE PROPERTY GRAPH",
                            "href":"create-property-graph.html#GUID-37364ADB-E89C-4D92-A431-F2544FEDB218"
                        },
                        {
                            "title":"CREATE RESTORE POINT",
                            "href":"CREATE-RESTORE-POINT.html#GUID-AD0FB693-7C28-4908-A870-BA884B320575"
                        },
                        {
                            "title":"CREATE ROLE",
                            "href":"CREATE-ROLE.html#GUID-B2252DC5-5AE7-49B7-9048-98062993E450"
                        },
                        {
                            "title":"CREATE ROLLBACK SEGMENT",
                            "href":"CREATE-ROLLBACK-SEGMENT.html#GUID-14AE3104-5B33-4E53-8E6F-6B2F037B52E9"
                        },
                        {
                            "title":"CREATE SCHEMA",
                            "href":"CREATE-SCHEMA.html#GUID-2D154F9C-9E2B-4A09-B658-2EA5B99AC838"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> SQL Statements: CREATE SEQUENCE to DROP CLUSTER",
                    "href":"SQL-Statements-CREATE-SEQUENCE-to-DROP-CLUSTER.html#GUID-01CD18EA-DF10-4B99-B64A-69BB959EEE59",
                    "topics":[
                        {
                            "title":"CREATE SEQUENCE",
                            "href":"CREATE-SEQUENCE.html#GUID-E9C78A8C-615A-4757-B2A8-5E6EFB130571"
                        },
                        {
                            "title":"CREATE SPFILE",
                            "href":"CREATE-SPFILE.html#GUID-D3E295B7-A3A4-43D3-8BBD-5CBE171A2E52"
                        },
                        {
                            "title":"CREATE SYNONYM",
                            "href":"CREATE-SYNONYM.html#GUID-A806C82F-1171-478E-A910-F9C6C42739B2"
                        },
                        {
                            "title":"CREATE TABLE",
                            "href":"CREATE-TABLE.html#GUID-F9CE0CC3-13AE-4744-A43C-EAC7A71AAAB6"
                        },
                        {
                            "title":"CREATE TABLESPACE",
                            "href":"CREATE-TABLESPACE.html#GUID-51F07BF5-EFAF-4910-9040-C473B86A8BF9"
                        },
                        {
                            "title":"CREATE TABLESPACE SET",
                            "href":"CREATE-TABLESPACE-SET.html#GUID-877951F1-B2A5-4907-9F0F-EF4F1884E8C4"
                        },
                        {
                            "title":"CREATE TRIGGER",
                            "href":"CREATE-TRIGGER.html#GUID-EE0DF3AA-7ADC-4171-B8E8-138BE9224E3B"
                        },
                        {
                            "title":"CREATE TRUE CACHE",
                            "href":"create-true-cache.html#GUID-9CDFE592-D927-427F-A997-B9A50B646A56"
                        },
                        {
                            "title":"CREATE TYPE",
                            "href":"CREATE-TYPE.html#GUID-E72E3EE6-DE95-4F58-8941-E2F76D0EAE80"
                        },
                        {
                            "title":"CREATE TYPE BODY",
                            "href":"CREATE-TYPE-BODY.html#GUID-C4F1591A-6F62-4897-9039-2C3F066F1E9D"
                        },
                        {
                            "title":"CREATE USER",
                            "href":"CREATE-USER.html#GUID-F0246961-558F-480B-AC0F-14B50134621C"
                        },
                        {
                            "title":"CREATE VECTOR INDEX",
                            "href":"create-vector-index.html#GUID-B396C369-54BB-4098-A0DD-7C54B3A0D66F"
                        },
                        {
                            "title":"CREATE VIEW",
                            "href":"CREATE-VIEW.html#GUID-61D2D2B4-DACC-4C7C-89EB-7E50D9594D30"
                        },
                        {
                            "title":"DELETE",
                            "href":"DELETE.html#GUID-156845A5-B626-412B-9F95-8869B988ABD7"
                        },
                        {
                            "title":"DISASSOCIATE STATISTICS",
                            "href":"DISASSOCIATE-STATISTICS.html#GUID-6E9A7D93-E28A-469D-97AB-2BECC2EF3C43"
                        },
                        {
                            "title":"DROP ANALYTIC VIEW",
                            "href":"DROP-ANALYTIC-VIEW.html#GUID-16BF7588-87E8-4324-BCEC-242355245720"
                        },
                        {
                            "title":"DROP ATTRIBUTE DIMENSION",
                            "href":"DROP-ATTRIBUTE-DIMENSION.html#GUID-98D6273D-5F83-4AEC-85AF-7540A710F59D"
                        },
                        {
                            "title":"DROP AUDIT POLICY (Unified Auditing)",
                            "href":"DROP-AUDIT-POLICY-Unified-Auditing.html#GUID-811D3F84-744E-47A1-B69D-C9D2FA4A0844"
                        },
                        {
                            "title":"DROP CLUSTER",
                            "href":"DROP-CLUSTER.html#GUID-531F7DE2-AA2A-400E-BC9A-4CBEEA7B7156"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> SQL Statements: DROP CONTEXT to DROP JAVA",
                    "href":"SQL-Statements-DROP-CONTEXT-to-DROP-JAVA.html#GUID-F06DDEEA-AE25-4912-A8EB-E83F8251BD91",
                    "topics":[
                        {
                            "title":"DROP CONTEXT",
                            "href":"DROP-CONTEXT.html#GUID-1C5C56A8-A3A3-421B-BEC5-C6ECCA0B60D0"
                        },
                        {
                            "title":"DROP DATABASE",
                            "href":"DROP-DATABASE.html#GUID-4FFC1AF5-538D-4882-8979-7A9957492A23"
                        },
                        {
                            "title":"DROP DATABASE LINK",
                            "href":"DROP-DATABASE-LINK.html#GUID-89856C55-29FB-4B52-84A9-E53B8D115864"
                        },
                        {
                            "title":"DROP DIMENSION",
                            "href":"DROP-DIMENSION.html#GUID-658FB451-6759-4777-ACDB-614CFDEFDF80"
                        },
                        {
                            "title":"DROP DIRECTORY",
                            "href":"DROP-DIRECTORY.html#GUID-3719950A-7B6A-4284-8467-B3455ECF8516"
                        },
                        {
                            "title":"DROP DISKGROUP",
                            "href":"DROP-DISKGROUP.html#GUID-6F77FABB-3365-448F-8E2B-9B776904182C"
                        },
                        {
                            "title":"DROP DOMAIN",
                            "href":"drop-domain.html#GUID-E82527C8-5C47-43D0-9C0D-E081E78E612F"
                        },
                        {
                            "title":"DROP EDITION",
                            "href":"DROP-EDITION.html#GUID-726082F7-C931-4975-8F2B-5EA814A51AB0"
                        },
                        {
                            "title":"DROP FLASHBACK ARCHIVE",
                            "href":"DROP-FLASHBACK-ARCHIVE.html#GUID-FFF61E62-28AF-4F7B-BBD7-8D9AC08DDE77"
                        },
                        {
                            "title":"DROP FUNCTION",
                            "href":"DROP-FUNCTION.html#GUID-5BF63D1C-797E-4FB7-BEAB-B02BD7AADAEF"
                        },
                        {
                            "title":"DROP HIERARCHY",
                            "href":"DROP-HIERARCHY.html#GUID-03DD165D-EDCC-484F-B79B-D56447587669"
                        },
                        {
                            "title":"DROP INDEX",
                            "href":"DROP-INDEX.html#GUID-F60F75DF-2866-4F93-BB7F-8FCE64BF67B6"
                        },
                        {
                            "title":"DROP INDEXTYPE",
                            "href":"DROP-INDEXTYPE.html#GUID-36D05D07-72C4-48F9-B27D-7C4BBD2C1A81"
                        },
                        {
                            "title":"DROP INMEMORY JOIN GROUP",
                            "href":"DROP-INMEMORY-JOIN-GROUP.html#GUID-520D0E9A-B577-4BCD-B6CB-8EB448C0686D"
                        },
                        {
                            "title":"DROP JAVA",
                            "href":"DROP-JAVA.html#GUID-0D24ADCD-01C8-4FB0-B14C-F5D9FB25E321"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> SQL Statements: DROP LIBRARY to DROP SYNONYM",
                    "href":"SQL-Statements-DROP-LIBRARY-to-DROP-SYNONYM.html#GUID-A1F5C322-5D22-4989-91A7-59C8F3ECC419",
                    "topics":[
                        {
                            "title":"DROP LIBRARY",
                            "href":"DROP-LIBRARY.html#GUID-82F45872-78AD-4125-8D14-EE6A69E2738D"
                        },
                        {
                            "title":"DROP LOCKDOWN PROFILE",
                            "href":"DROP-LOCKDOWN-PROFILE.html#GUID-62D428C1-5081-43CA-B45D-7FF1B81363E7"
                        },
                        {
                            "title":"DROP MATERIALIZED VIEW",
                            "href":"DROP-MATERIALIZED-VIEW.html#GUID-187B88E0-F84A-44DB-8F4D-F477586FD22B"
                        },
                        {
                            "title":"DROP MATERIALIZED VIEW LOG",
                            "href":"DROP-MATERIALIZED-VIEW-LOG.html#GUID-878A08F7-CB95-4911-BE2E-9FEED8861410"
                        },
                        {
                            "title":"DROP MATERIALIZED ZONEMAP",
                            "href":"DROP-MATERIALIZED-ZONEMAP.html#GUID-818B228D-9849-4C0C-944E-7A8DEF04A2D0"
                        },
                        {
                            "title":"DROP MLE ENV",
                            "href":"drop-mle-env.html#GUID-19AD5DA2-10B0-46D7-BBEF-6313B6A79425"
                        },
                        {
                            "title":"DROP MLE MODULE",
                            "href":"drop-mle-module.html#GUID-1E3DEB27-76D6-4564-BC3F-B11DB02609A7"
                        },
                        {
                            "title":"DROP OPERATOR",
                            "href":"DROP-OPERATOR.html#GUID-48E60BB4-9490-4B8B-B08E-D17EAEBDDD7E"
                        },
                        {
                            "title":"DROP OUTLINE",
                            "href":"DROP-OUTLINE.html#GUID-776F36E0-1905-48DC-9062-FBFAD5E1C36F"
                        },
                        {
                            "title":"DROP PACKAGE",
                            "href":"DROP-PACKAGE.html#GUID-FAE96214-2ED0-4130-8ACA-A077C7A90B23"
                        },
                        {
                            "title":"DROP PLUGGABLE DATABASE",
                            "href":"DROP-PLUGGABLE-DATABASE.html#GUID-4A663783-E184-417A-8BE1-703E1CDBA30B"
                        },
                        {
                            "title":"DROP PMEM FILESTORE",
                            "href":"drop-pmem-filestore.html#GUID-BA62AE81-AA2A-444E-BB46-57B7FB526EFC"
                        },
                        {
                            "title":"DROP PROCEDURE",
                            "href":"DROP-PROCEDURE.html#GUID-D7F2B5AD-DEEE-466B-B6D3-B765EB897DCB"
                        },
                        {
                            "title":"DROP PROFILE",
                            "href":"DROP-PROFILE.html#GUID-2892A481-F2C8-4B62-8960-E593D1150D83"
                        },
                        {
                            "title":"DROP PROPERTY GRAPH",
                            "href":"drop-property-graph.html#GUID-4B091B93-3681-4CB9-BFDC-A21000AD3637"
                        },
                        {
                            "title":"DROP RESTORE POINT",
                            "href":"DROP-RESTORE-POINT.html#GUID-5FC039A9-46C8-4604-8985-C29CB617798C"
                        },
                        {
                            "title":"DROP ROLE",
                            "href":"DROP-ROLE.html#GUID-F5DEDFAF-EDE6-4733-8E17-C5B94E3168DB"
                        },
                        {
                            "title":"DROP ROLLBACK SEGMENT",
                            "href":"DROP-ROLLBACK-SEGMENT.html#GUID-26B4C9D6-EFB4-4523-B84D-FAD42060D3D4"
                        },
                        {
                            "title":"DROP SEQUENCE",
                            "href":"DROP-SEQUENCE.html#GUID-32B640EE-47C9-46A7-9746-6125BAF8FF8C"
                        },
                        {
                            "title":"DROP SYNONYM",
                            "href":"DROP-SYNONYM.html#GUID-C7293D40-83B8-4E60-9E90-CB907F2CA6C7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> SQL Statements: DROP TABLE to LOCK TABLE",
                    "href":"SQL-Statements-DROP-TABLE-to-LOCK-TABLE.html#GUID-4DF57957-21B8-4033-A87B-1F37F27FD572",
                    "topics":[
                        {
                            "title":"DROP TABLE",
                            "href":"DROP-TABLE.html#GUID-39D89EDC-155D-4A24-837E-D45DDA757B45"
                        },
                        {
                            "title":"DROP TABLESPACE",
                            "href":"DROP-TABLESPACE.html#GUID-C91F3E94-4503-48DE-9BCA-42E495E6BE11"
                        },
                        {
                            "title":"DROP TABLESPACE SET",
                            "href":"DROP-TABLESPACE-SET.html#GUID-B14EC4C4-87C2-4E79-AB1A-044B620DF1FE"
                        },
                        {
                            "title":"DROP TRIGGER",
                            "href":"DROP-TRIGGER.html#GUID-724AC8BC-0428-43D3-8F11-4D4AD8DC2984"
                        },
                        {
                            "title":"DROP TYPE",
                            "href":"DROP-TYPE.html#GUID-2CBA2EFD-1B01-46A8-A4CD-B2975D3A1D67"
                        },
                        {
                            "title":"DROP TYPE BODY",
                            "href":"DROP-TYPE-BODY.html#GUID-9D661F88-2174-4D21-87CA-CC6A36385C05"
                        },
                        {
                            "title":"DROP USER",
                            "href":"DROP-USER.html#GUID-F766E1A2-6686-4734-89BA-0C5B4120B90E"
                        },
                        {
                            "title":"DROP VIEW",
                            "href":"DROP-VIEW.html#GUID-1A1BD841-66B9-47E4-896F-D36E075AE296"
                        },
                        {
                            "title":"EXPLAIN PLAN",
                            "href":"EXPLAIN-PLAN.html#GUID-FD540872-4ED3-4936-96A2-362539931BA0"
                        },
                        {
                            "title":"FLASHBACK DATABASE",
                            "href":"FLASHBACK-DATABASE.html#GUID-BE0ACF9A-BC13-4810-B08B-33326440258B"
                        },
                        {
                            "title":"FLASHBACK TABLE",
                            "href":"FLASHBACK-TABLE.html#GUID-FA9AF2FD-2DAD-4387-9E62-14AFC26EA85C"
                        },
                        {
                            "title":"GRANT",
                            "href":"GRANT.html#GUID-20B4E2C0-A7F8-4BC8-A5E8-BE61BDC41AC3"
                        },
                        {
                            "title":"INSERT",
                            "href":"INSERT.html#GUID-903F8043-0254-4EE9-ACC1-CB8AC0AF3423"
                        },
                        {
                            "title":"LOCK TABLE",
                            "href":"LOCK-TABLE.html#GUID-4C00C6D9-C5C5-46CC-AD33-A64001744A4C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> SQL Statements: MERGE to UPDATE",
                    "href":"SQL-Statements-MERGE-to-UPDATE.html#GUID-07BBB875-6272-441A-893F-35E2F9CA58ED",
                    "topics":[
                        {
                            "title":"MERGE",
                            "href":"MERGE.html#GUID-5692CCB7-24D9-4C0E-81A7-A22436DC968F"
                        },
                        {
                            "title":"NOAUDIT (Traditional Auditing)",
                            "href":"NOAUDIT-Traditional-Auditing.html#GUID-9D8EAF18-4AB3-4C04-8BF7-37BD0E15434D"
                        },
                        {
                            "title":"NOAUDIT (Unified Auditing)",
                            "href":"NOAUDIT-Unified-Auditing.html#GUID-EB92BE04-B09C-493F-952E-9629E739900E"
                        },
                        {
                            "title":"PURGE",
                            "href":"PURGE.html#GUID-9257F773-E019-4464-80F4-F5AB61D7D9B6"
                        },
                        {
                            "title":"RENAME",
                            "href":"RENAME.html#GUID-573347CE-3EB8-42E5-B4D5-EF71CA06FAFC"
                        },
                        {
                            "title":"REVOKE",
                            "href":"REVOKE.html#GUID-BAAD2331-40A5-4366-86CA-BAA6B957E866"
                        },
                        {
                            "title":"ROLLBACK",
                            "href":"ROLLBACK.html#GUID-94551F0C-A47F-43DE-BC68-9B1C1ED38C93"
                        },
                        {
                            "title":"SAVEPOINT",
                            "href":"SAVEPOINT.html#GUID-78EEA746-0021-42E8-9971-3BA6DFFEE794"
                        },
                        {
                            "title":"SELECT",
                            "href":"SELECT.html#GUID-CFA006CA-6FF1-4972-821E-6996142A51C6"
                        },
                        {
                            "title":"SET CONSTRAINT[S]",
                            "href":"SET-CONSTRAINTS.html#GUID-1EF5B212-17C5-4F7C-9412-D777DFDEDCE9"
                        },
                        {
                            "title":"SET ROLE",
                            "href":"SET-ROLE.html#GUID-863F9B6F-82B4-4C49-8E3A-3BA33AE79CAB"
                        },
                        {
                            "title":"SET TRANSACTION",
                            "href":"SET-TRANSACTION.html#GUID-F11E1E30-5871-48D1-8266-F80A1DF126A1"
                        },
                        {
                            "title":"TRUNCATE CLUSTER",
                            "href":"TRUNCATE-CLUSTER.html#GUID-90C16956-644E-4E28-A53D-BB34ED630561"
                        },
                        {
                            "title":"TRUNCATE TABLE",
                            "href":"TRUNCATE-TABLE.html#GUID-B76E5846-75B5-4876-98EC-439E15E4D8A4"
                        },
                        {
                            "title":"UPDATE",
                            "href":"UPDATE.html#GUID-027A462D-379D-4E35-8611-410F3AC8FDA5"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> How to Read Syntax Diagrams",
                    "href":"How-to-Read-Syntax-Diagrams.html#GUID-6DFBA035-DBCB-4F37-984D-37E9EBC1038B",
                    "topics":[
                        {
                            "title":"Graphic Syntax Diagrams",
                            "href":"Graphic-Syntax-Diagrams.html#GUID-D22097D5-1E7A-4A17-862A-F0084732B3CE"
                        },
                        {
                            "title":"Backus-Naur Form Syntax",
                            "href":"Backus-Naur-Form-Syntax.html#GUID-A4C08C40-8E2B-43F9-A2AA-9953288D4230"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Automatic and Manual Locking Mechanisms During SQL Operations",
                    "href":"Automatic-and-Manual-Locking-Mechanisms-During-SQL-Operations.html#GUID-0304C4AA-BD28-4C2A-B7F5-267532FB9499",
                    "topics":[
                        {
                            "title":"Automatic Locks in DML Operations",
                            "href":"Automatic-Locks-in-DML-Operations.html#GUID-3D57596F-8B73-4C80-8F4D-79A12F781EFD"
                        },
                        {
                            "title":"Automatic Locks in DDL Operations",
                            "href":"Automatic-Locks-in-DDL-Operations.html#GUID-84D392A3-94EC-444D-950F-7829DBCD43EE"
                        },
                        {
                            "title":"Manual Data Locking",
                            "href":"Manual-Data-Locking.html#GUID-B1DE7D59-7FD1-4971-B98D-B69529DF7688"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Oracle and Standard SQL",
                    "href":"Oracle-and-Standard-SQL.html#GUID-330DEBBB-006E-4B35-A516-5C0AEFFE06B9",
                    "topics":[
                        {
                            "title":"ANSI Standards",
                            "href":"ANSI-Standards.html#GUID-F51EA195-0669-4DED-9D81-B7205AAC642F"
                        },
                        {
                            "title":"ISO Standards",
                            "href":"ISO-Standards.html#GUID-BBCB4C70-C6CD-4AC7-A2C6-1D1B32732931"
                        },
                        {
                            "title":"Oracle Compliance to Core SQL",
                            "href":"Oracle-Compliance-To-Core-SQL2011.html#GUID-D372D906-805B-49B8-824A-D4697B05B7F8"
                        },
                        {
                            "title":"Oracle Support for Optional Features of SQL/Foundation",
                            "href":"Oracle-Support-for-Optional-Features-of-SQLFoundation2011.html#GUID-3BA98AEC-FAAD-4F21-A6AD-F696B5D36D56"
                        },
                        {
                            "title":"Oracle Compliance with SQL/CLI",
                            "href":"Oracle-Compliance-with-SQLCLI2008.html#GUID-C02FD016-90DB-408E-B9E8-AAB18582DBD7"
                        },
                        {
                            "title":"Oracle Compliance with SQL/PSM",
                            "href":"Oracle-Compliance-with-SQLPSM2011.html#GUID-651F9066-1511-407B-A002-C04AB2F2A534"
                        },
                        {
                            "title":"Oracle Compliance with SQL/MED",
                            "href":"Oracle-Compliance-with-SQLMED2008.html#GUID-F484CC68-C6DF-4587-ACAB-1ACD313DCE43"
                        },
                        {
                            "title":"Oracle Compliance with SQL/OLB",
                            "href":"Oracle-Compliance-with-SQLOLB2008.html#GUID-79118C02-7279-4582-BDFA-8EFF1EE8BB90"
                        },
                        {
                            "title":"Oracle Compliance with SQL/JRT",
                            "href":"Oracle-Compliance-with-SQLJRT2008.html#GUID-DD68745D-EC08-48B1-AB5D-E24CAEE3AEC3"
                        },
                        {
                            "title":"Oracle Compliance with SQL/XML",
                            "href":"Oracle-Compliance-with-SQLXML2011.html#GUID-0D0F19C8-0FB7-4FDD-A55B-18839F340E17"
                        },
                        {
                            "title":"Oracle Compliance with SQL/MDA",
                            "href":"oracle-compliance-sql-mda.html#GUID-19127687-62CB-445F-B384-D8E5FC6C4BBA"
                        },
                        {
                            "title":"Oracle Compliance with SQL/PGQ",
                            "href":"oracle-compliance-sql-pgq.html#GUID-2984AEEA-BB05-4209-B144-57DB2B8D5878"
                        },
                        {
                            "title":"Oracle Compliance with FIPS 127-2",
                            "href":"Oracle-Compliance-with-FIPS-127-2.html#GUID-17C40E8F-D8E4-42BE-B552-9B6AB8A98CCB"
                        },
                        {
                            "title":"Oracle Extensions to Standard SQL",
                            "href":"Oracle-Extensions-to-Standard-SQL.html#GUID-7D3A5F6C-79D4-4B71-AEC3-7AB847DF0989"
                        },
                        {
                            "title":"Oracle Compliance with Older Standards",
                            "href":"Oracle-Compliance-with-Older-Standards.html#GUID-738EFE64-D6DC-41E2-B1D8-29C706DC060F"
                        },
                        {
                            "title":"Character Set Support",
                            "href":"Character-Set-Support.html#GUID-7625CE74-9C1F-4CC8-A223-43B8D53776E0"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">D </span> Oracle Regular Expression Support",
                    "href":"Oracle-Regular-Expression-Support.html#GUID-969230D6-FC1A-4C75-BF2A-6B1BE909DED6",
                    "topics":[
                        {
                            "title":"Multilingual Regular Expression Syntax",
                            "href":"Multilingual-Regular-Expression-Syntax.html#GUID-B03DEEAC-3F9E-4BFD-89D5-F481EA391D7C"
                        },
                        {
                            "title":"Regular Expression Operator Multilingual Enhancements",
                            "href":"Regular-Expression-Operator-Multilingual-Enhancements.html#GUID-8A02D839-90A5-4FB6-AC43-7AE8CB08E8BA"
                        },
                        {
                            "title":"Perl-influenced Extensions in Oracle Regular Expressions",
                            "href":"Perl-influenced-Extensions-in-Oracle-Regular-Expressions.html#GUID-2D2B8DEB-1343-4DA3-BBC1-5A5C79A5FC20"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">E </span> Oracle SQL Reserved Words and Keywords",
                    "href":"Oracle-SQL-Reserved-Words-and-Keywords.html#GUID-6A07BB21-AD82-4B47-80FA-9B1141CC23C2",
                    "topics":[
                        {
                            "title":"Oracle SQL Reserved Words",
                            "href":"Oracle-SQL-Reserved-Words.html#GUID-55C49D1E-BE08-4C50-A9DD-8593EB925612"
                        },
                        {
                            "title":"Oracle SQL Keywords",
                            "href":"Oracle-SQL-Keywords.html#GUID-82EA000B-5661-41EB-AAF7-6BDDB4AB58EE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">F </span> Extended Examples",
                    "href":"Extended-Examples.html#GUID-8FE85432-DF49-4C26-9785-1F1363FBE8B1",
                    "topics":[
                        {
                            "title":"Using Extensible Indexing",
                            "href":"Using-Extensible-Indexing.html#GUID-BEAC690B-1FA4-4B31-9B28-FEAF45A01665"
                        },
                        {
                            "title":"Using XML in SQL Statements",
                            "href":"Using-XML-in-SQL-Statements.html#GUID-5FE21EC9-1F66-45F1-9FD8-ECA5336EDC14"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});