define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Audience",
                            "href":"audience.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Related Documents",
                            "href":"related-documents.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"conventions.html"
                        }
                    ]
                },
                {
                    "title":"Changes in This Release for Oracle AI Database Get Started with Performance Tuning",
                    "href":"changes-this-release-oracle-database-2-day-performance-tuning-guide.html",
                    "topics":[
                        {
                            "title":"Changes in Oracle AI Database Release 26ai",
                            "href":"changes-oracle-ai-database-26ai.html"
                        },
                        {
                            "title":"Changes in Oracle Database Release 19c, Version 19.1",
                            "href":"changes-oracle-database-19.1.html",
                            "topics":[
                                {
                                    "title":"New Features",
                                    "href":"new-features-19.1.html"
                                },
                                {
                                    "title":"Desupported Features",
                                    "href":"desupported-features-19.1.html"
                                }
                            ]
                        },
                        {
                            "title":"Changes in Oracle Database Release 18c, Version 18.1",
                            "href":"changes-oracle-database-18.1.html"
                        },
                        {
                            "title":"Changes in Oracle Database 12c Release 2 (12.2)",
                            "href":"changes-oracle-database-12c-release-2-12.2.html"
                        },
                        {
                            "title":"Changes in Oracle Database 12c Release 1 (12.1.0.2)",
                            "href":"changes-oracle-database-12c-release-1-12.1.0.2.html",
                            "topics":[
                                {
                                    "title":"New Features",
                                    "href":"new-features1.html"
                                },
                                {
                                    "title":"Other Changes",
                                    "href":"other-changes1.html"
                                }
                            ]
                        },
                        {
                            "title":"Changes in Oracle Database 12c Release 1 (12.1.0.1)",
                            "href":"changes-oracle-database-12c-release-1-12.1.0.1.html",
                            "topics":[
                                {
                                    "title":"New Features",
                                    "href":"new-features.html"
                                },
                                {
                                    "title":"Desupported Features",
                                    "href":"desupported-features.html"
                                },
                                {
                                    "title":"Other Changes",
                                    "href":"other-changes.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part I Getting Started",
                    "href":"getting-started.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> Introduction",
                            "href":"introduction.html",
                            "topics":[
                                {
                                    "title":"About This Guide",
                                    "href":"this-guide.html"
                                },
                                {
                                    "title":"Common Oracle DBA Tasks",
                                    "href":"common-oracle-dba-tasks.html"
                                },
                                {
                                    "title":"Tools for Tuning the Database",
                                    "href":"tools-tuning-database.html"
                                },
                                {
                                    "title":"Accessing the Database Home Page",
                                    "href":"accessing-database-home-page.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> Oracle AI Database Performance Method",
                            "href":"oracle-database-performance-method.html",
                            "topics":[
                                {
                                    "title":"Gathering Database Statistics Using the Automatic Workload Repository",
                                    "href":"gathering-database-statistics-using-automatic-workload-repository.html",
                                    "topics":[
                                        {
                                            "title":"Time Model Statistics",
                                            "href":"time-model-statistics.html"
                                        },
                                        {
                                            "title":"Wait Event Statistics",
                                            "href":"wait-event-statistics.html"
                                        },
                                        {
                                            "title":"Session and System Statistics",
                                            "href":"session-and-system-statistics.html"
                                        },
                                        {
                                            "title":"Active Session History Statistics",
                                            "href":"active-session-history-statistics.html"
                                        },
                                        {
                                            "title":"High-Load SQL Statistics",
                                            "href":"high-load-sql-statistics.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Using the Oracle Performance Method",
                                    "href":"using-oracle-performance-method.html",
                                    "topics":[
                                        {
                                            "title":"Preparing the Database for Tuning",
                                            "href":"preparing-database-tuning.html"
                                        },
                                        {
                                            "title":"Tuning the Database Proactively",
                                            "href":"tuning-database-proactively.html"
                                        },
                                        {
                                            "title":"Tuning the Database Reactively",
                                            "href":"tuning-database-reactively.html"
                                        },
                                        {
                                            "title":"Tuning SQL Statements",
                                            "href":"tuning-sql-statements1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Common Performance Problems Found in Databases",
                                    "href":"common-performance-problems-found-databases.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part II Proactive Database Tuning",
                    "href":"proactive-database-tuning.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3 </span> Automatic Database Performance Monitoring",
                            "href":"automatic-database-performance-monitoring.html",
                            "topics":[
                                {
                                    "title":"Overview of Automatic Database Diagnostic Monitor",
                                    "href":"overview-automatic-database-diagnostic-monitor.html",
                                    "topics":[
                                        {
                                            "title":"ADDM Analysis",
                                            "href":"addm-analysis.html"
                                        },
                                        {
                                            "title":"ADDM Recommendations",
                                            "href":"addm-recommendations.html"
                                        },
                                        {
                                            "title":"ADDM for Oracle Real Application Clusters",
                                            "href":"addm-oracle-real-application-clusters.html"
                                        },
                                        {
                                            "title":"ADDM for a Multitenant Environment",
                                            "href":"addm-oracle-multitenant-environment.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Configuring Automatic Database Diagnostic Monitor",
                                    "href":"configuring-automatic-database-diagnostic-monitor.html",
                                    "topics":[
                                        {
                                            "title":"Setting Initialization Parameters to Enable ADDM",
                                            "href":"setting-initialization-parameters-enable-addm.html"
                                        },
                                        {
                                            "title":"Setting the DBIO_EXPECTED Parameter",
                                            "href":"setting-dbio_expected-parameter.html"
                                        },
                                        {
                                            "title":"Managing AWR Snapshots",
                                            "href":"managing-awr-snapshots.html",
                                            "topics":[
                                                {
                                                    "title":"Creating Snapshots",
                                                    "href":"creating-snapshots.html"
                                                },
                                                {
                                                    "title":"Modifying Snapshot Settings",
                                                    "href":"modifying-snapshot-settings.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Reviewing the Automatic Database Diagnostic Monitor Analysis",
                                    "href":"reviewing-automatic-database-diagnostic-monitor-analysis.html"
                                },
                                {
                                    "title":"Interpretation of Automatic Database Diagnostic Monitor Findings",
                                    "href":"interpretation-automatic-database-diagnostic-monitor-findings.html"
                                },
                                {
                                    "title":"Implementing Automatic Database Diagnostic Monitor Recommendations",
                                    "href":"implementing-automatic-database-diagnostic-monitor-recommendations.html"
                                },
                                {
                                    "title":"Viewing Snapshot Statistics",
                                    "href":"viewing-snapshot-statistics.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> Monitoring Real-Time Database Performance",
                            "href":"monitoring-real-time-database-performance.html",
                            "topics":[
                                {
                                    "title":"Monitoring User Activity",
                                    "href":"monitoring-user-activity.html",
                                    "topics":[
                                        {
                                            "title":"Monitoring Top Dimensions",
                                            "href":"monitoring-top-dimensions.html"
                                        },
                                        {
                                            "title":"Monitoring SQL",
                                            "href":"monitoring-sql.html"
                                        },
                                        {
                                            "title":"Monitoring PL/SQL",
                                            "href":"monitoring-pl-sql.html"
                                        },
                                        {
                                            "title":"Monitoring Resource Consumption",
                                            "href":"monitoring-resource-consumption.html"
                                        },
                                        {
                                            "title":"Monitoring Session Identifiers",
                                            "href":"monitoring-session-identifiers.html"
                                        },
                                        {
                                            "title":"Monitoring Session Attributes",
                                            "href":"monitoring-session-attributes.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Monitoring Instance Activity",
                                    "href":"monitoring-instance-activity.html",
                                    "topics":[
                                        {
                                            "title":"Monitoring Throughput",
                                            "href":"monitoring-throughput.html"
                                        },
                                        {
                                            "title":"Monitoring I/O",
                                            "href":"monitoring-i-o.html",
                                            "topics":[
                                                {
                                                    "title":"Monitoring I/O by Function",
                                                    "href":"monitoring-i-o-function.html"
                                                },
                                                {
                                                    "title":"Monitoring I/O by Type",
                                                    "href":"monitoring-i-o-type.html"
                                                },
                                                {
                                                    "title":"Monitoring I/O by Consumer Group",
                                                    "href":"monitoring-i-o-consumer-group.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Monitoring Parallel Execution",
                                            "href":"monitoring-parallel-execution.html"
                                        },
                                        {
                                            "title":"Monitoring Services",
                                            "href":"monitoring-services.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Monitoring Host Activity",
                                    "href":"monitoring-host-activity.html",
                                    "topics":[
                                        {
                                            "title":"Monitoring CPU Utilization",
                                            "href":"monitoring-cpu-utilization.html"
                                        },
                                        {
                                            "title":"Monitoring Memory Utilization",
                                            "href":"monitoring-memory-utilization.html"
                                        },
                                        {
                                            "title":"Monitoring Disk I/O Utilization",
                                            "href":"monitoring-disk-i-o-utilization.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Determining the Cause of Spikes in Database Activity",
                                    "href":"determining-cause-spikes-database-activity.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5 </span> Monitoring Real-Time Database Operations",
                            "href":"monitoring-real-time-database-operations.html",
                            "topics":[
                                {
                                    "title":"About Monitoring Database Operations",
                                    "href":"monitoring-database-operations.html",
                                    "topics":[
                                        {
                                            "title":"Types of Database Operations",
                                            "href":"types-database-operations.html"
                                        },
                                        {
                                            "title":"Purposes of Monitoring Database Operations",
                                            "href":"purposes-monitoring-database-operations.html"
                                        },
                                        {
                                            "title":"Enabling Monitoring of Database Operations",
                                            "href":"enabling-monitoring-database-operations.html"
                                        },
                                        {
                                            "title":"Attributes of Database Operations",
                                            "href":"attributes-database-operations.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Creating a Database Operation",
                                    "href":"creating-database-operation.html"
                                },
                                {
                                    "title":"Monitoring Database Operations in Cloud Control",
                                    "href":"monitoring-database-operations-cloud-control.html",
                                    "topics":[
                                        {
                                            "title":"Viewing SQL Execution Details for a Composite Database Operation",
                                            "href":"viewing-sql-execution-details-composite-database-operation.html"
                                        },
                                        {
                                            "title":"Viewing SQL Execution Details for a SQL Statement",
                                            "href":"viewing-sql-execution-details-sql-statement.html"
                                        },
                                        {
                                            "title":"Viewing SQL Execution Details for a PL/SQL Statement",
                                            "href":"viewing-sql-execution-details-pl-sql-statement.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6 </span> Monitoring Performance Alerts",
                            "href":"monitoring-performance-alerts.html",
                            "topics":[
                                {
                                    "title":"Setting Metric Thresholds for Performance Alerts",
                                    "href":"setting-metric-thresholds-performance-alerts.html"
                                },
                                {
                                    "title":"Responding to Alerts",
                                    "href":"responding-alerts.html"
                                },
                                {
                                    "title":"Clearing Alerts",
                                    "href":"clearing-alerts.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part III Reactive Database Tuning",
                    "href":"reactive-database-tuning.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7 </span> Manual Database Performance Monitoring",
                            "href":"manual-database-performance-monitoring.html",
                            "topics":[
                                {
                                    "title":"Manually Running ADDM to Analyze Current Database Performance",
                                    "href":"manually-running-addm-analyze-current-database-performance.html"
                                },
                                {
                                    "title":"Manually Running ADDM to Analyze Historical Database Performance",
                                    "href":"manually-running-addm-analyze-historical-database-performance.html"
                                },
                                {
                                    "title":"Accessing Previous ADDM Results",
                                    "href":"accessing-previous-addm-results.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8 </span> Resolving Transient Performance Problems",
                            "href":"resolving-transient-performance-problems.html",
                            "topics":[
                                {
                                    "title":"Overview of Active Session History",
                                    "href":"overview-active-session-history.html"
                                },
                                {
                                    "title":"Running Active Session History Reports",
                                    "href":"running-active-session-history-reports.html"
                                },
                                {
                                    "title":"Active Session History Reports",
                                    "href":"active-session-history-reports.html",
                                    "topics":[
                                        {
                                            "title":"Top Events",
                                            "href":"top-events.html",
                                            "topics":[
                                                {
                                                    "title":"Top User Events",
                                                    "href":"top-user-events.html"
                                                },
                                                {
                                                    "title":"Top Background Events",
                                                    "href":"top-background-events.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Load Profile",
                                            "href":"load-profile1.html"
                                        },
                                        {
                                            "title":"Top SQL",
                                            "href":"top-sql.html"
                                        },
                                        {
                                            "title":"Top Sessions",
                                            "href":"top-sessions.html"
                                        },
                                        {
                                            "title":"Top DB Objects/Files/Latches",
                                            "href":"top-db-objects-files-latches.html",
                                            "topics":[
                                                {
                                                    "title":"Top DB Objects",
                                                    "href":"top-db-objects.html"
                                                },
                                                {
                                                    "title":"Top DB Files",
                                                    "href":"top-db-files.html"
                                                },
                                                {
                                                    "title":"Top Latches",
                                                    "href":"top-latches.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Activity Over Time",
                                            "href":"activity-time.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9 </span> Resolving Performance Degradation Over Time",
                            "href":"resolving-performance-degradation-time.html",
                            "topics":[
                                {
                                    "title":"Managing Baselines",
                                    "href":"managing-baselines.html",
                                    "topics":[
                                        {
                                            "title":"Creating a Baseline",
                                            "href":"creating-baseline.html",
                                            "topics":[
                                                {
                                                    "title":"Creating a Single Baseline",
                                                    "href":"creating-single-baseline.html"
                                                },
                                                {
                                                    "title":"Creating a Repeating Baseline",
                                                    "href":"creating-repeating-baseline.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Deleting a Baseline",
                                            "href":"deleting-baseline.html"
                                        },
                                        {
                                            "title":"Setting Metric Thresholds for Baselines",
                                            "href":"setting-metric-thresholds-baselines.html",
                                            "topics":[
                                                {
                                                    "title":"Setting Metric Thresholds for the Default Moving Baseline",
                                                    "href":"setting-metric-thresholds-default-moving-baseline.html"
                                                },
                                                {
                                                    "title":"Setting Metric Thresholds for Selected Baselines",
                                                    "href":"setting-metric-thresholds-selected-baselines.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Running the AWR Compare Periods Reports",
                                    "href":"running-awr-compare-periods-reports.html",
                                    "topics":[
                                        {
                                            "title":"Comparing a Baseline to Another Baseline or Pair of Snapshots",
                                            "href":"comparing-baseline-another-baseline-or-pair-snapshots.html"
                                        },
                                        {
                                            "title":"Comparing Current System Performance to a Baseline Period",
                                            "href":"comparing-current-system-performance-baseline-period.html"
                                        },
                                        {
                                            "title":"Comparing Two Pairs of Snapshots",
                                            "href":"comparing-two-pairs-snapshots.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Using the AWR Compare Periods Reports",
                                    "href":"using-awr-compare-periods-reports.html",
                                    "topics":[
                                        {
                                            "title":"Summary of the AWR Compare Periods Report",
                                            "href":"summary-awr-compare-periods-report.html",
                                            "topics":[
                                                {
                                                    "title":"Snapshot Sets",
                                                    "href":"snapshot-sets.html"
                                                },
                                                {
                                                    "title":"Host Configuration Comparison",
                                                    "href":"host-configuration-comparison.html"
                                                },
                                                {
                                                    "title":"Cache Sizes",
                                                    "href":"cache-sizes.html"
                                                },
                                                {
                                                    "title":"Load Profile",
                                                    "href":"load-profile.html"
                                                },
                                                {
                                                    "title":"Top Timed Events",
                                                    "href":"top-timed-events.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Details of the AWR Compare Periods Report",
                                            "href":"details-awr-compare-periods-report.html"
                                        },
                                        {
                                            "title":"Supplemental Information in the AWR Compare Periods Report",
                                            "href":"supplemental-information-awr-compare-periods-report.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10 </span> Using Automatic Workload Repository Warehouse for Generating Performance Reports",
                            "href":"using-automatic-workload-repository-warehouse-generating-performance-reports.html",
                            "topics":[
                                {
                                    "title":"Setting Up the AWR Warehouse",
                                    "href":"setting-awr-warehouse.html",
                                    "topics":[
                                        {
                                            "title":"Working with Source Databases",
                                            "href":"working-source-databases.html"
                                        },
                                        {
                                            "title":"Uploading Snapshots to the AWR Warehouse",
                                            "href":"uploading-snapshots-awr-warehouse.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Using Performance Pages with the AWR Warehouse",
                                    "href":"using-performance-pages-awr-warehouse.html"
                                },
                                {
                                    "title":"AWR Warehouse Best Practices",
                                    "href":"awr-warehouse-best-practices.html",
                                    "topics":[
                                        {
                                            "title":"Database Best Practices",
                                            "href":"database-best-practices.html",
                                            "topics":[
                                                {
                                                    "title":"Memory Management",
                                                    "href":"memory-management.html"
                                                },
                                                {
                                                    "title":"Storage Requirements",
                                                    "href":"storage-requirements.html"
                                                },
                                                {
                                                    "title":"Backup",
                                                    "href":"backup.html"
                                                },
                                                {
                                                    "title":"Redo Log Size",
                                                    "href":"redo-log-size.html"
                                                },
                                                {
                                                    "title":"Stats Collection",
                                                    "href":"stats-collection.html"
                                                },
                                                {
                                                    "title":"The job_queue_processes Parameter",
                                                    "href":"job_queue_processes-parameter.html"
                                                },
                                                {
                                                    "title":"Access Control",
                                                    "href":"access-control.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Enterprise Manager Best Practices",
                                            "href":"enterprise-manager-best-practices.html",
                                            "topics":[
                                                {
                                                    "title":"AWR Warehouse Credentials",
                                                    "href":"awr-warehouse-credentials.html"
                                                },
                                                {
                                                    "title":"Source Database Credentials",
                                                    "href":"source-database-credentials.html"
                                                },
                                                {
                                                    "title":"Staging Location on AWR Warehouse",
                                                    "href":"staging-location-awr-warehouse.html"
                                                },
                                                {
                                                    "title":"Network Latency",
                                                    "href":"network-latency.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Monitoring and Researching Incidents and Errors",
                                    "href":"monitoring-and-researching-incidents-and-errors.html"
                                },
                                {
                                    "title":"Using Autonomous Database Warehouse in Automatic Workload Repository",
                                    "href":"using-autonomous-data-warehouse-awr-warehouse.html"
                                },
                                {
                                    "title":"Using Automatic Workload Repository for Applications",
                                    "href":"using-awr-apps.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part IV SQL Tuning",
                    "href":"sql-tuning.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11 </span> Identifying High-Load SQL Statements",
                            "href":"identifying-high-load-sql-statements.html",
                            "topics":[
                                {
                                    "title":"Identification of High-Load SQL Statements Using ADDM Findings",
                                    "href":"identification-high-load-sql-statements-using-addm-findings.html"
                                },
                                {
                                    "title":"Monitoring Databases with Performance Hub",
                                    "href":"performance-hub-tgdba.html#GUID-7B0EF828-EEC4-4277-8F3D-9EE4B0140EE4",
                                    "topics":[
                                        {
                                            "title":"Automatic Database Diagnostic Monitor (ADDM)",
                                            "href":"addm-tab.html#GUID-93EEDF90-9896-4D82-A8C6-839FBA14465A"
                                        }
                                    ]
                                },
                                {
                                    "title":"Identifying High-Load SQL Statements Using Top SQL",
                                    "href":"identifying-high-load-sql-statements-using-top-sql.html#GUID-572D0FE3-BC16-4107-A8CC-EF59480B9C9E"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12 </span> Tuning SQL Statements",
                            "href":"tuning-sql-statements.html",
                            "topics":[
                                {
                                    "title":"Tuning SQL Statements Using SQL Tuning Advisor",
                                    "href":"tuning-sql-statements-using-sql-tuning-advisor.html",
                                    "topics":[
                                        {
                                            "title":"Tuning SQL Manually Using SQL Tuning Advisor",
                                            "href":"tuning-sql-manually-using-sql-tuning-advisor.html"
                                        },
                                        {
                                            "title":"Viewing Automatic SQL Tuning Results",
                                            "href":"viewing-automatic-sql-tuning-results.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Managing SQL Tuning Sets",
                                    "href":"managing-sql-tuning-sets.html",
                                    "topics":[
                                        {
                                            "title":"Creating a SQL Tuning Set",
                                            "href":"creating-sql-tuning-set.html",
                                            "topics":[
                                                {
                                                    "title":"Creating a SQL Tuning Set: Options",
                                                    "href":"creating-sql-tuning-set-options.html"
                                                },
                                                {
                                                    "title":"Creating a SQL Tuning Set: Load Methods",
                                                    "href":"creating-sql-tuning-set-load-methods.html",
                                                    "topics":[
                                                        {
                                                            "title":"Loading Active SQL Statements Incrementally from the Cursor Cache",
                                                            "href":"loading-active-sql-statements-incrementally-cursor-cache.html"
                                                        },
                                                        {
                                                            "title":"Loading SQL Statements from the Cursor Cache",
                                                            "href":"loading-sql-statements-cursor-cache.html"
                                                        },
                                                        {
                                                            "title":"Loading SQL Statements from AWR Snapshots",
                                                            "href":"loading-sql-statements-awr-snapshots.html"
                                                        },
                                                        {
                                                            "title":"Loading SQL Statements from AWR Baselines",
                                                            "href":"loading-sql-statements-awr-baselines.html"
                                                        },
                                                        {
                                                            "title":"Loading SQL Statements from a User-Defined Workload",
                                                            "href":"loading-sql-statements-user-defined-workload.html"
                                                        }
                                                    ]
                                                },
                                                {
                                                    "title":"Creating a SQL Tuning Set: Filter Options",
                                                    "href":"creating-sql-tuning-set-filter-options.html"
                                                },
                                                {
                                                    "title":"Creating a SQL Tuning Set: Schedule",
                                                    "href":"creating-sql-tuning-set-schedule.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Dropping a SQL Tuning Set",
                                            "href":"dropping-sql-tuning-set.html"
                                        },
                                        {
                                            "title":"Transporting SQL Tuning Sets",
                                            "href":"transporting-sql-tuning-sets.html",
                                            "topics":[
                                                {
                                                    "title":"Exporting a SQL Tuning Set",
                                                    "href":"exporting-sql-tuning-set.html"
                                                },
                                                {
                                                    "title":"Importing a SQL Tuning Set",
                                                    "href":"importing-sql-tuning-set.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Managing SQL Profiles",
                                    "href":"managing-sql-profiles.html"
                                },
                                {
                                    "title":"Managing SQL Plan Baselines",
                                    "href":"managing-sql-plan-baselines.html",
                                    "topics":[
                                        {
                                            "title":"Capturing SQL Plan Baselines Automatically",
                                            "href":"capturing-sql-plan-baselines-automatically.html"
                                        },
                                        {
                                            "title":"Loading SQL Plan Baselines Manually",
                                            "href":"loading-sql-plan-baselines-manually.html"
                                        },
                                        {
                                            "title":"Evolving SQL Plans",
                                            "href":"evolving-sql-plans.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">13 </span> Optimizing Data Access Paths",
                            "href":"optimizing-data-access-paths.html",
                            "topics":[
                                {
                                    "title":"Running SQL Access Advisor",
                                    "href":"running-sql-access-advisor.html",
                                    "topics":[
                                        {
                                            "title":"Selecting the Initial Options",
                                            "href":"selecting-initial-options.html"
                                        },
                                        {
                                            "title":"Selecting the Workload Source",
                                            "href":"selecting-workload-source.html",
                                            "topics":[
                                                {
                                                    "title":"Using SQL Statements from the Cache",
                                                    "href":"using-sql-statements-cache.html"
                                                },
                                                {
                                                    "title":"Using an Existing SQL Tuning Set",
                                                    "href":"using-existing-sql-tuning-set.html"
                                                },
                                                {
                                                    "title":"Using a Hypothetical Workload",
                                                    "href":"using-hypothetical-workload.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Applying Filter Options",
                                            "href":"applying-filter-options.html",
                                            "topics":[
                                                {
                                                    "title":"Defining Filters for Resource Consumption",
                                                    "href":"defining-filters-resource-consumption.html"
                                                },
                                                {
                                                    "title":"Defining Filters for Users",
                                                    "href":"defining-filters-users.html"
                                                },
                                                {
                                                    "title":"Defining Filters for Tables",
                                                    "href":"defining-filters-tables.html"
                                                },
                                                {
                                                    "title":"Defining Filters for SQL Text",
                                                    "href":"defining-filters-sql-text.html"
                                                },
                                                {
                                                    "title":"Defining Filters for Modules",
                                                    "href":"defining-filters-modules.html"
                                                },
                                                {
                                                    "title":"Defining Filters for Actions",
                                                    "href":"defining-filters-actions.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Specifying Recommendation Options",
                                            "href":"specifying-recommendation-options.html"
                                        },
                                        {
                                            "title":"Specifying Task and Scheduling Options",
                                            "href":"specifying-task-and-scheduling-options.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Reviewing the SQL Access Advisor Recommendations",
                                    "href":"reviewing-sql-access-advisor-recommendations.html",
                                    "topics":[
                                        {
                                            "title":"Reviewing the SQL Access Advisor Recommendations: Summary",
                                            "href":"reviewing-sql-access-advisor-recommendations-summary.html"
                                        },
                                        {
                                            "title":"Reviewing the SQL Access Advisor Recommendations: Recommendations",
                                            "href":"reviewing-sql-access-advisor-recommendations-recommendations.html"
                                        },
                                        {
                                            "title":"Reviewing the SQL Access Advisor Recommendations: SQL Statements",
                                            "href":"reviewing-sql-access-advisor-recommendations-sql-statements.html"
                                        },
                                        {
                                            "title":"Reviewing the SQL Access Advisor Recommendations: Details",
                                            "href":"reviewing-sql-access-advisor-recommendations-details.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Implementing the SQL Access Advisor Recommendations",
                                    "href":"implementing-sql-access-advisor-recommendations.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});