define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-3C441336-BABC-4FE8-8B14-2E4E6F1F66EB"
                },
                {
                    "title":"Part I Topology Data Model",
                    "href":"topology-data-model.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> Topology Data Model Overview",
                            "href":"topology-data-model-overview.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1 </span> Main Steps in Using Topology Data",
                                    "href":"main-steps-using-topology-data.html#GUID-F6F34EB5-B232-438A-954F-6C60BC1F7ADC"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.2 </span> Topology Data Model Concepts",
                                    "href":"topology-data-model-concepts.html#GUID-77BD1C8C-D9A1-4165-B5BD-8B4A4B4F6D3B"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.3 </span> Topology Geometries and Layers",
                                    "href":"topology-geometries-and-layers.html#GUID-5DCF62BD-2B74-49F7-968D-D4CD6787C9E4"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4 </span> Topology Geometry Layer Hierarchy",
                                    "href":"topology-geometry-layer-hierarchy.html#GUID-048DC942-FC27-4977-AB98-2451E4A4910F"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5 </span> Topology Data Model Tables",
                                    "href":"topology-data-model-tables.html#GUID-86DFC29E-32D2-4F6C-9A17-6493B5946A99"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.6 </span> Topology Data Types",
                                    "href":"topology-data-types.html#GUID-3DFBD879-D267-4D69-B7AD-1A7CCA9424FD"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.7 </span> Topology Metadata Views",
                                    "href":"topology-metadata-views.html#GUID-2FB6ED4F-3FBB-40D4-AF34-330890315290"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.8 </span> Topology Application Programming Interface",
                                    "href":"topology-application-programming-interface.html#GUID-7FD02739-8A8E-4700-8CE2-F4D513A90A38"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.9 </span> Exporting and Importing Topology Data",
                                    "href":"exporting-and-importing-topology-data.html#GUID-2D284F68-529F-4772-9C96-2E2FCC72AA70"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.10 </span> Cross-Schema Topology Usage and Editing",
                                    "href":"cross-schema-topology-usage-and-editing.html#GUID-7C1445F9-CBF6-4E86-A3F6-3500A08A56FD"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.11 </span> Function-Based Indexes Not Supported",
                                    "href":"function-based-indexes-not-supported.html#GUID-8F1AD378-4C16-4E64-9BA8-68D825029C8C"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.12 </span> Topology Examples (PL/SQL)",
                                    "href":"topology-examples-pl-sql.html#GUID-637E97AE-C81B-444E-9683-89A143F803F3"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.13 </span> README File for Spatial and Related Features",
                                    "href":"readme-file-spatial-and-graph-and-related-features.html#GUID-43C622BE-1149-4A40-9368-67C7D1EF13E9"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> Editing Topologies",
                            "href":"editing-topologies.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1 </span> Approaches for Editing Topology Data",
                                    "href":"approaches-editing-topology-data.html#GUID-3855F8F8-35C3-43F7-97AE-612C98A4F3CF"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2 </span> Performing Operations on Nodes",
                                    "href":"performing-operations-nodes.html#GUID-FC9B2AC9-2B65-4327-91F6-893A4EAC2A40"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3 </span> Performing Operations on Edges",
                                    "href":"performing-operations-edges.html#GUID-48615C1B-6AAA-4088-B575-B9183737931C"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3 </span> SDO_TOPO Package Subprograms",
                            "href":"sdo_topo-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1 </span> SDO_TOPO.ADD_TOPO_GEOMETRY_LAYER",
                                    "href":"sdo_topo-add_topo_geometry_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2 </span> SDO_TOPO.CREATE_TOPOLOGY",
                                    "href":"sdo_topo-create_topology.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3 </span> SDO_TOPO.DELETE_TOPO_GEOMETRY_LAYER",
                                    "href":"sdo_topo-delete_topo_geometry_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4 </span> SDO_TOPO.DROP_TOPOLOGY",
                                    "href":"sdo_topo-drop_topology.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5 </span> SDO_TOPO.GET_FACE_BOUNDARY",
                                    "href":"sdo_topo-get_face_boundary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.6 </span> SDO_TOPO.GET_TOPO_OBJECTS",
                                    "href":"sdo_topo-get_topo_objects.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.7 </span> SDO_TOPO.INITIALIZE_AFTER_IMPORT",
                                    "href":"sdo_topo-initialize_after_import.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.8 </span> SDO_TOPO.INITIALIZE_METADATA",
                                    "href":"sdo_topo-initialize_metadata.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.9 </span> SDO_TOPO.PREPARE_FOR_EXPORT",
                                    "href":"sdo_topo-prepare_for_export.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.10 </span> SDO_TOPO.RELATE",
                                    "href":"sdo_topo-relate.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> SDO_TOPO_MAP Package Subprograms",
                            "href":"sdo_topo_map-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1 </span> SDO_TOPO_MAP.ADD_EDGE",
                                    "href":"sdo_topo_map-add_edge.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2 </span> SDO_TOPO_MAP.ADD_ISOLATED_NODE",
                                    "href":"sdo_topo_map-add_isolated_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3 </span> SDO_TOPO_MAP.ADD_LINEAR_GEOMETRY",
                                    "href":"sdo_topo_map-add_linear_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4 </span> SDO_TOPO_MAP.ADD_LOOP",
                                    "href":"sdo_topo_map-add_loop.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5 </span> SDO_TOPO_MAP.ADD_NODE",
                                    "href":"sdo_topo_map-add_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6 </span> SDO_TOPO_MAP.ADD_POINT_GEOMETRY",
                                    "href":"sdo_topo_map-add_point_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.7 </span> SDO_TOPO_MAP.ADD_POLYGON_GEOMETRY",
                                    "href":"sdo_topo_map-add_polygon_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8 </span> SDO_TOPO_MAP.CHANGE_EDGE_COORDS",
                                    "href":"sdo_topo_map-change_edge_coords.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.9 </span> SDO_TOPO_MAP.CLEAR_TOPO_MAP",
                                    "href":"sdo_topo_map-clear_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.10 </span> SDO_TOPO_MAP.COMMIT_TOPO_MAP",
                                    "href":"sdo_topo_map-commit_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.11 </span> SDO_TOPO_MAP.CREATE_EDGE_INDEX",
                                    "href":"sdo_topo_map-create_edge_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.12 </span> SDO_TOPO_MAP.CREATE_FACE_INDEX",
                                    "href":"sdo_topo_map-create_face_index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.13 </span> SDO_TOPO_MAP.CREATE_FEATURE",
                                    "href":"sdo_topo_map-create_feature.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.14 </span> SDO_TOPO_MAP.CREATE_TOPO_MAP",
                                    "href":"sdo_topo_map-create_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.15 </span> SDO_TOPO_MAP.DROP_TOPO_MAP",
                                    "href":"sdo_topo_map-drop_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.16 </span> SDO_TOPO_MAP.GET_CONTAINING_FACE",
                                    "href":"sdo_topo_map-get_containing_face.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.17 </span> SDO_TOPO_MAP.GET_EDGE_ADDITIONS",
                                    "href":"sdo_topo_map-get_edge_additions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.18 </span> SDO_TOPO_MAP.GET_EDGE_CHANGES",
                                    "href":"sdo_topo_map-get_edge_changes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.19 </span> SDO_TOPO_MAP.GET_EDGE_COORDS",
                                    "href":"sdo_topo_map-get_edge_coords.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.20 </span> SDO_TOPO_MAP.GET_EDGE_DELETIONS",
                                    "href":"sdo_topo_map-get_edge_deletions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.21 </span> SDO_TOPO_MAP.GET_EDGE_NODES",
                                    "href":"sdo_topo_map-get_edge_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.22 </span> SDO_TOPO_MAP.GET_FACE_ADDITIONS",
                                    "href":"sdo_topo_map-get_face_additions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.23 </span> SDO_TOPO_MAP.GET_FACE_CHANGES",
                                    "href":"sdo_topo_map-get_face_changes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.24 </span> SDO_TOPO_MAP.GET_FACE_BOUNDARY",
                                    "href":"sdo_topo_map-get_face_boundary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.25 </span> SDO_TOPO_MAP.GET_FACE_DELETIONS",
                                    "href":"sdo_topo_map-get_face_deletions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.26 </span> SDO_TOPO_MAP.GET_NEAREST_EDGE",
                                    "href":"sdo_topo_map-get_nearest_edge.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.27 </span> SDO_TOPO_MAP.GET_NEAREST_EDGE_IN_CACHE",
                                    "href":"sdo_topo_map-get_nearest_edge_in_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.28 </span> SDO_TOPO_MAP.GET_NEAREST_NODE",
                                    "href":"sdo_topo_map-get_nearest_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.29 </span> SDO_TOPO_MAP.GET_NEAREST_NODE_IN_CACHE",
                                    "href":"sdo_topo_map-get_nearest_node_in_cache.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.30 </span> SDO_TOPO_MAP.GET_NODE_ADDITIONS",
                                    "href":"sdo_topo_map-get_node_additions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.31 </span> SDO_TOPO_MAP.GET_NODE_CHANGES",
                                    "href":"sdo_topo_map-get_node_changes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.32 </span> SDO_TOPO_MAP.GET_NODE_COORD",
                                    "href":"sdo_topo_map-get_node_coord.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.33 </span> SDO_TOPO_MAP.GET_NODE_DELETIONS",
                                    "href":"sdo_topo_map-get_node_deletions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.34 </span> SDO_TOPO_MAP.GET_NODE_FACE_STAR",
                                    "href":"sdo_topo_map-get_node_face_star.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.35 </span> SDO_TOPO_MAP.GET_NODE_STAR",
                                    "href":"sdo_topo_map-get_node_star.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.36 </span> SDO_TOPO_MAP.GET_TOPO_NAME",
                                    "href":"sdo_topo_map-get_topo_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.37 </span> SDO_TOPO_MAP.GET_TOPO_TRANSACTION_ID",
                                    "href":"sdo_topo_map-get_topo_transaction_id.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.38 </span> SDO_TOPO_MAP.LIST_TOPO_MAPS",
                                    "href":"sdo_topo_map-list_topo_maps.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.39 </span> SDO_TOPO_MAP.LOAD_TOPO_MAP",
                                    "href":"sdo_topo_map-load_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.40 </span> SDO_TOPO_MAP.MOVE_EDGE",
                                    "href":"sdo_topo_map-move_edge.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.41 </span> SDO_TOPO_MAP.MOVE_ISOLATED_NODE",
                                    "href":"sdo_topo_map-move_isolated_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.42 </span> SDO_TOPO_MAP.MOVE_NODE",
                                    "href":"sdo_topo_map-move_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.43 </span> SDO_TOPO_MAP.REMOVE_EDGE",
                                    "href":"sdo_topo_map-remove_edge.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.44 </span> SDO_TOPO_MAP.REMOVE_NODE",
                                    "href":"sdo_topo_map-remove_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.45 </span> SDO_TOPO_MAP.REMOVE_OBSOLETE_NODES",
                                    "href":"sdo_topo_map-remove_obsolete_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.46 </span> SDO_TOPO_MAP.ROLLBACK_TOPO_MAP",
                                    "href":"sdo_topo_map-rollback_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.47 </span> SDO_TOPO_MAP.SEARCH_EDGE_RTREE_TOPO_MAP",
                                    "href":"sdo_topo_map-search_edge_rtree_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.48 </span> SDO_TOPO_MAP.SEARCH_FACE_RTREE_TOPO_MAP",
                                    "href":"sdo_topo_map-search_face_rtree_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.49 </span> SDO_TOPO_MAP.SET_MAX_MEMORY_SIZE",
                                    "href":"sdo_topo_map-set_max_memory_size.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.50 </span> SDO_TOPO_MAP.UPDATE_TOPO_MAP",
                                    "href":"sdo_topo_map-update_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.51 </span> SDO_TOPO_MAP.VALIDATE_TOPO_MAP",
                                    "href":"sdo_topo_map-validate_topo_map.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.52 </span> SDO_TOPO_MAP.VALIDATE_TOPOLOGY",
                                    "href":"sdo_topo_map-validate_topology.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part II Network Data Model",
                    "href":"network-data-model.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5 </span> Network Data Model Overview",
                            "href":"network-data-model-graph-overview.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1 </span> Introduction to Network Modeling",
                                    "href":"introduction-network-modeling.html#GUID-3D943949-5DA2-4225-9EA5-9496399646F5"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2 </span> Main Steps in Using the Network Data Model",
                                    "href":"main-steps-using-network-data-model-graph.html#GUID-E088F1BF-6F15-495F-9732-C8A62649607B"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3 </span> Network Data Model Concepts",
                                    "href":"network-data-model-graph-concepts.html#GUID-4D127E98-2856-4C90-9FE0-BCA156E39C7C"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.4 </span> Network Applications",
                                    "href":"network-applications.html#GUID-99FBD672-441B-4660-90ED-A11BA249AD5A"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.5 </span> Network Hierarchy",
                                    "href":"network-hierarchy.html#GUID-9DAFED69-BD14-4375-B053-4879F50D54CB"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.6 </span> Network User Data",
                                    "href":"network-user-data.html#GUID-7B80A118-F2A5-44D5-92F5-24033B6BD84F"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.7 </span> Feature Modeling",
                                    "href":"feature-modeling.html#GUID-7F09B637-DBC2-43FA-BF29-C32656EADEE4"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.8 </span> Feature Modeling Using Network Feature Editing (NFE)",
                                    "href":"feature-modeling-using-network-feature-editing-nfe.html#GUID-ADC9EC6C-A95C-4FEA-93E9-6BE8D79C1403"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.9 </span> Network Constraints",
                                    "href":"network-constraints.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.10 </span> Network Buffers",
                                    "href":"network-buffers.html#GUID-4D15B2C8-9EBB-4E2A-AA58-EFA663BC3CC9"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.11 </span> Network Analysis Using Load on Demand",
                                    "href":"network-analysis-using-load-demand.html#GUID-718EB9E1-3ED8-4CA0-B098-1ED8EC6D07B6"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.12 </span> Network Management and Analysis Using Contraction Hierarchies",
                                    "href":"network-management-and-analysis-using-contraction-hierarchies.html#GUID-A95D054C-68FE-4132-8D1A-114A35314D04"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.13 </span> Network Data Model Tables",
                                    "href":"network-data-model-graph-tables.html#GUID-368DCA87-F688-40FC-8B47-E5AA8BCA083F"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.14 </span> Network Data Model and Network Feature Editing (NFE) Model Metadata Views",
                                    "href":"network-data-model-graph-and-network-feature-editing-nfe-metadata-views.html#GUID-08FC9575-4397-4A50-9401-44F48F78E00D"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.15 </span> Network Data Model Application Programming Interface",
                                    "href":"network-data-model-graph-application-programming-interface.html#GUID-B16D53F5-7E65-487D-98E9-8A606F457C82"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.16 </span> Cross-Schema Network Access",
                                    "href":"cross-schema-network-access.html#GUID-96C6EB60-4CC0-4016-8190-40115606CF6F"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.17 </span> Network Examples",
                                    "href":"network-examples.html#GUID-F343E028-D514-4783-B6DC-50E6118BBE7A"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.18 </span> Network Data Model Tutorial and Other Resources",
                                    "href":"network-data-model-graph-tutorial-and-other-resources.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19 </span> README File for Spatial and Related Features",
                                    "href":"readme-file-spatial-and-graph-and-related-features1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6 </span> SDO_NET Package Subprograms",
                            "href":"sdo_net-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1 </span> SDO_NET.ADD_CHILD_FEATURE",
                                    "href":"sdo_net-add_child_feature.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2 </span> SDO_NET.ADD_CHILD_FEATURES",
                                    "href":"sdo_net-add_child_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.3 </span> SDO_NET.ADD_FEATURE",
                                    "href":"sdo_net-add_feature.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.4 </span> SDO_NET.ADD_FEATURE_ELEMENT",
                                    "href":"sdo_net-add_feature_element.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.5 </span> SDO_NET.ADD_FEATURE_ELEMENTS",
                                    "href":"sdo_net-add_feature_elements.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.6 </span> SDO_NET.ADD_FEATURE_LAYER",
                                    "href":"sdo_net-add_feature_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.7 </span> SDO_NET.COMPUTE_PATH_GEOMETRY",
                                    "href":"sdo_net-compute_path_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.8 </span> SDO_NET.COPY_NETWORK",
                                    "href":"sdo_net-copy_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.9 </span> SDO_NET.CREATE_LINK_TABLE",
                                    "href":"sdo_net-create_link_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.10 </span> SDO_NET.CREATE_LOGICAL_NETWORK",
                                    "href":"sdo_net-create_logical_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.11 </span> SDO_NET.CREATE_LRS_NETWORK",
                                    "href":"sdo_net-create_lrs_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.12 </span> SDO_NET.CREATE_LRS_TABLE",
                                    "href":"sdo_net-create_lrs_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.13 </span> SDO_NET.CREATE_NODE_TABLE",
                                    "href":"sdo_net-create_node_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.14 </span> SDO_NET.CREATE_PARTITION_TABLE",
                                    "href":"sdo_net-create_partition_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.15 </span> SDO_NET.CREATE_PATH_LINK_TABLE",
                                    "href":"sdo_net-create_path_link_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.16 </span> SDO_NET.CREATE_PATH_TABLE",
                                    "href":"sdo_net-create_path_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.17 </span> SDO_NET.CREATE_SDO_NETWORK",
                                    "href":"sdo_net-create_sdo_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.18 </span> SDO_NET.CREATE_SUBPATH_TABLE",
                                    "href":"sdo_net-create_subpath_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.19 </span> SDO_NET.CREATE_TOPO_NETWORK",
                                    "href":"sdo_net-create_topo_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.20 </span> SDO_NET.DELETE_CHILD_FEATURES",
                                    "href":"sdo_net-delete_child_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.21 </span> SDO_NET.DELETE_CHILD_FEATURES_AT",
                                    "href":"sdo_net-delete_child_features_at.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.22 </span> SDO_NET.DELETE_DANGLING_FEATURES",
                                    "href":"sdo_net-delete_dangling_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.23 </span> SDO_NET.DELETE_DANGLING_LINKS",
                                    "href":"sdo_net-delete_dangling_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.24 </span> SDO_NET.DELETE_DANGLING_NODES",
                                    "href":"sdo_net-delete_dangling_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.25 </span> SDO_NET.DELETE_FEATURE_ELEMENTS",
                                    "href":"sdo_net-delete_feature_elements.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.26 </span> SDO_NET.DELETE_FEATURE_ELEMENTS_AT",
                                    "href":"sdo_net-delete_feature_elements_at.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.27 </span> SDO_NET.DELETE_FEATURES",
                                    "href":"sdo_net-delete_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.28 </span> SDO_NET.DELETE_LINK",
                                    "href":"sdo_net-delete_link.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.29 </span> SDO_NET.DELETE_NODE",
                                    "href":"sdo_net-delete_node.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.30 </span> SDO_NET.DELETE_PATH",
                                    "href":"sdo_net-delete_path.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.31 </span> SDO_NET.DELETE_PHANTOM_FEATURES",
                                    "href":"sdo_net-delete_phantom_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.32 </span> SDO_NET.DELETE_SUBPATH",
                                    "href":"sdo_net-delete_subpath.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.33 </span> SDO_NET.DEREGISTER_CONSTRAINT",
                                    "href":"sdo_net-deregister_constraint.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.34 </span> SDO_NET.DROP_FEATURE_LAYER",
                                    "href":"sdo_net-drop_feature_layer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.35 </span> SDO_NET.DROP_NETWORK",
                                    "href":"sdo_net-drop_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.36 </span> SDO_NET.FIND_CONNECTED_COMPONENTS",
                                    "href":"sdo_net-find_connected_components.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.37 </span> SDO_NET.GENERATE_NODE_LEVELS",
                                    "href":"sdo_net-generate_node_levels.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.38 </span> SDO_NET.GENERATE_PARTITION_BLOB",
                                    "href":"sdo_net-generate_partition_blob.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.39 </span> SDO_NET.GENERATE_PARTITION_BLOBS",
                                    "href":"sdo_net-generate_partition_blobs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.40 </span> SDO_NET.GET_CHILD_FEATURE_IDS",
                                    "href":"sdo_net-get_child_feature_ids.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.41 </span> SDO_NET.GET_CHILD_LINKS",
                                    "href":"sdo_net-get_child_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.42 </span> SDO_NET.GET_CHILD_NODES",
                                    "href":"sdo_net-get_child_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.43 </span> SDO_NET.GET_DANGLING_FEATURES",
                                    "href":"sdo_net-get_dangling_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.44 </span> SDO_NET.GET_DANGLING_LINKS",
                                    "href":"sdo_net-get_dangling_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.45 </span> SDO_NET.GET_DANGLING_NODES",
                                    "href":"sdo_net-get_dangling_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.46 </span> SDO_NET.GET_FEATURE_ELEMENTS",
                                    "href":"sdo_net-get_feature_elements.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.47 </span> SDO_NET.GET_FEATURE_LAYER_ID",
                                    "href":"sdo_net-get_feature_layer_id.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.48 </span> SDO_NET.GET_FEATURES_ON_LINKS",
                                    "href":"sdo_net-get_features_on_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.49 </span> SDO_NET.GET_FEATURES_ON_NODES",
                                    "href":"sdo_net-get_features_on_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.50 </span> SDO_NET.GET_GEOMETRY_TYPE",
                                    "href":"sdo_net-get_geometry_type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.51 </span> SDO_NET.GET_IN_LINKS",
                                    "href":"sdo_net-get_in_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.52 </span> SDO_NET.GET_INVALID_LINKS",
                                    "href":"sdo_net-get_invalid_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.53 </span> SDO_NET.GET_INVALID_NODES",
                                    "href":"sdo_net-get_invalid_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.54 </span> SDO_NET.GET_INVALID_PATHS",
                                    "href":"sdo_net-get_invalid_paths.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.55 </span> SDO_NET.GET_ISOLATED_NODES",
                                    "href":"sdo_net-get_isolated_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.56 </span> SDO_NET.GET_LINK_COST_COLUMN",
                                    "href":"sdo_net-get_link_cost_column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.57 </span> SDO_NET.GET_LINK_DIRECTION",
                                    "href":"sdo_net-get_link_direction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.58 </span> SDO_NET.GET_LINK_GEOM_COLUMN",
                                    "href":"sdo_net-get_link_geom_column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.59 </span> SDO_NET.GET_LINK_GEOMETRY",
                                    "href":"sdo_net-get_link_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.60 </span> SDO_NET.GET_LINK_TABLE_NAME",
                                    "href":"sdo_net-get_link_table_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.61 </span> SDO_NET.GET_LINKS_IN_PATH",
                                    "href":"sdo_net-get_links_in_path.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.62 </span> SDO_NET.GET_LRS_GEOM_COLUMN",
                                    "href":"sdo_net-get_lrs_geom_column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.63 </span> SDO_NET.GET_LRS_LINK_GEOMETRY",
                                    "href":"sdo_net-get_lrs_link_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.64 </span> SDO_NET.GET_LRS_NODE_GEOMETRY",
                                    "href":"sdo_net-get_lrs_node_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.65 </span> SDO_NET.GET_LRS_TABLE_NAME",
                                    "href":"sdo_net-get_lrs_table_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.66 </span> SDO_NET.GET_NETWORK_TYPE",
                                    "href":"sdo_net-get_network_type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.67 </span> SDO_NET.GET_NO_OF_HIERARCHY_LEVELS",
                                    "href":"sdo_net-get_no_of_hierarchy_levels.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.68 </span> SDO_NET.GET_NO_OF_LINKS",
                                    "href":"sdo_net-get_no_of_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.69 </span> SDO_NET.GET_NO_OF_NODES",
                                    "href":"sdo_net-get_no_of_nodes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.70 </span> SDO_NET.GET_NODE_DEGREE",
                                    "href":"sdo_net-get_node_degree.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.71 </span> SDO_NET.GET_NODE_GEOM_COLUMN",
                                    "href":"sdo_net-get_node_geom_column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.72 </span> SDO_NET.GET_NODE_GEOMETRY",
                                    "href":"sdo_net-get_node_geometry.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.73 </span> SDO_NET.GET_NODE_IN_DEGREE",
                                    "href":"sdo_net-get_node_in_degree.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.74 </span> SDO_NET.GET_NODE_OUT_DEGREE",
                                    "href":"sdo_net-get_node_out_degree.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.75 </span> SDO_NET.GET_NODE_TABLE_NAME",
                                    "href":"sdo_net-get_node_table_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.76 </span> SDO_NET.GET_OUT_LINKS",
                                    "href":"sdo_net-get_out_links.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.77 </span> SDO_NET.GET_PARENT_FEATURE_IDS",
                                    "href":"sdo_net-get_parent_feature_ids.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.78 </span> SDO_NET.GET_PARTITION_SIZE",
                                    "href":"sdo_net-get_partition_size.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.79 </span> SDO_NET.GET_PATH_GEOM_COLUMN",
                                    "href":"sdo_net-get_path_geom_column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.80 </span> SDO_NET.GET_PATH_TABLE_NAME",
                                    "href":"sdo_net-get_path_table_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.81 </span> SDO_NET.GET_PERCENTAGE",
                                    "href":"sdo_net-get_percentage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.82 </span> SDO_NET.GET_PHANTOM_FEATURES",
                                    "href":"sdo_net-get_phantom_features.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.83 </span> SDO_NET.GET_PT",
                                    "href":"sdo_net-get_pt.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.84 </span> SDO_NET.IS_HIERARCHICAL",
                                    "href":"sdo_net-is_hierarchical.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.85 </span> SDO_NET.IS_LINK_IN_PATH",
                                    "href":"sdo_net-is_link_in_path.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.86 </span> SDO_NET.IS_LOGICAL",
                                    "href":"sdo_net-is_logical.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.87 </span> SDO_NET.IS_NODE_IN_PATH",
                                    "href":"sdo_net-is_node_in_path.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.88 </span> SDO_NET.IS_SPATIAL",
                                    "href":"sdo_net-is_spatial.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.89 </span> SDO_NET.LOAD_CONFIG",
                                    "href":"sdo_net-load_config.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.90 </span> SDO_NET.LOGICAL_PARTITION",
                                    "href":"sdo_net-logical_partition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.91 </span> SDO_NET.LOGICAL_POWERLAW_PARTITION",
                                    "href":"sdo_net-logical_powerlaw_partition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.92 </span> SDO_NET.LRS_GEOMETRY_NETWORK",
                                    "href":"sdo_net-lrs_geometry_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.93 </span> SDO_NET.NETWORK_EXISTS",
                                    "href":"sdo_net-network_exists.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.94 </span> SDO_NET.POST_XML",
                                    "href":"sdo_net-post_xml.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.95 </span> SDO_NET.REGISTER_CONSTRAINT",
                                    "href":"sdo_net-register_constraint.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.96 </span> SDO_NET.SDO_GEOMETRY_NETWORK",
                                    "href":"sdo_net-sdo_geometry_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.97 </span> SDO_NET.SET_LOGGING_LEVEL",
                                    "href":"sdo_net-set_logging_level.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.98 </span> SDO_NET.SET_MAX_JAVA_HEAP_SIZE",
                                    "href":"sdo_net-set_max_java_heap_size.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.99 </span> SDO_NET.SPATIAL_PARTITION",
                                    "href":"sdo_net-spatial_partition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.100 </span> SDO_NET.TOPO_GEOMETRY_NETWORK",
                                    "href":"sdo_net-topo_geometry_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.101 </span> SDO_NET.UPDATE_FEATURE",
                                    "href":"sdo_net-update_feature.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.102 </span> SDO_NET.UPDATE_FEATURE_ELEMENT",
                                    "href":"sdo_net-update_feature_element.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.103 </span> SDO_NET.VALIDATE_LINK_SCHEMA",
                                    "href":"sdo_net-validate_link_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.104 </span> SDO_NET.VALIDATE_LRS_SCHEMA",
                                    "href":"sdo_net-validate_lrs_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.105 </span> SDO_NET.VALIDATE_NETWORK",
                                    "href":"sdo_net-validate_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.106 </span> SDO_NET.VALIDATE_NODE_SCHEMA",
                                    "href":"sdo_net-validate_node_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.107 </span> SDO_NET.VALIDATE_PARTITION_SCHEMA",
                                    "href":"sdo_net-validate_partition_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.108 </span> SDO_NET.VALIDATE_PATH_SCHEMA",
                                    "href":"sdo_net-validate_path_schema.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.109 </span> SDO_NET.VALIDATE_SUBPATH_SCHEMA",
                                    "href":"sdo_net-validate_subpath_schema.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7 </span> SDO_NFE Package Subprograms",
                            "href":"sdo_nfe-package-subprograms.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1 </span> SDO_NFE.APPLY_RULE",
                                    "href":"sdo_nfe-apply_rule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2 </span> SDO_NFE.CLASSIFY_LINES_BY_SIDE",
                                    "href":"sdo_nfe-classify_lines_by_side.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3 </span> SDO_NFE.CREATE_MODEL_SEQUENCE",
                                    "href":"sdo_nfe-create_model_sequence.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.4 </span> SDO_NFE.CREATE_MODEL_STRUCTURE",
                                    "href":"sdo_nfe-create_model_structure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.5 </span> SDO_NFE.CREATE_MODEL_UNDERLYING_NET",
                                    "href":"sdo_nfe-create_model_underlying_net.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.6 </span> SDO_NFE.CREATE_MODEL_WORKSPACE",
                                    "href":"sdo_nfe-create_model_workspace.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.7 </span> SDO_NFE.DELETE_ALL_FT_LAYERS",
                                    "href":"sdo_nfe-delete_all_ft_layers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.8 </span> SDO_NFE.DELETE_ALL_WORKSPACES",
                                    "href":"sdo_nfe-delete_all_workspaces.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.9 </span> SDO_NFE.DELETE_MODEL_STRUCTURE",
                                    "href":"sdo_nfe-delete_model_structure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.10 </span> SDO_NFE.DELETE_MODEL_WORKSPACE",
                                    "href":"sdo_nfe-delete_model_workspace.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.11 </span> SDO_NFE.DROP_MODEL_SEQUENCE",
                                    "href":"sdo_nfe-drop_model_sequence.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.12 </span> SDO_NFE.DROP_MODEL_UNDERLYING_NETWORK",
                                    "href":"sdo_nfe-drop_model_underlying_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.13 </span> SDO_NFE.GET_CONNECTION_POINT_GEOM",
                                    "href":"sdo_nfe-get_connection_point_geom.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.14 </span> SDO_NFE.GET_INTERACTION_GROUPS",
                                    "href":"sdo_nfe-get_interaction_groups.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.15 </span> SDO_NFE.GET_LINES_MATCH_LP_RULE",
                                    "href":"sdo_nfe-get_lines_match_lp_rule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.16 </span> SDO_NFE.GET_LL_CONN_INTERSECTIONS",
                                    "href":"sdo_nfe-get_ll_conn_intersections.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.17 </span> SDO_NFE.GET_LP_CONN_INTERSECTIONS",
                                    "href":"sdo_nfe-get_lp_conn_intersections.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.18 </span> SDO_NFE.GET_MODEL_SEQUENCE_NAME",
                                    "href":"sdo_nfe-get_model_sequence_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.19 </span> SDO_NFE.GET_MODEL_TABLE_NAME",
                                    "href":"sdo_nfe-get_model_table_name.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.20 </span> SDO_NFE.GET_MODEL_UNDERLYING_NETWORK",
                                    "href":"sdo_nfe-get_model_underlying_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.21 </span> SDO_NFE.GET_NEXT_SEQUENCE_VALUE",
                                    "href":"sdo_nfe-get_next_sequence_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.22 </span> SDO_NFE.GET_POINTS_MATCH_LP_RULE",
                                    "href":"sdo_nfe-get_points_match_lp_rule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.23 </span> SDO_NFE.IMPORT_NETWORK",
                                    "href":"sdo_nfe-import_network.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.24 </span> SDO_NFE.SET_MODEL_UNDERLYING_NETWORK",
                                    "href":"sdo_nfe-set_model_underlying_network.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});