define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-B9A1644F-9FE9-4140-B8C4-78390F87183D"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Upgrading Oracle Database",
                    "href":"intro-to-upgrading-oracle-database.html#GUID-FA024F34-A61A-4C4B-AA60-C123A9191A16",
                    "topics":[
                        {
                            "title":"Oracle Database Releases That Support Direct Upgrade",
                            "href":"oracle-database-releases-that-support-direct-upgrade.html#GUID-7AA90913-D8AB-4EBA-944F-31FA01D6BE5D"
                        },
                        {
                            "title":"Overview of Oracle Database Upgrade Tools and Processes",
                            "href":"overview-oracle-db-upgrade-tools-processes.html#GUID-99E10023-B2E5-4B35-BD01-E21D5B912D50",
                            "topics":[
                                {
                                    "title":"Definition of Terms Upgrading and Migrating",
                                    "href":"definition-of-terms-upgrading-and-migrating.html#GUID-D949E541-4AB1-43E0-BFC3-B7493C3E46D8"
                                },
                                {
                                    "title":"Upgrade and Data Migration Methods and Processes",
                                    "href":"upgrade-and-data-migration-methods-and-processes.html#GUID-93250F01-DB85-4CA2-9A10-5B5FA5E4B924"
                                },
                                {
                                    "title":"Where to Find the Latest Information About Upgrading Oracle Database",
                                    "href":"find-latest-information-upgrading-oracle-database.html#GUID-DFC94F4C-01A9-43BD-9F70-1EE6D472A562"
                                }
                            ]
                        },
                        {
                            "title":"Compatibility and Interoperability Between Oracle Database Releases",
                            "href":"compatibility-interoperability-between-database-releases.html#GUID-CC06CC01-77F5-456E-AA43-E4D80E40F26C",
                            "topics":[
                                {
                                    "title":"About Oracle Database Release Numbers",
                                    "href":"oracle-database-release-numbers.html#GUID-1E2F3945-C0EE-4EB2-A933-8D1862D8ECE2"
                                },
                                {
                                    "title":"Convention for Referring to Release Numbers in Upgrade Topics",
                                    "href":"conventions-release-numbers-oracle.html#GUID-74D2EC82-21F6-48C2-8C60-D67C2396B215"
                                },
                                {
                                    "title":"What Is Oracle Database Compatibility?",
                                    "href":"what-is-oracle-database-compatibility.html#GUID-4711E0D1-9FCF-4F35-85B5-52EBB437C00E"
                                },
                                {
                                    "title":"Updating the Database Compatibility Level",
                                    "href":"updating-compatibility-level-oracle-database.html#GUID-F7FB3605-9A42-41F4-8E81-558AA8CB2BBC"
                                },
                                {
                                    "title":"What Is Interoperability for Oracle Database Upgrades?",
                                    "href":"what-is-interoperability-for-oracle-database-upgrades.html#GUID-96FA7FF6-B699-4A02-AC42-601AC245C66B"
                                },
                                {
                                    "title":"About Invalid Schema Objects and Database Upgrades",
                                    "href":"invalid-schema-objects-database-upgrades.html#GUID-306CB6B3-F7FB-42C1-931F-4C8B22912AA8"
                                }
                            ]
                        },
                        {
                            "title":"About Running Multiple Oracle Database Releases",
                            "href":"running-multiple-oracle-database-releases.html#GUID-EDF33DC1-BB2C-4E7E-9DFA-B00BC46BEF7F"
                        },
                        {
                            "title":"About Converting Databases During Upgrades",
                            "href":"converting-databases-upgrades.html#GUID-C7B6FF47-0718-4597-9550-63E3C7E0A024",
                            "topics":[
                                {
                                    "title":"Overview of Converting Databases During Upgrades",
                                    "href":"overview-converting-databases-during-upgrade.html#GUID-595CB101-7846-4609-B260-FC030E5631FF"
                                },
                                {
                                    "title":"About Upgrading Using Standby Databases",
                                    "href":"upgrading-using-standby-databases.html#GUID-852A592A-0589-456B-9DD3-5B662EC2EE14"
                                },
                                {
                                    "title":"Overview of Steps for Upgrading Oracle Database Using Oracle GoldenGate",
                                    "href":"overview-steps-upgrading-using-oracle-goldengate.html#GUID-8E029631-8265-497C-983B-B8A4ACD47B98"
                                },
                                {
                                    "title":"Migrating From Standard Edition to Enterprise Edition Oracle AI Database",
                                    "href":"migrating-from-standard-to-enterprise--database.html#GUID-294262A1-9E53-4C76-8FFA-086BD6CC4EE1"
                                },
                                {
                                    "title":"Migrating from Enterprise Edition to Standard Edition Oracle AI Database",
                                    "href":"migrating-from-enterprise-to-standard-database.html#GUID-FD2DB65B-0E54-4ECE-8DF3-8E8F12FBD005"
                                },
                                {
                                    "title":"Migrating from Oracle Database Express Edition (Oracle Database XE) to Oracle AI Database",
                                    "href":"migrating-from-express-to-standard-database.html#GUID-8DE9745C-EAFB-4C08-9B79-379E6983F9F8"
                                }
                            ]
                        },
                        {
                            "title":"About Upgrading Platforms for a New Oracle AI Database Release",
                            "href":"upgrading-platforms-new-oracle-database-release.html#GUID-F38989CF-4649-46BE-894E-27FBBA0335AD"
                        },
                        {
                            "title":"About Image-Based Oracle Database Installation",
                            "href":"image-based-oracle-database-installations.html#GUID-0315AA15-1C03-4E96-B801-3A8E5F5D4B39"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Preparing to Upgrade Oracle Database",
                    "href":"tasks-prepare-upgrade-oracle-database.html#GUID-733D2563-A42D-4366-9FCD-DABD25D0E2DF",
                    "topics":[
                        {
                            "title":"Tasks to Prepare for Oracle Database Upgrades",
                            "href":"tasks-to-prepare-for-oracle-database-upgrades.html#GUID-3C319260-B5CD-4C50-B606-36D060FDF0BE",
                            "topics":[
                                {
                                    "title":"Become Familiar with New Oracle Database Features",
                                    "href":"become-familiar-with-new-database-features.html#GUID-46BF5A44-69EC-4952-AD0A-81F732EA9181"
                                },
                                {
                                    "title":"Pre-Upgrade Information Check with AutoUpgrade",
                                    "href":"preupgrade-information-tool-checklist.html#GUID-2DB48303-DC1E-41CD-831D-864D76BD8061"
                                },
                                {
                                    "title":"Review Deprecated and Desupported Features",
                                    "href":"review-deprecated-desupported-features.html#GUID-C86D0012-A8D8-448B-87C7-0EAD59B93361"
                                },
                                {
                                    "title":"Choose an Upgrade Method for Oracle Database",
                                    "href":"choose-an-upgrade-method-for-oracle-database.html#GUID-9774D863-E62C-4B49-9696-B5D244EF2826"
                                },
                                {
                                    "title":"Choose a New Location for Oracle Home when Upgrading or Patching",
                                    "href":"choose-a-new-location-for-oracle-home-when-upgrading.html#GUID-AFA0564D-F5B5-40CA-988C-011AFCE2084B"
                                },
                                {
                                    "title":"Develop a Test Plan for Upgrading Oracle Database",
                                    "href":"develop-a-test-plan-for-upgrading-database.html#GUID-1CE27BA9-26B0-491D-89EB-A01F06CEC9D2"
                                },
                                {
                                    "title":"Schema-Only Accounts and Upgrading EXPIRED Password Accounts",
                                    "href":"schema-only-accounts-upgraded-expired-password-accounts.html#GUID-D2C22951-2BBA-4A18-85C2-F0DF38839EF8"
                                },
                                {
                                    "title":"Back Up Files to Preserve Downgrade and Recovery Options",
                                    "href":"back-up-files-to-preserve-downgrade.html#GUID-42C0E7B6-8668-48E8-AC4E-FACB02121B64"
                                }
                            ]
                        },
                        {
                            "title":"Installing the New Oracle Database Software for Single Instance",
                            "href":"installing-software-only-oracle-database-single-instance.html#GUID-9FFE2643-6529-4AB2-A92F-082361739A81"
                        },
                        {
                            "title":"Installing the New Oracle Database Software for Oracle RAC",
                            "href":"installing-new-oracle-database-software.html#GUID-8C58EB98-BCB6-43DB-A3F4-31F6D17F7266"
                        },
                        {
                            "title":"Database Preparation Tasks to Complete Before Starting Oracle AI Database Upgrades",
                            "href":"database-preparation-tasks-to-complete-before-upgrades.html#GUID-58C1A4B9-32F4-44E5-B82B-5D0EC78A6AE2"
                        },
                        {
                            "title":"Preparing the New Oracle Home for Upgrading",
                            "href":"preparing-new-oracle-home-for-upgrade.html#GUID-E9112AB3-2230-495C-8BB7-9998A6BF903E"
                        },
                        {
                            "title":"Prerequisites for Preparing Oracle Home on Windows",
                            "href":"prerequisites-for-preparing-oracle-home-on-windows.html#GUID-78AA584B-F911-4E31-B9D9-CFA0B67DD960"
                        },
                        {
                            "title":"Performing Preupgrade Checks Using AutoUpgrade",
                            "href":"using-autoupgrade-utility-perform-checks.html#GUID-A177DDAB-C617-476B-8718-041333DAA67B"
                        },
                        {
                            "title":"Testing the Upgrade Process for Oracle Database",
                            "href":"testing-upgraded-production-oracle-database.html#GUID-DA291D0C-5680-48D3-90A8-CF4217577A6B"
                        },
                        {
                            "title":"Upgrade Oracle Call Interface (OCI) and Precompiler Applications",
                            "href":"upgrade-oci-precompiler-applications.html#GUID-DCDFE417-1D74-4154-B565-5E34E616E1BA"
                        },
                        {
                            "title":"Requirements for Upgrading Databases That Use Oracle Database Vault",
                            "href":"requirements-upgrading-databases-that-use-oracle-label-security-and-oracle-database-vault.html#GUID-8EEEB9FC-CEFC-451C-8EC7-4B6D03418B96"
                        },
                        {
                            "title":"Back Up Oracle Database Before Upgrading",
                            "href":"backing-up-oracle-db-for-upgrading.html#GUID-E3BF972C-26EA-436D-B09B-716B3DB90A23"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Upgrading Databases with Oracle Data Guard Standbys",
                    "href":"upgrading-databases-with-oracle-data-guard-standby-databases.html#GUID-3697D19A-9383-49C9-B64A-055E4133B331",
                    "topics":[
                        {
                            "title":"Preparing for Upgrades of Databases Using Oracle Data Guard",
                            "href":"preparing-database-rolling-upgrades-using-oracle-data-guard.html#GUID-4C56C03E-671E-4518-830A-81B1F5EAFF76"
                        },
                        {
                            "title":"Manual Non-CDB to PDB Conversion and Upgrade with Data Guard Standby",
                            "href":"manual-non-cdb-to-pdb-conversion-data-guard-standbys.html#GUID-6F201EED-E013-4D80-A6ED-30272BD66D27"
                        },
                        {
                            "title":"Before You Patch or Upgrade the Oracle Database Software",
                            "href":"before-you-patch-or-upgrade-oracle-database-data-guard.html#GUID-784C06D8-9CFA-4244-BA55-D7003CAB3F1E"
                        },
                        {
                            "title":"Recovering After the NOLOGGING Clause Is Specified",
                            "href":"recovering-after-nologging-clause-specified-data-guard.html#GUID-BD9E85AB-D812-4659-9C85-26CDFF115A8A"
                        },
                        {
                            "title":"Enable an Appropriate Logging Mode",
                            "href":"enable-logging-mode-data-guard.html#GUID-AE2B1237-57A1-4745-A04C-4246A831A963"
                        },
                        {
                            "title":"Upgrading Oracle Database with a Physical Standby Database in Place",
                            "href":"upgrading-oracle-database-physical-standby-data-guard.html#GUID-6431EFBF-6B00-4E7D-A106-63574225BDD9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Using AutoUpgrade for Oracle Database Upgrades",
                    "href":"using-autoupgrade-oracle-database-upgrades.html#GUID-71883C8C-7A34-4E93-8955-040CB04F2109",
                    "topics":[
                        {
                            "title":"About Oracle Database AutoUpgrade",
                            "href":"about-oracle-database-autoupgrade.html#GUID-3FCFB2A6-4617-4783-828A-41BD635FC88C"
                        },
                        {
                            "title":"Examples of How to Use AutoUpgrade",
                            "href":"examples-of-autoupgrade-workflows.html#GUID-6A4B79EB-2CE6-44FF-8FF4-C67B09D82F12"
                        },
                        {
                            "title":"AutoUpgrade Messages and Process Description Terms",
                            "href":"autoupgrade-messages-process-description-terms.html#GUID-BA8F8767-F6CF-477F-BE88-AC1829CEF88A"
                        },
                        {
                            "title":"About AutoUpgrade Processing Modes",
                            "href":"about-autoupgrade-processing-modes.html#GUID-986294F2-814A-4392-BCA9-F9250D9E2775"
                        },
                        {
                            "title":"Understanding AutoUpgrade Workflows and Stages",
                            "href":"understanding-autoupgrade-workflows-stages.html#GUID-8C1FC4E1-2C9C-4CBC-AF5B-95F311D73BE4"
                        },
                        {
                            "title":"Understanding Non-CDB to PDB Upgrades with AutoUpgrade",
                            "href":"understanding-non-cdb-to-pdb-upgrades-autoupgrade.html#GUID-D739E4A4-F1B9-45BE-B0E2-F213FE70F665"
                        },
                        {
                            "title":"Understanding Unplug-Plug Upgrades with AutoUpgrade",
                            "href":"understanding-pdb-unplug-plug-upgrades-autoupgrade.html#GUID-F03BAE5B-DFB7-40AF-8109-670DDD42589A"
                        },
                        {
                            "title":"AutoUpgrade Command-Line Parameters and Options",
                            "href":"autoupgrade-command-line-parameters.html#GUID-F535B6AC-7F42-4328-B8B2-9E8870E6DFF6"
                        },
                        {
                            "title":"Understanding AutoUpgrade Utility Configuration Files Parameters and Options",
                            "href":"understanding-autoupgrade-utility-configuration-files.html#GUID-C55BC9C5-D9DC-4BA5-BAA0-CE34AC93F095",
                            "topics":[
                                {
                                    "title":"About Locally Modifiable Global Parameters for AutoUpgrade Configuration File",
                                    "href":"about-locally-modify-global-parameters-autoupgrade-config-file.html#GUID-B5B44FC6-C2DA-462E-8F90-474AEA01037C"
                                },
                                {
                                    "title":"About Local Parameters for the AutoUpgrade Configuration File",
                                    "href":"about-local-parameters-autoupgrade-config-file.html#GUID-6AF95954-DAD4-47E2-9318-5EB35631F83D"
                                },
                                {
                                    "title":"About Global Parameters for the AutoUpgrade User Configuration File",
                                    "href":"about-global-parameters-autoupgrade-config-file.html#GUID-5C5542C0-F21E-4DBF-A878-27F5F4AF6519"
                                }
                            ]
                        },
                        {
                            "title":"Common Parameters for the AutoUpgrade Configuration File (Upgrade and Patch)",
                            "href":"common-parameters-autoupgrade-config-file.html#GUID-16A44308-178F-4511-A80C-EA63C528AD4B"
                        },
                        {
                            "title":"Upgrade Parameters for the AutoUpgrade Configuration File",
                            "href":"upgrade-parameters-autoupgrade-config-file.html#GUID-DA3997E5-51AB-4FFF-9028-13B42740DE42"
                        },
                        {
                            "title":"Patch Parameters for the AutoUpgrade Configuration File",
                            "href":"patch-parameters-autoupgrade-config-file.html#GUID-6299B2D2-9A65-4268-A88D-5213B785EC66"
                        },
                        {
                            "title":"AutoUpgrade and Oracle Database Configuration Options",
                            "href":"autoupgrade-oracle-database-config-options.html#GUID-0A42F734-FC51-47C0-BA21-7504C742501A"
                        },
                        {
                            "title":"AutoUpgrade Patching",
                            "href":"autoupgrade-patching.html#GUID-20D02F58-2A55-4FC6-B726-113AB44FDCB7"
                        },
                        {
                            "title":"AutoUpgrade Configuration File Examples",
                            "href":"autoupgrade-configuration-file-examples.html#GUID-AC404F2D-70CB-4BB2-B177-A2CDF6B0B862"
                        },
                        {
                            "title":"AutoUpgrade Internal Settings Configuration File",
                            "href":"autoupgrade-internal-settings-config-file-parameters.html#GUID-F6B11B94-E0E8-499D-8FAE-5FE6BFAC3F39"
                        },
                        {
                            "title":"AutoUpgrade Log File Structure",
                            "href":"autoupgrade-log-file-structure.html#GUID-31F89463-C990-4BDC-85A2-8057B3479C89"
                        },
                        {
                            "title":"Enabling Full Deployments for AutoUpgrade",
                            "href":"enabling-full-deployments-autoupgrade.html#GUID-632ED90B-3116-49B6-AD49-75A0C47699B7"
                        },
                        {
                            "title":"Examples of How to Use the AutoUpgrade Console",
                            "href":"how-to-use-autoupgrade-console.html#GUID-1A77ACA5-B5DA-4F26-8BE3-5125BD4FE1B1"
                        },
                        {
                            "title":"Known Restrictions for AutoUpgrade",
                            "href":"known-restrictions-autoupgrade.html#GUID-0738AD0B-84D9-49F5-A513-4A5915EF8AEE"
                        },
                        {
                            "title":"Proper Management of AutoUpgrade Database Changes",
                            "href":"proper-management-autoupgrade-database-changes.html#GUID-161FC9EB-0E96-41DE-9500-3D419114E274"
                        },
                        {
                            "title":"How to Override Default Fixups",
                            "href":"how-to-override-default-fixups.html#GUID-4D4F8626-6C05-4D8F-BD90-BCEBA829773B"
                        },
                        {
                            "title":"Local Configuration File Parameter Fixups Checklist Example",
                            "href":"config-file-parameter-fixups-checklist.html#GUID-2D9ED6FA-11F5-4A1F-9E02-5D18451096A8"
                        },
                        {
                            "title":"AutoUpgrade and Microsoft Windows ACLs and CLIs",
                            "href":"autoupgrade-microsoft-windows-access-cointrol-lists.html#GUID-A621851A-CAC8-4BB7-828B-CE5DA7DC62E7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Using Other Methods for Oracle Database Upgrades",
                    "href":"upgrade-pdb-noncdbs-replay-upgrade-autoupgrade-fpp-gold-image.html#GUID-CC88F262-3370-4FFA-8604-EDA9F20F56D9",
                    "topics":[
                        {
                            "title":"Upgrading Oracle Database Releases Using Replay Upgrade",
                            "href":"adopting-non-cdb-pbs-using-capture-upgrade.html#GUID-77BA4A1D-447F-46FB-B3EE-C58B8546FEB0"
                        },
                        {
                            "title":"Upgrading Non-CDB Oracle Database Release with the Source CDB",
                            "href":"upgrade-scenarios-non-cdb-oracle-databases.html#GUID-B9505420-7D07-4260-BC2E-D677180365A7"
                        },
                        {
                            "title":"Upgrading Oracle Database Using Fleet Patching and Provisioning",
                            "href":"upgrading-oracle-database-fleet-patching-provisioning.html#GUID-9456CC2B-46D0-4083-93F3-3B20A00D5A79"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Troubleshooting the Upgrade for Oracle Database",
                    "href":"troubleshooting-oracle-database-upgrade.html#GUID-474BFAA2-0CD6-4672-8A7A-BF640F4FBFB2"
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Postupgrade Tasks for Oracle Database",
                    "href":"post-upgrade-tasks-oracle-database.html#GUID-637ADBD0-866B-4B64-9513-4C7CDE84895C",
                    "topics":[
                        {
                            "title":"Check the Upgrade With Post-Upgrade Status Tool",
                            "href":"check-upgrade-post-upgrade-status-tool.html#GUID-ADD5F3FB-5B7B-42F2-AB1B-FE0B9DE0CF41"
                        },
                        {
                            "title":"How to Show the Current State of the Oracle Data Dictionary",
                            "href":"how-to-show-current-state-oracle-data-dictionary.html#GUID-57458D9B-9927-4E1A-8F6C-5B2A301B30C4"
                        },
                        {
                            "title":"Required Tasks to Complete After Upgrading Oracle Database",
                            "href":"required-tasks-complete-upgrading-oracle-database.html#GUID-C9102D8A-0BD1-41FF-9AE9-656818267FB9"
                        },
                        {
                            "title":"Recommended and Best Practices to Complete After Upgrading Oracle Database",
                            "href":"recommended-and-best-practices-complete-upgrading-oracle-database.html#GUID-5196CE88-8669-45D6-8906-C45272940740"
                        },
                        {
                            "title":"Recommended Tasks After Upgrading an Oracle RAC Database",
                            "href":"recommended-tasks-after-upgrade-oracle-rac.html#GUID-67805AAF-14F4-4B57-8D83-FD7B608E0444"
                        },
                        {
                            "title":"Recommended Tasks After Upgrading Oracle ASM",
                            "href":"recommended-tasks-upgrading-oracle-asm.html#GUID-984B06FD-3B16-4713-BE62-7079E30340B1"
                        },
                        {
                            "title":"Migrating Oracle Database Express Edition to Oracle Database Free",
                            "href":"upgrading-oracle-database-express-edition-to-oracle-database-free.html#GUID-4C7731F9-C3D8-4198-8709-48D80416A479"
                        },
                        {
                            "title":"Tasks to Complete After Testing Your Oracle Database Upgrade",
                            "href":"tasks-complete-only-manually-upgrading-oracle-database.html#GUID-7611721E-D87B-41FF-9595-F9B311ABA0EC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Upgrading Applications After Upgrading Oracle Database",
                    "href":"upgrading-apps-after-oracle-db-upgrade.html#GUID-54B5CF85-BEC6-464B-9CDC-B2D3597B7423",
                    "topics":[
                        {
                            "title":"Overview of Upgrading Applications on a New Oracle Database Release",
                            "href":"overview-upgrading-applications-new-oracle-database-release.html#GUID-FFD82ACD-F76B-42D7-AEF1-E8BBBDBF9B59"
                        },
                        {
                            "title":"Compatibility Issues for Applications on Different Releases of Oracle Database",
                            "href":"compatibility-issues-applications-different-releases-oracle-database.html#GUID-B66FED88-9808-4BCF-93A7-B4511FB536B4"
                        },
                        {
                            "title":"Software Upgrades and Client and Server Configurations for Oracle Database",
                            "href":"software-upgrades-and-client-and-server-configurations-oracle-database.html#GUID-4E4BED49-A224-443C-8321-7900A4D4AEFB"
                        },
                        {
                            "title":"Compatibility Rules for Applications When Upgrading Oracle Database Client or Server Software",
                            "href":"compatibility-rules-applications-when-upgrading-oracle-database-client-server-software.html#GUID-5E9ED158-696B-4320-A2F8-7AE21BDFA0FB"
                        },
                        {
                            "title":"About Upgrading Precompiler and OCI Applications in Oracle Database",
                            "href":"upgrade-precompiler-oci-apps-oracle-database.html#GUID-624A9128-1FD8-4CE6-B69A-97A6E4A4882E"
                        },
                        {
                            "title":"Schema-Only Accounts and Upgrading EXPIRED Password Accounts",
                            "href":"schema-only-accounts-upgrading-expired-password-accts.html#GUID-D2C22951-2BBA-4A18-85C2-F0DF38839EF8"
                        },
                        {
                            "title":"About Upgrading Options for Oracle Precompiler and OCI Applications",
                            "href":"upgrade-options-precompiler-oci.html#GUID-70243AA4-D921-4EF7-8C33-DB0B6BF27739"
                        },
                        {
                            "title":"Upgrading SQL*Plus Scripts and PL/SQL after Upgrading Oracle Database",
                            "href":"upgrading-sqlplus-scripts-and-pl-sql-database.html#GUID-E67A7E60-6FFD-4A99-848B-CC65B8E14FE1"
                        },
                        {
                            "title":"About Upgrading Oracle Forms or Oracle Developer Applications",
                            "href":"upgrading-oracle-forms-oracle-developer-applications.html#GUID-E959A530-051A-4455-BD06-AF5CCB62E2FC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Downgrading Oracle Database to an Earlier Release",
                    "href":"downgrading-oracle-db-after-upgrade.html#GUID-CAD9888A-2E6E-48F8-938C-B3E861738606",
                    "topics":[
                        {
                            "title":"Supported Releases for Downgrading Oracle Database",
                            "href":"supported-releases-for-downgrading-oracle.database.html#GUID-59F92E2A-DC4D-46A3-9AC9-63F47BE4A86F"
                        },
                        {
                            "title":"Prepare to Downgrade a Standby Database with the Primary",
                            "href":"prepare-downgrade-standby-database-with-primary.html#GUID-A025D9F8-3CCF-4F7E-85DD-8F5CFCFB3A05"
                        },
                        {
                            "title":"Check COMPATIBLE Parameter when Downgrading Oracle Database",
                            "href":"check-incompatibilities-before-downgrading-oracle-database.html#GUID-16E57DCD-0136-4E2D-8EB8-CE5572FCB010"
                        },
                        {
                            "title":"Perform a Full Backup Before Downgrading Oracle Database",
                            "href":"perform-full-backup-before-downgrading-oracle-database.html#GUID-FFECBDB5-6FA3-4A32-B817-BCBCE4C93C4B"
                        },
                        {
                            "title":"Using Scripts to Downgrade Oracle AI Database",
                            "href":"using-scripts-to-downgrade-oracle-database.html#GUID-EF4B784F-BF90-48B5-80B5-3D4E209F8F8E"
                        },
                        {
                            "title":"Downgrading a Single Pluggable Oracle Database (PDB)",
                            "href":"downgrading-single-pluggable-pdb-oracle-database.html#GUID-66560D5D-A5C8-4ACC-82C0-46315465E77F"
                        },
                        {
                            "title":"Downgrading PDBs That Contain Oracle APEX",
                            "href":"downgrading-pdbs-that-contain-oracle-application-express-apex.html#GUID-EEC355DD-AA56-4972-9EB3-139CEC457D65"
                        },
                        {
                            "title":"Post-Downgrade Tasks for Oracle Database Downgrades",
                            "href":"post-downgrade-tasks-oracle-database-downgrades.html#GUID-5DF45F07-90FB-4AE2-9814-4956D60726E5"
                        },
                        {
                            "title":"Troubleshooting the Downgrade of Oracle Database",
                            "href":"troubleshooting-downgrades-oracle.database.html#GUID-F3DAC69A-A5D0-4998-A14D-DCC8599AD3FA"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Oracle Database Changes, Desupports, and Deprecations",
                    "href":"oracle-database-changes-deprecations-desupports.html#GUID-44E0A12C-2918-4565-BB19-A1CBA4C0FDCD"
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle Database Upgrade Utilities",
                    "href":"oracle-database-upgrade-utilities.html#GUID-408F22C3-2AD6-4DA4-8015-F5C6149508F0",
                    "topics":[
                        {
                            "title":"Scripts Associated with Upgrading Oracle AI Database",
                            "href":"scripts-upgrade-oracle-database.html#GUID-7935BC31-8818-4757-A6E7-A180C3E95A62"
                        },
                        {
                            "title":"Upgrade Script (catctl) Parameters",
                            "href":"upgrade-catctl-pl-parameters.html#GUID-C667B51C-058F-48B6-86FE-12E9D82FDDBD"
                        },
                        {
                            "title":"Pre-Upgrade Information Tool and AutoUpgrade Preupgrade",
                            "href":"using-preupgrade-information-tool-for-oracle-database.html#GUID-C0219AF1-AD43-4097-B358-E53E48958647"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> AutoUpgrade Error Messages",
                    "href":"autoupgrade-error-messages.html#GUID-0EEBA8EF-CC14-4E91-9FB6-2CBD599A2F33"
                },
                {
                    "title":"<span class=\"secnum\">C </span> AutoUpgrade REST APIs",
                    "href":"autoupgrade-rest-apis.html#GUID-757E7473-3FDB-4AE8-978A-1E762630BCA2"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});