define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Audience",
                            "href":"audience.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"do-not-use-shared-global-topic-conventions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> What's New for Oracle AI Vector Search",
                    "href":"whats-new-oracle-ai-vector-search.html",
                    "topics":[
                        {
                            "title":"Oracle AI Database 26ai Release Updates",
                            "href":"oracle-ai-database-26ai-release-updates.html",
                            "topics":[
                                {
                                    "title":"July 2024, Release Update 23.5",
                                    "href":"july-2024-release-update-23.5.html"
                                },
                                {
                                    "title":"October 2024, Release Update 23.6",
                                    "href":"october-2024-release-update-23.6.html"
                                },
                                {
                                    "title":"January 2025, Release Update 23.7",
                                    "href":"january-2025-release-update-23.7.html"
                                },
                                {
                                    "title":"April 2025, Release Update 23.8",
                                    "href":"april-2025-release-update-23.8.html"
                                },
                                {
                                    "title":"July 2025, Release Update 23.9",
                                    "href":"july-2025-release-update-23.9.html"
                                }
                            ]
                        },
                        {
                            "title":"Autonomous AI Database Updates",
                            "href":"autonomous-ai-database-updates.html",
                            "topics":[
                                {
                                    "title":"June 2024",
                                    "href":"june-2024.html"
                                },
                                {
                                    "title":"July 2024",
                                    "href":"july-2024.html"
                                },
                                {
                                    "title":"August 2024",
                                    "href":"august-2024.html"
                                },
                                {
                                    "title":"September 2024",
                                    "href":"september-2024.html"
                                },
                                {
                                    "title":"October 2024",
                                    "href":"october-2024.html"
                                },
                                {
                                    "title":"November 2024",
                                    "href":"november-2024.html"
                                },
                                {
                                    "title":"December 2024",
                                    "href":"december-2024.html"
                                },
                                {
                                    "title":"January 2025",
                                    "href":"january-2025.html"
                                },
                                {
                                    "title":"February 2025",
                                    "href":"february-2025.html"
                                },
                                {
                                    "title":"March 2025",
                                    "href":"march-2025.html"
                                },
                                {
                                    "title":"April 2025",
                                    "href":"april-2025.html"
                                },
                                {
                                    "title":"May 2025",
                                    "href":"may-2025.html"
                                },
                                {
                                    "title":"June 2025",
                                    "href":"june-2025.html"
                                },
                                {
                                    "title":"July 2025",
                                    "href":"july-2025.html"
                                },
                                {
                                    "title":"August 2025",
                                    "href":"august-2025.html"
                                },
                                {
                                    "title":"September 2025",
                                    "href":"september-2025.html"
                                },
                                {
                                    "title":"October 2025",
                                    "href":"october-2025.html"
                                }
                            ]
                        },
                        {
                            "title":"Deprecated Features",
                            "href":"deprecated-features.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Overview",
                    "href":"overview-node.html",
                    "topics":[
                        {
                            "title":"Overview of Oracle AI Vector Search",
                            "href":"overview-ai-vector-search.html"
                        },
                        {
                            "title":"Why Use Oracle AI Vector Search?",
                            "href":"why-use-vector-search-instead-other-vector-databases.html"
                        },
                        {
                            "title":"Oracle AI Vector Search Workflow",
                            "href":"oracle-ai-vector-search-workflow.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Get Started",
                    "href":"get-started-node.html",
                    "topics":[
                        {
                            "title":"SQL Quick Start Using a Vector Embedding Model Uploaded into the Database",
                            "href":"sql-quick-start-using-vector-embedding-model-uploaded-database.html"
                        },
                        {
                            "title":"SQL Quick Start Using a FLOAT32 Vector Generator",
                            "href":"sql-quick-start-using-float32-vector-generator.html"
                        },
                        {
                            "title":"SQL Quick Start Using a BINARY Vector Generator",
                            "href":"sql-quick-start-using-binary-vector-generator.html"
                        },
                        {
                            "title":"Your Vector Documentation Map to GenAI Prompts",
                            "href":"your-vector-documentation-map-genai-prompts.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Generate Vector Embeddings",
                    "href":"generate-vector-embeddings-node.html",
                    "topics":[
                        {
                            "title":"About Vector Generation",
                            "href":"vector-generation.html",
                            "topics":[
                                {
                                    "title":"Understand the Stages of Data Transformations",
                                    "href":"understand-stages-data-transformations.html"
                                },
                                {
                                    "title":"About SQL Functions to Generate Embeddings",
                                    "href":"sql-functions-generate-embeddings.html"
                                },
                                {
                                    "title":"About PL/SQL Packages to Generate Embeddings",
                                    "href":"pl-sql-packages-generate-embeddings.html",
                                    "topics":[
                                        {
                                            "title":"About Chainable Utility Functions and Common Use Cases",
                                            "href":"chainable-utility-functions-and-common-use-cases.html"
                                        },
                                        {
                                            "title":"About Vector Helper Procedures",
                                            "href":"vector-helper-procedures.html"
                                        },
                                        {
                                            "title":"Supplied Vector Utility PL/SQL Packages",
                                            "href":"supplied-vector-utility-pl-sql-packages.html"
                                        },
                                        {
                                            "title":"Terms of Using Vector Utility PL/SQL Packages",
                                            "href":"terms-using-vector-utility-pl-sql-packages.html"
                                        },
                                        {
                                            "title":"Validate JSON Input Parameters",
                                            "href":"validate-json-input-parameters.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Import Pretrained Models in ONNX Format",
                            "href":"import-pretrained-models-onnx-format-vector-generation-database.html",
                            "topics":[
                                {
                                    "title":"ONNX Pipeline Models: Text Embedding",
                                    "href":"onnx-pipeline-models-text-embedding.html"
                                },
                                {
                                    "title":"ONNX Pipeline Models: Image Embedding",
                                    "href":"onnx-pipeline-models-image-embedding.html"
                                },
                                {
                                    "title":"ONNX Pipeline Models: CLIP Multi-Modal Embedding",
                                    "href":"onnx-pipeline-models-multi-modal-embedding.html"
                                },
                                {
                                    "title":"ONNX Pipeline Models: Text Classification",
                                    "href":"onnx-pipeline-models-text-classification.html"
                                },
                                {
                                    "title":"ONNX Pipeline Models: Reranking Pipeline",
                                    "href":"onnx-pipeline-models-reranking-pipeline.html"
                                },
                                {
                                    "title":"Convert Pretrained Models to ONNX Model: End-to-End Instructions for Text Embedding",
                                    "href":"convert-pretrained-models-onnx-model-end-end-instructions.html"
                                },
                                {
                                    "title":"Import ONNX Models into Oracle AI Database End-to-End Example",
                                    "href":"import-onnx-models-oracle-ai-database-end-end-example.html",
                                    "topics":[
                                        {
                                            "title":"Alternate Method to Import ONNX Models",
                                            "href":"alternate-method-import-onnx-models.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Access Third-Party Models for Vector Generation Leveraging Third-Party REST APIs",
                            "href":"access-third-party-models-vector-generation-leveraging-third-party-rest-apis.html"
                        },
                        {
                            "title":"Vector Generation Examples",
                            "href":"vector-generation-examples.html",
                            "topics":[
                                {
                                    "title":"Generate Embeddings",
                                    "href":"generate-embeddings.html",
                                    "topics":[
                                        {
                                            "title":"Convert Text String to Embedding Within Oracle Database",
                                            "href":"convert-text-string-embedding-oracle-database.html"
                                        },
                                        {
                                            "title":"Convert Text String to BINARY Embedding Outside Oracle Database",
                                            "href":"convert-text-string-binary-embedding-oracle-database.html"
                                        },
                                        {
                                            "title":"Convert Text String to Embedding Using Public REST Providers",
                                            "href":"convert-text-string-embedding-using-public-third-party-apis.html"
                                        },
                                        {
                                            "title":"Convert Text String to Embedding Using the Local REST Provider Ollama",
                                            "href":"convert-text-string-embedding-locally-ollama.html"
                                        },
                                        {
                                            "title":"Convert Image to Embedding Using Public REST Providers",
                                            "href":"convert-image-embedding-using-public-third-party-apis.html"
                                        },
                                        {
                                            "title":"Generate Multi-modal Embeddings Using CLIP",
                                            "href":"generate-multi-modal-embeddings-using-clip.html"
                                        },
                                        {
                                            "title":"Vectorize Relational Tables Using OML Feature Extraction Algorithms",
                                            "href":"vectorize-relational-tables-using-oml-feature-extraction-algorithms.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Perform Chunking With Embedding",
                                    "href":"perform-chunking-embedding.html",
                                    "topics":[
                                        {
                                            "title":"Convert Text to Chunks With Custom Chunking Specifications",
                                            "href":"convert-text-chunks-custom-chunking-specifications.html"
                                        },
                                        {
                                            "title":"Convert File to Text to Chunks to Embeddings Within Oracle Database",
                                            "href":"convert-file-text-chunks-embeddings-oracle-database.html"
                                        },
                                        {
                                            "title":"Convert File to Embeddings Within Oracle Database",
                                            "href":"convert-file-embeddings-oracle-database.html"
                                        },
                                        {
                                            "title":"Generate and Use Embeddings for an End-to-End Search",
                                            "href":"generate-and-use-embeddings-end-end-search.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Configure Chunking Parameters",
                                    "href":"configure-chunking-parameters.html",
                                    "topics":[
                                        {
                                            "title":"Explore Chunking Techniques and Examples",
                                            "href":"explore-chunking-techniques-and-examples.html"
                                        },
                                        {
                                            "title":"Create and Use Custom Vocabulary",
                                            "href":"create-and-use-custom-vocabulary.html"
                                        },
                                        {
                                            "title":"Create and Use Custom Language Data",
                                            "href":"create-and-use-custom-language-data.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Store Vector Embeddings",
                    "href":"store-vector-embeddings.html",
                    "topics":[
                        {
                            "title":"Create Tables Using the VECTOR Data Type",
                            "href":"create-tables-using-vector-data-type.html",
                            "topics":[
                                {
                                    "title":"Vectors in External Tables",
                                    "href":"vectors-external-tables.html",
                                    "topics":[
                                        {
                                            "title":"Querying an Inline External Table",
                                            "href":"querying-inline-external-table.html"
                                        },
                                        {
                                            "title":"Performing a Semantic Similarity Search Using External Table",
                                            "href":"performing-semantic-similarity-search-using-external-table.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Vectors in Distributed Database Tables",
                                    "href":"vectors-distributed-database-tables.html"
                                },
                                {
                                    "title":"BINARY Vectors",
                                    "href":"binary-vectors.html"
                                },
                                {
                                    "title":"SPARSE Vectors",
                                    "href":"sparse-vectors.html"
                                }
                            ]
                        },
                        {
                            "title":"Insert Vectors in a Database Table Using the INSERT Statement",
                            "href":"insert-vectors-database-table-using-insert-statement.html"
                        },
                        {
                            "title":"Load Vector Data Using SQL*Loader",
                            "href":"load-vector-data-using-sqlloader.html",
                            "topics":[
                                {
                                    "title":"Load Character Vector Data Using SQL*Loader Example",
                                    "href":"load-character-vector-data-using-sqlloader-example.html"
                                },
                                {
                                    "title":"Load Binary Vector Data Using SQL*Loader Example",
                                    "href":"load-binary-vector-data-using-sqlloader-example.html"
                                }
                            ]
                        },
                        {
                            "title":"Unload and Load Vectors Using Oracle Data Pump",
                            "href":"unload-and-load-vectors-using-oracle-data-pump.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Create Vector Indexes and Hybrid Vector Indexes",
                    "href":"create-vector-indexes-and-hybrid-vector-indexes.html",
                    "topics":[
                        {
                            "title":"Size the Vector Pool",
                            "href":"size-vector-pool.html"
                        },
                        {
                            "title":"Manage the Different Categories of Vector Indexes",
                            "href":"manage-different-categories-vector-indexes.html",
                            "topics":[
                                {
                                    "title":"In-Memory Neighbor Graph Vector Index",
                                    "href":"memory-neighbor-graph-vector-index.html",
                                    "topics":[
                                        {
                                            "title":"About In-Memory Neighbor Graph Vector Index",
                                            "href":"memory-neighbor-graph-vector-indexes.html",
                                            "topics":[
                                                {
                                                    "title":"Overview of Hierarchical Navigable Small World Indexes",
                                                    "href":"overview-hierarchical-navigable-small-world-indexes.html"
                                                },
                                                {
                                                    "title":"Transaction Support for HNSW Indexes",
                                                    "href":"transaction-support-hnsw-indexes.html"
                                                },
                                                {
                                                    "title":"HNSW Graph Persistence",
                                                    "href":"graph-persistence-hnsw-indexes.html"
                                                },
                                                {
                                                    "title":"HNSW RAC Duplication",
                                                    "href":"hnsw-duplication-rac-nodes.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Hierarchical Navigable Small World Index Syntax and Parameters",
                                            "href":"hierarchical-navigable-small-world-index-syntax-and-parameters.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Neighbor Partition Vector Index",
                                    "href":"neighbor-partition-vector-index.html",
                                    "topics":[
                                        {
                                            "title":"Understand Inverted File Flat Vector Indexes",
                                            "href":"understand-inverted-file-flat-vector-indexes.html"
                                        },
                                        {
                                            "title":"Understand Local Inverted File Flat Vector Indexes",
                                            "href":"understand-local-inverted-file-flat-vector-indexes.html"
                                        },
                                        {
                                            "title":"Inverted File Flat Vector Indexes Online Rebuild",
                                            "href":"inverted-file-flat-vector-indexes-online-rebuild.html"
                                        },
                                        {
                                            "title":"Included Columns",
                                            "href":"included-columns.html"
                                        },
                                        {
                                            "title":"Inverted File Flat CREATE INDEX",
                                            "href":"inverted-file-flat-index-creation-syntax-and-parameters.html"
                                        },
                                        {
                                            "title":"Inverted File Flat ALTER INDEX",
                                            "href":"inverted-file-flat-alter-index.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Partition Maintenance Operations and Vector indexes",
                                    "href":"partition-maintenance-operations-and-vector-indexes.html",
                                    "topics":[
                                        {
                                            "title":"Partition Maintenance Operations with GLOBAL Vector Indexes",
                                            "href":"partition-maintenance-operations-global-vector-indexes.html",
                                            "topics":[
                                                {
                                                    "title":"Experiment with Global IVF and HNSW Indexes",
                                                    "href":"experiment-global-ivf-and-hnsw-indexes.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Guidelines for Using Vector Indexes",
                                    "href":"guidelines-using-vector-indexes.html"
                                },
                                {
                                    "title":"Index Accuracy Report",
                                    "href":"index-accuracy-report.html"
                                },
                                {
                                    "title":"Vector Index Status, Checkpoint, and Advisor Procedures",
                                    "href":"vector-index-status-checkpoint-and-advisor-procedures.html"
                                }
                            ]
                        },
                        {
                            "title":"Manage Hybrid Vector Indexes",
                            "href":"manage-hybrid-vector-indexes.html",
                            "topics":[
                                {
                                    "title":"Understand Hybrid Vector Indexes",
                                    "href":"understand-hybrid-vector-indexes.html"
                                },
                                {
                                    "title":"Guidelines and Restrictions for Hybrid Vector Indexes",
                                    "href":"guidelines-and-restrictions-hybrid-vector-indexes.html"
                                },
                                {
                                    "title":"CREATE HYBRID VECTOR INDEX",
                                    "href":"create-hybrid-vector-index.html"
                                },
                                {
                                    "title":"Creating Hybrid Vector Indexes using DBMS_SEARCH API",
                                    "href":"creating-hybrid-vector-index-using-dbms_search-api.html"
                                },
                                {
                                    "title":"ALTER INDEX",
                                    "href":"alter-index.html"
                                }
                            ]
                        },
                        {
                            "title":"Vector Indexes in a Globally Distributed Database",
                            "href":"vector-indexes-gdd.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Use SQL Functions for Vector Operations",
                    "href":"use-sql-functions-vector-operations.html",
                    "topics":[
                        {
                            "title":"Vector Distance Functions and Operators",
                            "href":"vector-distance-functions-and-operators.html",
                            "topics":[
                                {
                                    "title":"Vector Distance Metrics",
                                    "href":"vector-distance-metrics.html",
                                    "topics":[
                                        {
                                            "title":"Euclidean and Euclidean Squared Distances",
                                            "href":"euclidean-and-squared-euclidean-distances.html"
                                        },
                                        {
                                            "title":"Cosine Similarity",
                                            "href":"cosine-similarity.html"
                                        },
                                        {
                                            "title":"Dot Product Similarity",
                                            "href":"dot-product-similarity.html"
                                        },
                                        {
                                            "title":"Manhattan Distance",
                                            "href":"manhattan-distance.html"
                                        },
                                        {
                                            "title":"Hamming Distance",
                                            "href":"hamming-distance.html"
                                        },
                                        {
                                            "title":"Jaccard Similarity",
                                            "href":"jaccard-similarity.html"
                                        },
                                        {
                                            "title":"Custom Distance Function",
                                            "href":"custom-distance-function.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"VECTOR_DISTANCE",
                                    "href":"vector_distance.html"
                                },
                                {
                                    "title":"L1_DISTANCE",
                                    "href":"l1_distance.html"
                                },
                                {
                                    "title":"L2_DISTANCE",
                                    "href":"l2_distance.html"
                                },
                                {
                                    "title":"COSINE_DISTANCE",
                                    "href":"cosine_distance.html"
                                },
                                {
                                    "title":"INNER_PRODUCT",
                                    "href":"inner_product.html"
                                },
                                {
                                    "title":"HAMMING_DISTANCE",
                                    "href":"hamming_distance-vecse.html"
                                },
                                {
                                    "title":"JACCARD_DISTANCE",
                                    "href":"jaccard_distance-vecse.html"
                                }
                            ]
                        },
                        {
                            "title":"Chunking and Vector Generation Functions",
                            "href":"chunking-and-vector-generation-functions.html",
                            "topics":[
                                {
                                    "title":"VECTOR_CHUNKS",
                                    "href":"vector_chunks.html"
                                },
                                {
                                    "title":"VECTOR_EMBEDDING",
                                    "href":"vector_embedding.html"
                                }
                            ]
                        },
                        {
                            "title":"Constructors, Converters, Descriptors, and Arithmetic Operators",
                            "href":"constructors-converters-descriptors-and-arithmetic-operators.html",
                            "topics":[
                                {
                                    "title":"Vector Constructors",
                                    "href":"vector-constructors.html",
                                    "topics":[
                                        {
                                            "title":"TO_VECTOR",
                                            "href":"to_vector-vecse.html"
                                        },
                                        {
                                            "title":"VECTOR",
                                            "href":"vector-vecse.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Vector Serializers",
                                    "href":"vector-serializers.html",
                                    "topics":[
                                        {
                                            "title":"FROM_VECTOR",
                                            "href":"from_vector-vecse.html"
                                        },
                                        {
                                            "title":"VECTOR_SERIALIZE",
                                            "href":"vector_serialize-vecse.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"VECTOR_NORM",
                                    "href":"vector_norm-vecse.html"
                                },
                                {
                                    "title":"VECTOR_DIMENSION_COUNT",
                                    "href":"vector_dimension_count-vecse.html"
                                },
                                {
                                    "title":"VECTOR_DIMS",
                                    "href":"vector_dims-vecse.html"
                                },
                                {
                                    "title":"VECTOR_DIMENSION_FORMAT",
                                    "href":"vector_dimension_format-vecse.html"
                                },
                                {
                                    "title":"Arithmetic Operators",
                                    "href":"arithmetic-operators.html"
                                },
                                {
                                    "title":"Aggregate Functions",
                                    "href":"aggregate-functions.html",
                                    "topics":[
                                        {
                                            "title":"AVG",
                                            "href":"avg_vecse.html"
                                        },
                                        {
                                            "title":"SUM",
                                            "href":"sum_vecse.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"JSON Compatibility with the VECTOR Data Type",
                            "href":"json-compatibility-vector-data-type.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Query Data With Similarity and Hybrid Searches",
                    "href":"query-data-similarity-and-hybrid-searches.html",
                    "topics":[
                        {
                            "title":"Perform Exact Similarity Search",
                            "href":"perform-exact-similarity-search.html"
                        },
                        {
                            "title":"Perform Approximate Similarity Search Using Vector Indexes",
                            "href":"perform-approximate-similarity-search-using-vector-indexes.html",
                            "topics":[
                                {
                                    "title":"Understand Approximate Similarity Search Using Vector Indexes",
                                    "href":"understand-approximate-similarity-search-using-vector-indexes.html"
                                },
                                {
                                    "title":"Optimizer Plans for Vector Indexes",
                                    "href":"optimizer-plans-vector-indexes.html",
                                    "topics":[
                                        {
                                            "title":"Optimizer Plans for HNSW Vector Indexes",
                                            "href":"optimizer-plans-hnsw-vector-indexes.html"
                                        },
                                        {
                                            "title":"Optimizer Plans for IVF Vector Indexes",
                                            "href":"optimizer-plans-ivf-vector-indexes.html",
                                            "topics":[
                                                {
                                                    "title":"Terminable Iteration for IVF Index",
                                                    "href":"terminable-iteration-ivf.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Vector Index Hints",
                                            "href":"vector-index-hints.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Approximate Similarity Search Examples",
                                    "href":"approximate-similarity-search-examples.html",
                                    "topics":[
                                        {
                                            "title":"Approximate Search Using HNSW",
                                            "href":"approximate-search-using-hnsw.html"
                                        },
                                        {
                                            "title":"Approximate Search Using IVF",
                                            "href":"approximate-search-using-ivf.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Perform Multi-Vector Similarity Search",
                            "href":"perform-multi-vector-similarity-search.html"
                        },
                        {
                            "title":"Perform Hybrid Search",
                            "href":"perform-hybrid-search.html",
                            "topics":[
                                {
                                    "title":"Understand Hybrid Search",
                                    "href":"understand-hybrid-search.html"
                                },
                                {
                                    "title":"Query Hybrid Vector Indexes End-to-End Example",
                                    "href":"query-hybrid-vector-indexes-end-end-example.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Work with LLM-Powered APIs and Retrieval Augmented Generation",
                    "href":"work-llm-powered-apis-and-retrieval-augmented-generation-node.html",
                    "topics":[
                        {
                            "title":"Use LLM-Powered APIs to Generate Summary and Text",
                            "href":"use-llm-powered-apis-generate-summary-and-text.html",
                            "topics":[
                                {
                                    "title":"Generate Summary",
                                    "href":"generate-summary.html",
                                    "topics":[
                                        {
                                            "title":"Generate Summary Using Public REST Providers",
                                            "href":"generate-summary-using-public-third-party-apis.html"
                                        },
                                        {
                                            "title":"Generate Summary Using the Local REST Provider Ollama",
                                            "href":"generate-summary-using-ollama.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Generate Text Response",
                                    "href":"generate-text-response.html",
                                    "topics":[
                                        {
                                            "title":"Generate Text Using Public REST Providers",
                                            "href":"generate-text-using-public-third-party-apis.html"
                                        },
                                        {
                                            "title":"Generate Text Using the Local REST Provider Ollama",
                                            "href":"generate-text-locally-ollama.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Describe Image Content",
                                    "href":"describe-image-content.html",
                                    "topics":[
                                        {
                                            "title":"Describe Images Using Public REST Providers",
                                            "href":"describe-images-using-public-third-party-apis.html"
                                        },
                                        {
                                            "title":"Describe Images Using the Local REST Provider Ollama",
                                            "href":"describe-images-using-ollama.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Use Retrieval Augmented Generation to Complement LLMs",
                            "href":"use-retrieval-augmented-generation-complement-llms.html",
                            "topics":[
                                {
                                    "title":"About Retrieval Augmented Generation",
                                    "href":"retrieval-augmented-generation1.html"
                                },
                                {
                                    "title":"SQL RAG Example",
                                    "href":"sql-rag-example.html"
                                },
                                {
                                    "title":"Oracle AI Vector Search Integration with LangChain",
                                    "href":"oracle-ai-vector-search-integration-langchain.html"
                                },
                                {
                                    "title":"Oracle AI Vector Search Integration with LlamaIndex",
                                    "href":"oracle-ai-vector-search-integration-llamaindex.html"
                                },
                                {
                                    "title":"Use Reranking for Better RAG Results",
                                    "href":"use-reranking-better-rag-results.html"
                                }
                            ]
                        },
                        {
                            "title":"Supported Third-Party Provider Operations and Endpoints",
                            "href":"supported-third-party-provider-operations-and-endpoints.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Supported Clients and Languages",
                    "href":"supported-clients-and-languages.html"
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Vector Diagnostics",
                    "href":"vector-diagnostics-node.html",
                    "topics":[
                        {
                            "title":"Oracle AI Vector Search Views",
                            "href":"oracle-ai-vector-search-views.html",
                            "topics":[
                                {
                                    "title":"Text Processing Views",
                                    "href":"text-processing-views.html",
                                    "topics":[
                                        {
                                            "title":"ALL_VECTOR_ABBREV_TOKENS",
                                            "href":"all_vector_abbrev_tokens.html"
                                        },
                                        {
                                            "title":"ALL_VECTOR_LANG",
                                            "href":"all_vector_lang.html"
                                        },
                                        {
                                            "title":"DBA_VECTOR_HITCOUNTS",
                                            "href":"dba_vector_hitcounts.html"
                                        },
                                        {
                                            "title":"USER_VECTOR_ABBREV_TOKENS",
                                            "href":"user_vector_abbrev_tokens.html"
                                        },
                                        {
                                            "title":"USER_VECTOR_HITCOUNTS",
                                            "href":"user_vector_hitcounts.html"
                                        },
                                        {
                                            "title":"USER_VECTOR_LANG",
                                            "href":"user_vector_lang.html"
                                        },
                                        {
                                            "title":"USER_VECTOR_VOCAB",
                                            "href":"user_vector_vocab.html"
                                        },
                                        {
                                            "title":"USER_VECTOR_VOCAB_TOKENS",
                                            "href":"user_vector_vocab_tokens.html"
                                        },
                                        {
                                            "title":"ALL_VECTOR_VOCAB",
                                            "href":"all_vector_vocab.html"
                                        },
                                        {
                                            "title":"ALL_VECTOR_VOCAB_TOKENS",
                                            "href":"all_vector_vocab_tokens.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Vector Memory Pool Views",
                                    "href":"vector-memory-pool-views.html",
                                    "topics":[
                                        {
                                            "title":"V$VECTOR_MEMORY_POOL",
                                            "href":"vvector_memory_pool.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Vector Index and Hybrid Vector Index Views",
                                    "href":"vector-index-and-hybrid-vector-index-views.html",
                                    "topics":[
                                        {
                                            "title":"VECSYS.VECTOR$INDEX",
                                            "href":"vecsys-vectorindex.html"
                                        },
                                        {
                                            "title":"V$VECTOR_INDEX",
                                            "href":"vvector_index.html"
                                        },
                                        {
                                            "title":"V$VECTOR_GRAPH_INDEX",
                                            "href":"vvector_graph_index.html"
                                        },
                                        {
                                            "title":"V$VECTOR_GRAPH_INDEX_CHKPT",
                                            "href":"vvector_graph_index_chkpt.html"
                                        },
                                        {
                                            "title":"V$VECTOR_GRAPH_INDEX_SNAPSHOTS",
                                            "href":"vvector_graph_index_snapshots.html"
                                        },
                                        {
                                            "title":"V$VECTOR_PARTITIONS_INDEX",
                                            "href":"vvector_partitions_index.html"
                                        },
                                        {
                                            "title":"VECSYS.VECTOR$INDEX$CHECKPOINTS",
                                            "href":"vecsys-vectorindexcheckpoints.html"
                                        },
                                        {
                                            "title":"<index name>$VECTORS",
                                            "href":"indexnamevectors.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Oracle AI Vector Search Statistics",
                            "href":"oracle-ai-vector-search-statistics.html",
                            "topics":[
                                {
                                    "title":"Oracle AI Vector Search Dictionary Statistics",
                                    "href":"oracle-ai-vector-search-dictionary-statistics.html"
                                },
                                {
                                    "title":"Oracle Machine Learning Static Dictionary Views",
                                    "href":"oracle-machine-learning-static-dictionary-views.html"
                                }
                            ]
                        },
                        {
                            "title":"Oracle AI Vector Search Parameters",
                            "href":"oracle-ai-vector-search-parameters.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Vector Search PL/SQL Packages",
                    "href":"vector-search-pl-sql-packages-node.html",
                    "topics":[
                        {
                            "title":"DBMS_VECTOR",
                            "href":"dbms_vector-vecse.html",
                            "topics":[
                                {
                                    "title":"CREATE_CREDENTIAL",
                                    "href":"create_credential-dbms_vector.html"
                                },
                                {
                                    "title":"CREATE_INDEX",
                                    "href":"create_index.html"
                                },
                                {
                                    "title":"DISABLE_CHECKPOINT",
                                    "href":"disable_checkpoint.html"
                                },
                                {
                                    "title":"DROP_CREDENTIAL",
                                    "href":"drop_credential-dbms_vector.html"
                                },
                                {
                                    "title":"DROP_ONNX_MODEL Procedure",
                                    "href":"drop_onnx_model-procedure-dbms_vector.html"
                                },
                                {
                                    "title":"ENABLE_CHECKPOINT",
                                    "href":"enable_checkpoint.html"
                                },
                                {
                                    "title":"GET_INDEX_STATUS",
                                    "href":"get_index_status.html"
                                },
                                {
                                    "title":"INDEX_ACCURACY_QUERY",
                                    "href":"index_accuracy_query.html"
                                },
                                {
                                    "title":"INDEX_ACCURACY_REPORT",
                                    "href":"index_accuracy_report.html"
                                },
                                {
                                    "title":"INDEX_VECTOR_MEMORY_ADVISOR",
                                    "href":"index_vector_memory_advisor.html"
                                },
                                {
                                    "title":"LOAD_ONNX_MODEL",
                                    "href":"load_onnx_model-procedure.html",
                                    "topics":[
                                        {
                                            "title":"JSON Metadata Parameters for ONNX Models",
                                            "href":"json-metadata-parameters-onnx-models.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"LOAD_ONNX_MODEL_CLOUD",
                                    "href":"load_onnx_model_cloud.html"
                                },
                                {
                                    "title":"QUERY",
                                    "href":"query.html"
                                },
                                {
                                    "title":"REBUILD_INDEX",
                                    "href":"rebuild_index.html"
                                },
                                {
                                    "title":"UTL_TO_RERANK",
                                    "href":"utl_to_rerank-dbms_vector.html"
                                },
                                {
                                    "title":"UTL_TO_CHUNKS",
                                    "href":"utl_to_chunks-dbms_vector.html"
                                },
                                {
                                    "title":"UTL_TO_EMBEDDING and UTL_TO_EMBEDDINGS",
                                    "href":"utl_to_embedding-and-utl_to_embeddings-dbms_vector.html"
                                },
                                {
                                    "title":"UTL_TO_GENERATE_TEXT",
                                    "href":"utl_to_generate_text-dbms_vector.html"
                                }
                            ]
                        },
                        {
                            "title":"DBMS_VECTOR_CHAIN",
                            "href":"dbms_vector_chain-vecse.html",
                            "topics":[
                                {
                                    "title":"CREATE_CREDENTIAL",
                                    "href":"create_credential-dbms_vector_chain.html"
                                },
                                {
                                    "title":"CREATE_LANG_DATA",
                                    "href":"create_lang_data.html"
                                },
                                {
                                    "title":"CREATE_PREFERENCE",
                                    "href":"create_preference.html"
                                },
                                {
                                    "title":"CREATE_VOCABULARY",
                                    "href":"create_vocabulary.html"
                                },
                                {
                                    "title":"DROP_CREDENTIAL",
                                    "href":"drop_credential-dbms_vector_chain.html"
                                },
                                {
                                    "title":"DROP_LANG_DATA",
                                    "href":"drop_lang_data.html"
                                },
                                {
                                    "title":"DROP_PREFERENCE",
                                    "href":"drop_preference.html"
                                },
                                {
                                    "title":"DROP_VOCABULARY",
                                    "href":"drop_vocabulary.html"
                                },
                                {
                                    "title":"UTL_TO_RERANK",
                                    "href":"utl_to_rerank-dbms_vector_chain.html"
                                },
                                {
                                    "title":"UTL_TO_CHUNKS",
                                    "href":"utl_to_chunks-dbms_vector_chain.html"
                                },
                                {
                                    "title":"UTL_TO_EMBEDDING and UTL_TO_EMBEDDINGS",
                                    "href":"utl_to_embedding-and-utl_to_embeddings-dbms_vector_chain.html"
                                },
                                {
                                    "title":"UTL_TO_GENERATE_TEXT",
                                    "href":"utl_to_generate_text-dbms_vector_chain.html"
                                },
                                {
                                    "title":"UTL_TO_SUMMARY",
                                    "href":"utl_to_summary.html"
                                },
                                {
                                    "title":"UTL_TO_TEXT",
                                    "href":"utl_to_text.html"
                                },
                                {
                                    "title":"Supported Languages and Data File Locations",
                                    "href":"supported-languages-and-data-file-locations.html"
                                }
                            ]
                        },
                        {
                            "title":"DBMS_HYBRID_VECTOR",
                            "href":"dbms_hybrid_vector-vecse.html",
                            "topics":[
                                {
                                    "title":"SEARCH",
                                    "href":"search.html"
                                },
                                {
                                    "title":"GET_SQL",
                                    "href":"get_sql.html"
                                },
                                {
                                    "title":"SEARCHPIPELINE",
                                    "href":"searchpipeline.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Python Classes to Convert Pretrained Models to ONNX Models (Deprecated)",
                    "href":"python-classes-convert-pretrained-models-onnx-models-deprecated.html"
                },
                {
                    "title":"Glossary",
                    "href":"Chunk1892559167.html"
                }
            ]
        }
    ]
});