define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-2C12DC44-6459-4190-93CB-5DC6C3A7C6DA"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Developing for Oracle NoSQL Database",
                    "href":"developing.html",
                    "topics":[
                        {
                            "title":"Configuring Logging",
                            "href":"configuring-logging.html"
                        },
                        {
                            "title":"Obtaining a KVStore Handle",
                            "href":"obtaining-kvstore-handle.html#GUID-356C5859-C6C9-4C09-BAB0-9374C279C859"
                        },
                        {
                            "title":"Using the Authentication APIs",
                            "href":"using-authentication-apis-working-secured-store.html#GUID-4958D9E9-69B5-4E40-A116-B5A5CB2BE408"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Introduction to Oracle KVLite",
                    "href":"introduction-oracle-kvlite.html",
                    "topics":[
                        {
                            "title":"Starting KVLite",
                            "href":"starting-kvlite.html"
                        },
                        {
                            "title":"Stopping and Restarting KVLite",
                            "href":"stopping-and-restarting-kvlite.html"
                        },
                        {
                            "title":"Verifying the Installation",
                            "href":"verifying-installation.html"
                        },
                        {
                            "title":"kvlite Utility Command Line Parameter Options",
                            "href":"kvlite-utility-command-line-parameter-options.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Introducing Oracle NoSQL Database Tables and Indexes",
                    "href":"introducing-tables-and-indexes.html",
                    "topics":[
                        {
                            "title":"Defining Tables",
                            "href":"defining-tables.html#GUID-FE0A841D-2063-4D7F-A930-65D94A676513"
                        },
                        {
                            "title":"Using the UUID data type",
                            "href":"using-uuid-data-type.html",
                            "topics":[
                                {
                                    "title":"Inserting rows into a table with a UUID column",
                                    "href":"inserting-rows-uuid-column.html"
                                },
                                {
                                    "title":"Updating rows of a table with a UUID column",
                                    "href":"updating-rows-uuid-column.html"
                                },
                                {
                                    "title":"Add or Remove a UUID column",
                                    "href":"alter-table-add-or-remove-uuid-column.html"
                                }
                            ]
                        },
                        {
                            "title":"Creating Indexes",
                            "href":"creating-indexes.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Introducing Oracle NoSQL Database Namespaces",
                    "href":"introducing-namespaces.html",
                    "topics":[
                        {
                            "title":"Creating Namespaces",
                            "href":"creating-namespaces.html"
                        },
                        {
                            "title":"Granting Authorization Access to Namespaces",
                            "href":"granting-authorization-access-namespaces.html"
                        },
                        {
                            "title":"Using and Setting Namespaces",
                            "href":"using-and-setting-namespaces.html"
                        },
                        {
                            "title":"Showing and Describing Namespaces",
                            "href":"showing-and-describing-namespace-information.html"
                        },
                        {
                            "title":"Dropping Namespaces",
                            "href":"dropping-namespaces.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Primary and Shard Key Design",
                    "href":"primary-and-shard-key-design.html",
                    "topics":[
                        {
                            "title":"Primary Keys",
                            "href":"primary-keys.html#GUID-6A063474-4A3A-4981-B1D8-71D0D95BE8DF"
                        },
                        {
                            "title":"Row Data",
                            "href":"row-data.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Writing and Deleting Table Rows",
                    "href":"writing-and-deleting-table-rows.html",
                    "topics":[
                        {
                            "title":"Write Exceptions",
                            "href":"write-exceptions-write-errors.html"
                        },
                        {
                            "title":"Writing Rows to a Table in the Store",
                            "href":"writing-rows-table-store.html#GUID-F889410D-D507-4479-B304-3984797D5BD3"
                        },
                        {
                            "title":"Bulk Put Operations",
                            "href":"bulk-put-operations.html"
                        },
                        {
                            "title":"Using Time to Live",
                            "href":"using-time-live.html#GUID-A768A8F9-309A-4018-8CC3-D2D6B8793C59"
                        },
                        {
                            "title":"Deleting Rows from the Store",
                            "href":"deleting-rows-store.html#GUID-5DD7B5DF-84ED-4640-AA52-B91A1DFC3B4F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Reading Table Rows",
                    "href":"reading-table-rows.html",
                    "topics":[
                        {
                            "title":"Read Exceptions",
                            "href":"read-exceptions-read-errors.html"
                        },
                        {
                            "title":"Retrieving a Single Row",
                            "href":"retrieving-single-row.html#GUID-D9424837-586A-42A1-A863-B9434D4BBBC3"
                        },
                        {
                            "title":"Using multiGet()",
                            "href":"using-multiget.html"
                        },
                        {
                            "title":"Iterating over Table Rows",
                            "href":"iterating-table-rows.html"
                        },
                        {
                            "title":"Specifying Field Ranges",
                            "href":"specifying-field-ranges.html"
                        },
                        {
                            "title":"Iterating with Nested Tables",
                            "href":"iterating-nested-tables.html"
                        },
                        {
                            "title":"Reading Indexes",
                            "href":"reading-indexes.html"
                        },
                        {
                            "title":"Parallel Scans",
                            "href":"parallel-scans.html"
                        },
                        {
                            "title":"Bulk Get Operations",
                            "href":"bulk-get-operations.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Using Data Types",
                    "href":"using-data-types.html",
                    "topics":[
                        {
                            "title":"Using Arrays",
                            "href":"using-arrays.html"
                        },
                        {
                            "title":"Using Binary",
                            "href":"using-binary.html"
                        },
                        {
                            "title":"Using Enums",
                            "href":"using-enums.html"
                        },
                        {
                            "title":"Using Fixed Binary",
                            "href":"using-fixed-binary.html"
                        },
                        {
                            "title":"Using JSON",
                            "href":"using-json.html"
                        },
                        {
                            "title":"Using Maps",
                            "href":"using-maps.html"
                        },
                        {
                            "title":"Using Embedded Records",
                            "href":"using-embedded-records.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Indexing Non-Scalar Data Types",
                    "href":"indexing-non-scalar-data-types.html",
                    "topics":[
                        {
                            "title":"Indexing Arrays",
                            "href":"indexing-arrays.html"
                        },
                        {
                            "title":"Indexing JSON Fields",
                            "href":"indexing-json-fields.html"
                        },
                        {
                            "title":"Indexing Maps",
                            "href":"indexing-maps.html#GUID-1069307A-5A14-48F6-98F9-83E0A60796EE"
                        },
                        {
                            "title":"Indexing Embedded Records",
                            "href":"indexing-embedded-records.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Using Row Versions",
                    "href":"using-versions-using-row-versions.html"
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Consistency Guarantees",
                    "href":"consistency-guarantees.html",
                    "topics":[
                        {
                            "title":"Specifying Consistency Policies",
                            "href":"specifying-consistency-policies.html"
                        },
                        {
                            "title":"Using Simple Consistency",
                            "href":"using-simple-consistency.html"
                        },
                        {
                            "title":"Using Time-Based Consistency",
                            "href":"using-time-based-consistency.html"
                        },
                        {
                            "title":"Using Version-Based Consistency",
                            "href":"using-version-based-consistency.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Durability Guarantees",
                    "href":"durability-guarantees.html",
                    "topics":[
                        {
                            "title":"Setting Acknowledgment-Based Durability Policies",
                            "href":"setting-acknowledgment-based-durability-policies.html"
                        },
                        {
                            "title":"Setting Synchronization-Based Durability Policies",
                            "href":"setting-synchronization-based-durability-policies.html"
                        },
                        {
                            "title":"Setting Durability Guarantees",
                            "href":"setting-durability-guarantees.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Executing a Sequence of Operations",
                    "href":"executing-sequence-operations.html",
                    "topics":[
                        {
                            "title":"Sequence Errors",
                            "href":"sequence-errors.html"
                        },
                        {
                            "title":"Creating a Sequence",
                            "href":"creating-sequence.html"
                        },
                        {
                            "title":"Executing a Sequence",
                            "href":"executing-sequence.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Introduction to SQL for Oracle NoSQL Database",
                    "href":"introduction-sql-oracle-nosql-database.html",
                    "topics":[
                        {
                            "title":"Running a simple query",
                            "href":"running-simple-query.html"
                        },
                        {
                            "title":"Using binding variables",
                            "href":"using-binding-variables.html"
                        },
                        {
                            "title":"Accessing metadata",
                            "href":"accessing-metadata.html"
                        },
                        {
                            "title":"Using a query to update data",
                            "href":"using-query-update-data.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> JSON By Example",
                    "href":"json-example.html",
                    "topics":[
                        {
                            "title":"Sample Data",
                            "href":"sample-data.html"
                        },
                        {
                            "title":"UpdateJSON",
                            "href":"updatejson.html"
                        },
                        {
                            "title":"UpdateJSON.run()",
                            "href":"updatejson-run.html"
                        },
                        {
                            "title":"UpdateJSON.defineTable()",
                            "href":"updatejson-definetable.html"
                        },
                        {
                            "title":"UpdateJSON.createIndex()",
                            "href":"updatejson-createindex.html"
                        },
                        {
                            "title":"UpdateJSON.runDDL()",
                            "href":"updatejson-runddl.html"
                        },
                        {
                            "title":"UpdateJSON.updateTableWithoutQuery()",
                            "href":"updatejson-updatetablewithoutquery.html"
                        },
                        {
                            "title":"UpdateJSON.updateTableWithIndex()",
                            "href":"updatejson-updatetablewithindex.html"
                        },
                        {
                            "title":"UpdateJSON.updateTableUsingSQLQuery()",
                            "href":"updatejson-updatetableusingsqlquery.html"
                        },
                        {
                            "title":"UpdateJSON.updateZipCode()",
                            "href":"updatejson-updatezipcode.html"
                        },
                        {
                            "title":"UpdateJSON.loadTable()",
                            "href":"updatejson-loadtable.html"
                        },
                        {
                            "title":"UpdateJSON.displayTable()",
                            "href":"updatejson-displaytable.html"
                        },
                        {
                            "title":"UpdateJSON.displayResult()",
                            "href":"updatejson-displayresult.html"
                        },
                        {
                            "title":"UpdateJSON.parseArgs()",
                            "href":"updatejson-parseargs.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Table Data Definition Language Overview",
                    "href":"table-data-definition-language-overview.html",
                    "topics":[
                        {
                            "title":"Name Constraints",
                            "href":"name-constraints.html"
                        },
                        {
                            "title":"DDL Comments",
                            "href":"ddl-comments.html"
                        },
                        {
                            "title":"CREATE TABLE",
                            "href":"create-table.html#GUID-653A1602-80CA-4AE5-906A-B224617AFF99"
                        },
                        {
                            "title":"Modify Table Definitions",
                            "href":"modify-table-definitions.html#GUID-BB4A49FF-C466-4D6A-A578-2FF95D78F82E"
                        },
                        {
                            "title":"DROP TABLE",
                            "href":"drop-table.html"
                        },
                        {
                            "title":"CREATE INDEX",
                            "href":"create-index.html#GUID-D2D3F9B9-4B1A-4422-B43B-2B4FAC10480B"
                        },
                        {
                            "title":"CREATE FULL TEXT INDEX",
                            "href":"create-full-text-index.html"
                        },
                        {
                            "title":"DROP INDEX",
                            "href":"drop-index.html"
                        },
                        {
                            "title":"DESCRIBE AS JSON TABLE",
                            "href":"describe-json-table.html"
                        },
                        {
                            "title":"DESCRIBE AS JSON INDEX",
                            "href":"describe-json-index.html"
                        },
                        {
                            "title":"SHOW TABLES",
                            "href":"show-tables.html"
                        },
                        {
                            "title":"SHOW INDEXES",
                            "href":"show-indexes.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Exceptions",
                    "href":"exceptions.html"
                }
            ]
        }
    ]
});