define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to SQL for Oracle NoSQL Database",
                    "href":"introduction-sql-nosql.html",
                    "topics":[
                        {
                            "title":"SQL Program",
                            "href":"sql-program.html"
                        },
                        {
                            "title":"EBNF Syntax",
                            "href":"ebnf-syntax.html"
                        },
                        {
                            "title":"Comments",
                            "href":"comments.html"
                        },
                        {
                            "title":"Identifiers",
                            "href":"identifiers.html"
                        },
                        {
                            "title":"Literals",
                            "href":"literals.html"
                        },
                        {
                            "title":"Operator Precedence",
                            "href":"operator-precedence.html"
                        },
                        {
                            "title":"Reserved Words",
                            "href":"reserved-words.html"
                        },
                        {
                            "title":"Case Sensitivity",
                            "href":"case-sensitivity.html"
                        },
                        {
                            "title":"Constraints",
                            "href":"constraints.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Oracle NoSQL Database Data Model",
                    "href":"data-model.html",
                    "topics":[
                        {
                            "title":"Atomic Data Types",
                            "href":"atomic-data-types.html"
                        },
                        {
                            "title":"Complex Data Types",
                            "href":"complex-data-types.html"
                        },
                        {
                            "title":"JSON Data Type",
                            "href":"json-data-type.html"
                        },
                        {
                            "title":"Wildcard Data Types",
                            "href":"wildcard-data-types.html"
                        },
                        {
                            "title":"Data Type Hierarchy",
                            "href":"data-type-hierarchy.html"
                        },
                        {
                            "title":"Data Type Definitions",
                            "href":"data-type-definitions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Namespace Management",
                    "href":"namespace-management.html",
                    "topics":[
                        {
                            "title":"CREATE NAMESPACE Statement",
                            "href":"create-namespace.html"
                        },
                        {
                            "title":"SHOW NAMESPACES Statement",
                            "href":"show-namespaces.html"
                        },
                        {
                            "title":"DROP NAMESPACE Statement",
                            "href":"drop-namespace.html"
                        },
                        {
                            "title":"Namespace Resolution",
                            "href":"namespace-resolution.html"
                        },
                        {
                            "title":"Namespace Scoped Privileges",
                            "href":"namespace-scoped-privileges.html"
                        },
                        {
                            "title":"Granting Authorization Access to Namespaces",
                            "href":"granting-authorization-access-namespaces.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Region Management",
                    "href":"region-management.html",
                    "topics":[
                        {
                            "title":"CREATE REGION Statement",
                            "href":"create-region.html"
                        },
                        {
                            "title":"SHOW REGIONS Statement",
                            "href":"show-regions.html"
                        },
                        {
                            "title":"DROP REGION Statement",
                            "href":"drop-region.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Table Management",
                    "href":"table-management.html",
                    "topics":[
                        {
                            "title":"CREATE TABLE Statement",
                            "href":"create-table.html"
                        },
                        {
                            "title":"SHOW TABLES Statement",
                            "href":"show-tables.html"
                        },
                        {
                            "title":"DESCRIBE TABLE Statement",
                            "href":"describe-table.html"
                        },
                        {
                            "title":"Table Hierarchies",
                            "href":"table-hierarchies.html"
                        },
                        {
                            "title":"Using JSON Collection Tables",
                            "href":"using-json-collection-tables.html"
                        },
                        {
                            "title":"Using the IDENTITY Column",
                            "href":"identity-column.html",
                            "topics":[
                                {
                                    "title":"Creating Tables With an IDENTITY Column",
                                    "href":"creating-tables-identity-column.html"
                                }
                            ]
                        },
                        {
                            "title":"Using the UUID data type",
                            "href":"using-uuid-data-type.html"
                        },
                        {
                            "title":"Using the MR_COUNTER datatype",
                            "href":"using-mr_counter-datatype.html#GUID-DDDC0615-FC24-4102-BB6E-2DA370AA49B6"
                        },
                        {
                            "title":"Sequence Generator",
                            "href":"sequence-generator.html"
                        },
                        {
                            "title":"DROP TABLE Statement",
                            "href":"drop-table.html"
                        },
                        {
                            "title":"ALTER TABLE Statement",
                            "href":"alter-table.html"
                        },
                        {
                            "title":"Altering an IDENTITY Column",
                            "href":"alter-identity-columns.html"
                        },
                        {
                            "title":"Add or Remove a UUID column",
                            "href":"alter-table-add-or-remove-uuid-column.html"
                        },
                        {
                            "title":"Add or Remove an IDENTITY column",
                            "href":"add-or-remove-identity-column.html"
                        },
                        {
                            "title":"Add or Remove an MR_COUNTER column",
                            "href":"add-or-remove-mr_counter-column.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> SQL Query Management",
                    "href":"sql-query-management.html",
                    "topics":[
                        {
                            "title":"Expressions",
                            "href":"expressions.html"
                        },
                        {
                            "title":"Sequences",
                            "href":"sequences.html"
                        },
                        {
                            "title":"Sequence Types",
                            "href":"sequence-type.html"
                        },
                        {
                            "title":"Variable Declaration",
                            "href":"variable-declarations.html"
                        },
                        {
                            "title":"SELECT Expression",
                            "href":"select-expression.html",
                            "topics":[
                                {
                                    "title":"FROM Clause",
                                    "href":"clause.html"
                                },
                                {
                                    "title":"WHERE Clause",
                                    "href":"where-clause.html"
                                },
                                {
                                    "title":"GROUP BY Clause",
                                    "href":"group-clause.html"
                                },
                                {
                                    "title":"Using Aggregate Functions",
                                    "href":"aggregate-functions.html",
                                    "topics":[
                                        {
                                            "title":"Sequence Aggregate Functions",
                                            "href":"sequence-aggregate-functions.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"ORDER BY Clause",
                                    "href":"order-clause.html"
                                },
                                {
                                    "title":"SELECT Clause",
                                    "href":"select-clause.html"
                                },
                                {
                                    "title":"LIMIT Clause",
                                    "href":"limit-clause.html"
                                },
                                {
                                    "title":"OFFSET Clause",
                                    "href":"offset-clause.html"
                                }
                            ]
                        },
                        {
                            "title":"Path Expressions",
                            "href":"path-expressions.html",
                            "topics":[
                                {
                                    "title":"Field Step Expressions",
                                    "href":"field-step-expressions.html"
                                },
                                {
                                    "title":"Map-Filter Step Expressions",
                                    "href":"map-filter-step-expressions.html"
                                },
                                {
                                    "title":"Array-Filter Step Expressions",
                                    "href":"array-filter-step-expressions.html"
                                },
                                {
                                    "title":"Array-Slice Step Expressions",
                                    "href":"array-slice-step-expressions.html"
                                }
                            ]
                        },
                        {
                            "title":"Comparison Expressions",
                            "href":"comparison-expressions.html",
                            "topics":[
                                {
                                    "title":"Logical Operators: AND, OR, and NOT",
                                    "href":"logical-operators-and-or-and-not.html"
                                },
                                {
                                    "title":"IS NULL and IS NOT NULL Operators",
                                    "href":"is-null-and-is-not-null-operators.html"
                                },
                                {
                                    "title":"Value Comparison Operators",
                                    "href":"value-comparison-operators.html"
                                },
                                {
                                    "title":"Sequence Comparison Operators",
                                    "href":"sequence-comparison-operators.html"
                                },
                                {
                                    "title":"BETWEEN Operator",
                                    "href":"operator1.html"
                                },
                                {
                                    "title":"IN Operator",
                                    "href":"operator.html"
                                },
                                {
                                    "title":"Regular Expression Conditions",
                                    "href":"regular-expressions.html"
                                },
                                {
                                    "title":"Exists Operator",
                                    "href":"exists-operator.html"
                                },
                                {
                                    "title":"Is-Of-Type Operator",
                                    "href":"is-type-operator.html"
                                }
                            ]
                        },
                        {
                            "title":"Concatenation Operator",
                            "href":"concatenation-operator.html"
                        },
                        {
                            "title":"Arithmetic Expressions",
                            "href":"arithmetic-expressions.html"
                        },
                        {
                            "title":"Primary Expressions",
                            "href":"primary-expressions.html",
                            "topics":[
                                {
                                    "title":"Parenthesized Expressions",
                                    "href":"parenthesized-expressions.html"
                                },
                                {
                                    "title":"Constant Expressions",
                                    "href":"constant-expressions.html"
                                },
                                {
                                    "title":"Column References",
                                    "href":"column-references.html"
                                },
                                {
                                    "title":"Variable References",
                                    "href":"variable-references.html"
                                },
                                {
                                    "title":"Array and Map Constructors",
                                    "href":"array-and-map-constructors.html"
                                },
                                {
                                    "title":"Case Expressions",
                                    "href":"case-expressions.html"
                                },
                                {
                                    "title":"Cast Expression",
                                    "href":"cast-expressions.html"
                                },
                                {
                                    "title":"Extract Expressions",
                                    "href":"extract-expressions.html"
                                },
                                {
                                    "title":"Function Calls",
                                    "href":"function-calls.html"
                                },
                                {
                                    "title":"Sequence Transform Expressions",
                                    "href":"sequence-transform-expressions.html"
                                }
                            ]
                        },
                        {
                            "title":"Unnest Arrays & Maps",
                            "href":"unnest-arrays-maps.html",
                            "topics":[
                                {
                                    "title":"Example: Using unnesting with a GROUP BY clause",
                                    "href":"example-using-unnesting-group-clause.html"
                                }
                            ]
                        },
                        {
                            "title":"Joins",
                            "href":"joins.html",
                            "topics":[
                                {
                                    "title":"Using NESTED TABLES clause to query multiple tables in the same hierarchy",
                                    "href":"using-nested-tables-clause-query-multiple-tables-same-hierarchy.html"
                                },
                                {
                                    "title":"Example: Using NESTED TABLES clause to query multiple tables in the same hierarchy",
                                    "href":"examples-using-nested-tables-clause-query-multiple-tables-same-hierarchy.html"
                                },
                                {
                                    "title":"Left Outer Join (LOJ)",
                                    "href":"left-outer-join.html",
                                    "topics":[
                                        {
                                            "title":"Different scenarios of using an LOJ",
                                            "href":"different-scenarios-using-loj.html"
                                        },
                                        {
                                            "title":"Limitations of LOJ",
                                            "href":"limitations-loj.html"
                                        },
                                        {
                                            "title":"Nested tables Vs LOJ",
                                            "href":"nested-tables-vs-loj.html"
                                        },
                                        {
                                            "title":"Example: Using Left Outer Joins",
                                            "href":"example-using-left-outer-joins.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Data Row Management",
                    "href":"data-row-management.html",
                    "topics":[
                        {
                            "title":"INSERT Statement",
                            "href":"insert-statement.html"
                        },
                        {
                            "title":"Inserting Rows into JSON Collection Tables",
                            "href":"inserting-rows-json-collection-tables.html"
                        },
                        {
                            "title":"Inserting Rows with an IDENTITY Column",
                            "href":"insert-rows-identity.html"
                        },
                        {
                            "title":"Inserting rows into a table with a UUID column",
                            "href":"inserting-rows-uuid-column.html"
                        },
                        {
                            "title":"Inserting rows with an MR_COUNTER column",
                            "href":"inserting-rows-mr_counter-column.html"
                        },
                        {
                            "title":"Upsert statement",
                            "href":"upsert-statement.html"
                        },
                        {
                            "title":"Updating rows of a table with a UUID column",
                            "href":"updating-rows-uuid-column.html"
                        },
                        {
                            "title":"DELETE Statement",
                            "href":"delete-statement.html"
                        },
                        {
                            "title":"UPDATE Statement",
                            "href":"update-statement.html",
                            "topics":[
                                {
                                    "title":"Update Clauses",
                                    "href":"update-clause.html",
                                    "topics":[
                                        {
                                            "title":"SET Clause",
                                            "href":"update-clause-set.html"
                                        },
                                        {
                                            "title":"ADD Clause",
                                            "href":"update-clause-add.html"
                                        },
                                        {
                                            "title":"PUT Clause",
                                            "href":"update-clause-put.html"
                                        },
                                        {
                                            "title":"REMOVE Clause",
                                            "href":"update-clause-remove.html"
                                        },
                                        {
                                            "title":"SET TTL Clause",
                                            "href":"update-clause-set-ttl.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Updating rows with an IDENTITY Column",
                                    "href":"update-rows-identity.html"
                                },
                                {
                                    "title":"Updating rows with an MR_COUNTER column",
                                    "href":"updating-rows-mr_counter-column.html"
                                },
                                {
                                    "title":"Example: Updating Rows",
                                    "href":"example-updating-rows.html"
                                },
                                {
                                    "title":"Example: Updating JSON Data",
                                    "href":"example-updating-json-data.html"
                                },
                                {
                                    "title":"Example: Updating JSON collection tables",
                                    "href":"example-updating-json-collection-tables.html"
                                },
                                {
                                    "title":"Example: Updating TTL",
                                    "href":"example-updating-ttl.html"
                                },
                                {
                                    "title":"Example: Updating IDENTITY defined as GENERATED ALWAYS",
                                    "href":"example-updating-identity-defined-generated-always.html"
                                },
                                {
                                    "title":"Example: Updating IDENTITY defined as GENERATED BY DEFAULT",
                                    "href":"example-updating-identity-defined-generated-default.html"
                                }
                            ]
                        },
                        {
                            "title":"JSON Collection Table Example",
                            "href":"json-collection-appendix.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Indexes",
                    "href":"indexes.html",
                    "topics":[
                        {
                            "title":"About Indexes",
                            "href":"indexes1.html"
                        },
                        {
                            "title":"CREATE INDEX Statement",
                            "href":"create-index.html"
                        },
                        {
                            "title":"Classification of Indexes",
                            "href":"index-classification.html#GUID-9A04C4C4-0142-4DA6-AF88-5DEB69E85892"
                        },
                        {
                            "title":"SHOW INDEXES Statement",
                            "href":"show-indexes.html"
                        },
                        {
                            "title":"DESCRIBE INDEX Statement",
                            "href":"describe-index.html"
                        },
                        {
                            "title":"DROP INDEX Statement",
                            "href":"drop-index.html"
                        },
                        {
                            "title":"Appendix",
                            "href":"index-appendix.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Query Optimization",
                    "href":"query-optimization.html",
                    "topics":[
                        {
                            "title":"Using Indexes for Query Optimization",
                            "href":"using-indexes-query-optimization.html"
                        },
                        {
                            "title":"Finding Applicable Indexes",
                            "href":"finding-applicable-indexes.html"
                        },
                        {
                            "title":"Examples: Using Indexes for Query Optimization",
                            "href":"examples-query-optimization.html",
                            "topics":[
                                {
                                    "title":"Optimizing unnesting queries with the UNNEST clause",
                                    "href":"optimizing-unnesting-queries-unnest-clause.html"
                                }
                            ]
                        },
                        {
                            "title":"Choosing the Best Applicable Index",
                            "href":"choosing-best-applicable-index.html"
                        },
                        {
                            "title":"Appendix",
                            "href":"query-optimisation-appendix.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Query Plan",
                    "href":"query-plan.html",
                    "topics":[
                        {
                            "title":"Overview of a query plan",
                            "href":"overview-query-plan.html"
                        },
                        {
                            "title":"Examples of query execution plan",
                            "href":"examples-query-execution-plan.html",
                            "topics":[
                                {
                                    "title":"Example 1 : Using a covering index in a query plan with only index scans",
                                    "href":"example-1-using-covering-index-query-plan-only-index-scans.html"
                                },
                                {
                                    "title":"Example 2 : Using a covering index in a query plan with index scans and index predicates",
                                    "href":"example-2-using-covering-index-query-plan-index-scans-and-index-predicates.html"
                                },
                                {
                                    "title":"Example 3: Using a non-covering index in a query plan with index scans",
                                    "href":"example-3-using-non-covering-index-query-plan-index-scans.html"
                                },
                                {
                                    "title":"Example 4: Sort the data using a Covering index",
                                    "href":"example-4-sort-data-using-covering-index.html"
                                },
                                {
                                    "title":"Example 5: Sort the data using a field not part of the index",
                                    "href":"example-5-sort-data-using-field-not-part-index.html"
                                },
                                {
                                    "title":"Example 6: Group the data using a Covering index",
                                    "href":"example-6-group-data-using-covering-index.html"
                                },
                                {
                                    "title":"Example 7: Group data with fields not part of the index",
                                    "href":"example-7-group-data-fields-not-part-index.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> GeoJson Data Management",
                    "href":"geojson-data-management.html",
                    "topics":[
                        {
                            "title":"About GeoJson Data",
                            "href":"geojson-data.html"
                        },
                        {
                            "title":"Lines and Coordinate System",
                            "href":"lines-and-coordinate-system.html"
                        },
                        {
                            "title":"Restrictions on GeoJson Data",
                            "href":"restrictions-geojson-data.html"
                        },
                        {
                            "title":"Searching for GeoJson Data",
                            "href":"searching-geojson-data.html"
                        },
                        {
                            "title":"Indexing GeoJson Data",
                            "href":"indexing-geojson-data.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Built-in Functions",
                    "href":"built-functions.html",
                    "topics":[
                        {
                            "title":"Functions on Complex Values",
                            "href":"functions-complex-values.html"
                        },
                        {
                            "title":"Functions on Sequences",
                            "href":"functions-sequences.html"
                        },
                        {
                            "title":"Functions on Timestamps",
                            "href":"functions-timestamps.html",
                            "topics":[
                                {
                                    "title":"timestamp_add function",
                                    "href":"timestamp_add-function.html"
                                },
                                {
                                    "title":"timestamp_diff function",
                                    "href":"timestamp_diff-function.html"
                                },
                                {
                                    "title":"get_duration function",
                                    "href":"get_duration-function.html"
                                },
                                {
                                    "title":"timestamp_ceil function",
                                    "href":"timestamp_ceil-function.html"
                                },
                                {
                                    "title":"timestamp_floor or timestamp_trunc function",
                                    "href":"timestamp_floor-or-timestamp_trunc-function.html"
                                },
                                {
                                    "title":"timestamp_round function",
                                    "href":"timestamp_round-function.html"
                                },
                                {
                                    "title":"timestamp_bucket function",
                                    "href":"timestamp_bucket-function.html"
                                },
                                {
                                    "title":"format_timestamp function",
                                    "href":"format_timestamp-function.html"
                                },
                                {
                                    "title":"parse_to_timestamp function",
                                    "href":"parse_to_timestamp-function.html"
                                },
                                {
                                    "title":"to_last_day_of_month function",
                                    "href":"to_last_day_of_month-function.html"
                                },
                                {
                                    "title":"Timestamp extract functions",
                                    "href":"miscellaneous-timestamp-functions.html",
                                    "topics":[
                                        {
                                            "title":"Date extract functions",
                                            "href":"date-extract-functions.html"
                                        },
                                        {
                                            "title":"week/isoweek functions",
                                            "href":"week-isoweek-functions.html"
                                        },
                                        {
                                            "title":"Timestamp index extract functions",
                                            "href":"quarter-day_of_week-day_of_month-day_of_year-functions.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"current_time_millis function",
                                    "href":"current_time_millis-function.html"
                                },
                                {
                                    "title":"current_time function",
                                    "href":"current_time-function.html"
                                },
                                {
                                    "title":"Supported units",
                                    "href":"supported-units.html"
                                }
                            ]
                        },
                        {
                            "title":"Function to generate a UUID string",
                            "href":"function-generate-uuid-string.html"
                        },
                        {
                            "title":"Functions on Rows",
                            "href":"functions-rows.html"
                        },
                        {
                            "title":"Functions on GeoJson Data",
                            "href":"functions-geojson-data.html"
                        },
                        {
                            "title":"Functions on Strings",
                            "href":"functions-strings.html",
                            "topics":[
                                {
                                    "title":"substring Function",
                                    "href":"substring_function.html"
                                },
                                {
                                    "title":"concat Function",
                                    "href":"concat_function.html"
                                },
                                {
                                    "title":"upper Function",
                                    "href":"upper_function.html"
                                },
                                {
                                    "title":"lower Function",
                                    "href":"lower_function.html"
                                },
                                {
                                    "title":"trim Function",
                                    "href":"trim_function.html"
                                },
                                {
                                    "title":"ltrim Function",
                                    "href":"ltrim_function.html"
                                },
                                {
                                    "title":"rtrim Function",
                                    "href":"rtrim_function.html"
                                },
                                {
                                    "title":"length Function",
                                    "href":"length_function.html"
                                },
                                {
                                    "title":"contains Function",
                                    "href":"contains_function.html"
                                },
                                {
                                    "title":"starts_with Function",
                                    "href":"starts_with_function.html"
                                },
                                {
                                    "title":"ends_with Function",
                                    "href":"ends_with_function.html"
                                },
                                {
                                    "title":"index_of Function",
                                    "href":"index_of_function.html"
                                },
                                {
                                    "title":"replace Function",
                                    "href":"replace_function.html"
                                },
                                {
                                    "title":"reverse Function",
                                    "href":"reverse_function.html"
                                }
                            ]
                        },
                        {
                            "title":"Function to Convert String to JSON",
                            "href":"function-convert-string-json.html"
                        },
                        {
                            "title":"Functions of Mathematical Operations",
                            "href":"functions-mathematical-operations.html",
                            "topics":[
                                {
                                    "title":"abs function",
                                    "href":"abs-function.html"
                                },
                                {
                                    "title":"arc cosine function",
                                    "href":"arc-cosine-function.html"
                                },
                                {
                                    "title":"arc sine function",
                                    "href":"arc-sine-function.html"
                                },
                                {
                                    "title":"arc tan function",
                                    "href":"arc-tan-function.html"
                                },
                                {
                                    "title":"arc tan2 function",
                                    "href":"arc-tan2-function.html"
                                },
                                {
                                    "title":"ceil function",
                                    "href":"ceil-function.html"
                                },
                                {
                                    "title":"cosine function",
                                    "href":"cosine-function.html"
                                },
                                {
                                    "title":"cotangent function",
                                    "href":"cotangent-function.html"
                                },
                                {
                                    "title":"degrees function",
                                    "href":"degrees-function.html"
                                },
                                {
                                    "title":"Euler function",
                                    "href":"euler-function.html"
                                },
                                {
                                    "title":"exp function",
                                    "href":"exp-function.html"
                                },
                                {
                                    "title":"floor function",
                                    "href":"floor-function.html"
                                },
                                {
                                    "title":"ln function",
                                    "href":"ln-function.html"
                                },
                                {
                                    "title":"log function",
                                    "href":"log-function.html"
                                },
                                {
                                    "title":"log10 function",
                                    "href":"log10-function.html"
                                },
                                {
                                    "title":"pi function",
                                    "href":"pi-function.html"
                                },
                                {
                                    "title":"power function",
                                    "href":"power-function.html"
                                },
                                {
                                    "title":"radians function",
                                    "href":"radians-function.html"
                                },
                                {
                                    "title":"random function",
                                    "href":"random-function.html"
                                },
                                {
                                    "title":"round function",
                                    "href":"round-function.html"
                                },
                                {
                                    "title":"sign function",
                                    "href":"sign-function.html"
                                },
                                {
                                    "title":"sine function",
                                    "href":"sine-function.html"
                                },
                                {
                                    "title":"square root function",
                                    "href":"square-root-function.html"
                                },
                                {
                                    "title":"tangent function",
                                    "href":"tangent-function.html"
                                },
                                {
                                    "title":"truncate function",
                                    "href":"truncate-function.html"
                                },
                                {
                                    "title":"Additional Examples",
                                    "href":"additional-examples-mathematical-functions.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Introduction to the SQL for Oracle NoSQL Database Shell",
                    "href":"introduction-sql-shell.html",
                    "topics":[
                        {
                            "title":"Running the SQL Shell",
                            "href":"running-sql-shell.html"
                        },
                        {
                            "title":"Configuring the shell",
                            "href":"configuring-shell.html"
                        },
                        {
                            "title":"Shell Utility Commands",
                            "href":"shell-utility-commands.html",
                            "topics":[
                                {
                                    "title":"connect",
                                    "href":"connect.html"
                                },
                                {
                                    "title":"consistency",
                                    "href":"consistency.html"
                                },
                                {
                                    "title":"describe",
                                    "href":"describe.html"
                                },
                                {
                                    "title":"durability",
                                    "href":"durability.html"
                                },
                                {
                                    "title":"exit",
                                    "href":"exit.html"
                                },
                                {
                                    "title":"help",
                                    "href":"help.html"
                                },
                                {
                                    "title":"history",
                                    "href":"history.html"
                                },
                                {
                                    "title":"import",
                                    "href":"import.html"
                                },
                                {
                                    "title":"load",
                                    "href":"load.html"
                                },
                                {
                                    "title":"mode",
                                    "href":"mode.html"
                                },
                                {
                                    "title":"output",
                                    "href":"output.html"
                                },
                                {
                                    "title":"page",
                                    "href":"page.html"
                                },
                                {
                                    "title":"show faults",
                                    "href":"show-faults.html"
                                },
                                {
                                    "title":"show ddl",
                                    "href":"show-ddl.html"
                                },
                                {
                                    "title":"show indexes",
                                    "href":"show-indexes1.html"
                                },
                                {
                                    "title":"show namespaces",
                                    "href":"show-namespaces1.html"
                                },
                                {
                                    "title":"show query",
                                    "href":"show-query.html"
                                },
                                {
                                    "title":"show regions",
                                    "href":"show-regions1.html"
                                },
                                {
                                    "title":"show roles",
                                    "href":"show-roles.html"
                                },
                                {
                                    "title":"show tables",
                                    "href":"show-tables1.html"
                                },
                                {
                                    "title":"show users",
                                    "href":"show-users.html"
                                },
                                {
                                    "title":"timeout",
                                    "href":"timeout.html"
                                },
                                {
                                    "title":"timer",
                                    "href":"timer.html"
                                },
                                {
                                    "title":"verbose",
                                    "href":"verbose.html"
                                },
                                {
                                    "title":"version",
                                    "href":"version.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});