define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-4E2F4C8C-6B74-4C05-9CBC-41FEAC4BA4D6"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction",
                    "href":"introduction.html",
                    "topics":[
                        {
                            "title":"Introduction to Oracle NoSQL Database",
                            "href":"introduction-oracle-nosql-database1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Install and Upgrade",
                    "href":"install-and-upgrade.html",
                    "topics":[
                        {
                            "title":"Installing Oracle NoSQL Database",
                            "href":"installing-oracle-nosql-database1.html",
                            "topics":[
                                {
                                    "title":"Installation Prerequisites",
                                    "href":"installation-prerequisites.html"
                                },
                                {
                                    "title":"Installation",
                                    "href":"installation.html"
                                }
                            ]
                        },
                        {
                            "title":"Upgrading an Existing Oracle NoSQL Database Deployment",
                            "href":"upgrading-existing-deployment.html",
                            "topics":[
                                {
                                    "title":"General Upgrade Notes",
                                    "href":"general-upgrade-notes.html"
                                },
                                {
                                    "title":"Preparing to Upgrade",
                                    "href":"preparing-upgrade.html"
                                },
                                {
                                    "title":"Steps to Upgrade - Examples",
                                    "href":"steps-upgrade-examples.html#GUID-BC407F0A-A010-4FFB-9167-094ECAACA4A7"
                                },
                                {
                                    "title":"Upgrading the Xregion Service Agent",
                                    "href":"upgrading-xregion-service-agent.html"
                                },
                                {
                                    "title":"Upgrading the Oracle NoSQL Database Proxy",
                                    "href":"upgrading-oracle-nosql-database-proxy.html"
                                },
                                {
                                    "title":"Upgrading JDK on your Oracle NoSQL Database deployment",
                                    "href":"upgrading-jdk-your-oracle-nosql-database-deployment.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Configure",
                    "href":"configure.html",
                    "topics":[
                        {
                            "title":"Configuration Basics",
                            "href":"configuration-basics1.html",
                            "topics":[
                                {
                                    "title":"Installation Configuration Parameters",
                                    "href":"installation-configuration-parameters.html"
                                },
                                {
                                    "title":"Configuring the Firewall",
                                    "href":"configuring-firewall.html"
                                }
                            ]
                        },
                        {
                            "title":"Configuring security in a data store",
                            "href":"configuring-security-data-store1.html#GUID-A6880BD0-5CA9-403C-9712-19BFE40A59A3"
                        },
                        {
                            "title":"Configuration Scenarios",
                            "href":"configuration-scenarios1.html",
                            "topics":[
                                {
                                    "title":"Configure a single node KVLite",
                                    "href":"configure-single-node-kvlite.html"
                                },
                                {
                                    "title":"Configuring a single region data store",
                                    "href":"configuring-single-region-data-store1.html",
                                    "topics":[
                                        {
                                            "title":"Steps to configure a non-secure data store",
                                            "href":"configure-non-secure-data-store.html"
                                        },
                                        {
                                            "title":"Steps to configure a secure data store",
                                            "href":"configure-secure-data-store.html"
                                        },
                                        {
                                            "title":"Configuring your data store installation",
                                            "href":"configuring-your-data-store-installation.html"
                                        },
                                        {
                                            "title":"Using Plans",
                                            "href":"using-plans.html#GUID-95AB89A0-E430-4E42-B3E9-FDB3FF1D906E"
                                        },
                                        {
                                            "title":"Start the Administration CLI",
                                            "href":"start-administration-cli.html#GUID-CAC92FDC-5FF8-4A1C-9C3F-A6BC84E3F508"
                                        },
                                        {
                                            "title":"Name your data store",
                                            "href":"name-your-data-store.html"
                                        },
                                        {
                                            "title":"Create a Zone",
                                            "href":"create-zone.html"
                                        },
                                        {
                                            "title":"Create an Administration Process on a Specific Storage Node",
                                            "href":"create-administration-process-specific-host.html"
                                        },
                                        {
                                            "title":"Create a Storage Node Pool",
                                            "href":"create-storage-node-pool.html"
                                        },
                                        {
                                            "title":"Create the Remainder of your Storage Nodes",
                                            "href":"create-remainder-your-storage-nodes.html"
                                        },
                                        {
                                            "title":"Create and Deploy Replication Nodes",
                                            "href":"create-and-deploy-replication-nodes.html"
                                        },
                                        {
                                            "title":"Smoke Testing the System",
                                            "href":"smoke-testing-system.html"
                                        },
                                        {
                                            "title":"Create a script to configure the data store",
                                            "href":"create-script-configure-data-store.html"
                                        },
                                        {
                                            "title":"Troubleshooting",
                                            "href":"troubleshooting.html#GUID-BAFD8C75-9965-4C9D-BB7E-956D3AB1145A"
                                        }
                                    ]
                                },
                                {
                                    "title":"Configuring Multi-Region Data Stores",
                                    "href":"configuring-multi-region-data-stores1.html",
                                    "topics":[
                                        {
                                            "title":"Use Case 1: Set up Multi-Region Environment",
                                            "href":"use-case-1-set-multi-region-environment.html",
                                            "topics":[
                                                {
                                                    "title":"Deploy the data store",
                                                    "href":"deploy-data-store.html"
                                                },
                                                {
                                                    "title":"Set Local Region Name",
                                                    "href":"set-local-region-name.html"
                                                },
                                                {
                                                    "title":"Configure XRegion Service",
                                                    "href":"configure-xregion-service.html"
                                                },
                                                {
                                                    "title":"Start XRegion Service",
                                                    "href":"start-xregion-service.html"
                                                },
                                                {
                                                    "title":"Create Remote Regions",
                                                    "href":"create-remote-regions.html"
                                                },
                                                {
                                                    "title":"Create Multi-Region Tables",
                                                    "href":"create-mr-tables.html",
                                                    "topics":[
                                                        {
                                                            "title":"Create multi-region table with an MR_COUNTER column",
                                                            "href":"create-multi-region-table-mr_counter-column.html"
                                                        }
                                                    ]
                                                },
                                                {
                                                    "title":"Access and Manipulate Multi-Region Tables",
                                                    "href":"access-and-manipulate-mr-tables.html"
                                                },
                                                {
                                                    "title":"Stop XRegion Service",
                                                    "href":"stop-xregion-service.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Use Case 2: Expand a Multi-Region Table",
                                            "href":"use-case-2-expand-multi-region-table.html#GUID-6A42AC44-5226-4E48-9485-EC2CF905E91D"
                                        },
                                        {
                                            "title":"Use Case 3: Contract a Multi-Region Table",
                                            "href":"use-case-3-contract-multi-region-table.html#GUID-8129380C-127C-4714-8B8A-7CA11CD53BF6"
                                        },
                                        {
                                            "title":"Use Case 4: Drop a Region",
                                            "href":"use-case-4-drop-region.html#GUID-0656820F-77B0-4E5F-BF79-3EC74A0804E9"
                                        },
                                        {
                                            "title":"Use Case 5: Backup and Restore a Multi-Region Table",
                                            "href":"use-case-5-backup-and-restore-multi-region-table.html"
                                        },
                                        {
                                            "title":"Troubleshooting multi-region data store setup",
                                            "href":"troubleshooting-multi-region-kvstore-setup.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Configure data store - Advanced scenarios",
                            "href":"configure-data-store-advanced-scenarios.html",
                            "topics":[
                                {
                                    "title":"Create Additional Admin Processes",
                                    "href":"create-additional-admin-processes.html"
                                },
                                {
                                    "title":"Configuring with Multiple Zones",
                                    "href":"configuring-multiple-zones.html"
                                },
                                {
                                    "title":"Adding Secondary Zone to the Existing Topology",
                                    "href":"adding-secondary-zone-existing-topology.html"
                                }
                            ]
                        },
                        {
                            "title":"Oracle NoSQL Database Proxy",
                            "href":"proxy.html",
                            "topics":[
                                {
                                    "title":"About the Oracle NoSQL Database Proxy",
                                    "href":"oracle-nosql-database-proxy1.html"
                                },
                                {
                                    "title":"Configuring the Proxy",
                                    "href":"configuring-proxy.html"
                                },
                                {
                                    "title":"Using the Proxy in a non-secure data store",
                                    "href":"non-secure-proxy.html"
                                },
                                {
                                    "title":"Using the Proxy in a secure data store",
                                    "href":"secure-proxy.html"
                                },
                                {
                                    "title":"Example: Configuring Multiple Oracle NoSQL Database Proxies for Redundancy",
                                    "href":"configuring-multiple-proxy-redundancy.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Administer",
                    "href":"administer.html",
                    "topics":[
                        {
                            "title":"Changing the Store's Topology",
                            "href":"changing-stores-topology1.html",
                            "topics":[
                                {
                                    "title":"Determining Your Store's Configuration",
                                    "href":"determining-your-stores-configuration.html"
                                },
                                {
                                    "title":"Steps for Changing the Store's Topology",
                                    "href":"steps-changing-stores-topology.html#GUID-8277AFE2-9CB5-4476-B53E-9F94B1D01DF8"
                                },
                                {
                                    "title":"Deploying an Arbiter Node Enabled Topology",
                                    "href":"deploying-arbiter-node-enabled-topology.html"
                                }
                            ]
                        },
                        {
                            "title":"Backup and Recovery",
                            "href":"backup-and-recovery1.html",
                            "topics":[
                                {
                                    "title":"Backing Up the Store",
                                    "href":"backing-store1.html#GUID-31470932-7DEE-4D2A-ACCB-B33C352E7C10"
                                },
                                {
                                    "title":"Recovering the Store",
                                    "href":"recovering-store.html#GUID-947AFA45-6CE1-489B-B535-C1092770D70C"
                                },
                                {
                                    "title":"Use case to Demonstrate Backup and Restoration of Store",
                                    "href":"use-case-demonstrate-backup-and-restoration-store.html",
                                    "topics":[
                                        {
                                            "title":"Backing Up the Store",
                                            "href":"backing-store.html",
                                            "topics":[
                                                {
                                                    "title":"Write Data to Store",
                                                    "href":"write-data-store.html"
                                                },
                                                {
                                                    "title":"Create Snapshot of the Store",
                                                    "href":"create-snapshot-store.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"Restoring the Store",
                                            "href":"restoring-store.html",
                                            "topics":[
                                                {
                                                    "title":"Load Store Metadata from Backup",
                                                    "href":"load-store-metadata-backup.html"
                                                },
                                                {
                                                    "title":"Grant Required Privileges to Users",
                                                    "href":"grant-required-privileges-user.html"
                                                },
                                                {
                                                    "title":"Load Shard Data from Backup",
                                                    "href":"load-shard-data-backup.html"
                                                },
                                                {
                                                    "title":"Verify Restored Data",
                                                    "href":"verify-restored-data.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"Recovering from Data Corruption",
                                    "href":"recovering-data-corruption.html#GUID-C03B3E7E-AB99-4461-84C5-244FFBA39777"
                                },
                                {
                                    "title":"Replacing a Failed Disk",
                                    "href":"replacing-failed-disk.html"
                                },
                                {
                                    "title":"Replacing a Failed Storage Node",
                                    "href":"replacing-failed-storage-node.html",
                                    "topics":[
                                        {
                                            "title":"Using a New Storage Node",
                                            "href":"task-new-storage-node.html"
                                        },
                                        {
                                            "title":"Task for an Identical Node",
                                            "href":"task-identical-node.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Repairing a Failed Zone by Replacing Hardware",
                                    "href":"repairing-failed-zone-replacing-hardware.html"
                                }
                            ]
                        },
                        {
                            "title":"Managing your kvstore",
                            "href":"managing-your-kvstore1.html",
                            "topics":[
                                {
                                    "title":"Increasing Storage Node Capacity",
                                    "href":"increasing-capacity-storage-node.html"
                                },
                                {
                                    "title":"Managing Storage Directory Sizes",
                                    "href":"managing-storage-directory-sizes.html#GUID-14D5B742-1B84-4290-960D-5B7316315892"
                                },
                                {
                                    "title":"Managing Admin Directory Size",
                                    "href":"managing-admin-directory-size.html#GUID-3EB45F79-15F6-4300-A82B-1F23B9906DE6"
                                },
                                {
                                    "title":"Disabling Storage Node Agent Hosted Services",
                                    "href":"disabling-storage-node-agent-hosted-services.html"
                                },
                                {
                                    "title":"Verifying the Store",
                                    "href":"verifying-store.html"
                                },
                                {
                                    "title":"Erasing Data",
                                    "href":"erasing-data.html"
                                },
                                {
                                    "title":"Setting Store Parameters",
                                    "href":"setting-store-parameters.html#GUID-B6F7AE32-DD5D-4F6A-A4F6-BC576A10C2A0"
                                },
                                {
                                    "title":"Removing an Oracle NoSQL Database Deployment",
                                    "href":"removing-deployment.html"
                                },
                                {
                                    "title":"Modifying Storage Node HA Port Ranges",
                                    "href":"modifying-storage-node-ha-port-ranges.html"
                                },
                                {
                                    "title":"Modifying Storage Node Service Port Ranges",
                                    "href":"modifying-storage-node-service-port-ranges.html#GUID-1F957054-3806-4AC9-A9A5-4D8FC8F7495A"
                                }
                            ]
                        },
                        {
                            "title":"Availability, Failover and Switchover",
                            "href":"availability-failover-and-switchover1.html",
                            "topics":[
                                {
                                    "title":"Availability and Failover",
                                    "href":"availability-and-failover.html"
                                },
                                {
                                    "title":"Replication Overview",
                                    "href":"replication-overview.html"
                                },
                                {
                                    "title":"Loss of a Read-Only Replica Node",
                                    "href":"loss-read-only-replica-node.html"
                                },
                                {
                                    "title":"Loss of a Read/Write Master",
                                    "href":"loss-read-write-master.html"
                                },
                                {
                                    "title":"Unplanned Network Partitions",
                                    "href":"network-partitions.html",
                                    "topics":[
                                        {
                                            "title":"Master is in the Majority Node Partition",
                                            "href":"master-is-majority-node-partition.html"
                                        },
                                        {
                                            "title":"Master is in the Minority Node Partition",
                                            "href":"master-is-minority-node-partition.html"
                                        },
                                        {
                                            "title":"No Majority Node Partition",
                                            "href":"no-majority-node-partition.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Failover and Switchover Operations",
                                    "href":"failover-and-switchover-operations.html",
                                    "topics":[
                                        {
                                            "title":"Repairing a Failed Zone",
                                            "href":"repairing-failed-zone.html"
                                        },
                                        {
                                            "title":"Performing a Failover",
                                            "href":"performing-failover.html"
                                        },
                                        {
                                            "title":"Performing a Switchover",
                                            "href":"performing-switchover.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Zone Failover",
                                    "href":"zone-failover.html"
                                },
                                {
                                    "title":"Durability Summary",
                                    "href":"durability-summary.html"
                                },
                                {
                                    "title":"Consistency Summary",
                                    "href":"consistency-summary.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Reference",
                    "href":"reference.html",
                    "topics":[
                        {
                            "title":"Terminologies used in Oracle NoSQL Database",
                            "href":"terminologies-used-oracle-nosql-database1.html"
                        },
                        {
                            "title":"Admin CLI Reference",
                            "href":"admin-cli-reference1.html",
                            "topics":[
                                {
                                    "title":"aggregate",
                                    "href":"aggregate.html#GUID-437AE483-7809-4F7C-8EFE-C103EC55E37E"
                                },
                                {
                                    "title":"await-consistent",
                                    "href":"await-consistent.html"
                                },
                                {
                                    "title":"change-policy",
                                    "href":"change-policy.html"
                                },
                                {
                                    "title":"configure",
                                    "href":"configure1.html"
                                },
                                {
                                    "title":"connect",
                                    "href":"connect.html#GUID-37959214-7B6D-4F5C-A634-629F470F9B32"
                                },
                                {
                                    "title":"delete",
                                    "href":"delete.html#GUID-24681ED1-A78C-45E7-A227-1468612A2F24"
                                },
                                {
                                    "title":"execute",
                                    "href":"execute.html"
                                },
                                {
                                    "title":"exit",
                                    "href":"exit.html"
                                },
                                {
                                    "title":"get",
                                    "href":"get.html#GUID-CE76923F-BCCE-42EB-A6D1-836BE2143589"
                                },
                                {
                                    "title":"help",
                                    "href":"help.html"
                                },
                                {
                                    "title":"hidden",
                                    "href":"hidden.html"
                                },
                                {
                                    "title":"history",
                                    "href":"history.html"
                                },
                                {
                                    "title":"load",
                                    "href":"load.html"
                                },
                                {
                                    "title":"logtail",
                                    "href":"logtail.html"
                                },
                                {
                                    "title":"namespace",
                                    "href":"namespace.html"
                                },
                                {
                                    "title":"page",
                                    "href":"page.html"
                                },
                                {
                                    "title":"ping",
                                    "href":"ping1.html"
                                },
                                {
                                    "title":"plan",
                                    "href":"plan.html#GUID-A8D8698D-6F97-48BE-8F31-C98807F34B28"
                                },
                                {
                                    "title":"pool",
                                    "href":"pool.html#GUID-21D00E92-644E-4669-A60C-9C50D7E0234D"
                                },
                                {
                                    "title":"put",
                                    "href":"put.html#GUID-2D0DD594-6458-4874-92B4-532E9B7B10F5"
                                },
                                {
                                    "title":"repair-admin-quorum",
                                    "href":"repair-admin-quorum.html"
                                },
                                {
                                    "title":"show",
                                    "href":"show.html#GUID-B7076ECF-70D7-43FE-8CDB-1ADE819C4894"
                                },
                                {
                                    "title":"snapshot",
                                    "href":"snapshot.html#GUID-F2D6B9E3-57E6-4B1A-BE3F-74B4906442D6"
                                },
                                {
                                    "title":"table",
                                    "href":"table.html"
                                },
                                {
                                    "title":"table-size",
                                    "href":"table-size.html"
                                },
                                {
                                    "title":"timer",
                                    "href":"timer.html"
                                },
                                {
                                    "title":"topology",
                                    "href":"topology.html#GUID-F30B4D20-5E3A-45C7-8CBF-E99C5B5F151F"
                                },
                                {
                                    "title":"verbose",
                                    "href":"verbose.html"
                                },
                                {
                                    "title":"verify",
                                    "href":"verify.html#GUID-B4DD0B70-C903-4CE2-AC12-FA302DEC6944"
                                }
                            ]
                        },
                        {
                            "title":"Admin Utility Command Reference",
                            "href":"admin-utility-command-reference1.html",
                            "topics":[
                                {
                                    "title":"diagnostics",
                                    "href":"diagnostics.html"
                                },
                                {
                                    "title":"generateconfig",
                                    "href":"generateconfig.html"
                                },
                                {
                                    "title":"help",
                                    "href":"help1.html"
                                },
                                {
                                    "title":"kvlite",
                                    "href":"kvlite.html"
                                },
                                {
                                    "title":"load admin metadata",
                                    "href":"load-admin-metadata.html"
                                },
                                {
                                    "title":"load store data",
                                    "href":"load-store-data.html"
                                },
                                {
                                    "title":"makebootconfig",
                                    "href":"makebootconfig.html"
                                },
                                {
                                    "title":"ping",
                                    "href":"ping.html#GUID-7EF03942-D52B-46E7-A1AC-D3519E7B1658"
                                },
                                {
                                    "title":"restart",
                                    "href":"restart.html"
                                },
                                {
                                    "title":"runadmin",
                                    "href":"runadmin.html"
                                },
                                {
                                    "title":"securityconfig",
                                    "href":"securityconfig.html"
                                },
                                {
                                    "title":"start",
                                    "href":"start.html"
                                },
                                {
                                    "title":"status",
                                    "href":"status.html"
                                },
                                {
                                    "title":"stop",
                                    "href":"stop.html"
                                },
                                {
                                    "title":"version",
                                    "href":"version.html"
                                },
                                {
                                    "title":"xrstart",
                                    "href":"xrstart.html"
                                },
                                {
                                    "title":"xrstatus",
                                    "href":"xrstatus.html"
                                },
                                {
                                    "title":"xrstop",
                                    "href":"xrstop.html"
                                }
                            ]
                        },
                        {
                            "title":"Initial Capacity Planning",
                            "href":"initial-capacity-planning1.html",
                            "topics":[
                                {
                                    "title":"Shard Capacity",
                                    "href":"shard-capacity.html#GUID-8819139E-837F-43CA-8136-E92F3F2CE3BA"
                                },
                                {
                                    "title":"Estimate total Shards and Machines",
                                    "href":"estimate-total-shards-and-machines.html#GUID-B43EF791-7680-47C9-8755-95F1B00B2606"
                                }
                            ]
                        },
                        {
                            "title":"Tuning",
                            "href":"tuning1.html",
                            "topics":[
                                {
                                    "title":"Turn off the swap",
                                    "href":"turn-swap.html"
                                },
                                {
                                    "title":"Linux Page Cache Tuning",
                                    "href":"linux-page-cache-tuning.html"
                                },
                                {
                                    "title":"OS User Limits",
                                    "href":"os-user-limits.html#GUID-2A06097C-B98C-4E1D-AC2A-BBB135275165"
                                },
                                {
                                    "title":"Linux Network Configuration Settings",
                                    "href":"linux-network-configuration-settings.html#GUID-F98FDC96-9F8D-4337-85FB-D8D3F1B29979"
                                },
                                {
                                    "title":"Check AES Intrinsics Settings",
                                    "href":"check-aes-intrinsics-settings.html"
                                },
                                {
                                    "title":"Viewing Key Distribution Statistics",
                                    "href":"viewing-key-distribution-statistics.html",
                                    "topics":[
                                        {
                                            "title":"Examples: Key Distribution Statistics",
                                            "href":"examples-key-distribution-statistics.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Solid State Drives (SSDs)",
                            "href":"solid-state-drives-ssds1.html",
                            "topics":[
                                {
                                    "title":"Trim requirements",
                                    "href":"trim-requirements.html"
                                },
                                {
                                    "title":"Enabling Trim",
                                    "href":"enabling-trim.html"
                                }
                            ]
                        },
                        {
                            "title":"Diagnostics Utility",
                            "href":"diagnostics-utility1.html",
                            "topics":[
                                {
                                    "title":"Setting up the tool",
                                    "href":"setting-tool.html"
                                },
                                {
                                    "title":"Packaging Information and Files",
                                    "href":"packaging-information-and-files.html"
                                },
                                {
                                    "title":"Verifying Storage Node configuration",
                                    "href":"verifying-storage-node-configuration.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});