define("article",["jquery","handlebars","manifest","lookup"],function($,handlebars,manifest,lookup){

function load(name) {

  //define variables
  var svgfilename = name + '.svg';
  var svgpath = "images/" + svgfilename;
  var htmlfilename = name + '.html';
  var htmlpath = name + '.html';
  var lookupname = "c_" + name;

  //global variables
  var pagetitle = "";
  var notescode = "";
  var relatedresources = "";
  var svgcode = "";

  //clear content
  $('.relatedresourceslist').empty();

//*************** diagram numbering ************
  //create an array of just the top level nodes from the manifest file; exclude nodes where the href is external and exclude index node. This array is used for setting the diagram number on the page
  var pagearr = new Array();
  Object.entries(manifest).forEach(([key, value]) => {
          //if href is external, url would have / in its name
          //only include nodes that start with c_ in the manifest
          if  ( (key.startsWith('c_')) && (!(value.href.includes('/'))) ){
            var valuetopush = value.href.slice(0,-5);
              pagearr.push(valuetopush);
          }
    });

    //find the current slide number
    function getcurrentpageindex(){
          var url = window.location.pathname;
          var htmlfile = url.substring(url.lastIndexOf('/')+1);
          var currentpage = htmlfile.slice(0,-5);
          var currentpageindex = pagearr.indexOf(currentpage);
          return currentpageindex;
        }

$('#totalslides').text(pagearr.length);
var a = getcurrentpageindex();
$('#currentslidenum').text(a+1); //page count needs an extra value because we don't say page 0



//***************************//


// Get Notes and SVG title
  let p1 = new Promise((resolve, reject)=> {
        var notesrequest = $.ajax({
          async: true, //new line April 12, 2024
          url: htmlpath,
          type: 'GET',
          cache:false
        });

				notesrequest.done(function(html) {
					notescode = $(html).find('#NotesContainer').html();
          pagetitle = $(html).filter('title').text();
          relatedresources = $(html).find('#RelatedResources UL').html();
        //  console.log(html);
					resolve(notescode, pagetitle, relatedresources);
				});

				notesrequest.fail(function() {
					reject("Notes request failed");
				});
    }); //end p1


//Get SVG
		let p2 = new Promise((resolve, reject)=> {
			var ajaxsvg = new XMLHttpRequest();
			ajaxsvg.open("GET", svgpath, true);
			ajaxsvg.send();
			ajaxsvg.onload = function(e) {
								//get the svg code block
								svgcode = ajaxsvg.responseText;
								resolve(svgcode);
							}

			}); //end p2

// After both SVG and notes are retrieved, display the page and configure links in svg
Promise.all([p1,p2]).then((things)=>{
        //  console.log('both SVG and Notes are loaded');
        // console.log(svgcode);
        // console.log(notescode);
         //console.log(pagetitle);
      //   console.log(relatedresources);


     //Populate areas
        $('#articleTitle').text(pagetitle);
        $('#SlideContainer').html(svgcode);
        $('#NotesContainer').html(notescode);
        $('ul.relatedresourceslist').html(relatedresources);
		//add target = _blank to each related resource
		$('ul.relatedresourceslist li a').attr("target","_blank");


//ORIGINALLY....
        //Populate Related Resources
        //Note: Related resources are coming from the manifest.js file. Configure to open related resources in new tab.
        //this is defined at the top of page: lookupname = "c_" + name;

    //     var relatedresnode = lookup.relatedresources(lookupname);
    //      Object.entries(relatedresnode).forEach(([key, value]) => {
      //            var rresource = '<li><a href="' + value + '" target="_blank">' + key + '</a></li>';
      //          $('ul.relatedresourceslist').append(rresource);
    //    });


          //Manipulate the svg
              var object = document.getElementById("SlideContainer");
              var allsvgItems = object.querySelectorAll('svg > *');
              var svgItems = object.querySelectorAll('*[id^="c_"]');
            //  console.log("All svg items: ");
            //  console.log(svgItems);


              // set all svg elements as aria-hidden
              // exclude all g elements (June 9 2025 update)
              //Remove aria-hidden="true" on all <g> tags. (June 9 2025 update)
            // Make sure all other elements have aria-hidden="false" or no aria-hidden attribute. (June 9 2025 update)
             $('#SlideContainer svg:first-child *').not('g').each(function() {
                 $(this).attr('aria-hidden', 'true');
             });

             // remove aria-hidden from svg tag  (Jun 9 2025 update)
             $('#SlideContainer svg:first-child').attr('aria-hidden', 'false');



              // ALL THIS STUFF IN GREEN BELOW is alternate method
             // Add aria info to SVG element and remove aria-hidden on the title and desc
             //This will bring in the image description and point JAWS users to the notes below the image
             //$('#SlideContainer svg:first-child').attr("aria-labelledby", "desc-svg");
            // $('#title-svg').removeAttr('aria-hidden');
             //$('#desc-svg').removeAttr('aria-hidden');

             //Added May 15, 2025
             //insert a <desc> right after <svg> tag for accessibility
              //var svg = object.querySelector('svg'); // Select the SVG element
              //var desc = document.createElementNS('http://www.w3.org/2000/svg', 'desc'); // Create <desc> in SVG namespace
             // desc.id = 'desc-svg';
              //desc.textContent = 'Architecture Diagram - see full description under Notes.'; // Set description text
             // svg.insertBefore(desc, svg.firstChild); // Insert <desc> as the first child of <svg>

              // Add <g> as the first child inside the svg for accessibility (June 9, 2025)
              // <g id="img" role="img" aria-label="Architecture diagram - see full description under Notes heading"> </g>
              var svg = object.querySelector('svg'); // Select the SVG element
              var g = document.createElementNS('http://www.w3.org/2000/svg', 'g');
              g.setAttribute('id', 'img');
              g.setAttribute('role', 'img');
              g.setAttribute('aria-label','Architecture diagram - see full description under Notes heading') ;
             svg.insertBefore(g, svg.firstChild);



             //insert links into svg
              for (i = 0; i < svgItems.length; i++) {
                //    console.log("svgItem: ");
                  //  console.log(svgItems[i]);

                         //get element name from element's id
                           var elemID = svgItems[i].id;
                           var name = elemID.substring(2,);
                           var filename = name + ".html"

                           var clickablegroup = "c_" + name;
                           var clickablelink = "a_" + name;

                         //pull the values from the manifest
                        try {
                          var href = lookup.href(clickablegroup);
                          var tooltip = lookup.title(clickablegroup);
                        }
                        catch(err) {

                         console.log("Note: In " + svgfilename + ", you specify a clickable object named " + clickablegroup + " that does not have a corresponding HTML file.");
                          continue;
                        }



                        //Add an <a> element before each <g> element that's clickable
                        var elem = document.createElementNS('http://www.w3.org/2000/svg','a');
                       var title = document.createElementNS('http://www.w3.org/2000/svg','title');

                        //Add a <title> element as the first child of the <a> tag. Note that tooltips are not accessible, but we use them here for the Oracle Accessibilty Toolbar to pass inspection on links
                            title.innerHTML = tooltip;
                            elem.prepend(title);

                        // grab target element reference
                        var target = svgItems[i];

                        // insert the element before target element
                        target.parentNode.insertBefore(elem, target);

                        //move the <g> element into the <a> element
                        elem.appendChild(target);

                        //set attributes to <a> element
                        elem.setAttribute("id","a_" + name);
                        elem.setAttribute("class", "clickable");
                        elem.setAttribute("role", "link");
                        elem.setAttribute("href",href);
                        elem.setAttribute("aria-hidden", "false");
                        if ((tooltip.endsWith('Documentation')) || (tooltip.endsWith('Video')))
                        {
                          elem.setAttribute("target", "_blank");
                        }
                        
                        //  Note; elem.setAttribute("onclick","${drilldown.now(name)}"); does not work

                      //add class to element if internal url
                      if (!(href.startsWith('http'))) {
                          elem.classList.add("internal");
                      }

                  }  //end for loop



                // Onclick function for SVG element
                //****************************************

                   $('svg > a.internal').click(function(e) {

                 //stop default click action
                        e.stopPropagation();
                        e.preventDefault();
                  //      console.log("Clicked: " + this.id);
                        var nameinternal = this.id.substring(2,);

                  //update filename in url without refreshing page
                        const state = {};
                          window.history.pushState(state,'', nameinternal+".html");

                  //Select the correct drop-down list item according to the page opened
                          var e = document.getElementById("f9");
                          e.value = nameinternal+".html";

                  // Set the correct slide number
                    var a = getcurrentpageindex();
                    $('#currentslidenum').text(a+1); //page count needs an extra value because we don't say page 0

                  //load in the new svg and notes and create links
                        load(nameinternal);


                // Set the tab name to be the same as the article title
                    var tabtitle = lookup.title("c_"+nameinternal);
                    document.title = tabtitle;

                  }); //end function


                     //Do a load when back button is clicked
                     window.onpopstate = function(e) {
                           //when the url changes, get the filename of the new url
                           var url = window.location.pathname;
                           var htmlfile = url.substring(url.lastIndexOf('/')+1);
                           var name = htmlfile.slice(0,-5);

                           //load the svg and notes for the new filename
                           load(name);

                           // Set the correct slide number
                             var a = getcurrentpageindex();
                             $('#currentslidenum').text(a+1); //page count needs an extra value because we don't say page 0

                             //Select the correct drop-down list item according to the page opened
                             var e = document.getElementById("f9");
                             e.value = name + '.html';
                       }

                     //fade in the article
                    $("article").fadeIn("fast");

}) //end promise all

} //end load function

return {
  load: load
};
   }); //end module
