define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-7A47EE50-29AA-4B03-A405-D799CA60EC73"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Oracle Banking Branch",
                    "href":"overview-oracle-banking-branch.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Prerequisites",
                            "href":"prerequisites.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> About Main Menu",
                            "href":"main-menu.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Application Layout",
                            "href":"application-layout.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.3.1 </span> Customer Search",
                                    "href":"customer-search1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.3.2 </span> About Transaction Area",
                                    "href":"transaction-area1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Salient Features",
                            "href":"salient-features.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.4.1 </span> About Machine Learning",
                                    "href":"machine-learning.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.2 </span> About Virtual Identifier",
                                    "href":"virtual-identifier.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.3 </span> About Oracle Digital Assistant",
                                    "href":"oracle-digital-assistant.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.4 </span> About Amount-Based Signature Verification",
                                    "href":"amount-based-signature-verification.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.5 </span> Advice Generation for Teller Transactions",
                                    "href":"advice-generation-teller-transactions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.6 </span> Keyboard Navigation for Transaction Screens",
                                    "href":"keyboard-navigation-transaction-screens.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.4.7 </span> About Business Process Codes",
                                    "href":"business-process-codes.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Branch Operations",
                    "href":"branch-operations.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> TC Denomination Enquiry",
                            "href":"tc-denomination-enquiry1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Open Branch Batch",
                            "href":"open-branch-batch1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Open Vault Batch",
                            "href":"open-vault-batch1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Open Teller Batch",
                            "href":"open-teller-batch1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Current Open Tills",
                            "href":"current-open-tills1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Branch Breach Limits",
                            "href":"branch-breach-limits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Till Vault Position",
                            "href":"till-vault-position1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Branch Total Position",
                            "href":"branch-total-position.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Close Teller Batch",
                            "href":"close-teller-batch1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> Close Vault Batch",
                            "href":"close-vault-batch1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.11 </span> Close Branch Batch",
                            "href":"close-branch-batch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.12 </span> Book Shortage",
                            "href":"book-shortage1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.12.1 </span> Add Denomination Details",
                                    "href":"add-denomination-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.13 </span> Book Overage",
                            "href":"book-overage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.14 </span> Book Vault Shortage",
                            "href":"book-vault-shortage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.15 </span> Book Vault Overage",
                            "href":"book-vault-overage1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.16 </span> Teller Session",
                            "href":"teller-session.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.16.1 </span> Start Teller Session",
                                    "href":"start-teller-session1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.16.2 </span> Stop Teller Session",
                                    "href":"stop-teller-session1.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Till-Vault Operations",
                    "href":"till-vault-operations.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Buy TC from Agent",
                            "href":"buy-tc-from-agent1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1.1 </span> Add TC Denominations to Buy TC",
                                    "href":"add-tc-denominations-buy-tc.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Buy TC from Head Office",
                            "href":"buy-tc-from-head-office1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Buy TC from Vault",
                            "href":"buy-tc-from-vault.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Return TC to Vault",
                            "href":"return-tc-vault1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.4.1 </span> Add TC Denominations to Return TC",
                                    "href":"add-tc-denominations-return-tc.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Return TC to HO",
                            "href":"return-tc-ho.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> Buy Cash from Currency Chest",
                            "href":"buy-cash-from-currency-chest1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Sell Cash to Currency Chest",
                            "href":"sell-cash-currency-chest1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> Buy Cash from Vault",
                            "href":"buy-cash-from-vault.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.9 </span> Sell Cash to Vault",
                            "href":"sell-cash-vault.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.10 </span> Buy Cash from Till",
                            "href":"buy-cash-from-till1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.11 </span> Sell Cash to Till",
                            "href":"sell-cash-till1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.12 </span> Denomination Exchange",
                            "href":"denomination-exchange.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.13 </span> Vault Denomination Exchange",
                            "href":"vault-denomination-exchange.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.14 </span> Inter Branch Transactions",
                            "href":"inter-branch-transactions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.14.1 </span> Inter Branch Transaction Request",
                                    "href":"inter-branch-transaction-request.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.14.2 </span> Inter Branch Transaction Input",
                                    "href":"inter-branch-transaction-input1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.14.3 </span> Inter Branch Transaction Liquidation",
                                    "href":"inter-branch-transaction-liquidation1.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Customer Transactions",
                    "href":"customer-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Cash Deposit",
                            "href":"cash-deposit1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1.1 </span> Charge Details",
                                    "href":"charge-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Cash Withdrawal",
                            "href":"cash-withdrawal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Cheque Withdrawal",
                            "href":"cheque-withdrawal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> FX Sale Against Account",
                            "href":"fx-sale-against-account.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> FX Sale Against Walk-in",
                            "href":"fx-sale-against-walk.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> FX Purchase Against Account",
                            "href":"fx-purchase-against-account.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> FX Purchase Against Walk-in",
                            "href":"fx-purchase-against-walk1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Close Out Withdrawal",
                            "href":"close-out-withdrawal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Close Out Withdrawal by Multi-Mode",
                            "href":"close-out-withdrawal-multi-mode1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.10 </span> Safe Deposit Rental By Cash",
                            "href":"safe-deposit-rental-cash.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.11 </span> Recurring Deposit Payment by Cash",
                            "href":"recurring-deposit-payment-cash1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.12 </span> F23C Tax Payment by Cash",
                            "href":"f23c-tax-payment-cash.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.13 </span> F24C Tax Payment By Cash",
                            "href":"f24c-tax-payment-cash1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.13.1 </span> Add Standard Details",
                                    "href":"add-standard-details-f24-tax-cash.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.1 </span> Add Tax Details",
                                            "href":"add-tax-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.2 </span> Add INPS Details",
                                            "href":"add-inps-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.3 </span> Add Region Details",
                                            "href":"add-region-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.4 </span> Add IMU and Other Local Taxes",
                                            "href":"add-imu-other-local-taxes.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.5 </span> Add Insurance Details",
                                            "href":"add-insurance-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.6 </span> Add Other Bodies",
                                            "href":"add-other-bodies.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.13.1.7 </span> Add Excise Details",
                                            "href":"add-excise-details.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.13.2 </span> Add Simplified Details",
                                    "href":"add-simplified-details-f24-tax-cash.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.13.3 </span> Add Element Identification Details",
                                    "href":"add-elements-identification-details-f24-tax-cash.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.13.4 </span> Add Predefined Details",
                                    "href":"add-predefined-details-f24-tax-cash.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.14 </span> F23 Tax Payment by Account",
                            "href":"f23-tax-payment-account.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.15 </span> F24 Tax Payment By Account",
                            "href":"f24-tax-payment-account1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.15.1 </span> Add Standard Details",
                                    "href":"add-standard-details-f24-tax-account.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.15.2 </span> Add Simplified Details",
                                    "href":"add-simplified-details-f24-tax-account.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.15.3 </span> Add Element Identification Details",
                                    "href":"add-element-identification-details-f24-tax-account.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.15.4 </span> Add Predefined Details",
                                    "href":"add-predefined-details-f24-tax-account.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Miscellaneous Transactions",
                    "href":"miscellaneous-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Miscellaneous Customer Debit",
                            "href":"miscellaneous-customer-debit1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Miscellaneous Customer Credit",
                            "href":"miscellaneous-customer-credit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Miscellaneous GL Debit",
                            "href":"miscellaneous-gl-debit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Miscellaneous GL Credit",
                            "href":"miscellaneous-gl-credit1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Miscellaneous GL Transfer",
                            "href":"miscellaneous-gl-transfer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Miscellaneous Transfer",
                            "href":"miscellaneous-transfer1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Transfers",
                    "href":"transfers.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Account Transfer",
                            "href":"account-account-transfer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> In-House Cheque Deposit",
                            "href":"house-cheque-deposit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Domestic Transfer Against Account",
                            "href":"domestic-transfer-against-account1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.3.1 </span> Add Payment Details for Domestic Transfer",
                                    "href":"add-payment-details-domestic-transfer1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Domestic Transfer Against Walk-in",
                            "href":"domestic-transfer-against-walk1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> International Transfer Against Account",
                            "href":"international-transfer-against-account1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.5.1 </span> Add Payment Details for International Transfer",
                                    "href":"add-payment-details-international-transfer1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> International Transfer Against Walk-in",
                            "href":"international-transfer-against-walk1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Clearing Transactions",
                    "href":"clearing-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Cheque Deposit",
                            "href":"cheque-deposit.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1.1 </span> Cheque Deposit Against Account",
                                    "href":"cheque-deposit-against-account1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.1.2 </span> Cheque Deposit Against GL",
                                    "href":"cheque-deposit-against-gl1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Cheque Return",
                            "href":"cheque-return1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Inward Clearing Data Entry",
                            "href":"inward-clearing-data-entry1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Outward Clearing Data Entry",
                            "href":"outward-clearing-data-entry1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Remittances",
                    "href":"remittances.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Banker's Cheque",
                            "href":"bankers-cheque.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1.1 </span> BC Issue Against Account",
                                    "href":"bc-issue-against-account1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.2 </span> BC Issue Against Walk-in",
                                    "href":"bc-issue-against-walk1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.3 </span> BC Issue Against GL",
                                    "href":"bc-issue-against-gl1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.4 </span> BC Print and Reprint",
                                    "href":"bc-print-reprint1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.5 </span> BC Operations",
                                    "href":"bc-operations.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.1 </span> BC Inquiry",
                                            "href":"bc-inquiry-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.2 </span> BC Revalidation",
                                            "href":"bc-revalidation-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.3 </span> BC Duplicate Issue",
                                            "href":"bc-duplicate-issue-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.4 </span> BC Payment by Account",
                                            "href":"bc-payment-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.5 </span> BC Payment by Cash",
                                            "href":"bc-payment-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.6 </span> BC Payment by GL",
                                            "href":"bc-payment-gl1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.7 </span> BC Refund by Account",
                                            "href":"bc-refund-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.8 </span> BC Refund by Cash",
                                            "href":"bc-refund-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.9 </span> BC Refund by GL",
                                            "href":"bc-refund-gl1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.10 </span> Cancel BC by Account",
                                            "href":"cancel-bc-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.11 </span> Cancel BC by Cash",
                                            "href":"cancel-bc-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.5.12 </span> Cancel BC by GL",
                                            "href":"cancel-bc-gl1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.6 </span> Multi BC Issuance",
                                    "href":"multi-bc-issuance.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.1.6.1 </span> Multi BC Issuance Against Account",
                                            "href":"multi-bc-issuance-against-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.1.6.2 </span> Multi BC Issuance Against Cash",
                                            "href":"multi-bc-issuance-against-cash1.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Demand Drafts",
                            "href":"demand-drafts.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.2.1 </span> DD Issue Against Account",
                                    "href":"dd-issue-against-account1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.2 </span> DD Issue Against Walk-in",
                                    "href":"dd-issue-against-walk1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.3 </span> DD Issue Against GL",
                                    "href":"dd-issue-against-gl1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.4 </span> DD Print and Reprint",
                                    "href":"dd-print-reprint.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.5 </span> DD Operations",
                                    "href":"dd-operations.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.1 </span> DD Inquiry",
                                            "href":"dd-inquiry-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.2 </span> DD Revalidation",
                                            "href":"dd-revalidation-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.3 </span> DD Duplicate Issue",
                                            "href":"dd-duplicate-issue-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.4 </span> DD Payment by Account",
                                            "href":"dd-payment-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.5 </span> DD Payment by Cash",
                                            "href":"dd-payment-cash.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.6 </span> DD Payment by GL",
                                            "href":"dd-payment-gl.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.7 </span> DD Refund by Account",
                                            "href":"dd-refund-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.8 </span> DD Refund by Cash",
                                            "href":"dd-refund-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.9 </span> DD Refund by GL",
                                            "href":"dd-refund-gl1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.10 </span> Cancel DD by Account",
                                            "href":"cancel-dd-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.11 </span> Cancel DD by Cash",
                                            "href":"cancel-dd-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.12 </span> Cancel DD by GL",
                                            "href":"cancel-dd-gl1.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Cash Remittance",
                            "href":"cash-remittance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.3.1 </span> Cash Remittance Issue",
                                    "href":"cash-remittance-issue.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.1 </span> Cash Remittance Issue Against Account",
                                            "href":"cash-remittance-issue-against-account1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.2 </span> Cash Remittance Issue Against Cash",
                                            "href":"cash-remittance-issue-against-cash1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.3 </span> Cash Remittance Issue Against GL",
                                            "href":"cash-remittance-issue-against-gl1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.2 </span> Cash Remittance Operations",
                                    "href":"cash-remittance-operations.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.1 </span> Cash Remittance Inquiry",
                                            "href":"cash-remittance-inquiry.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.2 </span> Cash Remittance Payment by Account",
                                            "href":"cash-remittance-payment-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.3 </span> Cash Remittance Payment by Cash",
                                            "href":"cash-remittance-payment-cash.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.4 </span> Cash Remittance Payment by GL",
                                            "href":"cash-remittance-payment-gl.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.5 </span> Cash Remittance Refund by Account",
                                            "href":"cash-remittance-refund-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.6 </span> Cash Remittance Refund by Cash",
                                            "href":"cash-remittance-refund-cash.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.7 </span> Cash Remittance Refund by GL",
                                            "href":"cash-remittance-refund-gl.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.8 </span> Cancel Cash Remittance by Account",
                                            "href":"cancel-cash-remittance-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.9 </span> Cancel Cash Remittance by Cash",
                                            "href":"cancel-cash-remittance-cash.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.10 </span> Cancel Cash Remittance by GL",
                                            "href":"cancel-cash-remittance-gl.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.3 </span> Inward Remittance Registration",
                                    "href":"inward-remittance-registration1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Travellers Cheque",
                            "href":"travellers-cheque.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.4.1 </span> TC Sale by Other Modes",
                                    "href":"tc-sale-other-modes.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.4.1.1 </span> Add TC Denominations to Sell TC",
                                            "href":"add-tc-denominations-sell-tc.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4.2 </span> TC Sale Against Walk-in",
                                    "href":"tc-sale-against-walk1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4.3 </span> TC Purchase Against Account",
                                    "href":"tc-purchase-against-account1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.4.3.1 </span> Add TC Denominations to Purchase TC",
                                            "href":"add-tc-denominations-purchase-tc.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.4.4 </span> TC Purchase Against Walk-in",
                                    "href":"tc-purchase-against-walk1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> Instrument Status Update",
                            "href":"instrument-status-update.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.6 </span> Instrument Details Inquiry",
                            "href":"instrument-details-inquiry1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.7 </span> Inventory Integration",
                            "href":"inventory-integration.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Term Deposit Transactions",
                    "href":"term-deposit-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> TD Account Opening",
                            "href":"td-account-opening1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.1.1 </span> Add Funding Details",
                                    "href":"add-funding-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.2 </span> Add Joint Holders Details",
                                    "href":"add-joint-holders.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.3 </span> Add Payout Details",
                                    "href":"add-payout-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.4 </span> Add Interest Details",
                                    "href":"add-interest-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.5 </span> Add Rollover Details",
                                    "href":"add-rollover-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> TD Redemption Against Cash",
                            "href":"td-redemption-against-cash.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> TD Redemption Against Account",
                            "href":"td-redemption-against-account.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> TD Top-Up Against Account",
                            "href":"td-top-against-account1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> TD Top-Up Against Cash",
                            "href":"td-top-against-cash1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Credit Card Transactions",
                    "href":"credit-card-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Credit Card Advance by Cash",
                            "href":"credit-card-advance-cash.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Credit Card Advance by Transfer",
                            "href":"credit-card-advance-transfer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Credit Card Payment by Cash",
                            "href":"credit-card-payment-cash1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> Credit Card Payment by Non-Cash Modes",
                            "href":"credit-card-payment-non-cash-modes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.4.1 </span> Credit Card Payment by Account",
                                    "href":"credit-card-payment-account1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4.2 </span> Credit Card Payment by Clearing Cheque",
                                    "href":"credit-card-payment-clearing-cheque1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Stop Card Request",
                            "href":"stop-card-request.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Loan Transactions",
                    "href":"loan-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Loan Disbursement by Cash",
                            "href":"loan-disbursement-cash.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Loan Repayment by Cash",
                            "href":"loan-repayment-cash.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Islamic Transactions",
                    "href":"islamic-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Murabaha Payment by Cash",
                            "href":"murabaha-payment-cash1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Islamic Down Payment by Cash",
                            "href":"islamic-down-payment-cash1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> Islamic TD Account Opening",
                            "href":"islamic-td-account-opening.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.3.1 </span> Add Funding Details for Islamic TD",
                                    "href":"add-funding-details-islamic-td.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.2 </span> Add Joint Holders for Islamic TD",
                                    "href":"add-joint-holders-islamic-td.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.3 </span> Add Payout Details for Islamic TD",
                                    "href":"add-payout-details-islamic-td1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.4 </span> Add Rollover Details for Islamic TD",
                                    "href":"add-rollover-details-islamic-td.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Bill Payments",
                    "href":"bill-payments.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Bill Payment by Cash",
                            "href":"bill-payment-cash1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Bill Payments by Other Modes",
                            "href":"bill-payments-other-modes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.2.1 </span> Bill Payment by Account",
                                    "href":"bill-payment-account1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2.2 </span> Bill Payment by Clearing Cheque",
                                    "href":"bill-payment-clearing-cheque1.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Session Teller Transactions",
                    "href":"session-teller-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Cash Deposit",
                            "href":"cash-deposit-teller-session.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Cash Withdrawal",
                            "href":"cash-withdrawal-teller-session.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> FX Sale Against Walk-in",
                            "href":"fx-sale-against-walk.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> FX Purchase Against Walk-in",
                            "href":"fx-purchase-against-walk-teller-session.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.5 </span> Loan Repayment by Cash",
                            "href":"loan-repayment-cash-teller-session.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Journal Log",
                    "href":"journal-log.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> About Electronic and Servicing Journals",
                            "href":"electronic-servicing-journals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Electronic Journal",
                            "href":"electronic-journal1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> Servicing Journal",
                            "href":"servicing-journal1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.4 </span> Types of Transaction Status",
                            "href":"types-transaction-status.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.5 </span> Reassign Transactions",
                            "href":"reassign-transactions1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.6 </span> Natural Electronic Journal",
                            "href":"natural-electronic-journal1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Prediction",
                    "href":"prediction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Teller Service Counters Prediction",
                            "href":"teller-service-counters-prediction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Cash Prediction",
                            "href":"cash-prediction.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Customer Service",
                    "href":"customer-service.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Cheque Status Inquiry",
                            "href":"cheque-status-inquiry1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.2 </span> Stop Cheque Request",
                            "href":"stop-cheque-request1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.3 </span> Cheque Book Request",
                            "href":"cheque-book-request.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.4 </span> Passbook Issue",
                            "href":"passbook-issue1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.5 </span> Passbook Update",
                            "href":"passbook-update.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.6 </span> Passbook Status Change",
                            "href":"passbook-status-change1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.7 </span> Passbook Reprint",
                            "href":"passbook-reprint.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.8 </span> Account Balance Inquiry",
                            "href":"account-balance-inquiry.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.9 </span> Account Statement Request",
                            "href":"account-statement-request.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.10 </span> Customer Address Update",
                            "href":"customer-address-update1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.11 </span> Account Address Update",
                            "href":"account-address-update1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.12 </span> Customer Contact Update",
                            "href":"customer-contact-update1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.13 </span> Cheque Book Status Change",
                            "href":"cheque-book-status-change1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Branch Dashboard",
                    "href":"branch-dashboard.html"
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Branch Maintenance",
                    "href":"branch-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19.1 </span> Common Actions for Branch Maintenance",
                            "href":"common-actions-branch-maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.2 </span> Teller Branch Parameters",
                            "href":"maintain-teller-branch-parameters.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.3 </span> Branch Role Limits",
                            "href":"maintain-branch-role-limits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.4 </span> Branch User Preferences",
                            "href":"maintain-branch-user-preferences.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.5 </span> Denominations",
                            "href":"maintain-denominations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.6 </span> Charge Definitions",
                            "href":"maintain-charge-definitions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.7 </span> Function Code Definitions",
                            "href":"maintain-function-code-definitions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.8 </span> Function Code Preferences",
                            "href":"maintain-function-code-preferences.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.9 </span> Default Authorizer",
                            "href":"maintain-default-authorizer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.10 </span> Accounting and Settlements",
                            "href":"maintain-accounting-settlements-parameters.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.11 </span> Instrument Numbers",
                            "href":"maintain-instrument-numbers.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.12 </span> Inter Branch Transit Account",
                            "href":"maintain-inter-branch-transit-account.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.13 </span> External System",
                            "href":"maintain-external-system.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.14 </span> Channel Limits",
                            "href":"maintain-channel-limits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.15 </span> Account Group",
                            "href":"maintain-account-group.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.16 </span> Branch Group",
                            "href":"maintain-branch-group.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.17 </span> Customer Group",
                            "href":"maintain-customer-group.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.18 </span> Create Charge Pricing",
                            "href":"create-charge-pricing-maintenance1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.19 </span> View Charge Pricing",
                            "href":"view-charge-pricing-maintenance1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.20 </span> Charge Condition Group",
                            "href":"maintain-charge-condition-group.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.20.1 </span> Additional Information on Parameters",
                                    "href":"additional-information-parameters.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.21 </span> Charge Decisions",
                            "href":"maintain-charge-decisions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.22 </span> Charge Decision Enquiry",
                            "href":"charge-decision-enquiry1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.23 </span> Reject Codes",
                            "href":"maintain-reject-codes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.24 </span> Clearing Network Codes",
                            "href":"maintain-clearing-network-codes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.25 </span> Denomination Variations",
                            "href":"maintain-denomination-variations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.26 </span> External Bank Codes",
                            "href":"maintain-external-bank-codes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.27 </span> Issuer Codes",
                            "href":"maintain-issuer-codes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.28 </span> Utility Providers",
                            "href":"maintain-utility-provider.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.29 </span> Account Entitlement Restriction",
                            "href":"maintain-account-entitlement-restriction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.30 </span> Static Data Update",
                            "href":"static-data-update.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.31 </span> GST Rule Maintenance",
                            "href":"gst-rule-maintenance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.31.1 </span> Create GST Rule Maintenance",
                                    "href":"create-gst-rule-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.31.2 </span> View GST Rule Maintenance",
                                    "href":"view-gst-rule-maintenance.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.32 </span> GST Branch Parameters",
                            "href":"gst-branch-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.32.1 </span> Create GST Branch Parameters",
                                    "href":"create-gst-branch-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.32.2 </span> View GST Branch Parameters",
                                    "href":"view-gst-branch-parameters.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.33 </span> Customer Account GST Parameters",
                            "href":"customer-account-gst-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.33.1 </span> Create Customer Account GST Parameters",
                                    "href":"create-customer-account-gst-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.33.2 </span> View Customer Account GST Parameters",
                                    "href":"view-customer-account-gst-parameters.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> List of Functional Activity Codes",
                    "href":"appendix-f---list-functional-activity-codes.html"
                },
                {
                    "title":"<span class=\"secnum\">B </span> Error Codes and Messages",
                    "href":"appendix---error-codes-messages.html"
                },
                {
                    "title":"<span class=\"secnum\">C </span> List of Function Codes",
                    "href":"appendix-b---list-function-codes.html"
                },
                {
                    "title":"<span class=\"secnum\">D </span> Advices",
                    "href":"appendix-c---advices.html"
                },
                {
                    "title":"<span class=\"secnum\">E </span> Order of Replacing Parameters with Wild Card Entries",
                    "href":"appendix-d---order-replacement-parameters-wild-card-entries.html"
                },
                {
                    "title":"<span class=\"secnum\">F </span> Static Maintenance Parameters",
                    "href":"appendix-e---static-maintenance-parameters.html"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});