import { extractTextFromNode } from "./commonFunc";

export function extractTextForButton(node: any) {
    const type = node.componentProperties['Type'].value;
    if (type === 'Icon') {
        const iconChild = node.findOne((n: any) => n.name === 'Icon');
        const nameholder = iconChild?.children[0]?.name;
        return nameholder;
    }
    return extractTextFromNode(node, 'TEXT');
}

export function buttonIconProperties(node: any) {
    const {
        Type: { value: type = '' } = { value: '' },
        Style: { value: style = '' } = { value: '' },
        Size: { value: size = '' } = { value: '' }
    } = node.componentProperties;

    const iconChild = node.findOne((n: any) => n.name === 'Icon');
    let iconName: string = '';
    const mainComponent = iconChild?.mainComponent;

    if (mainComponent && mainComponent.parent && mainComponent.parent.type === "COMPONENT_SET") {
        const componentSetNode = mainComponent.parent;
        iconName = componentSetNode?.name || '';
    }

    const hideLabel = type === 'Icon';
    const imgSource = (type === 'Icon' || type === 'Icon + Text')
        ? (iconName ? `oj-ux-ico-${iconName}` : undefined)
        : undefined;
    const slotType = imgSource ? 'startIcon' : undefined;

    const buttonNameMapping: { [key: string]: string } = {
        'cta': 'primary',
        'outline': 'secondary',
        'borderless': 'tertiary'
    };

    const chromingMapping: { [key: string]: string } = {
        'cta': 'callToAction',
        'outline': 'outlined',
        'borderless': 'borderless'
    };

    const buttonName = type === 'Text' ? (buttonNameMapping[style.toLowerCase()] || style) : undefined;

    let customAttribute: any = [];

    if (type === 'Icon' || type === 'Icon + Text') {
        const chromingValue = chromingMapping[style.toLowerCase()] || style.toLowerCase();
        customAttribute.push({
            attribute: "chroming",
            value: `'${chromingValue}'`,
            colon: true,
        });
    }
    
    if (size) {
        const sizeClassMapping: any = {
            SM: "oj-button-sm",
            LG: "oj-button-lg",
        };
    
        const sizeClass = sizeClassMapping[size];
        if (sizeClass) {
            customAttribute.push({
                attribute: "class",
                value: `'${sizeClass}'`,
                colon: true,
            });
        }
    }
    
    customAttribute = customAttribute.length > 0 ? customAttribute : undefined;
    

    return { hideLabel, imgSource, slotType, buttonName, customAttribute };
}

