import { fetchOptions } from "./commonFunc";

export function generateCheckBoxProperties(node: any): any[] {
    return checkBoxOptions(node);
}

function checkBoxOptions(node: any): any {
    const checkBoxQuantity = findCheckBoxNode(node);
    const children = checkBoxQuantity?.children;
    const options = children?.map((child: any) => fetchOptions(child, output => output?.value)) ?? [];

    const optionList = {
        optionSource: "custom",
        options: options
    };
    return {optionList}
}

function findCheckBoxNode(node: any) {
    return node.findOne((n: any) => n.name.replace(/\d+/g, '').trim() === "Private/❗️Checkbox Quantity");
}

export function generateCheckBoxOrientation(node: any): string {
    const checkBoxQuantity = findCheckBoxNode(node);
    const orientationValue = checkBoxQuantity.componentProperties?.['Orientation']?.value?.toLowerCase();
    return orientationValue === 'horizontal' ? 'oj-choice-direction-row' : '';
}