import { addAttributes } from "../traverseNode";

export function paddingDivider(node: any, output: any) {
    const paddingValue: string = framePadding(node);
    let dividerClasses = [
        node.strokeBottomWeight > 0 ? 'oj-divider-bottom' : '',
        node.strokeTopWeight > 0 ? 'oj-divider-top' : '',
        node.strokeRightWeight > 0 ? 'oj-divider-end' : '',
        node.strokeLeftWeight > 0 ? 'oj-divider-start' : ''
    ].filter(Boolean).join(' ');

    if (node.strokes.length <= 0) {
        dividerClasses = ''
    }

    if (paddingValue && dividerClasses) {

        const paddingDivider = {
            colon: true,
            attribute: 'class',
            value: `' ${paddingValue} ${dividerClasses}'`.trim()
        };
        output.customAttribute = addAttributes(output.customAttribute, paddingDivider);
    }
}

function framePadding(node: any) {
    const boundVars = node.boundVariables;
    if (!boundVars) {
        return '';
    }

    let paddingLeftValue = '';
    let paddingRightValue = '';
    let paddingTopValue = '';
    let paddingBottomValue = '';

    const resolvePaddingValue = (paddingVar: any) => {
        const variableId = paddingVar?.id;
        const variable = figma.variables.getVariableById(variableId);
        return variable ? variable.name : null;
    };

    if (boundVars.paddingLeft) {
        paddingLeftValue = resolvePaddingValue(boundVars.paddingLeft) || '';
    }
    if (boundVars.paddingRight) {
        paddingRightValue = resolvePaddingValue(boundVars.paddingRight) || '';
    }
    if (boundVars.paddingTop) {
        paddingTopValue = resolvePaddingValue(boundVars.paddingTop) || '';
    }
    if (boundVars.paddingBottom) {
        paddingBottomValue = resolvePaddingValue(boundVars.paddingBottom) || '';
    }

    if (
        paddingLeftValue &&
        paddingLeftValue === paddingRightValue &&
        paddingLeftValue === paddingTopValue &&
        paddingLeftValue === paddingBottomValue
    ) {
        return `oj-sm-padding-${paddingLeftValue}`;
    }

    const isHorizontalEqual =
        paddingLeftValue && paddingLeftValue === paddingRightValue;

    const isVerticalEqual =
        paddingTopValue && paddingTopValue === paddingBottomValue;

    if (isHorizontalEqual && isVerticalEqual) {
        return `oj-sm-padding-${paddingLeftValue}-horizontal oj-sm-padding-${paddingTopValue}-vertical`;
    }

    if (isVerticalEqual) {
        return `oj-sm-padding-${paddingTopValue}-vertical${paddingLeftValue ? ` oj-sm-padding-${paddingLeftValue}-start` : ''}${paddingRightValue ? ` oj-sm-padding-${paddingRightValue}-end` : ''}`;
    }

    if (isHorizontalEqual) {
        return `oj-sm-padding-${paddingLeftValue}-horizontal${paddingTopValue ? ` oj-sm-padding-${paddingTopValue}-top` : ''}${paddingBottomValue ? ` oj-sm-padding-${paddingBottomValue}-bottom` : ''}`;
    }

    const classList: any = [];

    if (paddingLeftValue) {
        classList.push(`oj-sm-padding-${paddingLeftValue}-start`);
    }
    if (paddingRightValue) {
        classList.push(`oj-sm-padding-${paddingRightValue}-end`);
    }
    if (paddingTopValue) {
        classList.push(`oj-sm-padding-${paddingTopValue}-top`);
    }
    if (paddingBottomValue) {
        classList.push(`oj-sm-padding-${paddingBottomValue}-bottom`);
    }

    return classList.join(' ');
}