import { useAppContext } from '../../context/AppContext';
import ButtonComponent from '../utility/Button';
import ContainerComponent from "../utility/ContainerComponent";
import Header from "../utility/Header";
import "ojs/ojinputtext";
import 'ojs/ojcollapsible';

export function MergeSummary(props: any) {

    const { conditionSet, handleMerge } = props;
    const { setType } = useAppContext();

    const handleBack = () => {
        setType('mergeConditions');
    }

    const countConditions = () => {
        let newConditions: any[] = [], modifiedConditions: any[] = [], removedConditions: any[] = [], unchangedConditions: any[] = [];

        conditionSet.forEach((condition: any) => {
            if (condition.updateCondition === condition.old) {
                unchangedConditions.push(condition);
            } else if (condition.new !== '') {
                if (condition.updateCondition === condition.new) {
                    newConditions.push(condition);
                } else if (condition.updateCondition !== condition.old) {
                    modifiedConditions.push(condition);
                } else if (condition.updateCondition === '') {
                    removedConditions.push(condition);
                }
            }
        });

        return { newConditions, modifiedConditions, removedConditions, unchangedConditions };
    };

    const { newConditions, modifiedConditions, removedConditions, unchangedConditions } = countConditions();

    return (
        <>
            <ContainerComponent>
                <Header title='Add Condition' handleBack={handleBack} />

                <div style={{ overflowY: 'auto', flex: 1, marginBottom: '45px' }}>
                    <h3>Merge Summary</h3>

                    <oj-collapsible id="c1" class='oj-bg-success-30' style={{ padding: '10px', margin: '5px 0', borderRadius: '5px', border: '2px solid #28a745' }}>
                        <div slot="header">
                            <strong>New : </strong> {newConditions.length}
                        </div>
                        <ul>
                            {newConditions.map((condition: any) => (
                                <li key={condition.figmaId}>{condition.name}</li>
                            ))}
                        </ul>
                    </oj-collapsible>

                    <oj-collapsible id="c2" class='oj-bg-info-30' style={{ padding: '10px', margin: '5px 0', borderRadius: '5px', border: '2px solid #17a2b8' }}>
                        <div slot="header">
                            <strong>Modified : </strong> {modifiedConditions.length}
                        </div>
                        <ul>
                            {modifiedConditions.map((condition: any) => (
                                <li key={condition.figmaId}>{condition.name}</li>
                            ))}
                        </ul>
                    </oj-collapsible>

                    <oj-collapsible id="c3" class='oj-bg-danger-30' style={{ padding: '10px', margin: '5px 0', borderRadius: '5px', border: '2px solid #dc3545' }}>
                        <div slot="header">
                            <strong>Removed : </strong> {removedConditions.length}
                        </div>
                        <ul>
                            {removedConditions.map((condition: any) => (
                                <li key={condition.figmaId}>{condition.name}</li>
                            ))}
                        </ul>
                    </oj-collapsible>

                    <oj-collapsible id="c4" class='oj-bg-neutral-30' style={{ padding: '10px', margin: '5px 0', borderRadius: '5px', border: '2px solid #6c757d' }}>
                        <div slot="header">
                            <strong>Unchanged : </strong> {unchangedConditions.length}
                        </div>
                        <ul>
                            {unchangedConditions.map((condition: any) => (
                                <li key={condition.figmaId}>{condition.name}</li>
                            ))}
                        </ul>
                    </oj-collapsible>

                </div>

                <ButtonComponent
                    label='Merge'
                    onClick={handleMerge}
                    disabled={false}
                />
            </ContainerComponent>
        </>
    )
}