import { conditionControlling, createClone, deleteCondition, deleteGrid, exportResult, generate, generateOutput, removeSelectionChangeListener, saveConditionData, saveGridData, selectOverviewEmptyComponent, selectOverviewSidePanelComponent, selectTemplateComponent, templateComponent, templateOutput, updateConditionData } from "./msgFunc";
import { fetchAllComponents } from "./traverseNode";

figma.showUI(__html__, { width: 440, height: 450, title: "UX Plugin" });

async function init() {
    const storedTrunkPath = await figma.clientStorage.getAsync('trunkPath');
    if (storedTrunkPath?.path) {
        figma.ui.postMessage({ path: storedTrunkPath });
    }
    // await figma.clientStorage.deleteAsync('trunkPath');
}

init();
figma.ui.onmessage = async (msg: any) => {
    if (msg?.path === 'trunk') {
        const trunkPath = msg.finalPath;
        figma.clientStorage.setAsync('trunkPath', { path: trunkPath });
    }

    if (msg?.type === 'main-page') {
        figma.ui.resize(440, 450);
    }

    if (msg?.type === 'create-clone') {
        const { component, type } = msg?.cloneComponent ?? {};
        createClone(component, type);
    }

    if (msg?.type === 'generate') {
        generate();
    }

    if (msg?.type === 'generate-output') {
        const selectedButton = msg?.selectedButton;
        let messageDetails: string = msg?.transactionType;
        generateOutput(selectedButton, messageDetails);
    }


    if (msg?.type === 'fetch-controlling-component') {
        conditionControlling();
    }

    if (msg?.type === 'save-condition-data') {
        const conditionData = msg?.componentDetails;
        saveConditionData(conditionData);
    }

    if (msg?.type === 'update-condition') {
        const conditionData = msg?.componentDetails;
        updateConditionData(conditionData);
    }

    if (msg.type === 'delete-condition') {
        const index = msg?.index;
        const figmaId = msg?.figmaId;
        deleteCondition(index, figmaId);
    }

    if (msg?.type === 'save-grid-data') {
        const gridData = msg?.gridMap;
        const selectedComponent = msg?.selectedComponent;
        saveGridData(gridData, selectedComponent);
    }

    if (msg?.type === 'delete-grid') {
        deleteGrid();
    }

    if (msg?.type === 'fetch-template-component') {
        selectTemplateComponent();
    }

    if (msg?.type === 'fetch-overview-empty-component') {
        selectOverviewEmptyComponent();
    }

    if (msg?.type === 'fetch-overview-sidepanel-component') {
        selectOverviewSidePanelComponent();
    }

    if (msg?.type === 'template') {
        templateComponent();
    }

    if (msg?.type === 'template-output') {
        const selectedButton = msg?.selectedButton;
        let messageDetails: string = msg?.templateData;
        templateOutput(selectedButton, messageDetails);
    }

    if (msg?.type === 'export-proceed') {
        const formData = msg?.formData;
        await fetchAllComponents();
        exportResult(formData);
    }

    if (msg?.type === 'update-overwrite') {
        removeSelectionChangeListener();
    }

    if (msg?.type === 'select-component') {
        const figmaId = msg?.figmaId;
        const node = figma.getNodeById(figmaId) as InstanceNode;
        if (node) {
            figma.ui.postMessage({ pluginSelectedComponent: node.name });
            figma.currentPage.selection = [node];
            figma.viewport.scrollAndZoomIntoView([node]);
        }
    }

    if (msg?.type === 'close-plugin') {
        figma.closePlugin();
    }

}