import { addAttributes } from "../traverseNode";

export function panelResult(node: any, frameResult: any) {
    let value = 'oj-panel ';
    const colorValue: any = panelBgColor(node);

    if (colorValue) {
        value += `${colorValue} `;
    }

    const shadowValue: any = panelShadow(node);

    if (shadowValue) {
        value += `${shadowValue} `;
    }

    // const paddingValue: any = panelPadding(node);

    // if (paddingValue) {
    //     value += `${paddingValue}`
    // }

    const panel = {
        "colon": true,
        "attribute": "class",
        "value": `'${value}'`
    };
    frameResult.customAttribute = addAttributes(frameResult.customAttribute, panel);
}

function panelBgColor(node: any) {
    const fills: any = node.fills;

    if (fills && fills[0]?.boundVariables && fills[0]?.boundVariables.color) {
        const variableId = fills[0].boundVariables.color.id;
        const variable = figma.variables.getVariableById(variableId);
        if (variable) {
            const colorValue = variable?.name;
            const outputColor: string = convertToColorFormat(colorValue) || 'oj-bg-body';
            return outputColor;
        } else {
            console.error('Variable not found');
            return 'oj-bg-body ';
        }
    } else {
        console.error('No colour assigned');
        return 'oj-bg-body ';
    }
}

function panelShadow(node: any) {
    const effectStyleId = node?.effectStyleId;
    if (effectStyleId) {
        const effectStyle: any = figma.getStyleById(effectStyleId)?.name;
        const shadowOutput = convertToShadowFormat(effectStyle);
        return shadowOutput;
    }
}

function convertToColorFormat(input: string) {
    const parts = input.split("/");
    let [colorName, colorValue] = parts.slice(-2);
    colorName = colorName.toLowerCase().replace(/\s+/g, "-");
    colorValue = colorValue.toLowerCase().replace(/\s+/g, "-");
    return `oj-bg-${colorName}-${colorValue}`;
}

function convertToShadowFormat(input: string) {
    const parts = input.split("/");
    let shadowSize = parts.slice(-1)[0];
    shadowSize = shadowSize.toLowerCase();
    return `oj-panel-shadow-${shadowSize}`;
}

function panelPadding(node: any) {
    const boundVars = node.boundVariables;
    if (!boundVars) {
        return '';
    }

    let paddingLeftValue = '';
    let paddingRightValue = '';
    let paddingTopValue = '';
    let paddingBottomValue = '';

    const resolvePaddingValue = (paddingVar: any) => {
        const variableId = paddingVar?.id;
        const variable = figma.variables.getVariableById(variableId);
        return variable ? variable.name : null;
    };

    if (boundVars.paddingLeft) {
        paddingLeftValue = resolvePaddingValue(boundVars.paddingLeft) || '';
    }
    if (boundVars.paddingRight) {
        paddingRightValue = resolvePaddingValue(boundVars.paddingRight) || '';
    }
    if (boundVars.paddingTop) {
        paddingTopValue = resolvePaddingValue(boundVars.paddingTop) || '';
    }
    if (boundVars.paddingBottom) {
        paddingBottomValue = resolvePaddingValue(boundVars.paddingBottom) || '';
    }

    if (
        paddingLeftValue &&
        paddingLeftValue === paddingRightValue &&
        paddingLeftValue === paddingTopValue &&
        paddingLeftValue === paddingBottomValue
    ) {
        return `oj-sm-padding-${paddingLeftValue}`;
    }

    const isHorizontalEqual =
        paddingLeftValue && paddingLeftValue === paddingRightValue;

    const isVerticalEqual =
        paddingTopValue && paddingTopValue === paddingBottomValue;

    if (isHorizontalEqual && isVerticalEqual) {
        return `oj-sm-padding-${paddingLeftValue}-horizontal oj-sm-padding-${paddingTopValue}-vertical`;
    }

    if (isVerticalEqual) {
        return `oj-sm-padding-${paddingTopValue}-vertical${paddingLeftValue ? ` oj-sm-padding-${paddingLeftValue}-start` : ''}${paddingRightValue ? ` oj-sm-padding-${paddingRightValue}-end` : ''}`;
    }

    if (isHorizontalEqual) {
        return `oj-sm-padding-${paddingLeftValue}-horizontal${paddingTopValue ? ` oj-sm-padding-${paddingTopValue}-top` : ''}${paddingBottomValue ? ` oj-sm-padding-${paddingBottomValue}-bottom` : ''}`;
    }

    const classList: any = [];

    if (paddingLeftValue) {
        classList.push(`oj-sm-padding-${paddingLeftValue}-start`);
    }
    if (paddingRightValue) {
        classList.push(`oj-sm-padding-${paddingRightValue}-end`);
    }
    if (paddingTopValue) {
        classList.push(`oj-sm-padding-${paddingTopValue}-top`);
    }
    if (paddingBottomValue) {
        classList.push(`oj-sm-padding-${paddingBottomValue}-bottom`);
    }

    return classList.join(' ');
}