export async function frameWorkSpectraComponentsFunc(type: string) {
    let response: any;
    if (type === 'frameWork') {
        response = await fetch('http://localhost:3000/files/readFrameworkElements');
    } else if (type === 'spectra') {
        response = await fetch('http://localhost:3000/files/readSpectraComponents');
    }
    const components = await response.json();
    const ccaPropertiesArray = components.map((component: any) => component.ccaProperties);
    return ccaPropertiesArray;
}

export async function coreComponentsFunc() {
    let response: any = await fetch('http://localhost:3000/files/readCoreComponents');
    const components = await response.json();
    const coreMetaData = components.map((component: any) => component.metadata);
    return coreMetaData;
}

export async function businessComponentsFunc() {
    const response = await fetch('http://localhost:3000/files/readBusinessComponents');
    const components = await response.json();
    const propertiesArray = components.map((component: any) => {
        const { properties, moduleName } = component;
        if (properties) {
            const { name, version, jetVersion, displayName, description, properties: innerProperties, methods, events, slots } = properties;
            return {
                name,
                version,
                jetVersion,
                displayName,
                description,
                moduleName,
                properties: innerProperties,
                methods,
                events,
                slots
            };
        }
        return null;
    }).filter((property: any) => property !== undefined);
    return propertiesArray;
}
