import { camelCase, cleanComponentProperties } from "./cleanFunc";

export function handleReadOnly(selectedComponent: any) {
    const outputClone = selectedComponent?.clone();
    if (outputClone) {
        turnReadOnly(outputClone);
        figma.ui.postMessage({ action: 'close' });
    }
}

function turnReadOnly(node: any): void {
    figma.skipInvisibleInstanceChildren = true;
    if (node?.type === 'INSTANCE') {
        if (node.reactions) {
            node.reactions = [];
        }
        const mainComponent = node.mainComponent as ComponentNode;
        const componentSetNode = mainComponent?.parent as ComponentSetNode;
        const componentProperties = componentSetNode?.componentPropertyDefinitions;

        if (componentProperties) {
            if ('readOnly' in componentProperties) {
                try {
                    node.setProperties({
                        readOnly: 'True'
                    });
                } catch (error) {
                    console.error('Error setting readOnly property:', error);
                }
                return;
            }

            const stateVariantOptions = componentProperties?.State?.variantOptions;
            if (stateVariantOptions) {
                const readOnlyVariants = ["Read Only", "Read-only"];
                const selectedState = readOnlyVariants.find(variant =>
                    stateVariantOptions.includes(variant)
                );
                if (selectedState) {
                    try {
                        node.setProperties({
                            State: selectedState
                        });
                    } catch (error) {
                        console.error('Error setting State property:', error);
                    }
                    return;
                }
            }
        }
    }
    if (node.children && node.children.length > 0) {
        for (const child of node.children) {
            turnReadOnly(child);
        }
    }
}

export async function handleTransaction(selectedComponent: any, transactionType: string) {

    //key at one location
    const componentSet = await figma.importComponentSetByKeyAsync("dc50189b5219b2c418f086e8a4561c997862e54d") as ComponentSetNode;
    const componentNodeToClone = componentSet?.defaultVariant as ComponentNode;
    const outputClone = componentNodeToClone?.createInstance() as InstanceNode;

    outputClone.setProperties({
        'Review Type': transactionType === 'default' ? 'Default' : 'Skip Review'
    });

    const initiation = outputClone?.findOne((n: any) => n.name === 'Initiation') as InstanceNode;
    const initiationTransactionBody = initiation?.findOne((n: any) => n.name === 'Transaction Body');

    const review = outputClone?.findOne((n: any) => n.name === 'Review Default') as InstanceNode ||
        outputClone?.findOne((n: any) => n.name === 'Skip Review') as InstanceNode;
    const reviewTransactionBody = review?.findOne((n: any) => n.name === 'Transaction Body');

    const initClone = selectedComponent?.clone();
    const reviewClone = selectedComponent?.clone();

    if (initClone && reviewClone && initiationTransactionBody && reviewTransactionBody) {
        generateTransaction(initClone, initiationTransactionBody);
        turnReadOnly(reviewClone);
        generateTransaction(reviewClone, reviewTransactionBody);
    } else {
        figma.ui.postMessage({ type: 'error', message: 'Invalid frames selected.' });
    }
    initClone.remove();
    reviewClone.remove();
    figma.currentPage.selection = [outputClone];
    figma.viewport.scrollAndZoomIntoView([outputClone]);
    figma.ui.postMessage({ action: 'close' });
}

const convertToOverviewComponent = (selectedFrame: any, constFrame: any) => {
    let selectedComponent: any;
    if (selectedFrame?.type === 'FRAME') {
        try {
            const frameItemSpacing = selectedFrame.itemSpacing;
            selectedComponent = figma.createComponent();
            selectedComponent.name = 'Overview Body';
            selectedComponent.resizeWithoutConstraints(selectedFrame.width, selectedFrame.height);
            selectedComponent.layoutMode = "VERTICAL";
            selectedComponent.primaryAxisSizingMode = "FIXED";
            selectedComponent.counterAxisSizingMode = "FIXED";
            selectedComponent.itemSpacing = frameItemSpacing;
            for (const child of selectedFrame.children) {
                child.y = 0;
                selectedComponent.appendChild(child);
            }
        } catch (error) {
            console.error("Error converting frame to component:", error);
        }
    } else {
        console.log('Selection should be a frame');
    }

    let targetInstance: any;
    if (constFrame?.type === 'INSTANCE') {
        targetInstance = constFrame;
    } else {
        console.log('Invalid Transaction');
    }

    if (selectedComponent && targetInstance) {
        targetInstance.swapComponent(selectedComponent);
    }
    targetInstance.horizontalPadding = 48;
    targetInstance.verticalPadding = 48;
    targetInstance.primaryAxisSizingMode = "FIXED";
    targetInstance.counterAxisSizingMode = "FIXED";
    selectedComponent.remove();
}

export async function handleOverview(messageDetails: any) {
    const componentNode = await figma.importComponentByKeyAsync("837116584e680816a8132c41f0c8a70dc7f02493") as ComponentNode;
    const outputClone = componentNode?.createInstance() as InstanceNode;

    if (messageDetails?.overviewId) {
        const overviewComponent = figma.currentPage.findOne((n: any) => n.id === messageDetails?.overviewId) as FrameNode;
        const centralContainer = outputClone.findOne((n: any) => n.name === 'Overview Body') as InstanceNode;

        const overviewClone = overviewComponent?.clone();

        if (overviewClone && centralContainer) {
            convertToOverviewComponent(overviewClone, centralContainer);
        }

        overviewClone.remove();
    }

    if (messageDetails?.noDataId) {
        const noDataComponent = figma.currentPage.findOne((n: any) => n.id === messageDetails?.noDataId) as InstanceNode;
        const emptyListingPage = outputClone?.findOne((n: any) => n.name === 'Listing Page (Empty)') as InstanceNode;
        const mainContent = emptyListingPage?.findOne((n: any) => n.name === 'Main Content') as FrameNode;
        const content = mainContent?.findOne((n: any) => n.name === 'Content') as FrameNode;
        const emptyListingNode = content?.children[0] as InstanceNode;
        if (noDataComponent && noDataComponent.mainComponent && emptyListingNode) {
            emptyListingNode.swapComponent(noDataComponent.mainComponent);
        }
    }

    if (messageDetails?.sidePanel) {
        const sidepanelComponent = figma.currentPage.findOne((n: any) => n.id === messageDetails?.sidePanel) as InstanceNode;
        const sidePanelFrame = outputClone.findOne((n: any) => n.name === 'Side Panel') as FrameNode;
        const sidePanel = sidePanelFrame?.children[0] as InstanceNode;
        if (sidepanelComponent && sidepanelComponent.mainComponent && sidePanel) {
            sidePanel.swapComponent(sidepanelComponent.mainComponent);
        }
    }

    figma.currentPage.selection = [outputClone];
    figma.viewport.scrollAndZoomIntoView([outputClone]);
    figma.ui.postMessage({ action: 'close' });
}

const generateTransaction = (selectedFrame: any, constFrame: any) => {
    let selectedComponent: any;
    if (selectedFrame?.type === 'FRAME') {
        try {
            const frameItemSpacing = selectedFrame.itemSpacing;
            selectedComponent = figma.createComponent();
            selectedComponent.name = 'Transaction Body';
            selectedComponent.resizeWithoutConstraints(selectedFrame.width, selectedFrame.height);
            selectedComponent.layoutMode = "VERTICAL";
            selectedComponent.primaryAxisSizingMode = "FIXED";
            selectedComponent.counterAxisSizingMode = "FIXED";
            selectedComponent.itemSpacing = frameItemSpacing;
            for (const child of selectedFrame.children) {
                child.y = 0;
                selectedComponent.appendChild(child);
            }
            // for (let i = selectedFrame.children.length - 1; i >= 0; i--) {
            //     const child = selectedFrame.children[i];
            //     console.log(child.name);
            //     child.y = 0;
            //     selectedComponent.appendChild(child);
            // }
        } catch (error) {
            console.error("Error converting frame to component:", error);
        }
    } else {
        console.log('Selection should be a frame');
    }

    let targetInstance: any;
    if (constFrame?.type === 'INSTANCE') {
        targetInstance = constFrame;
    } else {
        console.log('Invalid Transaction');
    }

    if (selectedComponent && targetInstance) {
        targetInstance.swapComponent(selectedComponent);
    }
    targetInstance.horizontalPadding = 48;
    targetInstance.verticalPadding = 48;
    targetInstance.primaryAxisSizingMode = "FIXED";
    targetInstance.counterAxisSizingMode = "FIXED";
    selectedComponent.remove();
}

export function handleGrid(selectedComponent: any) {
    let childrenList: any;
    if ('children' in selectedComponent) {
        childrenList = selectedComponent?.children.map((child: any) => child.name);;
    }
    const selectedGridComponent = {
        id: selectedComponent.id,
        name: selectedComponent.name
    }
    figma.ui.postMessage({ selected: true, selectedGridComponent, gridComponent: childrenList, generateType: 'grid' });
}

export function handleAddCondition(selectedComponent: any) {
    const conditionComponent1: any = {
        id: selectedComponent.id,
        name: selectedComponent.name,
    }
    if (selectedComponent.type === 'INSTANCE') {
        const mainComponent = selectedComponent.mainComponent as ComponentNode;
        const componentSetNode = mainComponent?.parent as ComponentSetNode;
        if (componentSetNode && 'componentPropertyDefinitions' in componentSetNode) {
            const propertiesDetails = getPropertiesDetails(componentSetNode);
            conditionComponent1.propertiesDetails = propertiesDetails;
        }
    }
    figma.ui.postMessage({ selected: true, conditionComponent1, generateType: 'condition' });
    figma.ui.resize(680, 490);
}

export function getPropertiesDetails(component: any) {
    const formattedObject: any = {};
    const inputObject = component.componentPropertyDefinitions;
    if (Object.keys(inputObject).length === 0) {
        return;
    }
    for (const key in inputObject) {
        let cleanedKey = camelCase(key.split('#')[0]);
        if(inputObject[key].type==='BOOLEAN'){
            formattedObject[cleanedKey] = inputObject[key].defaultValue;
        }
    }
    return formattedObject;
}

export function getValueDetails(selectedComponent: any) {
    figma.skipInvisibleInstanceChildren = true;
    const textNode = selectedComponent.findAllWithCriteria({ types: ['TEXT'] });
    const arrayOfStrings: string[] = textNode.map((obj: any) => obj.characters);
    figma.skipInvisibleInstanceChildren = false;
    return arrayOfStrings;
}