const path = require("path");
const webpack = require('webpack');

module.exports = {
    entry: {
        code: "./code.ts"
    },
    module: {
        rules: [
            {
                test: /\.tsx?$/,
                use: "ts-loader",
                exclude: /node_modules/
            },
        ]
    },
    // Webpack tries these extensions for you if you omit the extension like "import './file'"
    resolve: {
        extensions: [
            ".tsx",
            ".ts",
            ".jsx",
            ".js"
        ],
    },
    output: {
        publicPath: '/',
        filename: (pathData) => pathData.chunk.name === 'code'
        ? 'code.js'
        : '[name].[contenthash].js',
        path: path.resolve(__dirname,
            "dist"), // Compile into a folder called "dist"
        // Clean the output directory before emit.
        clean: true
    },
// Tells Webpack to generate "ui.html" and to inline "ui.ts" into it
plugins: [
    new webpack.DefinePlugin({
        global: {} // Fix missing symbol error when running in developer VM
    }),
]
};
