/**
  Copyright (c) 2015, 2023, Oracle and/or its affiliates.
  Licensed under The Universal Permissive License (UPL), Version 1.0
  as shown at https://oss.oracle.com/licenses/upl/

*/
module.exports = {
  /**
   *
   * @param {object} options.context - ojet build context which contains useful fields like
   * buildType
   * @param {object} options.config - Default webpack config generated by ojet. You can
   * add to it, remove from it or update it using webpack-merge which was
   * installed alongside webpack. If desired, you can create your own config
   * and return it which will override the default config
   * @returns {object|undefined}
   */
  webpack: ({ context, config }) => {
    if (context.buildType === 'release') {
      // update config with release / production options
    } else {
      // console.log(JSON.stringify(config))
      const HtmlInlineScriptPlugin = require("html-inline-script-webpack-plugin")
config.plugins.splice(2,0,new HtmlInlineScriptPlugin({
  htmlMatchPattern: [/index.html/],
  scriptMatchPattern: [/.js$/]
}))
 config.plugins[3].options.runtime=false
config.module.rules.unshift( {
  test: /\.sass$/,
  use: [
  'style-loader',
  'css-loader',
  'sass-loader',
],
})
      // update config w
      // update config with development options
    }
    // only have to return if new config object was created but
    // since it doesn't matter always returning the config is good
    // practice
    return config;
  }
};
