import { useState, useEffect, useCallback } from "preact/hooks";
import "ojs/ojinputtext";
import "ojs/ojlabel";
import "ojs/ojbutton";
import "ojs/ojlabelvalue";
import "ojs/ojlistview";
import "ojs/ojlistitemlayout";
import "ojs/ojknockout";
import "ojs/ojcheckboxset";
import "ojs/ojselectsingle";
import "ojs/ojradioset";
import { ojCheckboxset } from "ojs/ojcheckboxset";
import ContainerComponent from "../utility/ContainerComponent";
import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from "../../context/PluginData";
import Header from "../utility/Header";
import ButtonComponent from "../utility/Button";

export function GenerateSelected() {

    const { setType } = useAppContext();
    const { pluginData } = useAppDataContext();

    const [selectedButton, setSelectedButton] = useState<string>('grid');
    // const [transactionType, setTransactionType] = useState<string>('default');
    const [conditionArray, setConditionArray] = useState<any[]>([]);
    const [gridArray, setGridArray] = useState<any[]>([]);
    const [logicState, setLogicState] = useState<boolean>(false);
    const [logicCheck, setLogicCheck] = useState<Record<string, boolean>>({});

    useEffect(() => {
        if (pluginData?.conditionData) {
            try {
                const conditionArray = JSON.parse(pluginData.conditionData);
                setConditionArray(conditionArray);
            } catch (error) {
                console.error("Error parsing conditionData:", error);
                setConditionArray([]);
            }
        } else {
            setConditionArray([]);
        }

        if (pluginData?.fetchGridData) {
            try {
                setGridArray(pluginData.fetchGridData);
            } catch (error) {
                console.error("Error parsing conditionData:", error);
                setGridArray([]);
            }
        } else {
            setGridArray([]);
        }
    }, [pluginData]);

    const handleBack = () => {
        parent.postMessage({ pluginMessage: { type: 'main-page' } }, '*');
        setType("mainPage");
    }

    const onButtonSetValueChanged = (event: any) => {
        setSelectedButton(event.detail.value);
    }

    // const handleTransactionChange = (event: any) => {
    //     const component = event.detail.value;
    //     setTransactionType(component);
    // };

    const handleLogic = () => {
        setLogicState(true);
    }

    const handleLogicCheckValue = (
        index: string,
        event: ojCheckboxset.valueChanged<string, Array<string>, Array<string>>
    ) => {
        setLogicCheck(prevState => ({
            ...prevState,
            [index]: event.detail.value!.length < 1 ? false : true
        }));
    };

    const handleCancel = () => {
        setLogicState(false);
    }

    const handleAddLogic = () => {
        const result: any = [];
        let subArray: any = [];

        conditionArray.forEach((component, index) => {
            if (logicCheck[index] !== undefined && logicCheck[index]) {
                if (Array.isArray(component)) {
                    subArray.push(...component);
                } else {
                    subArray.push(component);
                }
            } else {
                result.push(component);
            }
        });

        if (subArray.length > 0) {
            result.unshift(subArray);
        }
        setConditionArray(result);
        setLogicState(false);
        parent.postMessage({ pluginMessage: { type: 'update-condition', componentDetails: result } }, '*');
    }

    const handleDelete = (figmaId: string, index: number) => {
        parent.postMessage({ pluginMessage: { type: 'delete-condition', figmaId, index } }, '*');
        setType('generate');
    }

    const handleRemoveLogic = (index: number) => {
        const result: any = [];
        conditionArray.forEach((component, index) => {
            if (Array.isArray(component)) {
                result.push(...component);
            } else {
                result.push(component);
            }
        });
        setConditionArray(result);
        parent.postMessage({ pluginMessage: { type: 'update-condition', componentDetails: result } }, '*');
    }

    const renderData = useCallback((data: any) => {
        const renderItem = (item: any, index: number) => (
            <div key={index} class="oj-typography-body-md oj-text-color-primary">
                {item.controllingComponentName && <span>{item.controllingComponentName}</span>}
                {item.controllingProperty && <span> → {item.controllingProperty}</span>}
                {item.controllingProperty && item.controllingPropertyValue && <span> → {item.controllingPropertyValue}</span>}
                {item.controllingComponentValue && <span> → {item.controllingComponentValue}</span>}
            </div>
        );

        if (Array.isArray(data)) {
            return data.map(renderItem);
        } else {
            return renderItem(data, 0);
        }
    }, []);

    const handleGenerate = () => {
        // if (selectedButton === 'transaction') {
        //     parent.postMessage({ pluginMessage: { type: 'generate-output', selectedButton, transactionType } }, '*');
        // } else {
        // }
        parent.postMessage({ pluginMessage: { type: 'generate-output', selectedButton } }, '*');
    }

    const handleDeleteGrid = () => {
        parent.postMessage({ pluginMessage: { type: 'delete-grid' } }, '*');
        setType('generate');
    }

    const totalValue = gridArray.reduce((sum, item) => sum + item.value, 0);
    return (
        <>
            <ContainerComponent>
                <Header title='Modify Component' handleBack={handleBack} />
                <oj-input-text
                    id="componentName"
                    value={pluginData?.componentName}
                    label-hint="Selected Component"
                    label-edge="inside"
                    readonly
                    class="oj-sm-margin-4x-bottom"
                ></oj-input-text>

                {/* label can be added in common component */}
                <oj-label-value>
                    <oj-label id="mainlabelid" slot="label" style={{ color: '#5A5957', fontSize: '12px', fontWeight: '600' }}>Select the action you would like to perform</oj-label>
                </oj-label-value>
                <oj-buttonset-one
                    id="generateOptions"
                    labelled-by="generateOptionsId"
                    value={selectedButton}
                    onvalueChanged={onButtonSetValueChanged}
                    class="oj-button-sm oj-sm-margin-4x-bottom">
                    {/* <oj-option value='readOnly'>
                        <span>Convert To Read Only</span>
                    </oj-option> */}
                    {/* <oj-option value='transaction'>
                        <span>Transaction</span>
                    </oj-option> */}
                    <oj-option value='grid'>
                        <span>Add Grid</span>
                    </oj-option>
                    <oj-option value='condition'>
                        <span>Add Condition</span>
                    </oj-option>
                </oj-buttonset-one>

                {/* {selectedButton === 'transaction' && (
                    <div style={{ display: 'flex', alignItems: 'center', marginBottom: '10px' }}>
                        <oj-radioset
                            id="transactionType"
                            value={transactionType}
                            class="oj-choice-direction-row"
                            label-hint="Select Transaction Type"
                            onvalueChanged={handleTransactionChange}>
                            <oj-option value="default">Default</oj-option>
                            <oj-option value="skipReview">Skip Review</oj-option>
                        </oj-radioset>
                    </div>
                )} */}

                {selectedButton === 'condition' && (
                    <div style={{ paddingBottom: '10px' }}>
                        {conditionArray.length !== 0 && (
                            <div style={{ display: "flex", alignItems: "center", marginBottom: "5px", paddingTop: "5px", paddingBottom: "10px", borderBottom: "thin solid #DEDEDE", cursor: "pointer", transition: "background-color 0.3s" }}
                                onMouseOver={(e) => {
                                    e.currentTarget.style.backgroundColor = "#F2F2F2";
                                }}
                                onMouseOut={(e) => {
                                    e.currentTarget.style.backgroundColor = "initial";
                                }}
                                onClick={handleLogic}>
                                <oj-button class="oj-button-sm" display="icons" chroming="borderless" onClick={handleLogic}>
                                    <span class="oj-ux-ico-plus oj-ux-icon-size-5x" role="img" aria-label="add"></span>
                                </oj-button>
                                <div slot="secondary" class="oj-typography-body-md oj-text-color-primary">
                                    Add Logic
                                </div>
                            </div>
                        )}
                        <div style={{ overflowY: 'auto', flex: 1, marginBottom: '25px' }}>
                            {conditionArray.map((data: any, index: any) => (
                                <div style={{ display: "flex", alignItems: "center", marginBottom: "10px", paddingBottom: "10px", borderBottom: "thin solid #DEDEDE" }}>
                                    {logicState && (
                                        <oj-checkboxset
                                            style={{ alignSelf: "center" }}
                                            id={index}
                                            onvalueChanged={(event) => handleLogicCheckValue(index, event)}
                                        >
                                            <oj-option value={index}></oj-option>
                                        </oj-checkboxset>
                                    )}
                                    <div style={{ marginRight: "auto" }}>
                                        <div style={{ color: '#5A5957', fontSize: '12px', fontWeight: '600' }}>
                                            Connected To
                                        </div>
                                        {renderData(data)}
                                    </div>
                                    {!Array.isArray(data) && (
                                        <oj-button class="oj-button-sm" display="icons" chroming="borderless" style={{ alignSelf: "center" }} onojAction={() => handleDelete(data.variableComponentId, index)}>
                                            <span class="oj-ux-ico-trash oj-ux-icon-size-5x" style={{ color: '#B3311F' }} role="img" title="Delete Condition" aria-label="delete"></span>
                                        </oj-button>
                                    )}
                                    {Array.isArray(data) && (
                                        <oj-button class="oj-button-sm" display="icons" chroming="borderless" style={{ alignSelf: "center" }} onojAction={() => handleRemoveLogic(index)}>
                                            <span class="oj-ux-ico-if oj-ux-icon-size-5x" style={{ color: '#B3311F' }} role="img" title="Remove AND Logic" aria-label="cancel"></span>
                                        </oj-button>
                                    )}
                                </div>
                            ))}
                        </div>
                    </div>
                )}

                {selectedButton === 'grid' && gridArray.length > 0 && (
                    <div
                        style={{
                            display: 'grid',
                            gridTemplateColumns: gridArray.map(item => `calc(${(item.value / totalValue) * 100}% - 5px)`).join(' '),
                            width: '100%',
                            height: '100px',
                            gap: '5px',
                            padding: '0px',
                            boxSizing: 'border-box'
                        }}
                    >
                        {gridArray.map((item, index) => (
                            <div
                                key={index}
                                style={{
                                    display: 'flex',
                                    flexDirection: 'column',
                                    alignItems: item.alignItems,
                                    justifyContent: item.justifyContent,
                                    borderRadius: '10px',
                                    padding: '10px',
                                    backgroundColor: '#d9d9d9',
                                    textAlign: 'center',
                                    boxSizing: 'border-box'
                                }}
                            >
                                <div style={{ fontSize: '12px', color: '#5A5957' }}>{item.key}</div>
                                <div style={{ fontWeight: 'bold', marginBottom: '5px' }}>{item.value}</div>
                            </div>
                        ))}
                    </div>
                )}

                {((selectedButton === 'condition' && !logicState) ||
                    (selectedButton === 'grid' && gridArray.length === 0)) && (
                        <ButtonComponent
                            label={selectedButton === 'condition' ? 'Add New Condition' : 'Add New Grid'}
                            onClick={handleGenerate}
                            disabled={false}
                        />
                    )}


                {selectedButton !== 'condition' && selectedButton !== 'grid' && (
                    <ButtonComponent
                        label='Proceed'
                        onClick={handleGenerate}
                        disabled={false}
                    />
                )}

                {/* Change to Button component in utility */}
                {logicState && selectedButton === 'condition' && (
                    <div style={{ position: 'fixed', bottom: 8, left: 8, right: 8, padding: 0, display: 'flex', justifyContent: 'space-between' }}>
                        <oj-button style={{ flex: 1, marginRight: '8px' }} class="oj-button-md" chroming="outlined" label="Cancel" onojAction={handleCancel} />
                        <oj-button style={{ flex: 1, marginLeft: '8px' }} class="oj-button-md" chroming="callToAction" label="Add" onojAction={handleAddLogic} />
                    </div>
                )}

                {gridArray.length > 0 && selectedButton === 'grid' && (
                    <div style={{ position: 'fixed', bottom: 8, left: 8, right: 8, padding: 0, display: 'flex', justifyContent: 'space-between' }}>
                        <oj-button style={{ flex: 1, marginRight: '8px' }} class="oj-button-md" chroming="outlined" label="Remove Grid" onojAction={handleDeleteGrid} />
                        <oj-button style={{ flex: 1, marginLeft: '8px' }} class="oj-button-md" chroming="callToAction" label="Edit Grid" onojAction={handleGenerate} />
                    </div>
                )}

            </ContainerComponent>
        </>
    )
}