import { useState, useEffect } from "preact/hooks";
import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from "../../context/PluginData";
import { MainPage } from "./mainPage";
import { Create } from "./create";
import { NotSelected } from "./notSelected";
import { GenerateSelected } from "./generateSelected";
import { AddCondition } from "./conditionComponent1";
import { AddGrid } from "./addGrid";
import { GenerateSuccess } from "./generateSuccess";
import { ExportForm } from "./exportForm";
import { MenuEntry } from "./menuEntry";
import { ExportSelected } from "./exportSelected";
import { Success } from "./success";
import { UpdateOverwrite } from "./updateOverwrite";
import { UpdateConditions } from "./updateConditions";
import { MergeConditions } from "./mergeConditions";
import { MergeSummary } from "./mergeSummary";
import { ConvertTemplate } from "./templatePage";

export function MainContainer() {

    const { formData, setFormData, type, setType } = useAppContext();
    const { pluginData } = useAppDataContext();
    const [menuData, setMenuData] = useState([]);
    const [oldObject, setOldObject] = useState<any>(null);
    const [conditionSet, setConditionSet] = useState<any>();



    useEffect(() => {
        if (type === 'generate') {
            parent.postMessage({ pluginMessage: { type: 'generate' } }, '*');
        }
    }, [type])

    useEffect(() => {
        if (pluginData?.generateType === 'condition' && pluginData?.conditionComponent1) {
            setType('condition');
        }
        if (pluginData?.generateType === 'grid') {
            setType('grid');
        }
        if (pluginData?.path) {
            const trunkPath: any = pluginData?.path;
            setFormData({
                ...formData,
                trunkPath: trunkPath?.path
            });
        }
    }, [pluginData]);


    if (pluginData?.action === 'close') {
        parent.postMessage({ pluginMessage: { type: 'close-plugin' } }, '*');
    }

    const fetchData = async (url: string, data: object) => {
        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data),
            });
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
            return await response.json();
        } catch (error) {
            console.error(`Error in API call to ${url}:`, error);
            throw error;
        }
    };

    const checkFileExists = async () => {
        const data = {
            channelPath: formData.trunkPath,
            moduleName: formData.moduleName,
            componentName: formData.componentName,
            componentType: formData.componentType,
            businessComponent: formData.usableComponent,
        };

        const response = await fetch('http://localhost:3000/files/checkFileExists', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });

        const result = await response.json();
        if (result) {
            setOldObject(result);
            return true;
        } else {
            return false;
        }
    };

    const addEntryInMenu = async () => {
        try {
            const response = await fetch('http://localhost:3000/files/addEntryInMenu', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    "nlsPath": `${formData.trunkPath}\\resources/nls/menu.js`,
                    "flowName": formData.componentName,
                    "menuEntryName": formData.componentDescription,
                    menuData,
                    "componentType": formData.componentType

                })
            });
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
            console.log('Menu Entry done successfully');
        } catch (error) {
            console.error('Error in API', error);
        }
    }

    const writeDrawerMetadata = async (drawerMetaData: any, drawerFormData: any) => {
        try {
            const response = await fetch('http://localhost:3000/files/writeMetadata', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    "moduleName": drawerFormData.moduleName || drawerFormData.componentName,
                    "componentName": drawerFormData.componentName,
                    "componentType": drawerFormData.componentType,
                    "metaData": drawerMetaData,
                    "businessComponent": drawerFormData.usableComponent
                })
            });
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            } else {
                console.log('Drawer MetaData written successfully');
            }
        } catch (error) {
            console.error('Error in written metadata API', error);
        }
    }


    const handleExport = async () => {
        if (type !== 'updateOverwrite' && await checkFileExists()) {
            parent.postMessage({ pluginMessage: { type: 'update-overwrite' } }, '*');
            setType('updateOverwrite');
            return;
        }

        if (pluginData?.output) {

            if (pluginData?.drawerMetaData && pluginData?.drawerFormData) {
                writeDrawerMetadata(pluginData?.drawerMetaData, pluginData?.drawerFormData);
            }
            console.log({
                "moduleName": formData.moduleName,
                "componentName": formData.componentName,
                "componentType": formData.componentType,
                "metaData": pluginData?.output,
                "businessComponent": formData.usableComponent
            });
            const writeMetadata = async () => {
                try {
                    const response = await fetch('http://localhost:3000/files/writeMetadata', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            "moduleName": formData.moduleName,
                            "componentName": formData.componentName,
                            "componentType": formData.componentType,
                            "metaData": pluginData?.output,
                            "businessComponent": formData.usableComponent
                        })
                    });
                    if (!response.ok) {
                        throw new Error(`HTTP error! Status: ${response.status}`);
                    } else {
                        if (formData.menuEntry) {
                            addEntryInMenu();
                        }
                        setType('success');
                        console.log('MetaData written successfully');
                    }
                } catch (error) {
                    console.error('Error in written metadata API', error);
                }
            }
            const writeMetadataPromise = writeMetadata();
        }
    };

    const updateMetadata = async (metaData: any, formData: any) => {
        const data = {
            channelPath: formData.trunkPath,
            moduleName: formData.moduleName || formData.componentName,
            componentName: formData.componentName,
            componentType: formData.componentType,
            metaData: metaData,
            businessComponent: formData.usableComponent,
        };

        try {
            const response = await fetch('http://localhost:3000/files/updateMetadata', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            });
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            } else {
                console.log('MetaData updated successfully');
                setType('success');
            }
        } catch (error) {
            console.error('Error in written metadata API', error);
        }
    };

    const handleUpdate = async (metaData: any) => {
        if (pluginData?.drawerMetaData && Object.keys(pluginData?.drawerMetaData)?.length && Object.keys(pluginData?.drawerFormData)?.length) {
            updateMetadata(pluginData?.drawerMetaData, pluginData?.drawerFormData);
        }
        updateMetadata(metaData, formData);
    }

    const handleConditions = () => {
        const oldLayout = oldObject?.components[0]?.layout;
        const newLayout = pluginData?.output?.components[0]?.layout;
        const result: any = compareConditionalValues(newLayout, oldLayout);
        if (result === true) {
            handleUpdate(pluginData?.output);
        } else {
            setConditionSet(result);
            setType('updateConditions');
        }
    }

    function compareConditionalValues(
        newFile: any[],
        oldFile: any[]
    ): boolean | { figmaId: string; new: string; old: string }[] {
        const diffArray: { figmaId: string; new: string; old: string }[] = [];

        const compareObjects = (newObj: any, oldObj: any) => {
            const newConditionalValue = newObj.conditionalExpression?.conditionalValue ?? "";
            const oldConditionalValue = oldObj?.conditionalExpression?.conditionalValue ?? "";
            // Add to the array if the conditional values are different
            if (newConditionalValue !== oldConditionalValue) {
                diffArray.push({
                    figmaId: newObj.figmaId,
                    new: newConditionalValue,
                    old: oldConditionalValue,
                });
            }
            // Recursively compare children by matching figmaId
            if (newObj.children && oldObj.children) {
                newObj.children.forEach((newChild: any) => {
                    const oldChild = oldObj.children?.find((child: any) => child.figmaId === newChild.figmaId);
                    if (oldChild) {
                        compareObjects(newChild, oldChild);
                    }
                });
            }
        };

        newFile.forEach((newObj) => {
            const oldObj = oldFile.find((item) => item.figmaId === newObj.figmaId);
            if (oldObj) {
                compareObjects(newObj, oldObj);
            }
        });

        return diffArray.length === 0 ? true : diffArray;
    }

    const handleMerge = () => {
        const newMetaData = pluginData?.output;
        //issue may rise for individual page with contract buttons
        let newData;
        if(formData.componentType === 'FLOW'){
            newData = [newMetaData?.components[0]?.layout[0]]
        } else {
            newData = newMetaData?.components[0]?.layout;
        }
        updateConditionInLayout(newData);
        handleUpdate(newMetaData);
    }

    const updateConditionInLayout = (metadata: any) => {
        conditionSet.forEach((condition: any) => {
            const { figmaId, updateCondition } = condition;
            metadata.forEach((metaItem: any) => {
                const targetItem = metaItem.children.find(
                    (child: any) => child.figmaId === figmaId
                );

                if (targetItem) {
                    if (updateCondition !== "") {
                        if (targetItem.conditionalExpression?.conditionalValue) {
                            targetItem.conditionalExpression.conditionalValue = updateCondition;
                        } else {
                            targetItem.conditionalExpression = {
                                conditionalValue: updateCondition,
                            };
                        }
                    } else {
                        if (targetItem.conditionalExpression?.conditionalValue) {
                            delete targetItem.conditionalExpression.conditionalValue;
                        }

                        if (targetItem.conditionalExpression &&
                            Object.keys(targetItem.conditionalExpression).length === 0) {
                            delete targetItem.conditionalExpression;
                        }
                    }
                }
            });
        });
    };

    return (
        <>
            {type === 'mainPage' && (
                <MainPage />
            )}


            {type === 'create' && (
                <Create />
            )}

            {type === 'generate' && !pluginData?.selected && (
                <NotSelected componentType="generate" />
            )}

            {type === 'generate' && pluginData?.selected && (
                <GenerateSelected />
            )}

            {type === 'template' && (
                <ConvertTemplate />
            )}

            {type === 'condition' && (
                <AddCondition />
            )}

            {type === 'grid' && (
                <AddGrid />
            )}

            {type === 'conditionSuccess' && (
                <GenerateSuccess successType='Condition' />
            )}

            {type === 'gridSuccess' && (
                <GenerateSuccess successType='Grid' />
            )}

            {type === 'export' && (
                <ExportForm />
            )}

            {type === 'exportMenuEntry' && (
                <MenuEntry menuData={menuData} setMenuData={setMenuData} />
            )}

            {type === 'exportProceed' && !pluginData?.selected && (
                <NotSelected componentType="export" />
            )}

            {type === 'exportProceed' && pluginData?.selected && (
                <ExportSelected handleExport={handleExport} />
            )}

            {type === 'success' && (
                <Success />
            )}

            {/* {type === 'updateOverwrite' && !pluginData?.selected && (
                <NotSelected componentType="export" />
                )} */}

            {type === 'updateOverwrite' && (
                <UpdateOverwrite handleExport={handleExport} handleUpdate={handleConditions} />
            )}

            {type === 'updateConditions' && (
                <UpdateConditions handleUpdate={handleUpdate} />
            )}

            {type === 'mergeConditions' && conditionSet && (
                <MergeConditions conditionSet={conditionSet} setConditionSet={setConditionSet} />
            )}

            {type === 'mergeSummary' && conditionSet && (
                <MergeSummary conditionSet={conditionSet} handleMerge={handleMerge} />
            )}


        </>
    )
}