import { useState } from "preact/hooks";
import ContainerComponent from "../utility/ContainerComponent";
import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from "../../context/PluginData";
import Header from "../utility/Header";
import ButtonComponent from "../utility/Button";
import "ojs/ojcheckboxset";
import { ojCheckboxset } from "ojs/ojcheckboxset";

export function ConvertTemplate() {

    const { setType } = useAppContext();
    const { pluginData, setPluginData } = useAppDataContext();
    const [selectedButton, setSelectedButton] = useState<string>('transaction');
    const [transactionType, setTransactionType] = useState<string>('default');
    const [emptyStateExists, setEmptyStateExists] = useState<string>('emptyState');


    const handleBack = () => {
        parent.postMessage({ pluginMessage: { type: 'main-page' } }, '*');
        setPluginData({
            ...pluginData,
            templateComponent: undefined,
            overviewNoDataComponent: undefined,
            overviewSidePanel: undefined
        });
        setType("mainPage");
    }

    const onButtonSetValueChanged = (event: any) => {
        setSelectedButton(event.detail.value);
    }

    const handleTransactionChange = (event: any) => {
        const component = event.detail.value;
        setTransactionType(component);
    };

    const handleTemplate = () => {
        let data;
        if(pluginData?.templateComponent?.nodeType!=='FRAME'){
            console.log('Selected Component should to be a frame');
            return;
        }
        if (selectedButton === 'transaction') {
            data = {
                id: pluginData?.templateComponent?.id,
                name: pluginData?.templateComponent?.name,
                type: transactionType
            }
        } else {
            if(pluginData?.overviewNoDataComponent?.nodeType!=='INSTANCE'){
                console.log('No Data Component should to be a instance');
                return;
            }
            if(pluginData?.overviewSidePanel?.nodeType!=='INSTANCE'){
                console.log('Side Panel Component should to be a instance');
                return;
            }
            data = {
                overviewId: pluginData?.templateComponent?.id,
                noDataId: pluginData?.overviewNoDataComponent?.id,
                sidePanel: pluginData?.overviewSidePanel?.id
            }
        }
        parent.postMessage({ pluginMessage: { type: 'template-output', selectedButton, templateData: data } }, '*');
    }

    const fetchTemplateComponent = () => {
        parent.postMessage({ pluginMessage: { type: 'fetch-template-component' } }, '*');
    }

    const fetchEmptyStateComponent = () => {
        parent.postMessage({ pluginMessage: { type: 'fetch-overview-empty-component' } }, '*');
    }

    const fetchSidePanel = () => {
        parent.postMessage({ pluginMessage: { type: 'fetch-overview-sidepanel-component' } }, '*');
    }

    const handleEmptyState = (
        event: ojCheckboxset.valueChanged<string, Array<string>>
    ) => {
        const emptyState: any = event.detail.value
        setEmptyStateExists(emptyState[0]);
    };


    return (
        <>
            <ContainerComponent>
                <Header title='Convert to Template' handleBack={handleBack} />

                {/* label can be added in common component */}
                <oj-label-value>
                    <oj-label id="mainlabelid" slot="label" style={{ color: '#5A5957', fontSize: '12px', fontWeight: '600' }}>Select the action you would like to perform</oj-label>
                </oj-label-value>
                <oj-buttonset-one
                    id="generateOptions"
                    labelled-by="generateOptionsId"
                    value={selectedButton}
                    onvalueChanged={onButtonSetValueChanged}
                    class="oj-button-sm oj-sm-margin-4x-bottom">
                    <oj-option value='transaction'>
                        <span>Transaction</span>
                    </oj-option>
                    <oj-option value='overview'>
                        <span>Overview</span>
                    </oj-option>
                </oj-buttonset-one>

                {selectedButton === 'transaction' && (
                    <div style={{ alignItems: 'center', marginBottom: '10px' }}>
                        {!pluginData?.templateComponent && (
                            <oj-button class="oj-button-md oj-button-full-width" id="width_full_button" chroming="borderless" label="Select the Transaction Body" style={{ border: "2px dashed black" }} onojAction={fetchTemplateComponent} />
                        )}
                        {pluginData?.templateComponent && (
                            <oj-input-text
                                id="templateComponent"
                                value={pluginData.templateComponent.name}
                                label-hint="Template Body"
                                label-edge="inside"
                                readonly
                                class=""
                            >
                                <oj-button
                                    slot="end"
                                    display="icons"
                                    onojAction={fetchTemplateComponent}
                                    chroming="borderless">
                                    <span slot="endIcon" class="oj-ux-ico-edit"></span>
                                </oj-button>
                            </oj-input-text>
                        )}
                        <oj-radioset
                            id="transactionType"
                            value={transactionType}
                            class="oj-choice-direction-row oj-sm-margin-4x-top"
                            label-hint="Select Transaction Type"
                            onvalueChanged={handleTransactionChange}>
                            <oj-option value="default">Default</oj-option>
                            <oj-option value="skipReview">Skip Review</oj-option>
                        </oj-radioset>
                    </div>
                )}

                {selectedButton === 'overview' && (
                    <div style={{ alignItems: 'center', marginBottom: '10px' }}>
                        {!pluginData?.templateComponent && (
                            <oj-button class="oj-button-md oj-button-full-width oj-sm-margin-4x-bottom" id="width_full_button" chroming="borderless" label=" Select the Frame of Overview Sections" style={{ border: "2px dashed black" }} onojAction={fetchTemplateComponent} />
                        )}
                        {pluginData?.templateComponent && (
                            <oj-input-text
                                id="templateComponent"
                                value={pluginData.templateComponent.name}
                                label-hint="Overview Body"
                                label-edge="inside"
                                readonly
                                class="oj-sm-margin-4x-bottom"
                            >
                                <oj-button
                                    slot="end"
                                    display="icons"
                                    onojAction={fetchTemplateComponent}
                                    chroming="borderless">
                                    <span slot="endIcon" class="oj-ux-ico-edit"></span>
                                </oj-button>
                            </oj-input-text>
                        )}

                        <oj-checkboxset
                            id="overviewId"
                            class="oj-sm-margin-4x-bottom"
                            value={[emptyStateExists]}
                            onvalueChanged={(event) => handleEmptyState(event)}>
                            <oj-option value={emptyStateExists}>Include Listing Empty State</oj-option>
                        </oj-checkboxset>

                        {!pluginData?.overviewNoDataComponent && emptyStateExists && (
                            <oj-button class="oj-button-md oj-button-full-width oj-sm-margin-4x-bottom" id="width_full_button" chroming="borderless" label="Select Listing Empty State Body Component" style={{ border: "2px dashed black" }} onojAction={fetchEmptyStateComponent} />
                        )}
                        {pluginData?.overviewNoDataComponent && emptyStateExists && (
                            <oj-input-text
                                id="noData"
                                value={pluginData.overviewNoDataComponent.name}
                                label-hint="Listing Empty State Body"
                                label-edge="inside"
                                readonly
                                class="oj-sm-margin-4x-bottom"
                            >
                                <oj-button
                                    slot="end"
                                    display="icons"
                                    onojAction={fetchEmptyStateComponent}
                                    chroming="borderless">
                                    <span slot="endIcon" class="oj-ux-ico-edit"></span>
                                </oj-button>
                            </oj-input-text>
                        )}

                        {!pluginData?.overviewSidePanel && (
                            <oj-button class="oj-button-md oj-button-full-width" id="width_full_button" chroming="borderless" label="Select the Side Panel Component" style={{ border: "2px dashed black" }} onojAction={fetchSidePanel} />
                        )}
                        {pluginData?.overviewSidePanel && (
                            <oj-input-text
                                id="componentName"
                                value={pluginData.overviewSidePanel.name}
                                label-hint="Side Panel"
                                label-edge="inside"
                                readonly
                                class=""
                            >
                                <oj-button
                                    slot="end"
                                    display="icons"
                                    onojAction={fetchSidePanel}
                                    chroming="borderless">
                                    <span slot="endIcon" class="oj-ux-ico-edit"></span>
                                </oj-button>
                            </oj-input-text>
                        )}
                    </div>
                )}

                <ButtonComponent label='Save' onClick={handleTemplate} disabled={false} />

            </ContainerComponent>
        </>
    )
}