import { useAppContext } from '../../context/AppContext';
import "ojs/ojbutton";
import ContainerComponent from '../utility/ContainerComponent';
import Header from '../utility/Header';
import { useAppDataContext } from "../../context/PluginData";

export function UpdateConditions(props: any) {
    const { setType } = useAppContext();
    const { pluginData } = useAppDataContext();
    const {handleUpdate} = props;


    const handleBack = () => {
        setType("updateOverwrite");
    }

    const handleMerge = () => {
        setType('mergeConditions');
    }

    const handleFigmaConditions = () => {
        handleUpdate(pluginData?.output);
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Export to toolkit' handleBack={handleBack} />
                <div style={{ display: "flex", flexDirection: "column", justifyContent: "center", flexGrow: 1, alignContent: 'center' }}>
                    <p style={{ textAlign: 'center' }}>Merge or Figma Conditions?</p>
                    <div class="oj-sm-margin-2x">
                        <oj-button class="oj-button-md oj-button-full-width oj-sm-margin-2x-bottom" chroming="outlined" label="Merge" onojAction={handleMerge} />
                        <oj-button class="oj-button-md oj-button-full-width" chroming="outlined" label="Figma Conditions" onojAction={handleFigmaConditions} />
                    </div>
                </div>
            </ContainerComponent>
        </>
    )
}
