import { useState, useContext } from "preact/hooks";
import { createContext } from "preact";

export interface FormDataInterface {
    componentType: string;
    componentName: string;
    componentDescription: string;
    usableComponent: boolean;
    moduleName: string;
    moduleDescription: string;
    trunkPath: string;
    menuEntry: boolean;
    readOnly: boolean;
    ignoredInstanceList: any[];
    userType: []
}

interface AppContextState {
    type: string;
    setType: (type: string) => void;
    formData: FormDataInterface;
    setFormData: (type: FormDataInterface) => void;
}

const AppContext = createContext<AppContextState | undefined>(undefined);

const AppProvider = ({ children }: any) => {

    const [type, setType] = useState<string>('mainPage');
    const [formData, setFormData] = useState<FormDataInterface>(
        {
            componentType: 'SINGLE_PAGE',
            componentName: '',
            componentDescription: '',
            usableComponent: false,
            moduleName: '',
            moduleDescription: '',
            trunkPath: '',
            menuEntry: false,
            readOnly: false,
            ignoredInstanceList: [] as any[],
            userType: []
        }
    );



    return (
        <AppContext.Provider value={{
            type,
            setType,
            formData,
            setFormData
        }}>
            {children}
        </AppContext.Provider>
    );
};

const useAppContext = (): AppContextState => {
    const context = useContext(AppContext);
    if (!context) {
        throw new Error('useAppContext must be used within an AppProvider');
    }
    return context;
};

export { AppProvider, useAppContext };
