export function componentToComponentMapping(key: string): string {
    const mapping: any = {
        'row': 'obdx-row',
        'account': 'account-input',
        'address': 'obdx-address',
        'obdxLookup': 'bank-look-up',
        'uiDownload': 'transaction-container',
        'modalDialog': 'modal-window',
        'widget': 'obdx-widget'
    };

    return mapping[key] || key;
}

export function slotToTagType(key: string): string {
    const mapping: any = {
        'itemTemplate': 'template-xyz',
    };

    return mapping[key] || 'div';
}

export function idToComponentMapping(key: string): string | undefined {
    const mapping: Record<string, string> = {
        "4756:20092": "inputText",
        "4937:12849": "inputPassword",
        "4937:11301": "inputNumber",
        "4988:17159": "inputTextArea",
        "4988:18238": "inputDate",
        "4910:3567": "inputDate",
        "2:2434": "pageSection", //doubtful key
        "5198:58956": "pageSection",
        "4463:58092": "tabBar",
        "5047:26806": "columnShare",
        "5047:27173": "inputSelectSingle",
        "4910:3564": "inputSelectSingle",
        "4851:8152": "switch",
        "4853:8833": "radioSet",
        "4277:32868": "toggleButton",
        "4867:10574": "sliderSingle",
        "4870:11499": "checkboxSet",
        "4729:20125": "button",
        "5002:46775": "text",
        "4910:3547": "text",
        "5002:45785": "link",
        "4910:4027": "link",
        "4881:12521": "meterBarVertical",
        "4989:23035": "meterBarHorizontal",
        "4883:14322": "ratingGaugeStep",
        "4989:24744": "ratingGaugeEditable",
        "4989:33115": "avatarLight",
        "4989:33315": "avatarDark",
        "4893:29605": "filePicker",
        "4463:57959": "badgeLight",
        "4539:67399": "badgeDark",
        "4060:63176": "icon",
        "5065:48169": "table",
        "5198:61127": "overview"

    }
    return mapping[key];
}

export function idToComponentMapping25A(key: string): string | undefined {
    const mapping: Record<string, string> = {
        "5528:31451": "inputText", 
        "5528:33088": "inputPassword", 
        "5528:33408": "inputNumber", 
        "5528:34955": "inputTextArea", 
        "5528:37077": "inputDate", 
        "5528:39516": "tabBar", 
        "5528:42072": "inputSelectSingle", 
        "5529:47447": "switch", 
        "5529:47658": "radioSet", 
        "5342:1985": "toggleButton", 
        "5529:46936": "sliderSingle", 
        "5529:48479": "checkboxSet", 
        "5528:35326": "button", 
        "5538:49101": "meterBarVertical", 
        "5538:50803": "meterBarHorizontal", 
        "5538:53268": "ratingGaugeStep", 
        "5538:68593": "ratingGaugeEditable", 
        "5528:41618": "avatarLight", 
        "5539:76969": "avatarDark", 
        "5539:77172": "filePicker",
        "5528:39383": "badgeLight", 
        "5539:77211": "badgeDark", 
    }
    return mapping[key];
}

export function idToKeyMapping24D(key: string): string | undefined {
    const mapping: Record<string, string> = {
        "56a5e845b49192b8e8f66b18c4a3445d534fe6e1": "inputText",
        "bcc27e59cd11b002d7d97ae44df878bd661ec688": "inputPassword",
        "50b95395241e42b34ff8beafa633c630753daffa": "inputNumber",
        "af96efbfda7a6c4b6c3d1a38724d1b8d85171942": "inputTextArea",
        "85d8413cbfc76e641e7c226d17b52a416ca85c72": "inputDate",
        "762567ee63d8e0ed9af5c89f1c95c1979b2b82c5": "inputDate",
        "79ca7775bfcd0d5495b736eb94af07630ea8c633": "inputSearch",
        "856c19a88057ba1893789e1b127c0d13f915f5d6": "pageSection",
        "2a0224825fe68bce2d080cef0cada9ecbf991418": "tabBar",
        "88ef710e6e9abe6bd67cfbaa3dfcf86217367be4": "columnShare",
        "baf82bd69c9941f58df144a8bc083b7f6a4f11c5": "inputSelectSingle",
        "c4ff56e763ce198fb0b0ba0a7e2b2280027c6a9b": "inputSelectSingle",
        "d21d21b5f6defd30c861795277b6d444ca825414": "switch",
        "25a81b7899387be6cc3346f33d7f65ea291af276": "radioSet",
        "d5e5ef668111eae708b359c9a011d237405dcf69": "toggleButton",
        "121fe2cb6e4319cd31be4bbbc3f57ad678eedf6c": "sliderSingle",
        "1c87600bb283898e11a525b58ec1e48fd23391f4": "checkboxSet",
        "8510ae5c24806457cc373b09ad4a0107b54c38bf": "button",
        "3f579efdf289902def5c5b397f57356048aaf5f3": "text",
        "9e416d7d806d74cbe33df9c596bead8ab1dcd5b8": "text",
        "182251f5669f396f4a51c272939f92c55a791a3d": "link",
        "fda35e70719c085f8098ba908491fb28e4d4155d": "link",
        "8b2076b7000e30dece9795b396999cd205db3b22": "meterBarVertical",
        "5b2295ae6d48eccbf40e79baba7b514ae7897602": "meterBarHorizontal",
        "95d839546d30cb595d85f1df5c3a25670b7dd34a": "ratingGaugeStep",
        "6745818caa6f8e26043e320331a81d7f2bf4e417": "ratingGaugeEditable",
        "3a878cb791e67c418e60d77c0c2221e58b7082c7": "avatarLight",
        "c9079453139052205d83c19aec54b14f8a45d87a": "avatarDark",
        "562df21a0e497e5a5adef91aafa76a137fc7332e": "filePicker",
        "dfb7ef849f69beb77536fc776b73474e8c4ba582": "badgeLight",
        "421fc3706a6921a39b10aa7987b190d80d6e23ae": "badgeDark",
        "d9c50a7aecbfe3aed34c50238629ef0ee8548391": "icon",
        "7f79552c1027df5bc44334abb55bd6426fb2a5b8": "table",
        "837116584e680816a8132c41f0c8a70dc7f02493": "listingOverview",
        "9279562bcb68eea75c1579d7fae921623d486cf5": "overview",
        "755dca111769eae6b45ce22b3917417ca044f894": "chart"
    }
    return mapping[key];
}

export function idToKeyMapping25A(key: string): string | undefined {
    const mapping: Record<string, string> = {
        "a07c38a0c208fca1b8b95087845641dfc3de2c90": "inputText",
        "4f23b0bafef6bd60ccb8e79ddbea241038996907": "inputPassword",
        "7dd4f7654f21e96f7693f00a3c6b3af096cd66db": "inputNumber",
        "7ddadc9d59f0badfba2073ef19ec55dd2c715203": "inputTextArea",
        "841addeecbfa3e69f1b5b45a2b22fa70a54cdddd": "inputDate",
        "0ff17b1415258b52c2ec14c77b3dde68857dfc1e": "inputSearch",
        "351b7ad42ff0f33b4d39cacaacebba16f17d62cb": "tabBar",
        "5625656160e2ec517962517c1955979ae0fc308d": "inputSelectSingle",
        "6ae9bb5a34a4bb226f6da83ae4daf3d53b42beb5": "switch",
        "621f793d07bdbebb41dcd97c2feb0956a962c603": "radioSet",
        "b0d61edc79b961a7ec8a51a79225ca578df20af3": "toggleButton",
        "d82fccbdf78183ed97349ad15805b85d88a5d270": "sliderSingle",
        "87081a245fc2c281405fa54933b9fa2b10cb79bd": "checkboxSet",
        "c90997803d731d471059bfcfde1b1c029869aa21": "button",
        "1ea5bda7a718a2b50ba00824799048f810b7f885": "meterBarVertical",
        "0c043a6f0a0d14be885d17613c0a85b9c521b690": "meterBarHorizontal",
        "ca2efcaca4720872b551d0cd8e6b6ee26149b06b": "ratingGaugeStep",
        "4242dde649c58b63f5f00bf60bf2ae5973dafc45": "ratingGaugeEditable",
        "24cb665a7f70b0c2cd32ca14eac2917bac98b2e5": "avatarLight",
        "268dd81422605950421014357a80efa8c3541dbf": "avatarDark",
        "db53912644c9a5eae494436d9672ed28d345ecba": "filePicker",
        "de82d57bba974a20789974bcf0ee10af6807fb27": "badgeLight",
        "843661fee20bb1055b15c0b527f3afa484c147e0": "badgeDark",
    }
    return mapping[key];
}