import { useAppContext } from '../../context/AppContext';
import { useAppDataContext } from '../../context/PluginData';
import ButtonComponent from '../utility/Button';
import ContainerComponent from '../utility/ContainerComponent';
import Header from '../utility/Header';

export function ExportSelected(props: any) {
    const { handleExport } = props;
    const { setType, formData, setFormData } = useAppContext();
    const { pluginData, ignoredComponentListKnown, ignoredComponentListUnknown } = useAppDataContext();

    const handleBack = () => {
        setFormData({
            ...formData,
            menuEntry: false
        });
        setType("export");
    }

    return (
        <>
            <ContainerComponent>
                <Header title='Export to toolkit' handleBack={handleBack} />
                <oj-input-text
                    id="componentName"
                    value={pluginData?.componentName}
                    label-hint="Selected Component"
                    label-edge="inside"
                    readonly
                    class="oj-sm-margin-2x-bottom"
                ></oj-input-text>
                {(ignoredComponentListKnown.length > 0 || ignoredComponentListUnknown.length > 0) && (
                    <>
                        <div class="oj-typography-body-md oj-sm-margin-2x-bottom">
                            Note - Plugin does not recognize the following components:
                        </div>
                        {ignoredComponentListKnown.length > 0 && (
                            <>
                                <div class="oj-typography-body-md">
                                    Following unrecognized components will be used as Div:
                                </div>
                                <ul>
                                    {ignoredComponentListKnown.map((component, index) => (
                                        <li key={index}>
                                            <div class="ignoredComponentListKnown">
                                                {component.name} (ID: {component.id})
                                            </div>
                                        </li>
                                    ))}
                                </ul>
                            </>
                        )}

                        {ignoredComponentListUnknown.length > 0 && (
                            <>
                                <div class="oj-typography-body-md">
                                    Following unrecognized components will be used as ignored:
                                </div>
                                <ul>
                                    {ignoredComponentListUnknown.map((component, index) => (
                                        <li key={index}>
                                            <div class="ignoredComponentListUnknown">
                                                {component.name} (ID: {component.id})
                                            </div>
                                        </li>
                                    ))}
                                </ul>
                            </>
                        )}
                    </>
                )}

                <ButtonComponent
                    label='Export'
                    onClick={handleExport}
                    disabled={false} />

            </ContainerComponent>
        </>
    )
}