define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-6588A54D-9FC9-4735-B858-9196E7E16FED"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Liquidity Management - An Overview",
                    "href":"liquidity-management---overview.html"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Cash Concentration Methods",
                    "href":"cash-concentration-methods.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Zero Balance",
                            "href":"zero-balance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Fixed Sweep",
                            "href":"fixed-sweep.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Target Balance/Minimum Balance",
                            "href":"target-balanceminimum-balance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Threshold",
                            "href":"threshold.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Collor",
                            "href":"collor.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Percentage",
                            "href":"percentage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Range Based Balancing",
                            "href":"range-based-balancing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Investment Sweeps",
                            "href":"investment-sweeps.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Cover Overdrafts",
                            "href":"cover-overdrafts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> Additional Sweep Parameters",
                            "href":"additional-sweep-parameters.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Notional Pooling",
                    "href":"notional-pooling.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Benefits of Notional Pooling",
                            "href":"benefits-notional-pooling.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Notional Pooling Structures",
                            "href":"notional-pooling-structures.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Interest Calculation Methods",
                            "href":"interest-calculation-methods.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.3.1 </span> Interest Method",
                                    "href":"interest-method.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.2 </span> Advantage Method",
                                    "href":"advantage-method.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.3 </span> Ratio Method",
                                    "href":"ratio-method.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Interest Allocation Methods",
                            "href":"interest-allocation-methods.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Interest Optimization",
                            "href":"interest-optimization.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.5.1 </span> Create Interest Optimization",
                                    "href":"create-interest-optimization.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.2 </span> Interest Optimization Closure",
                                    "href":"io-structure-closure.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Multi Bank Cash Concentration",
                    "href":"multi-bank-cash-concentration.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Benefits of MBCC",
                            "href":"benefits-mbcc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Features in MBCC",
                            "href":"features-mbcc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Sweep Mechanism",
                            "href":"sweep-mechanism.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> MBCC System Setup",
                            "href":"mbcc-system-setup.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Maintenance for Liquidity Management",
                    "href":"maintenance-liquidity-management.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Account Group",
                            "href":"account-group.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1.1 </span> Create Interest Account Group",
                                    "href":"create-interest-account-group1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.1.2 </span> View Interest Account Group",
                                    "href":"view-interest-account-group1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Account Parameters",
                            "href":"account-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.2.1 </span> Create Account Parameters",
                                    "href":"create-account-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.2 </span> View Account Parameters",
                                    "href":"view-account-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Account Special Rate",
                            "href":"account-special-rate.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Create Account Special Rate",
                                    "href":"create-account-special-rate1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.2 </span> View Account Special Rate",
                                    "href":"view-account-special-rate1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Application Parameters",
                            "href":"application-parameters.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Bank Parameters",
                            "href":"bank-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.5.1 </span> Create Bank Parameters",
                                    "href":"create-bank-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.5.2 </span> View Bank Parameters",
                                    "href":"view-bank-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Country Parameters",
                            "href":"country-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.6.1 </span> Create Country Parameters",
                                    "href":"create-country-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.6.2 </span> View Country Parameters",
                                    "href":"view-country-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> Branch Parameters",
                            "href":"branch-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.7.1 </span> Create Branch Parameters",
                                    "href":"create-branch-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.7.2 </span> View Branch Parameters",
                                    "href":"view-branch-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Currency Parameters",
                            "href":"currency-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.8.1 </span> Create Currency Parameters",
                                    "href":"create-currency-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.8.2 </span> View Currency Parameters",
                                    "href":"view-currency-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.9 </span> Customer Parameters",
                            "href":"customer-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.9.1 </span> Create Customer Parameters",
                                    "href":"create-customer-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.9.2 </span> View Customer Parameters",
                                    "href":"view-customer-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.10 </span> Frequency",
                            "href":"frequency.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.10.1 </span> Create Frequency",
                                    "href":"create-frequency1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.10.2 </span> View Frequency",
                                    "href":"view-frequency1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.11 </span> Interface Instruction",
                            "href":"interface-instruction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.11.1 </span> Create Interface Instruction",
                                    "href":"create-interface-instruction1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.11.2 </span> View Interface Instruction",
                                    "href":"view-interface-instruction1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.12 </span> MBCC Currency Cutoff",
                            "href":"mbcc-currency-cutoff.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.12.1 </span> Create MBCC Currency Cut Off",
                                    "href":"create-mbcc-currency-cutoff1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.12.2 </span> View MBCC Currency Cutoff",
                                    "href":"view-mbcc-currency-cutoff.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.13 </span> Payment Instruction",
                            "href":"payment-instruction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.13.1 </span> Create Payment Instruction",
                                    "href":"create-payment-instruction1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.13.2 </span> View Payment Instruction",
                                    "href":"view-payment-instruction1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.14 </span> Sweep Instruction",
                            "href":"sweep-instruction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.14.1 </span> Create Sweep Instruction",
                                    "href":"create-sweep-instruction1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.14.2 </span> View Sweep Instruction",
                                    "href":"view-sweep-instruction1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.15 </span> User Linkage",
                            "href":"user-linkage.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.15.1 </span> Create UserLinkage",
                                    "href":"create-user-linkage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.15.2 </span> View User Linkage",
                                    "href":"view-user-linkage.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.16 </span> Interest Maintenance",
                            "href":"interest-maintenances.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.17 </span> File Upload",
                            "href":"file-upload.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Structure Maintenance",
                    "href":"structure-maintenance---new-ux.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Create Account Structure",
                            "href":"create-account-structure.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Structure Details",
                                    "href":"structure-details1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Sweep Structure Maintenance",
                                    "href":"sweep-structure-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Pool Structure Maintenance",
                                    "href":"pool-structure-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.4 </span> Hybrid Structure Maintenance",
                                    "href":"hybrid-structure-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.5 </span> Link Account for Drain Pool Structure",
                                    "href":"link-account-drain-pool-structure.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.6 </span> Structure Priority",
                                    "href":"structure-priority.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.7 </span> Structure Summary",
                                    "href":"structure-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> View Account Structure",
                            "href":"view-account-structure.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Edit Account Structure",
                            "href":"edit-structure.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Structure Closure",
                            "href":"structure-closure-new-ux.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Structure Approval",
                            "href":"structure-approval1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Balance Build",
                    "href":"balance-build.html"
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Monitors and Batches",
                    "href":"monitors-batches.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Monitors",
                            "href":"monitors.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1.1 </span> Exception Monitor",
                                    "href":"exception-monitor.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.2 </span> Interest Accrual Monitor",
                                    "href":"interest-accrual-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.3 </span> Interface Monitor",
                                    "href":"interface-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.4 </span> MBCC Monitor",
                                    "href":"mbcc-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.5 </span> Message Monitor",
                                    "href":"message-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.6 </span> Pending Authorization",
                                    "href":"pending-authorization1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.7 </span> Pool Monitor",
                                    "href":"pool-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.8 </span> Reallocation Monitor",
                                    "href":"reallocation-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.9 </span> Reverse Sweep Monitor",
                                    "href":"reverse-sweep-monitor1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.10 </span> Structure Query",
                                    "href":"structure-query1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.11 </span> Sweep Monitor",
                                    "href":"sweep-monitor1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Batches",
                            "href":"batches.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.2.1 </span> Account Pair Sweep",
                                    "href":"account-pair-sweep.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.2.1.1 </span> Initiate Account Pair Sweep",
                                            "href":"initiate-account-pair-sweep1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.1.2 </span> View Account Pair Sweep",
                                            "href":"view-account-pair-sweep1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.1.3 </span> Authorize Account Pair Sweep",
                                            "href":"authorize-account-pair-sweep1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.2 </span> End of Cycle",
                                    "href":"end-cycle.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.3 </span> Manual Status Update",
                                    "href":"manual-status-update.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.2.3.1 </span> Update Status",
                                            "href":"update-status1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.3.2 </span> Authorize Status",
                                            "href":"authorize-status1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.4 </span> Pool Batch",
                                    "href":"pool-batch1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.5 </span> Structure Sweep",
                                    "href":"structure-sweep.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.1 </span> Initiate Structure Sweep",
                                            "href":"initiate-structure-sweep1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.2 </span> View Structure Sweep",
                                            "href":"view-structure-sweep1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.2.5.3 </span> Authorize Structure Sweep",
                                            "href":"authorize-structure-sweep1.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> BVT Handling",
                    "href":"bvt-handling.html"
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Withholding Tax",
                    "href":"withholding-tax.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Oracle Banking Liquidity Management Accounts with IC",
                            "href":"oracle-banking-liquidity-management-accounts-ic.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Pool Interest Method",
                            "href":"pool-interest-method.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Advantage Method",
                            "href":"advantage-method1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.3.1 </span> WHT Interest Map",
                                    "href":"wht-interest-map.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.3.1.1 </span> Create Interest Map",
                                            "href":"create-interest-map1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.3.1.2 </span> View Interest Map",
                                            "href":"view-interest-map1.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Simulation Details",
                    "href":"simulation-details---new-ux.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Create Simulation",
                            "href":"create-simulation-ds.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.1.1 </span> Simulation Details",
                                    "href":"simulation-ds-simulation-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.2 </span> Structure Details",
                                    "href":"simulation-ds-structure-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.3 </span> Link Account for Sweep Simulation Structure",
                                    "href":"link-account-sweep-simulation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.4 </span> Link Account for Pool Simulation Structure",
                                    "href":"link-account-pool-simulation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.5 </span> Link Account for Hybrid Simulation Structure",
                                    "href":"link-account-hybrid-simulation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.6 </span> Structure Summary",
                                    "href":"simulation-ds-structure-summary.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.7 </span> Simulation Summary",
                                    "href":"simulation-ds-simulation-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> View Simulation",
                            "href":"view-simulation-ds.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> Edit Simulation Structure",
                            "href":"simulation-ds-edit-simulation-structure.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.4 </span> Simulation File Upload",
                            "href":"simulation-file-upload.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Dashboards",
                    "href":"dashboards.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Banker Dashboard",
                            "href":"banker-dashboard.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> RM Dashboard",
                            "href":"rm-dashboard.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Advices",
                    "href":"advices1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Generate Advices",
                            "href":"generate-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Real Time Liquidity Management",
                    "href":"real-time-liquidity-management.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> RTL Structure Maintenance",
                            "href":"rtl-structure-maintenance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1.1 </span> Create RTL Structure",
                                    "href":"rtl-structure1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">14.1.1.1 </span> Create Structure Details",
                                            "href":"create-structure-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.1.1.2 </span> Link Account",
                                            "href":"link-account-rtl-structure1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.1.1.3 </span> Group Account",
                                            "href":"group-account.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.1.1.4 </span> Summary",
                                            "href":"summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> RTL Flow",
                            "href":"rtl-flow.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> RTL Monitor",
                            "href":"rtl-monitor1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> RTL Sublimit Monitor",
                            "href":"rtl-sublimit-monitor1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Third Party Maintenance",
                    "href":"third-party-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> Third Party Account Parameters",
                            "href":"third-party-account-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.1.1 </span> Create Third Party Account Parameters",
                                    "href":"create-third-party-account-parameters1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">15.1.1.1 </span> Request for Statement/ Balance",
                                            "href":"request-statement-balance.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">15.1.2 </span> View Third Party Account Parameters",
                                    "href":"view-third-party-account-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.1.3 </span> Error Code and Messages",
                                    "href":"error-codes-messages.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Third Party Bank Parameters",
                            "href":"third-party-bank-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.2.1 </span> Create Third Party Bank Parameters",
                                    "href":"create-third-party-bank-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.2 </span> View Third Party Bank Parameters",
                                    "href":"view-third-party-bank-parameters1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> Third Party Branch Parameters",
                            "href":"third-party-branch-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.3.1 </span> Create Third Party Branch Parameters",
                                    "href":"create-third-party-branch-parameters1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.3.2 </span> View Third Party Branch Parameters",
                                    "href":"view-third-party-branch-parameters1.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Inter Company Loans",
                    "href":"inter-company-loans.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Limit",
                            "href":"limit.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.1.1 </span> Create Limit",
                                    "href":"create-limit1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.1.2 </span> View Limit",
                                    "href":"view-limit1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Structure Creation",
                            "href":"structure-creation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.3 </span> Limit Query",
                            "href":"limit-query1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.4 </span> Loan Query",
                            "href":"loan-query1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.5 </span> Settlement",
                            "href":"settlement1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.6 </span> Interest Query",
                            "href":"interest-query1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Charges",
                    "href":"charges.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Charge Code",
                            "href":"charge-code.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.1.1 </span> Create Charge Code",
                                    "href":"create-charge-code1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.1.2 </span> View Charge Code",
                                    "href":"view-charge-code1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17.2 </span> Charge Rule",
                            "href":"charge-rule.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.2.1 </span> Create Charge Rule",
                                    "href":"create-charge-rule1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">17.2.1.1 </span> Examples for Tier Based Amount",
                                            "href":"examples-tier-based-amount.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">17.2.2 </span> View Charge Rule",
                                    "href":"view-charge-rule1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17.3 </span> Pricing Schemes",
                            "href":"pricing-schemes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.3.1 </span> Create Pricing Schemes",
                                    "href":"create-pricing-schemes1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.3.2 </span> View Pricing Schemes",
                                    "href":"view-pricing-schemes1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17.4 </span> Charge Decisioning",
                            "href":"charge-decisioning.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.4.1 </span> Create Charge Decisioning",
                                    "href":"create-charge-decisioning1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.4.2 </span> View Charge Decisioning",
                                    "href":"view-charge-decisioning1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17.5 </span> Charge Preferential Pricing",
                            "href":"charge-preferential-pricing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.5.1 </span> Create Charge Preferential Pricing",
                                    "href":"create-charge-preferential-pricing1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.5.2 </span> View Charge Preferential Pricing",
                                    "href":"view-charge-preferential-pricing1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">17.6 </span> Charge Inquiry",
                            "href":"charge-inquiry1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Functional Activity Codes",
                    "href":"functional-activity-codes.html"
                },
                {
                    "title":"<span class=\"secnum\">B </span> IC Formulae",
                    "href":"ic-formulae.html"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});