define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"audience_7.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"documentation-accessibility-1.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"critical-patches.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"conventions.html"
                        },
                        {
                            "title":"Related Resources",
                            "href":"related-resources.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"screenshot-disclaimer.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"acronyms-and-abbreviations.html"
                        },
                        {
                            "title":"Basic Actions",
                            "href":"basic-actions.html"
                        },
                        {
                            "title":"Symbols, Definitions and Abbreviations",
                            "href":"symbols-and-icons.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Cross Border Overview",
                    "href":"cross-border-overview.html"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Cross Border Maintenances",
                    "href":"cross-border-maintenances.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Correspondents Maintenances",
                            "href":"correspondents-maintenances.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1.1 </span> Currency Correspondent",
                                    "href":"currency-correspondent.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.1.1.1 </span> Viewing Currency Correspondent Summary",
                                            "href":"viewing-currency-correspondent-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.2 </span> Currency Correspondent Rules",
                                    "href":"currency-correspondent-rules.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.1.2.1 </span> Currency Correspondent Rules Summary",
                                            "href":"viewing-currency-correspondent-rules-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.3 </span> External Correspondent",
                                    "href":"external-correspondent.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.1.3.1 </span> External Correspondent Summary",
                                            "href":"external-correspondent-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.4 </span> Global Correspondent",
                                    "href":"global-correspondent.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.1.4.1 </span> Global Correspondent Summary",
                                            "href":"viewing-global-correspondent-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Sender Receiver Agreement",
                            "href":"sender-receiver-agreement.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.2.1 </span> Maintaining Sender Receiver Agreement",
                                    "href":"maintaining-sender-receiver-agreement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.2.1.1 </span> Sender-Receiver Agreement Summary",
                                            "href":"viewing-sender-receiver-agreement-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Special Instructions",
                            "href":"special-instructions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.3.1 </span> Maintaining Special Instructions",
                                    "href":"maintaining-special-instructions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.3.1.1 </span> Special Instructions Summary",
                                            "href":"viewing-special-instructions-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Cover Preferences",
                            "href":"cover-preferences.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.4.1 </span> Cover Suppression Rule",
                                    "href":"cover-suppression-rule.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.4.1.1 </span> Cover Suppression Summary",
                                            "href":"viewing-cover-suppression-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.4.2 </span> Cover Match Preferences",
                                    "href":"cover-match-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.4.2.1 </span> Cover Match Preferences Summary",
                                            "href":"cover-match-preferences-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Message Enrichment",
                            "href":"message-enrichment.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.5.1 </span> D to A Converter",
                                    "href":"d-converter.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.5.1.1 </span> D to A Converter Summary",
                                            "href":"viewing-d-converter-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Queue Rule",
                            "href":"queue-rule.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.6.1 </span> Cover Queue Rule",
                                    "href":"cover-queue-rule.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.6.1.1 </span> Cover Queue Rule Summary",
                                            "href":"cover-queue-rule-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6.2 </span> Message Queue Derivation Rule",
                                    "href":"message-queue-derivation-rule.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.6.2.1 </span> Message Queue Derivation Rule Summary",
                                            "href":"message-queue-derivation-rule-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6.3 </span> Clearing Code",
                                    "href":"clearing-code.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.6.3.1 </span> Clearing Code Summary",
                                            "href":"viewing-clearing-code-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Reconciliation External Accounts",
                            "href":"reconciliation-external-accounts1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.7.1 </span> Reconciliation External Accounts",
                                    "href":"reconciliation-external-accounts.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.7.1.1 </span> Reconciliation External Accounts Summary",
                                            "href":"reconciliation-external-accounts-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> RMA /RMA +",
                            "href":"rma-rma.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.8.1 </span> RMA or RMA Plus Details",
                                    "href":"rma-or-rma-plus-details.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.8.1.1 </span> RMA/RMA+ Validation (MT)",
                                            "href":"rma-rma-validation-mt.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">2.8.1.2 </span> RMA/RMA+ Validation (SWIFT CBPRPlus)",
                                            "href":"rma-rma-validation-swift-cbprplus.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">2.8.1.3 </span> RMA or RMA Plus Details Summary",
                                            "href":"viewing-rma-or-rma-plus-details-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Alpha Code",
                            "href":"alpha-code.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.9.1 </span> Alpha Code Summary",
                                    "href":"alpha-code-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> Template",
                            "href":"template.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.10.1 </span> Outbound Cross Border Payments Template Transaction",
                                    "href":"outbound-cross-border-payments-template-transaction.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.10.1.1 </span> Template Summary",
                                            "href":"template-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.10.2 </span> Amendable Fields of a Template",
                                    "href":"amendable-fields-template.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.11 </span> Standing Instruction",
                            "href":"standing-instruction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.11.1 </span> Standing Instruction Template",
                                    "href":"standing-instruction-template.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.11.1.1 </span> Standing Instruction Template Summary",
                                            "href":"standing-instruction-template-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.12 </span> SWIFT Pricing",
                            "href":"swift-pricing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.12.1 </span> SWIFT Pricing Preferences",
                                    "href":"swift-pricing-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.12.1.1 </span> Charge Processing for Cross Border/ RTGS transactions",
                                            "href":"charge-processing-cross-border-rtgs-transactions.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">2.12.1.2 </span> SWIFT Pricing Preferences Summary",
                                            "href":"swift-pricing-preferences-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.13 </span> Hold Suppress Release Rule",
                            "href":"hold-suppress-release-rule.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.13.1 </span> Hold Suppress Release Rule Definition",
                                    "href":"hold-suppress-release-rule-definition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.13.2 </span> Message Hold Suppress Release Rule Preferences",
                                    "href":"message-hold-suppress-release-rule-preferences.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.13.3 </span> Hold Suppress Release Restriction Preferences",
                                    "href":"hold-suppress-release-restriction-preferences.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.14 </span> Reverse Message Agreement",
                            "href":"reverse-message-agreement.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.14.1 </span> Reverse Message Agreement Maintenance",
                                    "href":"reverse-message-agreement-maintenance.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.14.1.1 </span> Reverse Message Agreement Summary",
                                            "href":"viewing-reverse-message-agreement-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.15 </span> Chinese Currency Conversion Preferences",
                            "href":"cnh-payments.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.15.1 </span> CNH Conversion",
                                    "href":"cnh-conversion.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.15.2 </span> CNH Conversion Summary",
                                    "href":"viewing-cnh-conversion-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.16 </span> SWIFT SRG Effective Date Maintenance",
                            "href":"swift-srg-effective-date-maintenance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.16.1 </span> SWIFT SRG Effective Date Summary",
                                    "href":"swift-srg-effective-date-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.17 </span> SWIFT n99 Pricing",
                            "href":"swift-n99-pricing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.17.1 </span> SWIFT n99 Pricing Preference",
                                    "href":"swift-n99-pricing-preference.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.17.1.1 </span> SWIFT n99 Pricing Preferences Summary",
                                            "href":"swift-n99-pricing-preferences-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.18 </span> Customer Account Address",
                            "href":"customer-account-address.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.18.1 </span> Customer Account Address Maintenance in 50F Format",
                                    "href":"customer-account-address-maintenance-50f-format.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.18.1.1 </span> Customer Account Address Maintenance in 50F Format Summary",
                                            "href":"customer-account-address-maintenance-50f-format-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.18.2 </span> Customer Address Maintenance in 50F Format",
                                    "href":"customer-address-maintenance-50f-format.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.18.2.1 </span> Customer Address Maintenance in 50F Format Summary",
                                            "href":"customer-address-maintenance-50f-format-summary.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Cross Border Outbound Transactions",
                    "href":"cross-border-outbound-transactions.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Outbound Transaction Input",
                            "href":"outbound-transaction-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1.1 </span> Outbound Cross Border Payments Transaction Input",
                                    "href":"outbound-cross-border-payments-transaction-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.1 </span> Main Tab",
                                            "href":"outbound-cross-border-payments-transaction-input_main-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.2 </span> Pricing Tab",
                                            "href":"pricing-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.3 </span> Additional Details",
                                            "href":"outbound-cross-border-payments-transaction-input_additional-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.4 </span> Sequence B - Cover Details",
                                            "href":"outbound-cross-border-payments-transaction-input_sequence-b-cover-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.5 </span> UDF Button",
                                            "href":"udf-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.6 </span> MIS Button",
                                            "href":"mis-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.7 </span> Messaging and Accounting Entries",
                                            "href":"messaging-and-accounting-entries1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.8 </span> Accounting Entries",
                                            "href":"accounting-entries_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.9 </span> View Change Log",
                                            "href":"view-change-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.10 </span> Payment Chain",
                                            "href":"payment-chain1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.11 </span> Transaction Authorization",
                                            "href":"transaction-authorization.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.12 </span> Cross Border Outbound Transaction Summary",
                                            "href":"viewing-cross-border-outbound-transaction-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.2 </span> Outbound Cross Border Payments View",
                                    "href":"outbound-cross-border-payments-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.1 </span> Additional Details Tab",
                                            "href":"outbound-cross-border-payments-view_additional-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.2 </span> Sequence B - Cover Details Tab",
                                            "href":"outbound-cross-border-payments-view_sequence-b-cover-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.3 </span> Accounting Entries",
                                            "href":"outbound-cross-border-payments-view_accounting-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.4 </span> All Messages",
                                            "href":"all-messages_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.5 </span> Exceptions Tab",
                                            "href":"exceptions-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.6 </span> gpi Confirmations",
                                            "href":"gpi-confirmations_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.7 </span> Recall Messages",
                                            "href":"recall-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.8 </span> View Queue Action Log",
                                            "href":"view-queue-action-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.9 </span> UDF View Button",
                                            "href":"udf-view-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.10 </span> MIS View Button",
                                            "href":"mis-view-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.11 </span> View Repair Log",
                                            "href":"view-repair-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.12 </span> Document",
                                            "href":"document.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.13 </span> Compliance Questions",
                                            "href":"compliance-questions.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.14 </span> Payment Chain",
                                            "href":"payment-chain.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.15 </span> Chinese Codeword Changes",
                                            "href":"chinese-codeword-changes.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.16 </span> Outbound Transaction View Summary",
                                            "href":"outbound-transaction-view-summary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.2.17 </span> Outbound Cross Border Cancellation Request",
                                            "href":"outbound-cross-border-cancellation-request.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.3 </span> Outbound Multi Credit Transfer Consol Summary",
                                    "href":"outbound-multi-credit-transfer-consol-summary.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.1.3.1 </span> Consol Close/ Cancel/ Approve",
                                            "href":"consol-close-cancel-approve.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.3.2 </span> Delink Consol",
                                            "href":"delink-consol.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.4 </span> Outbound Multi Credit Transfer Consol View Summary",
                                    "href":"outbound-multi-credit-transfer-consol-view-summary.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.1.4.1 </span> All Messages",
                                            "href":"all-messages_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.4.2 </span> Accounting Details",
                                            "href":"accounting-entries-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.1.4.3 </span> Invalid/Closed BIC Handling Process",
                                            "href":"invalid-closed-bic-handling-process.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Outbound Transaction Upload",
                            "href":"outbound-transaction-upload.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Outbound Transaction Processing",
                            "href":"outbound-transaction-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.3.1 </span> Bank Re-direction",
                                    "href":"bank-direction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.2 </span> Account Re-direction",
                                    "href":"account-direction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.3 </span> D to A Conversion",
                                    "href":"d-conversion.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.4 </span> Account Derivation",
                                    "href":"account-derivation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.5 </span> Ordering Customer Population",
                                    "href":"ordering-customer-population.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.6 </span> IBAN Validation",
                                    "href":"iban-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.7 </span> Cross Border to RTGS Rule Evaluation",
                                    "href":"cross-border-rtgs-rule-evaluation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.8 </span> Date Derivation",
                                    "href":"date-derivation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.9 </span> PSD Validation",
                                    "href":"psd-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.10 </span> Customer Payment Restriction Validation",
                                    "href":"customer-payment-restriction-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.11 </span> Duplicate Check",
                                    "href":"duplicate-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.12 </span> Field 72 Codeword Validation",
                                    "href":"field-72-codeword-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.13 </span> Special Instructions Validations",
                                    "href":"special-instructions-validations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.14 </span> Authorization Limit Validations",
                                    "href":"authorization-limit-validations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.15 </span> Processing Cutoff Validation",
                                    "href":"processing-cutoff-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.16 </span> EU Payer Validation",
                                    "href":"eu-payer-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.17 </span> Sanction Check Validation",
                                    "href":"sanction-check-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.18 </span> Exchange Rate/FX Processing",
                                    "href":"exchange-rate-fx-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.19 </span> Pricing",
                                    "href":"pricing1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.3.19.1 </span> Standard Price",
                                            "href":"standard-price.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.3.19.2 </span> Charge Amount Validation",
                                            "href":"charge-amount-validation.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.20 </span> External Credit Approval Processing",
                                    "href":"external-credit-approval-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.21 </span> Network Cuttoff Check",
                                    "href":"network-cuttoff-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.22 </span> Accounting",
                                    "href":"accounting.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.23 </span> Messaging",
                                    "href":"messaging.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.24 </span> MIS & UDF",
                                    "href":"mis-udf.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.25 </span> Transaction Cancellation Processing",
                                    "href":"transaction-cancellation-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.26 </span> Future Date Transaction Processing",
                                    "href":"future-date-transaction-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.3.27 </span> Cover via RTGS Network",
                                    "href":"cover-rtgs-network.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Cross Border Inbound Transaction",
                    "href":"cross-border-inbound-transaction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Inbound Transaction Input",
                            "href":"inbound-transaction-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1.1 </span> Inbound Cross Border Payments Transaction Input",
                                    "href":"inbound-cross-border-payments-transaction-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.1 </span> Main Tab",
                                            "href":"inbound-cross-border-payments-transaction-input_main-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.2 </span> Pricing Tab",
                                            "href":"pricing-tab-2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.3 </span> Additional Details Button",
                                            "href":"inbound-cross-border-payments-transaction-input_additional-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.4 </span> Sequence B - Cover Details Tab",
                                            "href":"inbound-cross-border-payments-transaction-input_sequence-b-cover-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.5 </span> UDF Button",
                                            "href":"udf-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.6 </span> MIS Button",
                                            "href":"mis-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.7 </span> Sanction Scanning of Cover Messages",
                                            "href":"sanction-scanning-cover-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.1.8 </span> Inbound Transaction Summary",
                                            "href":"viewing-inbound-transaction-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.1.2 </span> Inbound Cross Border Payments View",
                                    "href":"inbound-cross-border-payments-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.1 </span> Additional Details Button",
                                            "href":"inbound-cross-border-payments-view_additional-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.2 </span> Sequence B - Cover Details Tab",
                                            "href":"inbound-cross-border-payments-view_sequence-b-cover-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.3 </span> Accounting Entries",
                                            "href":"inbound-cross-border-payments-view_accounting-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.4 </span> All Messages",
                                            "href":"all-messages_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.5 </span> Exceptions Tab",
                                            "href":"inbound-cross-border-payments-view_exception-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.6 </span> gpi Confirmations",
                                            "href":"gpi-confirmations_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.7 </span> Recall Messages",
                                            "href":"recall-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.8 </span> View Queue Action Log",
                                            "href":"view-queue-action-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.9 </span> UDF View Button",
                                            "href":"udf-view-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.10 </span> MIS View Button",
                                            "href":"mis-view-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.11 </span> View Repair Log",
                                            "href":"view-repair-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.12 </span> Inbound MT 103/ MT 202 Processing",
                                            "href":"inbound-mt-103-mt-202-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.13 </span> Inbound Cross Border Payments View Summary",
                                            "href":"inbound-cross-border-payments-view-summary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.1.2.14 </span> Credit Account Branch Based Routing Processing",
                                            "href":"credit-account-branch-based-routing-processing.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.1.3 </span> Inbound Multi Credit Consol View Summary",
                                    "href":"inbound-multi-credit-consol-view-summary.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.1.3.1 </span> Accounting Entries",
                                            "href":"inbound-multi-credit-consol-view-summary_accounting-entries.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Inbound Transaction Upload",
                            "href":"inbound-transaction-upload.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Inbound Transaction Processing",
                            "href":"inbound-transaction-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.3.1 </span> Bank Re-direction",
                                    "href":"bank-direction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.2 </span> Account Re-direction",
                                    "href":"account-direction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.3 </span> D to A Conversion",
                                    "href":"d-conversion.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.4 </span> Account Derivation",
                                    "href":"account-derivation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.5 </span> PSD Validation",
                                    "href":"psd-validation_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.6 </span> Network Cutoff Validation",
                                    "href":"network-cutoff-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.7 </span> Beneficiary Name Validations",
                                    "href":"beneficiary-name-validations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.8 </span> Customer Payment Restriction Validation",
                                    "href":"customer-payment-restriction-validation_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.9 </span> EU Payer Validation",
                                    "href":"eu-payer-validation_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.10 </span> Sanction Check Validation",
                                    "href":"sanction-check-validation_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.11 </span> Duplicate Check",
                                    "href":"duplicate-check_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.12 </span> Authorization Limit Validations",
                                    "href":"authorization-limit-validations_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.13 </span> External Account Check Processing",
                                    "href":"external-account-check-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.14 </span> Exchange Rate/FX Processing",
                                    "href":"exchange-rate-fx-processing_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.15 </span> Pricing",
                                    "href":"pricing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.16 </span> Accounting",
                                    "href":"accounting.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.17 </span> MIS & UDF",
                                    "href":"mis-udf.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.18 </span> Transaction Cancellation Processing",
                                    "href":"transaction-cancellation-processing_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.19 </span> Future Date Transaction Processing",
                                    "href":"future-date-transaction-processing_2.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Straight-Through Processing",
                    "href":"straight-processing.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> STP of Inbound Messages",
                            "href":"stp-inbound-messages.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1.1 </span> Debit Account Resolution",
                                    "href":"debit-account-resolution.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.1.2 </span> MT202 Unmatched Queue Validation",
                                    "href":"mt202-unmatched-queue-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.1.3 </span> External Validations for Advisory Messages",
                                    "href":"external-validations-advisory-messages.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Cover Matching",
                            "href":"cover-matching.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.2.1 </span> Cover Matching of incoming MT 103/MT 202",
                                    "href":"cover-matching-incoming-mt-103-mt-202.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.2 </span> Incoming Swift Payment View",
                                    "href":"incoming-swift-payment-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.2.2.1 </span> Additional Details",
                                            "href":"incoming-swift-payment-view-_additional-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.2.2.2 </span> Sequence B - Cover Details Tab",
                                            "href":"incoming-swift-payment-view_sequence-b-cover-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.2.2.3 </span> gpi Confirmations",
                                            "href":"gpi-confirmations_4.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.2.2.4 </span> View Queue Action Log",
                                            "href":"view-queue-action-log.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.2.2.5 </span> Incoming Swift Payment View Summary",
                                            "href":"incoming-swift-payment-view-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.3 </span> Statement Browser",
                                    "href":"statement-browser.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.2.3.1 </span> Statement Browser Summary",
                                            "href":"viewing-statement-browser-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.4 </span> Transaction Type Resolution",
                                    "href":"transaction-type-resolution.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> MT Messages Processing",
                            "href":"mt-messages-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Processing of MT 200",
                                    "href":"processing-mt-200.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.2 </span> Processing of MT 203",
                                    "href":"processing-mt-203.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.3 </span> Processing of MT 204",
                                    "href":"processing-mt-204.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.4 </span> Processing of MT 205",
                                    "href":"processing-mt-205.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.5 </span> Processing of MT 210",
                                    "href":"processing-mt-210.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.6 </span> Sanctions scanning of Inbound Messages (MT 900, MT 210)",
                                    "href":"sanctions-scanning-inbound-messages-mt-900-mt-210.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Common Group Messages",
                    "href":"common-group-messages.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Outbound Manual Input Screens",
                            "href":"outbound-manual-input-screens.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Advice of Charges",
                                    "href":"advice-charges.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.1.1 </span> Advice of Charges Summary",
                                            "href":"viewing-advice-charges-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Request for Payment of Charges",
                                    "href":"request-payment-charges.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.2.1 </span> Request for Payment of Charges Summary",
                                            "href":"viewing-request-payment-charges-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Request for Cancellation",
                                    "href":"request-cancellation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.3.1 </span> View Message",
                                            "href":"view-outgoing-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.3.2 </span> Request for Cancellation Summary",
                                            "href":"viewing-request-cancellation-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.4 </span> Queries",
                                    "href":"queries.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.4.1 </span> View Message",
                                            "href":"view-outgoing-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.4.2 </span> Queries Summary",
                                            "href":"viewing-queries-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.5 </span> Answers",
                                    "href":"answers.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.5.1 </span> View Message",
                                            "href":"view-outgoing-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.5.2 </span> Answers Summary",
                                            "href":"viewing-answers-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.6 </span> Proprietary Message",
                                    "href":"proprietary-message.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.6.1 </span> Proprietary Message Summary",
                                            "href":"viewing-proprietary-message-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.7 </span> Free Format Message",
                                    "href":"free-format-message.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.1 </span> Main Tab",
                                            "href":"free-format-message_main-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.2 </span> Pricing Tab",
                                            "href":"free-format-message_pricing-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.3 </span> Accounting Entries",
                                            "href":"free-format-message_accounting-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.4 </span> MIS Tab",
                                            "href":"free-format-message_mis-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.5 </span> View Message",
                                            "href":"view-outgoing-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.6 </span> MT n99 Generation Processing Changes",
                                            "href":"mt-n99-generation-processing-changes.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.7 </span> Free Format Message – Values Population Logic",
                                            "href":"free-format-message-values-population-logic.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.8 </span> Charges on Free Format Messages",
                                            "href":"charges-free-format-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.7.9 </span> Free Format Message Summary",
                                            "href":"viewing-free-format-message-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Outbound Auto-generation",
                            "href":"outbound-auto-generation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.2.1 </span> Queries",
                                    "href":"queries1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Outbound Common Group Messages - Processing",
                            "href":"outbound-common-group-messages-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.3.1 </span> Network Character Validation for Outbound Common Group",
                                    "href":"network-character-validation-outbound-common-group.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.3.2 </span> Sanction Scanning of Outbound Common Group Messages",
                                    "href":"sanction-scanning-outbound-common-group-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.3.3 </span> UETR population in Outbound Common Core Messages",
                                    "href":"uetr-population-outbound-common-core-messages.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Inbound Common Group Messages",
                            "href":"inbound-common-group-messages.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.4.1 </span> Sanction Scanning of Inbound Common Group Messages",
                                    "href":"sanction-scanning-inbound-common-group-messages.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Cross Border Cancellation",
                    "href":"cross-border-cancellation.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Inbound Cross Border Cancellation",
                            "href":"inbound-cross-border-cancellation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1.1 </span> Inbound Cross Border Cancellation Request",
                                    "href":"inbound-cross-border-cancellation-request.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.1.2 </span> Inbound Cross Border Cancellation Request Summary",
                                    "href":"inbound-cross-border-cancellation-request-summary.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Outbound Cancellation Processing",
                            "href":"outbound-cancellation-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.2.1 </span> Outbound Cancellation Request Processing",
                                    "href":"outbound-cancellation-request-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">7.2.1.1 </span> Cancellation Job",
                                            "href":"cancellation-job.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">7.2.1.2 </span> Non- Dispatched/ Unprocessed Payments",
                                            "href":"non-dispatched-unprocessed-payments.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2.2 </span> Outbound - Cancellation via Service",
                                    "href":"outbound-cancellation-service.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Inbound Cancellation Processing",
                            "href":"inbound-cancellation-processing.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Cross Border Reversal",
                    "href":"cross-border-reversal.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Cross Border Reversal Transaction",
                            "href":"cross-border-reversal-transaction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1.1 </span> Cross Border Transaction Reversal Input",
                                    "href":"cross-border-transaction-reversal-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.1.1.1 </span> Cross Border Transaction Reversal Summary",
                                            "href":"cross-border-transaction-reversal-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Cross Border Reversal Processing",
                            "href":"cross-border-reversal-processing.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Cross Border Return",
                    "href":"cross-border-return.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Cross Border Outbound Return Processing",
                            "href":"cross-border-outbound-return-processing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Cross Border Inbound Return Processing",
                            "href":"cross-border-inbound-return-processing.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> SWIFT gpi",
                    "href":"swift-gpi.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> gpi Maintenances",
                            "href":"gpi-maintenances.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1.1 </span> SWIFT gpi Static Preferences",
                                    "href":"swift-gpi-static-preferences.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.2 </span> Outbound gpi Payment Receiver Agreement",
                                    "href":"outbound-gpi-payment-receiver-agreement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.2.1 </span> Outbound gpi Payment Receiver Agreement Summary",
                                            "href":"outbound-gpi-payment-receiver-agreement-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.3 </span> Inbound gpi Payment Sender Agreement",
                                    "href":"inbound-gpi-payment-sender-agreement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.1 </span> Inbound gpi Payment Sender Agreement Summary",
                                            "href":"inbound-gpi-payment-sender-agreement-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.4 </span> SWIFT gpi Host Preferences",
                                    "href":"swift-gpi-host-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.4.1 </span> SWIFT gpi Host Preferences Summary",
                                            "href":"swift-gpi-host-preferences-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.5 </span> SWIFT gpi Directory",
                                    "href":"swift-gpi-directory.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.5.1 </span> SWIFT gpi Directory Summary",
                                            "href":"viewing-swift-gpi-directory-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.6 </span> Flat File gpi Directory Upload",
                                    "href":"flat-file-gpi-directory-upload.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.7 </span> SWIFT gpi Confirmation Reject Code Mapping",
                                    "href":"swift-gpi-confirmation-reject-code-mapping.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.7.1 </span> SWIFT gpi Confirmation Reject Code Mapping Summary",
                                            "href":"swift-gpi-confirmation-reject-code-mapping-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.8 </span> SWIFT gpi/Universal Confirmation - Manual Generation",
                                    "href":"swift-gpi-universal-confirmation-manual-generation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.8.1 </span> SWIFT gpi/Universal Confirmation - Manual Generation Summary",
                                            "href":"swift-gpi-universal-confirmation-manual-generation-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> gCCT Transaction Processing",
                            "href":"gcct-transaction-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.2.1 </span> Outbound gCCT Processing",
                                    "href":"outbound-gcct-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.2.2 </span> Inbound gCCT processing",
                                    "href":"inbound-gcct-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> gCOV Transaction Processing",
                            "href":"gcov-transaction-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.3.1 </span> Outbound gCOV processing (Debtor/ Instructing Agent)",
                                    "href":"outbound-gcov-processing-debtor-instructing-agent.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.3.2 </span> Inbound gCOV Processing",
                                    "href":"inbound-gcov-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> gCCT Confirmations - MT 199",
                            "href":"gcct-confirmations-mt-199.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.4.1 </span> Outbound gCCT Confirmations - MT 199 Generation",
                                    "href":"outbound-gcct-confirmations-mt-199-generation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.4.1.1 </span> Reject Confirmation - Reason code population",
                                            "href":"reject-confirmation-reason-code-population.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4.2 </span> Inbound gCCT Confirmations - MT 199 Message Processing",
                                    "href":"inbound-gcct-confirmations-mt-199-message-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.4.2.1 </span> Inbound gpi Confirmations Summary",
                                            "href":"inbound-gpi-confirmations-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4.3 </span> Auto Confirmation Message Generation Processing",
                                    "href":"auto-confirmation-message-generation-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4.4 </span> Manual Confirmation Message Generation Processing",
                                    "href":"manual-confirmation-message-generation-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> gCOV Confirmations - MT 299",
                            "href":"gcov-confirmations-mt-299.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.5.1 </span> Outbound gCOV Confirmations - MT 299 Message Generation",
                                    "href":"outbound-gcov-confirmations-mt-299-message-generation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.5.1.1 </span> Reject Confirmation - Reason code population",
                                            "href":"reject-confirmation-reason-code-population.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.5.2 </span> Inbound gCCT Confirmations - MT 199 Message Processing",
                                    "href":"inbound-gcct-confirmations-mt-199-message-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.5.2.1 </span> Inbound gpi Confirmations Summary",
                                            "href":"inbound-gpi-confirmations-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> Notifications",
                            "href":"notifications.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.7 </span> gSRP Cancellation Processing",
                            "href":"gsrp-cancellation-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.7.1 </span> Outbound Cancellation Request Processing",
                                    "href":"outbound-cancellation-request-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.1.1 </span> Dispatched/ Processed Payments",
                                            "href":"dispatched-processed-payments.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.1.2 </span> MT n92 / gSRP Request Message Generation",
                                            "href":"mt-n92-gsrp-request-message-generation.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.2 </span> Outbound Cancellation Response Processing",
                                    "href":"outbound-cancellation-response-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.2.1 </span> gSRP Response Message Processing",
                                            "href":"gsrp-response-message-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.2.2 </span> Tracker gSRP Status Notification & gSRP Alerts",
                                            "href":"tracker-gsrp-status-notification-gsrp-alerts.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.2.3 </span> MT n96 Response Processing",
                                            "href":"mt-n96-response-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.2.4 </span> Recall Response Log",
                                            "href":"recall-response-log.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.3 </span> Inbound Cancellation Request Processing",
                                    "href":"inbound-cancellation-request-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.3.1 </span> Matching with Inbound Payments",
                                            "href":"matching-inbound-payments.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.3.2 </span> Processed Payments",
                                            "href":"processed-payments.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.3.3 </span> Unprocessed Payments",
                                            "href":"unprocessed-payments.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.4 </span> Inbound Cancellation Request - Response Processing",
                                    "href":"inbound-cancellation-request-response-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.4.1 </span> Cancellation Response Processing",
                                            "href":"cancellation-response-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.4.2 </span> gSRP Response Message",
                                            "href":"gsrp-response-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.4.3 </span> Non-gSRP Response Message",
                                            "href":"non-gsrp-response-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.4.4 </span> Interim gSRP Response Message at EOD",
                                            "href":"interim-gsrp-response-message-eod.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.4.5 </span> Recall Response Log",
                                            "href":"recall-response-log_2.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.5 </span> Outbound Pass-through Cancellation Request Processing",
                                    "href":"outbound-pass-cancellation-request-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.5.1 </span> Unprocessed Payments",
                                            "href":"unprocessed-payments_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.5.2 </span> Processed Payments",
                                            "href":"processed-payments_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.5.3 </span> MT n92/ gSRP Request Message Generation",
                                            "href":"mt-n92-gsrp-request-message-generation_2.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.6 </span> Outbound Pass-through Cancellation Response Processing",
                                    "href":"outbound-pass-cancellation-response-processing_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.7 </span> Inbound Pass-through Cancellation Request Processing",
                                    "href":"inbound-pass-cancellation-request-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.7.1 </span> Matching with Outbound Pass-through Payments",
                                            "href":"matching-outbound-pass-payments.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.7.2 </span> Processed Payments",
                                            "href":"processed-payments_3.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.7.3 </span> Unprocessed Payments",
                                            "href":"unprocessed-payments_3.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.7.8 </span> Inbound Pass-through Cancellation Request - Response Processing",
                                    "href":"inbound-pass-cancellation-request-response-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.7.8.1 </span> Cancellation Response Processing",
                                            "href":"cancellation-response-processing_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.8.2 </span> gSRP Response Message",
                                            "href":"gsrp-response-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.8.3 </span> Non-gSRP Response Message",
                                            "href":"non-gsrp-response-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.7.8.4 </span> Interim gSRP Response Message at EOD",
                                            "href":"interim-gsrp-response-message-eod.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.8 </span> gFIT Processing",
                            "href":"gfit-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.8.1 </span> Outbound Cross Border/RTGS Transaction Processing",
                                    "href":"outbound-cross-border-rtgs-transaction-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.8.2 </span> Inbound gFIT Confirmation Message Processing",
                                    "href":"inbound-gfit-confirmation-message-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.8.3 </span> Inbound gFIT Message Processing",
                                    "href":"inbound-gfit-message-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.9 </span> SWIFT gLowValue Transactions",
                            "href":"swift-glowvalue-transactions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.9.1 </span> Outbound Cross Border gLowValue Payment Transaction Input",
                                    "href":"outbound-cross-border-glowvalue-payment-transaction-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.1 </span> Main Tab",
                                            "href":"outbound-cross-border-glowvalue-payment-transaction-input_main-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.2 </span> Pricing Tab",
                                            "href":"pricing-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.3 </span> UDF Button",
                                            "href":"udf-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.4 </span> MIS Button",
                                            "href":"outbound-cross-border-glowvalue-payment-transaction-input_mis-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.5 </span> Messaging and Accounting Entries",
                                            "href":"messaging-and-accounting-entries.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.6 </span> Payment Chain",
                                            "href":"payment-chain.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.1.7 </span> Outbound Cross Border gLowValue Payment Transaction Input Summary",
                                            "href":"outbound-cross-border-glowvalue-payment-transaction-input-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.9.2 </span> SWIFT gLowValue Payment Host Preferences",
                                    "href":"swift-glowvalue-payment-host-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.9.2.1 </span> SWIFT gLowValue Payment Host Preferences Summary",
                                            "href":"swift-glowvalue-payment-host-preferences-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.9.3 </span> Inbound Cross Border gLowValue Payment Processing",
                                    "href":"inbound-cross-border-glowvalue-payment-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.1 </span> Incoming gpi & gpi Payment Type Check",
                                            "href":"incoming-gpi-gpi-payment-type-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.2 </span> Host Level Check",
                                            "href":"host-level-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.3 </span> gpi Agent check",
                                            "href":"gpi-agent-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.4 </span> Cover Matching",
                                            "href":"cover-matching_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.5 </span> Network Cuttoff Check",
                                            "href":"network-cuttoff-check_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.6 </span> Pricing",
                                            "href":"pricing_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.3.7 </span> Generate gLowValue Payment confirmations",
                                            "href":"generate-glowvalue-payment-confirmations.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.9.4 </span> Outbound Pass Through gLowValue Payment Processing",
                                    "href":"outbound-pass-glowvalue-payment-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.1 </span> Incoming gpi & gpi Payment Type Check",
                                            "href":"incoming-gpi-gpi-payment-type-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.2 </span> Host Level Check",
                                            "href":"host-level-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.3 </span> gpi Agent check",
                                            "href":"gpi-agent-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.4 </span> Payment Chain Lookup",
                                            "href":"payment-chain-lookup.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.5 </span> Network Cuttoff Check",
                                            "href":"network-cuttoff-check_3.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.6 </span> Pricing",
                                            "href":"pricing_3.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.7 </span> Field 71F",
                                            "href":"field-71f.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.8 </span> Generate gLowValue Payment confirmations",
                                            "href":"generate-glowvalue-payment-confirmations_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.9 </span> Field 23B, 23E",
                                            "href":"field-23b-23.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.9.4.10 </span> Field 52A, 57A, 72",
                                            "href":"field-52a-57a-72.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.10 </span> SWIFT gpi Tracker API services",
                            "href":"swift-gpi-tracker-api-services.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.11 </span> SWIFT gpi Status Reading via API",
                            "href":"swift-gpi-status-reading-api.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.11.1 </span> SWIFT gpi Status Reading via API",
                                    "href":"swift-gpi-status-reading-api_2.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.11.1.1 </span> SWIFT gpi Status Reading via API Summary",
                                            "href":"swift-gpi-status-reading-api-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.11.2 </span> SWIFT gpi API Tracker Status Browser",
                                    "href":"swift-gpi-api-tracker-status-browser.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.11.2.1 </span> View Message",
                                            "href":"view-message_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.11.2.2 </span> View Response",
                                            "href":"view-response.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.11.2.3 </span> Ad-hoc Request",
                                            "href":"ad-hoc-request.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.12 </span> gpi Tracker Enquiry by UETR",
                            "href":"gpi-tracker-enquiry-uetr.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.12.1 </span> gpi Tracker Enquiry by UETR",
                                    "href":"gpi-tracker-enquiry-uetr_2.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.12.1.1 </span> Transaction Type Processing",
                                            "href":"transaction-type-processing.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Charge Claim",
                    "href":"charge-claim.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Maintenances",
                            "href":"maintenances.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.1.1 </span> Charge Claim Default Preferences",
                                    "href":"charge-claim-default-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.1.1 </span> Charge Claim Default Preferences Summary",
                                            "href":"charge-claim-default-preferences-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.2 </span> Inbound Claim Preferences",
                                    "href":"inbound-claim-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.2.1 </span> Inbound Claim Preferences Summary",
                                            "href":"inbound-claim-preferences-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.3 </span> Outbound Claim Preferences",
                                    "href":"outbound-claim-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.3.1 </span> Outbound Claim Preferences Summary",
                                            "href":"outbound-claim-preferences-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.4 </span> Customer Preferences Detailed",
                                    "href":"customer-preferences-detailed.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.5 </span> Narrative Maintenance",
                                    "href":"narrative-maintenance.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.5.1 </span> Narrative Summary",
                                            "href":"narrative-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.6 </span> Charge Claim Advice Format Preference",
                                    "href":"charge-claim-advice-format-preference.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.6.1 </span> Charge Claim Advice Format Preference Summary",
                                            "href":"charge-claim-advice-format-preference-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.7 </span> Customer Charge Claim Advice Preferences",
                                    "href":"customer-charge-claim-advice-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.1.7.1 </span> Customer Charge Claim Advice Preferences Summary",
                                            "href":"customer-charge-claim-advice-preferences-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Outbound Charge Claim Processing",
                            "href":"outbound-charge-claim-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.2.1 </span> Outbound Charge Claim Processing",
                                    "href":"outbound-charge-claim-processing_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.2 </span> Outbound Charge Claim Queue",
                                    "href":"outbound-charge-claim-queue.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.3 </span> Outbound Charge Claim View",
                                    "href":"outbound-charge-claim-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.1 </span> Out Claim Accounting",
                                            "href":"claim-accounting.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.2 </span> Charge Claim Out Details Summary",
                                            "href":"charge-claim-details-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.4 </span> Charge Claim Based on Statement Entries",
                                    "href":"charge-claim-based-mt-940-mt-950.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.5 </span> Duplicate Claim Settlement Check",
                                    "href":"duplicate-claim-settlement-check.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.5.1 </span> Inbound MT910 Credit Confirmation Claim Settlement",
                                            "href":"inbound-mt910-credit-confirmation-claim-settlement.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.5.2 </span> Inbound Statement Entry for Claim Settlement",
                                            "href":"inbound-statement-entry-claim-settlement.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.5.3 </span> Inbound MT202 Bank Transfer as Claim Settlement",
                                            "href":"inbound-mt202-bank-transfer-claim-settlement.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.6 </span> Mail Advice for Charge Claim Liquidation",
                                    "href":"mail-advice-charge-claim-liquidation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> Inbound Charge Claim Processing",
                            "href":"inbound-charge-claim-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.3.1 </span> Duplicate Check",
                                    "href":"duplicate-check_inbound-charge-claim-processing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.3.2 </span> Inbound Charge Claim Processing",
                                    "href":"inbound-charge-claim-processing_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.3.3 </span> Inbound Charge Claim Queue",
                                    "href":"inbound-charge-claim-queue.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.3.4 </span> Inbound Claim View",
                                    "href":"inbound-claim-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.3.4.1 </span> Inbound Claim View Summary",
                                            "href":"viewing-inbound-claim-view-summary.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> MT 101 Processing",
                    "href":"mt-101-processing.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> MT101 Maintenances",
                            "href":"mt101-maintenances.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.1.1 </span> MT 101 Parameters",
                                    "href":"mt-101-parameters.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.1.1 </span> MT 101 Parameters Summary",
                                            "href":"viewing-mt-101-parameters-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.2 </span> External Customer Account List",
                                    "href":"external-customer-account-list-detailed.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.2.1 </span> External Customer Account List Summary",
                                            "href":"external-customer-account-list-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.3 </span> MT 101 Customer Identification",
                                    "href":"mt-101-customer-identification.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.3.1 </span> MT 101 Customer Identification Summary",
                                            "href":"mt-101-customer-identification-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.4 </span> MT 101 Inbound Agreement",
                                    "href":"mt-101-inbound-agreement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.4.1 </span> MT 101 Inbound Agreement Summary",
                                            "href":"mt-101-inbound-agreement-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.5 </span> MT101 Outbound Agreement",
                                    "href":"mt101-outbound-agreement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.5.1 </span> MT 101 Outbound Agreement Summary",
                                            "href":"mt-101-outbound-agreement-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.6 </span> MT 101 Outbound Pricing Preference",
                                    "href":"mt-101-outbound-pricing-preference.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.6.1 </span> MT 101 Outbound Pricing Preference Summary",
                                            "href":"mt-101-outbound-pricing-preference-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> MT101 Inbound Transactions",
                            "href":"mt101-inbound-transactions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.2.1 </span> Inbound Cross Border MT 101 View",
                                    "href":"inbound-cross-border-mt-101-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.2.1.1 </span> ASI Agent Details",
                                            "href":"inbound-cross-border-mt-101-view_asi-agent-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.2.1.2 </span> SWIFT MT 101 Inbound Summary",
                                            "href":"swift-mt-101-inbound-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> MT 101 Inbound Processing",
                            "href":"mt-101-inbound-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.3.1 </span> Agreement Validation",
                                    "href":"agreement-validation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.2 </span> Cutoff Time Check",
                                    "href":"cutoff-time-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.3 </span> Transaction Amount Limit check",
                                    "href":"transaction-amount-limit-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.4 </span> Future Value Check",
                                    "href":"future-value-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.5 </span> Sanction Check Validation",
                                    "href":"sanction-check-validation_3.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.6 </span> Network Resolution and Transaction Booking",
                                    "href":"network-resolution-and-transaction-booking.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.3.7 </span> FX Handling for Inbound MT 101",
                                    "href":"fx-handling-inbound-mt-101.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12.4 </span> MT101 Outbound Transactions",
                            "href":"mt101-outbound-transactions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.4.1 </span> Outbound MT 101 Transaction Input",
                                    "href":"outbound-mt-101-transaction-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.4.1.1 </span> Main Tab",
                                            "href":"outbound-mt-101-transaction-input-_main-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.1.2 </span> Pricing Tab",
                                            "href":"outbound-mt-101-transaction-input_pricing-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.1.3 </span> Sequence B - Other Details",
                                            "href":"outbound-mt-101-transaction-input_other-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.1.4 </span> Outbound MT 101 Transaction Summary",
                                            "href":"viewing-outbound-mt-101-transaction-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.4.2 </span> Outbound Cross Border MT 101 View",
                                    "href":"outbound-cross-border-mt-101-view.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.4.2.1 </span> All Messages",
                                            "href":"all-messages_2.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.2.2 </span> Sequence A & B -View Queue Action",
                                            "href":"sequence-b-view-queue-action.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.2.3 </span> Accounting Details",
                                            "href":"accounting-entries-button.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.4.2.4 </span> Outbound MT 101 View Summary",
                                            "href":"outbound-mt-101-view-summary.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">12.5 </span> MT101 Outbound Processing",
                            "href":"mt101-outbound-processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.5.1 </span> Agreement Validation",
                                    "href":"agreement-validation_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.5.2 </span> Sanction Check Validation",
                                    "href":"sanction-check-validation_4.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.5.3 </span> Message Generation",
                                    "href":"message-generation.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> MT 204 Processing",
                    "href":"mt-204-processing.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Maintenances",
                            "href":"maintenances.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.1.1 </span> Inbound MT 204 Agreement",
                                    "href":"inbound-mt-204-agreement.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Inbound MT204",
                            "href":"inbound-mt204.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.2.1 </span> Inbound MT204 Message Browser",
                                    "href":"inbound-mt204-message-browser.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.2.1.1 </span> Inbound MT204 Message Browser Summary",
                                            "href":"inbound-mt204-message-browser-summary.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2.2 </span> Inbound MT204 Processing",
                                    "href":"inbound-mt204-processing.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">13.2.2.1 </span> Message Upload and Parsing",
                                            "href":"message-upload-and-parsing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.2.2.2 </span> Credit Instruction Processing",
                                            "href":"credit-instruction-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">13.2.2.3 </span> Direct Debit Transaction Information Processing",
                                            "href":"direct-debit-transaction-information-processing.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Annexure",
                    "href":"annexure.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> PSD2 Compliance",
                            "href":"psd2-compliance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1.1 </span> PSD2 Validations",
                                    "href":"psd-validations_3.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">14.1.1.1 </span> PSD2 Changes for Corporate BICs are part of the Payment Chain",
                                            "href":"psd2-changes-corporate-bics-are-part-payment-chain.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Accounting changes",
                            "href":"accounting-changes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.2.1 </span> Inbound Cross Border/RTGS Transactions",
                                    "href":"inbound-cross-border-rtgs-transactions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">14.2.1.1 </span> Debit Account is of type Nostro",
                                            "href":"debit-account-is-type-nostro.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.2.1.2 </span> Debit Account is of type Vostro (Account Class - Normal)",
                                            "href":"debit-account-is-type-vostro-account-class-normal.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.2 </span> Pass-through Cross Border/RTGS Transactions",
                                    "href":"pass-cross-border-rtgs-transactions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">14.2.2.1 </span> Debit Account is of type Nostro",
                                            "href":"debit-account-is-type-nostro.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">14.2.2.2 </span> Debit Account is of type Vostro (Account Class - Normal)",
                                            "href":"debit-account-is-type-vostro-account-class-normal-_2.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.3 </span> Inbound Cross Border/RTGS Transactions",
                                    "href":"inbound-cross-border-rtgs-transactions_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.4 </span> Pass-through Cross Border/RTGS Transactions",
                                    "href":"pass-cross-border-rtgs-transactions_2.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.5 </span> Pass-through Cross Border/RTGS Transactions booked via Fedwire Incoming",
                                    "href":"pass-cross-border-rtgs-transactions-booked.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.6 </span> Accounting Entry Posting Processing",
                                    "href":"accounting-entry-posting-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> Message Type",
                            "href":"message-type.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.3.1 </span> Incoming Messages",
                                    "href":"incoming-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.3.2 </span> Outgoing Messages",
                                    "href":"outgoing-messages.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> Notifications",
                            "href":"notifications_annexure.html"
                        }
                    ]
                }
            ]
        }
    ]
});