define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"1-preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"1.1-purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"1.2-audience.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"1.4-critical-patches-1-1.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"1.6-conventions-1-1.html"
                        },
                        {
                            "title":"Related Documents",
                            "href":"1.6-related-documents.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"1.7-screenshot-disclaimer.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"1.9-symbols-and-icons.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Islamic Bills and Collections",
                    "href":"2-overview-islamic-bills-and-collections.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Features of Islamic Bills and Collections",
                            "href":"2.2-features-islamic-bills-and-collections.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Islamic Bill Operations",
                            "href":"2.3-islamic-bill-operations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Profit and Charge Liquidation",
                            "href":"2.4-profit-and-charge-liquidation.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Islamic Bills Maintenance",
                    "href":"3-islamic-bills-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Documents and Clauses",
                            "href":"3.2-documents-and-clauses.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1.1 </span> Maintain Documents and Clauses",
                                    "href":"3.2.1-maintain-documents-and-clauses.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.2 </span> Operations on Document Maintenance Screen",
                                    "href":"3.2.2-operations-document-maintenance-screen.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Commodity Codes",
                            "href":"3.3-commodity-codes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.2.1 </span> Maintain Commodity Codes",
                                    "href":"3.3.1-maintain-commodity-codes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2.2 </span> Operations on Goods/Commodity Maintenance Record",
                                    "href":"3.3.2-operations-goods-commodity-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Instruction Codes",
                            "href":"3.4-instruction-codes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.3.1 </span> Maintain Instruction Codes",
                                    "href":"3.4.1-maintain-instruction-codes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.2 </span> Operations on Instruction Code Maintenance Record",
                                    "href":"3.4.2-operations-instruction-code-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Free Format Texts",
                            "href":"3.5-free-format-texts.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.4.1 </span> Maintain Free Format Texts",
                                    "href":"3.5.1-maintain-free-format-texts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.4.2 </span> Operations on FFT Maintenance Record",
                                    "href":"3.5.2-operations-fft-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Discrepancy Codes",
                            "href":"3.6-discrepancy-codes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.5.1 </span> Maintain Discrepancy Codes",
                                    "href":"3.6.1-maintain-discrepancy-codes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.5.2 </span> Operations on Discrepancy Code Maintenance Record",
                                    "href":"3.6.2-operations-discrepancy-code-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Insurance Company Details",
                            "href":"3.7-insurance-company-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.6.1 </span> Maintain Insurance Company Details",
                                    "href":"3.7.1-maintain-insurance-company-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6.2 </span> Operations on Insurance Company Record",
                                    "href":"3.7.2-operations-insurance-company-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Exchange Rate Type based on Transaction Amount",
                            "href":"3.8-exchange-rate-type-based-transaction-amount.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.7.1 </span> Process Exchange Rate Type based on Transaction Amount",
                                    "href":"3.8.1-process-exchange-rate-type-based-transaction-amount.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Define Attributes of Islamic Bills and Collections Product",
                    "href":"4-define-attributes-islamic-bills-and-collections-product.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Characteristics for a Product",
                            "href":"4.2-characteristics-product.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1.1 </span> Define Characteristics for Product",
                                    "href":"4.2.1-define-characteristics-product.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Process Islamic Bills",
                    "href":"5-process-islamic-bills.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Process Islamic BC Contract Detailed",
                            "href":"5.1-process-islamic-bc-contract-detailed.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Bill Amount Amendment",
                            "href":"5.2-bill-amount-amendment.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.2.1 </span> Amend Bill Amount",
                                    "href":"5.3.1-amend-bill-amount.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.2 </span> Specify Advices for the Amendment",
                                    "href":"5.3.2-specify-advices-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.3 </span> Specify FFTs for an Advice",
                                    "href":"5.3.3-specify-ffts-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.4 </span> Specify Instructions for an Advice",
                                    "href":"5.3.4-specify-instructions-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.5 </span> Maintain Event Details",
                                    "href":"5.3.5-maintain-event-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.6 </span> Specify Settlement Instructions",
                                    "href":"5.3.6-specify-settlement-instructions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.7 </span> Maintain Profit Details",
                                    "href":"5.3.7-maintain-profit-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.8 </span> Maintain Charges Details",
                                    "href":"5.3.8-maintain-charges-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.9 </span> Maintain Tax Details",
                                    "href":"5.3.9-maintain-tax-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.10 </span> View Different Versions of a Bill",
                                    "href":"5.3.10-view-different-versions-bill.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.11 </span> Save Contract as a Template",
                                    "href":"5.3.11-contract-template.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.12 </span> Delete a Contract",
                                    "href":"5.3.12-delete-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.13 </span> Specify Counterparty Details",
                                    "href":"5.3.13-specify-counterparty-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.14 </span> View the Media Addresses of a Customer",
                                    "href":"5.3.14-view-media-addresses-customer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.15 </span> View Islamic BC Contract",
                                    "href":"5.3.15-view-islamic-bc-contract.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Liquidation of Receivable Components of Islamic Bill",
                    "href":"6-liquidation-receivable-components-islamic-bill.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Liquidate Outstanding Components of Bill",
                            "href":"6.2-liquidate-outstanding-components-bill.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Reverse Liquidation Entries",
                            "href":"6.3-reverse-liquidation-entries.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.2.1 </span> Partial Payment of the Discounted Bills",
                                    "href":"6.3.1-partial-payment-discounted-bills.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> List of Outstanding Items Report",
                            "href":"6.4-list-outstanding-items-report.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Process Report",
                                    "href":"6.4.1-process-report.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.2 </span> Selection Options",
                                    "href":"6.4.2-selection-options.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.3.3 </span> Contents of the Report",
                                    "href":"6.4.3-contents-report.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Liquidation of Overdue Components",
                            "href":"6.5-liquidation-overdue-components.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.4.1 </span> Liquidate Overdue Components",
                                    "href":"6.5.1-liquidate-overdue-components.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Document Arrival Details",
                            "href":"6.6-document-arrival-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.5.1 </span> Maintain Document Arrival Details",
                                    "href":"6.6.1-maintain-document-arrival-details.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Define Discount Accrual Classes",
                    "href":"7-define-discount-accrual-classes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Define Discount Accrual Class",
                            "href":"7.2-define-discount-accrual-class.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Events and Accounting Entries for Discount Accrual",
                            "href":"7.3-events-and-accounting-entries-discount-accrual.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Specify Status Change Details for Discount Accrual",
                            "href":"7.4-specify-status-change-details-discount-accrual.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Process for Discount Accrual",
                            "href":"7.5-process-discount-accrual.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.4.1 </span> Processing for Discount Accrual",
                                    "href":"7.5.1-processing-discount-accrual.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.4.2 </span> IRR Calculation and IRR Re-calculation",
                                    "href":"7.5.2-irr-calculation-and-irr-calculation.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Registration of Islamic Bill",
                    "href":"8-registration-islamic-bill.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Islamic Bills & Collections Registration",
                            "href":"8.2-islamic-bills-collections-registration.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1.1 </span> Maintain the Bills and Collections Registration Details of a Islamic Bill",
                                    "href":"8.2.1-maintain-bills-and-collections-registration-details-islamic-bill.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.1.2 </span> View Islamic Bills and Collections Registration Input Summary",
                                    "href":"8.2.2-view-islamic-bills-and-collections-registration-input-summary.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Automatic Processes",
                    "href":"9-automatic-processes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Maintain Branch Parameters",
                            "href":"9.2-maintain-branch-parameters.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Process Bills Batch",
                            "href":"9.3-process-bills-batch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Processes Run during Beginning of Day",
                            "href":"9.4-processes-run-beginning-day.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.3.1 </span> Automatic Liquidation of Bills",
                                    "href":"9.4.1-automatic-liquidation-bills.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.1 </span> ECA Request Creation Batch",
                                            "href":"9.4.1.1-eca-request-creation-batch.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.2 </span> Accounting Entries Passed for a Status Change",
                                            "href":"9.4.1.2-accounting-entries-passed-status-change.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.3 </span> Advices",
                                            "href":"9.4.1.3-advices.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.4 </span> Delink of CASA/CD during Auto Liquidation",
                                            "href":"9.4.1.4-delink-casa-cd-auto-liquidation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.5 </span> Delink and Utilization of FX Linkage during Auto Liquidation",
                                            "href":"9.4.1.5-delink-and-utilization-fx-linkage-auto-liquidation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.1.6 </span> Holiday Processing",
                                            "href":"9.4.1.6-holiday-processing.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.2 </span> Tracer Generation",
                                    "href":"9.4.2-tracer-generation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.2.1 </span> Advices",
                                            "href":"9.4.2.1-advices.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.3 </span> Automatic Accrual of Profit",
                                    "href":"9.4.3-automatic-accrual-profit.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.4 </span> Intra Day Accruals",
                                    "href":"9.4.4-intra-day-accruals.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.5 </span> Automatic Status Changes",
                                    "href":"9.4.5-automatic-status-changes.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.5.1 </span> Accounting Entries that are Passed",
                                            "href":"9.4.5.1-accounting-entries-that-are-passed.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.5.2 </span> Advices that are Generated",
                                            "href":"9.4.5.2-advices-that-are-generated.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.5.3 </span> Holiday Processing",
                                            "href":"9.4.5.3-holiday-processing.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.6 </span> Floating Rate Change",
                                    "href":"9.4.6-floating-rate-change.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.7 </span> Automatic Change from Acceptance to Advance",
                                    "href":"9.4.7-automatic-change-acceptance-advance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.8 </span> Automatic Generation Advices",
                                    "href":"9.4.8-automatic-generation-advices.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">8.3.8.1 </span> Automatic Generation of Reimbursement Claims",
                                            "href":"9.4.8.1-automatic-generation-reimbursement-claims.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">8.3.8.2 </span> Automatic Generation of a Payment Due Advice",
                                            "href":"9.4.8.2-automatic-generation-payment-due-advice.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.9 </span> Acceptance to Advance on Future Advance Date",
                                    "href":"9.4.9-acceptance-advance-future-advance-date.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Islamic Bills and Collection Contract Simulation",
                    "href":"10-islamic-bills-and-collection-contract-simulation.html"
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Annexure - A",
                    "href":"11-annexure.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Free Format Texts (FFTs)",
                            "href":"11.1-free-format-texts-ffts.html"
                        }
                    ]
                },
                {
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Original import bill to be created before creating a buyers credit undertaking bill",
                            "href":"12.1-original-import-bill-be-created-creating-buyers-credit-undertaking-bill.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Suggested Accounting Entries and Advices for Islamic Bills",
                            "href":"13.1-suggested-accounting-entries-and-advices-islamic-bills.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.2.1 </span> BOOK - Booking",
                                    "href":"13.1.1-book-booking.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.1 </span> Incoming Payment",
                                            "href":"13.1.1.1-incoming-payment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.2 </span> Incoming Advance",
                                            "href":"13.1.1.2-incoming-advance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.3 </span> Incoming Acceptance",
                                            "href":"13.1.1.3-incoming-acceptance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.4 </span> Incoming Discount",
                                            "href":"13.1.1.4-incoming-discount.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.5 </span> Outgoing Payment",
                                            "href":"13.1.1.5-outgoing-payment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.6 </span> Outgoing Purchase",
                                            "href":"13.1.1.6-outgoing-purchase.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.7 </span> Outgoing Negotiation",
                                            "href":"13.1.1.7-outgoing-negotiation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.8 </span> Outgoing Acceptance",
                                            "href":"13.1.1.8-outgoing-acceptance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.9 </span> Outgoing Discount (Initial)",
                                            "href":"13.1.1.9-outgoing-discount-initial.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.1.10 </span> Outgoing Discount (Final)",
                                            "href":"13.1.1.10-outgoing-discount-final.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.2 </span> INIT - Initiation",
                                    "href":"13.1.2-init-initiation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.1 </span> Incoming/Outgoing Collections",
                                            "href":"13.1.2.1-incoming-outgoing-collections.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.2 </span> Incoming Acceptance (Documentary)",
                                            "href":"13.1.2.2-incoming-acceptance-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.3 </span> Incoming Discount (Documentary)",
                                            "href":"13.1.2.3-incoming-discount-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.4 </span> Incoming Discount (Clean)",
                                            "href":"13.1.2.4-incoming-discount-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.5 </span> Outgoing Payment",
                                            "href":"13.1.2.5-outgoing-payment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.6 </span> Outgoing Purchase (Documentary)",
                                            "href":"13.1.2.6-outgoing-purchase-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.7 </span> Outgoing Purchase (Clean)",
                                            "href":"13.1.2.7-outgoing-purchase-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.8 </span> Outgoing Negotiation (Documentary)",
                                            "href":"13.1.2.8-outgoing-negotiation-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.9 </span> Outgoing Negotiation (Clean)",
                                            "href":"13.1.2.9-outgoing-negotiation-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.10 </span> Outgoing Acceptance (Documentary)",
                                            "href":"13.1.2.10-outgoing-acceptance-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.11 </span> Outgoing Acceptance (Clean)",
                                            "href":"13.1.2.11-outgoing-acceptance-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.12 </span> Outgoing Discount",
                                            "href":"13.1.2.12-outgoing-discount.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.3 </span> LIQD - Contract Liquidation",
                                    "href":"13.1.3-liqd-contract-liquidation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.1 </span> Incoming Collection",
                                            "href":"13.1.3.1-incoming-collection.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.2 </span> Incoming Payment (Final)",
                                            "href":"13.1.3.2-incoming-payment-final.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.3 </span> Incoming Advance",
                                            "href":"13.1.3.3-incoming-advance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.4 </span> Incoming Acceptance (Documentary)",
                                            "href":"13.1.3.4-incoming-acceptance-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.5 </span> Incoming Acceptance (Clean)",
                                            "href":"13.1.3.5-incoming-acceptance-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.6 </span> Incoming Discount (Documentary)",
                                            "href":"13.1.3.6-incoming-discount-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.7 </span> Incoming Discount (Clean)",
                                            "href":"13.1.3.7-incoming-discount-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.8 </span> Outgoing Collection (Final)",
                                            "href":"13.1.3.8-outgoing-collection-final.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.9 </span> Outgoing Payment",
                                            "href":"13.1.3.9-outgoing-payment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.10 </span> Outgoing Purchase (Documentary)",
                                            "href":"13.1.3.10-outgoing-purchase-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.11 </span> Outgoing Purchase (Clean)",
                                            "href":"13.1.3.11-outgoing-purchase-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.12 </span> Outgoing Negotiation (Documentary)",
                                            "href":"13.1.3.12-outgoing-negotiation-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.13 </span> Outgoing Negotiation (Clean)",
                                            "href":"13.1.3.13-outgoing-negotiation-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.14 </span> Outgoing Acceptance (Documentary)",
                                            "href":"13.1.3.14-outgoing-acceptance-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.15 </span> Outgoing Acceptance (Clean)",
                                            "href":"13.1.3.15-outgoing-acceptance-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.16 </span> Outgoing Discount (Documentary)",
                                            "href":"13.1.3.16-outgoing-discount-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.17 </span> Outgoing Discount (Clean)",
                                            "href":"13.1.3.17-outgoing-discount-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.3.18 </span> Collateral Accounting on Bill Liquidation",
                                            "href":"13.1.3.18-collateral-accounting-bill-liquidation.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.4 </span> CLOS - Contract Closure",
                                    "href":"13.1.4-clos-contract-closure.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.1 </span> Incoming Payment",
                                            "href":"13.1.4.1-incoming-payment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.2 </span> Incoming Acceptance (Initial)",
                                            "href":"13.1.4.2-incoming-acceptance-initial.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.3 </span> Incoming Acceptance (Final)",
                                            "href":"13.1.4.3-incoming-acceptance-final.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.4 </span> Incoming Acceptance",
                                            "href":"13.1.4.4-incoming-acceptance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.5 </span> Outgoing Acceptance (Documentary)",
                                            "href":"13.1.4.5-outgoing-acceptance-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.4.6 </span> Outgoing Acceptance (Clean)",
                                            "href":"13.1.4.6-outgoing-acceptance-clean.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.5 </span> REGN - Contract Registration",
                                    "href":"13.1.5-regn-contract-registration.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.5.1 </span> Incoming / Outgoing Collection",
                                            "href":"13.1.5.1-incoming-outgoing-collection.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.6 </span> BDIS - Discounting",
                                    "href":"13.1.6-bdis-discounting.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.6.1 </span> Incoming Acceptance to Discount (Documentary)",
                                            "href":"13.1.6.1-incoming-acceptance-discount-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.6.2 </span> Incoming Acceptance to Discount (Clean)",
                                            "href":"13.1.6.2-incoming-acceptance-discount-clean.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.6.3 </span> Outgoing Acceptance to Discount (Documentary)",
                                            "href":"13.1.6.3-outgoing-acceptance-discount-documentary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.6.4 </span> Outgoing Acceptance to Discount (Clean)",
                                            "href":"13.1.6.4-outgoing-acceptance-discount-clean.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.7 </span> BACP - Bill Acceptance",
                                    "href":"13.1.7-bacp-bill-acceptance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.8 </span> REVR - Reversal of an Islamic BC Contract",
                                    "href":"13.1.8-revr-reversal-islamic-bc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.9 </span> REVE - Reversal of an BC Event",
                                    "href":"13.1.9-reve-reversal-bc-event.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.9.1 </span> All Bill Products",
                                            "href":"13.1.9.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.10 </span> ACCR: Profit Accrual",
                                    "href":"13.1.10-accr-profit-accrual.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.10.1 </span> All Bill Products",
                                            "href":"13.1.10.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.11 </span> REAS - Reassignment",
                                    "href":"13.1.11-reas-reassignment.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.11.1 </span> All BC Products",
                                            "href":"13.1.11.1-all-bc-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.12 </span> ADIS - Approval of Discrepancies",
                                    "href":"13.1.12-adis-approval-discrepancies.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.12.1 </span> All Bill Products",
                                            "href":"13.1.12.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.13 </span> REFA - Refusal to Accept",
                                    "href":"13.1.13-refa-refusal-accept.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.13.1 </span> All Bill Products",
                                            "href":"13.1.13.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.14 </span> REFP - Refusal to Pay",
                                    "href":"13.1.14-refp-refusal-pay.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.14.1 </span> All Bill Products",
                                            "href":"13.1.14.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.15 </span> TAFT - Advice of Fate",
                                    "href":"13.1.15-taft-advice-fate.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.15.1 </span> All Bill Products",
                                            "href":"13.1.15.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.16 </span> TACP - Tracer for Acceptance",
                                    "href":"13.1.16-tacp-tracer-acceptance.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.16.1 </span> All Bill Products",
                                            "href":"13.1.16.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.17 </span> TAPY: Transfer for Payment",
                                    "href":"13.1.17-tapy-transfer-payment.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.17.1 </span> All Bill Products",
                                            "href":"13.1.17.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.18 </span> TDIS: Tracer for approval of discrepancies",
                                    "href":"13.1.18-tdis-tracer-approval-discrepancies.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.18.1 </span> All Bill Products",
                                            "href":"13.1.18.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.19 </span> TRES: Tracer for release of reserve",
                                    "href":"13.1.19-tres-tracer-release-reserve.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.19.1 </span> All Bill Products",
                                            "href":"13.1.19.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.20 </span> DNTC: Arrival of Document Notice",
                                    "href":"13.1.20-dntc-arrival-document-notice.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.20.1 </span> All Bill Products",
                                            "href":"13.1.20.1-all-bill-products.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.21 </span> ROLL - Rollover",
                                    "href":"13.1.21-roll-rollover.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.22 </span> FOPY",
                                    "href":"13.1.22-fopy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.23 </span> Accounting Roles for transfer of Charge & Commission Components from LC to BC",
                                    "href":"13.1.23-accounting-roles-transfer-charge-commission-components-lc-bc.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.23.1 </span> Accounting Definition for Charges / Commission as Part of Bills",
                                            "href":"13.1.23.1-accounting-definition-charges-commission-part-bills.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">11.2.23.1.1 </span> Event: BPUR",
                                                    "href":"13.1.23.1.1-event-bpur.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.24 </span> Accounting Entries for FX Linkage",
                                    "href":"13.1.24-accounting-entries-fx-linkage.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.24.1 </span> Accounting Entries of FX for operation Purchase/Discount/Negotiation During initiation",
                                            "href":"13.1.24.1-accounting-entries-fx-operation-purchase-discount-negotiation-initiation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.24.2 </span> Event: BDIS",
                                            "href":"13.1.24.2-event-bdis.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.24.3 </span> Event: INIT",
                                            "href":"13.1.24.3-event-init.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.25 </span> Accounting Entries of FX for operation Purchase/Discount/Negotiation During Liquidation",
                                    "href":"13.1.25-accounting-entries-fx-operation-purchase-discount-negotiation-liquidation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.25.1 </span> Event: LPUR",
                                            "href":"13.1.25.1-event-lpur.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.25.2 </span> Event: LDIS",
                                            "href":"13.1.25.2-event-ldis.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.25.3 </span> Event: LIQD",
                                            "href":"13.1.25.3-event-liqd.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.26 </span> BCAC",
                                    "href":"13.1.26-bcac.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.26.1 </span> Event: LIQD",
                                            "href":"13.1.28.1-event-liqd.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.27 </span> Accounting Entries for Buyers Credit",
                                    "href":"13.2-accounting-entries-buyers-credit.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.27.1 </span> Original import bill to be created before creating a buyers credit undertaking bill",
                                            "href":"13.2.1-original-import-bill-be-created-creating-buyers-credit-undertaking-bill.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">11.2.27.1.1 </span> Event: INIT",
                                                    "href":"13.2.1.1-event-init.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.27.2 </span> Buyers credit undertaking bill for Original Import Bill",
                                            "href":"13.2.2-buyers-credit-undertaking-bill-original-import-bill.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">11.2.27.2.1 </span> Event: LIQD - Accounting Entries",
                                                    "href":"13.2.2.1-event-liqd-accounting-entries.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.28 </span> Collateral Bridge Accounting Role",
                                    "href":"13.2.3-collateral-bridge-accounting-role.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.29 </span> Crystallization Linkage Event",
                                    "href":"13.2.24-crystallization-linkage-event.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.30 </span> Events for Reversal of Linked Finance before and after initiation of the finance",
                                    "href":"13.2.5-events-reversal-linked-finance-and-initiation-finance.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Annexure C - Error Codes and Messages for Islamic Bills and Collections",
                    "href":"14-annexure-c-error-codes-and-messages-islamic-bills-and-collections.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Annexure C - Error Codes and Messages for Islamic Bills and Collections",
                            "href":"14.1-error-codes-and-messages.html"
                        }
                    ]
                },
                {
                    "title":"Glossary",
                    "href":"Chunk1001087452.html"
                }
            ]
        }
    ]
});