define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"1-preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"1.1-purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"1.2-audience.html"
                        },
                        {
                            "title":"List of Topics",
                            "href":"1.5-list-topics.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"1.4-critical-patches-1-1.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"1.6-conventions-1-1.html"
                        },
                        {
                            "title":"Related Documents",
                            "href":"1.6-related-documents.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"1.3-acronyms-and-abbreviations.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"1.6-screenshot-disclaimer-1.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"1.8-symbols-and-icons-1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Islamic Letters of Credit",
                    "href":"2-overview-islamic-letters-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Features",
                            "href":"2.1-features.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Operations supported on an Islamic LC",
                            "href":"2.2-operations-supported-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> SWIFT Messages for an Import Islamic LC",
                            "href":"2.3-swift-messages-import-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> SWIFT Messages for an Export Islamic LC",
                            "href":"2.4-swift-messages-export-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> SWIFT Messages for a Standby Islamic LC",
                            "href":"2.5-swift-messages-standby-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.6 </span> SWIFT Messages for a Clean Islamic LC",
                            "href":"2.6-swift-messages-clean-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.7 </span> SWIFT Messages for a Guarantee",
                            "href":"2.7-swift-messages-guarantee.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.8 </span> SWIFT Messages for a Shipping Guarantee",
                            "href":"2.8-swift-messages-shipping-guarantee.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.9 </span> Process Commissions and Charges",
                            "href":"2.9-process-commissions-and-charges.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.10 </span> Variations Supported for an Islamic LC",
                            "href":"2.10-variations-supported-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.11 </span> Red Clause Letter of Credit",
                            "href":"2.11-red-clause-letter-credit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.12 </span> Revocable and Irrevocable Islamic LCs",
                            "href":"2.12-revocable-and-irrevocable-islamic-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.13 </span> Transferable and Non Transferable Islamic LCs",
                            "href":"2.13-transferable-and-non-transferable-islamic-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.14 </span> Revolving and Non Revolving Islamic LCs",
                            "href":"2.14-revolving-and-non-revolving-islamic-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.15 </span> Sight and Usance Islamic LC",
                            "href":"2.15-sight-and-usance-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.16 </span> Open Ended Islamic LCs",
                            "href":"2.16-open-ended-islamic-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.17 </span> Cash Collateral against an Islamic LC",
                            "href":"2.17-cash-collateral-islamic-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.18 </span> Availment against an Islamic LC",
                            "href":"2.18-availment-islamic-lc.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Islamic Letters of Credit - Maintenance",
                    "href":"3-islamic-letters-credit-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Documents and Clauses Details",
                            "href":"3.1-documents-and-clauses-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1.1 </span> Maintain Documents and Clauses",
                                    "href":"3.1.1-maintain-documents-and-clauses-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.2 </span> Specify Values for the User Defined Fields",
                                    "href":"3.1.2-specify-values-user-defined-fields.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.3 </span> Operations on Document Maintenance Record",
                                    "href":"3.1.3-operations-document-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Goods Details",
                            "href":"3.2-goods-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.2.1 </span> Maintain Goods",
                                    "href":"3.2.1-maintain-goods-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2.2 </span> Specify Values for UDF",
                                    "href":"3.2.2-specify-values-udf.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2.3 </span> Operations on a Goods/Commodity Maintenance Record",
                                    "href":"3.2.3-operations-goods-commodity-maintenance-record.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Free Format Text (FFT) Codes Details",
                            "href":"3.3-free-format-text-fft-codes-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.3.1 </span> Maintain Free Format Text (FFT) Codes",
                                    "href":"3.3.1-maintain-free-format-text-fft-codes-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.2 </span> Specify Values for User Defined Fields",
                                    "href":"3.3.2-specify-values-user-defined-fields.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.3 </span> Operations on the FFT Maintenance Record",
                                    "href":"3.3.3-operations-fft-maintenance-record.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.4 </span> Maintain INCO Terms",
                                    "href":"3.3.4-maintain-inco-terms.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Maintain Insurance Company Details",
                            "href":"3.4-maintain-insurance-company-details-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Maintain Customer Insurance Details",
                            "href":"3.5-maintain-customer-insurance-details-1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.5.1 </span> Capture Utilization History Details",
                                    "href":"3.5.1-capture-utilization-history-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Maintain Import License Expiry Date",
                            "href":"3.6-maintain-import-license-expiry-date-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Application of Exchange Rate Type based on Transaction Amount",
                            "href":"3.7-application-exchange-rate-type-based-transaction-amount-1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Define Attributes specific to an Islamic Product",
                    "href":"4-define-attributes-specific-islamic-product.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Create an Islamic LC Product",
                            "href":"4.1-create-islamic-lc-product.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1.1 </span> Specify Sanction Check Details",
                                    "href":"4.1.1-specify-sanction-check-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Generate Islamic LC Expiry/Closure Advices",
                            "href":"4.2-generate-islamic-lc-expiry-closure-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.2.1 </span> Opting to Track Limits",
                                    "href":"4.2.1-opting-track-limits.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.2 </span> Setting Criteria for Status Change",
                                    "href":"4.2.2-setting-criteria-status-change-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.3 </span> Specify Applicable Rules of a Guarantee",
                                    "href":"4.2.3-specify-applicable-rules-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.4 </span> Generate Advices for the Insurance Company",
                                    "href":"4.2.4-generate-advices-insurance-company.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.5 </span> Specify Event for Reissue of Guarantee",
                                    "href":"4.2.5-specify-event-reissue-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.6 </span> Generate Advice for Faxing Islamic LC Confirmation to Counterparty",
                                    "href":"4.2.6-generate-advice-faxing-islamic-lc-confirmation-counterparty.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Process an Islamic LC Contract",
                    "href":"5-process-islamic-lc-contract.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Introduction",
                            "href":"5.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Islamic LC Contract Details",
                            "href":"5.2-islamic-lc-contract-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.2.1 </span> Islamic LC Contract Details Screen",
                                    "href":"5.2.1-islamic-lc-contract-details-screen-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Islamic LC Contract Details Screen Description",
                            "href":"5.3-islamic-lc-contract-details-screen-description.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.3.1 </span> Description of the Islamic LC Contract Details Screen",
                                    "href":"5.3.1-description-islamic-lc-contract-details-screen.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.2 </span> Specify the Main Details of an Islamic LC",
                                    "href":"5.3.2-specify-main-details-islamic-lc-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.3 </span> Update Parties’ Limits on Amendment of Islamic LC Contract",
                                    "href":"5.3.3-update-parties-limits-amendment-islamic-lc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.4 </span> Update Parties’ Limits on Islamic LC Availments",
                                    "href":"5.3.4-update-parties-limits-islamic-lc-availments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.5 </span> Specify the Media Details for a Party",
                                    "href":"5.3.5-specify-media-details-party.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.6 </span> Specify Credit Administration Details",
                                    "href":"5.3.6-specify-credit-administration-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.7 </span> Specify Shipping for an Islamic LC",
                                    "href":"5.3.7-specify-shipping-islamic-lc-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.8 </span> Specify Advices for an Islamic LC",
                                    "href":"5.3.8-specify-advices-islamic-lc-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.9 </span> Specify the Free Format Instructions that should accompany an Advice",
                                    "href":"5.3.9-specify-free-format-instructions-that-should-accompany-advice.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Cancel an Islamic LC",
                            "href":"5.4-cancel-islamic-lc-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Close, Reopen, and Black list an Islamic LC",
                            "href":"5.5-close-reopen-and-black-list-islamic-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.5.1 </span> Closing an Islamic LC",
                                    "href":"5.5.1-closing-islamic-lc.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.5.1.1 </span> Close an Islamic LC automatically",
                                            "href":"5.5.1.1-close-islamic-lc-automatically.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.5.1.2 </span> Close an Islamic LC manually",
                                            "href":"5.5.1.2-close-islamic-lc-manually.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.2 </span> Reopen an Islamic LC",
                                    "href":"5.5.2-reopen-islamic-lc.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.5.2.1 </span> Procedure to reopen an Islamic LC",
                                            "href":"5.5.2.1-procedure-reopen-islamic-lc.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.3 </span> Black Listing Islamic LCs",
                                    "href":"5.5.3-black-listing-islamic-lcs-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Reverse Islamic LC",
                            "href":"5.6-reverse-islamic-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.6.1 </span> Reverse an Islamic LC",
                                    "href":"5.6.1-reverse-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6.2 </span> Procedure for Reversing an Islamic LC",
                                    "href":"5.6.2-procedure-reversing-islamic-lc-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6.3 </span> Contract Reversal",
                                    "href":"5.6.3-contract-reversal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6.4 </span> Event Reversal",
                                    "href":"5.6.4-event-reversal.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Additional Details",
                    "href":"6-additional-details.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Capture Additional Details",
                            "href":"6.1-capture-additional-details-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> View Islamic LC Contract Summary Details",
                            "href":"6.2-view-islamic-lc-contract-summary-details-1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.2.1 </span> Operations on Islamic LC Contract",
                                    "href":"6.2.1-operations-islamic-lc-contract-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.2 </span> Create Contract",
                                    "href":"6.2.2-create-contract.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Authorize a Contract",
                            "href":"6.3-authorize-contract-1.html"
                        }
                    ]
                },
                {
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Introduction",
                            "href":"7.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Islamic LC Availment Input",
                            "href":"7.2-islamic-lc-availment-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.2.1 </span> Islamic LC Contract Availment",
                                    "href":"7.2.1-islamic-lc-contract-availment-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.2 </span> Islamic LC Liability Reversal",
                                    "href":"7.2.2-islamic-lc-liability-reversal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.3 </span> View Islamic LC Availed",
                                    "href":"7.2.3-view-islamic-lc-availed-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.4 </span> Reversal of an Availment",
                                    "href":"7.2.4-reversal-availment.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Amend Details of an Islamic LC",
                    "href":"8-amend-details-islamic-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Introduction",
                            "href":"8.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Procedure to Amend an Islamic LC",
                            "href":"8.2-procedure-amend-islamic-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.2.1 </span> Indicate a Change of Value for a Field",
                                    "href":"8.2.1-indicate-change-value-field.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2.2 </span> Commission and Charges for the Amendment",
                                    "href":"8.2.2-commission-and-charges-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.2.3 </span> Amendment of an Unauthorized Islamic LC",
                                    "href":"8.2.3-amendment-unauthorized-islamic-lc.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Islamic LC Amendment Details",
                            "href":"8.3-islamic-lc-amendment-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.3.1 </span> Confirm the Islamic LC Amendment",
                                    "href":"8.3.1-confirm-islamic-lc-amendment-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.2 </span> Authorize Amendment Details",
                                    "href":"8.3.2-authorize-amendment-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.3 </span> Confirm Amended Details",
                                    "href":"8.3.3-confirm-amended-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.4 </span> Amend details using the Contract screen",
                                    "href":"8.3.4-amend-details-using-contract-screen.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">7.3.4.1 </span> Authorize Confirmation",
                                            "href":"8.3.4.1-authorize-confirmation.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.5 </span> Reject Amended Details",
                                    "href":"8.3.5-reject-amended-details.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">7.3.5.1 </span> Authorize Rejection",
                                            "href":"8.3.5.1-authorize-rejection.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.6 </span> Islamic LC Amendment Details",
                                    "href":"8.3.6-islamic-lc-amendment-details-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Operations on Confirmation Record",
                            "href":"8.4-operations-confirmation-record.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> Upload Islamic LC Amendment",
                            "href":"8.5-upload-islamic-lc-amendment.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Islamic Letter of Credit Registration",
                    "href":"9-islamic-letter-credit-registration.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Introduction",
                            "href":"9.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Islamic Letters of Credit Registration",
                            "href":"9.2-islamic-letters-credit-registration.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.2.1 </span> Islamic Letters of Credit Registration Details",
                                    "href":"9.2.1-islamic-letters-credit-registration-details-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.2 </span> Islamic LC Registration Input Summary",
                                    "href":"9.2.2-islamic-lc-registration-input-summary-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Islamic LC Amendment Registration Input",
                            "href":"9.3-islamic-lc-amendment-registration-input-1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Islamic LC Transfer",
                    "href":"10-islamic-lc-transfer.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Introduction",
                            "href":"10.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Transfer Islamic LC",
                            "href":"10.2-transfer-islamic-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.2.1 </span> Note on Transfers from Import and Export Islamic LCs",
                                    "href":"10.2.1-note-transfers-import-and-export-islamic-lcs.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">9.2.1.1 </span> Process of Transfers from Import Islamic LCs",
                                            "href":"10.2.1.1-process-transfers-import-islamic-lcs.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.1.2 </span> Process of Transfers from Export Islamic LCs",
                                            "href":"10.2.1.2-process-transfers-export-islamic-lcs.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.1.3 </span> Amendment In Transferred LC",
                                            "href":"10.2.1.3-amendment-transferred-lc.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">9.2.1.4 </span> Transfer LC Cancel/Closure",
                                            "href":"10.2.1.4-transfer-lc-cancel-closure.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Islamic Guarantees and Standby Letter of Credit",
                    "href":"11-islamic-guarantees-and-standby-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Introduction",
                            "href":"11.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Islamic Guarantees and Standby Letters of Credit Contract Input",
                            "href":"11.2-islamic-guarantees-and-standby-letters-credit-contract-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.2.1 </span> Process Islamic Guarantees and Standby LC",
                                    "href":"11.2.1-process-islamic-guarantees-and-standby-lc-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.2.2 </span> View Guarantees and SBLC Contract Details",
                                    "href":"11.2.2-view-guarantees-and-sblc-contract-details-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Islamic Guarantees and Standby Letters of Credit Amendment",
                            "href":"11.3-islamic-guarantees-and-standby-letters-credit-amendment.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.3.1 </span> Process Amendment of Islamic Guarantees and SBLC",
                                    "href":"11.3.1-process-amendment-islamic-guarantees-and-sblc-1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.3.1.1 </span> FFT Details",
                                            "href":"11.3.1.1-fft-details-1.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.3.2 </span> View Guarantees and SBLC Amendment Details",
                                    "href":"11.3.2-view-guarantees-and-sblc-amendment-details-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> Lodging Islamic Guarantee Claim",
                            "href":"11.4-lodging-islamic-guarantee-claim.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.4.1 </span> Lodging Islamic Guarantee Claim",
                                    "href":"11.4.1-lodging-islamic-guarantee-claim-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.4.2 </span> View Islamic Guarantee Claim Details",
                                    "href":"11.4.2-view-islamic-guarantee-claim-details-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Islamic Guarantee Claim Settlement",
                            "href":"11.5-islamic-guarantee-claim-settlement.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.5.1 </span> Islamic Guarantee Claim Settlement",
                                    "href":"11.5.1-islamic-guarantee-claim-settlement-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.5.2 </span> View Islamic Guarantee Claim Settlement Summary",
                                    "href":"11.5.2-view-islamic-guarantee-claim-settlement-summary-1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> Islamic Guarantees Transfer Input",
                            "href":"11.6-islamic-guarantees-transfer-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.6.1 </span> Islamic Guarantees Transfer Input",
                                    "href":"11.6.1-islamic-guarantees-transfer-input.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.6.2 </span> View Islamic Guarantees and SBLC Transfer Details",
                                    "href":"11.6.2-view-islamic-guarantees-and-sblc-transfer-details-1.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Liquidate Receivable Components",
                    "href":"12-liquidate-receivable-components.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Introduction",
                            "href":"12.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Maintain Online Receivable/Payable Details",
                            "href":"12.2-maintain-online-receivable-payable-details-1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.2.1 </span> Liquidate the Receivable Components of an Islamic LC",
                                    "href":"12.2.1-liquidate-receivable-components-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.2 </span> Manual Liquidation of Receivable Components for the Islamic LC",
                                    "href":"12.2.2-manual-liquidation-receivable-components-islamic-lc-1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.1 </span> Specify Payment Breakup Details",
                                            "href":"12.2.2.1-specify-payment-breakup-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.2.2.2 </span> Waiver of Components during Manual Liquidation of Islamic LC Charges",
                                            "href":"12.2.2.2-waiver-components-manual-liquidation-islamic-lc-charges.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.2.3 </span> Specify Details of the Advices for the Liquidation",
                                    "href":"12.2.3-specify-details-advices-liquidation.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Credit Limit Tracking for an Islamic LC",
                    "href":"13-credit-limit-tracking-islamic-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Introduction",
                            "href":"13.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Track Credit Limit",
                            "href":"13.2-track-credit-limit.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.2.1 </span> Specify whether Limit Tracking is Required",
                                    "href":"13.2.1-specify-whether-limit-tracking-is-required.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.2.2 </span> Indicate the Customer against whom the Islamic LC Liability Amount is Tracked",
                                    "href":"13.2.2-indicate-customer-whom-islamic-lc-liability-amount-is-tracked.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.2.3 </span> Specify the Limit Track Tenor",
                                    "href":"13.2.3-specify-limit-track-tenor.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.2.4 </span> Indicate the Credit Line for Liability Amount",
                                    "href":"13.2.4-indicate-credit-line-liability-amount.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Automatic Processes",
                    "href":"14-automatic-processes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Introduction",
                            "href":"14.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Maintain Branch Parameters",
                            "href":"14.2-maintain-branch-parameters-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> Batch Process",
                            "href":"14.3-batch-process-1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.3.1 </span> Generating Tracers",
                                    "href":"14.3.1-generating-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.3.2 </span> Intra Day Accruals",
                                    "href":"14.3.2-intra-day-accruals.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Simulation",
                    "href":"15-simulation.html"
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Annexure A - Accounting Entries",
                    "href":"16-annexure-accounting-entries.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> Islamic LC Events",
                            "href":"16.1-islamic-lc-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Amount Tags",
                            "href":"16.2-amount-tags.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> Accounting Roles",
                            "href":"16.3-accounting-roles.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.4 </span> Event-Accounting Entries",
                            "href":"16.4-event-accounting-entries.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.4.1 </span> BISS: Booking of an import Islamic LC",
                                    "href":"16.4.1-biss-booking-import-islamic-lc.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">15.4.1.1 </span> Liability",
                                            "href":"16.4.1.1-liability.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">15.4.1.2 </span> Collateral",
                                            "href":"16.4.1.2-collateral.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">15.4.1.3 </span> Charges",
                                            "href":"16.4.1.3-charges.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">15.4.1.4 </span> Commission",
                                            "href":"16.4.1.4-commission.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.2 </span> Accounting Roles for Transfer of Charge & Commission Components from Islamic LC to BC",
                                    "href":"16.4.2-accounting-roles-transfer-charge-commission-components-islamic16.4.2-accounting-roles-transf.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.3 </span> Accounting Entries for Transfer of Charge & Commission Components from Islamic LC to BC",
                                    "href":"16.4.3-accounting-entries-transfer-charge-commission-components-islamic-lc-bc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.4 </span> Collateral Bridge Accounting Role",
                                    "href":"16.4.4-collateral-bridge-accounting-role.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.5 </span> AVAL: Availment under Islamic LC",
                                    "href":"16.4.5-aval-availment-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.6 </span> CLOS: Closure of an Islamic LC / Guarantee",
                                    "href":"16.4.6-clos-closure-islamic-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.7 </span> REIN: Reinstatement of an Islamic LC / Guarantee",
                                    "href":"16.4.7-rein-reinstatement-islamic-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.8 </span> BADV: Advising an Islamic LC",
                                    "href":"16.4.8-badv-advising-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.9 </span> BCFM: Confirming an Islamic LC",
                                    "href":"16.4.9-bcfm-confirming-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.10 </span> BPRE: Pre-advising an Islamic LC",
                                    "href":"16.4.10-bpre-advising-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.11 </span> BANC: Advising and Confirming an Islamic LC",
                                    "href":"16.4.11-banc-advising-and-confirming-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.12 </span> AMND: Amendment",
                                    "href":"16.4.12-amnd-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.13 </span> AOCF: Amendment from Open to Open and Confirm",
                                    "href":"16.4.13-aocf-amendment-open-open-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.14 </span> APAD: Amendment from Pre-advice to Advice",
                                    "href":"16.4.14-apad-amendment-advice-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.15 </span> APAC: Amendment from Pre-advice to Advice and Confirm",
                                    "href":"16.4.15-apac-amendment-advice-advice-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.16 </span> REVR: Reversal of an Islamic LC Contract",
                                    "href":"16.4.16-revr-reversal-islamic-lc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.17 </span> REVE: Reversal of an Islamic LC Event",
                                    "href":"16.4.17-reve-reversal-islamic-lc-event.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.18 </span> ACCR: Accrual of Commission",
                                    "href":"16.4.18-accr-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.19 </span> CALC: Periodic Commission Calculation Date",
                                    "href":"16.4.19-calc-periodic-commission-calculation-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.20 </span> CLIQ: Liquidation of Commission",
                                    "href":"16.4.20-cliq-liquidation-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.21 </span> ROPN: Reopening of an Islamic LC",
                                    "href":"16.4.21-ropn-reopening-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.22 </span> CANC: Cancellation of an Islamic LC",
                                    "href":"16.4.22-canc-cancellation-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.23 </span> TRGN: Generation of Tracers",
                                    "href":"16.4.23-trgn-generation-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.24 </span> AATC: Amendment from Advice to Confirm",
                                    "href":"16.4.24-aatc-amendment-advice-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.25 </span> RASN: Reassign an Islamic LC",
                                    "href":"16.4.25-rasn-reassign-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.26 </span> RAVL: Reversal of Availment",
                                    "href":"16.4.26-ravl-reversal-availment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.27 </span> MLIQ: Manual Liquidation of Islamic LC commission",
                                    "href":"16.4.27-mliq-manual-liquidation-islamic-lc-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.28 </span> WAIV: Waiver of Components during Manual Liquidation",
                                    "href":"16.4.28-waiv-waiver-components-manual-liquidation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.29 </span> GCLP: Guarantee Claim Settlement",
                                    "href":"16.4.29-gclp-guarantee-claim-settlement.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.30 </span> AASC: Amendment of Advice to Silent Confirmation",
                                    "href":"16.4.30-aasc-amendment-advice-silent-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.31 </span> TRAM: Transfer Amendment",
                                    "href":"16.4.31-tram-transfer-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.4.32 </span> RTRA: Reinstatement of Transferred LC Amount",
                                    "href":"16.4.32-rtra-reinstatement-transferred-lc-amount.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Annexure B – Events and Advices",
                    "href":"17-annexure-b-events-and-advices.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Islamic LC Events",
                            "href":"17.1-islamic-lc-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Islamic LC Messages",
                            "href":"17.2-islamic-lc-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.3 </span> Generate Multiple Copies of the Islamic LC Instrument",
                            "href":"17.3-generate-multiple-copies-islamic-lc-instrument.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.4 </span> Generate Fax 700/707 LC Confirmation Mail Message Copy to Counterparty",
                            "href":"17.4-generate-fax-700-707-lc-confirmation-mail-message-copy-counterparty.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.5 </span> Islamic LC Event - Messages",
                            "href":"17.5-islamic-lc-event-messages.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.5.1 </span> BISS: Booking of an Import Islamic LC/ Islamic Shipping Guarantee",
                                    "href":"17.5.1-biss-booking-import-islamic-lc-islamic-shipping-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.2 </span> AVAL: Availment under Islamic LC",
                                    "href":"17.5.2-aval-availment-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.3 </span> CLOS: Closure of an Islamic LC/Guarantee",
                                    "href":"17.5.3-clos-closure-islamic-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.4 </span> REIN: Reinstatement of an Islamic LC/Guarantee",
                                    "href":"17.5.4-rein-reinstatement-islamic-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.5 </span> BADV: Advising an Islamic LC",
                                    "href":"17.5.5-badv-advising-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.6 </span> BCFM: Confirming an Islamic LC",
                                    "href":"17.5.6-bcfm-confirming-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.7 </span> BPRE: Pre-advising an Islamic LC",
                                    "href":"17.5.7-bpre-advising-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.8 </span> BANC: Advising and Confirming an Islamic LC",
                                    "href":"17.5.8-banc-advising-and-confirming-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.9 </span> REIS: Reissue of Guarantee",
                                    "href":"17.5.9-reis-reissue-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.10 </span> AMND: Islamic LC Amendment",
                                    "href":"17.5.10-amnd-islamic-lc-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.11 </span> REVR: Reversal of Contract",
                                    "href":"17.5.11-revr-reversal-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.12 </span> REVE: Reversal of Event",
                                    "href":"17.5.12-reve-reversal-event.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.13 </span> ACCR: Accrual of Commission",
                                    "href":"17.5.13-accr-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.14 </span> CALC: Periodic Commission Calculation Date",
                                    "href":"17.5.14-calc-periodic-commission-calculation-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.15 </span> CLIQ: Liquidation of Commission",
                                    "href":"17.5.15-cliq-liquidation-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.16 </span> ROPN: Reopening of an Islamic LC",
                                    "href":"17.5.16-ropn-reopening-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.17 </span> TRGN: End of Day Check for Tracers",
                                    "href":"17.5.17-trgn-end-day-check-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.18 </span> CANC: Cancellation of an Islamic LC",
                                    "href":"17.5.18-canc-cancellation-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.19 </span> APAC: Amendment from Pre-Advice to Advice and Confirm",
                                    "href":"17.5.19-apac-amendment-advice-advice-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.20 </span> APAD: Amendment from Pre-advice to Advice",
                                    "href":"17.5.20-apad-amendment-advice-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.21 </span> GCEX: Guarantee Claim Extension",
                                    "href":"17.5.21-gcex-guarantee-claim-extension.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.22 </span> RASN: Reassign an Islamic LC",
                                    "href":"17.5.22-rasn-reassign-islamic-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.23 </span> RAVL: Reversal of Availment",
                                    "href":"17.5.23-ravl-reversal-availment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.24 </span> CALC: Periodic Commission Calculation",
                                    "href":"17.5.24-calc-periodic-commission-calculation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.25 </span> Advice Generated for the Insurance Company",
                                    "href":"17.5.25-advice-generated-insurance-company.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.26 </span> Advice Generated for the Counterparty",
                                    "href":"17.5.26-advice-generated-counterparty.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.27 </span> AASC: Amendment of Advice to Silent Confirmation",
                                    "href":"17.5.27-aasc-amendment-advice-silent-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.28 </span> AMNV: Invitation of Amendment Confirmation",
                                    "href":"17.5.28-amnv-invitation-amendment-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">16.5.29 </span> AREJ: Rejection Of Amendment Confirmation",
                                    "href":"17.5.29-arej-rejection-amendment-confirmation.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});