define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface-1.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"1.1-introduction.html"
                        },
                        {
                            "title":"Audience",
                            "href":"1.2-audience.html"
                        },
                        {
                            "title":"List of Topics",
                            "href":"1.4-list-topics.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"1.4-critical-patches-1-1.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"1.6-conventions-1-1.html"
                        },
                        {
                            "title":"Related Documents",
                            "href":"1.5-related-documents.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"1.3-acronyms-and-abbreviations.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"1.7-screenshot-disclaimer-1-1.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"1.8-symbols-and-icons-1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> An overview of Letters of Credit",
                    "href":"2-overview-letters-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Introduction",
                            "href":"2.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Features",
                            "href":"2.2-features.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Operations supported on LC",
                            "href":"2.3-operations-supported-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Process Commissions and Charges",
                            "href":"2.4-process-commissions-and-charges.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Variations Supported for an LC",
                            "href":"2.5-variations-supported-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.5.1 </span> Red Clause Letter of Credit",
                                    "href":"2.5.1-red-clause-letter-credit.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5.2 </span> Transferable and Non-transferable LCs",
                                    "href":"2.5.2-transferable-and-non-transferable-lcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5.3 </span> Revolving and Non revolving LCs",
                                    "href":"2.5.3-revolving-and-non-revolving-lcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5.4 </span> Sight and Usance LC",
                                    "href":"2.5.4-sight-and-usance-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5.5 </span> Cash Collateral against an LC",
                                    "href":"2.5.5-cash-collateral-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.5.6 </span> Availment against an LC",
                                    "href":"2.5.6-availment-lc.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> LC Maintenance",
                    "href":"3-lc-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Maintain Document Details",
                            "href":"3.1-maintain-document-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Clause Details",
                            "href":"3.2-clause-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Goods Details",
                            "href":"3.3-goods-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Import License Details",
                            "href":"3.4-import-license-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> View Import License Summary Details",
                            "href":"3.5-view-import-license-summary-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Free Format Text Codes",
                            "href":"3.6-free-format-text-codes-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Insurance Company Details",
                            "href":"3.7-insurance-company-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Trade License Details",
                            "href":"3.8-trade-license-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Exchange Rates for Bills Details",
                            "href":"3.9-exchange-rates-bills-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> INCO Terms Details",
                            "href":"3.10-inco-terms-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.11 </span> Open Insurance Policy Details",
                            "href":"3.11-open-insurance-policy-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.12 </span> Blacklist LCs",
                            "href":"3.12-blacklist-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.13 </span> Maintain Branch Parameters for Letters of Credit",
                            "href":"3.13-maintain-branch-parameters-letters-credit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.14 </span> List of Glossary - LC Maintenance",
                            "href":"3.14-list-glossary-lc-maintenance.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Define Product Attributes",
                    "href":"4-define-product-attributes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Create LC Product",
                            "href":"4.1-create-lc-product.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> List of Glossary - Define Product Attributes",
                            "href":"4.2-list-glossary-define-product-attributes.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Process LC Contract",
                    "href":"5-process-lc-contract.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> LC Contract Details",
                            "href":"5.1-lc-contract-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1.1 </span> Capture LC Contract Details",
                                    "href":"5.1.1-capture-lc-contract-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> View LC Contract",
                            "href":"5.2-view-lc-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.2.1 </span> Operations on LC Contract",
                                    "href":"5.2.1-operations-lc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.2 </span> Create Contract",
                                    "href":"5.2.2-create-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.2.3 </span> Upload LCs",
                                    "href":"5.2.3-upload-lcs.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.2.3.1 </span> Update Parties Limits on Reversal and Deletion of LC Contracts",
                                            "href":"5.2.3.1-update-parties-limits-reversal-and-deletion-lc-contracts.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.2.3.2 </span> Process Sanction Check during Save of a Transaction",
                                            "href":"5.2.3.2-process-sanction-check-transaction.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.2.3.3 </span> Receipt of Response from Sanction Check System and Post Response Processing",
                                            "href":"5.2.3.3-receipt-response-sanction-check-system-and-response-processing.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Authorize a Contract",
                            "href":"5.3-authorize-contract.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Multilevel Authorization of a Contract",
                            "href":"5.5-multilevel-authorization-contract.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Cancel LC",
                            "href":"5.6-cancel-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.5.1 </span> Cancel LC",
                                    "href":"5.6.1-cancel-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.2 </span> Procedure for Cancelling LC",
                                    "href":"5.6.2-procedure-cancelling-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.3 </span> Generate Cancellation Advice in SWIFT Format",
                                    "href":"5.6.3-generate-cancellation-advice-swift-format.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.4 </span> Cancellation of Shipping Guarantee",
                                    "href":"5.6.4-cancellation-shipping-guarantee.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Close LC",
                            "href":"5.7-close-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.6.1 </span> Close an LC",
                                    "href":"5.7.1-close-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6.2 </span> Close an LC Automatically",
                                    "href":"5.7.2-close-lc-automatically.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.6.3 </span> Close an LC Manually",
                                    "href":"5.7.3-close-lc-manually.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Reopening LC",
                            "href":"5.8-reopening-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.7.1 </span> Procedure for Reopening LC",
                                    "href":"5.8.1-procedure-reopening-lc.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Reverse LC",
                            "href":"5.9-reverse-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.8.1 </span> Reverse an LC",
                                    "href":"5.9.1-reverse-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.2 </span> Contract Reversal",
                                    "href":"5.9.2-contract-reversal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.3 </span> Event Reversal",
                                    "href":"5.9.3-event-reversal.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Reassigning a Contract to another User",
                            "href":"5.10-reassigning-contract-another-user.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.10 </span> Liquidate Components",
                            "href":"5.11-liquidate-components.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.11 </span> Import License Utilization",
                            "href":"5.12-import-license-utilization.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.12 </span> View Import License Utilization Summary Details",
                            "href":"5.13-view-import-license-utilization-summary-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.13 </span> View Import License Utilization Details",
                            "href":"5.14-view-import-license-utilization-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.13.1 </span> Operations on Import License Utilization",
                                    "href":"5.14.1-operations-import-license-utilization.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.14 </span> List of Glossary - Process LC Contract",
                            "href":"5.15-list-glossary-process-lc-contract.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> LC Availment",
                    "href":"6-lc-availment.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Introduction",
                            "href":"6.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Availment Details",
                            "href":"6.2-availment-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.2.1 </span> Capture Availment Details",
                                    "href":"6.2.1-capture-availment-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.2.2 </span> Reverse LC Liability",
                                    "href":"6.2.2-reverse-lc-liability.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> View LC Availed",
                            "href":"6.3-view-lc-availed.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Reversal of Availment",
                                    "href":"6.3.1-reversal-availment.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> List of Glossary - LC Availment",
                            "href":"6.4-list-glossary-lc-availment.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Amend Details of LC",
                    "href":"7-amend-details-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Amend LC",
                            "href":"7.1-amend-lc.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Indicate Change of Value for a Field",
                                    "href":"7.1.1-indicate-change-value-field.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Commission and Charges for Amendment",
                                    "href":"7.1.2-commission-and-charges-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Amend Import Pre-advice LC Contract",
                                    "href":"7.1.3-amend-import-advice-lc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.4 </span> Confirm LC Amendment",
                                    "href":"7.1.4-confirm-lc-amendment.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.4.1 </span> Settlement, Commission and Tax Subsystems Amendment",
                                            "href":"7.1.4.1-settlement-commission-and-tax-subsystems-amendment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.4.2 </span> Amendment with Beneficiary Confirmation (AMNV, ACON, AMND)",
                                            "href":"7.1.4.2-amendment-beneficiary-confirmation-amnv-acon-amnd.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.1.4.3 </span> Amendment without Beneficiary Confirmation (AMND)",
                                            "href":"7.1.4.3-amendment-beneficiary-confirmation-amnd.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Utilize Import Licenses",
                            "href":"7.2-utilize-import-licenses.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.2.1 </span> Authorize Amendment Details",
                                    "href":"7.2.1-authorize-amendment-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Confirm Amended Details",
                            "href":"7.3-confirm-amended-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Amend details using the Contract",
                            "href":"7.4-amend-details-using-contract.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> View LC Amendment",
                            "href":"7.5-view-lc-amendment.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> Upload LC Amendment",
                            "href":"7.6-upload-lc-amendment.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Letter of Credit Registration",
                    "href":"8-letter-credit-registration.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Letters of Credit Registration",
                            "href":"8.1-letters-credit-registration.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Letter of Credit Registration Details",
                            "href":"8.2-letter-credit-registration-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> View LC Registration Input",
                            "href":"8.3-view-lc-registration-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> LC Amendment Registration Input",
                            "href":"8.4-lc-amendment-registration-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> List of Glossary - Letter of Credit Registration",
                            "href":"8.5-list-glossary-letter-credit-registration.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Amend Details of LC",
                    "href":"9-amend-details-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> LC Transfer Details",
                            "href":"9.1-lc-transfer-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1.1 </span> Specify LC Transfer Details",
                                    "href":"9.1.1-specify-lc-transfer-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.2 </span> Note on Transfers made from Import and Export LCs",
                                    "href":"9.1.2-note-transfers-made-import-and-export-lcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.3 </span> Authorize LC Transfer",
                                    "href":"9.1.3-authorize-lc-transfer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.4 </span> View Details of Transfers made to the LC",
                                    "href":"9.1.4-view-details-transfers-made-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.5 </span> Amendment In Transferred LC",
                                    "href":"9.1.5-amendment-transferred-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.6 </span> Transfer LC Cancel/Closure",
                                    "href":"9.1.6-transfer-lc-cancel-closure.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Guarantees and Standby Letters of Credit",
                    "href":"10-guarantees-and-standby-letters-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Introduction",
                            "href":"10.1-introduction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Guarantees and Standby Letters of Credit Contract Input",
                            "href":"10.2-guarantees-and-standby-letters-credit-contract-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.2.1 </span> View Guarantees and SBLC Contract Details",
                                    "href":"10.2.1-view-guarantees-and-sblc-contract-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Guarantees and Standby Letters of Credit Amendment",
                            "href":"10.3-guarantees-and-standby-letters-credit-amendment.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.3.1 </span> Process Amendment of Guarantees and SBLC",
                                    "href":"10.3.1-process-amendment-guarantees-and-sblc.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> View Guarantees and SBLC Amendment Details",
                            "href":"10.5-view-guarantees-and-sblc-amendment-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Lodging Guarantee Claim",
                            "href":"10.6-lodging-guarantee-claim.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> View Guarantee Claim Details",
                            "href":"10.7-view-guarantee-claim-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> Guarantee Claim Settlement",
                            "href":"10.8-guarantee-claim-settlement.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.8 </span> View Claim Settlement",
                            "href":"10.9-view-claim-settlement.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.9 </span> Transfer Guarantees and Standby Letters of Credit Transfer Input",
                            "href":"10.10-transfer-guarantees-and-standby-letters-credit-transfer-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.10 </span> View Guarantees and SBLC Transfer Details",
                            "href":"10.11-view-guarantees-and-sblc-transfer-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.11 </span> List of Glossary - Guarantees and Standby Letters of Credit",
                            "href":"10.12-list-glossary-guarantees-and-standby-letters-credit.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Liquidation of Components Maintenance",
                    "href":"11-liquidation-components-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Online Receivable/Payable Details",
                            "href":"11.1-online-receivable-payable-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1.1 </span> Maintain Trade Finance Receivable or Payable Online Details",
                                    "href":"11.1.1-maintain-trade-finance-receivable-or-payable-online-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.2 </span> Liquidate Receivable Components of LC",
                                    "href":"11.1.2-liquidate-receivable-components-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.3 </span> Liquidate Receivable Components of LC Manually",
                                    "href":"11.1.3-liquidate-receivable-components-lc-manually.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.1 </span> Event for Manual Liquidation of LC Charges",
                                            "href":"11.1.3.1-event-manual-liquidation-lc-charges.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.2 </span> Processing Charge for LC Contracts",
                                            "href":"11.1.3.2-processing-charge-lc-contracts.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.3 </span> Processing LC Closure",
                                            "href":"11.1.3.3-processing-lc-closure.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.4 </span> Setup in case advising charges income to be recognized in LC",
                                            "href":"11.1.3.4-setup-case-advising-charges-income-be-recognized-lc.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">10.1.3.5 </span> Processing STP",
                                            "href":"11.1.3.5-processing-stp.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.4 </span> Specify Details of Advices for Liquidation",
                                    "href":"11.1.4-specify-details-advices-liquidation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">10.1.4.1 </span> Accounting Entries passed during Account Receivable Liquidation",
                                            "href":"11.1.4.1-accounting-entries-passed-account-receivable-liquidation.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Generate ACK_TRACER, GUA_CLM_TRACER and CON_TRACER Manually",
                            "href":"11.2-generate-ack_tracer-and-con_tracer-manually.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> List of Glossary - Liquidation of Components Maintenance",
                            "href":"11.3-list-glossary-liquidation-components-lc.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Credit Limit Tracking for LC",
                    "href":"12-credit-limit-tracking-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Introduction",
                            "href":"12.1-introduction.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.1.1 </span> Specify whether Limit Tracking is Required",
                                    "href":"12.1.1-specify-whether-limit-tracking-is-required.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.2 </span> Specify Limit Tracking Tenor",
                                    "href":"12.1.2-specify-limit-tracking-tenor.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.3 </span> Import LC - Non Revolving Limit Utilization",
                                    "href":"12.1.3-import-lc-non-revolving-limit-utilization.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">11.1.4 </span> Indicate Credit Line under which the Liability Amount must be Tracked",
                                    "href":"12.1.4-indicate-credit-line-which-liability-amount-must-be-tracked.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Automatic Processes",
                    "href":"13-automatic-processes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Branch Parameters Details",
                            "href":"13.1-branch-parameters-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">12.1.1 </span> Automatic Closure of LC",
                                    "href":"13.1.9-automatic-closure-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.2 </span> Maintain Branch Parameters",
                                    "href":"13.1.1-maintain-branch-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.3 </span> Process LC Batch",
                                    "href":"13.1.2-process-lc-batch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.4 </span> Automatic Events Executed During Beginning of Day (BOD)",
                                    "href":"13.1.3-automatic-events-executed-beginning-day-bod.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.5 </span> Automatic Liquidation of Periodic Commission",
                                    "href":"13.1.4-automatic-liquidation-periodic-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.6 </span> Automatic Reinstatement of LC",
                                    "href":"13.1.5-automatic-reinstatement-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.7 </span> Automatic Extension of Guarantee/SBLC",
                                    "href":"13.1.6-automatic-extension-guarantee-sblc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.8 </span> LCEOD Batch enhanced to support Liability Change Schedule",
                                    "href":"13.1.7-lceod-batch-enhanced-support-liability-change-schedule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.9 </span> Processes Run during End of Day (EOD)",
                                    "href":"13.1.8-processes-run-end-day-eod.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.10 </span> Automatic Closure of LC",
                                    "href":"13.1.9-automatic-closure-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.11 </span> LC Auto Closure Batch",
                                    "href":"13.1.10-lc-auto-closure-batch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.12 </span> LC Automatic Status Update Batch",
                                    "href":"13.1.11-lc-automatic-status-update-batch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.13 </span> Automatic Accrual of Commission",
                                    "href":"13.1.12-automatic-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.14 </span> Memo Accrual of Commission",
                                    "href":"13.1.13-memo-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.15 </span> Generate Tracers",
                                    "href":"13.1.14-generate-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.16 </span> Execute Tracer Generation Function",
                                    "href":"13.1.15-execute-tracer-generation-function.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.17 </span> Auto Renewal of Open ended guarantees",
                                    "href":"13.1.16-auto-renewal-open-ended-guarantees.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.18 </span> Straight through Processing of SWIFT Messages",
                                    "href":"13.1.17-straight-processing-swift-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.19 </span> STP of MT710 - Advise of Third Bank’s Documentary Credit",
                                    "href":"13.1.18-stp-mt710-advise-third-banks-documentary-credit.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.20 </span> STP of MT707 - Amendment to Documentary Credit",
                                    "href":"13.1.19-stp-mt707-amendment-documentary-credit.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.21 </span> STP of MT730 – Acknowledgment",
                                    "href":"13.1.20-stp-mt730-acknowledgment.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">12.1.21.1 </span> Acknowledgment of MT707",
                                            "href":"13.1.20.1-acknowledgment-mt707.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">12.1.21.2 </span> Acknowledgment of MT710",
                                            "href":"13.1.20.2-acknowledgment-mt710.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.22 </span> STP of MT740 - Authorization to Reimburse",
                                    "href":"13.1.21-stp-mt740-authorization-reimburse.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.23 </span> STP of MT747 – Amendment to an Authorization to Reimburse",
                                    "href":"13.1.22-stp-mt747-amendment-authorization-reimburse.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.24 </span> STP of MT768 – Acknowledgement of a Guarantee Message",
                                    "href":"13.1.23-stp-mt768-acknowledgement-guarantee-message.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.25 </span> STP of MT759 for LCs, Guarantees and SBLCs",
                                    "href":"13.1.24-stp-mt759-lcs-guarantees-and-sblcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.26 </span> STP of MT760 for Guarantees and SBLCs",
                                    "href":"13.1.25-stp-mt760-guarantees-and-sblcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.27 </span> STP of MT765 – Guarantees/SBLCs Demand",
                                    "href":"13.1.26-stp-mt765-advice-guarantees-sblcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.28 </span> STP of MT767 – Guarantees and SBLCs",
                                    "href":"13.1.27-stp-mt767-guarantees-and-sblcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.29 </span> STP of MT786 – Guarantees/SBLCs",
                                    "href":"13.1.28-stp-mt786-guarantees-sblcs.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.30 </span> Revoke Confirmation Contingent Entries Reversal",
                                    "href":"13.1.29-revoke-confirmation-contingent-entries-reversal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">12.1.31 </span> Counter Guarantee Revenue Sharing",
                                    "href":"13.1.30-counter-guarantee-revenue-sharing.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Simulation",
                    "href":"14-simulation.html"
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Annexure A - Accounting Entries for LCs",
                    "href":"15-annexure-accounting-entries-lcs.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Accounting Entries for LCs",
                            "href":"15.1-accounting-entries-lcs.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1.1 </span> LC Events",
                                    "href":"15.1.1-lc-events.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.1.2 </span> Amount Tags",
                                    "href":"15.1.2-amount-tags.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.1.3 </span> Accounting Roles",
                                    "href":"15.1.3-accounting-roles.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Event-wise Accounting Entries",
                            "href":"15.2-event-wise-accounting-entries.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.2.1 </span> BISS: Booking of an import LC",
                                    "href":"15.2.1-biss-booking-import-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.2 </span> AVAL: Availment Under LC",
                                    "href":"15.2.2-aval-availment-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.3 </span> CLOS: Closure of an LC / Guarantee",
                                    "href":"15.2.3-clos-closure-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.4 </span> REIN: Reinstatement of an LC / Guarantee",
                                    "href":"15.2.4-rein-reinstatement-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.5 </span> BADV: Advising an LC",
                                    "href":"15.2.5-badv-advising-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.6 </span> BCFM: Confirming an LC",
                                    "href":"15.2.6-bcfm-confirming-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.7 </span> BPRE: Pre-advising an LC",
                                    "href":"15.2.7-bpre-advising-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.8 </span> BANC: Advising and Confirming An LC",
                                    "href":"15.2.8-banc-advising-and-confirming-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.9 </span> AMND: Amendment",
                                    "href":"15.2.9-amnd-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.10 </span> AOCF: Amendment from Open to Open and Confirm",
                                    "href":"15.2.10-aocf-amendment-open-open-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.11 </span> APAD: Amendment from Pre-advice to Advice",
                                    "href":"15.2.11-apad-amendment-advice-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.12 </span> APAC: Amendment from Pre-advice to Advice and Confirm",
                                    "href":"15.2.12-apac-amendment-advice-advice-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.13 </span> REVR: Reversal of an LC Contract",
                                    "href":"15.2.13-revr-reversal-lc-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.14 </span> REVE: Reversal of an LC Event",
                                    "href":"15.2.14-reve-reversal-lc-event.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.15 </span> ACCR: Accrual of Commission",
                                    "href":"15.2.15-accr-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.16 </span> CALC: Periodic Commission Calculation Date",
                                    "href":"15.2.16-calc-periodic-commission-calculation-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.17 </span> CLIQ: Liquidation of Commission",
                                    "href":"15.2.17-cliq-liquidation-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.18 </span> ROPN: Reopening of an LC",
                                    "href":"15.2.18-ropn-reopening-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.19 </span> CANC: Cancellation of an LC",
                                    "href":"15.2.19-canc-cancellation-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.20 </span> TRGN: Generation of Tracers",
                                    "href":"15.2.20-trgn-generation-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.21 </span> AATC: Amendment from Advice to Confirm",
                                    "href":"15.2.21-aatc-amendment-advice-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.22 </span> RASN: Reassign an LC",
                                    "href":"15.2.22-rasn-reassign-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.23 </span> Transfer of an LC",
                                    "href":"15.2.23-transfer-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.24 </span> RAVL: Reversal of Availment",
                                    "href":"15.2.24-ravl-reversal-availment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.25 </span> BKSG: Booking of Shipping Guarantee",
                                    "href":"15.2.25-bksg-booking-shipping-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.26 </span> CASG: Cancellation of Shipping Guarantee",
                                    "href":"15.2.26-casg-cancellation-shipping-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.27 </span> APRE: Amendment of LC with Pre-advice",
                                    "href":"15.2.27-apre-amendment-lc-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.28 </span> GCLP: Guarantee Claim Settlement",
                                    "href":"15.2.28-gclp-guarantee-claim-settlement.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.29 </span> AASC: Amendment of Advice to Silent Confirmation",
                                    "href":"15.2.29-aasc-amendment-advice-silent-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.30 </span> TRAM: Transfer Amendment",
                                    "href":"15.2.30-tram-transfer-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">14.2.31 </span> RTRA: Reinstatement of Transferred LC Amount",
                                    "href":"15.2.31-rtra-reinstatement-transferred-lc-amount.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Annexure B – Events, Advices and SDEs for LC",
                    "href":"16-annexure-b-events-advices-and-sdes-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> Event - Advices for LCs",
                            "href":"16.1-event-advices-lcs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> LC Advices",
                            "href":"16.2-lc-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">15.2.1 </span> ISB_BEN_CL",
                                    "href":"16.2.1-isb_ben_cl.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.2 </span> GUA_CLAIM_ADV",
                                    "href":"16.2.2-gua_claim_adv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.3 </span> LC_AMND_INSTR (MT 707)",
                                    "href":"16.2.3-lc_amnd_instr-mt-707.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.4 </span> LC_INSTRUMENT (MT 700/MT 701)",
                                    "href":"16.2.4-lc_instrument-mt-700-mt-701.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.5 </span> GUARANTEE (MT 760)",
                                    "href":"16.2.5-guarantee-mt-760.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.6 </span> LC_INSTR_COPY",
                                    "href":"16.2.6-lc_instr_copy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.7 </span> LC_ACK_ADVICE (MT 730)",
                                    "href":"16.2.7-lc_ack_advice-mt-730.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.8 </span> PADV_CL",
                                    "href":"16.2.8-padv_cl.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.9 </span> LC_PRE_ADVICE (MT 705)",
                                    "href":"16.2.9-lc_pre_advice-mt-705.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.10 </span> LC_ACK_AMEND",
                                    "href":"16.2.10-lc_ack_amend.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.11 </span> LC_CASH_COL_ADV",
                                    "href":"16.2.11-lc_cash_col_adv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.12 </span> LC_AMD_AUTH_REB (MT 747)",
                                    "href":"16.2.12-lc_amd_auth_reb-mt-747.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.13 </span> AMD_IMP_CR",
                                    "href":"16.2.13-amd_imp_cr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.14 </span> GUA_AMD_INSTR (MT 767)",
                                    "href":"16.2.14-gua_amd_instr-mt-767.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.15 </span> LC_AM_INST_COPY",
                                    "href":"16.2.15-lc_am_inst_copy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.16 </span> ACK_TRACER",
                                    "href":"16.2.16-ack_tracer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.17 </span> CHG_COM_TRACER",
                                    "href":"16.2.17-chg_com_tracer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.18 </span> CON_TRACER",
                                    "href":"16.2.18-con_tracer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.19 </span> GUA_CLM_TRACER",
                                    "href":"16.2.19-gua_clm_tracer.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.20 </span> LC_CANCEL_ADV",
                                    "href":"16.2.20-lc_cancel_adv.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.21 </span> PADV_TO_ADVCON",
                                    "href":"16.2.21-padv_to_advcon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.22 </span> ADV_TO_ADVCON",
                                    "href":"16.2.22-adv_to_advcon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.23 </span> AMD_EXP_CR",
                                    "href":"16.2.23-amd_exp_cr.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.24 </span> SG_Instrument",
                                    "href":"16.2.24-sg-_instrument.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.25 </span> COMM_ADVICE",
                                    "href":"16.2.24-comm_advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.26 </span> LC Messages",
                                    "href":"16.2.25-lc-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.27 </span> Generate Multiple Copies of LC Instrument",
                                    "href":"16.2.26-generate-multiple-copies-lc-instrument.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.28 </span> Generate Fax 700/707 LC Confirmation Mail Message Copy to Counterparty",
                                    "href":"16.2.27-generate-fax-700-707-lc-confirmation-mail-message-copy-counterparty.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.29 </span> LC event - Messages",
                                    "href":"16.2.28-lc-event-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.30 </span> BISS: Booking of an Import LC/ Shipping Guarantee",
                                    "href":"16.2.29-biss-booking-import-lc-shipping-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.31 </span> AVAL: Availment under LC",
                                    "href":"16.2.30-aval-availment-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.32 </span> CLOS: Closure of an LC / Guarantee",
                                    "href":"16.2.31-clos-closure-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.33 </span> REIN: Reinstatement of an LC / Guarantee",
                                    "href":"16.2.32-rein-reinstatement-lc-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.34 </span> BADV: Advising an LC",
                                    "href":"16.2.33-badv-advising-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.35 </span> BCFM: Confirming an LC",
                                    "href":"16.2.34-bcfm-confirming-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.36 </span> BPRE: Pre-advising an LC",
                                    "href":"16.2.35-bpre-advising-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.37 </span> BANC: Advising and Confirming an LC",
                                    "href":"16.2.36-banc-advising-and-confirming-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.38 </span> REIS: Reissue of Guarantee",
                                    "href":"16.2.37-reis-reissue-guarantee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.39 </span> AMND: LC Amendments",
                                    "href":"16.2.38-amnd-lc-amendments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.40 </span> REVR: Reversal of Contract",
                                    "href":"16.2.39-revr-reversal-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.41 </span> REVR: Reversal of Event",
                                    "href":"16.2.40-revr-reversal-event.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.42 </span> ACCR: Accrual of Commission",
                                    "href":"16.2.41-accr-accrual-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.43 </span> CALC: Periodic Commission Calculation Date",
                                    "href":"16.2.42-calc-periodic-commission-calculation-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.44 </span> CLIQ: Liquidation of Commission",
                                    "href":"16.2.43-cliq-liquidation-commission.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.45 </span> ROPN: Reopening of an LC",
                                    "href":"16.2.44-ropn-reopening-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.46 </span> TRGN: End of Day Check for Tracers",
                                    "href":"16.2.45-ttrgn-end-day-check-tracers.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.47 </span> CANC: Cancellation of an LC",
                                    "href":"16.2.46-canc-cancellation-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.48 </span> APAC: Amendment from Pre-advice to Advice and Confirm",
                                    "href":"16.2.47-apac-amendment-advice-advice-and-confirm.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.49 </span> APAD: Amendment from Pre-advice to Advice",
                                    "href":"16.2.48-apad-amendment-advice-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.50 </span> AMNV: Invitation of Amendment Confirmation",
                                    "href":"16.2.49-amnv-invitation-amendment-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.51 </span> GCEX: Guarantee claim Extension",
                                    "href":"16.2.50-gcex-guarantee-claim-extension.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.52 </span> RASN: Reassign an LC",
                                    "href":"16.2.51-rasn-reassign-lc.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.53 </span> RAVL: Reversal of availment",
                                    "href":"16.2.52-ravl-reversal-availment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.54 </span> CALC: Periodic commission calculation",
                                    "href":"16.2.53-calc-periodic-commission-calculation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.55 </span> Advice Generated for the Insurance Company",
                                    "href":"16.2.54-advice-generated-insurance-company.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.56 </span> Advice Generated for Counterparty",
                                    "href":"16.2.55-advice-generated-counterparty.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">15.2.57 </span> AREJ: Rejection Of Amendment Confirmation",
                                    "href":"16.2.56-arej-rejection-amendment-confirmation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> LC SDEs",
                            "href":"16.3-lc-sdes.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Annexure C - SWIFT Category 7 Messages",
                    "href":"17-annexure-c-swift-category-7-messages.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> List of SWIFT Messages",
                            "href":"17.1-list-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> SWIFT Advices",
                            "href":"17.2-swift-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.3 </span> Details of MT202 (General Financial Institution Transfer)",
                            "href":"17.3-details-mt202-general-financial-institution-transfer.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Annexure D - Letter of Credit Glossary",
                    "href":"18-annexure-d-letter-credit-glossary.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> List of Important Terms",
                            "href":"18.1-list-important-terms.html"
                        }
                    ]
                }
            ]
        }
    ]
});