define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"audience-1-1-2-1-1-1.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"critical-patches.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Related Resources",
                            "href":"related-resources-1-2-2-1-1-1.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"conventions-1-1-1.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"screenshot-disclaimer.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"acronyms-and-abbreviations-1-1-1-1-1-1.html"
                        },
                        {
                            "title":"Basic Actions",
                            "href":"basic-actions.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"symbols-and-icons.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Foreign Exchange Module",
                    "href":"overview-introduction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> System Setup",
                            "href":"system-setup.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Generic Attributes for Foreign Exchange Deals",
                            "href":"generic-attributes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Specify Brokerage",
                            "href":"specify-brokerage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Define tax details",
                            "href":"define-tax-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Track limits",
                            "href":"track-limits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.6 </span> Settlements of FX Contracts",
                            "href":"settlements-fx-contracts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.7 </span> Retrieve FX deal Information",
                            "href":"retrieve-fx-deal-information.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Data Maintenance in FX Module",
                    "href":"data-maintenance-fx-module1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Static Data",
                            "href":"static-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Static Data specific to the FX module",
                            "href":"static-data-specific-fx-module.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Branch Parameters",
                            "href":"branch-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.3.1 </span> Maintain the Branch Parameters",
                                    "href":"maintain-branch-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.2 </span> Specify UDF values",
                                    "href":"specify-udf-values.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Foreign Exchange Yield Calculation Parameters Maintenance",
                            "href":"foreign-exchange-yield-calculation-parameters-maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Method of Application",
                            "href":"method-application.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Discount Rates",
                            "href":"discount-rates.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.6.1 </span> Maintain Discount Rates",
                                    "href":"maintain-discount-rates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.6.2 </span> Query Discount Rates",
                                    "href":"query-discount-rates.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Netting",
                            "href":"netting.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.7.1 </span> Netting Details",
                                    "href":"netting-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.7.2 </span> Maintain Netting Details",
                                    "href":"maintain-netting-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.7.3 </span> Maintain FX Risk Netting Details",
                                    "href":"maintain-fx-risk-netting-details.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.7.3.1 </span> Foreign Exchange Netting Limits Maintenance",
                                            "href":"foreign-exchange-netting-limits-maintenance.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">2.7.4 </span> Specify UDF Values",
                                    "href":"specify-udf-values1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.7.4.1 </span> Default the Credit Lines",
                                            "href":"default-credit-lines.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Confirmation Rule Maintenance Details",
                            "href":"confirmation-rule-maintenance-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Confirmation Rule Maintenance Summary",
                            "href":"confirmation-rule-maintenance-summary.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> FX Confirmation Message Intraday Batch",
                            "href":"fx-confirmation-message-intraday-batch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.11 </span> Confirmation Message Matching",
                            "href":"confirmation-message-matching.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.11.1 </span> Confirmation Message Matching",
                                    "href":"confirmation-message-matching1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.2 </span> View Message Button",
                                    "href":"view-message-button.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.3 </span> View Match Details Button",
                                    "href":"view-match-details-button.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.4 </span> Contract Details",
                                    "href":"contract-details1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.5 </span> View Message",
                                    "href":"view-message.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.6 </span> View Confirmation Message Matching Details",
                                    "href":"view-confirmation-message-matching-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.11.7 </span> Processing of Partially Matched or Unmatched Messages",
                                    "href":"processing-partially-matched-or-unmatched-messages.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.11.7.1 </span> Un-matching Matched Messages",
                                            "href":"un-matching-matched-messages.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Define Attributes Specific to FX Products",
                    "href":"introduction-define-attributes-specific-fx-products.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Spot Deals",
                            "href":"spot-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> FX Products",
                            "href":"fx-products.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.2.1 </span> FX Product Definition",
                                    "href":"fx-product-definition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.2.2 </span> Additional tab",
                                    "href":"additional-tab.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.2.2.1 </span> Define Additional Details",
                                            "href":"display-additional-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.2.2.2 </span> Deal level reversal of Revaluation Entries",
                                            "href":"deal-level-reversal-revaluation-entries.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> ISDA",
                            "href":"isda.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.3.1 </span> ISDA Confirmation Preferences",
                                    "href":"isda-confirmation-preferences.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Product Combinations",
                            "href":"product-combinations.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.4.1 </span> Maintain Product Combinations",
                                    "href":"maintain-product-combinations.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4.2 </span> Foreign Exchange Combination Product Maintenance",
                                    "href":"foreign-exchange-combination-product-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4.3 </span> Maintain Product Category Details for Internal Swap Transactions",
                                    "href":"maintain-product-category-details-internal-swap-transactions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.4.3.1 </span> Internal swap Product Category Maintenance",
                                            "href":"internal-swap-product-category-maintenance.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">3.4.3.2 </span> Validations for Product Category Details for Internal Swap Transactions",
                                            "href":"validations-product-category-details-internal-swap-transactions.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Beginning of Day Operations",
                    "href":"beginning-day-operations-introduction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Forward Rates",
                            "href":"forward-rates.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1.1 </span> Discounting Rates",
                                    "href":"discounting-rates.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Automatic Liquidation of a Contract",
                            "href":"automatic-liquidation-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.2.1 </span> Validations",
                                    "href":"validations.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Description of the function",
                            "href":"description-function.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.3.1 </span> Split Value Dates",
                                    "href":"split-value-dates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.2 </span> Auto rollover",
                                    "href":"auto-rollover.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.3.3 </span> Retrieve information",
                                    "href":"retrieve-information.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Automatic Rollover of a Contract",
                            "href":"automatic-rollover-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.4.1 </span> A Description of the Function or Procedures",
                                    "href":"description-function-or-procedures.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.2 </span> Retrieving Information",
                                    "href":"retrieving-information.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Processing of Contract",
                    "href":"introduction-processing-contract.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> FX Deal",
                            "href":"fx-deal.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.1.1 </span> Initiate an FX deal",
                                    "href":"initiate-fx-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.1.2 </span> Foreign Exchange Contract Input",
                                    "href":"foreign-exchange-contract-input.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Limit Tracking Options",
                            "href":"limit-tracking-options.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Manual Netting",
                            "href":"manual-netting.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Netting Consolidated sub system",
                                    "href":"netting-consolidated-sub-system.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Automatic and Manual FX Netting Batch",
                            "href":"automatic-and-manual-fx-netting-batch.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.4.1 </span> EOD Processing",
                                    "href":"eod-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Manual Netting Process",
                            "href":"manual-netting-process.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> NDF Forward Deal",
                            "href":"ndf-forward-deal.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.6.1 </span> NDF Fixing Deal",
                                    "href":"ndf-fixing-deal.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> FX Limits",
                            "href":"fx-limits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Upload FX contract",
                            "href":"upload-fx-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.8.1 </span> Save an FX Contract",
                                    "href":"fx-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.8.2 </span> Contract with Product Combination",
                                    "href":"contract-product-combination.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.9 </span> FX Contracts with Netted Limits-tracking",
                            "href":"fx-contracts-netted-limits-tracking.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.9.1 </span> Upload",
                                    "href":"upload.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.9.2 </span> Amendment of Uploaded Deals",
                                    "href":"amendment-uploaded-deals.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.9.3 </span> Indicating the Option Period and the Rate",
                                    "href":"indicating-option-period-and-rate.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.9.3.1 </span> Multi Option Details",
                                            "href":"multi-option-details.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.10 </span> View Event Details",
                            "href":"view-event-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.11 </span> Suppress or Prioritize Advices",
                            "href":"suppress-or-prioritize-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.11.1 </span> Contract Advices",
                                    "href":"contract-advices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.11.2 </span> Suppress the Generation of an Advice",
                                    "href":"suppress-generation-advice.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.11.3 </span> Indicate the Priority of an Advice.",
                                    "href":"indicate-priority-advice.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.12 </span> Charge Details",
                            "href":"charge-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.13 </span> Brokerage Details",
                            "href":"brokerage-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.14 </span> Settlement Details",
                            "href":"settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.15 </span> FX Linkage",
                            "href":"fx-linkage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.16 </span> Holiday Preferences",
                            "href":"holiday-preferences.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.16.1 </span> Holiday Preference Example",
                                    "href":"holiday-preference-example.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.17 </span> Split Settlements",
                            "href":"split-settlements.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.18 </span> Limit",
                            "href":"limit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.19 </span> Operations on a Contract",
                            "href":"operations-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.19.1 </span> Amend Deal Details",
                                    "href":"amend-deal-details.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.19.1.1 </span> Account entries for the amendment",
                                            "href":"account-entries-amendment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.19.1.2 </span> Amend a deal involving a product combination",
                                            "href":"amend-deal-involving-product-combination.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.2 </span> Uploading the contracts for amendment",
                                    "href":"uploading-contracts-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.3 </span> Identify Financial and Non-Financial fields for Amendment",
                                    "href":"identify-financial-and-non-financial-fields-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.4 </span> Reversing and Rebooking a Contract",
                                    "href":"reversing-and-rebooking-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.5 </span> Copy Contract Details",
                                    "href":"copy-contract-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.6 </span> Contract Versions",
                                    "href":"contract-versions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.7 </span> Delete a contract",
                                    "href":"delete-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.8 </span> Reverse a contract",
                                    "href":"reverse-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.9 </span> Put a Contract on Hold",
                                    "href":"put-contract-hold.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.10 </span> Multilevel Authorization of a Contract",
                                    "href":"multilevel-authorization-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.11 </span> Authorizing a Contract",
                                    "href":"authorizing-contract.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.19.11.1 </span> Contract Authorization",
                                            "href":"contract-authorization.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.12 </span> Display the Rekey Fields",
                                    "href":"display-rekey-fields.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.13 </span> Capture Change Log",
                                    "href":"capture-change-log.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.14 </span> View Settlement Details",
                                    "href":"view-settlement-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.15 </span> Contract details",
                                    "href":"contract-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.16 </span> Rolling Over a Contract Manually",
                                    "href":"rolling-contract-manually.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.17 </span> Registering Confirmation for a Contract",
                                    "href":"registering-confirmation-contract.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.19.17.1 </span> Contract Summary",
                                            "href":"contract-summary.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.19.17.2 </span> Confirmation Details",
                                            "href":"confirmation-details.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.19.18 </span> Liquidate Contract Manually",
                                    "href":"liquidate-contract-manually.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.20 </span> Liquidation and Cancellation Function",
                            "href":"liquidation-and-cancellation-function.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.20.1 </span> Foreign Exchange Payment Input",
                                    "href":"foreign-exchange-payment-input.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.20.1.1 </span> Deal Rate",
                                            "href":"deal-rate.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">5.20.1.1.1 </span> Specify Settlement Instructions Pickup Details",
                                                    "href":"specify-settlement-instructions-pickup-details.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">5.20.2 </span> Authorize FX Payment Details",
                                    "href":"authorize-fx-payment-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.20.3 </span> Split Settlement",
                                    "href":"split-settlement.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.21 </span> Reassign Contract",
                            "href":"reassign-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.21.1 </span> Reassign Contract to another Users",
                                    "href":"reassign-contract-another-users.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.21.2 </span> FX Payment Details",
                                    "href":"fx-payment-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.21.3 </span> Advanced Search",
                                    "href":"advanced-search.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.21.4 </span> View FX contract",
                                    "href":"view-fx-contract.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.22 </span> FX Affirmation Input Screen",
                            "href":"fx-affirmation-input-screen.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.23 </span> Internal Swap Transactions Details",
                            "href":"internal-swap-transactions-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.23.1 </span> Internal Swap Transactions",
                                    "href":"internal-swap-transactions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.23.2 </span> Validations for Internal Swap Transactions",
                                    "href":"validations-internal-swap-transactions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">5.23.3 </span> Process Internal Swap Transactions",
                                    "href":"process-internal-swap-transactions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">5.23.3.1 </span> Buy Internal Swap Transaction",
                                            "href":"buy-internal-swap-transaction.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">5.23.3.2 </span> Sell Internal Swap Transaction",
                                            "href":"sell-internal-swap-transaction.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">5.24 </span> ISDA Confirmation",
                            "href":"isda-confirmation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.24.1 </span> ISDA Confirm Summary",
                                    "href":"isda-confirm-summary.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Continuous Linked Settlement",
                    "href":"introduction-continuous-linked-settlement.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> CLS Preferences",
                            "href":"cls-preferences.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Maintain the CLS Preferences for the Branch",
                                    "href":"maintain-cls-preferences-branch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Allow Currency to be Settled Inside CLS",
                                    "href":"allow-currency-be-settled-cls.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Identify the Customer as a CLS Participant and Maintain Currency Restrictions",
                                    "href":"identify-customer-cls-participant-and-maintain-currency-restrictions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.4 </span> Maintain CLS Currency Preferences for the Branch",
                                    "href":"maintain-cls-currency-preferences-branch.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.5 </span> Maintain Holidays for CLS Bank",
                                    "href":"maintain-holidays-cls-bank.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.6 </span> Maintain the Participant Type for CLS Customers",
                                    "href":"maintain-participant-type-cls-customers.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.6.1 </span> Upload CLS Directory Information to Oracle Banking Treasury Management",
                                            "href":"upload-cls-directory-information-oracle-banking-treasury-management.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.7 </span> Maintain Settlement Instructions for CLS Deals",
                                    "href":"maintain-settlement-instructions-cls-deals.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.8 </span> Maintain Alert Preferences for CLS deals",
                                    "href":"maintain-alert-preferences-cls-deals.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.1.8.1 </span> The Alert Generation Process",
                                            "href":"alert-generation-process.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.9 </span> Maintain Currency Settlement Linkage",
                                    "href":"maintain-currency-settlement-linkage.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> CLS deal",
                            "href":"cls-deal.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.2.1 </span> Process a CLS deal",
                                    "href":"process-cls-deal1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.2 </span> Check the CLS Eligibility of an FX deal",
                                    "href":"check-cls-eligibility-fx-deal.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.2.2.1 </span> First Level Validations",
                                            "href":"first-level-validations.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.2.2.2 </span> Second Level Check",
                                            "href":"second-level-check.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.2.2.3 </span> Third level validations",
                                            "href":"third-level-validations.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.3 </span> Processing a CLS deal as a non-CLS deal",
                                    "href":"processing-cls-deal-non-cls-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.4 </span> Process a CLS deal",
                                    "href":"process-cls-deal.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.2.4.1 </span> Process uploaded deals",
                                            "href":"process-uploaded-deals.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.5 </span> Message Generation for CLS deals",
                                    "href":"message-generation-cls-deals.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.2.5.1 </span> Generation of the FS Confirmation Message for CLS deals (MT304)",
                                            "href":"generation-fs-confirmation-message-cls-deals-mt304.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">6.2.6 </span> Process CLS Manual Settlement",
                                    "href":"process-cls-manual-settlement.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">6.2.6.1 </span> CLS Net Manual Settlement",
                                            "href":"cls-net-manual-settlement.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.2.6.2 </span> CLS Net Settlement Details",
                                            "href":"cls-net-settlement-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">6.2.6.3 </span> Process",
                                            "href":"process.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Multiple Confirmation Generation for Fund Type Customer",
                    "href":"introduction-multiple-confirmation-generation-fund-typecustomer.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Maintenance",
                            "href":"maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Processing",
                            "href":"processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.2.1 </span> Define Fund type Customer at Treasury Customer Additional details",
                                    "href":"providing-option-capture-fund-type-customer-treasury-customer-additional-details.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> FX Advices and Messages",
                    "href":"introduction-fx-advices-and-messages.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Advices",
                            "href":"advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Messages",
                            "href":"messages.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.2.1 </span> Generate Payment Messages",
                                    "href":"generate-payment-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.2 </span> Generate Receive Messages",
                                    "href":"generate-receive-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.3 </span> Generate User Reference Number in Messages",
                                    "href":"generate-user-reference-number-messages.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.4 </span> Generate Cancellation Request Messages",
                                    "href":"generate-cancellation-request-messages.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> ISO 20022 Standards for Foreign Exchange",
                    "href":"iso-20022-standards-foreign-exchange.html"
                },
                {
                    "title":"<span class=\"secnum\">A </span> Accounting Entries and Advices",
                    "href":"introduction-accounting-entries-and-advices.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A.1 </span> FX Events",
                            "href":"fx-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.2 </span> Amount tags",
                            "href":"amount-tags.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">A.2.1 </span> Accounting Roles",
                                    "href":"accounting-roles.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">A.3 </span> Event-wise Accounting Entries and Advices",
                            "href":"event-wise-accounting-entries-and-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">A.3.1 </span> BOOK Booking an FX contract",
                                    "href":"book-booking-fx-contract.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">A.3.2 </span> AMND Amending",
                                    "href":"amnd-amending.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">A.3.3 </span> REVR Reversal",
                                    "href":"revr-reversal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">A.3.4 </span> SGEN: Settlement Message",
                                    "href":"sgen-settlement-message.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});