define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"audience-1-1-2-1-1-1.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"critical-patches.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Related Resources",
                            "href":"related-resources-1-2-2-1-1-1.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"conventions-1-1-1.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"screenshot-disclaimer.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"acronyms-and-abbreviations-1-1-1-1-1-1.html"
                        },
                        {
                            "title":"Basic Actions",
                            "href":"basic-actions.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"symbols-and-icons.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Money Market Module",
                    "href":"introduction-overview-money-market-module.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> The Product Definition Facility",
                            "href":"product-definition-facility.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1.1 </span> Define Money Market schemes as Products",
                                    "href":"define-money-market-schemes-products.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.2 </span> Advantage of defining a product",
                                    "href":"advantage-defining-product.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Automatic Processing Features",
                            "href":"automatic-processing-features.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Settling or Settlement of Money Market Deals",
                            "href":"settling-settlement-money-market-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Roll Over Deals",
                            "href":"roll-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Track and Retrieve Information",
                            "href":"track-and-retrieve-information.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Define the Attributes of a Money Market Product",
                    "href":"introduction1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Money Market (MM) Product Definition",
                            "href":"money-market-mm-product-definition.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1.1 </span> Prerequisites for the Application Login",
                                    "href":"requisites-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.2 </span> Define a New Product and Static Data",
                                    "href":"define-new-product-and-static-data-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.3 </span> Maintain an Existing Product and Static Data",
                                    "href":"maintain-existing-product-and-static-data-1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.4 </span> Money Market Product Definition Screen",
                                    "href":"money-market-product-definiton-screen.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.5 </span> ICCF Details",
                                    "href":"iccf-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.1.6 </span> Specify Grace Days to Penalty",
                                    "href":"specify-grace-days-penalty.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">2.1.6.1 </span> Grace Days for Multiple Penal Components",
                                            "href":"grace-days-multiple-penal-components.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Process an MM Deal",
                    "href":"process-mm-deal1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Capture Deal Details",
                            "href":"capture-deal-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.1.1 </span> Features of the Contract Details screen",
                                    "href":"features-contract-details-screen.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.1.1.1 </span> Money Market Contract Input",
                                            "href":"money-market-contract-input.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.2 </span> Schedules Tab",
                                    "href":"schedules-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.3 </span> Rollover Tab",
                                    "href":"rollover-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.4 </span> Preferences Tab",
                                    "href":"preferences-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.5 </span> Display Money Market Value Dated Changes Input Summary Details",
                                    "href":"display-money-market-value-dated-changes-input-summary-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.6 </span> Modify a Placement or a Borrowing",
                                    "href":"modify-placement-or-borrowing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.1.7 </span> Display Money Market Contract Details",
                                    "href":"display-money-market-contract-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Financial Details available for Change",
                            "href":"financial-details-available-change.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Display the Other Details of a Deal",
                            "href":"display-other-details-deal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Advices for Deal Initiation",
                            "href":"advices-deal-initiation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> View Event Details",
                            "href":"view-event-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> View Accounting Entries for Deal Initiation",
                            "href":"view-accounting-entries-deal-initiation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Split Settlements",
                            "href":"split-settlements1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> Interest",
                            "href":"interest.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.9 </span> Holiday Preferences",
                            "href":"holiday-preferences.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.9.1 </span> Holiday Validation Assumptions",
                                    "href":"holiday-validation-assumptions.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.10 </span> Different Versions of a Deal",
                            "href":"different-versions-deal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.11 </span> Initiate a Future Value Dated Deal",
                            "href":"initiate-future-value-dated-deal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.12 </span> MM Confirmation Rule Maintenance",
                            "href":"mm-confirmation-rule-maintenance.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.12.1 </span> Process the MM Confirmation Rule Maintenance",
                                    "href":"process-mm-confirmation-rule-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.12.2 </span> View MM Confirmation Rule Maintenance Details",
                                    "href":"view-mm-confirmation-rule-maintenance-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.12.3 </span> Process MM Confirmation Message Intraday Batch",
                                    "href":"process-mm-confirmation-message-intraday-batch.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.13 </span> MM Confirmation Message Matching",
                            "href":"mm-confirmation-message-matching.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.13.1 </span> Process the MM Confirmation Message Matching",
                                    "href":"process-mm-confirmation-message-matching.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.13.2 </span> Process MM Confirmation Message Matching Details",
                                    "href":"process-mm-confirmation-message-matching-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.14 </span> Process Manual Match of the Messages",
                            "href":"process-manual-match-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.15 </span> Display MM Affirmation Input",
                            "href":"display-mm-affirmation-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.16 </span> Authorize a Contract",
                            "href":"authorize-contract.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.16.1 </span> Multilevel Authorization of a Contract",
                                    "href":"multilevel-authorization-contract.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.17 </span> Reassign a Contract to Another User",
                            "href":"reassign-contract-another-user.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.18 </span> Amend Money Market Transactions",
                            "href":"amend-money-market-transactions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.18.1 </span> Authorize Money Market Contracts",
                                    "href":"authorize-money-market-contracts.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.18.2 </span> Split Settlements",
                                    "href":"split-settlements2.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.19 </span> Process the MM Settlement Exception",
                            "href":"process-mm-settlement-exception.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.20 </span> Negative Interest Rate",
                            "href":"negative-interest-rate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.21 </span> SGEN Messages Generation",
                            "href":"sgen-messages-generation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.21.1 </span> RFR Enabling for SGEN",
                                    "href":"rfr-enabling-sgen.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">3.21.1.1 </span> Look back without Payment delay SGEN Generation",
                                            "href":"look-back-payment-delay-sgen-generation.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">3.21.1.1.1 </span> Look back or Lockout with Payment delay SGEN Generation",
                                                    "href":"look-back-or-lockout-payment-delay-sgen-generation.html"
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">3.21.2 </span> Contract Level Message Generation",
                                    "href":"contract-level-message-generation.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Process Repayments",
                    "href":"introduction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Define Schedules for a Product",
                            "href":"define-schedules-product.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Schedule Preferences",
                            "href":"set-product-schedule-preferences.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Define Repayment Schedules",
                            "href":"define-repayment-schedules.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Specify the Contract Preferences",
                            "href":"specify-contract-preferences.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.4.1 </span> Liquidate Back Valued Schedules",
                                    "href":"liquidate-back-valued-schedules.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.2 </span> When the Repayment Schedule Date is a Holiday",
                                    "href":"when-repayment-schedule-date-is-holiday.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.3 </span> Move Schedules Forward or Backward",
                                    "href":"move-schedules-forward-or-backward.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.4 </span> Move Schedule Dates Across the Month",
                                    "href":"move-schedule-dates-month.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.5 </span> Specify the Holiday Currency",
                                    "href":"specify-holiday-currency.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.6 </span> Mode of Liquidation",
                                    "href":"mode-liquidation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.4.7 </span> Cascade Schedules",
                                    "href":"cascade-schedules.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Revision and Repayment Schedules",
                            "href":"revision-and-repayment-schedules.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.5.1 </span> Interest Rate Revision Schedule",
                                    "href":"interest-rate-revision-schedule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.2 </span> Specify the Rate Revision Frequency",
                                    "href":"specify-rate-revision-frequency.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.3 </span> Specify the Rate Revision Dates",
                                    "href":"specify-rate-revision-dates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.4 </span> Build Rate Fixing Schedule",
                                    "href":"build-rate-fixing-schedule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.5 </span> Repayment Schedule",
                                    "href":"repayment-schedule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.6 </span> Interest Repayment Schedules as Different from Rate Revision Schedules",
                                    "href":"interest-repayment-schedules-different-rate-revision-schedules.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.5.7 </span> Specify Schedules for a Deal with a Fixed Interest Rate",
                                    "href":"specify-schedules-deal-fixed-interest-rate.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Redefine Schedules",
                            "href":"redefine-schedules.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Schedule Details",
                            "href":"schedule-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Make Manual Payments",
                            "href":"make-manual-payments.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.8.1 </span> Input of Manual Payments",
                                    "href":"input-manual-payments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.2 </span> Pay Tax",
                                    "href":"pay-tax.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.3 </span> Settlements",
                                    "href":"settlements.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">4.8.3.1 </span> Suppress Messages",
                                            "href":"suppress-messages.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">4.8.3.2 </span> View the Schedule Breakup Details",
                                            "href":"view-schedule-breakup-details.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.4 </span> Delete Manual Payments",
                                    "href":"delete-manual-payments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.8.5 </span> Reverse Manual Payments",
                                    "href":"reverse-manual-payments.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Split Settlements",
                            "href":"split-settlements.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Multiple Confirmation Generation for Fund type customer",
                    "href":"multiple-confirmation-generation-fund-typecustomer.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Maintenance",
                            "href":"maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Confirmation Message - Swift Messages",
                            "href":"confirmation-message-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Processing",
                            "href":"processing.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">5.3.1 </span> Providing option to capture Fund type Customer at Treasury Customer Additional details",
                                    "href":"providing-option-capture-fund-type-customer-treasury-customer-additional-details.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Make Interest Rate Changes",
                    "href":"introduction2.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Navigate to the Schedule Definition Screen",
                            "href":"navigate-schedule-definition-screen.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Change the Maturity Date",
                                    "href":"change-maturity-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Make Changes in the Credit Line",
                                    "href":"make-changes-credit-line.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Make Changes in Interest",
                                    "href":"make-changes-interest.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Settlement Details",
                            "href":"settlement-instructions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Delete Value Dated Changes",
                            "href":"delete-value-dated-changes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Upload the Contracts for Amendment",
                            "href":"upload-contracts-amendment.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Authorization of Changes",
                            "href":"authorization-changes.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Roll Over a Deal",
                    "href":"roll-deal1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Specify Rollover for a Product",
                            "href":"specify-rollover-product.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1.1 </span> Mode of Rollover (Manual or Automatic)",
                                    "href":"mode-rollover-manual-or-automatic.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.1.2 </span> Impact of Liquidation Mode on Rollover",
                                    "href":"impact-liquidation-mode-rollover.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">7.1.2.1 </span> Rollover Details",
                                            "href":"rollover-details.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Specify Contract Rollover Details",
                            "href":"specify-contract-rollover-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Roll over a Contract Manually",
                            "href":"roll-contract-manually.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.3.1 </span> Specify Contract Rollover Preferences",
                                    "href":"specify-contract-rollover-preferences.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.2 </span> Specify Rollover Details of Interest, Charges, and Fee",
                                    "href":"specify-rollover-details-interest-charges-and-fee.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.3 </span> Specify Schedule Basis for Rollover",
                                    "href":"specify-schedule-basis-rollover.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">7.3.4 </span> Specify the Maturity Details",
                                    "href":"specify-maturity-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Process of Rolled over MM Contract",
                            "href":"process-rolled-mm-contract.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> Advices for a Rolled Over Deal",
                            "href":"advices-rolled-deal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.6 </span> Authorize a Manual Rollover",
                            "href":"authorize-manual-rollover.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Automatic Processing",
                    "href":"automatic-processing1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Automatic Events in the Lifecycle of a Deal",
                            "href":"automatic-events-lifecycle-deal.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.1.1 </span> Begin of Day Processes",
                                    "href":"begin-day-processes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.1.2 </span> End of Day Processes",
                                    "href":"end-day-processes.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Specify the Branch Parameters",
                            "href":"specify-branch-parameters.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Initiate the Automatic Contract Update Function",
                            "href":"initiate-automatic-contract-update-function.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.3.1 </span> Process During Beginning of Day",
                                    "href":"process-beginning-day.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.2 </span> Process During End of Day",
                                    "href":"process-end-day.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.3.3 </span> Process for Holidays",
                                    "href":"process-holidays.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Initiate a Future Value Dated Deal",
                            "href":"initiate-future-value-dated-deal1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> Process an Automatic Repayment",
                            "href":"process-automatic-repayment.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.6 </span> Automatic Rollover of a Deal",
                            "href":"automatic-rollover-deal.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.6.1 </span> Advices for Rollover",
                                    "href":"advices-rollover.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.6.2 </span> Automatic Status Changes",
                                    "href":"automatic-status-changes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.6.3 </span> Forward Status Change",
                                    "href":"automatic-status-change.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.6.4 </span> Advices to be Generated for a Status Change",
                                    "href":"advices-be-generated-status-change.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.7 </span> Accrual of ICCF Components",
                            "href":"accrual-iccb-components.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.7.1 </span> Contents of the Accrual Control Journal",
                                    "href":"contents-accrual-control-journal.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.8 </span> Rate Fixing Process",
                            "href":"rate-fixing-process.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.9 </span> Interest Rate Revision on a Deal",
                            "href":"interest-rate-revision-deal.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.10 </span> Value Dated Changes",
                            "href":"value-dated-changes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.10.1 </span> Advices Generated for Value Dated Changes",
                                    "href":"advices-generated-value-dated-changes.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Risk Free Rates",
                    "href":"risk-free-rates2.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Define Rate codes for Risk Free rates",
                            "href":"define-rate-codes-risk-free-rates.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Risk Free Rates",
                            "href":"risk-free-rates1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Treasury Interest Class Definition",
                            "href":"treasury-interest-class-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> Money Market Product",
                            "href":"money-market-product.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Money Market Contract",
                            "href":"money-market-contract.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> Money Market Value Dated changes",
                            "href":"money-market-value-dated-changes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> Lifecycle Process Impact",
                            "href":"lifecycle-process-impact.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Customer Correspondence",
                    "href":"customer-correspondence1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Advices",
                            "href":"advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">10.1.1 </span> Confirm Advices",
                                    "href":"confirm-advices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.2 </span> Rollover Advice for a Placement",
                                    "href":"rollover-advice-placement.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.3 </span> Rollover Advice for a Borrowing",
                                    "href":"rollover-advice-borrowing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.4 </span> Initiate Advice for a Borrowing",
                                    "href":"initiate-advice-borrowing.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">10.1.5 </span> Initiate Advice for a Placement",
                                    "href":"initiate-advice-placement.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Advices Generated during Contract Confirmation",
                            "href":"advices-generated-contract-confirmation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Advice Generated for the Roll-over of a Placement",
                            "href":"advice-generated-roll-placement.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> Advice Generated for the Roll-over of a Borrowing",
                            "href":"advice-generated-roll-borrowing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Advice Generated for the Initiation of a Borrowing",
                            "href":"advice-generated-initiation-borrowing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> Advice Generated for the Initiation of a Placement",
                            "href":"advice-generated-initiation-placement.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.7 </span> Payment Messages",
                            "href":"payment-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.8 </span> Deal Confirmation Matching",
                            "href":"deal-confirmation-matching.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Accounting entries for Money Market",
                    "href":"accounting-entries-money-market.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> MM Events",
                            "href":"mm-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Amount Tags",
                            "href":"amount-tags.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> Accounting Roles",
                            "href":"accounting-roles.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.4 </span> Event-wise Accounting Entries and Advices",
                            "href":"event-wise-accounting-entries-and-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">11.4.1 </span> MM Placement with True Discounted Interest",
                                    "href":"mm-placement-true-discounted-interest.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.1 </span> LIQD: Liquidation",
                                            "href":"liqd-liquidation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.2 </span> VAMB: Value Dated Amendment Booking",
                                            "href":"vamb-value-dated-amendment-booking.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.3 </span> VAMI: Value Dated Amendment Initiation",
                                            "href":"vami-value-dated-amendment-initiation.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.4 </span> CAMD: Contract Amendment",
                                            "href":"camd-contract-amendment.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.5 </span> REVN: Rate Revision",
                                            "href":"revn-rate-revision1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.6 </span> REVC: Reversal",
                                            "href":"revc-reversal.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.1.7 </span> ROLL: Rollover",
                                            "href":"roll-rollover.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">11.4.2 </span> MM Borrowing with Fixed Discounted Interest",
                                    "href":"mm-borrowing-fixed-discounted-interest.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">11.4.2.1 </span> BOOK: Booking a Borrowing with fixed discounted interest",
                                            "href":"book-booking-borrowing-fixed-discounted-interest.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.2.2 </span> MM Placement – Fixed Bearing Interest",
                                            "href":"mm-placement-fixed-bearing-interest.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.2.3 </span> REVN: Rate Revision",
                                            "href":"revn-rate-revision.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">11.4.2.4 </span> MM Borrowing with Fixed Bearing Interest",
                                            "href":"mm-borrowing-fixed-bearing-interest.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">11.5 </span> Entries for contracts liquidated with Previous Year Adjustment option",
                            "href":"entries-contracts-liquidated-previous-year-adjustment-option.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.6 </span> Multiple Media Support",
                            "href":"multiple-media-support.html"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});