define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"About the REST APIs",
                    "href":"index.html"
                },
                {
                    "title":"All REST Endpoints",
                    "href":"rest-endpoints.html"
                }
            ]
        },
        {
            "heading":"Tasks",
            "topics":[
                {
                    "title":"Collateral Margin and Settlement Netting",
                    "topics":[
                        {
                            "title":"MarginProductMaintenance",
                            "href":"api-collateral-margin-and-settlement-netting-marginproductmaintenance.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-authorizeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-closeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-createproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-deleteproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-modifyproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenProduct",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-reopenproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-marginproductmaintenanceservice-marginproductmaintenance-queryproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Derivatives",
                    "topics":[
                        {
                            "title":"Confirmation",
                            "href":"api-derivatives-confirmation.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeDVConfirmation",
                                    "href":"op-confirmationservice-confirmation-authorizedvconfirmation-post.html"
                                },
                                {
                                    "title":"Operation to DeleteDVConfirmation",
                                    "href":"op-confirmationservice-confirmation-deletedvconfirmation-post.html"
                                },
                                {
                                    "title":"Operation to ModifyDVConfirmation",
                                    "href":"op-confirmationservice-confirmation-modifydvconfirmation-post.html"
                                },
                                {
                                    "title":"Query by contractref",
                                    "href":"op-confirmationservice-confirmation-querydvconfirmation-contractref-contractref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"DerivativesContract",
                            "href":"api-derivatives-derivativescontract.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-authorizedvcontract-post.html"
                                },
                                {
                                    "title":"Operation to CloseDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-closedvcontract-post.html"
                                },
                                {
                                    "title":"Operation to CreateDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-createdvcontract-post.html"
                                },
                                {
                                    "title":"Operation to DeleteDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-deletedvcontract-post.html"
                                },
                                {
                                    "title":"Operation to ModifyDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-modifydvcontract-post.html"
                                },
                                {
                                    "title":"Operation to ReverseDVContract",
                                    "href":"op-derivativescontractservice-derivativescontract-reversedvcontract-post.html"
                                },
                                {
                                    "title":"Query by cntref",
                                    "href":"op-derivativescontractservice-derivativescontract-querydvcontract-cntref-cntref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"DerivativesFloatingRates",
                            "href":"api-derivatives-derivativesfloatingrates.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-authorizecfdflrae-post.html"
                                },
                                {
                                    "title":"Operation to CloseCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-closecfdflrae-post.html"
                                },
                                {
                                    "title":"Operation to CreateCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-createcfdflrae-post.html"
                                },
                                {
                                    "title":"Operation to DeleteCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-deletecfdflrae-post.html"
                                },
                                {
                                    "title":"Operation to ModifyCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-modifycfdflrae-post.html"
                                },
                                {
                                    "title":"Operation to ReopenCFDFLRAE",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-reopencfdflrae-post.html"
                                },
                                {
                                    "title":"Query by branch & rateCode & tenorCode & ccyCode & effectiveDate",
                                    "href":"op-derivativesfloatingratesservice-derivativesfloatingrates-querycfdflrae-branch-branch-ratecode-ratecode-tenorcode-tenorcode-ccycode-ccycode-effectivedate-effectivedate-get.html"
                                }
                            ]
                        },
                        {
                            "title":"DerivativesManualPayment",
                            "href":"api-derivatives-derivativesmanualpayment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeDVManulPay",
                                    "href":"op-derivativesmanualpaymentservice-derivativesmanualpayment-authorizedvmanulpay-post.html"
                                },
                                {
                                    "title":"Operation to CreateDVManulPay",
                                    "href":"op-derivativesmanualpaymentservice-derivativesmanualpayment-createdvmanulpay-post.html"
                                },
                                {
                                    "title":"Operation to DeleteDVManulPay",
                                    "href":"op-derivativesmanualpaymentservice-derivativesmanualpayment-deletedvmanulpay-post.html"
                                },
                                {
                                    "title":"Query by transactionRefNo",
                                    "href":"op-derivativesmanualpaymentservice-derivativesmanualpayment-querydvmanulpay-transactionrefno-transactionrefno-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Exchange Traded Derivatives",
                    "topics":[
                        {
                            "title":"ExchangeDerivativesDealProductDefinition",
                            "href":"api-exchange-traded-derivatives-exchangederivativesdealproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-authorizedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-closedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-createdealproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-deletedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-modifydealproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenDealProduct",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-reopendealproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-exchangederivativesdealproductdefinitionservice-exchangederivativesdealproductdefinition-querydealproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ExchangeDerivativesInstrumentProductDefinition",
                            "href":"api-exchange-traded-derivatives-exchangederivativesinstrumentproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-authorizeinstrproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-closeinstrproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-createinstrproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-deleteinstrproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-modifyinstrproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenInstrProduct",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-reopeninstrproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-exchangederivativesinstrumentproductdefinitionservice-exchangederivativesinstrumentproductdefinition-queryinstrproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ExchangeDerivativesPortfolioProductDefinition",
                            "href":"api-exchange-traded-derivatives-exchangederivativesportfolioproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizePorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-authorizeporfolioproduct-post.html"
                                },
                                {
                                    "title":"Operation to ClosePorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-closeporfolioproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreatePorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-createporfolioproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeletePorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-deleteporfolioproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyPorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-modifyporfolioproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenPorfolioProduct",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-reopenporfolioproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-exchangederivativesportfolioproductdefinitionservice-exchangederivativesportfolioproductdefinition-queryporfolioproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Foreign Exchange",
                    "topics":[
                        {
                            "title":"ForeignCurrencyExchangeRates",
                            "href":"api-foreign-exchange-foreigncurrencyexchangerates.html",
                            "topics":[
                                {
                                    "title":"Query by brncd & ccy1 & ccy2",
                                    "href":"op-foreigncurrencyexchangeratesservice-foreigncurrencyexchangerates-queryfxcurrencyrate-brncd-brncd-ccy1-ccy1-ccy2-ccy2-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangeBranchParametersMaintenance",
                            "href":"api-foreign-exchange-foreignexchangebranchparametersmaintenance.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-authorizebrnprm-post.html"
                                },
                                {
                                    "title":"Operation to CloseBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-closebrnprm-post.html"
                                },
                                {
                                    "title":"Operation to CreateBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-createbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to DeleteBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-deletebrnprm-post.html"
                                },
                                {
                                    "title":"Operation to ModifyBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-modifybrnprm-post.html"
                                },
                                {
                                    "title":"Operation to ReopenBrnPrm",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-reopenbrnprm-post.html"
                                },
                                {
                                    "title":"Query by brncd",
                                    "href":"op-foreignexchangebranchparametersmaintenanceservice-foreignexchangebranchparametersmaintenance-querybrnprm-brncd-brncd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangeContract",
                            "href":"api-foreign-exchange-foreignexchangecontract.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-authorizecontract-post.html"
                                },
                                {
                                    "title":"Operation to CreateContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-createcontract-post.html"
                                },
                                {
                                    "title":"Operation to DeleteContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-deletecontract-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-liquidatecontract-post.html"
                                },
                                {
                                    "title":"Operation to ModifyContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-modifycontract-post.html"
                                },
                                {
                                    "title":"Operation to ReverseContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-reversecontract-post.html"
                                },
                                {
                                    "title":"Operation to RolloverContract",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-rollovercontract-post.html"
                                },
                                {
                                    "title":"Query by contrefnno",
                                    "href":"op-foreignexchangecontractservice-foreignexchangecontract-querycontract-contrefnno-contrefnno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangeContractAffirmation",
                            "href":"api-foreign-exchange-foreignexchangecontractaffirmation.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeFXAffirm",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-authorizefxaffirm-post.html"
                                },
                                {
                                    "title":"Operation to CloseFXAffirm",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-closefxaffirm-post.html"
                                },
                                {
                                    "title":"Operation to CreateFXAffirm",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-createfxaffirm-post.html"
                                },
                                {
                                    "title":"Operation to DeleteFXAffirm",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-deletefxaffirm-post.html"
                                },
                                {
                                    "title":"Operation to ModifyFXAffirm",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-modifyfxaffirm-post.html"
                                },
                                {
                                    "title":"Query by contractRefNo",
                                    "href":"op-foreignexchangecontractaffirmationservice-foreignexchangecontractaffirmation-queryfxaffirm-contractrefno-contractrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangeInternalSwap",
                            "href":"api-foreign-exchange-foreignexchangeinternalswap.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-authorizeintswap-post.html"
                                },
                                {
                                    "title":"Operation to CloseIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-closeintswap-post.html"
                                },
                                {
                                    "title":"Operation to CreateIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-createintswap-post.html"
                                },
                                {
                                    "title":"Operation to DeleteIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-deleteintswap-post.html"
                                },
                                {
                                    "title":"Operation to ModifyIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-modifyintswap-post.html"
                                },
                                {
                                    "title":"Operation to ReopenIntSwap",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-reopenintswap-post.html"
                                },
                                {
                                    "title":"Query by extdealrfno",
                                    "href":"op-foreignexchangeinternalswapservice-foreignexchangeinternalswap-queryintswap-extdealrfno-extdealrfno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangePayment",
                            "href":"api-foreign-exchange-foreignexchangepayment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizePayment",
                                    "href":"op-foreignexchangepaymentservice-foreignexchangepayment-authorizepayment-post.html"
                                },
                                {
                                    "title":"Operation to CreatePayment",
                                    "href":"op-foreignexchangepaymentservice-foreignexchangepayment-createpayment-post.html"
                                },
                                {
                                    "title":"Operation to DeletePayment",
                                    "href":"op-foreignexchangepaymentservice-foreignexchangepayment-deletepayment-post.html"
                                },
                                {
                                    "title":"Operation to ReversePayment",
                                    "href":"op-foreignexchangepaymentservice-foreignexchangepayment-reversepayment-post.html"
                                },
                                {
                                    "title":"Query by refno",
                                    "href":"op-foreignexchangepaymentservice-foreignexchangepayment-querypayment-refno-refno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForeignExchangeProduct",
                            "href":"api-foreign-exchange-foreignexchangeproduct.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-authorizeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-closeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-createproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-deleteproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-modifyproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenProduct",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-reopenproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-foreignexchangeproductservice-foreignexchangeproduct-queryproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"FXLink",
                            "href":"api-foreign-exchange-fxlink.html",
                            "topics":[
                                {
                                    "title":"Operation to CreateFXLink",
                                    "href":"op-fxlinkservice-fxlink-createfxlink-post.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Islamic Derivatives",
                    "topics":[
                        {
                            "title":"IslamicConfirmation",
                            "href":"api-islamic-derivatives-islamicconfirmation.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeIDConfirmation",
                                    "href":"op-islamicconfirmationservice-islamicconfirmation-authorizeidconfirmation-post.html"
                                },
                                {
                                    "title":"Operation to DeleteIDConfirmation",
                                    "href":"op-islamicconfirmationservice-islamicconfirmation-deleteidconfirmation-post.html"
                                },
                                {
                                    "title":"Operation to ModifyIDConfirmation",
                                    "href":"op-islamicconfirmationservice-islamicconfirmation-modifyidconfirmation-post.html"
                                },
                                {
                                    "title":"Query by contractref",
                                    "href":"op-islamicconfirmationservice-islamicconfirmation-queryidconfirmation-contractref-contractref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"IslamicDerivativeCommodityTracking",
                            "href":"api-islamic-derivatives-islamicderivativecommoditytracking.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeIDCommodity",
                                    "href":"op-islamicderivativecommoditytrackingservice-islamicderivativecommoditytracking-authorizeidcommodity-post.html"
                                },
                                {
                                    "title":"Operation to CreateIDCommodity",
                                    "href":"op-islamicderivativecommoditytrackingservice-islamicderivativecommoditytracking-createidcommodity-post.html"
                                },
                                {
                                    "title":"Operation to DeleteIDCommodity",
                                    "href":"op-islamicderivativecommoditytrackingservice-islamicderivativecommoditytracking-deleteidcommodity-post.html"
                                },
                                {
                                    "title":"Operation to ModifyIDCommodity",
                                    "href":"op-islamicderivativecommoditytrackingservice-islamicderivativecommoditytracking-modifyidcommodity-post.html"
                                },
                                {
                                    "title":"Query by conrefno",
                                    "href":"op-islamicderivativecommoditytrackingservice-islamicderivativecommoditytracking-queryidcommodity-conrefno-conrefno-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Islamic Money Market",
                    "topics":[
                        {
                            "title":"IslamicMoneyMarketContract",
                            "href":"api-islamic-money-market-islamicmoneymarketcontract.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-authorizemcicontract-post.html"
                                },
                                {
                                    "title":"Operation to CloseMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-closemcicontract-post.html"
                                },
                                {
                                    "title":"Operation to ConfirmMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-confirmmcicontract-post.html"
                                },
                                {
                                    "title":"Operation to CreateMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-createmcicontract-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-deletemcicontract-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-liquidatemcicontract-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-modifymcicontract-post.html"
                                },
                                {
                                    "title":"Operation to ReverseMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-reversemcicontract-post.html"
                                },
                                {
                                    "title":"Operation to RolloverMCIContract",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-rollovermcicontract-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-islamicmoneymarketcontractservice-islamicmoneymarketcontract-querymcicontract-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"IslamicMoneyMarketPayment",
                            "href":"api-islamic-money-market-islamicmoneymarketpayment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMCPayment",
                                    "href":"op-islamicmoneymarketpaymentservice-islamicmoneymarketpayment-authorizemcpayment-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMCPayment",
                                    "href":"op-islamicmoneymarketpaymentservice-islamicmoneymarketpayment-deletemcpayment-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMCPayment",
                                    "href":"op-islamicmoneymarketpaymentservice-islamicmoneymarketpayment-modifymcpayment-post.html"
                                },
                                {
                                    "title":"Operation to ReverseMCPayment",
                                    "href":"op-islamicmoneymarketpaymentservice-islamicmoneymarketpayment-reversemcpayment-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-islamicmoneymarketpaymentservice-islamicmoneymarketpayment-querymcpayment-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"IslamicMoneyMarketProductDefinition",
                            "href":"api-islamic-money-market-islamicmoneymarketproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-authorizeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-closeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-createproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-deleteproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-modifyproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenProduct",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-reopenproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-islamicmoneymarketproductdefinitionservice-islamicmoneymarketproductdefinition-queryproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Money Market",
                    "topics":[
                        {
                            "title":"MMBranchParameters",
                            "href":"api-money-market-mmbranchparameters.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-authorizemmbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to CloseMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-closemmbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to CreateMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-createmmbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-deletemmbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-modifymmbrnprm-post.html"
                                },
                                {
                                    "title":"Operation to ReopenMMBrnPrm",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-reopenmmbrnprm-post.html"
                                },
                                {
                                    "title":"Query by brncd",
                                    "href":"op-mmbranchparametersservice-mmbranchparameters-querymmbrnprm-brncd-brncd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MoneyMarketAffirmation",
                            "href":"api-money-market-moneymarketaffirmation.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMMAffirm",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-authorizemmaffirm-post.html"
                                },
                                {
                                    "title":"Operation to CloseMMAffirm",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-closemmaffirm-post.html"
                                },
                                {
                                    "title":"Operation to CreateMMAffirm",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-createmmaffirm-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMMAffirm",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-deletemmaffirm-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMMAffirm",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-modifymmaffirm-post.html"
                                },
                                {
                                    "title":"Query by contractRefNo & versionNo",
                                    "href":"op-moneymarketaffirmationservice-moneymarketaffirmation-querymmaffirm-contractrefno-contractrefno-versionno-versionno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MoneyMarketContract",
                            "href":"api-money-market-moneymarketcontract.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-authorizemmcontract-post.html"
                                },
                                {
                                    "title":"Operation to CloseMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-closemmcontract-post.html"
                                },
                                {
                                    "title":"Operation to ConfirmMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-confirmmmcontract-post.html"
                                },
                                {
                                    "title":"Operation to CreateMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-createmmcontract-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-deletemmcontract-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-liquidatemmcontract-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-modifymmcontract-post.html"
                                },
                                {
                                    "title":"Operation to ReverseMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-reversemmcontract-post.html"
                                },
                                {
                                    "title":"Operation to RolloverMMContract",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-rollovermmcontract-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-moneymarketcontractservice-moneymarketcontract-querymmcontract-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MoneyMarketPayment",
                            "href":"api-money-market-moneymarketpayment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMMPayment",
                                    "href":"op-moneymarketpaymentservice-moneymarketpayment-authorizemmpayment-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMMPayment",
                                    "href":"op-moneymarketpaymentservice-moneymarketpayment-deletemmpayment-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMMPayment",
                                    "href":"op-moneymarketpaymentservice-moneymarketpayment-modifymmpayment-post.html"
                                },
                                {
                                    "title":"Operation to ReverseMMPayment",
                                    "href":"op-moneymarketpaymentservice-moneymarketpayment-reversemmpayment-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-moneymarketpaymentservice-moneymarketpayment-querymmpayment-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MoneyMarketProduct",
                            "href":"api-money-market-moneymarketproduct.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-authorizeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-closeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-createproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-deleteproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-modifyproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenProduct",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-reopenproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-moneymarketproductservice-moneymarketproduct-queryproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MoneyMarketValueDatedAmendment",
                            "href":"api-money-market-moneymarketvaluedatedamendment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMMVAmend",
                                    "href":"op-moneymarketvaluedatedamendmentservice-moneymarketvaluedatedamendment-authorizemmvamend-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMMVAmend",
                                    "href":"op-moneymarketvaluedatedamendmentservice-moneymarketvaluedatedamendment-deletemmvamend-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMMVAmend",
                                    "href":"op-moneymarketvaluedatedamendmentservice-moneymarketvaluedatedamendment-modifymmvamend-post.html"
                                },
                                {
                                    "title":"Query by contractRefNo",
                                    "href":"op-moneymarketvaluedatedamendmentservice-moneymarketvaluedatedamendment-querymmvamend-contractrefno-contractrefno-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Options",
                    "topics":[
                        {
                            "title":"KnockInKnockOut",
                            "href":"api-options-knockinknockout.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeKnockinKnockout",
                                    "href":"op-knockinknockoutservice-knockinknockout-authorizeknockinknockout-post.html"
                                },
                                {
                                    "title":"Operation to CreateKnockinKnockout",
                                    "href":"op-knockinknockoutservice-knockinknockout-createknockinknockout-post.html"
                                },
                                {
                                    "title":"Operation to DeleteKnockinKnockout",
                                    "href":"op-knockinknockoutservice-knockinknockout-deleteknockinknockout-post.html"
                                },
                                {
                                    "title":"Operation to ModifyKnockinKnockout",
                                    "href":"op-knockinknockoutservice-knockinknockout-modifyknockinknockout-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-knockinknockoutservice-knockinknockout-queryknockinknockout-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"OptionBranchParameter",
                            "href":"api-options-optionbranchparameter.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeOTBrnParam",
                                    "href":"op-optionbranchparameterservice-optionbranchparameter-authorizeotbrnparam-post.html"
                                },
                                {
                                    "title":"Operation to CreateOTBrnParam",
                                    "href":"op-optionbranchparameterservice-optionbranchparameter-createotbrnparam-post.html"
                                },
                                {
                                    "title":"Operation to DeleteOTBrnParam",
                                    "href":"op-optionbranchparameterservice-optionbranchparameter-deleteotbrnparam-post.html"
                                },
                                {
                                    "title":"Operation to ModifyOTBrnParam",
                                    "href":"op-optionbranchparameterservice-optionbranchparameter-modifyotbrnparam-post.html"
                                },
                                {
                                    "title":"Query by branchCode",
                                    "href":"op-optionbranchparameterservice-optionbranchparameter-queryotbrnparam-branchcode-branchcode-get.html"
                                }
                            ]
                        },
                        {
                            "title":"OptionContractExercise",
                            "href":"api-options-optioncontractexercise.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeExcercise",
                                    "href":"op-optioncontractexerciseservice-optioncontractexercise-authorizeexcercise-post.html"
                                },
                                {
                                    "title":"Operation to CreateExcercise",
                                    "href":"op-optioncontractexerciseservice-optioncontractexercise-createexcercise-post.html"
                                },
                                {
                                    "title":"Operation to DeleteExcercise",
                                    "href":"op-optioncontractexerciseservice-optioncontractexercise-deleteexcercise-post.html"
                                },
                                {
                                    "title":"Query by contref",
                                    "href":"op-optioncontractexerciseservice-optioncontractexercise-queryexcercise-contref-contref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"OptionsContractInput",
                            "href":"api-options-optionscontractinput.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeContract",
                                    "href":"op-optionscontractinputservice-optionscontractinput-authorizecontract-post.html"
                                },
                                {
                                    "title":"Operation to CreateContract",
                                    "href":"op-optionscontractinputservice-optionscontractinput-createcontract-post.html"
                                },
                                {
                                    "title":"Operation to DeleteContract",
                                    "href":"op-optionscontractinputservice-optionscontractinput-deletecontract-post.html"
                                },
                                {
                                    "title":"Operation to ModifyContract",
                                    "href":"op-optionscontractinputservice-optionscontractinput-modifycontract-post.html"
                                },
                                {
                                    "title":"Operation to ReverseContract",
                                    "href":"op-optionscontractinputservice-optionscontractinput-reversecontract-post.html"
                                },
                                {
                                    "title":"Query by fcref",
                                    "href":"op-optionscontractinputservice-optionscontractinput-querycontract-fcref-fcref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"OptionsOtherExposuresMaintenance",
                            "href":"api-options-optionsotherexposuresmaintenance.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeOTLimval",
                                    "href":"op-optionsotherexposuresmaintenanceservice-optionsotherexposuresmaintenance-authorizeotlimval-post.html"
                                },
                                {
                                    "title":"Operation to ModifyOTLimval",
                                    "href":"op-optionsotherexposuresmaintenanceservice-optionsotherexposuresmaintenance-modifyotlimval-post.html"
                                }
                            ]
                        },
                        {
                            "title":"OptionsProductDefinition",
                            "href":"api-options-optionsproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-authorizeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-closeproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-createproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-deleteproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-modifyproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenProduct",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-reopenproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-optionsproductdefinitionservice-optionsproductdefinition-queryproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Securities",
                    "topics":[
                        {
                            "title":"BonustoCashInput",
                            "href":"api-securities-bonustocashinput.html",
                            "topics":[
                                {
                                    "title":"Query by branchCode & seInternalActionId & referenceNo & skLocation & skAccount",
                                    "href":"op-bonustocashinputservice-bonustocashinput-querysecashdefinition-branchcode-branchcode-seinternalactionid-seinternalactionid-referenceno-referenceno-sklocation-sklocation-skaccount-skaccount-get.html"
                                }
                            ]
                        },
                        {
                            "title":"CDDeal",
                            "href":"api-securities-cddeal.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeCDDeal",
                                    "href":"op-cddealservice-cddeal-authorizecddeal-post.html"
                                },
                                {
                                    "title":"Operation to CloseCDDeal",
                                    "href":"op-cddealservice-cddeal-closecddeal-post.html"
                                },
                                {
                                    "title":"Operation to ConfirmCDDeal",
                                    "href":"op-cddealservice-cddeal-confirmcddeal-post.html"
                                },
                                {
                                    "title":"Operation to CreateCDDeal",
                                    "href":"op-cddealservice-cddeal-createcddeal-post.html"
                                },
                                {
                                    "title":"Operation to DeleteCDDeal",
                                    "href":"op-cddealservice-cddeal-deletecddeal-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateCDDeal",
                                    "href":"op-cddealservice-cddeal-liquidatecddeal-post.html"
                                },
                                {
                                    "title":"Operation to ModifyCDDeal",
                                    "href":"op-cddealservice-cddeal-modifycddeal-post.html"
                                },
                                {
                                    "title":"Operation to ReopenCDDeal",
                                    "href":"op-cddealservice-cddeal-reopencddeal-post.html"
                                },
                                {
                                    "title":"Operation to ReverseCDDeal",
                                    "href":"op-cddealservice-cddeal-reversecddeal-post.html"
                                },
                                {
                                    "title":"Operation to RolloverCDDeal",
                                    "href":"op-cddealservice-cddeal-rollovercddeal-post.html"
                                },
                                {
                                    "title":"Query by dealref",
                                    "href":"op-cddealservice-cddeal-querycddeal-dealref-dealref-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesBlockOrReleaseBlock",
                            "href":"api-securities-securitiesblockorreleaseblock.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSEDealBlockRelease",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-authorizesedealblockrelease-post.html"
                                },
                                {
                                    "title":"Operation to CreateSEDealBlockRelease",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-createsedealblockrelease-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSEDealBlockRelease",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-deletesedealblockrelease-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateSEDealBlockRelease",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-liquidatesedealblockrelease-post.html"
                                },
                                {
                                    "title":"Operation to ModifySEDealBlockRelease",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-modifysedealblockrelease-post.html"
                                },
                                {
                                    "title":"Query by dlrf",
                                    "href":"op-securitiesblockorreleaseblockservice-securitiesblockorreleaseblock-querysedealblockrelease-dlrf-dlrf-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesBranchParameters",
                            "href":"api-securities-securitiesbranchparameters.html",
                            "topics":[
                                {
                                    "title":"Query by brncd",
                                    "href":"op-securitiesbranchparametersservice-securitiesbranchparameters-querysebrnprm-brncd-brncd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesBulkDeal",
                            "href":"api-securities-securitiesbulkdeal.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-authorizesecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to CloseSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-closesecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to ConfirmSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-confirmsecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to CreateSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-createsecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-deletesecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to LiquidateSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-liquidatesecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to ModifySecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-modifysecblockdeal-post.html"
                                },
                                {
                                    "title":"Operation to ReverseSecBlockDeal",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-reversesecblockdeal-post.html"
                                },
                                {
                                    "title":"Query by dealrefno",
                                    "href":"op-securitiesbulkdealservice-securitiesbulkdeal-querysecblockdeal-dealrefno-dealrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesCDInstrumentPrd",
                            "href":"api-securities-securitiescdinstrumentprd.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-authorizecdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Operation to CloseCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-closecdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Operation to CreateCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-createcdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Operation to DeleteCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-deletecdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Operation to ModifyCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-modifycdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Operation to ReopenCDInstrumentPrd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-reopencdinstrumentprd-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-securitiescdinstrumentprdservice-securitiescdinstrumentprd-querycdinstrumentprd-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesCorporateActionRedemption",
                            "href":"api-securities-securitiescorporateactionredemption.html",
                            "topics":[
                                {
                                    "title":"Query by iacd",
                                    "href":"op-securitiescorporateactionredemptionservice-securitiescorporateactionredemption-queryseredmdef-iacd-iacd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesCouponRateRevision",
                            "href":"api-securities-securitiescouponraterevision.html",
                            "topics":[
                                {
                                    "title":"Query by seInternalActionId",
                                    "href":"op-securitiescouponraterevisionservice-securitiescouponraterevision-queryseintraterevision-seinternalactionid-seinternalactionid-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesDealProductDefinition",
                            "href":"api-securities-securitiesdealproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-authorizedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-closedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-createdealproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-deletedealproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-modifydealproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenDealProduct",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-reopendealproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-securitiesdealproductdefinitionservice-securitiesdealproductdefinition-querydealproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesInterestCoupon",
                            "href":"api-securities-securitiesinterestcoupon.html",
                            "topics":[
                                {
                                    "title":"Query by inad",
                                    "href":"op-securitiesinterestcouponservice-securitiesinterestcoupon-querysecpndefinition-inad-inad-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesMarket",
                            "href":"api-securities-securitiesmarket.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSEMarketCode",
                                    "href":"op-securitiesmarketservice-securitiesmarket-authorizesemarketcode-post.html"
                                },
                                {
                                    "title":"Operation to CreateSEMarketCode",
                                    "href":"op-securitiesmarketservice-securitiesmarket-createsemarketcode-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSEMarketCode",
                                    "href":"op-securitiesmarketservice-securitiesmarket-deletesemarketcode-post.html"
                                },
                                {
                                    "title":"Operation to ModifySEMarketCode",
                                    "href":"op-securitiesmarketservice-securitiesmarket-modifysemarketcode-post.html"
                                },
                                {
                                    "title":"Query by mktcd",
                                    "href":"op-securitiesmarketservice-securitiesmarket-querysemarketcode-mktcd-mktcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesMarketPrice",
                            "href":"api-securities-securitiesmarketprice.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSEMarketPriceCodes",
                                    "href":"op-securitiesmarketpriceservice-securitiesmarketprice-authorizesemarketpricecodes-post.html"
                                },
                                {
                                    "title":"Operation to CreateSEMarketPriceCodes",
                                    "href":"op-securitiesmarketpriceservice-securitiesmarketprice-createsemarketpricecodes-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSEMarketPriceCodes",
                                    "href":"op-securitiesmarketpriceservice-securitiesmarketprice-deletesemarketpricecodes-post.html"
                                },
                                {
                                    "title":"Operation to ModifySEMarketPriceCodes",
                                    "href":"op-securitiesmarketpriceservice-securitiesmarketprice-modifysemarketpricecodes-post.html"
                                },
                                {
                                    "title":"Query by priceCode",
                                    "href":"op-securitiesmarketpriceservice-securitiesmarketprice-querysemarketpricecodes-pricecode-pricecode-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesPrice",
                            "href":"api-securities-securitiesprice.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-authorizesepricedetail-post.html"
                                },
                                {
                                    "title":"Operation to CloseSEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-closesepricedetail-post.html"
                                },
                                {
                                    "title":"Operation to CreateSEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-createsepricedetail-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-deletesepricedetail-post.html"
                                },
                                {
                                    "title":"Operation to ModifySEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-modifysepricedetail-post.html"
                                },
                                {
                                    "title":"Operation to ReopenSEPriceDetail",
                                    "href":"op-securitiespriceservice-securitiesprice-reopensepricedetail-post.html"
                                },
                                {
                                    "title":"Query by securityCode & brn1",
                                    "href":"op-securitiespriceservice-securitiesprice-querysepricedetail-securitycode-securitycode-brn1-brn1-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesSecurityProductDefinition",
                            "href":"api-securities-securitiessecurityproductdefinition.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-authorizesecurityproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseSecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-closesecurityproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateSecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-createsecurityproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-deletesecurityproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifySecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-modifysecurityproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenSecurityProduct",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-reopensecurityproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-securitiessecurityproductdefinitionservice-securitiessecurityproductdefinition-querysecurityproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SKLocationChange",
                            "href":"api-securities-sklocationchange.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSESKLocationChange",
                                    "href":"op-sklocationchangeservice-sklocationchange-authorizesesklocationchange-post.html"
                                },
                                {
                                    "title":"Operation to CreateSESKLocationChange",
                                    "href":"op-sklocationchangeservice-sklocationchange-createsesklocationchange-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSESKLocationChange",
                                    "href":"op-sklocationchangeservice-sklocationchange-deletesesklocationchange-post.html"
                                },
                                {
                                    "title":"Operation to ModifySESKLocationChange",
                                    "href":"op-sklocationchangeservice-sklocationchange-modifysesklocationchange-post.html"
                                },
                                {
                                    "title":"Query by contractrefno",
                                    "href":"op-sklocationchangeservice-sklocationchange-querysesklocationchange-contractrefno-contractrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SKLocations",
                            "href":"api-securities-sklocations.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSESKLocationMaint",
                                    "href":"op-sklocationsservice-sklocations-authorizesesklocationmaint-post.html"
                                },
                                {
                                    "title":"Operation to CreateSESKLocationMaint",
                                    "href":"op-sklocationsservice-sklocations-createsesklocationmaint-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSESKLocationMaint",
                                    "href":"op-sklocationsservice-sklocations-deletesesklocationmaint-post.html"
                                },
                                {
                                    "title":"Operation to ModifySESKLocationMaint",
                                    "href":"op-sklocationsservice-sklocations-modifysesklocationmaint-post.html"
                                },
                                {
                                    "title":"Query by sklocid",
                                    "href":"op-sklocationsservice-sklocations-querysesklocationmaint-sklocid-sklocid-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ValuesParameterBranchMaintenance",
                            "href":"api-securities-valuesparameterbranchmaintenance.html",
                            "topics":[
                                {
                                    "title":"Query by brncd",
                                    "href":"op-valuesparameterbranchmaintenanceservice-valuesparameterbranchmaintenance-querybrnprm-brncd-brncd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Securities Repo",
                    "topics":[
                        {
                            "title":"SecuritiesRepo",
                            "href":"api-securities-repo-securitiesrepo.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-authorizesrdeal-post.html"
                                },
                                {
                                    "title":"Operation to ConfirmSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-confirmsrdeal-post.html"
                                },
                                {
                                    "title":"Operation to CreateSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-createsrdeal-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-deletesrdeal-post.html"
                                },
                                {
                                    "title":"Operation to ModifySRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-modifysrdeal-post.html"
                                },
                                {
                                    "title":"Operation to ReverseSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-reversesrdeal-post.html"
                                },
                                {
                                    "title":"Operation to RolloverSRDeal",
                                    "href":"op-securitiesreposervice-securitiesrepo-rolloversrdeal-post.html"
                                },
                                {
                                    "title":"Query by referenceNo",
                                    "href":"op-securitiesreposervice-securitiesrepo-querysrdeal-referenceno-referenceno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesRepoPayment",
                            "href":"api-securities-repo-securitiesrepopayment.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeSRDealPayment",
                                    "href":"op-securitiesrepopaymentservice-securitiesrepopayment-authorizesrdealpayment-post.html"
                                },
                                {
                                    "title":"Operation to CreateSRDealPayment",
                                    "href":"op-securitiesrepopaymentservice-securitiesrepopayment-createsrdealpayment-post.html"
                                },
                                {
                                    "title":"Operation to DeleteSRDealPayment",
                                    "href":"op-securitiesrepopaymentservice-securitiesrepopayment-deletesrdealpayment-post.html"
                                },
                                {
                                    "title":"Operation to ReverseSRDealPayment",
                                    "href":"op-securitiesrepopaymentservice-securitiesrepopayment-reversesrdealpayment-post.html"
                                },
                                {
                                    "title":"Query by contrefno",
                                    "href":"op-securitiesrepopaymentservice-securitiesrepopayment-querysrdealpayment-contrefno-contrefno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SecuritiesRepoProducts",
                            "href":"api-securities-repo-securitiesrepoproducts.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-authorizerepoproduct-post.html"
                                },
                                {
                                    "title":"Operation to CloseRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-closerepoproduct-post.html"
                                },
                                {
                                    "title":"Operation to CreateRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-createrepoproduct-post.html"
                                },
                                {
                                    "title":"Operation to DeleteRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-deleterepoproduct-post.html"
                                },
                                {
                                    "title":"Operation to ModifyRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-modifyrepoproduct-post.html"
                                },
                                {
                                    "title":"Operation to ReopenRepoProduct",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-reopenrepoproduct-post.html"
                                },
                                {
                                    "title":"Query by prdcd",
                                    "href":"op-securitiesrepoproductsservice-securitiesrepoproducts-queryrepoproduct-prdcd-prdcd-get.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Treasury Core Services",
                    "topics":[
                        {
                            "title":"Dealer",
                            "href":"api-treasury-core-services-dealer.html",
                            "topics":[
                                {
                                    "title":"Operation to Authorizedealr",
                                    "href":"op-dealerservice-dealer-authorizedealr-post.html"
                                },
                                {
                                    "title":"Operation to Closedealr",
                                    "href":"op-dealerservice-dealer-closedealr-post.html"
                                },
                                {
                                    "title":"Operation to Createdealr",
                                    "href":"op-dealerservice-dealer-createdealr-post.html"
                                },
                                {
                                    "title":"Operation to Deletedealr",
                                    "href":"op-dealerservice-dealer-deletedealr-post.html"
                                },
                                {
                                    "title":"Operation to Modifydealr",
                                    "href":"op-dealerservice-dealer-modifydealr-post.html"
                                },
                                {
                                    "title":"Operation to Reopendealr",
                                    "href":"op-dealerservice-dealer-reopendealr-post.html"
                                },
                                {
                                    "title":"Query by dlrid",
                                    "href":"op-dealerservice-dealer-querydealr-dlrid-dlrid-get.html"
                                }
                            ]
                        },
                        {
                            "title":"ForwardExchangeRates",
                            "href":"api-treasury-core-services-forwardexchangerates.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-authorizefwdratemaster-post.html"
                                },
                                {
                                    "title":"Operation to CloseFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-closefwdratemaster-post.html"
                                },
                                {
                                    "title":"Operation to CreateFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-createfwdratemaster-post.html"
                                },
                                {
                                    "title":"Operation to DeleteFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-deletefwdratemaster-post.html"
                                },
                                {
                                    "title":"Operation to ModifyFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-modifyfwdratemaster-post.html"
                                },
                                {
                                    "title":"Operation to ReopenFwdrateMaster",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-reopenfwdratemaster-post.html"
                                },
                                {
                                    "title":"Query by branch & ccy1 & ccy2",
                                    "href":"op-forwardexchangeratesservice-forwardexchangerates-queryfwdratemaster-branch-branch-ccy1-ccy1-ccy2-ccy2-get.html"
                                }
                            ]
                        },
                        {
                            "title":"MISCodeRestrictionMaintenance",
                            "href":"api-treasury-core-services-miscoderestrictionmaintenance.html",
                            "topics":[
                                {
                                    "title":"Query by branchcode & misClass & productCode",
                                    "href":"op-miscoderestrictionmaintenanceservice-miscoderestrictionmaintenance-querymaintenance-branchcode-branchcode-misclass-misclass-productcode-productcode-get.html"
                                }
                            ]
                        },
                        {
                            "title":"OBTRAddressCode",
                            "href":"api-treasury-core-services-obtraddresscode.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-authorizeobtraddresscode-post.html"
                                },
                                {
                                    "title":"Operation to CloseOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-closeobtraddresscode-post.html"
                                },
                                {
                                    "title":"Operation to CreateOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-createobtraddresscode-post.html"
                                },
                                {
                                    "title":"Operation to DeleteOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-deleteobtraddresscode-post.html"
                                },
                                {
                                    "title":"Operation to ModifyOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-modifyobtraddresscode-post.html"
                                },
                                {
                                    "title":"Operation to ReopenOBTRAddressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-reopenobtraddresscode-post.html"
                                },
                                {
                                    "title":"Query by addressCode",
                                    "href":"op-obtraddresscodeservice-obtraddresscode-queryobtraddresscode-addresscode-addresscode-get.html"
                                }
                            ]
                        },
                        {
                            "title":"RoletoHeadMappingClass",
                            "href":"api-treasury-core-services-roletoheadmappingclass.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeCSDTRRHM_ID1",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-authorizecsdtrrhm_id1-post.html"
                                },
                                {
                                    "title":"Operation to CreateCSDTRRHM_ID1",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-createcsdtrrhm_id1-post.html"
                                },
                                {
                                    "title":"Operation to DeleteCSDTRRHM_ID1",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-deletecsdtrrhm_id1-post.html"
                                },
                                {
                                    "title":"Operation to ModifyCSDTRRHM_ID1",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-modifycsdtrrhm_id1-post.html"
                                },
                                {
                                    "title":"Operation to ReopenCSDTRRHM_ID1",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-reopencsdtrrhm_id1-post.html"
                                },
                                {
                                    "title":"Query by mod & clascd",
                                    "href":"op-roletoheadmappingclassservice-roletoheadmappingclass-querycsdtrrhm_id1-mod-mod-clascd-clascd-get.html"
                                }
                            ]
                        },
                        {
                            "title":"SettlementInstructions",
                            "href":"api-treasury-core-services-settlementinstructions.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-authorizeisdtrins-post.html"
                                },
                                {
                                    "title":"Operation to CloseISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-closeisdtrins-post.html"
                                },
                                {
                                    "title":"Operation to CreateISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-createisdtrins-post.html"
                                },
                                {
                                    "title":"Operation to DeleteISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-deleteisdtrins-post.html"
                                },
                                {
                                    "title":"Operation to ModifyISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-modifyisdtrins-post.html"
                                },
                                {
                                    "title":"Operation to ReopenISDTRINS",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-reopenisdtrins-post.html"
                                },
                                {
                                    "title":"Query by counterparty & module1 & productcode & currency & seqno & branch & effDate",
                                    "href":"op-settlementinstructionsservice-settlementinstructions-queryisdtrins-counterparty-counterparty-module1-module1-productcode-productcode-currency-currency-seqno-seqno-branch-branch-effdate-effdate-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TradeMsgBrnParametersMaintenance",
                            "href":"api-treasury-core-services-trademsgbrnparametersmaintenance.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-authorizemsdtrprf-post.html"
                                },
                                {
                                    "title":"Operation to CloseMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-closemsdtrprf-post.html"
                                },
                                {
                                    "title":"Operation to CreateMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-createmsdtrprf-post.html"
                                },
                                {
                                    "title":"Operation to DeleteMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-deletemsdtrprf-post.html"
                                },
                                {
                                    "title":"Operation to ModifyMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-modifymsdtrprf-post.html"
                                },
                                {
                                    "title":"Operation to ReopenMSDTRPRF",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-reopenmsdtrprf-post.html"
                                },
                                {
                                    "title":"Query by brn",
                                    "href":"op-trademsgbrnparametersmaintenanceservice-trademsgbrnparametersmaintenance-querymsdtrprf-brn-brn-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TRBranchDetails",
                            "href":"api-treasury-core-services-trbranchdetails.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-authorizebranch-post.html"
                                },
                                {
                                    "title":"Operation to CloseBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-closebranch-post.html"
                                },
                                {
                                    "title":"Operation to CreateBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-createbranch-post.html"
                                },
                                {
                                    "title":"Operation to DeleteBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-deletebranch-post.html"
                                },
                                {
                                    "title":"Operation to ModifyBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-modifybranch-post.html"
                                },
                                {
                                    "title":"Operation to ReopenBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-reopenbranch-post.html"
                                },
                                {
                                    "title":"Operation to SummaryQueryBranch",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-summaryquerybranch-post.html"
                                },
                                {
                                    "title":"Query by branchCode",
                                    "href":"op-trbranchdetailsservice-trbranchdetails-querybranch-branchcode-branchcode-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TRCustomer",
                            "href":"api-treasury-core-services-trcustomer.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-authorizetrcustomer-post.html"
                                },
                                {
                                    "title":"Operation to CloseTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-closetrcustomer-post.html"
                                },
                                {
                                    "title":"Operation to CreateTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-createtrcustomer-post.html"
                                },
                                {
                                    "title":"Operation to DeleteTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-deletetrcustomer-post.html"
                                },
                                {
                                    "title":"Operation to ModifyTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-modifytrcustomer-post.html"
                                },
                                {
                                    "title":"Operation to ReopenTRCustomer",
                                    "href":"op-trcustomerservice-trcustomer-reopentrcustomer-post.html"
                                },
                                {
                                    "title":"Query by custno",
                                    "href":"op-trcustomerservice-trcustomer-querytrcustomer-custno-custno-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TreasuryCustomerAddress",
                            "href":"api-treasury-core-services-treasurycustomeraddress.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-authorizetrmscustadd-post.html"
                                },
                                {
                                    "title":"Operation to CloseTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-closetrmscustadd-post.html"
                                },
                                {
                                    "title":"Operation to CreateTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-createtrmscustadd-post.html"
                                },
                                {
                                    "title":"Operation to DeleteTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-deletetrmscustadd-post.html"
                                },
                                {
                                    "title":"Operation to ModifyTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-modifytrmscustadd-post.html"
                                },
                                {
                                    "title":"Operation to ReopenTRMSCustAdd",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-reopentrmscustadd-post.html"
                                },
                                {
                                    "title":"Query by customerNo & location & media",
                                    "href":"op-treasurycustomeraddressservice-treasurycustomeraddress-querytrmscustadd-customerno-customerno-location-location-media-media-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TreasurySwiftTagMaintenance",
                            "href":"api-treasury-core-services-treasuryswifttagmaintenance.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-authorizetrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Operation to CloseTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-closetrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Operation to CreateTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-createtrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Operation to DeleteTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-deletetrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Operation to ModifyTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-modifytrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Operation to ReopenTRSwiftTagDesc",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-reopentrswifttagdesc-post.html"
                                },
                                {
                                    "title":"Query by msgType2",
                                    "href":"op-treasuryswifttagmaintenanceservice-treasuryswifttagmaintenance-querytrswifttagdesc-msgtype2-msgtype2-get.html"
                                }
                            ]
                        },
                        {
                            "title":"TREcaNotification",
                            "href":"api-treasury-core-services-trecanotification.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeTREcaNotify",
                                    "href":"op-trecanotificationservice-trecanotification-authorizetrecanotify-post.html"
                                },
                                {
                                    "title":"Operation to CreateTREcaNotify",
                                    "href":"op-trecanotificationservice-trecanotification-createtrecanotify-post.html"
                                },
                                {
                                    "title":"Operation to ModifyTREcaNotify",
                                    "href":"op-trecanotificationservice-trecanotification-modifytrecanotify-post.html"
                                }
                            ]
                        },
                        {
                            "title":"TRPeriodCode",
                            "href":"api-treasury-core-services-trperiodcode.html",
                            "topics":[
                                {
                                    "title":"Query by finCycle",
                                    "href":"op-trperiodcodeservice-trperiodcode-querytrfincycle-fincycle-fincycle-get.html"
                                }
                            ]
                        },
                        {
                            "title":"UdeEventTrigger",
                            "href":"api-treasury-core-services-udeeventtrigger.html",
                            "topics":[
                                {
                                    "title":"Operation to AuthorizeUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-authorizeudetrigger-post.html"
                                },
                                {
                                    "title":"Operation to CloseUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-closeudetrigger-post.html"
                                },
                                {
                                    "title":"Operation to CreateUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-createudetrigger-post.html"
                                },
                                {
                                    "title":"Operation to DeleteUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-deleteudetrigger-post.html"
                                },
                                {
                                    "title":"Operation to ModifyUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-modifyudetrigger-post.html"
                                },
                                {
                                    "title":"Operation to ReopenUdetrigger",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-reopenudetrigger-post.html"
                                },
                                {
                                    "title":"Query by fccref",
                                    "href":"op-udeeventtriggerservice-udeeventtrigger-queryudetrigger-fccref-fccref-get.html"
                                }
                            ]
                        }
                    ]
                }
            ]
        }
    ]
});