define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"audience-1-1-2-1-1-1.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"critical-patches.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Related Resources",
                            "href":"related-resources-1-2-2-1-1-1.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"conventions-1-1-1.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"screenshot-disclaimer.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"acronyms-and-abbreviations-1-1-1-1-1-1.html"
                        },
                        {
                            "title":"Basic Actions",
                            "href":"basic-actions.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"symbols-and-icons.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Overview of Securities Domain",
                    "href":"overview-securities-domain1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Financial market",
                            "href":"financial-market.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">1.1.1 </span> Types of Markets",
                                    "href":"types-markets.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.2 </span> Characteristic Features of the Financial Markets",
                                    "href":"characteristic-features-financial-markets.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.3 </span> Financial Intermediaries",
                                    "href":"financial-intermediaries.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.4 </span> Intermediaries Operating in Financial Markets",
                                    "href":"intermediaries-operating-financial-markets.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.5 </span> Financial Assets (Securities)",
                                    "href":"financial-assets-securities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.6 </span> Equities",
                                    "href":"equities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.7 </span> Preference Shares",
                                    "href":"preference-shares.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.8 </span> Fixed Income Securities",
                                    "href":"fixed-income-securities.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.1 </span> Bonds",
                                            "href":"bonds.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.2 </span> T Bills (Issued on Behalf of the Government)",
                                            "href":"t-bills-issued-behalf-government.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.3 </span> T Notes and T Bonds (Issued on Behalf of the Government)",
                                            "href":"t-notes-and-t-bonds-issued-behalf-government.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.4 </span> Treasury Strips (Issued on Behalf of the Government)",
                                            "href":"treasury-strips-issued-behalf-government.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.5 </span> Certificates of Deposit (CDs)",
                                            "href":"certificates-deposit-cds.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.6 </span> Commercial Paper",
                                            "href":"commercial-paper.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.7 </span> Banker’s Acceptances (BAs)",
                                            "href":"bankers-acceptances-bas.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.8.8 </span> Municipal Bonds And Notes",
                                            "href":"municipal-bonds-and-notes.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.9 </span> Rights and Warrants",
                                    "href":"rights-and-warrants1.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">1.1.9.1 </span> Rights",
                                            "href":"rights.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.9.2 </span> Warrants",
                                            "href":"warrants.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.10 </span> Trading in Equities",
                                    "href":"trading-equities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.11 </span> Trading in Bonds / Fixed Income securities",
                                    "href":"trading-bonds-fixed-income-securities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">1.1.12 </span> Corporate Actions on Securities",
                                    "href":"corporate-actions-securities.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.1 </span> Cash Dividend",
                                            "href":"cash-dividend.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.2 </span> Stock Dividend",
                                            "href":"stock-dividend.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.3 </span> Interest on Fixed Income Securities",
                                            "href":"interest-fixed-income-securities.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.4 </span> Redemption on Fixed Income Securities",
                                            "href":"redemption-fixed-income-securities.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.5 </span> Rights / Warrants",
                                            "href":"rights-warrants.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.6 </span> Stock Splits",
                                            "href":"stock-splits.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">1.1.12.7 </span> Mergers and Spin-offs",
                                            "href":"mergers-and-spin-offs.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Overview of Securities",
                    "href":"introduction26.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Snapshot of the Module",
                            "href":"snapshot-module.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Process at the Portfolio Level - at the Beginning or End of Day",
                            "href":"process-portfolio-level-beginning-or-end-day.html"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Started with the Module",
                            "href":"started-module.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.3.1 </span> Build Classes",
                                    "href":"build-classes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.2 </span> Define Products",
                                    "href":"define-products.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.3 </span> Handle Interest, Charge and Tax Components",
                                    "href":"handle-interest-charge-and-tax-components.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.4 </span> Build a Transaction Tax Scheme",
                                    "href":"build-transaction-tax-scheme.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.5 </span> Build an Issuer Tax Scheme",
                                    "href":"build-issuer-tax-scheme.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.6 </span> Handle Brokerage",
                                    "href":"handle-brokerage.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.7 </span> Track Limits",
                                    "href":"track-limits.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.8 </span> Settle Deals",
                                    "href":"settle-deals.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3.9 </span> Query the System for Details",
                                    "href":"query-system-details.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> General Maintenance",
                    "href":"introduction1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Prerequisites for the Application Login",
                            "href":"requisites-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Define a New Product and Static Data",
                            "href":"define-new-product-and-static-data-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Maintain an Existing Product and Static Data",
                            "href":"maintain-existing-product-and-static-data-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Bank Parameters",
                            "href":"bank-parameters.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.4.1 </span> Maintain Bank Parameters",
                                    "href":"maintain-bank-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4.2 </span> Maintain Deal Product",
                                    "href":"maintain-deal-product.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.4.3 </span> Maintain Nominal Based Yield Computation",
                                    "href":"maintain-nominal-based-yield-computation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Branch Parameters",
                            "href":"branch-parameters-1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.5.1 </span> Define Branch Parameters",
                                    "href":"define-branch-parameters.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.2 </span> Define Floating Rate Codes",
                                    "href":"define-floating-rate-codes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.3 </span> Define Rate Sources",
                                    "href":"define-rate-sources.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.4 </span> Define Rate Types",
                                    "href":"define-rate-types.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.5 </span> Define Float Rates",
                                    "href":"define-float-rates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.6 </span> Rate Fixing Maintenance",
                                    "href":"rate-fixing-maintenance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.7 </span> Interest Class Definition",
                                    "href":"interest-class-definition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.8 </span> Maintain Market Details",
                                    "href":"maintain-market-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.9 </span> Maintain Settlement Parties",
                                    "href":"maintain-settlement-parties.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.10 </span> Cancellation Message",
                                    "href":"cancellation-message.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.11 </span> Rate Reset Confirmation",
                                    "href":"rate-reset-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.12 </span> EIM for Treasury Bills and Security Bonds",
                                    "href":"eim-treasury-bills-and-security-bonds.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.13 </span> Yield Calculation Parameters for T-Bills",
                                    "href":"yield-calculation-parameters-t-bills.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.14 </span> Interest Method for Computing Coupon Interest",
                                    "href":"interest-method-computing-coupon-interest1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.15 </span> Exempt Interest for the Ex Period",
                                    "href":"exempt-interest-ex-period.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.16 </span> Tax Details",
                                    "href":"tax-details.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Price Details Maintenance",
                    "href":"price-details-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Maintain Price Details",
                            "href":"maintain-price-details1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">4.1.1 </span> Price Quotation Method",
                                    "href":"price-quotation-method.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">4.1.2 </span> Price",
                                    "href":"price.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Maintain Market Price Codes",
                    "href":"introduction12.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Maintain Market Price Codes",
                            "href":"maintain-market-price-codes1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Maintain Safe Keeping Locations",
                    "href":"introduction5.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Maintain Safe Keep Location",
                            "href":"maintain-safe-keep-location.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">6.1.1 </span> Exposure Line",
                                    "href":"exposure-line.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.2 </span> Specify SK Location Account",
                                    "href":"specify-sk-location-account.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">6.1.3 </span> Making Query",
                                    "href":"making-query.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> KEST",
                            "href":"kest.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Build Branch and Currency Restriction Classes",
                    "href":"build-branch-and-currency-restriction-classes1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Maintain Restrictions as Classes",
                            "href":"maintain-restrictions-classes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.1.1 </span> Advantage of Defining Restrictions as Classes",
                                    "href":"advantage-defining-restrictions-classes.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Process Branch and Currency Restrictions Class Screen",
                            "href":"process-branch-and-currency-restrictions-class-screen.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Specify the Customer Category Restrictions Class",
                            "href":"specify-customer-category-restrictions-class.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">7.3.1 </span> Process Customer Category Restrictions Class screen",
                                    "href":"process-customer-category-restrictions-class-screen.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Accounting Role to Head Mapping Class",
                    "href":"introduction17.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> General Ledger Types",
                            "href":"general-ledger-types.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Accounting Roles and Heads Class",
                            "href":"accounting-roles-and-heads-class.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.2.1 </span> Advantage of Building Accounting Roles and Heads Classes",
                                    "href":"advantage-building-accounting-roles-and-heads-classes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.2 </span> Maintain an Accounting Roles and Heads Class",
                                    "href":"maintain-accounting-roles-and-heads-class.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">8.2.3 </span> Map Roles to Heads",
                                    "href":"map-roles-heads.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Event Class",
                            "href":"event-class.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">8.3.1 </span> Maintain an Event Accounting Entries and Advices Class",
                                    "href":"maintain-event-accounting-entries-and-advices-class.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Define Security Preference Classes",
                    "href":"introduction6.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Security Product Preference Classes",
                            "href":"security-product-preference-classes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.1.1 </span> Specify Security Product Preference Class",
                                    "href":"specify-security-product-preference-class.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.2 </span> Capture Information Specific to a Security Type",
                                    "href":"capture-information-specific-security-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.3 </span> Indicating Banker’s Acceptance",
                                    "href":"indicating-bankers-acceptance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.4 </span> Indicate Banker’s Acceptance",
                                    "href":"indicate-bankers-acceptance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.5 </span> Capturing Trade-Related Information",
                                    "href":"capturing-trade-related-information.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">9.1.6 </span> Identifying the Holder",
                                    "href":"identifying-holder.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Specify the Material of a Security",
                            "href":"specify-material-security.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Indicate the Collateral Type",
                            "href":"indicate-collateral-type.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> Opting for Automatic Initiation of Corporate Actions",
                            "href":"opting-automatic-initiation-corporate-actions1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.4.1 </span> Indicate the Price Code for Revaluation",
                                    "href":"indicate-price-code-revaluation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Tenor Details",
                            "href":"tenor-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">9.5.1 </span> Capture SWIFT Related Information",
                                    "href":"capture-swift-related-information.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> Define Deal Limits for a Preference Class",
                            "href":"define-deal-limits-preference-class.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Maintain Portfolio Preference Class",
                    "href":"introduction20.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Specify Portfolio Preference Class",
                            "href":"specify-portfolio-preference-class.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Yield Accrual for Deals bought on Par",
                            "href":"yield-accrual-deals-bought-par.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Define a Deal preference Class",
                    "href":"introduction24.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Process Deal Preference Class",
                            "href":"process-deal-preference-class.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Security Restriction Classes",
                    "href":"introduction21.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Advantage of Defining Restrictions as Classes",
                            "href":"advantage-defining-restrictions-classes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Process the Security Restrictions",
                            "href":"process-security-restrictions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Maintain Portfolio Restriction Classes",
                    "href":"introduction19.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Advantage of Defining Restrictions as Classes",
                            "href":"advantage-defining-restrictions-classes1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Process Portfolio Restriction Classes",
                            "href":"process-portfolio-restriction-classes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> Process Securities - Portfolio Safe Keeping Location Balances Summary",
                            "href":"process-securities-portfolio-safe-keeping-location-balances-summary.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.4 </span> Process Securities - Portfolio Safe Keeping Location Movements Summary",
                            "href":"process-securities-portfolio-safe-keeping-location-movements-summary.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Define Attributes of a Securities Product",
                    "href":"introduction13.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Process Security Product",
                            "href":"process-security-product.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">14.1.1 </span> Specify Interest Details Type, Event Details, and Rate Details",
                                    "href":"specify-interest-details-type.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Define Attributes of a Portfolio Product",
                    "href":"introduction22.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> Process Security Portfolio Process Definition",
                            "href":"process-security-portfolio-process-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Process Security Portfolio Instrument Restrictions",
                            "href":"process-security-portfolio-instrument-restrictions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Securities Deal Product",
                    "href":"securities-deal-product.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Process Securities Deal Product",
                            "href":"process-securities-deal-product.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">16.1.1 </span> Specify Accounting Entries for KEST Computation",
                                    "href":"specify-accounting-entries-kest-computation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Process Security Deal Product Restrictions",
                            "href":"process-security-deal-product-restrictions.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Define a Product Combination",
                    "href":"introduction18.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Process a Combination Product",
                            "href":"process-combination-product.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Maintain a Security",
                    "href":"introduction14.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">18.1 </span> Process Security Deals Product Definition",
                            "href":"process-security-deals-product-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.2 </span> Details of a Security",
                            "href":"details-security.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.2.1 </span> Capture Details of a Security",
                                    "href":"entering-and-saving-details-security.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.2 </span> Capture Interest details",
                                    "href":"capture-interest-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.3 </span> Indicate Corporate Action Preference",
                                    "href":"indicate-corporate-action-preference.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.4 </span> Capture Trade-Related Information",
                                    "href":"capture-trade-related-information.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.5 </span> Specify Type of Price Quotation",
                                    "href":"specify-type-price-quotation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.6 </span> Capture Information Specific to the Security Type",
                                    "href":"capture-information-specific-security-type1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.7 </span> Indicate bankers acceptance",
                                    "href":"indicate-bankers-acceptance1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.8 </span> Specify Currency",
                                    "href":"specify-currency.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.9 </span> Specify Relevant dates",
                                    "href":"specify-relevant-dates.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.10 </span> Specify Price Details",
                                    "href":"specify-price-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.11 </span> Specify Interest Details for a Bond",
                                    "href":"specify-interest-details-bond.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.12 </span> Opting for Automatic Initiation of Corporate Actions",
                                    "href":"opting-automatic-initiation-corporate-actions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.13 </span> Indicate a Revaluation Price Code",
                                    "href":"indicate-revaluation-price-code.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.14 </span> Indicate the Collateral Type",
                                    "href":"indicate-collateral-type1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2.15 </span> Specify the Market for Revaluation",
                                    "href":"specify-market-revaluation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18.3 </span> Specify the Yield Calculation Parameters for a Security",
                            "href":"specify-yield-calculation-parameters-security.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.3.1 </span> Process Bonds and T-bill based on the YTM parameters",
                                    "href":"process-bonds-and-t-bill-based-ytm-parameters.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18.4 </span> Interest Method for Computing Coupon Interest",
                            "href":"interest-method-computing-coupon-interest.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.5 </span> Process Security Instruments",
                            "href":"process-security-instruments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.6 </span> Holiday Preference",
                            "href":"holiday-preference1.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.6.1 </span> Holiday Validation Assumptions",
                                    "href":"holiday-validation-assumptions.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18.7 </span> Upload Security Instruments for Amendment",
                            "href":"upload-security-instruments-amendment.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.8 </span> Bulk Upload- Security Instruments & Market Security-Price",
                            "href":"bulk-upload-security-instruments-market-security-price.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.9 </span> Process Securities Deal Contract",
                            "href":"process-securities-deal-contract.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Maintain and Process Corporate Actions",
                    "href":"introduction8.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19.1 </span> Process Corporate Action Event Stages",
                            "href":"process-corporate-action-event-stages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.2 </span> Rights and Warrants",
                            "href":"rights-and-warrants.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.2.1 </span> Process Rights and Warrants",
                                    "href":"process-rights-and-warrants1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.2 </span> Indicate Rights Ratio and Rounding Fractions",
                                    "href":"indicating-rights-ratio-and-rounding-fractions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.3 </span> Save Rights/Warrants Record",
                                    "href":"rights-warrants-record.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.4 </span> Process Rights and Warrants",
                                    "href":"process-rights-and-warrants.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.5 </span> Process Rights",
                                    "href":"process-rights.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">19.2.5.1 </span> Rights Tear-Off",
                                            "href":"rights-tear.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.5.2 </span> Rights Exercise",
                                            "href":"rights-exercise.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.5.3 </span> Warrants Tear Off",
                                            "href":"warrants-tear.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.5.4 </span> Warrants Exercise",
                                            "href":"warrants-exercise.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.6 </span> Process Rights and Warrants Expiry Details",
                                    "href":"process-rights-and-warrants-expiry-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.7 </span> Process Security Redemption Details",
                                    "href":"process-security-redemption-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2.8 </span> Security Redemption",
                                    "href":"security-redemptions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">19.2.8.1 </span> Process for Security Redemptions",
                                            "href":"process-security-redemptions.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.8.2 </span> Redemption Processing based on Quotation Type",
                                            "href":"redemption-processing-based-quotation-type.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.8.3 </span> End of Trading Processing",
                                            "href":"end-trading-processing.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.2.8.4 </span> Process of Amendment on Redemption Schedules",
                                            "href":"process-amendment-redemption-schedules.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.3 </span> Interest Coupon Details",
                            "href":"interest-coupon-details.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.3.1 </span> Process Interest Coupon Details",
                                    "href":"process-interest-coupon-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.3.2 </span> Link Interest Component to Tax Component",
                                    "href":"link-interest-component-tax-component.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.3.3 </span> Specify Event Narrative",
                                    "href":"specify-event-narrative.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.4 </span> Process Interest Coupon",
                            "href":"process-interest-coupon.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.4.1 </span> Process Interest Rate Revision Details",
                                    "href":"process-interest-rate-revision-details.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">19.4.1.1 </span> Specify Event Narrative",
                                            "href":"specify-event-narrative1.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.4.1.2 </span> Holiday Preference",
                                            "href":"holiday-preference.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">19.4.1.3 </span> History",
                                            "href":"history.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.5 </span> Backdated/Current dated Rate Revision Processing",
                            "href":"backdated-current-dated-rate-revision-processing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.6 </span> Auto Processing of Rate Fixing",
                            "href":"auto-processing-rate-fixing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.7 </span> Maintain Stock Dividend Details",
                            "href":"maintain-stock-dividend-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.8 </span> Process Cash Dividend",
                            "href":"process-cash-dividend.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.9 </span> Process Dividends",
                            "href":"process-dividends.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.9.1 </span> Process Bonus to Cash Conversion Details",
                                    "href":"process-bonus-cash-conversion-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.10 </span> Process Bonus to Cash Conversions",
                            "href":"process-bonus-cash-conversions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.10.1 </span> Process Corporate Action Events",
                                    "href":"process-corporate-action-events.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19.11 </span> Coupon Transfer",
                            "href":"coupon-transfer.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> Define Portfolio",
                    "href":"introduction4.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">20.1 </span> Process Portfolio Definition Details",
                            "href":"process-portfolio-definition-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.2 </span> Process Details of a Portfolio",
                            "href":"process-details-portfolio.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.3 </span> Define Preference for a Portfolio",
                            "href":"define-preference-portfolio.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.4 </span> Specify Advice to be Generated",
                            "href":"specify-advice-be-generated.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.5 </span> Map Accounts to a Safe Keeping Location",
                            "href":"map-accounts-safe-keeping-location.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.6 </span> Specify Accounting Role to Head Mapping Preferences",
                            "href":"specify-accounting-role-head-mapping-preferences.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.7 </span> Process Security Revaluation Prices for a Portfolio",
                            "href":"process-security-revaluation-prices-portfolio.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.8 </span> Process Risk Profile",
                            "href":"process-risk-profile.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.9 </span> View Safe keeping Location Portfolio Balances",
                            "href":"view-safe-keeping-location-portfolio-balances.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">21 </span> Process Security Deal",
                    "href":"introduction3.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">21.1 </span> Securities Deal Input Screen",
                            "href":"securities-deal-input-screen.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">21.1.1 </span> Process Securities Data Input Screen",
                                    "href":"process-securities-data-input-screen.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">21.1.1.1 </span> Process Securities Deals",
                                            "href":"process-securities-deals.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">21.1.1.1.1 </span> Specify details for the buy and sell leg of a deal",
                                                    "href":"specify-details-buy-and-sell-leg-deal.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">21.1.1.1.2 </span> Specify Details of Sell Leg",
                                                    "href":"specify-details-sell-leg.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">21.1.1.1.3 </span> Specify Details of the Buy Leg of a Deal",
                                                    "href":"specify-details-buy-leg-deal.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">21.1.1.1.4 </span> Trading in securities that do not belong to a portfolio",
                                                    "href":"trading-securities-that-do-not-belong-portfolio.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.1.2 </span> Additional Details",
                                            "href":"additional-details-tab.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.1.3 </span> Process Safe Keeping Location Balances",
                                            "href":"process-safe-keeping-location-balances.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.2 </span> Deal Net Consideration",
                                    "href":"deal-net-consideration.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.3 </span> View the forward profit or Loss in a Deal",
                                    "href":"view-forward-profit-or-loss-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.4 </span> Specify Details of Parties Involved in Block Security",
                                    "href":"specify-details-parties-involved-block-security.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.5 </span> Settlement Instructions for a Deal Leg",
                                    "href":"settlement-instructions-deal-leg.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">21.1.5.1 </span> Maintain Settlement Instructions for a Deal Leg",
                                            "href":"maintain-settlement-instructions-deal-leg.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.5.2 </span> Capture Settlement Instructions",
                                            "href":"capture-settlement-instructions.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.5.3 </span> Capture Account Details",
                                            "href":"capture-account-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.5.4 </span> Capture Details of the Deal Output",
                                            "href":"capture-details-deal-output.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.5.5 </span> Capture Party Details",
                                            "href":"capture-party-details.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.6 </span> Process Levy Tax on a Deal",
                                    "href":"process-levy-tax-deal.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">21.1.6.1 </span> Features of Tax Details Screen",
                                            "href":"features-tax-details-screen.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.7 </span> Process Brokerage on a Deal",
                                    "href":"process-brokerage-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.8 </span> Upload the Deals for Amendment",
                                    "href":"upload-deals-amendment.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.9 </span> Liquidating a Deal",
                                    "href":"liquidating-deal.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">21.1.9.1 </span> Money Settlement",
                                            "href":"money-settlement.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.9.2 </span> Security Settlement",
                                            "href":"security-settlement.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">21.1.10 </span> SGEN Message Generation",
                                    "href":"sgen-messages-generation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">21.1.10.1 </span> RFR Enabling for SGEN",
                                            "href":"rfr-enabling-sgen.html",
                                            "topics":[
                                                {
                                                    "title":"<span class=\"secnum\">21.1.10.1.1 </span> Look back without Payment delay SGEN Generation",
                                                    "href":"look-back-payment-delay-sgen-generation.html"
                                                },
                                                {
                                                    "title":"<span class=\"secnum\">21.1.10.1.2 </span> Look back/Lockout with Payment delay SGEN Generation",
                                                    "href":"look-back-lockout-payment-delay-sgen-generation.html"
                                                }
                                            ]
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.10.2 </span> Reassigning a Deal to another User",
                                            "href":"reassigning-deal-another-user.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">21.1.10.3 </span> Contract Level Message Generation",
                                            "href":"contract-level-message-generation.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">22 </span> Process A Block Securities Deal",
                    "href":"introduction7.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">22.1 </span> Features of a Block Deal in Oracle Banking Treasury Management",
                            "href":"features-block-deal-oracle-banking-treasury-management.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.2 </span> Process Block Securities Deal Screen",
                            "href":"process-block-securities-deal-screen.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">23 </span> Securities Transfer Across Locations",
                    "href":"securities-transfer-locations1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">23.1 </span> Transfer Securities Across Locations",
                            "href":"transfer-securities-locations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">23.2 </span> Specify the SK locations and accounts",
                            "href":"specify-sk-locations-and-accounts.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">24 </span> Maintain Block Security Details",
                    "href":"introduction25.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">24.1 </span> Process Securities Block/Release Block Input",
                            "href":"process-securities-block-release-block-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">24.2 </span> Specify Details of Parties Involved in Block Security",
                            "href":"specify-details-parties-involved-block-security.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">25 </span> Maintain Manual Revaluation Details",
                    "href":"introduction10.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">25.1 </span> Process Manual Revaluation",
                            "href":"process-manual-revaluation.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">25.1.1 </span> Manual Revaluation Processing",
                                    "href":"manual-revaluation-processing.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">25.2 </span> View Manual Revaluations",
                            "href":"view-manual-revaluations.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">26 </span> Bonds Provisioning",
                    "href":"introduction9.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">26.1 </span> Securities Security Product Definition",
                            "href":"securities-security-product-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.2 </span> Securities Manual Provision",
                            "href":"securities-manual-provision.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.3 </span> Securities Provisioning Summary",
                            "href":"securities-provisioning-summary.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.4 </span> Securities Instrument Definition",
                            "href":"securities-instrument-definition-others.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">27 </span> Bonds Status Change",
                    "href":"introduction23.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">27.1 </span> Securities Security Product Definition",
                            "href":"securities-security-product-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.2 </span> Securities Instrument Definition",
                            "href":"securities-instrument-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.3 </span> Securities Status Properties",
                            "href":"securities-status-properties.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.4 </span> Securities Status Properties Summary",
                            "href":"securities-status-properties-summary.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.5 </span> Securities Manual Status Change",
                            "href":"securities-manual-status-change.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.6 </span> Securities Status Change Summary",
                            "href":"securities-status-change-summary.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">28 </span> Batch Process",
                    "href":"introduction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">28.1 </span> Beginning of Day Processing",
                            "href":"beginning-day-processing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">28.2 </span> Process Daily Events",
                            "href":"process-daily-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">28.3 </span> Process Triggering Securities MSTL Batch",
                            "href":"process-triggering-securities-mstl-batch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">28.4 </span> Unrealized Revaluation for Unsettled Buy and Sell Deals",
                            "href":"unrealized-revaluation-unsettled-buy-and-sell-deals.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">28.4.1 </span> Illustrations",
                                    "href":"illustrations.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">28.5 </span> Unsettled EX Sell Deal – Revaluation Date after Deal Settlement Date",
                            "href":"unsettled-ex-sell-deal-revaluation-date-deal-settlement-date.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">29 </span> Credit Default Index",
                    "href":"introduction11.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">29.1 </span> Market Definition",
                            "href":"market-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.2 </span> CD credit event maintenance",
                            "href":"cd-credit-event-maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.3 </span> Credit Derivative Instrument Product Definition",
                            "href":"credit-derivative-instrument-product-definition.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.3.1 </span> Security Preferences",
                                    "href":"security-preferences.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">29.3.1.1 </span> Premium Details",
                                            "href":"premium-details.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">29.3.1.2 </span> Reference",
                                            "href":"reference.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">29.3.1.3 </span> MIS",
                                            "href":"mis2.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.2 </span> Credit Derivative Instrument Definition",
                                    "href":"credit-derivative-instrument-definition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.3 </span> Coupon",
                                    "href":"coupon.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.4 </span> Revision",
                                    "href":"revision.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.5 </span> Redemption Schedule",
                                    "href":"redemption-schedule.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.6 </span> Contract Premium Details",
                                    "href":"contract-premium-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.7 </span> Tax",
                                    "href":"tax.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.8 </span> MIS",
                                    "href":"mis1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.3.9 </span> Fields",
                                    "href":"fields.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29.4 </span> Credit Derivative Deal Product Definition",
                            "href":"credit-derivative-deal-product-definition.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.4.1 </span> Accounting Roles",
                                    "href":"accounting-roles1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.2 </span> Events",
                                    "href":"events.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.3 </span> Preferences",
                                    "href":"preferences.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.4 </span> Charges",
                                    "href":"charges.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.5 </span> Tax Definition",
                                    "href":"tax-definition.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.6 </span> MIS",
                                    "href":"mis.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.7 </span> Market Details",
                                    "href":"market-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.4.8 </span> Display Credit Derivative Deal Details",
                                    "href":"display-credit-derivative-deal-details.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29.5 </span> Credit Derivative Processing Branch Parameter",
                            "href":"credit-derivative-processing-branch-parameter.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.6 </span> Credit Derivative Portfolio Product Definition",
                            "href":"credit-derivative-portfolio-product-definition.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.6.1 </span> Accounting Role",
                                    "href":"accounting-role.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.6.2 </span> Events",
                                    "href":"events1.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">29.6.3 </span> Preferences",
                                    "href":"preferences1.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29.7 </span> CD Portfolio Definition",
                            "href":"cd-portfolio-definition.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.8 </span> CD External Revaluation Changes",
                            "href":"cd-external-revaluation-changes.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.8.1 </span> External MTM Example",
                                    "href":"external-mtm-example.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29.9 </span> CDI Derivative Deal Input",
                            "href":"cdi-derivative-deal-input.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">29.9.1 </span> Contract Level Message Generation",
                                    "href":"contract-level-message-generation.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">29.10 </span> Credit Derivative Corporate Action",
                            "href":"credit-derivative-corporate-action.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.11 </span> CDI Redemption Product Maintenance",
                            "href":"cdi-redemption-product-maintenance.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">30 </span> Risk Free Rates for Securities",
                    "href":"introduction16.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">30.1 </span> Define Rate codes for Risk Free Rates",
                            "href":"define-rate-codes-risk-free-rates.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.2 </span> Risk Free Rates",
                            "href":"risk-free-rates.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.3 </span> Treasury Interest Maintenance",
                            "href":"treasury-interest-maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.4 </span> Securities Instrument Product",
                            "href":"securities-instrument-product.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.5 </span> Interest Revision",
                            "href":"interest-revision.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.6 </span> Lifecycle process Impact",
                            "href":"lifecycle-process-impact.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">31 </span> Customer Correspondence",
                    "href":"introduction2.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">31.1 </span> Deal Related Advices",
                            "href":"deal-related-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">31.1.1 </span> Corporate Action Related Advices",
                                    "href":"corporate-action-related-advices.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.1.2 </span> Statement Related Advices",
                                    "href":"statement-related-advices.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">31.2 </span> Sample of all Advices",
                            "href":"sample-all-advices.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">31.2.1 </span> Security Trade Confirmation Affirmation message",
                                    "href":"security-trade-confirmation-affirmation-message.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.2 </span> Securities market Side Trade Confirmation",
                                    "href":"securities-market-side-trade-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.3 </span> Securities Receive Free Instruction",
                                    "href":"securities-receive-free-instruction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.4 </span> Securities Receive Against Payment Instruction",
                                    "href":"securities-receive-payment-instruction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.5 </span> Securities Deliver Free Instruction",
                                    "href":"securities-deliver-free-instruction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.6 </span> Securities Deliver Against Payment Instruction",
                                    "href":"securities-deliver-payment-instruction.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.7 </span> Securities Receipt Free Confirmation",
                                    "href":"securities-receipt-free-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.8 </span> Securities Receipt Against Payment Confirmation",
                                    "href":"securities-receipt-payment-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.9 </span> Securities Deliver Free Confirmation",
                                    "href":"securities-deliver-free-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.10 </span> Securities Delivery Against Payment Confirmation",
                                    "href":"securities-delivery-payment-confirmation.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">31.2.10.1 </span> Securities Notice of Rights Message",
                                            "href":"securities-notice-rights-message.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">31.2.10.2 </span> Securities Notice of Event Message",
                                            "href":"securities-notice-event-message.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.11 </span> Securities Advice of Money Income",
                                    "href":"securities-advice-money-income.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.12 </span> Securities Advice of Income in the Form of Securities",
                                    "href":"securities-advice-income-form-securities.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.13 </span> Securities Advice of Redemption",
                                    "href":"securities-advice-redemption.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.14 </span> Securities Request for Statement Message",
                                    "href":"securities-request-statement-message.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.15 </span> Securities Statement of Holdings",
                                    "href":"securities-statement-holdings.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2.16 </span> Securities Statement of Transactions",
                                    "href":"securities-statement-transactions.html",
                                    "topics":[
                                        {
                                            "title":"<span class=\"secnum\">31.2.16.1 </span> Securities Statement of Pending Transactions",
                                            "href":"securities-statement-pending-transactions.html"
                                        },
                                        {
                                            "title":"<span class=\"secnum\">31.2.16.2 </span> Other Information",
                                            "href":"other-information.html"
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">32 </span> Making Queries",
                    "href":"introduction15.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">32.1 </span> Details of Securities Safe Keeping Movements",
                            "href":"details-securities-safe-keeping-movements.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">32.1.1 </span> Process Securities Safe keeping Movements",
                                    "href":"process-securities-safe-keeping-movements.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.1.2 </span> The Other Query Screens",
                                    "href":"other-query-screens.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">32.1.3 </span> Ordering",
                                    "href":"ordering.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">32.2 </span> Process Portfolio Security Movements",
                            "href":"process-portfolio-security-movements.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Error Codes and Message for Securities",
                    "href":"error-codes-and-message-securities1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A.1 </span> Error Codes and Messages",
                            "href":"error-codes-and-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.2 </span> Error Codes and Messages for Securities Online",
                            "href":"error-codes-and-messages-securities-online.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.3 </span> Error Codes and Messages for Batches",
                            "href":"error-codes-and-messages-batches.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.4 </span> Error Codes and Messages for Deal Input",
                            "href":"error-codes-and-messages-deal-input.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.5 </span> Error Codes and Messages for Non-Securities",
                            "href":"error-codes-and-messages-non-securities.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.6 </span> Error Codes and Messages for Portfolio Online",
                            "href":"error-codes-and-messages-portfolio-online.html"
                        },
                        {
                            "title":"<span class=\"secnum\">A.7 </span> Error Codes and Messages for Others",
                            "href":"error-codes-and-messages-others.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Accounting Entries",
                    "href":"accounting-entries1.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">B.1 </span> Security Events",
                            "href":"security-events.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.2 </span> Amount Tags",
                            "href":"amount-tags.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.3 </span> Accounting Roles",
                            "href":"accounting-roles.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">B.3.1 </span> AMND: Amendment of Securities Deal",
                                    "href":"amnd-amendment-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.2 </span> CANC: Cancellation of Securities Deal",
                                    "href":"canc-cancellation-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.3 </span> CCON: Counter party Confirmation",
                                    "href":"ccon-counter-party-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.4 </span> DACF: Deliver Versus Payment Confirmation",
                                    "href":"dacf-deliver-payment-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.5 </span> DFCF: Deliver Free Confirmation",
                                    "href":"dfcf-deliver-free-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.6 </span> DSTL: Settlement of Securities Deal",
                                    "href":"dstl-settlement-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.7 </span> EXTN: Extension of Deal Settlement Date",
                                    "href":"extn-extension-deal-settlement-date.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.8 </span> MSTL: Money Settlement of Securities Deal",
                                    "href":"mstl-money-settlement-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.9 </span> RACF: Receive Versus Payment Confirmation",
                                    "href":"racf-receive-payment-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.10 </span> RBLK: Release Block of Security Positions",
                                    "href":"rblk-release-block-security-positions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.11 </span> RIBL: Reversal of Block of Security Positions",
                                    "href":"ribl-reversal-block-security-positions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.12 </span> RRBL: Reversal of Release Block of Security Positions",
                                    "href":"rrbl-reversal-release-block-security-positions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.13 </span> REAS: Reassignment of Securities Deal",
                                    "href":"reas-reassignment-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.14 </span> REVR: Reversal of Securities Deal",
                                    "href":"revr-reversal-securities-deal.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.15 </span> RFCF: Receive Free Confirmation",
                                    "href":"rfcf-receive-free-confirmation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.16 </span> MSTL: Money Settlement",
                                    "href":"mstl.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.17 </span> PROV: Provisioning",
                                    "href":"prov.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">B.3.18 </span> STCH: Status Change",
                                    "href":"stch.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">B.4 </span> CD Portfolio Processing",
                            "href":"cd-portfolio-processing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.5 </span> SGEN - Settlement Message Generation",
                            "href":"sgen-settlement-message-generation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.6 </span> Multi Media Support",
                            "href":"multi-media-support.html"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});