##############################################################################################
# OKE Advanced Terraform Module: VCN Outputs                                                 #
#                                                                                            #
# File: ~/oke_advanced_module/modules/vcn/outputs.tf                                         #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# This file defines and exports output values for key VCN and subnet resources.              #
# Outputs include OCIDs for VCN, API endpoint subnet, worker/pods subnets, load balancer     #
# subnet, and bastion public subnet for use in downstream modules.                           #
#                                                                                            #
##############################################################################################


#********************************************************************************************#
# Output: vcn_id                                                                             #
# Returns the OCID of the VCN                                                                #
#********************************************************************************************#

output "vcn_id" {
  description = "The OCID of the VCN."
  value       = oci_core_vcn.this.id
}


#********************************************************************************************#
# Output: vcn_name                                                                           #
# Returns the display name of the VCN                                                        #
#********************************************************************************************#

output "vcn_name" {
  description = "The Display Name of the VCN."
  value       = oci_core_vcn.this.display_name
}


#********************************************************************************************#
# Output: k8apiendpoint_private_subnet_id                                                    #
# Returns the OCID of the Kubernetes API Endpoint private subnet                             #
#********************************************************************************************#

output "k8apiendpoint_private_subnet_id" {
  description = "The OCID of the Kubernetes API Endpoint private subnet."
  value       = oci_core_subnet.Private-Subnet-For-K8-API-Endpoint.id
}


#********************************************************************************************#
# Output: workernodes_private_subnet_id                                                      #
# Returns the OCID of the worker nodes private subnet                                        #
#********************************************************************************************#

output "workernodes_private_subnet_id" {
  description = "The OCID of the worker nodes private subnet."
  value       = oci_core_subnet.Private-Subnet-For-Worker-Nodes.id
}


#********************************************************************************************#
# Output: nodepods_private_subnet_id                                                         #
# Returns the OCID of the pods private subnet                                                #
#********************************************************************************************#

output "nodepods_private_subnet_id" {
  description = "The OCID of the worker nodes private subnet."
  value       = oci_core_subnet.Private-Subnet-For-Pods.id
}


#********************************************************************************************#
# Output: serviceloadbalancers_public_subnet_id                                              #
# Returns the OCID of the public load balancers subnet                                       #
#********************************************************************************************#

output "serviceloadbalancers_public_subnet_id" {
  description = "The OCID of the public load balancers subnet."
  value       = oci_core_subnet.Public-Subnet-For-Load-Balancers.id
}


#********************************************************************************************#
# Output: bastion_public_subnet_id                                                           #
# Returns the OCID of the bastion public subnet                                              #
#********************************************************************************************#

output "bastion_public_subnet_id" {
  description = "The OCID of the bastion public subnet."
  value       = oci_core_subnet.Public-Subnet-For-Bastion-Host.id
}


##############################################################################################
# Note: The use of NSG is out of the scope of this release.                                  #
##############################################################################################