# mind there is a variables.pkr.hcl file where
# other vars are set 
# so when build use: packer build <directory name>
# so all the files whitin dir will be loaded


source "oracle-oci" "img1" {
  #auth vars
  region        = var.REGION
  tenancy_ocid  = var.TENANCY_OCID
  user_ocid     = var.USER_OCID
  key_file      = var.KEY_FILE
  fingerprint   = var.FINGERPRINT
  #
  availability_domain = var.AD
  base_image_ocid     = var.BASE_IMG_OCID
  compartment_ocid    = var.COMP_IMG_OCID
  image_name          = var.IMG_NAME
  shape               = var.SHAPE
  shape_config {
  ocpus               = var.SHAPE_OCPUS
  }
  ssh_username        = "opc"
  subnet_ocid         = var.SUBNET_OCID
  # for testing and debug. remove it after 
  skip_create_image   = true
}

source "oracle-oci" "img2" {
  #auth vars
  region        = var.REGION
  tenancy_ocid  = var.TENANCY_OCID
  user_ocid     = var.USER_OCID
  key_file      = var.KEY_FILE
  fingerprint   = var.FINGERPRINT
  #
  availability_domain = var.AD
  base_image_ocid     = var.BASE_IMG_OCID
  compartment_ocid    = var.COMP_IMG_OCID
  image_name          = var.IMG_NAME1
  shape               = var.SHAPE
  shape_config {
  ocpus               = var.SHAPE_OCPUS
  }
  ssh_username        = "opc"
  subnet_ocid         = var.SUBNET_OCID
  # for testing and debug. remove it after 
  skip_create_image   = true
}

build {
  sources = [
    "source.oracle-oci.img1",
    "source.oracle-oci.img2"
  ]
  
  #need ansible installed on VM that packer will build
  #so you need to install ansible beforehand

  provisioner "shell" {
    # this will run on all sources
    inline = [
      "sudo yum install ansible -y"
    ]
  }
  
  # this provisioner ansible-local needs ansible installed 
  # on the host that packer will builds

  provisioner "ansible-local" {
    playbook_file   = "${path.root}/ansible/pb1.yaml"
  }
  
  # This provisioner ansible 
  # will run ansible playbook from host that runs packer
  # so you don't need to inmstall ansible on VM that packer wil create

  #provisioner "ansible" {
  #  playbook_file   = "${path.root}/ansible/pb-remote.yaml"
  #  user = "opc"
  #  # in case you need to debug ansible tasks
  #  extra_arguments = [ "-vvvv" ]
  #}  
}
