##############################################################################################
# OKE Advanced Terraform Module: OKE Cluster Outputs                                         #
#                                                                                            #
# File: ~/oke_advanced_module/modules/oke/outputs.tf                                         #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# This file defines the output values for OKE cluster and node pools,                        #
# exposing cluster OCID, cluster name, node pool OCIDs, and node pool image IDs.             #
#                                                                                            #
##############################################################################################



#********************************************************************************************#
# Output: cluster_id                                                                         #
# Returns the OCID of the provisioned OKE cluster                                            #
#********************************************************************************************#

output "cluster_id" {
  description = "The OCID of the OKE cluster."
  value       = oci_containerengine_cluster.this.id
}


#********************************************************************************************#
# Output: cluster_name                                                                       #
# Returns the display name of the provisioned OKE cluster                                    #
#********************************************************************************************#

output "cluster_name" {
  description = "The display name of the OKE cluster."
  value       = oci_containerengine_cluster.this.name
}



#********************************************************************************************#
# Output: node_pool_ids                                                                      #
# Returns a map of node pool names to their OCIDs                                            #
#********************************************************************************************#

output "node_pool_ids" {
  description = "A map of node pool names to their OCIDs."
  value       = { for name, pool in oci_containerengine_node_pool.this : name => pool.id }
}


#********************************************************************************************#
# Output: node_pool_images                                                                   #
# Returns a map of node pool names to their image OCIDs (dynamically generated)              #
#********************************************************************************************#

output "node_pool_images" {
  description = "Node pool images dynamically genenrated."
  value       = { for name, pool in oci_containerengine_node_pool.this : name => pool.node_source_details[0].image_id }
}