
##############################################################################################
# OKE Advanced Terraform Module: VCN Variables                                               #
#                                                                                            #
# File: ~/oke_advanced_module/modules/vcn/variables.tf                                       #
#                                                                                            #
# Authors: Mahamat H. Guiagoussou, Payal Sharma, and Matthew McDaniel                        #
#                                                                                            #
# Copyright (c) 2025 Oracle                                                                  #
#                                                                                            #
#--------------------------------------------------------------------------------------------#
#                                                                                            #
# This file defines input variables used for VCN and subnet provisioning. Each variable      #
# enables flexible configuration of the VCN, subnets, and related settings.                  #
#                                                                                            #
##############################################################################################




#********************************************************************************************#
# Variable: compartment_id                                                                   #
# The OCID of the compartment where the VCN will be created                                  #
#********************************************************************************************#

variable "compartment_id" {
  description = "The OCID of the compartment where the VCN will be created."
  type        = string
}


#********************************************************************************************#
# Variable: vcn_cidr_block                                                                   #
# The CIDR block for the VCN                                                                 #
#********************************************************************************************#

variable "vcn_cidr_block" {
  description = "The CIDR block for the VCN."
  type        = string
}


#********************************************************************************************#
# Variable: display_name_prefix                                                              #
# A prefix for all resource display names                                                    #
#********************************************************************************************#

variable "display_name_prefix" {
  description = "A prefix for all resource display names."
  type        = string
}


#********************************************************************************************#
# Variable: host_name_prefix                                                                 #
# A prefix for the hostnames                                                                 #
#********************************************************************************************#

variable "host_name_prefix" {
  description = "A prefix for the hostnames."
  type        = string
}


#********************************************************************************************#
# Variable: k8apiendpoint_private_subnet_cidr_block                                          #
# The CIDR block for the Kubernetes API Endpoint private subnet                              #
#********************************************************************************************#

variable "k8apiendpoint_private_subnet_cidr_block" {
  description = "The CIDR block for the Kubernetes API Endpoint private subnet."
  type        = string
}


#********************************************************************************************#
# Variable: workernodes_private_subnet_cidr_block                                            #
# The CIDR block for the worker nodes private subnet                                         #
#********************************************************************************************#

variable "workernodes_private_subnet_cidr_block" {
  description = "The CIDR block for the worker nodes private subnet."
  type        = string
}


#********************************************************************************************#
# Variable: pods_private_subnet_cidr_block                                                   #
# The CIDR block for the Node Pods private subnet                                            #
#********************************************************************************************#

variable "pods_private_subnet_cidr_block" { 
  description = "The CIDR block for the Node Pods private subnet."
  type        = string
}


#********************************************************************************************#
# Variable: serviceloadbalancers_public_subnet_cidr_block                                    #
# The CIDR block for the public load balancers subnet                                        #
#********************************************************************************************#

variable "serviceloadbalancers_public_subnet_cidr_block" {
  description = "The CIDR block for the public load balancers subnet."
  type        = string
}


#********************************************************************************************#
# Variable: bastion_public_subnet_cidr_block                                                 #
# The CIDR block for the bastion regional public subnet                                      #
#********************************************************************************************#

variable "bastion_public_subnet_cidr_block" {
  description = "The CIDR block for the bastion regional public subnet."
  type        = string
}


#********************************************************************************************#
# Variable: use_nsg                                                                          #
# Flag to enable NSGs instead of SLs                                                         #
#********************************************************************************************#

variable "use_nsg" {
  description = "Flag to enable NSGs instead of SLs."
  type        = bool
}
